package com.ibatis.jpetstore.presentation.action;

import java.math.BigDecimal;

import com.ibatis.jpetstore.domain.*;
import com.ibatis.jpetstore.presentation.form.*;
import org.apache.struts.action.*;

import javax.servlet.http.*;

public class NewAccountFormAction extends BaseAction {

	/* Public Methods */

	public ActionForward doPerform(
		ActionMapping mapping,
		ActionForm form,
		HttpServletRequest request,
		HttpServletResponse response)
		throws Exception {

		AccountForm workingAcctForm = new AccountForm();

		if (workingAcctForm.getAccount() == null) {
			Account account = new Account();
			account.setMileage(new BigDecimal(0));
			workingAcctForm.setAccount(account);

		}

		if (workingAcctForm.getCategories() == null) {
			workingAcctForm.setCategories(petStore.getCategoryList());
		}

		request.getSession().removeAttribute("workingAccountForm");
		request.getSession().setAttribute(
			"workingAccountForm",
			workingAcctForm);

		return mapping.findForward("success");
	}
}
