/**
 * User: Clinton Begin
 * Date: Apr 1, 2003
 * Time: 9:03:33 PM
 */
package com.ibatis.jpetstore.presentation.action;

import org.apache.struts.action.*;

import javax.servlet.http.*;
import javax.servlet.*;
import java.io.*;

import com.ibatis.jpetstore.presentation.form.*;

public abstract class SecureBaseAction extends BaseAction {


  public ActionForward perform(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {

    AccountForm acctForm = (AccountForm) request.getSession().getAttribute("accountForm");

    if (acctForm == null || acctForm.getAccount() == null) {
      String url = request.getRequestURI();
      String query = request.getQueryString();
      if (query != null) {
        request.setAttribute("signonForwardAction", url+"?"+query);
      } else {
        request.setAttribute("signonForwardAction", url);
      }
      return mapping.findForward("global-signon");
    } else {
      return super.perform(mapping, form, request, response);
    }
  }


}
