package com.ibatis.jpetstore.presentation.action;

import com.ibatis.jpetstore.presentation.form.*;
import org.apache.struts.action.*;

import javax.servlet.http.*;

public class ViewCartAction extends BaseAction {

	/* Public Methods */

	public ActionForward doPerform(
		ActionMapping mapping,
		ActionForm form,
		HttpServletRequest request,
		HttpServletResponse response)
		throws Exception {

		CartForm cartForm = (CartForm) form;
		AccountForm acctForm =
			(AccountForm) request.getSession().getAttribute("accountForm");

		String page = request.getParameter("page");

		if (acctForm != null && acctForm.getAccount() != null) {
			if ("next".equals(page)) {
				acctForm.getMyList().nextPage();
			} else if ("previous".equals(page)) {
				acctForm.getMyList().previousPage();
			}
		}

		if ("nextCart".equals(page)) {
			cartForm.getCart().getCartItemList().nextPage();
		} else if ("previousCart".equals(page)) {
			cartForm.getCart().getCartItemList().previousPage();
		}

		return mapping.findForward("success");
	}

}
