package com.ibatis.jpetstore.presentation.action;

import com.ibatis.jpetstore.domain.*;
import com.ibatis.jpetstore.presentation.form.*;
import com.ibatis.jpetstore.service.*;
import org.apache.struts.action.*;

import javax.servlet.http.*;

public class ViewOrderAction extends SecureBaseAction {

  /* Public Methods */

  public ActionForward doPerform(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

    AccountForm acctForm = (AccountForm) form;

    int orderId = Integer.parseInt(request.getParameter("orderId"));

    Order order = null;

    if ("true".equals(request.getParameter("webservice"))) {
      order = new PetStoreClient().getOrder(orderId);
      order.setStatus(order.getStatus() + " (Using Web Service)");
    } else {
      order = petStore.getOrder(orderId);
    }

    if (acctForm.getAccount().getUsername().equals(order.getUsername())) {
      request.setAttribute("order", order);
      request.setAttribute("itemList", order.getLineItems());
      return mapping.findForward("success");
    } else {
      request.setAttribute("message", "You may only view your own orders.");
      return mapping.findForward("failure");
    }

  }
}
