/*
 * Decompiled with CFR 0.152.
 */
package JpicDriver;

import JPICSDK.JpicDocument;
import JPICSDK.JpicDriverInterface;
import JPICSDK.JpicDriverOwnerInterface;
import JPICSDK.JpicXmlDocMaker;
import JpicDriver.PublicJobsDriverInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.tidy.Tidy;

public class PublicJobsDriver
implements JpicDriverInterface,
Runnable {
    private Thread thread_;
    private JpicXmlDocMaker jpicXmlDocMaker_;
    private JpicDriverOwnerInterface owner_;
    private String uri_;
    private String convertUri_;
    private PublicJobsDriverInfo info = new PublicJobsDriverInfo();
    private boolean isCachingOn_;
    private Queue<String> cachQueue_;
    private Map<String, JpicDocument> cachedUriAndDocMap_;
    private int CachSize_ = 10;

    public PublicJobsDriver() {
        this.convertUri_ = new String();
        this.uri_ = new String();
        this.cachedUriAndDocMap_ = new HashMap<String, JpicDocument>();
        this.cachQueue_ = new LinkedList<String>();
    }

    public void setOwner(JpicDriverOwnerInterface owner) {
        this.owner_ = owner;
    }

    private boolean cachMapChecking(String uri) {
        JpicDocument jDoc = this.cachedUriAndDocMap_.get(uri);
        if (jDoc != null) {
            Calendar timeCal = jDoc.timeGet();
            Calendar timeNow = Calendar.getInstance();
            long day = (timeNow.getTime().getTime() - timeCal.getTime().getTime()) / 86400000L;
            if (day > 1L) {
                this.cachedUriAndDocMap_.remove(uri);
                this.cachQueue_.remove(uri);
                return false;
            }
            this.owner_.onResponse(this.uri_, jDoc.DocumentGet());
            return true;
        }
        return false;
    }

    public void setCaching(boolean isCachingOn) {
        this.isCachingOn_ = isCachingOn;
    }

    public boolean isCachingOn() {
        return this.isCachingOn_;
    }

    public int getCachSize() {
        return this.CachSize_;
    }

    public void setCachSize(int size) {
        this.CachSize_ = size;
    }

    public JpicDriverOwnerInterface getOwner() {
        return this.owner_;
    }

    public boolean request(String uri) {
        if (this.owner_ == null) {
            return false;
        }
        if (this.thread_ != null && this.thread_.isAlive()) {
            return false;
        }
        this.uri_ = uri;
        if (this.cachMapChecking(uri)) {
            return true;
        }
        this.thread_ = new Thread(this);
        this.thread_.start();
        return true;
    }

    private int uriAnalysis(String uri) throws UnsupportedEncodingException {
        String[] uriItem = uri.split("/");
        int temp = 0;
        int uriLength = uriItem.length;
        this.convertUri_ = this.info.baseUrl();
        if (uriItem[1].compareTo("\ucc44\uc6a9\ubaa9\ub85d") == 0) {
            if (uriLength != 6 && uriLength != 8) {
                return 0;
            }
            this.convertUri_ = String.valueOf(this.convertUri_) + this.info.listUrl();
            if (uriItem[2].compareTo("\uacf5\uac1c\uacbd\uc7c1\ucc44\uc6a9\uc815\ubcf4") == 0) {
                this.convertUri_ = String.valueOf(this.convertUri_) + "serviceId=e01&";
            } else if (uriItem[2].compareTo("\ud2b9\ubcc4\ucc44\uc6a9") == 0) {
                this.convertUri_ = String.valueOf(this.convertUri_) + "serviceId=e02&";
            } else if (uriItem[2].compareTo("\ubcc4\uc815\uc9c1_\uacc4\uc57d\uc9c1") == 0) {
                this.convertUri_ = String.valueOf(this.convertUri_) + "serviceId=e03&";
            } else if (uriItem[2].compareTo("\ud589\uc815\uc9c0\uc6d0\uc778\ub825") == 0) {
                this.convertUri_ = String.valueOf(this.convertUri_) + "serviceId=e04&";
            } else if (uriItem[2].compareTo("\uac1c\ubc29\ud615\uc9c1\uc704") == 0) {
                this.convertUri_ = String.valueOf(this.convertUri_) + "serviceId=e05&";
            } else if (uriItem[2].compareTo("\uacf5\ubaa8\uc9c1\uc704") == 0) {
                this.convertUri_ = String.valueOf(this.convertUri_) + "serviceId=e06&";
            } else if (uriItem[2].compareTo("\uc804\uc785\uacf5\ubaa8") == 0) {
                this.convertUri_ = String.valueOf(this.convertUri_) + "serviceId=e07&";
            } else if (uriItem[2].compareTo("\uacf5\uacf5\uae30\uac04\uacf5\ubaa8") == 0) {
                this.convertUri_ = String.valueOf(this.convertUri_) + "serviceId=e08&";
            } else {
                return 0;
            }
            if (uriItem[3].compareTo("\uc804\uccb4\uc9c1\uc885") == 0) {
                this.convertUri_ = String.valueOf(this.convertUri_) + "stype01=&";
            } else if (uriItem[3].compareTo("\uad6d\uac00\uc9c1") == 0) {
                this.convertUri_ = String.valueOf(this.convertUri_) + "stype01=g01&";
            } else if (uriItem[3].compareTo("\uc9c0\ubc29\uc9c1") == 0) {
                this.convertUri_ = String.valueOf(this.convertUri_) + "stype01=g02&";
            } else if (uriItem[3].compareTo("\uacf5\uacf5\uae30\uad00") == 0) {
                this.convertUri_ = String.valueOf(this.convertUri_) + "stype01=g03&";
            } else {
                return 0;
            }
            if (uriItem[4].compareTo("\uc804\uccb4\uae30\uac04") == 0) {
                this.convertUri_ = String.valueOf(this.convertUri_) + "sPeriod=1&";
                temp = 0;
            } else if (uriItem[4].compareTo("\ucd5c\uadfc3\uac1c\uc6d4") == 0) {
                this.convertUri_ = String.valueOf(this.convertUri_) + "sPeriod=2&";
                temp = 0;
            } else if (uriItem[4].compareTo("\uae30\uac04\uc120\ud0dd") == 0) {
                this.convertUri_ = String.valueOf(this.convertUri_) + "sPeriod=3&";
                this.convertUri_ = uriItem[5].compareTo("\uc804\uccb4\uc2dc\ub3c4") == 0 ? String.valueOf(this.convertUri_) + "sDate=&" : String.valueOf(this.convertUri_) + "&sDate=" + uriItem[5] + "&";
                this.convertUri_ = uriItem[6].compareTo("\uc804\uccb4\uc2dc\ub3c4") == 0 ? String.valueOf(this.convertUri_) + "&eDate=&" : String.valueOf(this.convertUri_) + "&eDate=" + uriItem[6] + "&";
                temp = 2;
            } else {
                return 0;
            }
            this.convertUri_ = String.valueOf(this.convertUri_) + "SearchType=title&searchId=" + uriItem[5 + temp] + "&SearchTEXT=" + uriItem[6 + temp] + "&page=" + uriItem[7 + temp];
            return 1;
        }
        if (uriItem[1].compareTo("\uc138\ubd80\uc815\ubcf4") == 0) {
            if (uriLength != 3) {
                return 0;
            }
            this.convertUri_ = String.valueOf(this.convertUri_) + this.info.detailUrl() + "modeType=read&pk=" + uriItem[2];
            return 2;
        }
        return 0;
    }

    private String convertString(String str) {
        String convert = new String();
        if ((str = str.replace("%20", " ")).contains("%")) {
            int start = str.indexOf("%");
            int end = str.lastIndexOf("%") + 5;
            String temp = new String();
            String hexStr = new String();
            String korStr = new String();
            hexStr = str.substring(start + 1, end);
            String[] parseStr = hexStr.split("%");
            int i = 0;
            while (i < parseStr.length) {
                if (parseStr[i].length() >= 4) {
                    temp = parseStr[i].substring(0, 4);
                    int s = Integer.parseInt(temp, 16);
                    char ch = (char)s;
                    korStr = String.valueOf(korStr) + String.valueOf(ch) + parseStr[i].substring(4);
                } else {
                    temp = parseStr[i].substring(0, 2);
                    char ch = (char)Integer.parseInt(temp, 16);
                    korStr = String.valueOf(korStr) + String.valueOf(ch) + parseStr[i].substring(2);
                }
                ++i;
            }
            convert = str.replace("%" + hexStr, korStr);
        } else {
            convert = str;
        }
        return convert;
    }

    private InputStream httpSourceGet(String url) throws IOException {
        URL hUrl = new URL(url);
        URLConnection connection = hUrl.openConnection();
        connection.connect();
        return connection.getInputStream();
    }

    @Override
    public void run() {
        System.out.println(this.uri_);
        try {
            if (this.uriAnalysis(this.uri_) == 1) {
                System.out.println(this.convertUri_);
                this.listInfo(this.convertUri_);
            } else if (this.uriAnalysis(this.uri_) == 2) {
                System.out.println(this.convertUri_);
                this.detailInfo(this.convertUri_);
            } else {
                System.out.println(this.convertUri_);
                this.owner_.onResponse(this.uri_, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String mergeChildText(NodeList nodeList) {
        String mergedText = new String();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                mergedText = String.valueOf(mergedText) + node.getNodeValue() + "\n";
            } else if (node.hasChildNodes()) {
                mergedText = String.valueOf(mergedText) + this.mergeChildText(node.getChildNodes());
            }
            ++i;
        }
        return mergedText;
    }

    private void listInfo(String url) throws ParserConfigurationException, IOException {
        InputStream in = this.httpSourceGet(url);
        Tidy tidy = new Tidy();
        tidy.setInputEncoding("euc-kr");
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.newDocument();
        Document doc = tidy.parseDOM(in, null);
        Element root = document.createElement("\ucc44\uc6a9\uc815\ubcf4");
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("xsi:noNamespaceSchemaLocation", "PublicJobsDriverDocument.xsd");
        document.appendChild(root);
        Element mainUrl = document.createElement("\ub098\ub77c\uc77c\ud130");
        root.appendChild(mainUrl);
        mainUrl.setAttribute("url", this.info.toString());
        Element jobList = document.createElement("\ucc44\uc6a9_\ub9ac\uc2a4\ud2b8");
        root.appendChild(jobList);
        NodeList lnitList = doc.getElementsByTagName("div");
        int i = 0;
        while (i < lnitList.getLength()) {
            Element element = (Element)lnitList.item(i);
            if (element.getAttribute("id").compareTo("naraTable") == 0) {
                NodeList code_List = element.getElementsByTagName("code");
                Element eleCode = (Element)code_List.item(0);
                jobList.setAttribute("TOTAL", eleCode.getLastChild().getNodeValue());
                eleCode = (Element)code_List.item(1);
                jobList.setAttribute("PAGE", eleCode.getLastChild().getNodeValue());
                NodeList job_List = element.getElementsByTagName("tr");
                int j = 0;
                while (j < job_List.getLength()) {
                    Element job = document.createElement("\uc815\ubcf4");
                    Element number = document.createElement("\ubc88\ud638");
                    Element subject = document.createElement("\uc81c\ubaa9");
                    Element company = document.createElement("\uae30\uad00\uba85");
                    Element sDate = document.createElement("\ub4f1\ub85d\uc77c");
                    Element eDate = document.createElement("\ub9c8\uac10\uc77c");
                    job.appendChild(number);
                    job.appendChild(subject);
                    job.appendChild(company);
                    job.appendChild(sDate);
                    job.appendChild(eDate);
                    Element jobInfoElement = (Element)job_List.item(j);
                    NodeList jobInfoList = jobInfoElement.getElementsByTagName("td");
                    int k = 0;
                    while (k < jobInfoList.getLength()) {
                        Element jobDataElement = (Element)jobInfoList.item(k);
                        switch (k) {
                            case 0: {
                                Text objText = document.createTextNode(jobDataElement.getFirstChild().getNodeValue());
                                number.appendChild(objText);
                                break;
                            }
                            case 1: {
                                NodeList aList = jobDataElement.getElementsByTagName("a");
                                Element temp = (Element)aList.item(0);
                                String detailNum = temp.getAttribute("href");
                                detailNum = detailNum.substring(detailNum.indexOf("pk=") + 3);
                                detailNum = detailNum.substring(0, detailNum.indexOf("&"));
                                job.setAttribute("DETAIL", detailNum);
                                Text objText = document.createTextNode(temp.getLastChild().getNodeValue());
                                subject.appendChild(objText);
                                break;
                            }
                            case 2: {
                                Text objText = document.createTextNode(jobDataElement.getFirstChild().getNodeValue());
                                company.appendChild(objText);
                                break;
                            }
                            case 3: {
                                Text objText = document.createTextNode(jobDataElement.getFirstChild().getNodeValue());
                                sDate.appendChild(objText);
                                break;
                            }
                            case 4: {
                                Text objText = document.createTextNode(jobDataElement.getFirstChild().getNodeValue());
                                eDate.appendChild(objText);
                                jobList.appendChild(job);
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (this.isCachingOn_) {
            if (this.cachQueue_.size() >= this.CachSize_) {
                this.cachQueue_.remove();
            }
            this.cachQueue_.add(this.uri_);
            JpicDocument jDoc = new JpicDocument();
            jDoc.timeSet();
            jDoc.DocumentSet(document);
            this.cachedUriAndDocMap_.put(this.uri_, jDoc);
        }
        this.owner_.onResponse(this.uri_, document);
    }

    private void detailInfo(String url) throws ParserConfigurationException, IOException {
        InputStream in = this.httpSourceGet(url);
        Tidy tidy = new Tidy();
        tidy.setInputEncoding("euc-kr");
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.newDocument();
        Document doc = tidy.parseDOM(in, null);
        Element root = document.createElement("\ucc44\uc6a9\uc815\ubcf4");
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("xsi:noNamespaceSchemaLocation", "PublicJobsDriverDocument.xsd");
        document.appendChild(root);
        Element mainUrl = document.createElement("\ub098\ub77c\uc77c\ud130");
        root.appendChild(mainUrl);
        mainUrl.setAttribute("url", this.info.toString());
        Element jobList = document.createElement("\ucc44\uc6a9_\uacf5\uace0\ub0b4\uc6a9");
        root.appendChild(jobList);
        Element job = document.createElement("\uc815\ubcf4");
        Element subject = document.createElement("\uc81c\ubaa9");
        Element company = document.createElement("\uae30\uad00\uba85");
        Element sDate = document.createElement("\ub4f1\ub85d\uc77c");
        Element eDate = document.createElement("\ub9c8\uac10\uc77c");
        Element filesLink = document.createElement("\ucca8\ubd80\ud30c\uc77c");
        Element link = document.createElement("\uad00\ub828\ub9c1\ud06c");
        Element rank = document.createElement("\ucc44\uc6a9\uc9c1\uae09");
        Element contents = document.createElement("\ub0b4\uc6a9");
        NodeList lnitList = doc.getElementsByTagName("thead");
        int i = 0;
        while (i < lnitList.getLength()) {
            Element element = (Element)lnitList.item(i);
            NodeList tableList = element.getElementsByTagName("td");
            element = (Element)tableList.item(0);
            Text objText = document.createTextNode(element.getLastChild().getNodeValue());
            subject.appendChild(objText);
            job.appendChild(subject);
            int j = 1;
            while (j < tableList.getLength()) {
                NodeList a_List;
                element = (Element)tableList.item(j);
                String str = element.getAttribute("headers");
                if (str.compareTo("t01") == 0) {
                    objText = document.createTextNode(element.getFirstChild().getNodeValue());
                    company.appendChild(objText);
                    job.appendChild(company);
                } else if (str.compareTo("t02") == 0) {
                    objText = document.createTextNode(element.getFirstChild().getNodeValue());
                    sDate.appendChild(objText);
                    job.appendChild(sDate);
                } else if (str.compareTo("t03") == 0) {
                    objText = document.createTextNode(element.getFirstChild().getNodeValue());
                    eDate.appendChild(objText);
                    job.appendChild(eDate);
                } else if (str.compareTo("t05") == 0) {
                    a_List = element.getElementsByTagName("a");
                    int k = 0;
                    while (k < a_List.getLength()) {
                        Element fileElement = (Element)a_List.item(k);
                        Element file = document.createElement("\ud30c\uc77c");
                        String tempStr = fileElement.getAttribute("href");
                        tempStr = this.convertString(tempStr);
                        objText = document.createTextNode(fileElement.getLastChild().getNodeValue());
                        tempStr = tempStr.replace("amp;", "");
                        file.appendChild(objText);
                        file.setAttribute("file_url", String.valueOf(this.info.baseUrl()) + tempStr);
                        filesLink.appendChild(file);
                        job.appendChild(filesLink);
                        ++k;
                    }
                } else if (str.compareTo("t06") == 0) {
                    a_List = element.getElementsByTagName("a");
                    Element urlElement = (Element)a_List.item(0);
                    objText = document.createTextNode(urlElement.getLastChild().getNodeValue());
                    link.appendChild(objText);
                    job.appendChild(link);
                } else if (str.compareTo("t07") == 0) {
                    objText = document.createTextNode(element.getFirstChild().getNodeValue());
                    rank.appendChild(objText);
                    job.appendChild(rank);
                }
                ++j;
            }
            ++i;
        }
        lnitList = doc.getElementsByTagName("tbody");
        i = 0;
        while (i < lnitList.getLength()) {
            Element element = (Element)lnitList.item(i);
            String str = this.mergeChildText(lnitList);
            str = str.replace("&#3664", "\u25cb");
            str = str.replace("&#983803", "\u25a1");
            str = str.replace("&#985103", "\u25a1");
            str = str.replace("&nbsp", " ");
            str = str.replace("&#65381", "\u00b7");
            Text objText = document.createTextNode(str);
            contents.appendChild(objText);
            job.appendChild(contents);
            ++i;
        }
        jobList.appendChild(job);
        if (this.isCachingOn_) {
            if (this.cachQueue_ != null && this.cachQueue_.size() >= this.CachSize_) {
                this.cachQueue_.remove();
            }
            this.cachQueue_.add(this.uri_);
            System.out.println(this.cachQueue_.size());
            JpicDocument jDoc = new JpicDocument();
            jDoc.timeSet();
            jDoc.DocumentSet(document);
            this.cachedUriAndDocMap_.put(this.uri_, jDoc);
        }
        this.owner_.onResponse(this.uri_, document);
    }
}

