/*
 * Created on 2004. 11. 6.

 */
package net.kldp.jsd;

import java.io.*;

/**
 * SimpleDaemon ش.
 * 
 * @author Son KwonNam(kwon37xi@yahoo.co.kr)
 */
public class SimpleDaemonManager {

	/**  ǥ   θ ˻ϴ ֱ */
	private static int DEFAULT_FILE_POLLING_INTERVAL = 2;

	/**
	 *  JVM  Ѱ SimpleDaemonManager ü Ѵ.   Ѱ ü.
	 */
	private static SimpleDaemonManager instance = null;

	/**
	 * ۾   Class ü
	 */
	private Class simpleDaemonClass = null;
	
	/**
	 *  ۾   ü
	 */
	private SimpleDaemon simpleDaemon = null;

	/**
	 *  ǥϴ  ϰ  ǥ  ̸ ϴ ڿ
	 */
	private String representName = null;

	/**
	 * ΰ
	 */
	private SimpleLogger log = null;

	/**
	 * initialize() ޼ҵ尡 ȣ Ǿ°?
	 */
	private boolean initialized = false;

	/**
	 * <p>
	 * SimpleDaemon ʱȭѴ.
	 * </p>
	 * <p>
	 *  Ŭ getInstance() ޼ҵ忡 ؼ ü   ִ.
	 * </p>
	 * 
	 * @param sd
	 *              ü.
	 */
	private SimpleDaemonManager(Class daemonClass) {
		simpleDaemonClass = daemonClass;
		log = SimpleLogger.getLogger();
	}

	/**
	 * <p>
	 * SimpleDaemonManager ü Ѵ.
	 * </p>
	 * <p>
	 *  JVM  Ѱ SimpleDaemonManager   ִ.
	 * 
	 * @param daemonClass   Ŭ
	 * @return SimpleDaemonManager νϽ
	 * @throws LockFileExistException
	 */
	public static synchronized SimpleDaemonManager getInstance(Class daemonClass)
		throws IllegalSimpleDaemonClassException {
		
		if (instance != null) {
			return instance;
		}
		
		if (!isSimpleDaemonClass(daemonClass)) {
			throw new IllegalSimpleDaemonClassException(daemonClass);
		}
		
		instance = new SimpleDaemonManager(daemonClass);

		return instance;
	}
	
	/**
	 * ־ Ŭ SimpleDaemon ̽ ϰ ִ°?
	 * 
	 * @param daemonClass Classü
	 * @return SimpleDaemon ̽  
	 */
	public static boolean isSimpleDaemonClass(Class daemonClass) {
		Class [] interfaces = daemonClass.getInterfaces();
		
		boolean isSimpleDaemonClass = false;
		
		for (int i = 0; i < interfaces.length; i++) {
			if (interfaces[i].equals(net.kldp.jsd.SimpleDaemon.class)) {
				isSimpleDaemonClass = true;
				break;
			}
		}
		
		return isSimpleDaemonClass;
	}

	/**
	 *  ۽Ų.
	 * @throws LockFileExistException
	 * @throws IOException
	 * @throws IllegalSimpleDaemonClassException
	 */
	public void start() throws LockFileExistException, IOException, IllegalSimpleDaemonClassException {
		initialize();

		//   Ѵ.
		simpleDaemon.startDaemon();
	}

	/**
	 * SimpleDaemonManager ü  ʱȭ Ѵ.
	 * 
	 * @throws LockFileExistException
	 * @throws IOException
	 * @throws IllegalSimpleDaemonClassException
	 */
	protected synchronized void initialize() throws LockFileExistException,
			IOException, IllegalSimpleDaemonClassException {
		if (initialized) {
			log.err("̹ initialize() ޼ҵ带 ȣ ߾ϴ.");
			return;
		}

		try {
			// ۾  SimpleDaemon ü 
			simpleDaemon = (SimpleDaemon)simpleDaemonClass.newInstance();
		} catch (InstantiationException e) {
			e.printStackTrace();
			throw new IllegalSimpleDaemonClassException(simpleDaemonClass, e);			
		} catch (IllegalAccessException e) {
			e.printStackTrace();
			throw new IllegalSimpleDaemonClassException(simpleDaemonClass, e);
		}
		
		File lockFile = getLockFile();
		if (lockFile.exists()) {
			//  ϸ ؾѴ.
			throw new LockFileExistException(lockFile);
		}

		//   
		log.out(lockFile.getAbsolutePath() + "   մϴ.");

		if (!lockFile.createNewFile()) {
			String err = lockFile.getAbsolutePath() + "    ߽ϴ.";
			log.err(err);
			throw new IOException(err);
		}

		File exitFlagFile = getExitFlagFile();
		if (exitFlagFile.exists()) {
			log.out(exitFlagFile.getAbsolutePath()
					+ "  ǥ  մϴ. մϴ.");

			if (!exitFlagFile.delete()) {
				String err = exitFlagFile.getAbsolutePath()
						+ "  ǥ   ߽ϴ.";
				log.err(err);
				throw new IOException(err);
			}
		}

		// JVM  ڵ ؾ ۾
		Runtime.getRuntime().addShutdownHook(new SimpleDaemonShutdownManager());

		//  ǥ  縦  ˻ϴ 
		ExitFlagFilePoll effp = new ExitFlagFilePoll(
				DEFAULT_FILE_POLLING_INTERVAL);
		
		effp.setDaemon(true);
		effp.start();
	}

	/**
	 *   θ ǥϴ   ̸ Ѵ.
	 * 
	 * @return   ̸
	 */
	protected String getLockFileName() {
		String lockFileName = getRepresentName() + ".lock";
		
		return lockFileName;
	}

	/**
	 *   ü Ѵ.
	 * 
	 * @return   ü
	 */
	protected File getLockFile() {
		File lockFile = new File(getLockFileName());
		return lockFile;
	}

	/**
	 *  ǥ  ̸ Ѵ.
	 * 
	 * @return  ǥ  ̸
	 */
	protected String getExitFlagFileName() {
		String exitFlagFileName = getRepresentName() + ".shutdown";
		
		return exitFlagFileName;

	}

	/**
	 *  ǥ  ü Ѵ.
	 * 
	 * @return  ǥ  ü
	 */
	protected File getExitFlagFile() {
		File exitFlagFile = new File(getExitFlagFileName());
		return exitFlagFile;
	}
	
	/**
	 *  ǥϴ  ϰ  ǥ  ̸ ϴ ڿ Ѵ.
	 * 
	 * @return  ǥ ڿ
	 */
	protected synchronized String getRepresentName() {
		if (representName != null) {
			return representName;
		}
		
		String home = System.getProperty("user.home");
		log.out("user.home " + home);

		String className = simpleDaemonClass.getName();
		log.out("SimpleDaemon Ŭ ̸ " + className);

		representName = home + File.separator + ".NKJSD_" + className;
		
		log.out(" ǥϴ ̸ " + representName + " Դϴ.");
		
		return representName;
	}

	/**
	 * JVM   Ǿ ϴ ۾ Ѵ.
	 * 
	 * @author Son KwonNam(kwon37xi@yahoo.co.kr)
	 */
	protected class SimpleDaemonShutdownManager extends Thread {

		public void run() {
			SimpleLogger log = SimpleLogger.getLogger();

			log.out(" shutdown() ޼ҵ ȣմϴ.");
			simpleDaemon.shutdown();

			File lockFile = getLockFile();
			log.out(lockFile.getAbsolutePath() + "    õմϴ.");

			if (lockFile.exists()) {
				if (lockFile.delete()) {
					log.out(lockFile.getAbsolutePath() + "   ߽ϴ.");
				} else {
					log.err(lockFile.getAbsolutePath() + "    ߽ϴ.");
				}

			} else {
				log.err(lockFile.getAbsolutePath() + "    ʽϴ.");
			}
			
			File exitFlagFile = getExitFlagFile();
			log.out(exitFlagFile.getAbsolutePath() + "  ǥ   õմϴ.");
			
			if (exitFlagFile.exists()) {
				if (exitFlagFile.delete()) {
					log.out(exitFlagFile.getAbsolutePath()
							+ "  ǥ  ߽ϴ.");
				} else {
					log.err(exitFlagFile.getAbsolutePath()
							+ "  ǥ   ߽ϴ.");
				}
			}

			log.out(" ᰡ ϷǾϴ.");
		}
	}

	/**
	 *  ǥ  Ǿ ֱ ˻ϴ
	 * .
	 * 
	 * @author Son KwonNam(kwon37xi@yahoo.co.kr)
	 */
	protected class ExitFlagFilePoll extends Thread {

		private int intervalms = 0;

		public ExitFlagFilePoll(int interval) {
			if (interval > 0) {
				this.intervalms = interval * 1000;
			} else {
				this.intervalms = DEFAULT_FILE_POLLING_INTERVAL * 1000;
			}
		}

		/**
		 *  ǥ  縦 ٸ.
		 */
		public void run() {
			log.out("  ǥ   带 ߽ϴ.");
			
			while (true) {
				File exitFlagFile = getExitFlagFile();

				if (exitFlagFile.exists()) {
					log.out(getExitFlagFileName() + "  Ǿϴ. " + 
							"ý Ḧ մϴ .");

					//  ع!
					System.exit(0);
				}

				try {
					Thread.sleep(intervalms);
				} catch (Exception ex) {
					ex.printStackTrace();
					//ignored
				}
			}
		}
	}

	/**
	 * <p> Ų.</p>
	 * 
	 * <p> ޼ҵ带 ϸ  JVM  Ǵ  ƴ϶,
	 * ̹ ٸ JVM   ǥ ǥ  Ͽ,
	 * ٸ JVM  Ű ̴.</p>
	 */
	public void shutdownDaemon() throws IOException {
			File exitFlagFile = getExitFlagFile();
			
			if (exitFlagFile.exists()) {
				log.err(exitFlagFile.getAbsolutePath() + " ̹ մϴ.");
				return;
			}
			
			try {
				exitFlagFile.createNewFile();
			} catch (IOException ex) {
				String err = exitFlagFile.getAbsolutePath() + "  ߽ϴ.";
				log.err(err);
				
				throw new IOException(err);
			}
			
			log.out(exitFlagFile.getAbsolutePath() + "  ߽ϴ. " + 
					"    Դϴ.");
	}
}