/*
 * ۼ: 2005. 7. 7.
 * ۼ: ̰
 *   : 
 */
package net.koov.irc;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Vector;

/**
 * @ۼ ̰
 * @ۼ 2005. 7. 7.
 * @ 2005. 7. 7.
 *
 */
public class Config {
	
	private static String	serverAddress;
	private static int		serverPort;
	private static String	clientAddress;
	private static String	clientName;
	private static String	clientNick;
	private static String	pass;
	
	private static Vector	accounts = new Vector();
	private static Vector	channels = new Vector();
	
	private static String	configFile = "KoovBot.cfg";
	
	static {
		try {
			clientAddress = InetAddress.getLocalHost().getHostAddress();
			BufferedReader reader = new BufferedReader(new FileReader(configFile));
			if (reader != null) {
				parse(reader);
				reader.close();
			}
			else {
				System.out.println("Ͽ");
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * ׿ ϸ Ѵ.
	 * @ۼ: ̰
	 * @ۼ: 2005. 7. 7.
	 * @: 2005. 7. 7.
	 * @return
	 */
	public static String getDebugFileName() {
		return null;
	}
	
	/**
	 * @ۼ: ̰
	 * @ۼ: 2005. 7. 11.
	 * @: 2005. 7. 11.
	 * @param reader
	 * @throws IOException
	 */
	private static void parse(BufferedReader reader) throws IOException {
		String line;
		while((line = reader.readLine()) != null) {
			if (line.charAt(0) == '#' || line.charAt(0) == ';') {
				continue;
			}
			
			String[] token = line.split("=");
			if (token == null || token.length < 2) {
				continue;
			}
			
			for (int i = 0 ; i < token.length ; i++) {
				System.out.print(token[i] + " ");
			}
			System.out.println();
			
			
			if (token[0].equalsIgnoreCase("ircserver")) {
				serverAddress = token[1].trim();
			}
			else if (token[0].equalsIgnoreCase("ircport")) {
				serverPort = Integer.parseInt(token[1].trim());
			}
			else if (token[0].equalsIgnoreCase("name")) {
				clientName = token[1].trim();
			}
			else if (token[0].equalsIgnoreCase("nick")) {
				clientNick = token[1].trim();
			}
			else if (token[0].equalsIgnoreCase("chan")) {
				channels.add(token[1].trim());
			}
			else if (token[0].equalsIgnoreCase("account")) {
				
				String[] info = new String[3];
				if (token[1].indexOf("!") != -1 && token[1].indexOf("@") != -1) {
					info[0] = token[1].substring(0, token[1].indexOf("!")).replaceAll("\\*", ".*");
					info[1] = token[1].substring(token[1].indexOf("!") + 1, token[1].indexOf("@")).replaceAll("\\*", ".*");;
					info[2] = token[1].substring(token[1].indexOf("@") + 1).replaceAll("\\*", ".*");;
					
					System.out.println("ID:" + info[0] + "/user:" + info[1] + "/host:" + info[2]);
				}
				
				accounts.add(info);
			}
			else if (token[0].equalsIgnoreCase("pass")) {
				pass = token[1].trim();
			}
			else {
				System.out.println("Unknown Setting : " + token[0]);
			}
		}
	}
	
	/**
	 * @return Returns the accounts.
	 */
	public static Vector getAccounts() {
		return accounts;
	}
	/**
	 * @param accounts The accounts to set.
	 */
	public static void setAccounts(Vector accounts) {
		Config.accounts = accounts;
	}
	/**
	 * @return Returns the channels.
	 */
	public static Vector getChannels() {
		return channels;
	}
	/**
	 * @param channels The channels to set.
	 */
	public static void setChannels(Vector channels) {
		Config.channels = channels;
	}
	/**
	 * @return Returns the clientName.
	 */
	public static String getClientName() {
		return clientName;
	}
	/**
	 * @param clientName The clientName to set.
	 */
	public static void setClientName(String clientName) {
		Config.clientName = clientName;
	}
	/**
	 * @return Returns the clientNick.
	 */
	public static String getClientNick() {
		return clientNick;
	}
	/**
	 * @param clientNick The clientNick to set.
	 */
	public static void setClientNick(String clientNick) {
		Config.clientNick = clientNick;
	}
	/**
	 * @return Returns the serverAddress.
	 */
	public static String getServerAddress() {
		return serverAddress;
	}
	/**
	 * @param serverAddress The serverAddress to set.
	 */
	public static void setServerAddress(String serverAddress) {
		Config.serverAddress = serverAddress;
	}
	/**
	 * @return Returns the serverPort.
	 */
	public static int getServerPort() {
		return serverPort;
	}
	/**
	 * @param serverPort The serverPort to set.
	 */
	public static void setServerPort(int serverPort) {
		Config.serverPort = serverPort;
	}
	
	public static String getClientAddress() {
		return clientAddress;
	}
}
