/*******************************************************************
Date : 20000. 09. x
File Name : LE-main.cpp
Description : Line Editor Program 
*******************************************************************/
#include<stdio.h>
#include<string.h>
#include<stdlib.h>
#include<malloc.h>
#include ".\\LE-declare.cpp"
//#include ".\\LE-function.cpp"
#define MAX_LINE 100		//ִ  100ٷ .
static char *lines[MAX_LINE];		//   ڿ 迭
static char file_name[20] = "";		// ̸  迭 .
static int line_number = 0;			//ü  .
static int current_line = 0;		//  ȣ.
static BOOLEAN saved_current = TRUE;	//     TRUE,   ʾ FALSE

int main(int argc, char *argv[])
{	

	printf(" Line Editor \tVer0.1 \tDate:2000.09.x \n\n");
	// Է μ ó
	if(argc == 2)
	{
		changeFileTitle(argv[1]);
		if(fileOpen(argv[1]) == 1)
		{
			printf("File Not Found\n");
			exit(1);		//߸
		}
	}
	else 
		if(argc > 2)
		{
			printf("Arguement Error!\n");
			exit(2);		//߸
		};
	interpreteCommand();		//ؼԼȣ
	return 0;
}
//////////////////// function part ////////////////////////
void interpreteCommand()
{
	char command[45], c, arg1[20], arg2[20];
	char ans=' ';
	int result=0;		//Լ  .
	int line1=0;
	int line2=0;
	char *new_line;
	while(1)
	{
		command[0] = 0;
		c = 0;
		arg1[0] = 0;
		arg2[0] = 0;
		printf("# ");
		gets(command);
		sscanf (command,"%c %s %s" ,&c, &arg1, &arg2);
		//ɰ μ  ޴ Ȯ.
		//printf("%c %s %s\n", c, arg1, arg2);
		switch(c)
		{
			/*  */
			case 'Q' : 
				exit(0);
			case 'q' : 
				if(fileQuit() == 1)
				{
					printf("Error: Current File is not saved, Save(y/n)?");
					ans = getchar();
					if((ans == 'y')||(ans == 'Y'))
					{
						result = fileSave();
						if (result == 1)
							printf("Error: File Name not declared\n");
						else 
							if(result == 2) 
								printf("Error: cannot write File\n");
							else 
								if(result == 0)
									printf("File Saved Succeed!\n");
						exit(0);
					} 
					else 
						exit(0);
				};
				break;
			/* ó */		 
			case 'N': 
				result = fileNew(arg1);
				break;		//switchŻ
			case 'S': 
				result = fileSave();
				if (result == 0)  //
					printf("File Saved Success!\n");
				else 
					if (result == 1)   // ̸ 
						printf("Error: File Name Not Declared!\n");
					else 
						if (result == 2)   // 
							printf("Error: File Not Saved!\n");
				break;
			case 'T' : 
				result = fileTitle();
				if (result == 1)
					printf("File name isn't specified\n");
				break;
			case 'C' :
				result = changeFileTitle(arg1);
				if (result == 1)
				{
					printf("File name needed!\n");
					printf("usage of this command : \"# C [filename]\"\n");
				}
				break;
			//case 'O'			
			/*Line  */
			case 'a':
				if (0 == strcmp(arg1, ""))
					line1 = current_line;
				else 
					if (arg1[0] == '!')
						line1 = current_line;
					else 
						if (arg1[0] == '$')
							line1 = line_number;
						else
							line1 = atoi(arg1);
				new_line = (char *)malloc(80);
				gets(new_line);
				lineAppend(line1, new_line);
				free(new_line);
				break;
			//case 'i':
			//case 'w':
			//case 'd':
			/*̵ */
			//case 'n':
			//case 'p':
			//case 'g':
			//case 'f':
			/*List */
			case 'l' : 
				//arg1  ó
				if (0 == strcmp(arg1, ""))
					line1 = 0;
				else 
					if (arg1[0] == '!')
						line1 = current_line;
					else 
						if (arg1[0] == '#')
							line1 = line_number;
						else
							line1 = atoi(arg1);
				//arg2   ó 
				if (0 == strcmp(arg1, ""))
					line2 = 0;
				else 
					if (arg2[0] == '!')
						line2 = current_line;
					else 
						if (arg2[0] == '#')
							line2 = line_number;
						else
							line2 = atoi(arg2);
				result = lineList(line1, line2);
				if( result == 1) 
					printf("Error : Line Number Incorrect\n");
				break;
			case '?' :
			case 'h' :
				helpcommand();
				break;
			//there is no matching.
			default :
				printf("Incorrect Comand\n");
		} //End of Switch.
	} //End of While.
} //End of interpreteCommand Function.

// changeFileTitle Լ 
int changeFileTitle(char *new_name)
{
	if (0 == strcmp(new_name,""))
		return 1;
	else
		strcpy(file_name, new_name);
		saved_current = FALSE;
		return 0;
}

// fileTitle Լ
int fileTitle(void)
{
	if (0 == strcmp(file_name,""))
		return 1;
	else 
	{
		printf("Fine name is : %s\n", file_name);
		return 0;
	}

}

// fileOpen Լ
int fileOpen(char *file)
{
	FILE *fp;
	int line_count=0;
	
	if (saved_current == FALSE)
		return 3; // Not Saved ...
	if ((fp=fopen(file,"r")) == NULL)
		return 1; // File Not Found || File Not Open ...
	else 
	{		
		while(!feof(fp))
		{
				 lines[line_count] = (char *) malloc(80);
				 fgets(lines[line_count], 80, fp);
				 line_count++;
				 if(MAX_LINE >= line_count) return 2;
		}
		line_number = line_count;
		current_line = 1;
		fclose(fp);
		return 0;
	}
}

// fileQuit Լ
int fileQuit(void)
{
	if (saved_current == FALSE) 
		return 1;
	else 
		exit(0);
}

// fileSave Լ
int fileSave(void)
{

	FILE *fp;
	int line_count;
	if (file_name == NULL)
		return 1;
	if ((fp=fopen(file_name,"w")) == NULL)
		return 2;
	else 
	{
		for (line_count=0; line_count < line_number; line_count++)
		{
			fputs(lines[line_count], fp);
			free(lines[line_count]);
		}	
		current_line = 1;
		saved_current = TRUE;	//TRUE:1
		fclose(fp);
		return 0;
	}	
}

// fileNew Լ
int fileNew(char *new_name)
{
//	int i;
	if(saved_current == FALSE) return 1;
	if(0 == strcmp(new_name,"")) new_name = "";	
	strcpy(file_name, new_name);
	line_number = 0;		//ü  .
	current_line = 0;		//  ȣ.
	saved_current = TRUE;	//TRUE:1
	//for(i = 0; i< 100; i++)
	//	free(lines[i]);
	return 0;
}

//lineAppend Լ
int lineAppend(int line, char *new_line)
{
	int i_ln = line_number;
	if(line > line_number)
	{
		puts("Error : Line Number Incorrect");
		return 1;
	}
	for(i_ln; i_ln > line; i_ln --)
	{
		lines[i_ln] = (char *) malloc(80);		
		strcpy(lines[i_ln], lines[i_ln -1]);
		free(lines[i_ln -1]);
	}
	lines[line] = (char *) malloc(80);
	strcpy(lines[line], new_line);
	current_line = ++line;
	saved_current = FALSE;	//FALSE:1
	line_number++;
	return 0;
}

// lineList Լ
int lineList(int line1, int line2)
{
	int i;
	//μ   :   
	if(line1 == 0 && line2 == 0)
	{
		printf("%d : %s\n", current_line, lines[current_line-1]);
		return 0;
	};
	//μ ϳ  : line1  
	if(line1 != 0 && line2 == 0)
	{
		if( line1 > line_number)
			return 1;
		else
		{
			printf("%d : %s\n", line1, lines[line1-1]);
			return 0;
		}
	};
	//μ ΰ  line1 ~ line2 
	if(line1 != 0 && line2 != 0)
	{
		if( line1 > line_number || line2 > line_number || line1 > line2)
			return 1;
		else
		{
			for (i = line1; i <=line2; i++)
				printf("%d : %s\n", i, lines[i-1]);
			return 0;
		}
	};
	return 0;
}

//
void helpcommand(void)
{
	system("cls");		//OSκ "cls"ɻ
	printf(" Line Editor \tVer0.1 \tDate:2000.09.x \n");
	printf("%========= Quit command =========\n");
	printf("Q : Quit\n");
	printf("q : Exit\n");
	printf("======= File Save command =======\n");
	printf("N [filename] : New file\n");
	printf("S [filename] : Save file\n");
	printf("T : Title of file\n");
	printf("C [filename] : Change title of file\n");
	printf("O [filename] : Open file\n");
	printf("=======Line Modify command======\n");
	printf("a [line number] : Append\n");
	printf("i [line number] : Insert\n");
	printf("w [line number] : OverWrite\n");
	printf("d [line number1][line number2] : Delete\n");
	printf("======Cursor move command=======\n");
	printf("n : Next\n");
	printf("p : Previous\n");	
	printf("g [line number] : Go\n");
	printf("f [string] : Find\n") ;
	printf("=====Line List Print command====\n");
	printf("l : List\n");
	printf("\"?\" or \"h\" : Help me\n");
}
