//////////////////////////////////////////////////////
// fileinfoshow.c
//
//  Lee Juhyun
//
#include <curses.h>
#include <panel.h>
#include <menu.h>
#include <stdlib.h>
#include <dirent.h>
#include <string.h>
#include "mainlib.h"

extern int screen_size_cols;
extern int screen_size_lines;

extern WINDOW 	*w_fileinfo;
extern PANEL 	*p_fileinfo;

extern int write_log(char *);
extern int exit_program(void);

int fileinfo_show(char *name) {

	int size_fileinfo_lines	= 1;
	int size_fileinfo_cols	= screen_size_cols - 2;
	int size_fileinfo_x	= 1;
	int size_fileinfo_y = screen_size_lines - 12;
	
	if ((w_fileinfo = newwin(size_fileinfo_lines, size_fileinfo_cols,
			size_fileinfo_y, size_fileinfo_x)) == NULL) {
		write_log("Error fileinfo_show/newwin");
		exit_program();
	}

	if ((p_fileinfo = new_panel(w_fileinfo)) == NULL) {
		write_log("Error fileinfo_show/new_panel");
		exit_program();
	}

	return 0;
}

