//////////////////////////////////////////////////////
// submenushow.c
//
//  Lee Juhyun
//
#include <panel.h>
#include <menu.h>
#include <stdlib.h>
#include <string.h>
#include "mainlib.h"
#include "varlib.h"

ITEM 			***my_subs;
int 			size_submenu_lines;
int 			size_submenu_cols;
int 			size_submenu_y;
int 			size_submenu_x;

extern 	int 		screen_size_cols;
extern 	int		 screen_size_lines;
extern 	menu_t 		*menudata;
extern 	filepath_t 	*filepath;
extern 	int 		index_menu;

extern WINDOW 		**w_submenu;
extern MENU		**m_submenu;
extern PANEL		**p_submenu;
extern PANEL_DATA	*pd_submenu;
extern MENU		*m_titlebar;

int submenu_show(void);
int init_w_submenu(WINDOW **, int n);
int show_w_submenu(WINDOW *, char *, int);
int print_in_middle_submenu(WINDOW * , int, int, int, char *, chtype);

extern int write_log(char *);
extern int exit_program();

int submenu_show(void) {

	size_submenu_lines	= screen_size_lines - 15;
	size_submenu_cols	= screen_size_cols/2 ;
	size_submenu_y		= 3;
	size_submenu_x		= screen_size_cols/2;

	int i, j;

	if ((w_submenu 	= (WINDOW **)calloc(menudata->n_submenu[0], sizeof(WINDOW *))) == NULL ||
		(m_submenu 	= (MENU **)calloc(menudata->n_submenu[0], sizeof(MENU *))) == NULL ||
		(p_submenu 	= (PANEL **)calloc(menudata->n_submenu[0], sizeof(PANEL *))) == NULL ||
		(my_subs		= (ITEM ***)calloc(menudata->n_submenu[0], sizeof(ITEM **))) == NULL ||
		(pd_submenu 	= (PANEL_DATA *)calloc(menudata->n_submenu[0], sizeof(PANEL_DATA))) == NULL) {
		write_log("Error submenu_show/calloc");
		exit_program();
	}
	
	if (init_w_submenu(w_submenu, menudata->n_submenu[0]) == -1) {
		write_log("Error submenu_show/init_w_submenu");
		exit_program();
	}
	
	for (i = 0; i < menudata->n_submenu[0]; i++) {
		
		if ((my_subs[i] = (ITEM **)calloc(menudata->n_submenu[i+1], sizeof(ITEM *))) == NULL) {
			write_log("Error submenu_show/calloc");
			exit_program();
		}

		for (j = 0; j < menudata->n_submenu[i+1]; j++) {
			if ((my_subs[i][j] = new_item(menudata->submenu[i+1][j].name ,menudata->submenu[i+1][j].desc2)) == NULL) {
				write_log("Error submenu_show/new_item");
				exit_program();
			}
		}
		my_subs[i][menudata->n_submenu[i+1]] = (ITEM *)NULL;

		if ((m_submenu[i] = new_menu((ITEM **)my_subs[i])) == NULL) {
			write_log("Error submenu_show/new_menu");
			exit_program();
		}

		set_menu_format(m_submenu[i], size_submenu_lines-5, 1);
		set_menu_win(m_submenu[i], w_submenu[i]);
		set_menu_sub(m_submenu[i], derwin(w_submenu[i], size_submenu_lines - 5, size_submenu_cols - 2, 3, 1));
		set_menu_mark(m_submenu[i], " ");
	
		post_menu(m_submenu[i]);

		if ((p_submenu[i] = new_panel(w_submenu[i])) == NULL) {
			write_log("Error submenu_show/new_panel");
			exit_program();
		}
		
		pd_submenu[i].hide = TRUE;

		set_panel_userptr(p_submenu[i], &pd_submenu[i]);

		hide_panel(p_submenu[i]);
	}

	return 0;

}

int init_w_submenu(WINDOW **wins, int n) {

	int x, y, i;
	char label[80];

	for (i = 0; i < n ; ++i) {
		if ((wins[i] = newwin(size_submenu_lines, size_submenu_cols,
				size_submenu_y, size_submenu_x)) == NULL) {
			write_log("Error init_w_submenu/newwin");
			return -1;
		}

		if (sprintf(label, "Push TAB, U can use filelist [%s]", menudata->submenu[0][i].name) < 0) {
			write_log("Error init_w_submenu/new_panel");
			return -1;
		}

		if (show_w_submenu(wins[i], label, 1) == -1) {
			write_log("Error init_w_submenu/show_w_submenu");
			return -1;
		}
	}		

	return 0;
}

int show_w_submenu(WINDOW *win, char *label, int label_color) {
	int startx, starty, height, width;

	getbegyx(win, starty, startx);
	getbegyx(win, height, width);

	box(win, 0, 0);
	mvwaddch(win, 2, 0, ACS_LTEE);
	mvwhline(win, 2, 1, ACS_HLINE, width - 2);
	mvwaddch(win, 2, width - 1, ACS_RTEE);

	if (print_in_middle_submenu(win, 1, 0, width, label, COLOR_PAIR(label_color)) == -1) {
		write_log("Error print_in_middle_submenu/print_in_middle_submenu");
		return -1;
	}
	
	return 0;
}


int  print_in_middle_submenu(WINDOW *win, int starty, int startx, int width, char *string, chtype color) {
	int length, x, y;
	float temp;

	if(win == NULL)
		win = stdscr;
	getyx(win, y, x);
	if(startx != 0)
		x = startx;
	if(starty != 0)
		y = starty;
	if(width == 0)
		width = 80;

	length = strlen(string);
	temp = (width - length)/2;
	x = startx + (int)temp;
	wattron(win, color);
	mvwprintw(win, y, x, "%s", string);
	wattroff(win,color);
	refresh();
	
	return 0;
}

int submenu_free() {
	int i,j;
	ITEM 	***my_subs;
	for(i = 0; i < menudata->n_submenu[0]; ++i) {
		for(j=0; j < menudata->n_submenu[i]; j++) {
			free_item(my_subs[i][j]);
		}
		free(menudata->submenu[i]);
	}
	free(menudata->submenu);
	free(menudata->n_submenu);
	free(menudata);

	return 0;
}

