/*****************************************************************************

  ui_font.c

	function for dealing with a Japanese character sequence.

*****************************************************************************/

#include "driver.h"
#ifdef KAILLERA
#include "KailleraChat.h"
#endif

#ifdef JAPANESE

#define COLOR_BUTTONS	(188 + 1)

static UINT16 _uifonttable[65536];
static UINT32 colortable[2 * 2];

/****************************************************************************/

static UINT16 uifont_buildtable(UINT16 code)
{
	UINT8 c1, c2;

	c1 = (code >> 8) & 0xff;
	c2 = code & 0xff;

	//  : ** ڵ óκ **
	//  : ϼ(KSC5601) ڵ  : c1: (0xa1-0xfd)  c2: (0xa1-0xfe)
	if ((0xa1 <= c1 && c1 <= 0xfd) && (c2 >= 0xa1))
	{
		if(0xa1 <= c1 && c1 <= 0xac)
			code = (c1 - 0xa1 + 4) * 94 + (c2 - 0xa1);
		else if(0xad <= c1 && c1 <= 0xaf)
			code = (c1 - 0xad) * 94 + (c2 - 0xa1);
		else if(0xb0 <= c1 && c1 <= 0xc8)
			code = (c1 - 0xa1 + 1) * 94 + (c2 - 0xa1);
		else if(c1 == 0xc9)
			code = (c1 - 0xc9 + 3) * 94 + (c2 - 0xa1);
		else if(0xca <= c1 && c1 <= 0xfd )
			code = (c1 - 0xa1) * 94 + (c2 - 0xa1);
	}

	//  : Ȯ念A : c1: (0x81-0xa0)  c2: (0x41-0x5a,0x61-0x7a,0x8a-0xfe)
	else if (0x81 <= c1 && c1 <= 0xa0)
	{
		if(0x41 <= c2 && c2 <= 0x5a)
			code = (c1 - 0x81) * 178 + (c2 - 0x41) + 8742;
		else if( 0x61 <= c2 && c2 <= 0x7a )
			code = (c1 - 0x81) * 178 + (c2 - 0x61 + 0x1a) + 8742;
		else if( 0x81 <= c2 && c2 <= 0xfe )
			code = (c1 - 0x81) * 178 + (c2 - 0x81 + 0x34) + 8742;
	}

	//  : Ȯ念B : c1: (0xa1-0xc6)  c2: (0x41-0x5a,0x61-0x7a,0x8a-0xa0)
	else if ((0xa1 <= c1 && c1 <= 0xc6) && (c2 <= 0xa0))
	{
		if( 0x41 <= c2 && c2 <= 0x5a )
			code = (c1 - 0x81) * 84 + (c2 - 0x41) + 14438;
		else if( 0x61 <= c2 && c2 <= 0x7a )
			code = (c1 - 0x81) * 84 + (c2 - 0x61 + 0x1a) + 14438;
		else if( 0x81 <= c2 && c2 <= 0xa0 )
			code = (c1 - 0x81) * 84 + (c2 - 0x81 + 0x34) + 14438;
	}
	else
		return 0x60;

	return code;
}


int uifont_buildfont(void)
{
	static unsigned char fontdata6x12[] =
	{
		#include "font\asc6x12.dat"
	};
	static unsigned char fontdata12x12[] =
	{
		#include "font\cmd12x12.dat"
		#include "font\ksc12x12.dat"
		#include "font\kse12x12.dat"
		#include "font\end12x12.dat"
	};
	static struct GfxLayout fontlayout6x12 =
	{
		6,12,	/* 6*12 characters */
		256,    /* 128 characters */
		1,	/* 1 bit per pixel */
		{ 0 },
		{ 0, 1, 2, 3, 4, 5, 6, 7 },	/* straightforward layout */
		{ 0*8, 1*8, 2*8, 3*8, 4*8, 5*8, 6*8, 7*8, 8*8, 9*8, 10*8, 11*8 },
		8*12	/* every char takes 8 consecutive bytes */
	};
	static struct GfxLayout fontlayout12x12 =
	{
		12,12,	/* 6*12 characters */
		256,    /* 128 characters */
		1,	/* 1 bit per pixel */
		{ 0 },
		{ 0,0, 1,1, 2,2, 3,3, 4,4, 5,5, 6,6, 7,7 },	/* straightforward layout */
		{ 0*8, 1*8, 2*8, 3*8, 4*8, 5*8, 6*8, 7*8, 8*8, 9*8, 10*8, 11*8 },
		8*12	/* every char takes 8 consecutive bytes */
	};
	static struct GfxLayout fontlayout6x24 =
	{
		6,24,	/* 6*12 characters */
		256,    /* 128 characters */
		1,	/* 1 bit per pixel */
		{ 0 },
		{ 0, 1, 2, 3, 4, 5, 6, 7 },	/* straightforward layout */
		{ 0*8,0*8, 1*8,1*8, 2*8,2*8, 3*8,3*8, 4*8,4*8, 5*8,5*8,
		  6*8,6*8, 7*8,7*8, 8*8,8*8, 9*8,9*8, 10*8,10*8, 11*8,11*8 },
		8*12	/* every char takes 8 consecutive bytes */
	};
	static struct GfxLayout fontlayout12x12z =
	{
		12,12,
		(0x9fff - 0x8140) + (0xfcff - 0xe040) + 1,
		1,
		{ 0 },
		{ 0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15 },
		{ 0*16,1*16,2*16,3*16,4*16,5*16,6*16,7*16,8*16,9*16,10*16,11*16 },
		16*12
	};
	static struct GfxLayout fontlayout24x12z =
	{
		24,12,
		(0x9fff - 0x8140) + (0xfcff - 0xe040) + 1,
		1,
		{ 0 },
		{ 0,0, 1,1, 2,2, 3,3, 4,4, 5,5, 6,6, 7,7,
		  8,8, 9,9, 10,10, 11,11, 12,12, 13,13, 14,14, 15,15 },
		{ 0*16,1*16,2*16,3*16,4*16,5*16,6*16,7*16,8*16,9*16,10*16,11*16 },
		16*12
	};
	static struct GfxLayout fontlayout12x24z =
	{
		12,24,
		(0x9fff - 0x8140) + (0xfcff - 0xe040) + 1,
		1,
		{ 0 },
		{ 0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15 },
		{ 0*16,0*16, 1*16,1*16, 2*16,2*16, 3*16,3*16, 4*16,4*16, 5*16,5*16,
		  6*16,6*16, 7*16,7*16, 8*16,8*16, 9*16,9*16, 10*16,10*16, 11*16,11*16 },
		16*12
	};
	int i;

	Machine->uifont   = 0;
	Machine->uifont2  = 0;

	switch_ui_orientation(NULL);

	if ((Machine->drv->video_attributes & VIDEO_PIXEL_ASPECT_RATIO_MASK)
			== VIDEO_PIXEL_ASPECT_RATIO_1_2)
	{
		if (Machine->gamedrv->flags & ORIENTATION_SWAP_XY)
		{
			if ((Machine->uifont = decodegfx(fontdata6x12, &fontlayout6x24)))
			{
				Machine->uifont->colortable = colortable;
				Machine->uifont->total_colors = 2;
				Machine->uifontwidth = 6;
				Machine->uifontheight = 24;
			}
			else
				return 0;

			if ((Machine->uifont2 = decodegfx(fontdata12x12, &fontlayout12x24z)))
			{
				Machine->uifont2->colortable = colortable;
				Machine->uifont2->total_colors = 2;
				Machine->uifontwidth2 = 12;
				Machine->uifontheight2 =24;
			}
			else
				return 0;
		}
		else
		{
			if ((Machine->uifont = decodegfx(fontdata6x12, &fontlayout12x12)))
			{
				Machine->uifont->colortable = colortable;
				Machine->uifont->total_colors = 2;
				Machine->uifontwidth = 12;
				Machine->uifontheight = 12;
			}
			else
				return 0;

			if ((Machine->uifont2 = decodegfx(fontdata12x12, &fontlayout24x12z)))
			{
				Machine->uifont2->colortable = colortable;
				Machine->uifont2->total_colors = 2;
				Machine->uifontwidth2 = 24;
				Machine->uifontheight2 =12;
			}
			else
				return 0;
		}
	}
	else
	{
		if ((Machine->uifont = decodegfx(fontdata6x12, &fontlayout6x12)))
		{
			Machine->uifont->colortable = colortable;
			Machine->uifont->total_colors = 2;
			Machine->uifontwidth = 6;
			Machine->uifontheight = 12;
		}
		else
			return 0;

		if ((Machine->uifont2 = decodegfx(fontdata12x12, &fontlayout12x12z)))
		{
			Machine->uifont2->colortable = colortable;
			Machine->uifont2->total_colors = 2;
			Machine->uifontwidth2 = 12;
			Machine->uifontheight2 =12;
		}
		else
			return 0;
	}

	switch_true_orientation(NULL);

	for (i = 0x4081; i < 0xfffc; i++)
		_uifonttable[i] = uifont_buildtable(i) + 256;

	return 1;
}


void uifont_freefont(void)
{
	if (Machine->uifont2)
	{
		freegfx(Machine->uifont2);
		Machine->uifont2 = 0;
	}
	if (Machine->uifont)
	{
		freegfx(Machine->uifont);
		Machine->uifont = 0;
	}
}

int uifont_decodechar(unsigned char *s, unsigned short *code)
{
    unsigned char c1 = *(unsigned char *)s;
    unsigned char c2 = *(unsigned char *)(s + 1);
	int isDBC;

	//  : Ȯϼ ڵ念 
	isDBC = ((c1 >= 0x81 && c1 <= 0xfe) && ((c2 >= 0x41 && c2 <= 0x5a) || (c2 >= 0x61 && c2 <= 0x7a) || (c2 >= 0x81 && c2 <= 0xfe)));

    if (isDBC)
    {
        *code = _uifonttable[(c1 << 8) | c2];

        if (*code == 0)
            *code = _uifonttable[0x817f];

        return 2;
    }

    *code = c1;
    return 1;
}

#else

int uifont_decodechar(unsigned char *s, unsigned short *code)
{
    *code = *s;
    return 1;
}

#endif

int uifont_drawfont(struct mame_bitmap *bitmap, const char *s, int sx,
                    int sy, int color)
{
    int x, y, wrapped, next_sy, increment, uifontwidth;
    unsigned short code;
    unsigned char *c;
    struct GfxElement *uifont;
#ifdef KAILLERA
    int colormode;
    int pos = 0;
    unsigned char *attr = NULL;
    int *clause = NULL;
    extern int nChatDrawMode;

    if (color == UI_COLOR_TRANS && nChatDrawMode)
        colormode = TRANSPARENCY_PEN;
    else
        colormode = TRANSPARENCY_NONE;

    if (color == UI_COLOR_ATTRIBUTE)
    {
        attr   = KailleraChatGetStrAttr();
        clause = KailleraChatGetStrClause();
    }
#endif

    c      = (unsigned char *)s;
    x      = sx;
    y      = sy;
    code   = 0;
    next_sy = 0;

    while (*c)
    {
        wrapped = 0;

        increment = uifont_decodechar(c, &code);

        if (*c == '\n')
        {
            x = sx;
            y += Machine->uifontheight + 1;
            next_sy += Machine->uifontheight;
            c++;
            continue;
        }
        else
        {
#ifdef JAPANESE
            if (code > 0x00ff)
            {
                uifont      = Machine->uifont2;
                uifontwidth = Machine->uifontwidth * 2;
#ifdef KAILLERA
                if (attr)
                {
                    color = attr[pos];
                    pos += 2;
                }
#endif
            }
            else
#endif
            {
                uifont      = Machine->uifont;
                uifontwidth = Machine->uifontwidth;
#ifdef KAILLERA
                if (attr)
                {
                    color = attr[pos];
                    pos++;
                }
#endif
            }
        }

        if (y >= Machine->uiheight)
            return next_sy;

        if (!wrapped)
        {
#ifdef JAPANESE
            if (code > 0x00ff)
                code -= 256;
#endif

#ifdef KAILLERA
            if (colormode == TRANSPARENCY_PEN)
            {
                if (nChatDrawMode == 1)
                    ui_drawmeshbox(bitmap, x, y, uifontwidth, Machine->uifontheight);
            }
            if (color & ~UI_COLOR_MASK)
            {
                if (pos == *clause)
                {
                    ui_drawline(bitmap, x, y + Machine->uifontheight, uifontwidth - 1, color & ~UI_COLOR_MASK);
                    clause++;
                }
                else
                    ui_drawline(bitmap, x, y + Machine->uifontheight, uifontwidth, color & ~UI_COLOR_MASK);
                color &= UI_COLOR_MASK;
            }
#endif

            drawgfx(bitmap,
                uifont,
                code,
                color,
                0,
                0,
                x + Machine->uixmin,
                y + Machine->uiymin,
                0,
#ifdef KAILLERA
                colormode,
#else
                TRANSPARENCY_NONE,
#endif
                0);

            x += uifontwidth;

            while (increment)
            {
                c++;
                increment--;
            }
        }
    }

    return next_sy;
}
