import random, os, email
from email import base64MIME

import template

class MailData :

	file_id = None
	user_id = None

	directory = {}
	directory["payload"] = None
	directory["cid"] = None

	which = "payload"

	def __init__(self, id) :
		""" """
		self.user_id = id

		self.__set_directory()

		if not self.__check_directory() :
			raise IOError

	def __gen_file_id (self) :

		self.file_id = int(random.random()*1000000000)

		return self.file_id

	def __set_directory (self) :

		# set directory
		self.directory["payload"] = "%s/%s" % \
			(template.directory["www_data"]["payload"], self.user_id)

		self.directory["cid"] = "%s/%s" % \
			(template.directory["www_data"]["cid"], self.user_id)

	def __check_directory (self) :

		# check whether directory exists or not
		if os.path.isdir(self.directory["payload"]) : # payload
			retval = True
		else :
			try :
				os.makedirs(self.directory["payload"])
			except :
				retval = False
			else :
				os.chmod(self.directory["payload"], 0777)
				retval = True

		if retval :
			if os.path.isdir(self.directory["cid"]) : # cid
				retval = True
			else :
				try :
					os.makedirs(self.directory["cid"])
				except :
					retval = False
				else :
					os.chmod(self.directory["cid"], 0777)
					retval = True

		return retval

	def save (self, data, which="payload") :
		"""
		Argument 'data' is encoded data by base64.
		"""

		self.__gen_file_id() # generate file id.

		filename = "%s/%s" % (self.directory[which], self.file_id)
		try :
			f = open(filename, "w")
		except :
			retval = False
		else :
			retval = True

			f.write(base64MIME.decode(data))
			f.close()

		return retval

	def read (self, file_name) :
		"""
		"""
		pass


__author__ =  "Spike^ekipS <spike@spikeekips.net>"
__version__=  "0.1"
__nonsense__ = ""

__file__ = "MailData.py"


