<?

class mail_Message {

	var $msg = false; // entire message.

	var $header = array();

	var $header_boundary = false;
	var $header_content_type = false;

	var $text_body = false;
	var $html_body = false;

	var $payload = array();
	var $cid = array();

	function mail_Message () {
	}

	// read message from strings.
	function from_string ($str) {
		$this->msg = $str;

		$this->__parse_all();
	}

	// read message from file.
	function from_file ($file) {
		$fh = fopen($file, "r");

		if ($fh) {
			while (! feof($fh)) {
				$data .= fgets($fh, 4096);
			}
			fclose($fh);

			$this->msg = $data;
		}

		$this->__parse_all();
	}

	///////////////////////////////////////////////////////////////////////////////
	function __parse_all () {

		// parse header.
		$this->__parse_header();
		$this->__parse_body();
	}

	function __parse_header () {

		$this->header = $this->parse_header($this->msg);

		$this->__parse_header_content_type();
	}

	function __parse_header_content_type () {

		if (array_key_exists("content-type", $this->header)) {
			$a = $this->__parse_field_value($this->header["content-type"]);

			// get boundary
			if ($a["boundary"]) {
				$this->header_boundary = "--" . $a["boundary"];
			}
		}
	}

	function __parse_body () {

		$h = explode("\n\n", $this->msg);
		unset($h[0]);

		$string = implode("\n\n", $h);

		if (! $this->header_boundary) { // it's normal message.

			$a = $this->__parse_field_value($this->header["content-type"]);

			switch ($a[0]) {
				case ("text/html") :
					$n = count($this->html_body) - 1;

					$this->html_body[$n]["data"] = $string;
				break;
				case ("text/plain") :
					$n = count($this->text_body);

					$this->text_body[$n]["data"] = $string;
				break;
			}

		} else { // it's multiparted message.

			$a = explode($this->header_boundary, $string);

			unset($a[count($a) - 1]);
			unset($a[0]);

			// parse body.
			while (list($i, $j) = each($a)) {
				unset($n);
				$b = $this->__parse_body_element($j);

				switch ($b["type"]) {
					case ("text/html") :
						$n = count($this->html_body) - 1;

						$this->html_body[$n]["header"] = $b["header"];
						$this->html_body[$n]["data"] = $b["data"];
					break;
					case ("text/plain") :
						$n = count($this->text_body);

						$this->text_body[$n]["header"] = $b["header"];
						$this->text_body[$n]["data"] = $b["data"];
					break;
					default : // it's payload or cid.

						// it's cid.
						if ($b["header"]["content-id"]) {
							$n = count($this->cid);

							$c = $this->__parse_field_value($b["header"]["content-type"]);
							$d = $this->__parse_field_value($b["header"]["content-disposition"]);

							$this->cid[$n]["mime-type"] = $c[0];
							$this->cid[$n]["filename"] = $d["filename"];
							$this->cid[$n]["id"] =
								ereg_replace("[<>]", "", $b["header"]["content-id"]);

							$this->cid[$n]["header"] = $b["header"];
							$this->cid[$n]["data"] = $b["data"];

						// it's payload
						} else {
							$n = count($this->payload);

							$this->payload[$n]["header"] = $b["header"];
							$this->payload[$n]["data"] = $b["data"];

							// set filename and mime-type.
							$c = $this->__parse_field_value($b["header"]["content-type"]);
							$d = $this->__parse_field_value($b["header"]["content-disposition"]);

							$this->payload[$n]["mime-type"] = $c[0];
							$this->payload[$n]["filename"] = $d["filename"];
						}
				}
			}
		}
	}

	function __parse_body_element ($el) {
		$a = explode("\n\n", $el);

		$header = $this->parse_header($a[0]);

		// parse content-type.
		$c = $this->__parse_field_value($header["content-type"]);
		$body_type = trim($c[0]);
		$body_charset = $c["charset"];

		// parse body data.
		unset($a[0]);
		$b = implode("\n\n", $a);

		switch (strtolower($header["content-transfer-encoding"])) {
			case ("base64") :
				$data = base64_decode($b);
			break;
			default :
				$data = $b;
		}

		$retval["header"] = $header;

		$retval["type"] = $body_type;
		$retval["charset"] = $body_charset;

		$retval["data"] = $data;

		return $retval;

	}

	function __parse_field_value ($value) {

		$c = explode(";", $value);

		while (list($i, $j) = each($c)) {
			$a = explode("=", trim($j));

			if (count($a) > 1) {
				$key = trim($a[0]);
			} else {
				$key = false;
				$var[] = $a[0];
			}

			unset($a[0]);
			$a = trim(ereg_replace("\"", "", implode("=", $a)));

			if ($key) $var[$key] = $a;
		}

		return $var;
	}

	///////////////////////////////////////////////////////////////////////////////
	function parse_header ($string) {

		$c = explode("\n\n", $string);

		$a = explode("\n", $c[0]);

		$h = array();

		while (list($i, $j) = each($a)) {
			if ( eregi("^[a-z][a-z0-9-]*:", $j) ) {
				$b = explode(":", ereg_replace("\n","", $j));

				$key = strtolower($b[0]);
				// key check.
				if (array_key_exists($key, $h)) {
					$h[$key] .= "\n" . eregi_replace("^[a-z][a-z0-9-]*:", "", $j);
				} else {
					$h[$key] = trim(eregi_replace("^[a-z][a-z0-9-]*:", "", $j));
				}
			} else {
				$h[$key] .= ereg_replace("\n","", $j);
			}
		}

		return $h;
	}

	function get_header ($type="array") {

		/*
		parse header information from message body.
		*/

		$header = $this->header;

		switch ($type) {
			case ("string") :
				while (list($i, $j) = each($header)) {
					$a[] = sprintf("%s: %s", $i, $j);
				}
				$retval = implode("\n", $a);
			break;
			default :
				$retval = $this->header;
		}

		return $retval;
	}

	function get_simple_header ($type="array") {
		/*
		To, From, Subject
		*/

		$simple_header["to"] = $this->header["to"];
		$simple_header["from"] = $this->header["from"];
		$simple_header["subject"] = $this->header["subject"];

		switch ($type) {
			case ("string") :
				while (list($i, $j) = each($simple_header)) {
					$a[] = sprintf("%s: %s", $i, $j);
				}
				$retval = implode("\n", $a);
			break;
			default :
				$retval = $simple_header;
		}

		return $retval;
	}

	function get_body () {
		if ($this->text_body) {
			$retval = $this->text_body;
		} else {
			$retval = $this->html_body;
		}

		return $retval;
	}

	function get_cid () {
		$retval = $this->cid;

		return $retval;
	}

	function get_payload () {
		$retval = $this->payload;

		return $retval;
	}

	function get_entire_message () {
		return $this->msg;
	}

}

/*

Author
------
 Spike^ekipS <spike@spikeekips.net>

Changelog
---------

Usage
-----

*/

?>
