<?

include_once $global["root"] . "/lib/Control.php";
include_once $global["root"] . "/lib/Items.php";
include_once $global["root"] . "/lib/Item.php";
include_once $global["root"] . "/lib/Module.php";
include_once $global["root"] . "/lib/Dialog.php";
include_once $global["root"] . "/lib/Directories.php";
include_once $global["root"] . "/lib/Directory.php";
include_once $global["root"] . "/lib/State.php";
include_once $global["root"] . "/lib/Search.php";
include_once $global["root"] . "/lib/Template.php";
include_once $global["root"] . "/lib/Module_card.php";

class Request {

	var $Template;
	var $mode;
	var $entire_page = false;

	function Request () {
		$this->Template = new Template;
	}

	////////////////////////////////////////////////////
	function view ($no) {
		global $global, $string;

		$Item = new Item($no);
		$retval = $Item->view();

		return $retval;
	}

	function edit ($no) {
		global $global, $string;

		$Item = new Item($no);
		$retval = $Item->edit();

		$this->entire_page = true;

		return $retval;
	}

	function add ($no) {
		global $global, $string;

		$Item = new Item();
		$Item->set_module($no);

		$this->entire_page = true;

		$retval = $Item->add();

		return $retval;
	}

	function module_dialog ($no) {
		global $global, $string;

		$Module = new Module($no);

		$retval = $Module->execute("add_dialog");

		return $retval;
	}

	function dialog ($type, $action="", $no="", $control="") {
		global $global, $string;

		if (! $type or $type == "") goprev();

		$Dialog = new Dialog($type, $control);
		$retval = $Dialog->print_return($action, $no);

		return $retval;
	}

	function remove ($no) {
		global $global, $string;

		$Dialog = new Dialog("0");
		$retval = $Dialog->print_return("remove", $no);

		return $retval;
	}

	function drct_select ($action, $items) {
		global $global, $string;

		if ($action != "remove" and $action != "cleanup" and
				$action != "move" and $action != "copy") {
			goprev();
		}

		if (($action == "remove" or $action == "move" or $action == "copy") and
				(count($items) < 1)) {
			goprev();
		}

		if ($_GET["directory"]) $_SESSION["user_directory"] = $_GET["directory"];

		if ($action == "remove" or $action == "cleanup") {
			$Dialog = new Dialog("0");
			$retval = $Dialog->print_return($action, $items);
		} else {
			$Directories = new Directories;
			$retval = $Directories->return_select_box ($action, $items);
		}

		return $retval;
	}

	function control ($control, $no) {
		global $global, $string;

		$Control = new Control;
		$retval = $Control->handle($control, $no);
		$this->entire_page = true;

		return $retval;
	}

	function navigate () {
		global $global, $string;

		$Directories = new Directories;
		$Directories->navigate = true;
		$retval = $Directories->return_list();

		return $retval;
	}

	function drct () {
		global $global, $string;

		$Directories = new Directories;
		$Directories->compact = true;
		$retval = $Directories->return_list();

		return $retval;
	}

	function search_form ($str) {
		global $global, $string;

		$Search = new Search($str);
		$retval = $Search->return_form();

		return $retval;
	}

	function search_result ($str="", $modules="", $case="", $directory_num="") {
		global $global, $string;

		if (! $modules) goprev();

		$Search = new Search($str);
		$retval = $Search->return_result($modules, $case, $directory_num);

		return $retval;
	}

	function return_list ($no="", $st="", $pg="") {
		global $global, $string;

		include_once $global["root"] . "/module/message/function/etc.php";

		if (! $pg or $pg == "") $pg = "0";

		$_SESSION["user_directory"] = "$no";
		$_SESSION["user_page_number"] = "$pg";

		$Directory = new myDirectory($_SESSION["user_directory"]);

		// handling sort method.
		if ($st == "title" or $st == "author" or $st == "createdTime") {
			$State = new State();
			$State->assign_sort($no, $st);
		}

		$Items = new Items();
		$retval = $Items->return_list();

		return $retval;
	}

	function frontpage () {
		$retval = print_frontpage();

		return $retval;
	}

	function handle () {
		global $global, $string;

		extract($_GET);

		switch ($mode) {
			// item
			case ("view") :
				$retval = $this->view($no);
			break;
			case ("edit") :
				$retval = $this->edit($no);
			break;
			case ("add") :
				$retval = $this->add($no);
			break;
			case ("remove") :
				$retval = $this->remove($no);
			break;

			case ("module_dialog") :
				$retval = $this->module_dialog($no);
			break;
			case ("dialog") :
				$retval = $this->dialog($type, $action, $no, $control);
			break;
			case ("drct_select") :
				$retval = $this->drct_select($action, $items);
			break;
			case ("navigate") : // directory management.
				$retval = $this->navigate();
			break;
			case ("drct") : // directory management.
				$this->entire_page = true;
				$retval = $this->drct();
			break;
			case ("control") : // control panel
				$retval = $this->control($control, $no);
			break;

			case ("card_list") :
				include_once $global["root"] . "/lib/Module_card.php";
				$Card = new card;
				$ret["content"] = $Card->return_manage_list($by);

				//$this->entire_page = true;
				$_SESSION["user_menu"] = "card";

				$retval = $this->Template->generate("/module/card/template/list", $ret);
			break;

			case ("search_form") : // search
				$this->entire_page = true;
				$retval = $this->search_form ($str);
			break;
			case ("search_result") :
				$retval = $this->search_result($str, $modules, $case, $directory_num);
			break;

			case ("front") :
				$this->entire_page = true;
				$retval = $this->frontpage();
			break;
			// mode no(directory number) st(sort method) pg (page)
			case ("list") :
				if ($no) {
					$retval = $this->return_list($no, $st, $pg);
				} else if ($_SESSION["user_directory"]) {
					$retval = $this->return_list($_SESSION["user_directory"], $st, $pg);
				} else {
					$this->entire_page = true;
					$retval = $this->frontpage();
				}
			break;
			default :

				if ($no == "" and ! $_SESSION["user_directory"]) {
					$this->entire_page = true;
					$retval = $this->frontpage();
				} else if ($no == "" and $_SESSION["user_directory"] != "") {
					$retval = $this->return_list($_SESSION["user_directory"], $st, $pg);
				} else {
					$retval = $this->return_list($no, $st, $pg);
				}
		}

		if (! $retval or $retval == "") goprev();

		return $retval;
	}
}

/*
Description
-----------

Author
------
 Spike^ekipS <spike@spikeekips.net>

Changelog
---------

Usage
-----

*/

?>
