# -*- coding: utf-8 -*-
import ConfigParser, sys, sre, os

class Config :

	CP = None

	sections = []
	re_1 = sre.compile(" #.*")

	def __init__ (self, filename) :

		self.CP = ConfigParser.ConfigParser()
		self.from_file(filename)

	def from_file (self, filename) :
		fh = open(filename, "r")

		try :
			self.CP.readfp(fh)
		except ConfigParser.ParsingError :
			sys.stderr.writelines("malformed config file, %s\n" % filename)
			sys.exit(1)

	def __read_all (self) :

		self.sections = self.CP.sections()

		retval = True
		value = {}

		for i in self.sections :
			value[i] = self.__read_value_of_sections(i)

			if not value[i] : retval = False

		if retval is not False :
			retval = value

		return retval

	def __read_value_of_sections (self, section) :

		try :
			value = {}
			for i in self.CP.items(section) :
				value[i[0]] = self.re_1.sub("", i[1])
		except ConfigParser.NoSectionError :
			retval = False
		else :
			retval = value

		return retval

	def get_all (self) :
		return self.__read_all()


"""
Description
-----------


ChangeLog
---------


Usage
-----


"""

__author__ =  "Spike^ekipS <spike@spikeekips.net>"
__version__=  "0.1"
__nonsense__ = ""

__file__ = "1.py"



# Mesian is Webmail.
#
# Copyright (C) 2003 Spike^ekipS <spike@spikeekips.net>
#
# Adapted from mesian :
#  Copyright (C) 2003  Spike^ekipS <spike@spikeekips.net>
#
# Contact: mailto:spike@spikeekips.net
# Original site: http://mesian-devel.spikeekips.net/
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Spike^ekipS
#	mailto:spike@spikeekips.net
#
# Original page :
#	http://mesian-devel.spikeekips.net/
#
# Original mesian :
#	Spike^ekipS
#	spike@spikeekips.net
#	Haman Korea


