# -*- coding: utf-8 -*-
import imaplib, string, re

PORT = imaplib.IMAP4_PORT

class Imap :

	Server = None
	message_num_list = []

	message_id = 1

	def __init__ (self) :
		pass

	def connect (self, **kwargs) :

		if not kwargs.has_key("port") :
			port = PORT
		else :
			try :
				port = int(kwargs["port"])
			except :
				port = PORT

		return self.__connect( \
			kwargs["host"], \
			port, \
			kwargs["user"], \
			kwargs["password"] \
		)

	def __connect (self, servername, port, username, password) :
		try :
			self.Server = imaplib.IMAP4(servername, port)
		except :	
			retval = False
		else :
			retval = self.__login(username, password)

			if retval :
				self.Server.select()
				a, b = self.Server.search(None, 'ALL')
				self.num_of_message = len(b[0].split())

		return retval

	def __login (self, username, password) :

		try :
			self.Server.login(username, password)
		except :
			retval = False
		else :
			retval = True

		return retval

	def __remove_all_message (self) :
		typ, data = self.Server.search(None, "ALL")

		remlist = []

		for num in string.split(data[0]) :
			typ, uid = self.Server.fetch(num, "UID")
			mo = re.match(".*\(UID (.*)\).*", uid[0])

			if mo != None :
				uid = mo.groups()[0]
			else :
				uid = None

			remlist = remlist + [uid]

		for i in remlist :
			self.Server.uid("store", i, "FLAGS", "(\Deleted)")

		self.Server.expunge()

	def logout (self) :
		try :
			self.__remove_all_message()

			self.Server.close()
			self.Server.logout()
		except :
			pass

	def fetch_all (self) :

		message = []
		for i in self.num_of_message :
			message.append(self.fetch())

		retval = message

		return retval

	def fetch (self) :

		a, data = self.Server.fetch(self.message_id, "(RFC822)")

		self.message_id += 1

		if data[0] == None :
			retval = False
		else :
			retval = data[0][1]

		return retval

"""
Description
-----------
Example
	M = imaplib.IMAP4()
	M.login(getpass.getuser(), getpass.getpass())
	M.select()
	typ, data = M.search(None, 'ALL')
	for num in data[0].split():
		 typ, data = M.fetch(num, '(RFC822)')
		 print 'Message %s\n%s\n' % (num, data[0][1])
	M.logout()

ChangeLog
---------


Usage
-----


"""

__author__ =  "Spike^ekipS <spike@spikeekips.net>"
__version__=  "0.1"
__nonsense__ = ""

__file__ = "Imap.py"


# Mesian is Webmail.
#
# Copyright (C) 2003 Spike^ekipS <spike@spikeekips.net>
#
# Adapted from mesian :
#  Copyright (C) 2003  Spike^ekipS <spike@spikeekips.net>
#
# Contact: mailto:spike@spikeekips.net
# Original site: http://mesian-devel.spikeekips.net/
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Spike^ekipS
#	mailto:spike@spikeekips.net
#
# Original page :
#	http://mesian-devel.spikeekips.net/
#
# Original mesian :
#	Spike^ekipS
#	spike@spikeekips.net
#	Haman Korea


