# -*- coding: utf-8 -*-
import myMySQLdb, sql

class Statistics :

	__db = None

	def __init__ (self, **kwd) :

		self.__db = kwd["db"]

	def insert_incoming (self, **kwd) :
		"""
		type is,
			spam
			virus
			normal
		"""

		retval = False

		# check argument
		user_id = ""
		domain_id = ""

		if not kwd.has_key("date") : retval = -2
		if not kwd.has_key("size") : retval = -2
		if not kwd.has_key("type") : retval = -2
		if not kwd.has_key("Toaddr") : retval = -2

		if retval != -2 :
			# make db instance
			DB = myMySQLdb.myMySQLdb(self.__db, True)

			# insert into db
			DB.query(sql.SQL_INSERT_STATISTICS_INCOMING % \
				(kwd["date"], kwd["size"], kwd["type"], kwd["Toaddr"]))

			retval = DB.retval
			DB.close()

		return retval

	def insert_outgoing (self, **kwd) :

		retval = False

		# check argument
		if not kwd.has_key("date") : retval = -2
		if not kwd.has_key("size") : retval = -2
		if not kwd.has_key("user_id") : retval = -2
		if not kwd.has_key("Toaddr") : retval = -2

		if retval != -2 :
			# make db instance
			DB = myMySQLdb.myMySQLdb(self.__db, True)

			# insert into db
			DB.query(sql.SQL_INSERT_STATISTICS_INCOMING % \
				(kwd["date"], kwd["size"], kwd["type"], kwd["user_id"], kwd["Toaddr"]))

			retval = DB.retval
			DB.close()

		return retval

"""
Description
-----------
mysql> desc statistics_incoming;
+-----------+-------------+------+-----+---------+----------------+
| Field     | Type        | Null | Key | Default | Extra          |
+-----------+-------------+------+-----+---------+----------------+
| no        | int(6)      |      | PRI | NULL    | auto_increment |
| date      | varchar(11) |      |     |         |                |
| size      | int(11)     |      |     | 0       |                |
| type      | varchar(10) |      |     | 0       |                |
| Toaddr  | tinytext    | YES  |     | NULL    |                |
+-----------+-------------+------+-----+---------+----------------+
5 rows in set (0.05 sec)

mysql> desc statistics_outgoing;
+---------+-------------+------+-----+---------+----------------+
| Field   | Type        | Null | Key | Default | Extra          |
+---------+-------------+------+-----+---------+----------------+
| no      | int(6)      |      | PRI | NULL    | auto_increment |
| date    | varchar(11) |      |     |         |                |
| size    | int(11)     |      |     | 0       |                |
| user_id | varchar(10) | YES  |     | NULL    |                |
| Toaddr  | tinytext    | YES  |     | NULL    |                |
+---------+-------------+------+-----+---------+----------------+
5 rows in set (0.05 sec)

mysql> 


ChangeLog
---------


Usage
-----


"""

__author__ =  "Spike^ekipS <spike@spikeekips.net>"
__version__=  "0.1"
__nonsense__ = ""

__file__ = "Statistics.py"


# Mesian is Webmail.
#
# Copyright (C) 2003 Spike^ekipS <spike@spikeekips.net>
#
# Adapted from mesian :
#  Copyright (C) 2003  Spike^ekipS <spike@spikeekips.net>
#
# Contact: mailto:spike@spikeekips.net
# Original site: http://mesian-devel.spikeekips.net/
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Spike^ekipS
#	mailto:spike@spikeekips.net
#
# Original page :
#	http://mesian-devel.spikeekips.net/
#
# Original mesian :
#	Spike^ekipS
#	spike@spikeekips.net
#	Haman Korea


