import message, sql, myMySQLdb

class Privilege :

	username = None
	domain = None

	user_id = None
	domain_id = None

	db = None

	is_valid_user = False
	is_valid_domain = False

	is_escape_domain = False

	def __init__ (self, db, address) :

		self.db = db

		(self.username, self.domain) = message.parse_address(address)

	def check (self) :

		self.__initializing_value()

		user_no = self.get_user_alias()
		if not user_no :
			self.user_id = self.get_user_id()
		else :
			self.user_id = self.get_user_id(user_no)

		if self.is_valid_user :
			self.domain_id = self.get_domain_id()

	def get_user_alias (self) :

		DB = myMySQLdb.myMySQLdb(self.db)
		DB.query(sql.SQL_CHECK_USER_ALIAS % (self.username, self.domain), True)

		if DB.num_rows < 1 :
			retval = False
		else :
			a = DB.fetch()

			if a["valid"] == "0" :
				retval = False
			else :
				retval = a["user_no"]

		DB.close()

		return retval

	def __initializing_value (self) :
		self.forward = None
		self.is_valid_user = False
		self.is_escape_domain = False

	def get_user_id (self, id=None) :
		""" """

		if id :
			query = sql.SQL_CHECK_USER1 % id
		else :
			query = sql.SQL_CHECK_USER % (self.username, self.domain)

		DB = myMySQLdb.myMySQLdb(self.db)
		DB.query(query, True)

		if DB.num_rows < 1 :
			self.is_vaild_user = False
			retval = None
		else :
			a = DB.fetch()

			self.username = a["name"]
			self.domain = a["domain"]

			if a["valid"] == "0" :
				self.is_valid_user = False
				retval = None
			else :
				self.is_valid_user = True
				retval = a["id"] # set id.

			if a["escape_filter_domain"] == "1" :
				self.is_escape_domain = True
			else :
				self.is_escape_domain = False

			if a["forward"] == "" :
				self.forward = None
			else :
				self.forward = a["forward"]

		DB.close()

		return retval

	def get_domain_id(self) :
		""" """

		DB = myMySQLdb.myMySQLdb(self.db)
		DB.query(sql.SQL_CHECK_DOMAIN % self.domain, True)

		if DB.num_rows < 1 :
			self.is_vaild = False
			retval = None
		else :
			a = DB.fetch()

			if a["valid"] == "0" :
				self.is_valid_domain = False
				retval = None
			else :
				self.is_valid_domain = True
				retval = a["id"]

		DB.close()

		return retval

__author__ =  "Spike^ekipS <spike@spikeekips.net>"
__version__=  "0.1"
__nonsense__ = ""

__file__ = "Privileges.py"

