import sql, strings, myMySQLdb, template, Privilege, MailData

#----------------------------------------------------------------------
class message_db :
	"""
	Description
	-----------
	Insert message into DB.

	ChangeLog
	---------
	Sat Mar  1 16:01:50 KST 2003
	- created.

	Wed Mar 12 04:19:27 KST 2003
	- split from message.py module to messageDB.py

	Usage
	-----

	"""

	result = False # the result, which the state of query. transction code depend on it.

	user_data = False
	db = None
	log = None
	message = {}

	is_valid_user = False
	id = None

	mail_table = {}
	DB = None

	MailData = None

	retval = False

	def __init__ (self, db, unKnown=False, **kwargs) :

		self.db = db

		# escape value
		if not type(kwargs["message"]) == dict :
			raise ValueError, "message is not dict value."

		for i in kwargs["message"].keys() :
			if i == "payload" or i == "cid" :
				self.message[i] = kwargs["message"][i]
				continue

			self.message[i] = myMySQLdb.escape_string("%s" % kwargs["message"][i])

		if unKnown :
			self.is_valid_user = False
			self.MailData = MailData.MailData("unKnown")
		else :
			# check whether valid user or not
			P = Privilege.Privilege(self.db, self.message["address"])
			P.check()

			self.is_valid_user = P.is_valid_user
			self.id = P.user_id

			if self.is_valid_user :
				if not self.__check_tables() :
					self.is_valid_user = False
				else :
					self.__set_table() # set the table name.

					self.MailData = MailData.MailData(P.user_id)

	#-------------------------------------------------- check & set
	def __set_table (self) :

		# assign table name
		for i in template.database["user_table"].keys() :
			self.mail_table[i] = template.database["user_table"][i] % self.id

	def __check_tables (self) :

		DB = myMySQLdb.myMySQLdb(self.db)

		retval = True
		for i in template.database["user_table"].keys() :
			if not DB.query(sql.SQL_TABLE_EXIST % \
					(template.database["user_table"][i] % self.id) ) :
				retval = False
				break

		self.mail_table = {}

		DB.close()

		return retval

	#-------------------------------------------------- insert all
	def insert (self, directory_num=None, message_id=None, message_type=None) :

		self.DB = myMySQLdb.myMySQLdb(self.db, True)

		if not self.is_valid_user :
			is_unKnown = template.database["table"]["entireMessage_unKnown"]
		else :
			is_unKnown = None

		self.insert_entireMessage(is_unKnown)

		if not self.is_valid_user :
			self.insert_message_unKnown()
		elif directory_num :
			self.insert_message(message_id, message_type)
			self.insert_item(directory_num)

		retval = self.DB.retval

		self.DB.close()

		self.DB = None # initiate.

		return retval

	#-------------------------------------------------- insert item
	def insert_item(self, directory_num) :

		if not self.DB.query( \
				sql.SQL_INSERT_ITEM % (self.mail_table["item"], directory_num)) :
			retval = False
		else :
			retval = True

		self.result = retval

		return retval

	#-------------------------------------------------- insert entire message
	def insert_entireMessage(self, table_name=None) :
		"""Insert into entireMessage_NUM"""

		if not table_name : table_name = self.mail_table["entireMessage"]

		if not self.DB.query(sql.SQL_INSERT_ENTIREMESSAGE % \
				(table_name, self.message["entireMessage"], \
					len(self.message["entireMessage"]))) :
			retval = False
		else :
			retval = True

		self.result = retval

		return retval

	#-------------------------------------------------- insert message
	def insert_message_unKnown(self) :
		"""Insert into message_unKnown"""

		if len(self.message["cid"]) < 1 :
			cid = ""
			cidHeader = ""
		else :

			is_saved = True
			__cid = []
			__cidHeader = []

			for i in self.message["cid"].keys() :
				if not self.MailData.save(self.message["cid"][i]["data"], "cid") :
					is_saved = False
					break
				else :
					__cid.append("%s" % self.MailData.file_id)
					__cidHeader.append(self.message["cid"][i]["header"])

			cid = ";".join(__cid)
			cidHeader = ";".join(__cidHeader)

		if len(self.message["payload"]) < 1 :
			payload = ""
			payloadHeader = ""
		else :

			is_saved = True
			__payload = []
			__payloadHeader = []

			for i in self.message["payload"].keys() :
				if not self.MailData.save(self.message["payload"][i]["data"], "payload") :
					is_saved = False
					break
				else :
					__payload.append(self.MailData.file_id)
					__payloadHeader.append(self.message["payload"][i]["header"])

			payload = ";".join(__payload)
			payloadHeader = ";".join(__payloadHeader)

		SQL_STATE = sql.SQL_INSERT_UNKNOWN_MESSAGE % \
			(template.database["table"]["unKnown"], \
				self.message["address"], self.message["header"], \
				self.message["headerSimple"], \
				self.message["textBody"], self.message["htmlBody"], \
				payload, payloadHeader, cid, cidHeader, \
				self.message["isPayload"], self.message["isCid"], \
				self.message["date"])

		if not self.DB.query(SQL_STATE) :
			retval = False
		else :
			retval = True

		self.result = retval

		return retval

	def insert_message(self, message_id=None, message_type=None) :
		""" Insert into mail_NUM """

		# save payload & cid data into filesystem.
		if len(self.message["cid"]) < 1 :
			cid = ""
			cidHeader = ""
		else :

			is_saved = True
			__cid = []
			__cidHeader = []

			for i in self.message["cid"].keys() :
				if not self.MailData.save(self.message["cid"][i]["data"], "cid") :
					is_saved = False
					break
				else :
					__cid.append(str(self.MailData.file_id))
					__cidHeader.append(self.message["cid"][i]["header"])

			cid = ";".join(__cid)
			cidHeader = ";".join(__cidHeader)

		if len(self.message["payload"]) < 1 :
			payload = ""
			payloadHeader = ""
		else :

			is_saved = True
			__payload = []
			__payloadHeader = []

			for i in self.message["payload"].keys() :
				if not self.MailData.save(self.message["payload"][i]["data"], "payload") :
					is_saved = False
					break
				else :
					__payload.append(str(self.MailData.file_id))
					__payloadHeader.append(self.message["payload"][i]["header"])

			payload = ";".join(__payload)
			payloadHeader = ";".join(__payloadHeader)

		# set message type
		if not message_id :
			message_id = "NULL"
		else :
			message_id = "'%s'" % message_id

		if not message_type :
			message_type = "NULL"
		else :
			message_type = "'%s'" % message_type

		SQL_STATE = sql.SQL_INSERT_MESSAGE % \
			(self.mail_table["message"], \
				self.message["header"], self.message["headerSimple"], \
				self.message["textBody"], self.message["htmlBody"], \
				payload, payloadHeader, cid, cidHeader, \
				self.message["isPayload"], self.message["isCid"], \
				self.message["date"], message_type, message_id)

		if not self.DB.query(SQL_STATE) :
			retval = False
		else :
			retval = True

		self.result = retval

		return retval

"""
ChangeLog
---------
Sun Mar  2 14:33:32 KST 2003
- added DB class.

Thu May 15 14:59:50 KST 2003
- add insert_item()

Sat Jun 14 03:49:23 KST 2003
- new design style applied.

"""

__author__ =  "Spike^ekipS <spike@spikeekips.net>"
__version__=  "0.2"
__nonsense__ = ""
__file__ = "message_db.py"

