<?

include_once $global["root"] . "/lib/Page.php";
include_once $global["root"] . "/lib/Module_card.php";
include_once $global["root"] . "/lib/Card_Group.php";

class Extend_card {

	var $Template;
	var $Card;
	var $Item;
	var $Group;

	var $empty = false;
	var $sort_key_list = array("email", "name");

	var $SQL_GET_CARD_GROUP = 
		"select SQL_CACHE no,name from card_group_%s";
	var $SQL_GET_CARD_ITEM = 
		"select SQL_CACHE item from card_group_%s where no = '%s'";
	var $SQL_GET_ALL_CARD = "select SQL_CACHE no from card_%s";

	var $SQL_GET_CARD =
			"select SQL_CACHE
				name, email, work_phone, home_phone, fax, mobile, zip_work, country_work,
				city_work, add_work, title_work, department_work, organization_work,
				zip_home, country_home, city_home, add_home, homepage, comment, date
				from card_%s where no = '%s'";

	function Extend_card ($group_no="", $tihs_page="", $sort_key="") {

		$this->set_params($group_no, $tihs_page, $sort_key);

		// set module.
		$this->Template = new Template;
		$this->Card = new Module_card;
		$this->Item = new Item;
	}

	function set_params ($group_no="", $sort_key="", $this_page="") {
		global $global, $string;

		// assign parameters.

		if ($this_page) {
			$this->this_page = $this_page;
		} else if ($_SESSION["user_card_page_number"]) {
			$this->this_page = $_SESSION["user_card_page_number"];
		} else {
			$this->this_page = "0";
		}

		// set group number.
		if ($group_no == "a") {
			$this->group_no = "a";
		} else if ($group_no) {
			$this->group_no = $group_no;
		} else if ($_SESSION["user_group_no"]) {
			$this->group_no = $_SESSION["user_group_no"];
		}

		$Group = new Card_Group;
		$this->group_name = $Group->get_name($this->group_no);

		if ($sort_key) {
			$this->sort_key = $sort_key;
		} else if (array_key_exists($this->group_no,
				$_SESSION["user_card_group_sort_state"])) {
			$this->sort_key = $_SESSION["user_card_group_sort_state"][$this->group_no];
		} else {
			$this->sort_key = "email";
		}

	}

	function get_items () {
		/*
		return the items as array.
		*/

		$DB = new MySQLdb;

		if ($this->group_no == "a") {
			$DB->query(sprintf($this->SQL_GET_ALL_CARD,
				$_SESSION["config_id"]), true);

			if ($DB->num_rows < 1) {
				$b = false;
			} else {
				for ($i = 0; $i < $DB->num_rows; $i++) {
					$a = $DB->fetch();
					$b[] = $a["no"];
				}
			}

			$retval = $b;

		} else if ($this->group_no) {
			$o = $DB->fetch_one(
				sprintf($this->SQL_GET_CARD_ITEM,
					$_SESSION["config_id"], $this->group_no)
			);

			if (! $o["item"]) {
				$retval = false;
			} else {
				$retval = __return_array_for_card_group_item($o["item"]);
			}
		}

		return $retval;
	}

	function get_list ($items) {

		while (list($i, $j) = each($items)) {

			// make list line.
			$item_no = $this->Item->get_no($j, "3");
			$o = $this->Card->info($j);

			$var["item_no"][$j] = $item_no;

			$var["no"][$j] = $j;
			$var["group_no"][$j] = $this->group_no;
			$var["email"][$j] = $o["title"];
			$var["name"][$j] = $o["author"]["short"];
			$var["createdTime"][$j] = print_time($o["createdTime"], "simple");
		}

		return $var;
	}

	function sort_list ($list) {

		if (array_key_exists("user_card_group_sort_state_key", $_SESSION)) {
			if (! array_key_exists($this->group_no,
					$_SESSION["user_card_group_sort_state_key"])) {
				asort($list[$this->sort_key]);
			} else {
				if ($_SESSION["user_card_group_sort_state_key"][$this->group_no] == "r") {
					arsort($list[$this->sort_key]);
				} else if
						($_SESSION["user_card_group_sort_state_key"][$this->group_no] == "o") {
					asort($list[$this->sort_key]);
				} else {
					arsort($list[$this->sort_key]); // default key is createdTime.
				}
			}

			reset($list[$this->sort_key]);
		}

		return $list;
	}

	function get_normal_list ($group_no="", $sort_key="", $this_page="") {
		$DB = new MySQLdb;

		$this->set_params($group_no, $sort_key, $this_page);

		// get all item.
		$all_items = $this->get_items();

		$main["group_no"] = $this->group_no;

		// handling sort key.
		$a = $this->sort_key_list;
		while (list($i, $j) = each($a)) {
			if ($this->sort_key == $j) {
				if ($_SESSION["user_card_group_sort_state_key"][$this->group_no] ==
						"o") {
					$icon = "module/item/image/sort_descending-25.png";
				} else if ($_SESSION["user_card_group_sort_state_key"][$this->group_no]
						== "r") {
					$icon = "module/item/image/sort_ascending-25.png";
				} else { // sort by createdTime
					$icon = "module/item/image/sort_default-25.png";
				}
			} else {
				$icon = "module/item/image/sort_default-25.png";
			}

			$main["label_sort_key_" . $j] =
				sprintf("%s/%s", $_SESSION["user_global_url"], $icon);
		}

		if (! $all_items) { // no item in here.
			$this->empty = true;

			$main["content"] = $this->Template->generate(
						"module/card/template/card_list_empty"
					);
		} else {
			// set page numbering.
			$this->Page =
				new Page_card($this->group_no, count($all_items), $this->this_page);

			$list = $this->sort_list($this->get_list($all_items));

			while (list($i, $j) = each($list[$this->sort_key])) {

				unset($one);

				$one["group_no"] = $this->group_no;
				$one["no"] = $list["no"][$i];
				$one["email"] = $list["email"][$i];
				$one["name"] = $list["name"][$i];

				$main["content"] .=
					$this->Template->generate(
						"module/card/template/card_list_one", $one);
			}

			//-------------------- card list label sorting key icon
		}

		$retval = $this->Template->generate("module/card/template/card_list",$main);

		return $retval;
	}

	function return_list ($group_no="", $sort_key="", $this_page="") {

		// get core list.
		$main["content"] = $this->get_normal_list($group_no, $sort_key, $this_page);
		$main["group_no"] = $this->group_no;

		// etc
		$main["group_name"] = $this->group_name;

		// item list menu
		if ($this->group_no == "a") $is_group_all = "_group_all";

		if ($this->empty) {
			$item_list_menu_template =
				sprintf("/module/card/template/action_menu_not_active%s", $is_group_all);
		} else {
			$item_list_menu_template =
				sprintf("/module/card/template/action_menu%s", $is_group_all);
		}

		// item list sub-menu
		if ($this->empty) {
			$item_list_menu_sub_template =
				sprintf("/module/card/template/action_menu_sub_not_active%s", $is_group_all);
		} else {
			$item_list_menu_sub_template =
				sprintf("/module/card/template/action_menu_sub%s", $is_group_all);
		}

		$main["item_list_menu"] = $this->Template->generate($item_list_menu_template);
		$main["item_list_menu_sub"] =
			$this->Template->generate($item_list_menu_sub_template);

		// page numbering
		if (! $this->empty) {
			// print page list.
			if ($this->Page->card_total_num > $_SESSION["config_pageLimit"]) {
				$main["page_list"] = $this->Page->print_list();
			}
		}

		$retval = $this->Template->generate("/module/card/template/list", $main);

		return $retval;
	}

	// return left side menu.
	function return_menu () {
		$DB = new MySQLdb;

		$DB->query(sprintf($this->SQL_GET_CARD_GROUP, $_SESSION["config_id"]), true);

		for ($i = 0; $i < $DB->num_rows; $i++) {
			$o = $DB->fetch();

			unset($var);
			$var["name"] = $o["name"];
			$var["group_no"] = $o["no"];

			$group["content"] .= $this->Template->generate(
					"module/card/template/card_menu_group_list_one",
					$var
				);
		}

		$main["group"] = $this->Template->generate(
				"module/card/template/card_menu_group_list", $group);
		$main["module"] = $this->Template->generate(
				"module/card/template/card_menu_module");

		$retval = $this->Template->generate( "module/card/template/card_menu", $main);

		return $retval;
	}

	function view ($no, $group_no="") {

		// set group number.
		if ($group_no == "a") {
			$this->group_no = "a";
		} else if ($group_no) {
			$this->group_no = $group_no;
		} else if ($_SESSION["user_group_no"]) {
			$this->group_no = $_SESSION["user_group_no"];
		}

		$item_no = $this->Item->get_no($no, "3");
		$o = $this->Card->view($no, $item_no);

		return $o;
	}

}

/*
Description
-----------

Author
------
 Ekips, Bae <spike@orangeware.net>

Changelog
---------

Usage
-----

*/

?>
