<?

include_once $global["root"] . "/lib/Domain.php";

class Authentication {

	var $authenticated = false;

	var $username;
	var $domain;

	var $SQL_FIND_USER =
			"select SQL_CACHE password, valid from user_priv
				where name = '%s' and domain = '%s'";

	function Authentication ($address=false) {
		if ($address) {
			$this->set_address($address);
		} else {
			$this->domain = $_SERVER["HTTP_HOST"];
		}
	}

	function set_address ($address) {
		$c = split("@", $address);
		$this->username = $c[0];
		$this->domain = $c[1];
	}

	function check () {
		global $global;

		if (! $_SESSION["user_authenticated"]) {
			$this->logout();
		}

		if ($_SESSION["config_timeout"] > 0) {
			$this->set_keepalive();
		}
	}

	function assign () {
		if (array_key_exists("config_timeout", $_SESSION)) {
			$_SESSION["config_timeout"] = 0;
		}
	}

	function escape ($method="_GET") {

		if (is_array(${$method}) and ${$method}) {
			$this->logout();
		}
	}

	function set_keepalive () {

		if (mktime() < $_SESSION["user_timeout"]) {
			$_SESSION["user_timeout"] = mktime() + $_SESSION["config_timeout"];
		} else {
			$this->logout();
		}
	}

	function logout () {
		global $global, $string;

		$this->authenticated = false;

		session_destroy();

		@mysql_close();

		Header (sprintf("Location: http://%s/login", $_SERVER["HTTP_HOST"]));
		exit;
	}

	function verify ($password) {
		/*
		return value
			false	: unregistered user
			true	: valid user
			-2		: postmaster user
		*/

		$DB = new MySQLdb;

		$this->authenticated = false;

		$DM = new Domain;
		$is_valid = $DM->get_valid($this->domain);

		if (! $is_valid) {
			$this->authenticated = false;
			$retval = false;
		} else {
			// postmaster
			if ($this->username == "postmaster") {
				$a = $this->get_domain_value();
				$b = sha1($password);

				//-------------------------------------------------- pre-handling
				if ($b != $a["password"]) {
					$this->authenticated = false;
					$retval = false;
				} else {

					if ($a["valid"] == "0") {
						$this->authenticated = false;
						$retval = false;
					} else {
						$this->authenticated = true;

						$retval = -2;
					}
				}

			// normal user
			} else {
				$a = $DB->fetch_one(sprintf($this->SQL_FIND_USER,
					$this->username, $this->domain));
				$b = sha1($password);

				//-------------------------------------------------- pre-handling
				if ($b != $a["password"]) {
					$this->authenticated = false;
					$retval = false;
				} else {

					if ($a["valid"] == "0") {
						$this->authenticated = false;
						$retval = 2;
					} else {
						$this->authenticated = true;
						$retval = true;
					}
				}

			}
		}

		return $retval;
	}

	function get_global_value () {

		$Globals = new Globals;
		$retval = $Globals->get_info();

		return $retval;
	}

	function get_domain_value () {

		$Domain = new Domain;
		$retval = $Domain->get_info($this->domain);

		return $retval;
	}

	function get_user_value () {

		$User = new User;
		$retval = $User->get_info_by_address($this->username, $this->domain);

		return $retval;
	}

	function remove () {

		while (list($i, $j) = each($_SESSION)) {
			if (! ereg("^config_", $i)) continue;
			unset($_SESSION[$i]);
		}
	}

}

/*
Description
-----------

Author
------
 Spike^ekipS <spike@spikeekips.net>

Changelog
---------

Usage
-----

*/

?>
