<?

include_once $global["root"] . "/module/message/function/etc.php";

class Basic_Doc {

	var $SQL_GET_ITEM =
		"select SQL_CACHE realname, storedname, size, mime_type, author,
			date, comment, title, flag from doc_%s where no = '%s'";
	var $SQL_INSERT_ITEMS_TO_MODULE =
		"insert into doc_%s
				(realname, storedname, size, mime_type, author, date, comment, title, flag)
				values ('%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s')";
	var $SQL_GET_DOC = "select SQL_CACHE
				realname, storedname, size, mime_type, author, date, comment, title, flag
				from doc_%s where no = '%s'";
	var $SQL_REMOVE_DOC_ITEM = "delete from doc_%s where no = '%s'";
	var $SQL_SEARCH_DOC = "select SQL_CACHE no from doc_%s where no = '%s' and (%s)";
	var $SQL_GET_SIZE = "select SQL_CACHE sum(size) as size from doc_%s where %s";

	function Module_Doc () {
		$this->Template = new Template;
	}

	// $no is directory number.
	function add ($directory_num) {
		global $global, $string;

		$a["directory_num"] = $directory_num;

		$retval = $this->Template->generate("/module/doc/template/add", $a);

		return $retval;
	}

	function copy ($no) {

		$DB = new MySQLdb;

		//------------ fetch from original data.
		$c = $DB->fetch_one(sprintf($this->SQL_GET_ITEM, $_SESSION["config_id"], $no));
		//------------

		if (! $c["realname"]) {
			$retval = false;
		} else {
			//------------ insert same data into doc_%s.
			$DB->query(sprintf($this->SQL_INSERT_ITEMS_TO_MODULE,
				$_SESSION["config_id"],
					addslashes($c["realname"]), addslashes($c["storedname"]),
					$c["size"], addslashes($c["mime_type"]),
					addslashes($c["author"]), $c["date"],
					addslashes($c["comment"]), addslashes($c["title"]),
					$c["flag"]));

			$retval = $DB->retval;
		}

		if ($retval) {
			$a = $DB->fetch_one("select LAST_INSERT_ID() as id");
			$retval = $a["id"];
		}

		return $retval;
	}

	function edit ($no) {
		global $global, $string;

		$DB = new MySQLdb;

		// db
		$a = $DB->fetch_one(sprintf($this->SQL_GET_DOC, $_SESSION["config_id"], $no));

		$Address = new Address($a["author"]);
		$b = $Address->return_split();
		$a = escapeHTMLCode($a);

		// data handling
		$main["author"] = $b["short"];
		$main["email"] = $b["full"];
		$main["comment"] = $a["comment"];
		$main["title"] = $a["title"];
		$main["realname"] = $a["realname"];
		$main["doc_num"] = $no;
		$main["old_filename"] = $a["storedname"];

		$main["directory_num"] = $_SESSION["user_directory"];

		$retval = $this->Template->generate("/module/doc/template/edit", $main);

		return $retval;
	}

	function info ($num) {
		global $global, $string;

		$DB = new MySQLdb;

		$o = $DB->fetch_one(sprintf($this->SQL_GET_DOC, $_SESSION["config_id"], $num));

		if (! is_array($o)) {
			$a = false;
		} else {
			if(trim($o["author"]) == "") {
				$author = $_SESSION["user_name"];
			} else {
				$author = $o["author"];
			}

			$a["title"] = sprintf("%s (%s)", $o["title"], htmlspecialchars($o["realname"]));

			$a["createdTime"] = $o["date"];

			$a["author"]["short"] = $o["author"];
			$a["author"]["full"] = $o["email"];
			$a["flag"] = $o["flag"];
		}

		$retval = $a;

		return $retval;
	}

	function remove ($no) {

		$DB = new MySQLdb;

		$DB->query(sprintf($this->SQL_REMOVE_DOC_ITEM, $_SESSION["config_id"], $no));

		$retval = $DB->retval;

		return $retval;
	}

	function search ($str, $data, $case="", $all="0") {
		global $global, $string;

		$DB = new MySQLdb;
		$Directory = new myDirectory;

		if ($all != "1") {
			$a = preg_split("/ \t*/", $str);

			$col = array("realname", "author", "comment", "title");

			if ($case) {
				while (list($i, $j) = each($col)) {
					$c[] = sprintf("%s regexp binary '%s'", $j, $str);
				}
			} else {
				$b = "%" . addslashes(implode("%", $a)) . "%";
				while (list($i, $j) = each($col)) {
					$c[] = sprintf("%s like '%s'", $j, $b);
				}
			}

			$d = implode(" or ", $c);
		}

		while (list($i, $j) = each($data)) {

			if ($all != "1") {
				$o = $DB->fetch_one(
					sprintf($this->SQL_SEARCH_DOC, $_SESSION["config_id"], $i, $d));

				if (! $o["no"]) continue;
			}

			$b = $this->info($i);

			//--------------------------------------------------
			// data handling
			$c["createdTime"] = print_time($b["createdTime"], "simple");

			if ($b["author"]["short"]) {
				$c["author"] = $b["author"]["short"];
			} else {
				$c["author"] = $b["author"]["full"];
			}

			$c["title"] = sprintf("<a href=\"%s/mail?no=%s&mode=view\">%s</a>",
				$_SESSION["user_www_url"], $j["no"], htmlspecialchars($b["title"]));

			$c["icon"] = sprintf("<img class=\"mesian\" src=\"%s/module/doc/image/content_type-25.png\">",
				$_SESSION["user_www_url"]);

			$Directory->no = $j["directory_num"];

			$c["directory"] =
				sprintf("<a href=\"%s/mail?no=%s\">%s</a>",
					$_SESSION["user_www_url"], $j["directory_num"],
					$Directory->get_name());
			//--------------------------------------------------

			$main["content"] .=
				$this->Template->generate("/module/item/template/search_result_line", $c);
		}

		$main["module_name"] = "Document";

		$retval =
			$this->Template->generate("/module/item/template/search_result_module", $main);

		return $retval;
	}

	function size ($no) {

		$DB = new MySQLdb;

		if (! is_array($no)) {
			$a = sprintf("no = '%s'", $no);
		} else {
			while (list($i, $j) = each($no)) {
				$b[] = sprintf("no = '%s'", $j);
			}
			$a = sprintf("(%s)", implode(" or ", $b));
		}

		$o = $DB->fetch_one(sprintf($this->SQL_GET_SIZE, $_SESSION["config_id"], $a));

		$retval = $o["size"];

		return $retval;
	}

}

/*
Description
-----------

Author
------
 Spike^ekipS <spike@spikeekips.net>

Changelog
---------

Usage
-----

*/

?>
