<?
include_once $global["root"] . "/lib/Item.php";

class myDirectory {

	var $DB;
	var $no;

	var $parent = "0";
	var $depth = "1";
	var $esc;
	var $mark = "-";

	var $compact = false;

	var $action;
	var $items;

	//-------------------------------------------------- sql
	var $SQL_INSERT_DIRECTORY =
			"insert into directory_%s (name, parent) values('%s','%s')";
	var $SQL_DELETE_DIRECTORY = "delete from directory_%s where no = '%s'";
	var $SQL_DELETE_DIRECTORY1 = "delete from directory_%s where %s";
	var $SQL_GET_PARENT = "select SQL_CACHE no,parent from directory_%s";
	var $SQL_RENAME_DIRECTORY =
			"update directory_%s set name = '%s' where no = '%s'";
	var $SQL_DIRECTORY_NAME_BY_ITEM =
			"select SQL_CACHE directory_num from item_%s
				where item_num = '%s' and item_type = '%s'";
	var $SQL_GET_DIRECTORY_NAME =
			"select SQL_CACHE name from directory_%s where no = '%s'";
	var $SQL_GET_DIRECTORY_CONFIG =
			"select SQL_CACHE %s from directory_%s where no = '%s'";
	var $SQL_GET_PARENT_DIRECTORY =
			"select SQL_CACHE name, parent from directory_%s where no = '%s'";
	var $SQL_GET_NUM_ITEMS =
			"select SQL_CACHE count(no) as nums from item_%s
				where directory_num = '%s'";
	var $SQL_GET_SUBDIRECTORY =
			"select SQL_CACHE no, name from directory_%s where parent = '%s'";
	var $SQL_GET_DIRECTORY =
			"select SQL_CACHE no from directory_%s";
	var $SQL_DIRECTORY_LIST =
			"select SQL_CACHE no, item_type, item_num
				from item_%s where directory_num = '%s'";

	var $system;

	//================================================== constructor
	function myDirectory ($no="0") {
		global $global;

		if ($no != "") $this->no = "$no";

		$this->system = array_flip($global["directory"]);
	}

	//-------------------------------------------------- directory action.
	// call this method first before you do some action.
	function set_DB () {
		$DB = new MySQLdb;
	}

	function is_system ($no="") {
		global $global;

		if (! $no) $no = "$this->no";

		$a = array_flip($global["directory"]);

		if (array_key_exists($no, $a) or ! $no) {
			$retval = true;
		} else {
			$retval = false;
		}

		return $retval;
	}

	function add ($name) {
		global $global;

		$DB = new MySQLdb;

		// add directory in mydirectory.
		if (! $this->no) $this->no = $global["directory"]["mydirectory"];

		$directory_name = addslashes(htmlspecialchars(trim($name)));

		$DB->query(sprintf($this->SQL_INSERT_DIRECTORY,
				$_SESSION["config_id"], $directory_name, $this->no));

		$retval = $DB->retval;

		return $retval;

	}

	function remove_item ($no) {

		$DB = new MySQLdb;

		// -------------------------------------------------- move items to trash.
		$DB->query(sprintf($this->SQL_DIRECTORY_LIST,
			$_SESSION["config_id"], $no), true);

		$Item = new Item();
		for ($i = 0; $i < $DB->num_rows; $i++) {
			$o = $DB->fetch();

			$Item->set($o["no"]);
			$Item->remove(false);
		}
	}

	function remove () {
		global $global;

		$a = array_flip($global["directory"]);

		if (array_key_exists($this->no, $a)) {
			$retval = false;
		} else {
			$DB = new MySQLdb;

			$this->remove_item($this->no);

			$DB->query(sprintf($this->SQL_DELETE_DIRECTORY,
				$_SESSION["config_id"], $this->no));

			if ($DB->retval) {
				$this->remove_orphan(); // remove all sub directories.
			}
			
			$retval = $DB->retval;
		}

		return $retval;

	}

	function remove_orphan () {

		$DB = new MySQLdb;

		$a = $this->get_orphan(); // remove all sub directories.

		if (! is_array($a)) {
			$DB->retval = true;
			$retval = true;
		} else {
			while (list($i, $j) = each($a)) {
				$b[] = sprintf("no = '%s'", $i);

				$this->remove_item($j);
			}

			$c = implode(" or ", $b);

			// remove
			$DB->query(sprintf($this->SQL_DELETE_DIRECTORY1,
				$_SESSION["config_id"], $c));

			$retval = $DB->retval;
		}

		return $retval;
	}

	function rename ($new_name) {

		$DB = new MySQLdb;
		$name = addslashes(htmlspecialchars(trim($new_name)));

		$DB->query(sprintf($this->SQL_RENAME_DIRECTORY,
			$_SESSION["config_id"], $name, $this->no));

		return $retval;

	}

	//-------------------------------------------------- get info.

	function get_orphan () {

		$DB = new MySQLdb;

		$DB->query(sprintf($this->SQL_GET_PARENT,
			$_SESSION["config_id"]), true);

		for ($i = 0; $i < $DB->num_rows; $i++) {
			$a = $DB->fetch();
			$b[$a["no"]] = $a["parent"];
		}

		if (! is_array($b)) {
			$retval = false;
		} else {
			while (list($i, $j) = each($b)) {
				if ($j == "0") continue;

				if ($orphan) {
					if (array_key_exists($j, $orphan)) {
						$orphan[$i] = $j;
					}
				}

				if (!array_key_exists($j, $b)) {
					$orphan[$i] = $j;
				}
			}

			$retval = $orphan;
		}

		return $retval;
	}

	function get_name ($no=False) {
		global $global, $string;

		$DB = new MySQLdb;

		if ($no) $this->no = $no;
		if (! $this->no) $this->no = "0";

		if ($this->no == "0") {
			$retval = $string["item16"];
		} else {

			$g = array_flip($global["directory"]);

			if (array_key_exists($this->no, $g)) {
				$retval = $string["directory" . $this->no];
			} else {
				$a = $DB->fetch_one(sprintf($this->SQL_GET_DIRECTORY_NAME,
						$_SESSION["config_id"], $this->no));

				$retval = $a["name"];
			}
		}

		return $retval;
	}

	function get_name_by_module ($item_num, $item_type) {

		$DB = new MySQLdb;
		$DB->query(sprintf($this->SQL_DIRECTORY_NAME_BY_ITEM,
			$_SESSION["config_id"], $item_num, $item_type), true);

		for ($i = 0; $i < $DB->num_rows; $i++) {
			$o = $DB->fetch();

			$this->no = $o["directory_num"];
			$a[] = array("name" => $this->get_name(), "no" => $o["directory_num"]);
		}

		$retval = $a;

		return $retval;

	}

	function get_parent () {

		$DB = new MySQLdb;
		$retval = $DB->fetch_one(sprintf($this->SQL_GET_PARENT_DIRECTORY,
				$_SESSION["config_id"], $this->no));

		return $retval;
	}

	function get_parent_list () {

		$DB = new MySQLdb;

		if ($this->no == "0") {
			$retval = false;
		} else {
			$b[] = $this->no;
			$a = $this->get_parent();
			$b[] = $a["parent"];

			while ($a["parent"] != "0" and $a["parent"]) {

				$this->no = $a["parent"];
				$a = $this->get_parent();
				$b[] = $a["parent"];
			}

			sort($b);
			reset($b);

			$retval = $b;
		}

		return $retval;
	}

	function get_nums_item () {

		$DB = new MySQLdb;
		$a = $DB->fetch_one(sprintf($this->SQL_GET_NUM_ITEMS,
			$_SESSION["config_id"], $this->no));

		$retval = $a["nums"];

		return $retval;
	}

	function get_info_subdirectory () {

		$DB = new MySQLdb;

		if (! $this->no) $this->no = "0";

		$DB->query(sprintf($this->SQL_GET_SUBDIRECTORY,
				$_SESSION["config_id"], $this->no), true);

		for ($i = 0; $i < $DB->num_rows; $i++) {
			$o = $DB->fetch();

			while (list($j, $k) = each($o)) {
				$a[$o["no"]][$j] = $k;
			}
		}

		$retval = $a;

		return $retval;
	}

	function get_total_size () {

		$DB = new MySQLdb;

		$DB->query(sprintf($this->SQL_GET_DIRECTORY,
				$_SESSION["config_id"]), true);

		for ($i = 0; $i < $DB->num_rows; $i++) {
			$o = $DB->fetch();

			$this->no = $o["no"];
			$a += $this->get_size();
		}

		$retval = $a;

		return $retval;
	}

	// $no : directory number
	function get_size () {
		global $global, $string;

		$DB = new MySQLdb;
		$DB->query(sprintf($this->SQL_DIRECTORY_LIST,
			$_SESSION["config_id"], $this->no), true);

		$Item = new Item();

		for ($i = 0; $i < $DB->num_rows; $i++) {
			$o = $DB->fetch();

			$a[$o["item_type"]][] = $o["item_num"];
		}

		if (count($a) < 1) {
			$c = 0;
		} else {
			while (list($i, $j) = each($a)) {
				$b = $Item->get_size($j, $i);
				if (! $b) continue;

				$c += $b;
			}
		}

		$retval = $c;

		return $retval;

	}
}

/*
Description
-----------

Author
------
 Spike^ekipS <spike@spikeekips.net>

Changelog
---------

Usage
-----

*/

?>
