<?

include_once $global["root"] . "/lib/Card_Group.php";

class Basic_Card_Group {

	var $SQL_UPDATE_CARD_GROUP = "update card_group_%s set item = '%s' where no = '%s'";
	var $SQL_ADD_GROUP = "insert into card_group_%s (name) values ('%s')";
	var $SQL_RENAME_GROUP = "update card_group_%s set name = '%s' where no = '%s'";
	var $SQL_REMOVE_GROUP = "delete from card_group_%s where no = '%s'";

	function add ($name) {

		if (trim($name) == "") {
			$retval = false;
		} else {
			$DB = new MySQLdb;

			$name = escape_string(trim($name));

			$DB->execute_query(
				sprintf($this->SQL_ADD_GROUP, $_SESSION["config_id"], $name)
			);

			$retval = $DB->retval;
		}

		return $retval;
	}

	function rename ($no, $name) {
		if (trim($name) == "") {
			$retval = false;
		} else {
			$DB = new MySQLdb;

			$name = escape_string(trim($name));

			$DB->execute_query(
				sprintf($this->SQL_RENAME_GROUP, $_SESSION["config_id"], $name, $no)
			);

			$retval = $DB->retval;
		}

		return $retval;
	}

	function remove ($no) {

		$DB = new MySQLdb;

		$DB->execute_query(
			sprintf($this->SQL_REMOVE_GROUP, $_SESSION["config_id"], $no)
		);

		$retval = $DB->retval;

		return $retval;
	}

	function move_item ($src_group_no, $dst_group_no, $items) {

		$retval = $this->remove_item($src_group_no, $items);

		if ($retval) {
			$retval = $this->add_item($dst_group_no, $items);
		}

		return $retval;
	}

	function remove_item_in_all_group ($items) {
		global $global;

		include_once $global["root"] . "/lib/Item.php";

		$Card = new Card_Group;
		$list = $Card->get_list();

		// remove this items in group.
		$retval = true;
		while (list($i, $j) = each($list)) {
			if ($retval) $retval = $this->remove_item($i, $items);
		}

		// remove this items in item_%s really.
		if ($retval) {
			$list = __return_array_for_card_group_item($items);
			$Item = new Item;

			while (list($i, $j) = each($list)) {
				$item_no = $Item->get_no($j, $_SESSION["user_item_type_rv"]["card"]);

				$Item->set($item_no, $j, $_SESSION["user_item_type_rv"]["card"]);
				$Item->remove();
			}
		}

		return $retval;
	}

	function remove_item ($group_no, $items) {

		// get item list from group_no.
		$Card = new Card_Group;
		$o = $Card->get_info($group_no);

		// generate item list.
		if (! is_array($o["item"])) {
			$retval = true;
		} else {

			if (count(__return_array_for_card_group_item($o["item"])) < 1) {
				$retval = true;

			} else {
				$var =
					__remove_item(__return_array_for_card_group_item($items), $o["item"]);

				$DB = new MySQLdb;

				$DB->query(sprintf(
						$this->SQL_UPDATE_CARD_GROUP, $_SESSION["config_id"],
						sprintf(",%s", implode(",", $var)),
						$group_no
					)
				);

				$retval = $DB->retval;
			}
		}

		return $retval;
	}

	function add_item ($group_no, $items) {

		// get item list from group_no.
		$Card = new Card_Group;
		$o = $Card->get_info($group_no);

		// generate item list.
		$var = __add_item($o["item"],
			__return_array_for_card_group_item($items));

		$DB = new MySQLdb;

		$DB->query(sprintf(
				$this->SQL_UPDATE_CARD_GROUP, $_SESSION["config_id"],
				sprintf(",%s", implode(",", $var)),
				$group_no
			)
		);

		$retval = $DB->retval;

		return $retval;
	}

}

/////////////////////////////////////////////////////////
// check and calculate item in card_group table.

function __add_item ($new_array, $org_array) {
	$e = array_unique(array_merge($new_array, $org_array));

	sort($e);

	return $e;
}

function __remove_item ($new_array, $dst_array) {

	$f = array_intersect($dst_array, $new_array);
	$g = array_diff($dst_array, $f);

	sort($g);

	return $g;
}

/*
Description
-----------

Author
------
 Ekips, Bae <spike@orangeware.net>

Changelog
---------

Usage
-----

*/

?>
