<?

include_once $global["root"] . "/lib/Mail_Message.php";
include_once $global["root"] . "/lib/MySQLdb.php";
include_once $global["root"] . "/lib/Payload.php";
include_once $global["root"] . "/lib/Cid.php";

class Extend_message {

	var $message;
	var $message_id;

	var $DB;

	function Extend_message () {
		$this->DB = new MySQLdb;
	}

	function insert_message_into_sent_directory ($message, $message_id) {

		$this->message = $message;
		$this->message_id = $message_id;

		$this->DB->transaction_start(true);

		$this->insert_into_entireMessage(); // insert into entireMessage table.
		$this->insert_into_mail(); // insert into mail table.
		$this->insert_into_item(); // insert into item table.

		$retval = $this->DB->retval;
		$this->DB->close();

		return $retval;
	}

	function insert_into_mail () {

		$M = new Mail_Message;
		$M->from_string($this->message);

		//////////// make cid header
		if (count($M->cid) < 1) {
			$headerCid = "";
			$isCid = "0";
		} else {
			$Cid = new Cid;

			while (list($i, $j) = each($M->cid)) {
				$hc[] =
					sprintf("%s:%s:%s",
						$M->cid[$i]["mime-type"], $M->cid[$i]["filename"], $M->cid[$i]["id"]
					);

				$fc[] = $Cid->save($M->cid[$i]["data"]);
			}

			$headerCid = implode(";", $hc);
			$isCid = "1";
			$cid_name = implode(";", $fc);
		}

		//////////// make payload header
		if (count($M->payload) < 1) {
			$headerPayload = "";
			$isPayload = "0";
		} else {
			$Payload = new Payload;

			while (list($i, $j) = each($M->payload)) {
				$hp[] =
					sprintf("%s:%s",
						$M->payload[$i]["mime-type"], $M->payload[$i]["filename"]
					);

				// save payload
				$fp[] = $Payload->save($M->payload[$i]["data"]);
			}

			$headerPayload = implode(";", $hp);
			$isPayload = "1";
			$payload_name = implode(";", $fp);
		}

		////////// make query.
		$SQL_INSERT_SENT_MESSAGE =
			"insert into mail_%s
				(header, headerSimple, textBody, htmlBody, payload, headerPayload,
					cid, headerCid, entireMessage, isPayload, isCid, date,
					type, message_id)
			values (
				'%s', '%s',
				'%s', '%s',
				'%s', '%s', '%s',
				'%s', LAST_INSERT_ID(), '%s', '%s', '%s', 'sent', '%s')";

		$query =
			sprintf($SQL_INSERT_SENT_MESSAGE,
				$_SESSION["config_id"],
				escape_string($M->get_header("string")),
				escape_string($M->get_simple_header("string")),
				escape_string($M->text_body[0]["data"]),
				escape_string($M->html_body[0]["data"]),
				escape_string($payload_name),
				escape_string($headerPayload),
				escape_string($cid_name),
				escape_string($headerCid),
				escape_string($isPayload),
				escape_string($isCid),
				mktime(),
				escape_string($this->message_id)
			);

		$this->DB->execute_query($query);
	}

	function insert_into_item () {
		global $global;

		$SQL_INSERT_ITEM =
			"insert into item_%s
					(item_type, item_num, directory_num)
				values('%s', LAST_INSERT_ID(), '%s')";

		$query =
			sprintf(
				$SQL_INSERT_ITEM,
					$_SESSION["config_id"],
					$_SESSION["user_item_type_rv"]["message"],
					$global["directory"]["sent"]
			);

		$this->DB->execute_query($query);

	}

	function insert_into_entireMessage () {

		$SQL_INSERT_ENTIREMESSAGE =
			"insert into mail_entireMessage_%s (message, size) values('%s', '%s')";

		$query =
			sprintf(
				$SQL_INSERT_ENTIREMESSAGE,
					$_SESSION["config_id"],
					escape_string($this->message),
					strlen($this->message)
			);

		$this->DB->execute_query($query);
	}

}

class Control_Message {

	var $SQL_GET_FILTER_NAME =
		"select SQL_CACHE no, name from mail_filter_%s order by sequence";
	var $SQL_GET_FILTER = "select SQL_CACHE * from mail_filter_%s";
	var $SQL_GET_FILTER_ONE = "select SQL_CACHE * from mail_filter_%s where no = '%s'";
	var $SQL_GET_NUM_FILTER = "select SQL_CACHE count(no) as num from mail_filter_%s";
	var $SQL_GET_LAST_SEQ_IN_FILTER =
		"select SQL_CACHE sequence from mail_filter_%s order by sequence desc limit 0,1";
	var $SQL_GET_SEQ_FILTER =
		"select SQL_CACHE sequence from mail_filter_%s where no = '%s'";

	var $SQL_GET_REMOTE_SERVER = "select SQL_CACHE no, servername from remote_server_%s";
	var $SQL_GET_REMOTE_SERVER_ONE =
		"select SQL_CACHE * from remote_server_%s where no = '%s'";

	function Control_Message () {
		$this->Template = new Template;
	}

	function filter () {
		$retval = $this->filter_item_list();

		return $retval;
	}

	function get_total_number_of_filter () {
		$DB = new MySQLdb;
		$o = $DB->fetch_one(sprintf($this->SQL_GET_NUM_FILTER, $_SESSION["config_id"]));

		if ($o["num"] > 0) {
			$retval = $o["num"];
		} else {
			$retval = false;
		}

		if ($retval > $_SESSION["config_block_address"]) {
			$retval = $_SESSION["config_block_address"];
		}

		return $retval;
	}

	function get_sequence ($no) {
		$DB = new MySQLdb;
		$o = $DB->fetch_one(
				sprintf($this->SQL_GET_SEQ_FILTER, $_SESSION["config_id"], $no));

		$retval = $o["sequence"];

		return $retval;
	}

	function get_new_sequence () {
		$DB = new MySQLdb;
		$o = $DB->fetch_one(
				sprintf($this->SQL_GET_LAST_SEQ_IN_FILTER, $_SESSION["config_id"]),
			true);

		if (! $o["sequence"]) {
			$retval = "0";
		} else {
			$retval = $o["sequence"] + 1;
		}

		return $retval;
	}

	function filter_item_list () {
		global $string;

		$DB = new MySQLdb;
		$DB->query(sprintf($this->SQL_GET_FILTER_NAME, $_SESSION["config_id"]), true);

		$num_rows = $this->get_total_number_of_filter();

		for ($i = 0; $i < $num_rows; $i++) {
			$o = $DB->fetch();
			if (! $o["no"]) break;

			if ($o["name"]) {
				$var["name"] = htmlspecialchars($o["name"]);
			} else {
				$var["name"] = sprintf("%s %s", $o["no"], $string["message35"]);
			}

			$var["seq"] = $i + 1;
			$var["no"] = $o["no"];
			$var["filter_code"] = $this->filter_item_one_short($o["no"]);

			$one["content"] .= $this->Template->generate(
				"/module/message/template/control_filter_list_one", $var);
		}

		$retval = $this->Template->generate(
			"/module/message/template/control_filter_list", $one);

		return $retval;
	}

	function filter_item_one_short ($no) {
		global $global, $string;

		$DB = new MySQLdb;
		$Directory = new myDirectory;

		$o = $DB->fetch_one(
			sprintf($this->SQL_GET_FILTER_ONE, $_SESSION["config_id"], $no));

		if ($o["f"]) {
			$code[] = "<li>" . sprintf($string["message97"], htmlspecialchars($o["f"]));
		}

		if ($o["payload_name"]) {
			$code[] = "<li>" . 
				sprintf($string["message99"][$o["p_o"]], htmlspecialchars($o["payload_name"]));
		}

		if ($o["s"]) {
			$code[] = "<li>" .
				sprintf($string["message98"][$o["s_o"]], htmlspecialchars($o["s"]));
		}

		$one["codes"] = implode("<br>", $code);

		if ($o["directory_num"] == "-100") {
			$one["directory"] = $string["message107"];
		} else {
			$one["directory"] =
				sprintf($string["message96"], $Directory->get_name($o["directory_num"]));
		}

		$retval = $this->Template->generate(
			"/module/message/template/control_filter_code_short", $one);

		return $retval;
	}

	function filter_item_one ($no) {
		global $global, $string;

		$DB = new MySQLdb;
		$Directories = new Directories;

		$o = $DB->fetch_one(
			sprintf($this->SQL_GET_FILTER_ONE, $_SESSION["config_id"], $no));

		$one["no"] = $no;

		if ($o["name"]) {
			$one["name"] = htmlspecialchars($o["name"]);
		} else {
			$one["name"] = sprintf("%s %s", $o["no"], $string["message35"]);
		}

		// expression
		if ($o["expression"] == "1") {
			$one["expression_and_selected"] = "selected";
		} else {
			$one["expression_or_selected"] = "selected";
		}

		// string
		$one["From_string"] = $o["f"];
		$one["To_string"] = $o["t"];
		$one["Subject_string"] = $o["s"];
		$one["payload_name_string"] = $o["payload_name"];

		if ($o["message_size"] != "0") {
			$one["message_size_string"] = $o["message_size"];
		}

		// option
		$one["Subject_option"] = $this->__return_expression_select_box($o["s_o"]);
		$one["payload_name_option"] =
			$this->__return_expression_select_box($o["p_o"]);
		$one["message_size_option"] =
			$this->__return_size_select_box($o["m_o"]);

		// case sensitive
		if ($o["s_c"]) $one["Subject_case"] = "checked";
		if ($o["p_c"]) $one["payload_name_case"] = "checked";

		// directory
		if ($o["directory_num"] == "-100") {
			$one["dontsave_selected"] = "checked";
			$one["directory"] = $Directories->return_select_options(
					array($global["directory"]["sent"]), $global["directory"]["spam"]);
		} else {
			$one["directory"] = $Directories->return_select_options(
					array($global["directory"]["sent"]), $o["directory_num"]);
		}

		// return
		$retval = $this->Template->generate(
			"/module/message/template/control_filter_one", $one);

		return $retval;
	}

	function add_filter () {
		global $global, $string;

		$Directories = new Directories;

		$one["directory"] = $Directories->return_select_options(
			array($global["directory"]["sent"]), $global["directory"]["spam"]);

		// return
		$retval = $this->Template->generate(
			"/module/message/template/control_filter_add", $one);

		return $retval;
	}

	function __return_size_select_box ($selected="") {
		global $string;

		$expression1 = array( "0" => $string["message62"], "1" => $string["message63"],
			"2" => $string["message64"]);

		while (list($i, $j) = each($expression1)) {
			if ($selected == $i) {
				$a[] = sprintf("<option value=\"%s\" selected>&nbsp;%s",$i, $j);
			} else {
				$a[] = sprintf("<option value=\"%s\">&nbsp;%s",$i, $j);
			}
		}

		return implode("\n", $a);
	}

	function __return_expression_select_box ($selected="") {
		global $string;

		$expression1 = array( "0" => $string["item45"], "1" => $string["item46"],
			"2" => $string["item47"], "3" => $string["item48"], "4" => $string["item58"]);

		while (list($i, $j) = each($expression1)) {
			if ($selected == $i) {
				$a[] = sprintf("<option value=\"%s\" selected>&nbsp;%s",$i, $j);
			} else {
				$a[] = sprintf("<option value=\"%s\">&nbsp;%s",$i, $j);
			}
		}

		return implode("\n", $a);
	}

	function add_remote_server () {
		
		$retval =
			$this->Template->generate(
				"/module/message/template/control_remote_server_one_add", $one);

		return $retval;
	}

	function remote_server_one ($no) {
		$DB = new MySQLdb;

		$o = $DB->fetch_one(
			sprintf($this->SQL_GET_REMOTE_SERVER_ONE, $_SESSION["config_id"], $no), True);

		$one["no"] = $o["no"];
		$one["name"] = $o["servername"];
		$one["servername"] = $o["servername"];
		$one["port"] = $o["port"];
		$one["username"] = $o["username"];
		$one["password"] = $o["password"];

		switch ($o["type"]) {
			case ("imap") :
				$one["imap_selected"] = "selected";
			break;
			default :
				$one["pop3_selected"] = "selected";
		}

		if ($o["valid"] == "1") {
			$one["valid"] = "checked";
		} else {
			$one["invalid"] = "checked";
		}

		$retval =
			$this->Template->generate(
				"/module/message/template/control_remote_server_one", $one);

		return $retval;
	}

	function remote_server_list () {

		$DB = new MySQLdb;

		$DB->query(
			sprintf($this->SQL_GET_REMOTE_SERVER, $_SESSION["config_id"]), True);

		for ($i = 0; $i < $DB->num_rows; $i++) {
			unset($var);

			$o = $DB->fetch();

			$var["name"] = $o["servername"];
			$var["no"] = $o["no"];

			if (! $o["success"]) $var["failed"] = "mesian_failed";

			$one["content"] .=
				$this->Template->generate(
					"/module/message/template/control_remote_server_list_one", $var);
		}

		$retval =
			$this->Template->generate(
				"/module/message/template/control_remote_server_list", $one);

		return $retval;
	}

	function remote_server_all () {
		/*
			no, servername, port, type, valid, success, username, password
		*/
		$DB = new MySQLdb;

		$DB->query(
			sprintf($this->SQL_GET_REMOTE_SERVER, $_SESSION["config_id"]), True);

		for ($i = 0; $i < $DB->num_rows; $i++) {
			unset($one);

			$o = $DB->fetch();

			$one["no"] = $i;
			$one["servername"] = $o["servername"];
			$one["port"] = $o["port"];
			$one["username"] = $o["username"];
			$one["password"] = $o["password"];

			if ($o["valid"] == "1") {
				$one["valid"] = "checked";
			} else {
				$one["invalid"] = "checked";
			}

			if ($o["success"] != "1") {
				$one["success"] = "Failed to login.";
			}

			switch ($o["type"]) {
				case ("imap") :
					$one["type_imap"] = "selected";
				break;
				default :
					$one["type_pop3"] = "selected";
			}

			$var["content"] .=
				$this->Template->generate(
					"/module/message/template/control_remote_server_one", $one);
		}

		for ($i = $DB->num_rows; $i < 3; $i++) {
			unset($one);

			$one["no"] = "$i";
			$one["invalid"] = "checked";
			$one["type_imap"] = "selected";

			$var["content"] .=
				$this->Template->generate(
					"/module/message/template/control_remote_server_one", $one);
		}

		$retval =
			$this->Template->generate(
				"/module/message/template/control_remote_server", $var);

		return $retval;
	}

}

/*
Description
-----------
mysql> desc item_1059297317;
+---------------+---------+------+-----+---------+----------------+
| Field         | Type    | Null | Key | Default | Extra          |
+---------------+---------+------+-----+---------+----------------+
| no            | int(11) |      | PRI | NULL    | auto_increment |
| item_type     | int(11) |      |     | 0       |                |
| item_num      | int(6)  |      |     | 0       |                |
| directory_num | int(11) |      |     | 0       |                |
+---------------+---------+------+-----+---------+----------------+
4 rows in set (0.00 sec)

mysql> 

Author
------
 Spike^ekipS <spike@spikeekips.net>

Changelog
---------

Usage
-----

*/

?>
