<?

class MySQLdb {

	var $conn;

	var $result = false;
	var $result_affected = false;

	var $retval;
	var $is_transaction = false;
	var $transaction_done = false;

	var $num_rows;

	var $SQL_LAST_INSERT_ID = "select LAST_INSERT_ID() as id";

	function MySQLdb ($transaction=false) {
		if ($transaction == true) {
			$this->transaction_start(true);
		}
	}

	function connect ($config) {

		if ($config["unix_socket"]) {
			$host = sprintf("%s:%s", $config["host"], $config["unix_socket"]);
		} else if ($config["port"]) {
			$host = sprintf("%s:%s", $config["host"], $config["port"]);
		} else {
			$host = $config["host"];
		}

		if (mysql_connect($host, $config["user"], $config["password"])) {
			$this->retval = true;
		} else {
			$this->retval = false;
		}
	}
	// mysql_ping() be supported for php >= 4.3.0.
	function ping () {
		$retval = mysql_ping();
		return $retval;
	}

	function set_db ($db_name) {

		if (! mysql_select_db($db_name)) {
			$this->retval = false;
		} else {
			$this->retval = true;
		}

		return $this->retval;
	}

	function close () {
		if (! $this->transaction_done) {
			$this->transaction_end();
		}
	}

	// it includes transaction function.
	// if query true, commit, if failed, rollback
	function quit () {
		$this->close();
		mysql_close();
	}

	function get_retval () {
		return $this->retval;
	}

	//---------------------------------------- transaction
	function transaction_start ($is_transaction=false) {
		if ($is_transaction or $this->is_transaction) {
			$this->is_transaction = true;
			$this->query("start transaction");
		}
	}

	function transaction_end () {
		if ($this->is_transaction) {

			$this->transaction_done = true;

			if ($this->retval) { // transaction.
				$this->commit();
			} else {
				$this->rollback();
			}
		}
	}

	function commit () {
		$this->query("commit");
	}

	function rollback () {
		$this->query("rollback");
	}

	//---------------------------------------- query

	function get_last_insert_id () {
		$o = $this->fetch_one($this->SQL_LAST_INSERT_ID);
		$retval = $o["id"];

		return $retval;
	}

	function get_num () {
		$ret = mysql_num_rows($this->result);

		return $ret;
	}

	function query ($query, $get_row=false) {
		$this->fetch_query($query, $get_row);
	}

	function execute_query ($query) {

		$this->result = mysql_query($query);

		if (! $this->result) {
			$this->retval = false;
		} else {
			$this->retval = true;
		}

		if (mysql_affected_rows() < 1) {
			$this->result_affected = false;
		} else {
			$this->result_affected = true;
		}

		return $this->retval;
	}

	function fetch_query ($query, $get_row=false) {

		$this->result = mysql_query($query);

		if (! $this->result) {
			$this->retval = false;
		} else {
			if ($get_row) $this->num_rows = $this->get_num();
			$this->retval = true;
		}
	}

	function fetch () {

		$ret = mysql_fetch_array($this->result);

		return $ret;
	}

	function fetch_one ($query) {

		$this->query($query);
		$ret = $this->fetch();

		if (! $ret) {
			$this->retval = false;
		} else {
			$this->retval = true;
		}

		return $ret;
	}

	function fetch_all ($query){

		$this->fetch_query($query, true);

		for ($i = 0; $i < $this->num_rows; $i++) {
			$o = $this->fetch();
			$ret[] = $o;
		}

		if (! is_array($ret)) {
			$ret = false;
			$this->retval = false;
		} else {
			$this->retval = true;
		}

		return $ret;
	}
}

function escape_string ($str) {
	$data = str_replace(";", "\\;", mysql_escape_string($str));

	return $data;
}


/*
Description
-----------

Author
------
 Spike^ekipS <spike@spikeekips.net>

Changelog
---------

Usage
-----

*/

?>
