# -*- coding: utf-8 -*-
import ConfigParser, sys, sre, os

class Config :

	CP = None

	sections = []
	re_1 = sre.compile(" #.*")

	def __init__ (self, filename) :

		self.CP = ConfigParser.ConfigParser()
		self.from_file(filename)

	def from_file (self, filename) :
		fh = open(filename, "r")

		try :
			self.CP.readfp(fh)
		except ConfigParser.ParsingError :
			sys.stderr.writelines("malformed config file, %s\n" % filename)
			sys.exit(1)

	def __read_all (self) :

		self.sections = self.CP.sections()

		retval = True
		value = {}

		for i in self.sections :
			value[i] = self.__read_value_of_sections(i)

			if not value[i] : retval = False

		if retval is not False :
			retval = value

		return retval

	def __read_value_of_sections (self, section) :

		try :
			value = {}
			for i in self.CP.items(section) :
				value[i[0]] = self.re_1.sub("", i[1])
		except ConfigParser.NoSectionError :
			retval = False
		else :
			retval = value

		return retval

	def get_all (self) :
		return self.__read_all()


"""
Description
-----------


ChangeLog
---------


Usage
-----


"""

__author__ =  "Spike^ekipS <spike@spikeekips.net>"
__version__=  "0.1"
__nonsense__ = ""

__file__ = "1.py"


