<?

class Board
{
	var $ldb;
	var $fields;
	var $types;
	var $auto_create;

	function Board($where, $fields, $types, $auto_create=false)
	{
		$this->ldb = new ListDatabase($where);
		$this->fields = $fields;
		$this->types = $types;
		$this->auto_create = $auto_create;
	}

	function open()
	{
		if ( !$this->ldb->openLDB("w") )
		{
			if ( $this->auto_create )
			{
				if ( !$this->ldb->createLDB($this->fields, $this->types) ) return false;
				if ( !$this->ldb->openLDB("w") ) return false;
			}
			return false;
		}
		return true;
	}

	function close()
	{
		$this->ldb->closeLDB();
	}

	function getTotal()
	{
		return $this->ldb->getTotalRow();
	}
	
	function getLatest()
	{
		return $this->ldb->getNnd($this->getTotal());
	}
	
	function getNext($current)
	{
		return $this->ldb->getBeforeRow($current);
	}
	
	function addData($fields)
	{
		$no = $this->ldb->insertRow(-1);
		$this->setData($no, $fields);
		return $no;
	}

	function insertData($no, $fields)
	{
		$no = $this->ldb->insertRow($this->ldb->getBeforeRow($no));
		$this->setData($no, $fields);
		return $no;
	}

	function setData($no, $fields)
	{
		while ( list($field, $value) = each($fields) ) $this->ldb->setValue($no, $field, $value);
		return true;
	}

	function getData($no, $field=null)
	{
		if ( $field == null )
		{
			$count = count($this->fields);
			for ( $i=0 ; $i<$count ; $i++ ) $data[$this->fields[$i]] = $this->ldb->getValue($no, $this->fields[$i]);
			return $data;
		}
		else
		{
			return $this->ldb->getValue($no, $field);
		}
	}

	function dropData($no)
	{
		return $this->ldb->dropRow($no);
	}

	function unlinkAddData()
	{
		return $this->ldb->unlinkInsertRow();
	}

	function unlinkDropData($no)
	{
		return $this->ldb->unlinkDropRow($no);
	}

	function getList($page, $num)
	{
		$TOTAL = $this->ldb->getTotalRow();

		// get total page
		$TOTAL_PAGE = (int)($TOTAL/$num);
		if ( $TOTAL%$num != 0 ) $TOTAL_PAGE++;

		// set now list page
		if ( $page == 0 || $page == "" ) $page=$TOTAL_PAGE;

		// make list
		$start = ($TOTAL_PAGE-$page)*$num;
		$first = $this->ldb->getNnd($TOTAL-$start);
		if ( $first != 0 )
		{
			$list[0] = $first;
			for ( $i=1 ; $i<$num ; $i++ )
			{
				$list[$i] = $this->ldb->getBeforeRow($list[$i-1]);

				if ( $list[$i] == 0 )
				{
					array_pop($list);
					break;
				}
			}
		}

		return array($list, $TOTAL_PAGE);;
	}

	function getSearchList($page, $num, $keyword, $where, $opt="only1000", $result_head=null)
	{
		
		if ( $where['title'] == 'on' )		$where[0] = 'title';
		if ( $where['text'] == 'on' )		$where[1] = 'text';
		if ( $where['name'] == 'on' )	$where[2] = 'name';
		
		$total = $this->ldb->getTotalRow();
		if ( $opt == "only1000" && $total > 1000 )	$range = 1000;
		else $range = $total;
		
		$result_num = 0;
		
		$last = $this->ldb->getFirstRow();
		
		if ( $result_head == null )
		{
			$result_head	= array();
			$result_page	= 0;
			$current			= $this->ldb->getLastRow();
			
			for ( $i=0 ; $i<$range ; $i++ )
			{
				if (
				strpos($this->getData($current, $where[0]), $keyword) !== false ||
				strpos($this->getData($current, $where[1]), $keyword) !== false ||
				strpos($this->getData($current, $where[2]), $keyword) !== false )
				{
					$list[$result_num++] = $current;
					if ( $result_num>($num*$result_page) ) $result_head[$result_page++] = $current;
				}
				if ( $current == $last ) break;
				$current = $this->ldb->getBeforeRow($current);
			}
			
			if ( empty($page) ) $page = $result_page;
			
			if ( !empty($list) )	$list = array_slice($list, ($result_page-$page)*$num, $num);	
			else							$list = array();
			
			return array($list, $result_page, $result_head, $result_num);
		}
		else
		{
			$result_page = count ( $result_head );
			$current = $result_head[$result_page-$page];
			
			for ( $i=0 ; $i<$range ; $i++ )
			{
				if (
				strpos($this->getData($current, $where[0]), $keyword) !== false ||
				strpos($this->getData($current, $where[1]), $keyword) !== false ||
				strpos($this->getData($current, $where[2]), $keyword) !== false )
				{
					$list[$result_num++] = $current;
					if ( $result_num > $num ) break;
				}
				if ( $current == $last ) break;
				$current = $this->ldb->getBeforeRow($current);
			}
			return array($list, $result_page, $result_head, $result_num);
		}
	}
}
?>