########################
# Nari 인터프리터 코어 #
########################

# strscan 참조
require 'strscan'
# date 참조
# win32api 참조
require 'Win32API'
require 'date'
# time 참조
require 'time'
# values 해시 세팅
values = {}
# returns 해시 세팅
returns = {}
# 루프
loop do
  # 입력 받는다
  line = gets or break
  # scanner 생성
  scanner = StringScanner.new(line.chomp)
  # 다음 파이프를 통과하지 않으면 에러
  scanner.scan(/(openie|help|nowtime|nowdate|fileread|put2|put|puts2|puts|abs|set)\s+/) or fail "Missing command"
  # cmd 세팅
  cmd = scanner[1]
  # var_name 세팅
  var_name = scanner.scan(/\w+/) or fail "Missing variable"
  # cmd 를 케이스 조건으로..
  case cmd
  # openie 함수
  when "openie"
    ie = WIN32OLE.new('InternetExplorer.Application')
    ie.visible = true
    ie.navigate(values[var_name])
  # help 함수
  when "help"
    puts "############################"
    puts "#자세한 것은 nari doc 참고.#"
    puts "############################"
  # nowtime 함수
  when "nowtime"
    nowtime1 = Time.now.httpdate
    values[var_name] = nowtime1
    puts values[var_name]
  # nowdate 함수
  when "nowdate"
    nowdate1 = DateTime.now
    values[var_name] = nowdate1
    puts values[var_name]
  # fileread 함수
  when "fileread"
    File.open(var_name) do |file|
      while line = file.gets
        puts line
      end
    end
  # put2 함수
  when "put2" 
    puts "#{values[var_name].inspect}"
  # put 함수
  when "put" 
    print "#{values[var_name].inspect}"
  # puts2 함수
  when "puts2" 
    puts "#{var_name}"
  # puts 함수
  when "puts" 
    print "#{var_name}"
  # abs 함수
  when "abs"
    puts values[var_name].abs
  # set 함수
  when "set"
    scanner.skip(/\s+=\s+/) or fail "Missing '='"
    value = scanner.rest
    values[var_name] = value
  # 만약 위 것들에 해당하지 않으면?
  else
    #뷁귉 에러
    fail cmd
  # 케이스문을 닫음
  end
# 루프문을 닫음 그리고 바이바이~
end
