/***************************************************************************
 *   Copyright (C) 2007 by Doo-Hyun Jang                                   *
 *   ring0320@nate.com                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef GROUPLIST_H
#define GROUPLIST_H

#include <qobject.h>
#include <qptrlist.h>

#include "group.h"

class Group;

/**
   @author Doo-Hyun Jang <ring0320@nate.com>
*/
class GroupList : public QObject
{
Q_OBJECT
public:
	GroupList();
  
	~GroupList();
  
	// add a group to buddylist
	Group *addGroup(QString sGroupID, QString sGroupName);
	Group *addGroup(Group *pGroup);
  
	/// 그룹ID로 Group을 찾음.
	Group *getGroupByID(QString sGroupID) const;
  
	/// 그룹명으로 Group을 찾음.
	Group *getGroupByName(QString sName) const;
  
	// return the group with the given sort position
	Group *getGroupBySortPosition(int nSortPosition) const;
  
	// return the list of groups
	const QPtrList<Group>&    getGroupList() const { return m_GroupList; };
  
	// remove a group
	void removeGroup(QString sGroupID);
	void removeGroup(Group *pGroup) { m_GroupList.remove(pGroup); };
	// change a group's name
	void renameGroup(QString sGroupID, QString sNewName);

	void clear() { m_GroupList.clear();}

	const QStringList &getGIDListByBuddyHandle( QString sHandle );
  
private:
	// delete all general groups
	void deleteGeneralGroups();
  
	// return if group with given gid exists
	bool IsGroupExist(QString sGroupID);
  
  
	// the list of groups
	QPtrList<Group> m_GroupList;
signals:
	// signal that a group has been added
	// void groupAdded(Group *pGroup);
  
	// signal that a group has been added
	void groupRemoved(const Group *pGroup);
};

#endif
