/***************************************************************************
 *   Copyright (C) 2007 by Doo-Hyun Jang                                   *
 *   ring0320@nate.com                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "config.h"

#ifdef HAVE_ARTS
#include <soundserver.h>
#include <artsc.h>
#include <artsc_export.h>
#include <kartsdispatcher.h>
#endif

#include "sound.h"

Sound::Sound()
{
}


Sound::~Sound()
{
}

void Sound::play(QString sFile)
{
#ifdef HAVE_ARTS
	KArtsDispatcher dispatcher;
  
	Arts::SimpleSoundServer server = Arts::Reference("global:Arts_SimpleSoundServer");
	server.play( sFile );
#else
	Q_UNUSED(sFile)
#endif
}


