/***************************************************************************
 *   Copyright (C) 2007 by Doo-Hyun Jang                                   *
 *   ring0320@nate.com                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "config.h"

#ifdef HAVE_ARTS
#include <soundserver.h>
#include <artsc.h>
#include <artsc_export.h>
#include <kartsdispatcher.h>
#include <kplayobject.h>
#include <kartsserver.h>
#include <kplayobjectfactory.h>
#endif

#include <kmessagebox.h>
#include <kdebug.h>

#include "sound.h"
#include "knateoncommon.h"

void MyClass::run()
{
	KMessageBox::information( 0, UTF8("KDE 시스템의 소리설정(arts)에 문제가 있는것 같습니다. 이 메시지를 보기 원하지 않으시면, 버디 목록 창의 '설정' 메뉴에서 '환경설정'의 '알림/소리' 탭의 '알림 시 소리사용' 선택을 없애주십시요."), UTF8("소리 알림 에러"), "OnlyOneShowSoundError" );
}


Sound::Sound()
{
}

Sound::~Sound()
{
}

void Sound::play(QString sFile)
{
#ifdef HAVE_ARTS
	KArtsDispatcher dispatcher;
	Arts::SimpleSoundServer server = Arts::Reference("global:Arts_SimpleSoundServer");
	if ( server.isNull() || server.error() ) {
		/* OnlyOneShowSoundError 가 KConfig 에 저장됨. */
		KMessageBox::information( 0, UTF8("KDE 시스템의 소리설정(arts)에 문제가 있는것 같습니다. 이 메시지를 보기 원하지 않으시면, 버디 목록 창의 '설정' 메뉴에서 '환경설정'의 '알림/소리' 탭의 '알림 시 소리사용' 선택을 없애주십시요."), UTF8("소리 알림 에러"), "OnlyOneShowSoundError" );
		
		/* 쓰레드로 안되나? 멈춰버리는군. */
		// MyClass *myClass = new MyClass();
		// myClass->start();
		return;
    }
	server.play( sFile );
#else
	Q_UNUSED(sFile)
#endif
}
