/***************************************************************************
 *   Copyright (C) 2008 by SK Communications.                              *
 *   http://kldp.net/projects/nateon/                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/



#include "messagebox.h"
#include "messageboxadaptor.h"
#include "../nateon/util/common.h"
//Added by qt3to4:
#include <QPixmap>
#include <QtDBus>

nmconfig stConfig;

messagebox::messagebox( QWidget * parent )
        : KXmlGuiWindow( parent ),
		aCollection(0),
        pFile(0),
        pMessage(0),
        pTool(0),
        pView(0),
        pHelp(0) {

	// register the QObject with D-Bus
	new MessageboxAdaptor( this );
	QDBusConnection dbus = QDBusConnection::sessionBus();
	dbus.registerObject( "/Messagebox", this );
	dbus.registerService( "org.skcomms.Messagebox" );

    KStandardDirs *dirs = KGlobal::dirs();
	dirs->addResourceDir( "data", "/usr/share/apps" );
    QString sPicsPath( dirs->findResource( "data", QString( KGlobal::mainComponent().aboutData()->appName() ) + "/pics/" ) );

    setIcon( QPixmap( sPicsPath + "title_icon_tmb.bmp" ) );
    pMessageboxWidget = new messageboxWidget( this );
    connect( pMessageboxWidget, SIGNAL( changeShowTab( int ) ), 
			this, SLOT( slotChangeTab( int ) ) );
    setCentralWidget( pMessageboxWidget );
    createMenu();

    connect( this, SIGNAL( gotDBPath( const QString & ) ), pMessageboxWidget, SLOT( slotListing( const QString & ) ) );
    // connect( )
    pMessageboxWidget->requireDBPath();
    // pMessageboxWidget->tabWidget2->setCurrentPage ( 1 );
}

/*
messagebox::~messagebox()
{
}
*/
void messagebox::createMenu() {
	aCollection =  new KActionCollection ( this, KGlobal::mainComponent() );

    pFile = new KMenu( this );
    menuBar()->insertItem( UTF8( "파일(&F)" ), pFile);

    pOpenAction = new KAction( UTF8( "열기(&O)" ), this );
	pOpenAction->setShortcut( Qt::CTRL + Qt::Key_O );
    connect( pOpenAction, SIGNAL( triggered() ), SLOT( slotOpenMenu() ) );
	pFile->addAction( aCollection->addAction( "open_action",pOpenAction ) );

    pSaveAction = new KAction( UTF8( "저장(&S)" ), this );
	pSaveAction->setShortcut( Qt::CTRL + Qt::Key_S );
	connect( pSaveAction, SIGNAL( triggered() ), SLOT( slotSaveMenu() ) );
	pFile->addAction( aCollection->addAction( "save_action",pSaveAction ) );

    pFile->insertSeparator();
    pQuitAction = new KAction( UTF8( "메시지함 닫기(&X)" ), this );
	pQuitAction->setShortcut( Qt::CTRL + Qt::Key_X );
	connect( pQuitAction, SIGNAL( triggered() ), SLOT( slotQuit() ) );
	pFile->addAction( aCollection->addAction( "quit_action",pQuitAction ) );

    pMessage = new KMenu( this );
    menuBar()->insertItem( UTF8( "메시지(&M)" ), pMessage);

    pNewAction = new KAction( UTF8( "새 메시지(&M)" ), this );
	pNewAction->setShortcut( Qt::CTRL + Qt::Key_N );
	connect( pNewAction, SIGNAL( triggered() ), SLOT( slotNewMenu() ) );
	pMessage->addAction( aCollection->addAction( "new_action",pNewAction ));

    pReplyMemoAction = new KAction( UTF8( "답장(&R)" ), this );
	pReplyMemoAction->setShortcut( Qt::CTRL + Qt::Key_R );
	connect( pReplyMemoAction, SIGNAL( triggered() ), 
			pMessageboxWidget, SLOT( slotMemoReply() ) );
	pMessage->addAction( aCollection->addAction( "replymemo_action", pReplyMemoAction ) );

    pReplyAllMemoAction = new KAction( UTF8("전체 답장(&A)"), this );
	pReplyAllMemoAction->setShortcut( Qt::CTRL + Qt::SHIFT + Qt::Key_R );
	connect( pReplyAllMemoAction, SIGNAL( triggered() ),
			pMessageboxWidget, SLOT( slotMemoReplyAll() ) );
	pMessage->addAction( aCollection->addAction( "replyallmemo_action", pReplyAllMemoAction ) );

    pForwardMemoAction = new KAction( UTF8( "전달(&F)" ), this );
	pForwardMemoAction->setShortcut( Qt::CTRL + Qt::Key_F );
	connect( pForwardMemoAction, SIGNAL( triggered() ), 
			 pMessageboxWidget, SLOT( slotMemoForward() ) );
	pMessage->addAction( aCollection->addAction( "forwardmemo_action", pForwardMemoAction ) );

    pMessage->insertSeparator();
    pDeleteAction = new KAction( UTF8( "삭제(&D)" ), this );
	pDeleteAction->setShortcut( Qt::Key_Delete );
	connect( pDeleteAction, SIGNAL( triggered() ), SLOT( slotDelete() ) );
	pMessage->addAction( aCollection->addAction( "delete_action", pDeleteAction ) );

    pTool = new KMenu( this );
    menuBar()->insertItem( UTF8( "도구(&T)" ), pTool );
	
    pAlwaysTopAction = new KToggleAction( UTF8( "항상 위(&Y)" ), this );
	pAlwaysTopAction->setShortcut( Qt::CTRL + Qt::Key_Y );
    connect( pAlwaysTopAction, SIGNAL( triggered( bool ) ), SLOT( slotAlwaysTop( bool ) ) );
	pTool->addAction( aCollection->addAction( "alwaystop_action", pAlwaysTopAction ) );

    pTool->insertSeparator();
    pFindAction = new KAction( UTF8( "찾기(&F)" ), this );
	pFindAction->setShortcut( Qt::CTRL + Qt::Key_F );
	connect( pFindAction, SIGNAL( triggered() ), SLOT( slotFindMenu() ) );
	pTool->addAction( aCollection->addAction( "find_action", pFindAction ) );

    pSelectAllAction = new KAction( UTF8( "전체선택(&A)" ), this );
	pSelectAllAction->setShortcut( Qt::CTRL + Qt::Key_A );
	connect( pSelectAllAction, SIGNAL( triggered() ), SLOT( slotSelectAll() ) );
	pTool->addAction( aCollection->addAction( "find_action", pSelectAllAction ) );

    pTool->insertSeparator();
    pSetupAction = new KAction( UTF8( "통합메시지함 옵션" ), this );
	pSetupAction->setShortcut( Qt::Key_F12 );
	connect( pSetupAction, SIGNAL( triggered() ), SLOT( slotSetup() ) );
    pSetupAction->setEnabled( FALSE );
	pTool->addAction( aCollection->addAction( "setup_action", pSetupAction ) );

    pView= new KMenu( this );
    menuBar()->insertItem( UTF8( "보기(&V)" ), pView);

    pRefreshAction = new KAction( UTF8( "새로 고침(&R)" ), this );
	pRefreshAction->setShortcut( Qt::Key_F5 );
	connect( pRefreshAction, SIGNAL( triggered() ), SLOT( slotRefreshMenu() ) );
	pView->addAction( aCollection->addAction( "refresh_action", pRefreshAction ) );

    pHelp = new KMenu( this );
    menuBar()->insertItem( UTF8( "도움말(&V)" ), pHelp);

    pNateDotComAction = new KAction( UTF8( "NATE.com 홈(&N)" ), this );
	pNateDotComAction->setShortcut( Qt::Key_F11 );
	connect( pNateDotComAction, SIGNAL( triggered() ), SLOT( slotGoNateDotComMenu() ) );
	pHelp->addAction( aCollection->addAction( "natedotcom_action", pNateDotComAction ) );

    pHelpAction = new KAction( UTF8( "통합메시지함 이용안내(&I)" ), this );
	pHelpAction->setShortcut( Qt::Key_F1 );
	connect( pHelpAction, SIGNAL( triggered() ), SLOT( slotGoHelpMenu() ) );
	pHelp->addAction( aCollection->addAction( "help_action", pHelpAction ) );
	
    pFaqAction = new KAction( UTF8( "네이트온 FAQ(&F)" ), this );
	connect( pFaqAction, SIGNAL( triggered() ), SLOT( slotGoFaqMenu() ) );
	pHelp->addAction( aCollection->addAction( "faq_action", pFaqAction ) );

    helpMenu_ = new KHelpMenu(this, KGlobal::mainComponent().aboutData(), false, actionCollection());
    pAboutAction = KStandardAction::aboutApp(helpMenu_, SLOT( aboutApplication() ), actionCollection() );
}

void messagebox::setUserID(const QString s) {
#ifdef NETDEBUG
    kDebug() << "YYY Receive Data : [" << s << "]";
#endif
    sUserID = s;
}

void messagebox::setDBPath(const QString s) {
#ifdef NETDEBUG
	kDebug() << "setDBPath";
    kDebug() << "XXX Receive Data : [" << s << "]";
#endif
    sDBPath = s;

    emit gotDBPath( s );
    // openDB( s );
}


void messagebox::openDB( const QString& sPath ) {
#if 0
    QString sFilePath;
    rowList mRow;

    /*! memo */
    sFilePath = sPath;
    sFilePath += "/memodata/local_inbox.db";
    kdDebug() << "[ F I L E P A T H ] [" << sFilePath << "]" << endl;
    mRow = pDB->getRecords( sFilePath, "SELECT UUID, SUSER, RUSER, SUBJECT, BODYDATA, DATE from tb_local_inbox;");

    for ( rowList::iterator it = mRow.begin(); it != mRow.end(); ++it ) {
        kdDebug() << "[" << (*it)[0] << "] [" << (*it)[1] << "] [" << (*it)[2] << "] [" << (*it)[3] << "] [" << (*it)[4] << "] [" << (*it)[5] << "] [" << endl;
    }
#if 0
    sFilePath = sPath;
    sFilePath += "/memodata/local_outbox.db";
    mRow = pDB->getRecords( sFilePath, "SELECT UUID, SUSER, RUSER, SUBJECT, BODYDATA, DATE from TB_local_outbox;");

    /*! chat */
    sFilePath = sPath;
    sFilePath += "/chatdata/local_chat.db";
    mRow = pDB->getRecords( sFilePath, "SELECT UUID, CHATUSER, BODYDATA, DATE, SIZE from tb_local_chat;");
#endif
#endif
    Q_UNUSED( sPath );
}

void messagebox::slotQuit() {
    close();
}

/*
void messagebox::dbusCommand(const QString s) {
#ifdef NETDEBUG
    kDebug() << "dbusCommand XXX [" << s << "]";
#endif
    QStringList slCommand = QStringList::split(QString(":"), s);
    if ( slCommand[0] == "VIEW" ) {
        if ( slCommand[1] == "CHAT" ) {
            pMessageboxWidget->tabWidget2->setCurrentPage ( 1 );
            pMessageboxWidget->pListViews_2->initFolders();
        } else if ( slCommand[1] == "MEMO" ) {
            pMessageboxWidget->tabWidget2->setCurrentPage ( 0 );
            pMessageboxWidget->pListViews->initFolders();
        }
    } else if ( slCommand[0] == "SEARCH" ) {
        if ( slCommand[1] == "CHAT" ) {
            // pMessageboxWidget->pListViews_2->initFolders();
            pMessageboxWidget->tabWidget2->setCurrentPage ( 1 );
            // 검색어 : slCommand[2] 
            pMessageboxWidget->slotChatSearch( 1, slCommand[2] );
            slotChangeTab( 1 );
        } else if ( slCommand[1] == "MEMO" ) {
        }
    } else if ( slCommand[0] == "QUIT" ) {
        close();
    }
}
*/

void messagebox::slotOpenMenu() {
    if ( pMessageboxWidget->tabWidget2->currentPageIndex() == 0 ) {
        if ( pMessageboxWidget->pListViews->getCurrentItem() == 0 ) {
            KMessageBox::information( this, i18n("먼저 선택을 하셔야 됩니다."), i18n("알림") );
            return;
        }
    } else {
        if ( pMessageboxWidget->pListViews_2->getCurrentItem() == 0 ) {
            KMessageBox::information( this, i18n("먼저 선택을 하셔야 됩니다."), i18n("알림") );
            return;
        }
    }
    pMessageboxWidget->slotMouseRight( 1 );
}

void messagebox::slotSaveMenu() {
    if ( pMessageboxWidget->tabWidget2->currentPageIndex() == 0 ) {
#ifdef NETDEBUG
        kDebug() << "[쪽지 저장]";
#endif
        if ( pMessageboxWidget->pListViews->getCurrentItem() == 0 ) {
            KMessageBox::information( this, i18n("먼저 선택을 하셔야 됩니다."), i18n("알림") );
            return;
        }
        pMessageboxWidget->slotMemoSave();
    } else {
#ifdef NETDEBUG
        kDebug() << "[대화 저장]";
#endif
        if ( pMessageboxWidget->pListViews_2->getCurrentItem() == 0 ) {
            KMessageBox::information( this, i18n("먼저 선택을 하셔야 됩니다."), i18n("알림") );
            return;
        }
        pMessageboxWidget->slotChatSave();
    }
}

void messagebox::slotNewMenu() {
    if ( pMessageboxWidget->tabWidget2->currentPageIndex() == 0 ) {
        pMessageboxWidget->slotMemoWrite();
    } else {
        pMessageboxWidget->slotGoChat();
    }
}

void messagebox::slotAlwaysTop( bool bAlwaysTop ) {
	Qt::WindowFlags flags = windowFlags();

    /*! 메뉴의 항상위 채크 */
    if ( bAlwaysTop ) {
		if ( !( flags & Qt::WindowStaysOnTopHint ) ) {
			flags |= Qt::WindowStaysOnTopHint;
            QPoint p(geometry().x(),geometry().y());
            reparent(0,flags,p,true);
        }
    } else {
		if ( flags & Qt::WindowStaysOnTopHint ) {
			flags ^= Qt::WindowStaysOnTopHint;
            QPoint p(geometry().x(),geometry().y());
            reparent(0,flags,p,true);
        }
    }
}

void messagebox::slotSetup() {
}

void messagebox::slotFindMenu() {
    if ( pMessageboxWidget->tabWidget2->currentPageIndex() == 0 ) {
        pMessageboxWidget->slotMemoFind();
    } else {
        pMessageboxWidget->slotChatFind();
    }
}

void messagebox::slotSelectAll() {
    if ( pMessageboxWidget->tabWidget2->currentPageIndex() == 0 ) {
        pMessageboxWidget->pListViews->messages->selectAll ( TRUE );
    } else {
        pMessageboxWidget->pListViews_2->messages->selectAll ( TRUE );
    }
}

void messagebox::slotRefreshMenu() {
    if ( pMessageboxWidget->tabWidget2->currentPageIndex() == 0 ) {
        pMessageboxWidget->slotMemoRefresh();
    } else {
        pMessageboxWidget->slotChatRefresh();
    }
}

void messagebox::slotGoNateDotComMenu() {
    /*! 티켓값으로 로그인 후 페이지 열기 */
    LNMUtils::openURL( "http://www.nate.com/" );
}

void messagebox::slotGoHelpMenu() {
    LNMUtils::openURL("http://nateonweb.nate.com/help/maclinux/linux_g_08.htm");
}

void messagebox::slotGoHotTipMenu() {
    LNMUtils::openURL("http://nateonweb.nate.com/help/guide_hottip_v3_main.html");
}

void messagebox::slotGoFaqMenu() {
    QString sURL("http://br.nate.com/index.php");
    sURL += "?code=E009";
    LNMUtils::openURL( sURL );
}

void messagebox::slotGoAboutMenu() {

}

void messagebox::slotDelete() {
    if ( pMessageboxWidget->tabWidget2->currentPageIndex() == 0 ) {
        pMessageboxWidget->slotMemoDelete();
    } else {
        pMessageboxWidget->slotChatDelete();
    }
}

void messagebox::slotChangeTab(int nTab) {
    if ( nTab == 0 ) {
        pNewAction->setText (i18n("새 메시지(&M)"));
        pReplyMemoAction->setEnabled( TRUE );
        pReplyAllMemoAction->setEnabled( TRUE );
        pForwardMemoAction->setEnabled( TRUE );
    } else {
        pNewAction->setText (i18n("새 대화(&T)"));
        pReplyMemoAction->setEnabled( FALSE );
        pReplyAllMemoAction->setEnabled( FALSE );
        pForwardMemoAction->setEnabled( FALSE );
    }
}

void messagebox::setDefaultBrowser(const QString s) {
    stConfig.defaultwebbrowser = s;
    // kdDebug() << "MSGBOX Default WB : ["<< s << "]" << endl;
    if ( stConfig.defaultwebbrowser == QString::fromUtf8("none") ) {
        stConfig.usedefaultwebbrowser = FALSE;
    } else {
        stConfig.usedefaultwebbrowser = TRUE;
    }
}


#include "messagebox.moc"
