/***************************************************************************
 *   Copyright (C) 2008 by SK Communications.                              *
 *   http://kldp.net/projects/nateon/                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <q3dragobject.h>
//Added by qt3to4:
#include <QDragEnterEvent>
#include <QDropEvent>
#include <QMouseEvent>
#include <QDragMoveEvent>

#include "buddylistview.h"
#include "contactlist.h"
#include "contactroot.h"
#include "contactbase.h"

BuddyListView::BuddyListView( QWidget* parent ) :
        K3ListView( parent ) {
    setAcceptDrops( TRUE );
}

BuddyListView::~BuddyListView() {
}

void BuddyListView::contentsMousePressEvent(QMouseEvent* e) {
    QPoint vp = contentsToViewport(e->pos());
    ContactList* item = (ContactList*)itemAt(vp);
    if (item && item->hasHompy() && item->richText() &&
            item->parent()) {
        item->richText()->adjustSize();
        //printf("korone>> e->pos() x:%d y:%d\n",
        //	e->pos().x(), e->pos().y());
        int marginX = treeStepSize() * item->depth();
        //printf("marginX:%d\n", marginX);

        // 18: hompy button size
        int hompyX1 = marginX + item->richText()->widthUsed() - 30;
        int hompyX2 = hompyX1 + 18;
        //printf("korone>> x1:%d x2:%d\n", hompyX1, hompyX2);
        if (e->pos().x() >= hompyX1 && e->pos().x() <= hompyX2) {
            emit clickedHompy(item);
            return;
        }
    }

    K3ListView::contentsMousePressEvent(e);
}

void BuddyListView::contentsDropEvent(QDropEvent * e) {
    e->setPoint( contentsToViewport( e->pos() ) );
    ContactBase *c = dynamic_cast<ContactBase*>( K3ListView::itemAt( e->pos() ) );
    if ( c ) {
        if ( c->getType() == ContactBase::Group ) {
            ContactRoot *cr = dynamic_cast<ContactRoot*>( c );
            if ( cr ) {
                const QString sGroupName( cr->getName() );
                emit moveBuddies( sGroupName );
                kDebug() << "1. BuddyListView::contentsDropEvent : " << sGroupName;
            }
        } else if ( c->getType() == ContactBase::Buddy ) {
            ContactList *cl = dynamic_cast<ContactList*>( c );
            if ( cl ) {
                ContactRoot *cr = dynamic_cast<ContactRoot*>( cl->getGroupItem() );
                if ( cr ) {
                    const QString sGroupName( cr->getName() );
                    emit moveBuddies( sGroupName );
                    kDebug() << "2. BuddyListView::contentsDropEvent : " << sGroupName;
                }
            }
        }
    }
}

void BuddyListView::contentsDragEnterEvent(QDragEnterEvent * e) {
    if ( Q3TextDrag::canDecode( e )
            || Q3ImageDrag::canDecode( e )
            || Q3UriDrag::canDecode( e ) ) {
        e->accept();
    }

    // Give the user some feedback...
    QString t;
    const char *f;
    for ( int i=0; (f=e->format( i )); i++ ) {
        if ( *(f) ) {
            if ( !t.isEmpty() )
                t += "\n";
            t += f;
        }
    }
    K3ListView::contentsDragEnterEvent( e );
}

void BuddyListView::contentsDragMoveEvent(QDragMoveEvent * e) {
    e->acceptAction( e->action() == QDropEvent::Copy );
    K3ListView::contentsDragMoveEvent( e );
}

void BuddyListView::leaveEvent(QEvent *e) {
    K3ListView::leaveEvent( e );
}

#include "buddylistview.moc"
