/***************************************************************************
 *   Copyright (C) 2008 by SK Communications.                              *
 *   http://kldp.net/projects/nateon/                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "emoticonwindow.h"

#include <qvariant.h>
#include <qpushbutton.h>
#include <qtabwidget.h>
#include <qwidget.h>
#include <qtoolbutton.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <q3whatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
//Added by qt3to4:
#include <QMouseEvent>
#include <Q3GridLayout>
#include <Q3HBoxLayout>
#include <Q3VBoxLayout>

static const unsigned char image0_data[] = {
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x1a,
    0x08, 0x06, 0x00, 0x00, 0x00, 0xb3, 0x76, 0xac, 0x40, 0x00, 0x00, 0x02,
    0xae, 0x49, 0x44, 0x41, 0x54, 0x48, 0x89, 0xed, 0x94, 0x49, 0x48, 0x94,
    0x01, 0x18, 0x86, 0x9f, 0xdf, 0xf9, 0x67, 0x46, 0x27, 0x6d, 0x46, 0x99,
    0xa2, 0xc5, 0xa6, 0xd4, 0x1c, 0xcd, 0xea, 0x60, 0xb8, 0x44, 0x52, 0xb6,
    0x10, 0x1e, 0x02, 0x29, 0x21, 0x68, 0xb9, 0x44, 0x74, 0x2a, 0x28, 0x3a,
    0x06, 0xd1, 0xc5, 0x36, 0x2c, 0xa3, 0xe5, 0xd6, 0x86, 0x74, 0x69, 0x39,
    0x34, 0x48, 0xa0, 0x87, 0x28, 0xa5, 0x6c, 0x19, 0x22, 0xad, 0x34, 0xcd,
    0xd4, 0x72, 0xd7, 0x29, 0xf5, 0x9f, 0x51, 0xe6, 0x1f, 0x9d, 0xc6, 0xff,
    0xeb, 0x10, 0x15, 0x51, 0xda, 0x46, 0x97, 0xea, 0xb9, 0xbe, 0x1f, 0xcf,
    0xe9, 0x7d, 0x3f, 0x45, 0x10, 0xfe, 0x04, 0x51, 0x7f, 0xc4, 0xfa, 0x5f,
    0xfc, 0x5f, 0xfc, 0xeb, 0xe2, 0x6e, 0x6f, 0x9d, 0x74, 0x7b, 0xeb, 0x7e,
    0xaa, 0xf0, 0xca, 0x64, 0x03, 0x69, 0xba, 0x5e, 0x21, 0x77, 0x8e, 0x9c,
    0x26, 0x65, 0x61, 0x3f, 0x7d, 0x6d, 0x56, 0xf4, 0xd1, 0x78, 0x72, 0x77,
    0x6d, 0xc7, 0xb9, 0x20, 0xf5, 0xf3, 0x8d, 0xa7, 0x92, 0x26, 0x4f, 0x05,
    0xd6, 0xa9, 0xb1, 0x24, 0xaf, 0x59, 0xc1, 0x8a, 0x7d, 0xbb, 0xb1, 0xda,
    0x63, 0x95, 0x09, 0xc5, 0xdd, 0x0f, 0xeb, 0xa4, 0x72, 0xe7, 0x2e, 0x8a,
    0x4a, 0xbb, 0x68, 0xf4, 0x38, 0xe8, 0x78, 0x11, 0x43, 0x7a, 0xd1, 0x1b,
    0x02, 0xaf, 0xa3, 0x19, 0xf3, 0x9b, 0x08, 0x0d, 0x99, 0xe9, 0x79, 0x16,
    0x4b, 0xfe, 0x8e, 0xb7, 0xa4, 0xad, 0xd3, 0x60, 0x3c, 0x8a, 0xe6, 0x1b,
    0xf1, 0x34, 0x7a, 0x97, 0xb2, 0xe1, 0xd2, 0x19, 0x94, 0xbc, 0xbc, 0xbc,
    0xaf, 0xcc, 0x99, 0x99, 0x99, 0x24, 0x37, 0xf7, 0x53, 0xb8, 0xb5, 0x16,
    0xeb, 0x8c, 0x31, 0x1e, 0x9e, 0xcb, 0xa7, 0xf0, 0xc2, 0x6a, 0xcc, 0xb6,
    0x3e, 0x50, 0x3a, 0x50, 0x94, 0x2e, 0xee, 0x95, 0x0c, 0x10, 0x67, 0xd7,
    0x58, 0xbc, 0xad, 0x07, 0xcc, 0x16, 0x08, 0x87, 0x31, 0x86, 0x62, 0xb8,
    0x7f, 0x2c, 0x11, 0x73, 0xea, 0x5e, 0xa8, 0xaa, 0xaa, 0x96, 0x82, 0x82,
    0x02, 0x29, 0x2f, 0x2f, 0x97, 0x8f, 0x68, 0x9a, 0x26, 0xa7, 0xd2, 0xf2,
    0x24, 0xd2, 0xe9, 0x90, 0x9a, 0xe2, 0xf9, 0xf2, 0xea, 0xe6, 0x09, 0x31,
    0xf4, 0xa7, 0x62, 0xe8, 0xad, 0x62, 0x04, 0x5f, 0x8b, 0xa1, 0xb7, 0xc9,
    0xd9, 0xec, 0x35, 0x32, 0xa6, 0x4d, 0x11, 0x23, 0xbc, 0x5f, 0x0c, 0xfd,
    0x81, 0x18, 0xe1, 0xbd, 0x62, 0x04, 0xa3, 0x65, 0xf0, 0xce, 0x6c, 0xb9,
    0xb6, 0x65, 0xa7, 0xa8, 0x2b, 0x57, 0xe5, 0x2b, 0xb3, 0x5e, 0xcc, 0x91,
    0xc3, 0x87, 0x0e, 0x52, 0x52, 0x52, 0x82, 0xcb, 0xe5, 0xc2, 0xe5, 0x72,
    0x31, 0x0b, 0x50, 0x54, 0x21, 0xd0, 0x69, 0xc5, 0xbd, 0xb1, 0x14, 0xc5,
    0x5a, 0x0a, 0xd8, 0x41, 0x66, 0x20, 0x32, 0x8f, 0xd0, 0xf0, 0x28, 0x96,
    0xb8, 0xa9, 0x48, 0x78, 0x13, 0xa8, 0x1e, 0x88, 0x6c, 0x03, 0xcb, 0x25,
    0xec, 0x73, 0x42, 0xf4, 0x3d, 0x7e, 0x8a, 0x0a, 0xe0, 0x4e, 0x4f, 0x56,
    0xca, 0xb8, 0x48, 0xc3, 0xa3, 0x16, 0x09, 0x0c, 0x06, 0x78, 0xd5, 0xd1,
    0x4a, 0x30, 0xa1, 0x91, 0xa0, 0xcf, 0xca, 0xf4, 0x8c, 0x10, 0x7d, 0xd5,
    0x16, 0x9c, 0xd3, 0x7d, 0x60, 0x1a, 0x04, 0x53, 0x2b, 0xa8, 0x77, 0x81,
    0x1c, 0xc4, 0xd0, 0x41, 0xf1, 0x41, 0x64, 0x3d, 0x44, 0x75, 0x80, 0x31,
    0x4a, 0xa0, 0xd7, 0x8e, 0x23, 0x3d, 0xed, 0x83, 0xf8, 0x23, 0x8b, 0xb2,
    0x53, 0x95, 0x9e, 0xf6, 0x01, 0x51, 0x55, 0x13, 0x9d, 0x39, 0x39, 0x78,
    0xcf, 0x74, 0x92, 0xbb, 0xa7, 0x97, 0x2b, 0xdb, 0x53, 0x30, 0x47, 0x54,
    0xdc, 0x05, 0x7e, 0x50, 0x0c, 0x30, 0x09, 0x19, 0xcb, 0x47, 0x68, 0xbf,
    0x65, 0x23, 0x69, 0xed, 0x66, 0x20, 0x0d, 0xa4, 0x09, 0x43, 0x53, 0x78,
    0x7e, 0x35, 0x01, 0x5b, 0x52, 0xd2, 0xc4, 0x75, 0xab, 0xaf, 0x69, 0x10,
    0xef, 0x81, 0x62, 0xe6, 0xb9, 0x9a, 0x99, 0xbd, 0x44, 0xa7, 0xa6, 0xcc,
    0x49, 0x28, 0xf8, 0x65, 0xed, 0x63, 0x62, 0xc7, 0x29, 0x3c, 0xd9, 0xce,
    0x34, 0x77, 0x10, 0x09, 0x9b, 0x78, 0x59, 0x3e, 0x8d, 0xdb, 0xe7, 0xe7,
    0x92, 0x7b, 0xfc, 0xe8, 0xe4, 0x3d, 0x1e, 0xe8, 0xd1, 0xe4, 0x49, 0xd9,
    0x65, 0x7c, 0xb5, 0x4f, 0x18, 0x8f, 0x8c, 0x13, 0x9f, 0x95, 0x45, 0x42,
    0x76, 0xf6, 0xa7, 0xdc, 0x5f, 0x5f, 0x4f, 0xd7, 0x75, 0x0f, 0x4e, 0x47,
    0x2f, 0x9a, 0xcf, 0x82, 0x3a, 0xd3, 0x4d, 0x62, 0xd1, 0x06, 0x92, 0x97,
    0x65, 0x4d, 0x2e, 0xfe, 0x16, 0xfd, 0xbd, 0xc3, 0x32, 0x3c, 0x14, 0xc0,
    0xff, 0x76, 0x88, 0x77, 0x63, 0xef, 0xbe, 0xca, 0x1d, 0xce, 0x78, 0x16,
    0x66, 0xa5, 0x4c, 0x3c, 0x90, 0x1f, 0xa1, 0xa5, 0xa1, 0x5b, 0x46, 0xfc,
    0x23, 0x8c, 0xea, 0x3a, 0xd1, 0x36, 0x1b, 0x71, 0x8e, 0x38, 0x52, 0x17,
    0x25, 0x2a, 0xf0, 0x9d, 0x49, 0xff, 0x0e, 0x7f, 0xe9, 0xdb, 0xfc, 0x37,
    0xc4, 0xef, 0x01, 0xd5, 0xdc, 0x35, 0x3e, 0x34, 0xd9, 0x72, 0x55, 0x00,
    0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

static const char* const image1_data[] = { 
"18 18 15 1",
"e c #000000",
"f c #5a5664",
"k c #655b60",
"c c #68626f",
"j c #790000",
"i c #7c3c00",
"m c #898792",
"# c #a58363",
"l c #c4c3c9",
"h c #e99900",
"a c #fdfcfa",
"g c #fefefe",
"d c #ffbf55",
"b c #ffdfaa",
". c #ffffff",
"......######.a....",
"....##bbbccd##....",
"...ccbbbceeedd#...",
"..#becbbebbbbdd#..",
".#bbbebbbbbbbbdd#.",
".#bfffbbbbbbbbbd#.",
"#bfgggfbbbbbbbbdd#",
"#bfgfefbbbeeebbdd#",
"#bfgeefbbebbbhhhd#",
"#bfgeefbbbbbbhhhd#",
"#bbfffbbbbbbbbbdd#",
"#dbbbbbbbbbbbbddd#",
".#dbbbbbbbbbbbdd#.",
".#ddbbbbbbbijddd#.",
"..#ddbjbbbijddd#..",
"...#ddijjjjddd#kll",
"....##dddddd##kkml",
"......######kkmlll"};

static const char* const image2_data[] = { 
"18 18 27 1",
"f c #000000",
"d c #336633",
"c c #576e4a",
"n c #74a97f",
"m c #76ad83",
"o c #790000",
"q c #7c3c00",
"l c #89b88e",
"# c #a58363",
"p c #a8cba1",
"g c #aecfa5",
"k c #b5d3a9",
"u c #b8d3ba",
"h c #c1dab0",
"y c #c4c3c9",
"t c #d1e2c9",
"x c #d8e5d6",
"i c #dae9bf",
"w c #e5eddd",
"j c #e99900",
"s c #eaf1d8",
"v c #f1f4e5",
"e c #f9f8f1",
"r c #fefefe",
"b c #ffbf55",
"a c #ffdfaa",
". c #ffffff",
"......######......",
"....##aaaaab#cdc..",
"...#aaaaaaaabdef..",
"..#aaaaaaaaaadgf..",
".#affffaaffffdhf#.",
".#aaaaaaaaaaadif#.",
"#aajjjjjjjjadiklf#",
"#aajjjjjjjjdiemmnf",
"#aaaaaooaaadipmmmf",
"#aaaaoqroaadstuumf",
"#aaaaorroaadeeeemf",
"#baaoqrroaadeeeemf",
".#baorroqaadeeeemf",
".#bborroaaadeeeemf",
"..#bbooqaaadvwxxmf",
"...#bbbbbbbdkmddmf",
"....##bbbbbdikmmnf",
"......######fffffy"};

static const char* const image3_data[] = { 
"18 18 45 1",
"j c #000000",
"v c #181818",
"c c #404040",
"J c #432f18",
"G c #4a4743",
"s c #4c4c4c",
"a c #535353",
"k c #565656",
"x c #595959",
"q c #5a5664",
"I c #5c4736",
"w c #5f5d5a",
"P c #655b60",
"l c #666666",
"n c #6c6c6c",
"u c #717171",
"L c #790000",
"N c #7a5d42",
"o c #7a7a7a",
"h c #808080",
"z c #816226",
"H c #847662",
"r c #848484",
"F c #857454",
"Q c #898792",
"M c #8d7245",
"# c #a58363",
"C c #a6a8aa",
"t c #a7a7a7",
"D c #ababab",
"A c #b2aca1",
"E c #b67d10",
"O c #c4c3c9",
"B c #d8d9da",
"K c #ddbf8c",
"y c #e99900",
"b c #f1f1f1",
"m c #f4f4f4",
"i c #f7f7f7",
"g c #f9f9f9",
"p c #fcfcfc",
"f c #fefefe",
"e c #ffbf55",
"d c #ffdfaa",
". c #ffffff",
"......######abc...",
"....##ddddeafcghci",
"...jjdddddjafkghfh",
"..jddjdddjafflmnfk",
".#ddddddddooffffpk",
".#ddddddddofoffffk",
"#dddqjdddqrffsfffk",
"#dddqjdddqafftfffu",
"#dddqjdddqvwfffffx",
"#dyydddddddzAffBCD",
"#dyydddddddyEFGHIJ",
"#edddddddddddddJKJ",
".#edLdddddddLdKJKJ",
".#eedLdddddLdeKKKJ",
"..#eedLLLLLeeeMKN.",
"...#eeeeeeeeee#JOO",
"....##eeeeee##PPQO",
"......######PPQOOO"};

static const char* const image4_data[] = { 
"18 18 33 1",
"p c #000000",
"a c #00427b",
"e c #2bb7f6",
"d c #4f4857",
"f c #5a5664",
"q c #655b60",
"C c #790000",
"E c #898792",
"g c #91d1fb",
"# c #996600",
"c c #9b4d00",
"D c #c4c3c9",
"b c #e1847e",
"h c #e3897f",
"i c #e38980",
"l c #e58f82",
"k c #e68f82",
"m c #e89785",
"o c #eca088",
"n c #ed9f88",
"r c #f0a88b",
"j c #f2f2f3",
"t c #f3b18f",
"u c #f4b18e",
"v c #f8b992",
"y c #fac195",
"w c #fbc195",
"x c #fbc295",
"z c #fdc797",
"A c #fec898",
"s c #fefefe",
"B c #ffdfaa",
". c #ffffff",
"......######...a..",
"....##bcbcbc##.a..",
"...#bcbcbcbcbcdea.",
"..#cbcbcbcbcbfegea",
".#hcicicicicifgjga",
".#kclclclclclfegja",
"#mkclclclclclcaaa#",
"#nnnnnnnnnnnnnnno#",
"#pppqppprrpppqppp#",
"#ssspssstussspsss#",
"#pppqpppvvpppqppp#",
"#wxwwwwwwwwwwwwyy#",
".#zzzAAAAAAAAAAz#.",
".#BBBBBBBBBBBBBB#.",
"..#BCCBBCCBBCCB#..",
"...CBBCCBBCCBBCqDD",
"....##BBBBBB##qqED",
"......######qqEDDD"};

static const char* const image5_data[] = { 
"18 18 27 1",
"b c #000000",
"a c #00427b",
"e c #2bb7f6",
"j c #655b60",
"w c #790000",
"x c #898792",
"f c #91d1fb",
"# c #996600",
"n c #a7a4ab",
"y c #c4c3c9",
"d c #e1847e",
"g c #e3897f",
"c c #e38980",
"k c #e58f82",
"i c #e68f82",
"l c #e89785",
"o c #ed9f88",
"p c #f0a88b",
"h c #f2f2f3",
"q c #f4b18e",
"r c #f8b992",
"s c #fbc195",
"u c #fdc797",
"t c #fec898",
"m c #fefefe",
"v c #ffdfaa",
". c #ffffff",
"......######...a..",
"...bbbcdddddbbba..",
"..b#ddbddddbddaea.",
"..#ccccccccccaefea",
".#gccccccccccafhfa",
".#ijjjkkkkkkjaefha",
"#ljmmmjkkkkjmmaaa#",
"#jmmnmmjoojmmnmmj#",
"#jmnbnmjppjmnbnmj#",
"#jmmnmmjqqjmmnmmj#",
"#rjmmmjrrrrjmmmjr#",
"#ssjjjssssssjjjss#",
".#tttttttttttttu#.",
".#vvvvvwwwwvvvvv#.",
"..#vvvwccccwvvv#..",
"...#vvwccccwvv#xyy",
"....##wwwwww##jjxy",
"......######jjxyyy"};

static const char* const image6_data[] = { 
"18 18 10 1",
"a c #000000",
"g c #432f18",
"c c #5a5664",
"# c #a58363",
"f c #bebebe",
"h c #c4c3c9",
"e c #fefefe",
"d c #ffbf55",
"b c #ffdfaa",
". c #ffffff",
"......######......",
"....aaabbbbaaa....",
"...acccbbbbbcca...",
"..#bbbbbbbbbbbd#..",
".#bbbbbabbabbbdd#.",
".#bbaaacbbcaaabd#.",
"#bbbbbbbbbbbbbbdd#",
"#bbbbbbccaccbbbdd#",
"#bbbbbceeeaecbbdd#",
"#bbbbceecceafcbdd#",
"#bbbbceaeaeafcbdd#",
"#dbbbcefacaefcddd#",
".#dbbceefceefcdd#.",
".#ddbbcefceecddd#.",
"..#ddbgaaaaagdd#..",
".##gggbbgdgbbgg##h",
"gbbbbbbgdddgbbbbbg",
".gggggg#####gggggh"};

static const char* const image7_data[] = { 
"18 18 13 1",
"d c #000000",
"c c #231800",
"e c #5a5664",
"i c #655b60",
"h c #790000",
"g c #7c3c00",
"k c #898792",
"# c #a58363",
"f c #bebdc0",
"j c #c4c3c9",
"b c #ffbf55",
"a c #ffdfaa",
". c #ffffff",
"......######......",
"....##aaaaab##....",
"...#caaaaadddb#...",
"..#cecaaadeaedb#..",
".#aaaaaaaaaaaabb#.",
".#aaaaaaaaaaaaab#.",
"#adddaaaddddddabb#",
"#aaaaaaaaaaaaaabb#",
"#aaaaaaaaaaaaaabb#",
"#aaaaaaaaaaaaaabb#",
"#aaaeeffeeaaaaabb#",
"#baeddaaddeaaabbb#",
".#ddfaggafddaabb#.",
".fbbaahhaaaafbbb#.",
"..#bbahhaaabbbb#..",
"...#bbfebbbbbb#ijj",
"....##edbbbb##iikj",
"......ed####iikjjj"};

static const char* const image8_data[] = { 
"18 18 11 1",
"c c #000000",
"d c #5a5664",
"g c #655b60",
"f c #790000",
"i c #898792",
"# c #a58363",
"h c #c4c3c9",
"e c #e99900",
"b c #ffbf55",
"a c #ffdfaa",
". c #ffffff",
"......######......",
"....##aaaaab##....",
"...#ccaaaaaccb#...",
"..#cddcaaacddcb#..",
".#aaaaaaaaaaaabb#.",
".#aaaaaaaaaaaaab#.",
"#aaaadcaaadcaaabb#",
"#aaaadcaaadcaaabb#",
"#aaaadcaaadcaaabb#",
"#aeeeaaaaaaaeeebb#",
"#aeeeaaaaaaaeeefb#",
"#bfaaaaaaaaaaafbb#",
".#bffaaaaaaaffbb#.",
".#bbafffffffabbb#.",
"..#bbaaaaaabbbb#..",
"...#bbbbbbbbbb#ghh",
"....##bbbbbb##ggih",
"......######ggihhh"};

static const char* const image9_data[] = { 
"18 18 9 1",
"c c #000000",
"a c #5a5664",
"e c #655b60",
"g c #898792",
"# c #a58363",
"f c #c4c3c9",
"d c #ffbf55",
"b c #ffdfaa",
". c #ffffff",
"......######aaaaaa",
"....##bbbbbaccccca",
"...#bbbbbbbbdd#ca.",
"..#bbbbbbbbbbdca..",
".#bbbbbbbbbbbcad#.",
".#bbbbbbbbbbcabd#.",
"#bbbbbbbbbbccccca#",
"#bbbbbbbbbbaaaaaa#",
"#bbbbbbbbbbbbbbdd#",
"#bbbbbbbbbbbbbbdd#",
"#bbbbbbbbbbbbbbdd#",
"#dbbbbbbbbbbbbddd#",
".#cccccbbccccccd#.",
".#ddbbbbbbbbbddd#.",
"..#ddbbbbbbdddd#..",
"...#dddddddddd#eff",
"....##dddddd##eegf",
"......######eegfff"};

static const char* const image10_data[] = { 
"18 18 14 1",
"c c #000000",
"e c #00427b",
"g c #2bb7f6",
"f c #4f4857",
"d c #5a5664",
"j c #655b60",
"i c #790000",
"l c #898792",
"# c #a58363",
"k c #c4c3c9",
"h c #f2f2f3",
"b c #ffbf55",
"a c #ffdfaa",
". c #ffffff",
"......######......",
"....##aaaaab##....",
"...#ccaaaccabb#...",
"..#cdaaaaadcabb#..",
".#acaaaaaaacaabb#.",
".#aaaaaaaaaaaaab#.",
"#aaadcaaacdaaaabb#",
"#aaadcaaacdaaaabb#",
"#aaadcaaacdaaaabb#",
"#aaaaaaaaaaaaeabb#",
"#aaaaaaaaaaaaeabb#",
"#baaaaaaaaaafgebb#",
".#baaaaaaaadggge#.",
".#bbaaaaaaadghge#.",
"..#bbiiiiiadgghe..",
"...#bbbbbbbbeeejkk",
"....##bbbbbb##jjlk",
"......######jjlkkk"};

static const char* const image11_data[] = { 
"18 18 20 1",
"b c #000000",
"h c #4e5153",
"k c #655b60",
"j c #790000",
"f c #7c3c00",
"r c #868685",
"q c #898792",
"m c #8c8e8f",
"d c #8e8b94",
"# c #a58363",
"n c #bedae1",
"l c #c4c3c9",
"g c #ced0d0",
"i c #d6d4d2",
"p c #e8e8e8",
"e c #e99900",
"o c #fefefe",
"c c #ffbf55",
"a c #ffdfaa",
". c #ffffff",
".......#####......",
".....##aaaaa##....",
"....bbaabbaaac#...",
"...bdaaaadbaaac#..",
"..#aaaaaaaaaaacc#.",
"..#aaaaaaaaaaaac#.",
".#aaabaabaaaaaacc#",
".#abbdaadbbaaaacc#",
".#adaaaaaaddaaacc#",
".#aaaaaaaaaaaaacc#",
".#eeaaaaaaaeeeacc#",
"..#efaaaaaaeeeac#.",
"..#faaaaaeaaaccc#.",
"...faaaaaaecccc#..",
".ghijjf#aa#ccc#kll",
"mnoophjjckec##kkql",
"ghnrnm.#k###kkqlll",
"..mpm............."};

static const char* const image12_data[] = { 
"18 18 29 1",
"a c #000000",
"f c #00427b",
"j c #111111",
"g c #2bb7f6",
"z c #43403a",
"r c #464646",
"c c #5a5664",
"w c #655b60",
"l c #73707c",
"o c #747474",
"e c #7c7c7c",
"A c #898792",
"i c #91d1fb",
"# c #a58363",
"x c #c4c3c9",
"v c #c4c4c4",
"t c #cdcdcd",
"q c #d8d8d8",
"s c #dcdcdc",
"h c #e99900",
"u c #ebebeb",
"k c #f2f2f3",
"n c #f5f5f5",
"p c #f9f9f9",
"y c #fcfcfc",
"m c #fefefe",
"d c #ffbf55",
"b c #ffdfaa",
". c #ffffff",
"......######......",
"...aaabbbbbbaaa...",
"..acccabbbbaccca..",
"..#bbbbbbbbbbbd#..",
".#bbaabbbbaaebdf#.",
".#bbbcabbacbbbbf#.",
"#bbbbbbbbbbbbbfgf#",
"#bhhhbbbbbhhhfgigf",
"#bhhhbbjbbhhhfikif",
"#bbbbblmjbbbbfgikf",
"#bbbbblnjbbbbbfff#",
"#dbbbblmjbbbbbddd#",
".#dbbojjjebbbbdd#.",
".#ddboppqjrbbddd#.",
"..#dblmjpjsjddd#..",
"...#dlmtjuvjdd#wxx",
"....#lmmymjz##wwAx",
"......rjjje#wwAxxx"};

static const char* const image13_data[] = { 
"18 18 13 1",
"# c #000000",
"h c #432f18",
"b c #5a5664",
"i c #655b60",
"f c #790000",
"k c #898792",
"a c #a58363",
"g c #a67666",
"j c #c4c3c9",
"c c #fefefe",
"e c #ffbf55",
"d c #ffdfaa",
". c #ffffff",
"...#.#aaaaaa......",
"..bc#cbddddea###..",
"..bc#cb#dddd##bbb.",
"..bc#cb##ddd#dea..",
".abc#cbdddddddbbb.",
".abb#bbddddddbcc#b",
"abccc#c#bdddbccc##",
"bccccc#c#bddbcbbbb",
"bcbc#c#c##ddbbbeea",
"bcbc#c#c#ddddddeea",
"bccbc#cc#ddddddeea",
"abccbccbddddddeeef",
".bccbccbddddddeegg",
".abb###ddddddeegf.",
".hddhdd#dddeeggf..",
"hddhehdd#####ffijj",
"hdh.aahddddddhiikj",
"ah....ahhhhhhikjjj"};

static const char* const image14_data[] = { 
"18 18 35 1",
"b c #000000",
"# c #2449aa",
"E c #655b60",
"f c #6f7fa6",
"j c #707c96",
"g c #7482a0",
"d c #7585b0",
"c c #778ab9",
"a c #799ddc",
"h c #88abe1",
"e c #88abe2",
"k c #88ace1",
"i c #88ace2",
"G c #898792",
"v c #8a858f",
"y c #8a8ea0",
"m c #8ca4c9",
"x c #9299a8",
"q c #97b2c7",
"z c #9ca5b4",
"o c #9dc0e9",
"l c #9ec0e9",
"n c #9ec1e9",
"p c #b3d5f1",
"t c #b3d6f0",
"r c #b3d6f1",
"s c #b4d5f0",
"u c #b4d6f1",
"C c #b5b5bd",
"w c #c2e4f6",
"F c #c4c3c9",
"D c #c4c4cb",
"A c #e6e5e7",
"B c #fefefe",
". c #ffffff",
"......######......",
"....##aaaaaa##....",
"...#aaaaaaaaaa#...",
"..#bcaaaaaaadba#..",
".#efbbghihjbbeik#.",
".#lmmmbbnbbmmono#.",
"#ppqbbrpstpbburrt#",
"vwwwwwwwwwwwwwwxb#",
"#byjjjjjjjjjjjzbw#",
"#wjAAAABBBBBACbww#",
"#wjAABBBBBBBADbww#",
"#wjABBBBBBBAADbww#",
".bjABBBBBBAAADbwb.",
".#jABBBBAAAADDbb#.",
"..#jAAAAAAADDbw#..",
"...#jDDDDDDDbw#EFF",
"....#bbbbbbb##EEGF",
"......######EEGFFF"};

static const char* const image15_data[] = { 
"18 18 13 1",
"d c #000000",
"c c #231800",
"f c #5a5664",
"i c #655b60",
"h c #790000",
"g c #7c3c00",
"k c #898792",
"# c #a58363",
"e c #b59f8a",
"j c #c4c3c9",
"b c #ffbf55",
"a c #ffdfaa",
". c #ffffff",
"......######......",
"....##aaaaab##....",
"...#caaaaaddde#...",
"..#cfcaaadfafdb#..",
".#aaaaaaaaaaaabb#.",
".#aaaaaaaaaaaaab#.",
"#adddaaaddddddabb#",
"#aaaaaaaaaaaaaabb#",
"#aaaaaaaaaaaaaabb#",
"#aaaaaaaaaaaaaabb#",
"#aaaaaaaaaaaaaabb#",
"#baaaaaaaaaaaabbb#",
".#baaaggaaaaaabb#.",
".#bbaahhaaaaabbb#.",
"..#bbahhaaabbbb#..",
"...#bbbbbbbbbb#ijj",
"....##bbbbbb##iikj",
"......######iikjjj"};

static const char* const image16_data[] = { 
"18 18 22 1",
"d c #000000",
"c c #231800",
"f c #5a5664",
"m c #5f5c69",
"s c #655b60",
"i c #736f7b",
"p c #790000",
"o c #7c3c00",
"t c #898792",
"# c #a58363",
"e c #b59f8a",
"j c #b9b7bd",
"r c #c4c3c9",
"l c #dad9dc",
"n c #e0dfe0",
"q c #e3e2e5",
"h c #eeedef",
"k c #f1f1f2",
"g c #fefefe",
"b c #ffbf55",
"a c #ffdfaa",
". c #ffffff",
"......######......",
"....##aaaaab##....",
"...#caaaaaddde#...",
"..#cfcaaadfafdddd.",
".#aaaaaaaaaadggghd",
".#aaaaaaaaaijklkgd",
"#adddaaaddddglimdf",
"#aaaaaaaaaafgggggd",
"#aaaaaaaaaafgljlkd",
"#aaaaaaaaaafglmddm",
"#aaaaaaaaaafggggj#",
"#baaaaaaaaafdlnnn#",
".#baooooaaaaddfdd.",
".#bbaoppaaaafgqd#.",
"..#bbappaaabfgqd..",
"...#bbbbbbbfggqdrr",
"....##bbbbbdggdstr",
"......######ddtrrr"};

static const char* const image17_data[] = { 
"18 18 31 1",
"c c #000000",
"d c #5a5664",
"i c #5f575d",
"n c #5f5c69",
"z c #655b60",
"s c #736f7b",
"q c #790000",
"e c #7a7782",
"w c #7f6854",
"A c #878590",
"x c #8a8791",
"h c #907661",
"y c #9996a0",
"# c #a58363",
"B c #aeadb4",
"C c #b0aeb6",
"m c #b9b7bd",
"v c #c4c3c9",
"p c #cc6600",
"k c #dad9dc",
"j c #e0dfe0",
"g c #e3e2e5",
"l c #e99900",
"u c #eeedef",
"o c #f1f1f2",
"t c #f5f5f6",
"f c #fefefe",
"r c #ffb287",
"b c #ffbf55",
"a c #ffdfaa",
". c #ffffff",
"......######......",
"....##aaaaab##....",
"...#ccaaaaacca#de.",
"..#caacaaacaacdfgc",
".#aaaaaaaaaaadffgd",
".#aaaaaaaaaaadffdh",
"#aaaadcaaadcadffc#",
"#aaaadcaaadciddcc#",
"#aaaadcaaadcjjjkcd",
"#alllaaaaaacmffffc",
"#alllaaaaaanccnkoc",
"#baaapqqqqqdokmkoc",
".#baaqrrrrrdffffkc",
".#bbaaqrrrqdcnskoc",
"..#bbaaqqqctfokoms",
"...#bbbbbbbcufffcv",
"....##bbbbbwccccxy",
"......######zzABCv"};

static const char* const image18_data[] = { 
"18 18 37 1",
"h c #000000",
"G c #655b60",
"z c #790000",
"I c #898792",
"# c #996600",
"E c #a3673c",
"F c #b47f5a",
"C c #be8b7c",
"H c #c4c3c9",
"a c #e1847e",
"f c #e28880",
"e c #e3887f",
"d c #e38880",
"b c #e3897f",
"c c #e38980",
"g c #e68f82",
"i c #e99685",
"j c #e99785",
"k c #ec9f88",
"m c #eca088",
"D c #edbea8",
"o c #f0a88b",
"n c #f0a88c",
"r c #f3b18e",
"q c #f3b18f",
"p c #f4b18f",
"s c #f7b992",
"t c #f7ba92",
"u c #f8b992",
"v c #f8ba92",
"y c #fac195",
"w c #fbc195",
"x c #fbc295",
"A c #fdc797",
"l c #fefefe",
"B c #ffdfaa",
". c #ffffff",
"......######......",
"....##aaaaaa##....",
"...#aaaaaaaaaa#...",
"..#aaaaaaaaaaaa#..",
".#bcdcdbbecccfcd#.",
".#ghgggggggggghg#.",
"#ijhhhjjjjjjhhhjj#",
"#kkhllhkkkkhllhkm#",
"#nohlhhhhhhhhlhoo#",
"#ppphhhhpphhhhpqr#",
"#stsussututsvssus#",
"#wxyyyyzzzzyyyxyy#",
".#AAAAzllllzAAAA#.",
".#BBBzCCCCCCzBBB#.",
"..#BBzCCDDDDzBB#..",
"...#BEzzzzzzFB#GHH",
"....##BBBBBB##GGIH",
"......######GGIHHH"};

static const char* const image19_data[] = { 
"18 18 38 1",
"l c #000000",
"H c #655b60",
"e c #6b6165",
"F c #790000",
"J c #898792",
"# c #996600",
"b c #9cffff",
"G c #a67666",
"I c #c4c3c9",
"a c #e1847e",
"j c #e28880",
"g c #e3887f",
"c c #e38880",
"d c #e3897f",
"h c #e38980",
"m c #e58f82",
"k c #e68f82",
"n c #e99785",
"o c #ec9f88",
"p c #ec9f89",
"q c #eca088",
"f c #f0a88b",
"u c #f3b18e",
"s c #f3b18f",
"t c #f4b18e",
"r c #f4b18f",
"v c #f7b992",
"w c #f7ba92",
"x c #f8b992",
"y c #f8ba92",
"B c #fac195",
"z c #fbc195",
"A c #fbc295",
"C c #fdc797",
"D c #fec898",
"i c #fefefe",
"E c #ffdfaa",
". c #ffffff",
"......######......",
"....##aaaaaa##....",
"...#aaaaaaaaaab...",
"..#aaaaaccccaab#..",
".#dcefcefghhijbc#.",
".#kklmmlmmmmmmik#.",
"llllellellllliiinb",
"eiilleeiiilleoipq#",
"#eeeeffeeeeeifbfi#",
"#rrrrrrsttrsrsbsu#",
"#vwvxvvxwxwvyvbxv#",
"#zAzzzzzzzzzzBABB#",
".#CCCzzzzDDDDCCC#.",
".#EEEDFFFEEEEEEE#.",
"..#EEFGEEEEEEEE#..",
"...#EFEEEEEEEE#HII",
"....##EEEEEE##HHJI",
"......######HHJIII"};

static const char* const image20_data[] = { 
"18 18 26 1",
"b c #000000",
"a c #00427b",
"e c #2bb7f6",
"j c #655b60",
"x c #898792",
"f c #91d1fb",
"# c #996600",
"n c #a7a4ab",
"w c #c4c3c9",
"d c #e1847e",
"g c #e3897f",
"c c #e38980",
"k c #e58f82",
"i c #e68f82",
"l c #e89785",
"o c #ed9f88",
"p c #f0a88b",
"h c #f2f2f3",
"q c #f4b18e",
"r c #f8b992",
"s c #fbc195",
"u c #fdc797",
"t c #fec898",
"m c #fefefe",
"v c #ffdfaa",
". c #ffffff",
"......######...a..",
"...bbbcdddddbbba..",
"..b#ddbddddbddaea.",
"..#ccccccccccaefea",
".#gccccccccccafhfa",
".#ijjjkkkkkkjaefha",
"#ljmmmjkkkkjmmaaa#",
"#jmmnmmjoojmmnmmj#",
"#jmnbnmjppjmnbnmj#",
"#jmmnmmjqqjmmnmmj#",
"#rjmmmjrrrrjmmmjr#",
"#ssjjjssssssjjjss#",
".#tttttttttttttu#.",
".#vvvvvvvvvvvvvv#.",
"..#vvvvvvvvvvvv#..",
"..bbbbbbbbbbbbbbww",
"....##vvvvvv##jjxw",
"......######jjxwww"};

static const char* const image21_data[] = { 
"18 18 19 1",
"a c #000000",
"# c #494949",
"b c #4f4f4f",
"h c #5a5664",
"n c #655b60",
"c c #676767",
"m c #790000",
"q c #898792",
"i c #95ced0",
"e c #a58363",
"d c #b3b3b3",
"j c #baeaeb",
"o c #c4c3c9",
"p c #dfdfe0",
"l c #e99900",
"k c #fefefe",
"g c #ffbf55",
"f c #ffdfaa",
". c #ffffff",
".#aaaaaaaaaaaaaa#.",
".b...c#aaaaaa.....",
".d...c#aaaaaa.....",
".b..eeffaafgee....",
".d.eaafffffaage...",
"dbdahhafffahhage..",
"bdbfffffffffffge..",
"dbdfaaaffffaaagge.",
"bebaiiiaffaiiiage.",
".eajjhajaajhajjae.",
".eakjfhkaakfhkgae.",
".efagkgaffakkgage.",
".elkaaaffffaaakge.",
"..ffllffffffllfe..",
"..efffmffffmffge..",
"...egggmmmmgggenop",
"....eeggggggeenqop",
"......eeeeeennqoo."};

static const char* const image22_data[] = { 
"18 18 15 1",
"a c #000000",
"j c #009933",
"b c #655b60",
"g c #790000",
"m c #898792",
"h c #99ff00",
"# c #a58363",
"k c #b55151",
"l c #c4c3c9",
"f c #c5a499",
"e c #e99900",
"i c #ff9933",
"d c #ffbf55",
"c c #ffdfaa",
". c #ffffff",
"......######......",
"...aabcccaad##....",
"..abccccccbacd#...",
"..#ccccccccaccd#..",
".#ccccccccccccdd#.",
".#bbacccabbccccd#.",
"#ccccaaacccccccdd#",
"#cbbacccabbccccdd#",
"#cceeeeeeecccccdd#",
"#fcccccccccccccdd#",
"gffffffffccccccdd#",
".ggggggggfccccddd#",
"...gdddhdggcccdd#.",
"..ddijiddddgcddd#.",
".jdhidhjdjkgddd#..",
".djdihiddkgddd#bll",
"jdihiddiigdd##bbml",
".j.j.jigg###bbmlll"};

static const char* const image23_data[] = { 
"18 18 14 1",
"d c #000000",
"e c #655b60",
"h c #790000",
"c c #795d3e",
"l c #898792",
"# c #a58363",
"k c #c4c3c9",
"j c #c5a499",
"g c #e99900",
"i c #fefefe",
"b c #ffbf55",
"f c #ffcc99",
"a c #ffdfaa",
". c #ffffff",
"......######......",
"....##aaaaab##....",
"...cdaaaaaddbb#...",
"..#daaaaaaaadbb#..",
".#aaaaaaaaaaaabb#.",
".#aaaaaaaaaaaaab#.",
"#aaddeaaaedddaabb#",
"#aaaadfaddaaagggb#",
"#aaaafaafaaaagggb#",
"#aaaaaaaaaaaahhbb#",
"#ahaaaaaaaahhihbb#",
"#bhhhhhhhhhjiihbb#",
".#hiijiijiijihbb#.",
".#hjijiijiijjhbb#.",
"..#hjjjjjjjjhbb#..",
"...#hjjjjjjhbb#ekk",
"....#hhhhhhb##eelk",
"......######eelkkk"};

static const char* const image24_data[] = { 
"18 18 49 1",
"e c #000000",
"# c #00427b",
"g c #2bb7f6",
"f c #4f4857",
"b c #5a5664",
"U c #655b60",
"R c #790000",
"a c #996600",
"T c #c4c3c9",
"c c #e1847e",
"l c #e3887f",
"j c #e38880",
"k c #e3897f",
"i c #e38980",
"n c #e58f82",
"o c #e68f82",
"r c #e89685",
"t c #e89785",
"q c #e99685",
"s c #e99785",
"u c #ec9f88",
"w c #ec9f89",
"x c #eca088",
"v c #ed9f88",
"z c #f0a88b",
"y c #f0a88c",
"h c #f2f2f3",
"C c #f3b18e",
"B c #f3b18f",
"A c #f4b18f",
"D c #f7b992",
"E c #f7ba92",
"F c #f8b992",
"G c #f8ba92",
"m c #f8dbda",
"J c #fac194",
"I c #fac195",
"H c #fbc195",
"K c #fdc797",
"O c #fdc798",
"N c #fdc897",
"L c #fdc898",
"M c #fec897",
"P c #fec898",
"d c #fefefe",
"p c #ff6600",
"S c #ff9900",
"Q c #ffdfaa",
". c #ffffff",
"..#...aaaaaa.bbb..",
"..#.aaccccccabde..",
".fg#cccccccccbde..",
"bggg#ccccccccbde..",
"bghg#ijkkliiibmea.",
"bggh#noononnnbpea.",
"a###qrsqsrrtsbpesa",
"auuvwvvvewwvubpexa",
"ayyzeyyzezzzzbpeza",
"aAAAeAABebABAbpeCa",
"aDEebDDFEeebGbpeDa",
"aHebIIIIIIIJHbpeIa",
".aKKKLMNOOOOPbpea.",
".aQQQQQQQQQQbpppe.",
"..aQQQQQQQQQRdSpRe",
"...aQQQQQQQQbSppRe",
"....aaQQQQQQbRpReT",
"......aaaaaaUeeeTT"};

static const char* const image25_data[] = { 
"18 18 51 1",
"e c #000000",
"g c #5a5664",
"U c #655b60",
"S c #790000",
"T c #7c3c00",
"W c #898792",
"w c #a55c1c",
"# c #a58363",
"V c #c4c3c9",
"a c #cdb999",
"c c #d0bb9a",
"d c #d0bc9a",
"f c #d0bc9b",
"l c #d4bf9b",
"j c #d4bf9c",
"h c #d5be9c",
"k c #d5bf9b",
"i c #d5bf9c",
"o c #d9c29d",
"p c #dac29d",
"m c #dac39d",
"q c #dfc7a0",
"r c #e0c79f",
"s c #e0c7a0",
"t c #e0c89f",
"u c #e0c8a0",
"v c #e6cca1",
"x c #e6cca2",
"B c #ecd0a3",
"C c #ecd0a4",
"A c #ecd1a3",
"y c #ecd1a4",
"z c #edd1a4",
"b c #efba64",
"D c #f2d5a5",
"E c #f2d5a6",
"G c #f2d6a5",
"F c #f2d6a6",
"I c #f7d9a7",
"K c #f7d9a8",
"L c #f7daa7",
"H c #f8d9a7",
"M c #f8d9a8",
"J c #f8daa7",
"Q c #fbdca9",
"P c #fbdda9",
"N c #fcdca9",
"O c #fcdda9",
"n c #fefefe",
"R c #ffdfaa",
". c #ffffff",
"......######......",
"....##aaaaab##....",
"...#aaaaaaaaab#...",
"..#aaaaaaaaaaab#..",
".#ccdecfedcdcfbb#.",
".#geghijkeggkljb#.",
"#mnenommpennmmpbb#",
"#qrrsrtuqrrrurrbb#",
"#vwxwvvvvxwxwxvbb#",
"#yyyyyzAyBAACyzbb#",
"#DwDwEEDEEwDwFGbb#",
"#bHIIJKILMIIKKbbb#",
".#bNOOPNOPQOONbb#.",
".#bbRRRRRRRRRbbb#.",
"..#bbSSSSSRbbbb#..",
"...#bTTTTTSbbb#UVV",
"....##bbbbbb##UUWV",
"......######UUWVVV"};

static const char* const image26_data[] = { 
"18 18 17 1",
"c c #000000",
"l c #474144",
"d c #5a5664",
"n c #655b60",
"e c #6b6165",
"i c #790000",
"o c #898792",
"# c #a58363",
"m c #c4c3c9",
"k c #d2d2d2",
"f c #e7e7e7",
"g c #e99900",
"h c #fefefe",
"j c #ffb287",
"b c #ffbf55",
"a c #ffdfaa",
". c #ffffff",
"......######......",
"....##aaaaab##....",
"...#ccaaaaaccb#...",
"..#caacaaacaacb#..",
".#aaaaaaaaaaaabb#.",
".#aaaaaaaaaaaaab#.",
"#aaaadcaaadcaaabb#",
"#aaaaecaaadcaaabb#",
"#aaaefcaaadcaaeeb#",
"#agefhcaaaaagehfc#",
"#aefhcaaaaaagehfc#",
"#efhcaiciiiaechfc#",
".efhcjcfcjjefhchkc",
".efhkchfcjeflhhhkc",
".efhhkcfcichhlhkc.",
".efhhhkcachlhhkcmm",
"..lkkkkcachhhkcnom",
"...lccc###ccccommm"};

static const char* const image27_data[] = { 
"18 18 15 1",
"e c #000000",
"c c #5a5664",
"k c #655b60",
"f c #790000",
"i c #7c3c00",
"m c #898792",
"# c #a58363",
"l c #c4c3c9",
"d c #fefefe",
"j c #ff6633",
"g c #ff9933",
"b c #ffbf55",
"h c #ffcccc",
"a c #ffdfaa",
". c #ffffff",
"......######......",
"....##aaaaab##....",
"...#ccaaaaccbb#...",
"..#cddcaacddcbb#..",
".#acdceaaecdcabb#.",
".#acdeeaaeedcaab#.",
"#aacdeeaaeedcaabb#",
"#aacdceaaecdcaabb#",
"#aaaccaaaaccaaabb#",
"#aaaaaaaaaaaaaabb#",
"#aaaaaaaaaaaaaabb#",
"#baafffffffffabbb#",
".#bffghihgjiffbb#.",
".#bbihihgjiaabbb#.",
"..#bigiggjibbbb#..",
"...#ijgjjibbbb#kll",
"....#iiiibbb##kkml",
"......######kkmlll"};

static const char* const image28_data[] = { 
"18 18 11 1",
"c c #000000",
"d c #5a5664",
"g c #655b60",
"e c #790000",
"f c #7c3c00",
"i c #898792",
"# c #a58363",
"h c #c4c3c9",
"b c #ffbf55",
"a c #ffdfaa",
". c #ffffff",
"......######......",
"....##aaaaab##....",
"...#aaaaaaaabb#...",
"..#cdaadcaaaabb#..",
".#acdaadcaaaaabb#.",
".#acaaaacaaaaaab#.",
"#aaaaaaaaaaaaaabb#",
"#adadaadaadaaaabb#",
"#aadaaaaddaaaaabb#",
"#aaaaaaaaaaaaaabb#",
"#aaaaaaaaaaaaaabb#",
"#baaaaaaaaaaaabbb#",
".#baaaaaaaaaaabb#.",
".#bbeefaaaaaabbb#.",
"..#bbeeaaaabbbb#..",
"...#befbbbbbbb#ghh",
"....##bbbbbb##ggih",
"......######ggihhh"};

static const char* const image29_data[] = { 
"18 18 28 1",
"# c #000000",
"o c #00427b",
"p c #2bb7f6",
"t c #2e294c",
"s c #4f4857",
"x c #5a5664",
"b c #655b60",
"h c #7a0101",
"z c #898792",
"l c #983427",
"y c #a48061",
"a c #a58363",
"f c #a7a4ab",
"g c #bf7559",
"v c #c47d5f",
"w c #c4c3c9",
"n c #dca47d",
"u c #e29542",
"m c #ebbe91",
"i c #efc495",
"r c #f0c697",
"q c #f2ac4d",
"j c #fbd9a5",
"k c #fddca7",
"e c #fefefe",
"d c #ffbf55",
"c c #ffdfaa",
". c #ffffff",
"..................",
"...##..aa####.....",
"..#bb#ac#bbbb#....",
"..#.accccbbbcda...",
"...bbcccbeeebcda..",
"..beebcbeef#ebdda.",
".bee#fbbee#febcda.",
".beeeebbeeeeebcdda",
".abeebccbeeebccdda",
".acbbccccbbbcccdda",
".accccccccccgcgdda",
".acghhicccccchcdda",
"..ahcjcckccclcgda.",
"..amhhcgncccccdha.",
"op.oqhrhcccccdla..",
"..sptuhvccccddabww",
".xpooaydddddaabbzw",
".xoo...aaaaabbzwww"};

static const char* const image30_data[] = { 
"18 18 16 1",
"d c #000000",
"e c #00427b",
"g c #2bb7f6",
"f c #4f4857",
"c c #5a5664",
"l c #655b60",
"i c #790000",
"n c #898792",
"# c #a58363",
"m c #c4c3c9",
"j c #e7d9d0",
"h c #f2f2f3",
"k c #fefefe",
"b c #ffbf55",
"a c #ffdfaa",
". c #ffffff",
"......######......",
"....##aaaaab##....",
"...caaaaaaaabbc...",
"..#cddaaaaadddc#..",
".#aacddacddcaabb#.",
".#cddaaaaacdddcb#.",
"#aeaaaaaaaaaaaebb#",
"#fgeaaaaaaaaaaebb#",
"cgheaaiiiaaaafgeb#",
"cggeaijjjiaacggge#",
"#eeaijkkkjiacghge#",
"#baijkkkkkjicgghe#",
".#bijjiikkkiaeee#.",
".#bbiiaaiiiaabbb#.",
"..#bbaaaaaabbbb#..",
"...#bbbbbbbbbb#lmm",
"....##bbbbbb##llnm",
"......######llnmmm"};

static const char* const image31_data[] = { 
"18 18 13 1",
"c c #000000",
"d c #655b60",
"h c #790000",
"k c #898792",
"# c #a58363",
"f c #a7a4ab",
"j c #c4c3c9",
"i c #c5a499",
"g c #e58f82",
"e c #fefefe",
"b c #ffbf55",
"a c #ffdfaa",
". c #ffffff",
"......######......",
"....##aaaaab##....",
"...#ccaaaaaccb#...",
"..#caacaaacaacb#..",
".#aaaaaaaaaaaabb#.",
".#aaddaaaaaaddab#.",
"#aadccdaaaadccdbb#",
"#adeefedaadefeedb#",
"#agddddgaagddddgb#",
"#aggggggaaggggggb#",
"#a#aaaaaaaaaaaa#b#",
"##ahhaaaaaaaahhb##",
".#heihhhhhhhheih#.",
".#bhieieieieiehb#.",
"..#bheieieieihb#..",
"...#bhhhhhhhhb#jjj",
"....##bbbbbb##kkkj",
"......######jjjjjj"};

static const char* const image32_data[] = { 
"18 18 14 1",
"b c #000000",
"c c #5a5664",
"j c #655b60",
"h c #790000",
"i c #7c3c00",
"l c #898792",
"# c #a58363",
"k c #c4c3c9",
"g c #db4900",
"e c #fefefe",
"f c #ff9255",
"d c #ffbf55",
"a c #ffdfaa",
". c #ffffff",
"......######......",
"....##aaabcd##....",
"..cbaaaaaabbdd#...",
"..baaaaaaaacadd#..",
".#aaaaaacccaaadd#.",
".#accaaceeecaaad#.",
"#aceecaceeecaaadd#",
"#acebbacebbbffadd#",
"#acebbacebbbgfffd#",
"#aacbbaacbbgeeffd#",
"#afgggfaffggggfdd#",
"#dafffaaafgggffdd#",
".#daaaaaafffffdd#.",
".#ddahaihaaaaddd#.",
"..#ddihhaaadddd#..",
"...#dddddddddd#jkk",
"....##dddddd##jjlk",
"......######jjlkkk"};

static const char* const image33_data[] = { 
"18 18 46 1",
"j c #000000",
"n c #5a5664",
"P c #655b60",
"G c #790000",
"R c #898792",
"# c #996600",
"L c #a3673c",
"Q c #c4c3c9",
"a c #e1847e",
"f c #e28880",
"e c #e3887f",
"d c #e38880",
"b c #e3897f",
"c c #e38980",
"i c #e58f82",
"g c #e68f82",
"h c #e68f83",
"m c #e89685",
"o c #e89785",
"k c #e99685",
"l c #e99785",
"p c #ec9f88",
"r c #ec9f89",
"s c #eca088",
"q c #ed9f88",
"u c #f0a88b",
"t c #f0a88c",
"y c #f3b18e",
"w c #f3b18f",
"x c #f4b18e",
"v c #f4b18f",
"z c #f7b992",
"A c #f7ba92",
"B c #f8b992",
"C c #f8ba92",
"H c #fac194",
"F c #fac195",
"D c #fbc195",
"E c #fbc295",
"I c #fdc797",
"M c #fdc798",
"K c #fdc897",
"J c #fdc898",
"N c #fec898",
"O c #ffdfaa",
". c #ffffff",
"......######......",
"....##aaaaaa##....",
"...#aaaaaaaaaa#...",
"..#aaaaaaaaaaaa#..",
".#bcdcdbbecccfcd#.",
".#gghiggigjjjgig#.",
"#klkkmlkljnolkkll#",
"#ppjjnqqpjrqppprs#",
"#ttutjtutuuuuuuuu#",
"#vvvvvvwxxvwvwvwy#",
"#zAzBzzBABAzCzzBz#",
"#DEFFFGGGGFHDFEFF#",
".#IIIJGKLLGMNIII#.",
".#OOOOOOOOOOOOOO#.",
"..#OOOOOOOOOOOO#..",
"...#OOOOOOOOOO#PQQ",
"....##OOOOOO##PPRQ",
"......######PPRQQQ"};

static const char* const image34_data[] = { 
"18 18 13 1",
"c c #000000",
"d c #5a5664",
"i c #655b60",
"g c #790000",
"k c #898792",
"# c #a58363",
"j c #c4c3c9",
"f c #cc6600",
"e c #e99900",
"h c #ffb287",
"b c #ffbf55",
"a c #ffdfaa",
". c #ffffff",
"......######......",
"....##aaaaab##....",
"...#ccaaaaaccb#...",
"..#caacaaacaacb#..",
".#aaaaaaaaaaaabb#.",
".#aaaaaaaaaaaaab#.",
"#aaaadcaaadcaaabb#",
"#aaaadcaaadcaaabb#",
"#aaaadcaaadcaaabb#",
"#aeeeaaaaaaaeeebb#",
"#aeeeaaaaaaaeeeab#",
"#baaafgggggfaaabb#",
".#baaghhhhhgaabb#.",
".#bbaaghhhgaabbb#.",
"..#bbaagggabbbb#..",
"...#bbbbbbbbbb#ijj",
"....##bbbbbb##iikj",
"......######iikjjj"};

static const char* const image35_data[] = { 
"18 18 17 1",
"d c #000000",
"a c #00427b",
"f c #2bb7f6",
"e c #4f4857",
"g c #5a5664",
"m c #655b60",
"k c #790000",
"j c #7c3c00",
"o c #898792",
"# c #a58363",
"n c #c4c3c9",
"i c #e99900",
"h c #f2f2f3",
"l c #fefefe",
"c c #ffbf55",
"b c #ffdfaa",
". c #ffffff",
"......######...a..",
"....##bbbbbc##.a..",
"...#dddbbbbdddefa.",
"..#dbbbbbbbbbgfffa",
".#bbbbbbbbbbbgfhfa",
".#bbbgdbbbgdbgffha",
"#bbbbgdbbbgdbbaaa#",
"#bbbbgdbbbgdbbbcc#",
"#biiibbbbbbbiiicc#",
"#biiibbbbbbbiiicc#",
"#bbbbbbbbbbbbbbcc#",
"#cbbbbjkkkjbbbccc#",
".#cbbjklllkjbbcc#.",
".#ccbklllllkbccc#.",
"..#cckkkkkkkccc#..",
"...#cccccccccc#mnn",
"....##cccccc##mmon",
"......######mmonnn"};

static const char* const image36_data[] = { 
"18 18 11 1",
"c c #000000",
"d c #5a5664",
"g c #655b60",
"e c #790000",
"f c #7c3c00",
"i c #898792",
"# c #a58363",
"h c #c4c3c9",
"b c #ffbf55",
"a c #ffdfaa",
". c #ffffff",
"......######......",
"....##aaaaab##....",
"...#aaaaaaaabb#...",
"..#aaaaaaaaaabb#..",
".#aaaaaaaaaaaabb#.",
".#aacaacaaaaaaab#.",
"#aaacaacdaaaaaabb#",
"#aadcaaacccaaaabb#",
"#accaaaaaaaaaaabb#",
"#aaaaaaaaaaaaaabb#",
"#aaaaaaaaaaaaaabb#",
"#baaaaaaaaaaaabbb#",
".#baaaaaaaaaaabb#.",
".#bbaeeeefaaabbb#.",
"..#befaaaeebbbb#..",
"...#bbbbbbbbbb#ghh",
"....##bbbbbb##ggih",
"......######ggihhh"};

static const char* const image37_data[] = { 
"18 18 14 1",
"c c #000000",
"d c #5a5664",
"j c #655b60",
"h c #790000",
"i c #7c3c00",
"l c #898792",
"# c #a58363",
"k c #c4c3c9",
"g c #e99900",
"a c #fdfcfa",
"f c #fefefe",
"e c #ffbf55",
"b c #ffdfaa",
". c #ffffff",
"......######.a....",
"....##bbbccc##....",
"...cbbbbccddde#...",
"..cccbbbcbbbbee#..",
".#bbbbbbbbdddbee#.",
".#bbbbbbbdffcdbe#.",
"#bdddbbbdfffccdee#",
"#dffcdbbdfddddbee#",
"#dddccbbdddbbggge#",
"#gggbbbbbbbbbggge#",
"#gggbbbbbbbbbbhee#",
"#ebbbbbbbbbbbbhee#",
".#ebbbbbbbbbbhie#.",
".#hebbbbbbbbhiee#.",
"..#hebbbbbhheee#..",
"...#hhhhhhieee#jkk",
"....##eeeeee##jjlk",
"......######jjlkkk"};

static const char* const image38_data[] = { 
"18 18 10 1",
"b c #000000",
"# c #2449aa",
"f c #655b60",
"c c #68626f",
"h c #898792",
"e c #a7a4ab",
"a c #c2e4f6",
"g c #c4c3c9",
"d c #fefefe",
". c #ffffff",
"......######......",
"....##aaaaaa##....",
"...bbbbbaabbbbb...",
"..#aaaaaaaaaaaa#..",
".#acccaaaaaaccca#.",
".#cdddcaaaacdddc#.",
"#cddeddcaacddeddc#",
"#cdebedcaacdebedc#",
"#cddeddcaacddeddc#",
"#acdddcaaaacdddca#",
"#aacccaaaaaacccaa#",
"#aaaaaaaaaaaaaaaa#",
".#aaaaaaaaaaaaaa#.",
".#aaaaaaaaaaaaaa#.",
"..#abbbbbbbbbba#..",
"...#aaaaaaaaaa#fgg",
"....##aaaaaa##ffhg",
"......######ffhggg"};

static const char* const image39_data[] = { 
"18 18 44 1",
"b c #000000",
"N c #655b60",
"d c #6b6165",
"M c #790000",
"P c #898792",
"# c #996600",
"c c #9cffff",
"L c #a67666",
"O c #c4c3c9",
"a c #e1847e",
"j c #e28880",
"h c #e3887f",
"f c #e38880",
"e c #e3897f",
"g c #e38980",
"m c #e58f82",
"k c #e68f82",
"l c #e68f83",
"o c #e89685",
"q c #e89785",
"n c #e99685",
"p c #e99785",
"s c #ec9f88",
"t c #ec9f89",
"u c #eca088",
"r c #ed9f88",
"w c #f0a88b",
"v c #f0a88c",
"A c #f3b18e",
"y c #f3b18f",
"z c #f4b18e",
"x c #f4b18f",
"B c #f7b992",
"C c #f7ba92",
"D c #f8b992",
"E c #f8ba92",
"H c #fac195",
"F c #fbc195",
"G c #fbc295",
"I c #fdc797",
"J c #fec898",
"i c #fefefe",
"K c #ffdfaa",
". c #ffffff",
"......######......",
"....##aaaaaa##....",
"bb.#aaaaabbbaac...",
".dbaaaaabddaaac#..",
".#ebfgfbehggijcf..",
".#kklmmmmmmmmmik#.",
"dddbnopdddbqqiiipc",
"iidbrrriidbrssitu#",
"#vvwwwwwvwwwiwcwi#",
"#xxxxxxyzzxyxycyA#",
"#BCBDBBDCDCBEBcDB#",
"#FGFFFFFFFFFFHGHH#",
".#IIIJJJJJJJJIII#.",
".#KKKLLLKKKKKKKK#.",
"..#KKMMMMKKKKKK#..",
"...#KKKKKKKKKK#NOO",
"....##KKKKKK##NNPO",
"......######NNPOOO"};

static const char* const image40_data[] = { 
"18 18 28 1",
"# c #000000",
"m c #00427b",
"n c #2bb7f6",
"t c #2e294c",
"s c #4f4857",
"x c #5a5664",
"b c #655b60",
"f c #7a0101",
"r c #84110d",
"z c #898792",
"k c #8b1e17",
"p c #983427",
"y c #a48061",
"a c #a58363",
"e c #bf7559",
"v c #c47d5f",
"w c #c4c3c9",
"l c #dca47d",
"u c #e29542",
"j c #ebbe91",
"g c #efc495",
"q c #f0c697",
"o c #f2ac4d",
"h c #fbd9a5",
"i c #fddca7",
"d c #ffbf55",
"c c #ffdfaa",
". c #ffffff",
"..................",
"...##a.aa####.....",
"..#bb#ac#bbbb#....",
"..#.accccccccda...",
"...accccccccccda..",
"..bcccccccccccdda.",
"..a#bccccb##cccda.",
".acc#bcc##cccccdda",
".acccbccbccccccdda",
".acccccccccccccdda",
".acccccccccccccdda",
".aceefgccccccccdda",
"..aechcciccccccda.",
"..ajfkcelcccccdda.",
"mn.mopqrcccccdda..",
"..sntufvcccdddabww",
".xnmmaydddddaabbzw",
".xmm...aaaaabbzwww"};

static const char* const image41_data[] = { 
"18 18 22 1",
"g c #000000",
"a c #00427b",
"e c #2bb7f6",
"d c #4f4857",
"f c #5a5664",
"r c #655b60",
"i c #790000",
"l c #7c3c00",
"t c #898792",
"# c #a58363",
"p c #a67547",
"q c #a76b4a",
"s c #c4c3c9",
"j c #ead8c4",
"h c #f2f2f3",
"k c #fefefe",
"n c #ff6633",
"o c #ff9933",
"c c #ffbf55",
"m c #ffcccc",
"b c #ffdfaa",
". c #ffffff",
"......######...a..",
"....##bbbbbc##.a..",
"...#bbbbbbbbccdea.",
"..#bbbbbbbbbbfeeea",
".#bbggfbggfbbfehea",
".#bgbbbbbbggbfeeha",
"#bbbbbbbbbbbbbaaa#",
"#bbbbbbbbbbbbbbcc#",
"#bbbbbbbbbbbbbbcc#",
"#bbbiiiiiiiibbbcc#",
"#bbijjjjjjjjibbcc#",
"#cijjkkkkkkkjiccc#",
".#ijkllllllkkicc#.",
".#cilmnlmonliccc#.",
"..#plolmonqiccc#..",
"...#lnonnliccc#rss",
"....#llllicc##rrts",
"......######rrtsss"};

static const char* const image42_data[] = { 
"18 18 24 1",
"e c #000000",
"d c #231800",
"i c #5a5664",
"a c #603913",
"o c #606060",
"s c #790000",
"r c #7c3c00",
"# c #a58363",
"u c #afaba5",
"v c #c4c3c9",
"t c #cfcfcf",
"n c #ec9094",
"c c #ed1c24",
"g c #ee2a32",
"p c #eed4b7",
"h c #f0474d",
"k c #f2555b",
"m c #f8aaad",
"j c #fcd4d6",
"l c #fef1f1",
"f c #fefefe",
"q c #ffbf55",
"b c #ffdfaa",
". c #ffffff",
"......####aaaaaaa.",
"....##bbbaccccccca",
"..d#bbbbeacfgchfca",
".didbbbeiacjfklmca",
".#bbbbbbbacgjfncca",
".#bbbbbbbachfnfnca",
"eeeobbeeeecfmgnfca",
"#bbbbbbbbaccccccca",
"#bbbbbbbbbaaaaaaa.",
"#bbbbbbbbbbbapaqq#",
"#bbbbbbbbbbbapaqq#",
"#qbbbbbbbbboooo#q#",
".#qbrrbbbboffffo#.",
".#qqssbbbbteeefuo.",
"..#qssbbbbeffffuo.",
"...#qqqqqqteeefuov",
"....##qqqqeffffovv",
"......#####eeeovvv"};

static const unsigned char image43_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x12,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x56, 0xce, 0x8e, 0x57, 0x00, 0x00, 0x03,
    0x97, 0x49, 0x44, 0x41, 0x54, 0x38, 0x8d, 0x6d, 0x94, 0x59, 0x68, 0x9c,
    0x55, 0x14, 0xc7, 0x7f, 0x77, 0x66, 0x92, 0x99, 0x64, 0xb2, 0x8f, 0x49,
    0x4c, 0x0c, 0x49, 0xa6, 0x9d, 0x34, 0x54, 0x69, 0xb5, 0x51, 0x1b, 0x91,
    0x56, 0xac, 0x54, 0x05, 0xdb, 0x92, 0x87, 0x22, 0x94, 0x8a, 0x42, 0x14,
    0xd4, 0xf6, 0xc5, 0xf8, 0xa0, 0x28, 0x8a, 0xe0, 0x9b, 0xf8, 0xa0, 0xa0,
    0x0f, 0x12, 0x5f, 0x8a, 0x62, 0x45, 0x41, 0x21, 0xa1, 0xa4, 0xb4, 0x60,
    0x0c, 0xd2, 0x5a, 0xa8, 0x60, 0x88, 0x49, 0x1b, 0x48, 0xcd, 0x46, 0xcc,
    0xd2, 0x49, 0x66, 0xf9, 0x66, 0xf9, 0xe6, 0xdb, 0xee, 0xfd, 0xae, 0x0f,
    0x59, 0xd0, 0xe8, 0x81, 0x03, 0x87, 0xc3, 0xef, 0xfc, 0x39, 0x0b, 0x1c,
    0xa1, 0xb5, 0xe6, 0xff, 0x2c, 0xff, 0xe7, 0x6f, 0xda, 0x4e, 0x2e, 0xfc,
    0x2b, 0x17, 0x8c, 0x44, 0x59, 0xfc, 0xf0, 0x54, 0xf4, 0xe1, 0x4b, 0xba,
    0xb4, 0x9b, 0x0f, 0x6d, 0x07, 0xc3, 0xc3, 0xc3, 0x7a, 0x68, 0x68, 0x88,
    0xc5, 0xc5, 0x45, 0xac, 0xe4, 0x02, 0x2f, 0x1d, 0xd9, 0x4b, 0xdf, 0xb3,
    0x4f, 0x82, 0x10, 0x9b, 0x80, 0x92, 0x6c, 0x14, 0x4c, 0xde, 0x9a, 0x6f,
    0x31, 0xf5, 0xb1, 0x63, 0x3b, 0x02, 0x03, 0x03, 0x03, 0xf4, 0xf5, 0xf5,
    0x89, 0x10, 0x40, 0x7f, 0x7f, 0xbf, 0x7e, 0xf1, 0xcc, 0xf3, 0xbc, 0x77,
    0xb4, 0x9e, 0xc0, 0xd1, 0x2a, 0xee, 0x39, 0x70, 0x9e, 0x8f, 0xbf, 0x1e,
    0x61, 0xda, 0x6d, 0xe0, 0x89, 0xc7, 0x7a, 0x40, 0x6b, 0xb4, 0xf6, 0x79,
    0xfd, 0xd5, 0xb7, 0xb9, 0x38, 0xf8, 0x29, 0xd6, 0xcc, 0xaf, 0x88, 0x8a,
    0x5a, 0x3a, 0x4e, 0xbf, 0xcb, 0xe9, 0x33, 0x2f, 0xd0, 0xd9, 0xd9, 0xa9,
    0x85, 0xd6, 0x9a, 0xf1, 0x9b, 0x37, 0x74, 0xcd, 0xed, 0x1f, 0xa8, 0x6a,
    0xeb, 0xa2, 0xbe, 0xab, 0x07, 0x11, 0x8e, 0x62, 0x18, 0x06, 0x86, 0x91,
    0xa5, 0xb3, 0xfd, 0x3e, 0xb4, 0xf6, 0x41, 0x29, 0x26, 0xa6, 0xa6, 0x39,
    0xf4, 0xe0, 0x43, 0xf8, 0x9e, 0x45, 0x61, 0x69, 0x86, 0x52, 0xe6, 0x2e,
    0x75, 0xc7, 0xcf, 0x63, 0x18, 0x06, 0x42, 0x6b, 0xcd, 0xf2, 0xc8, 0xe7,
    0x3a, 0x18, 0xae, 0xa4, 0xe5, 0xf8, 0x2b, 0x3b, 0x2d, 0x6b, 0xe9, 0xe0,
    0xa5, 0x67, 0x01, 0x0d, 0xbe, 0x8f, 0x56, 0x1e, 0xc1, 0x8a, 0x06, 0x42,
    0xb1, 0xf8, 0x0e, 0xe3, 0xe6, 0xd6, 0x29, 0xdc, 0xb9, 0x49, 0xec, 0xd1,
    0x53, 0x04, 0x00, 0x96, 0xc7, 0xc7, 0x98, 0x4c, 0xc2, 0xec, 0xe4, 0x38,
    0x32, 0x9f, 0x41, 0xe6, 0x33, 0x8c, 0x5e, 0xbe, 0xcc, 0xe2, 0xc2, 0x0a,
    0x22, 0x14, 0x46, 0x04, 0x43, 0x08, 0x11, 0x64, 0xf4, 0xca, 0xcf, 0x58,
    0xf3, 0xb7, 0x70, 0x56, 0xe6, 0x70, 0x56, 0xe6, 0xf8, 0x63, 0x7c, 0x82,
    0xe9, 0xb9, 0x55, 0xbc, 0xdc, 0x06, 0x22, 0x79, 0xed, 0x3b, 0x9d, 0x9d,
    0xfa, 0x09, 0xb7, 0xe5, 0x08, 0xdf, 0x8e, 0x8c, 0x02, 0x50, 0x5b, 0x1d,
    0xe5, 0xec, 0x89, 0x67, 0x68, 0xee, 0xde, 0x83, 0x3d, 0x3e, 0x89, 0x50,
    0x8a, 0xb2, 0xee, 0xbd, 0x28, 0x4f, 0xf2, 0xcb, 0x8d, 0xdf, 0xb9, 0x3e,
    0x3e, 0xb9, 0xc3, 0xf5, 0x3f, 0x7d, 0x88, 0x50, 0x63, 0x2b, 0x62, 0xfe,
    0xe2, 0xfb, 0x5a, 0x7a, 0x39, 0x1a, 0x13, 0x87, 0xf1, 0x4d, 0x09, 0x3a,
    0x00, 0x42, 0x10, 0xe9, 0x88, 0x93, 0x7c, 0xe3, 0x03, 0xca, 0xae, 0x8e,
    0x11, 0x01, 0x64, 0x5b, 0x0b, 0xd5, 0xc3, 0x17, 0x90, 0xb6, 0x85, 0x96,
    0x0a, 0xb4, 0x26, 0x14, 0x09, 0x52, 0x48, 0xcd, 0xe2, 0xd9, 0x8a, 0x80,
    0x9b, 0x5b, 0x47, 0x94, 0x95, 0xa1, 0xf1, 0xa9, 0x68, 0x6b, 0xa5, 0x32,
    0xde, 0x4e, 0x65, 0x62, 0x0f, 0xa5, 0x89, 0x29, 0xdc, 0xab, 0x63, 0x84,
    0x81, 0x18, 0x10, 0x5e, 0x5e, 0xa3, 0xf8, 0xd5, 0xf7, 0x84, 0x63, 0xb5,
    0x84, 0x63, 0x55, 0x94, 0xd7, 0x85, 0x11, 0x41, 0x45, 0x28, 0x52, 0x89,
    0x72, 0xcc, 0xcd, 0x1d, 0xf9, 0xbe, 0xc4, 0x2d, 0xe5, 0x40, 0x29, 0xb4,
    0x92, 0x20, 0x3d, 0xd2, 0x57, 0xc6, 0xf0, 0x00, 0x07, 0xc8, 0x00, 0x16,
    0x90, 0xf9, 0xec, 0x02, 0x5e, 0xd6, 0x00, 0x5f, 0x81, 0xaf, 0x50, 0x9e,
    0x83, 0x92, 0x2e, 0x56, 0x72, 0x81, 0x40, 0x79, 0x6d, 0x13, 0xb2, 0x54,
    0xc4, 0x2e, 0xa6, 0xf0, 0xa5, 0x0b, 0x4a, 0xa2, 0xa5, 0x87, 0x31, 0x7d,
    0x07, 0x13, 0xf8, 0x0b, 0xb8, 0x0e, 0x18, 0x40, 0x11, 0x30, 0xa7, 0x67,
    0xd0, 0x4a, 0xe2, 0x4b, 0x0f, 0xcf, 0x31, 0x71, 0x0a, 0x69, 0x2a, 0x9a,
    0xe3, 0x04, 0x22, 0x4d, 0x71, 0x94, 0x59, 0xc0, 0xb5, 0x0a, 0xd8, 0xb9,
    0x24, 0x5a, 0x7a, 0x20, 0x3d, 0x2c, 0xdf, 0x27, 0x0f, 0x5c, 0x02, 0xbe,
    0x04, 0xb2, 0x40, 0x1e, 0x90, 0x4a, 0x81, 0x92, 0x38, 0xa5, 0x1c, 0x8e,
    0x95, 0xc3, 0xce, 0xae, 0x53, 0x56, 0xdb, 0x44, 0xa0, 0x66, 0x5f, 0x2f,
    0xb8, 0x1e, 0xae, 0x9d, 0xc7, 0x58, 0x9f, 0xc3, 0x2d, 0xa6, 0xd1, 0xd2,
    0xa5, 0xa8, 0x35, 0x59, 0xc0, 0x04, 0x96, 0x80, 0xd4, 0xd6, 0x88, 0x3a,
    0x12, 0xc4, 0x2a, 0xa4, 0x70, 0x4b, 0x06, 0x8e, 0x69, 0xe0, 0x19, 0x69,
    0x6a, 0xf6, 0xf5, 0x12, 0x88, 0xb6, 0x3f, 0x20, 0xca, 0x6b, 0x9a, 0xf0,
    0x8c, 0x2c, 0x8e, 0x99, 0x25, 0xb5, 0x72, 0x9b, 0xfc, 0xc6, 0x02, 0xd1,
    0x83, 0x09, 0x32, 0x40, 0x3d, 0x70, 0x62, 0x4b, 0xa4, 0x10, 0xad, 0xa0,
    0xbc, 0xb9, 0x02, 0xab, 0x90, 0xc2, 0x2a, 0xa6, 0x29, 0xdd, 0x5d, 0x22,
    0x12, 0xeb, 0xa0, 0xa6, 0xeb, 0xb0, 0x08, 0x00, 0x74, 0x9f, 0x1b, 0x14,
    0x41, 0x57, 0x61, 0xe7, 0x52, 0xd8, 0xc5, 0x34, 0xb9, 0x8d, 0x79, 0xaa,
    0xf7, 0xd7, 0x91, 0x05, 0xaa, 0x80, 0x46, 0x20, 0x0d, 0x34, 0x9d, 0xec,
    0xa5, 0x54, 0xd8, 0xd8, 0xf4, 0xf4, 0x2a, 0xc2, 0xd3, 0x24, 0x5e, 0xfe,
    0x44, 0x00, 0x9b, 0x57, 0x03, 0x38, 0xf0, 0xce, 0x90, 0x28, 0xb3, 0x14,
    0x8e, 0x91, 0xc2, 0xca, 0x6f, 0x10, 0x69, 0x10, 0x24, 0xce, 0x3e, 0x4e,
    0x6a, 0x6b, 0xac, 0xca, 0x9e, 0x38, 0x89, 0xe7, 0xf6, 0x53, 0x32, 0xd6,
    0xb0, 0x53, 0xab, 0x04, 0x6c, 0xc9, 0xfd, 0x6f, 0x7e, 0x23, 0xb6, 0xeb,
    0xc5, 0xee, 0x7f, 0x34, 0xf3, 0xc5, 0x6b, 0xda, 0xcc, 0x2d, 0xa3, 0x83,
    0x01, 0x74, 0x79, 0x88, 0xcc, 0x5a, 0x11, 0xd7, 0xf6, 0x68, 0x4d, 0x34,
    0x82, 0x27, 0x09, 0xba, 0x3e, 0x91, 0x9a, 0x7b, 0xe9, 0x3e, 0x37, 0x28,
    0xfe, 0x59, 0xf7, 0x1f, 0xa1, 0x6d, 0x5b, 0xfa, 0xf1, 0x23, 0x5d, 0x5c,
    0xba, 0x85, 0xef, 0x98, 0x3b, 0xb9, 0x48, 0x53, 0x9c, 0xfa, 0x83, 0x4f,
    0x11, 0x7b, 0xe4, 0xa4, 0xd8, 0xcd, 0xff, 0x0d, 0x86, 0xe1, 0xdc, 0xfc,
    0x85, 0xff, 0x5a, 0x46, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44,
    0xae, 0x42, 0x60, 0x82
};

static const unsigned char image44_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x12,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x56, 0xce, 0x8e, 0x57, 0x00, 0x00, 0x03,
    0x95, 0x49, 0x44, 0x41, 0x54, 0x38, 0x8d, 0x6d, 0x94, 0x4b, 0x48, 0xdc,
    0x77, 0x10, 0xc7, 0x3f, 0xbf, 0x7d, 0xaf, 0x6b, 0x57, 0x57, 0xd9, 0xf5,
    0xed, 0xee, 0xa6, 0x31, 0xa9, 0xa6, 0x5a, 0x1b, 0x8d, 0x09, 0x69, 0x92,
    0x3e, 0x02, 0xa1, 0x79, 0x48, 0x9b, 0x0a, 0xd5, 0x43, 0x09, 0x3d, 0x04,
    0x02, 0x2d, 0x18, 0x7a, 0x28, 0xa1, 0xc1, 0x42, 0x43, 0x49, 0xe8, 0x21,
    0x87, 0xb6, 0x34, 0xb4, 0x0d, 0x94, 0x9e, 0x0a, 0xc9, 0xa1, 0x87, 0xd6,
    0xb4, 0x95, 0x12, 0x2c, 0x18, 0x21, 0xd4, 0x2a, 0x68, 0xd4, 0x4a, 0x62,
    0xaa, 0xeb, 0x1a, 0x4d, 0xdc, 0x44, 0xdd, 0x87, 0xfb, 0xfc, 0xff, 0xff,
    0x3b, 0x3d, 0x18, 0x02, 0x89, 0xce, 0x65, 0x60, 0x66, 0xf8, 0x30, 0xcc,
    0xe3, 0xab, 0x44, 0x84, 0xcd, 0x2c, 0x3e, 0x3d, 0x24, 0x99, 0xa5, 0xd9,
    0xa7, 0x62, 0x66, 0x87, 0x8b, 0xd0, 0xb9, 0x76, 0x57, 0x4b, 0xaf, 0xa4,
    0x9e, 0xad, 0x57, 0xcf, 0x82, 0x22, 0x83, 0x57, 0xe5, 0xd1, 0x3f, 0xbd,
    0xd8, 0x9c, 0x2e, 0x9c, 0xde, 0x6a, 0x50, 0x6a, 0x3d, 0x61, 0xe8, 0x18,
    0x5a, 0x8e, 0x54, 0x24, 0x4c, 0x49, 0x6b, 0x3b, 0xbe, 0x7d, 0x9d, 0x6a,
    0x53, 0xd0, 0x48, 0xbb, 0x2a, 0x98, 0x79, 0xb9, 0x2b, 0x79, 0xf7, 0xce,
    0x24, 0xae, 0xb2, 0x00, 0x56, 0x77, 0x29, 0x87, 0x8f, 0xb4, 0x53, 0x51,
    0x5e, 0x01, 0x22, 0xdc, 0xbf, 0xbf, 0xc0, 0x1f, 0xbf, 0xf7, 0x82, 0xa1,
    0xb3, 0x7a, 0x77, 0x94, 0x17, 0x76, 0xee, 0xc5, 0x7f, 0xf3, 0x87, 0x27,
    0xdd, 0x29, 0x11, 0xa1, 0xf5, 0x79, 0x55, 0xd4, 0xd2, 0xd4, 0x16, 0xcd,
    0xa7, 0x63, 0xec, 0x6c, 0xdd, 0x83, 0x32, 0x5b, 0xc0, 0x64, 0x62, 0x70,
    0x70, 0x80, 0xf3, 0x17, 0x2e, 0x22, 0x92, 0xa7, 0xab, 0xf3, 0x38, 0xcd,
    0x2f, 0x35, 0xd3, 0xdc, 0xd8, 0x84, 0x18, 0x1a, 0x7d, 0xd7, 0xaf, 0x53,
    0x5e, 0xe5, 0x67, 0xe4, 0xd6, 0x50, 0xf1, 0xf0, 0x7f, 0x12, 0x53, 0x22,
    0xc2, 0xb5, 0x4b, 0x67, 0x25, 0x3c, 0x35, 0xc4, 0x89, 0x93, 0xdd, 0x2c,
    0x44, 0x33, 0x84, 0x97, 0x96, 0x29, 0xf6, 0x78, 0xf0, 0x79, 0x3d, 0x54,
    0x54, 0x56, 0x91, 0x88, 0xc5, 0x98, 0x98, 0x98, 0x24, 0x97, 0xd5, 0x10,
    0x43, 0x67, 0x7f, 0x4b, 0x03, 0x92, 0x49, 0xd1, 0x73, 0xe1, 0x3c, 0xaf,
    0xbc, 0x7e, 0x84, 0x8e, 0x0f, 0x3e, 0x53, 0x6a, 0xe0, 0x30, 0x5e, 0xcf,
    0x81, 0xb7, 0x23, 0x25, 0x2f, 0xee, 0x61, 0x30, 0x94, 0xe1, 0xe3, 0x2f,
    0xbe, 0x23, 0x50, 0x53, 0xc9, 0xd8, 0xbf, 0xd3, 0x74, 0x9f, 0x3a, 0xc1,
    0xa7, 0x67, 0x4e, 0x33, 0x36, 0x36, 0xce, 0xae, 0x83, 0x1d, 0x34, 0x35,
    0xd4, 0x51, 0x54, 0xe8, 0xa2, 0xe8, 0xb9, 0x02, 0x2e, 0x9f, 0xeb, 0xa6,
    0xc8, 0x61, 0x65, 0x61, 0xf8, 0x4f, 0x1e, 0xfc, 0xf2, 0xbd, 0x4f, 0x2d,
    0xdd, 0xb8, 0x22, 0x2b, 0x63, 0x7d, 0x58, 0x6b, 0x9b, 0xf8, 0xe8, 0xab,
    0x9f, 0xb9, 0x7c, 0xb1, 0x07, 0x4f, 0x49, 0x29, 0xb1, 0x54, 0x96, 0x81,
    0xbf, 0x47, 0x79, 0xeb, 0xd8, 0x21, 0x66, 0x67, 0x43, 0xcc, 0x85, 0xc2,
    0x1c, 0xd8, 0xd5, 0x88, 0x68, 0x39, 0x7e, 0xed, 0xeb, 0x67, 0x6e, 0x7e,
    0x81, 0x0f, 0xdf, 0x7d, 0x93, 0xe5, 0x99, 0x51, 0x0a, 0x82, 0x6d, 0xa8,
    0x99, 0x9f, 0x7a, 0x44, 0x94, 0x86, 0xb7, 0x7e, 0x1f, 0x8b, 0x09, 0x8d,
    0x40, 0x6d, 0x0d, 0x20, 0x28, 0xb3, 0x19, 0xcc, 0x16, 0x50, 0x26, 0x90,
    0x3c, 0xa2, 0x6b, 0xa0, 0xe7, 0x10, 0x43, 0x07, 0x4c, 0x84, 0xc2, 0x0b,
    0xf8, 0x7d, 0x1e, 0x62, 0xf3, 0x13, 0xe4, 0x52, 0x59, 0x4c, 0x7a, 0x32,
    0x8a, 0xa3, 0x2c, 0x80, 0xb2, 0xbb, 0x08, 0x06, 0x02, 0x28, 0x8b, 0x1d,
    0x65, 0x2f, 0x44, 0x0c, 0x0d, 0xd1, 0x35, 0x44, 0xcf, 0x22, 0x7a, 0x0e,
    0x0c, 0x1d, 0xc9, 0x1b, 0x28, 0x5b, 0x01, 0x26, 0x9b, 0x93, 0x60, 0x30,
    0x80, 0x72, 0x14, 0xe0, 0xac, 0xdc, 0x06, 0x26, 0x13, 0x96, 0xbc, 0x9e,
    0x63, 0x6d, 0x71, 0x0a, 0xb3, 0xa1, 0x61, 0x2e, 0xdf, 0x0a, 0x16, 0xeb,
    0xfa, 0xd6, 0xcc, 0x16, 0x94, 0xc9, 0x00, 0x14, 0x88, 0x20, 0x92, 0x07,
    0x43, 0x23, 0x9f, 0x4d, 0x83, 0xa1, 0x21, 0x7a, 0x0e, 0x3d, 0x93, 0x24,
    0x1d, 0x8f, 0xb0, 0x16, 0xba, 0x85, 0xc5, 0x56, 0xe4, 0x23, 0xbd, 0xb6,
    0x48, 0x66, 0xed, 0x11, 0xb3, 0xd3, 0x36, 0xae, 0x7e, 0x73, 0xe9, 0xf1,
    0x11, 0x2a, 0x50, 0xac, 0x7b, 0x04, 0x84, 0xc7, 0x5e, 0xf0, 0xd6, 0x35,
    0x70, 0xfa, 0x54, 0x17, 0x5a, 0x36, 0x49, 0x36, 0xb1, 0x8c, 0xb3, 0x2c,
    0x88, 0xc5, 0xe1, 0x0b, 0xb2, 0xb6, 0x74, 0x9b, 0x5c, 0x61, 0x82, 0x15,
    0xd1, 0x79, 0x2f, 0x3e, 0x4e, 0xff, 0x2a, 0x3c, 0xd4, 0x36, 0xfd, 0x1c,
    0x3a, 0x7d, 0x70, 0x3b, 0x51, 0x82, 0x61, 0xb6, 0x92, 0x4d, 0xc7, 0xc8,
    0xac, 0x46, 0x70, 0x55, 0x36, 0x62, 0x71, 0x6f, 0xdb, 0xcd, 0xa3, 0x91,
    0x5e, 0x72, 0x99, 0x38, 0xfe, 0xed, 0x01, 0x66, 0xb2, 0xeb, 0x90, 0xf9,
    0xac, 0xda, 0x9c, 0x84, 0x60, 0xaf, 0x08, 0x90, 0x5e, 0xbd, 0x47, 0x36,
    0x19, 0x45, 0x8b, 0x2e, 0xe3, 0x7e, 0x6d, 0x37, 0x26, 0x57, 0xed, 0x0e,
    0x65, 0x73, 0xfb, 0xd0, 0xa2, 0xab, 0x14, 0xe7, 0x23, 0x24, 0x1a, 0x5f,
    0xc5, 0x6b, 0xdd, 0x1c, 0xe1, 0xb5, 0x0a, 0x09, 0x1d, 0xaa, 0x0f, 0x1d,
    0x27, 0xf9, 0x30, 0x44, 0xea, 0x41, 0x18, 0x47, 0xa9, 0x1f, 0x77, 0x5d,
    0x9b, 0x32, 0x01, 0x54, 0x1f, 0xed, 0xc6, 0x9c, 0x33, 0x58, 0x1a, 0xe9,
    0xa5, 0xfe, 0xfd, 0x93, 0xd4, 0x94, 0x16, 0x63, 0x57, 0x1b, 0x55, 0x61,
    0xaf, 0x1b, 0x56, 0x8e, 0x9e, 0xa2, 0xdc, 0xb8, 0x43, 0x6a, 0x79, 0x11,
    0xa5, 0x09, 0xd5, 0xc7, 0xba, 0x9f, 0x7e, 0xda, 0xe8, 0xf8, 0x5f, 0x32,
    0x7f, 0xed, 0x4b, 0x72, 0x36, 0xc1, 0xb1, 0xfd, 0x20, 0x37, 0xbf, 0xfd,
    0x91, 0xfe, 0xe1, 0x31, 0x04, 0x85, 0x5d, 0x09, 0x5b, 0x9c, 0xb0, 0xff,
    0xcc, 0xe7, 0x54, 0x79, 0xe2, 0x64, 0x96, 0xe6, 0xb0, 0xe4, 0x2d, 0xf8,
    0xdf, 0x39, 0x8b, 0xab, 0x76, 0x87, 0xda, 0x20, 0x23, 0xc9, 0xf0, 0xa4,
    0xdc, 0xfb, 0xed, 0x6b, 0x92, 0xb1, 0x7b, 0x38, 0x2b, 0xb6, 0x32, 0x9b,
    0x76, 0x12, 0x8b, 0xc7, 0x01, 0x45, 0xfd, 0x96, 0x4a, 0x54, 0x64, 0x0a,
    0x12, 0x09, 0x1c, 0xee, 0x72, 0xfc, 0x1d, 0x9f, 0xe0, 0xf0, 0x05, 0x9e,
    0x0c, 0x72, 0x83, 0x1e, 0x01, 0x64, 0x22, 0x21, 0x89, 0xdc, 0xb8, 0xc2,
    0x5a, 0x78, 0x82, 0x7c, 0x36, 0xf9, 0x24, 0xee, 0xf0, 0x05, 0xf1, 0x34,
    0xbd, 0xb1, 0xa9, 0xb8, 0xfd, 0x0f, 0xa2, 0xf1, 0xab, 0x9c, 0xb0, 0x08,
    0xc7, 0x23, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42,
    0x60, 0x82
};

static const unsigned char image45_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x12,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x56, 0xce, 0x8e, 0x57, 0x00, 0x00, 0x03,
    0x48, 0x49, 0x44, 0x41, 0x54, 0x38, 0x8d, 0x6d, 0x94, 0x5d, 0x68, 0x9b,
    0x55, 0x18, 0xc7, 0x7f, 0x6f, 0xde, 0x34, 0xc9, 0x9b, 0xa6, 0xcb, 0xbb,
    0xa6, 0x9f, 0xa6, 0xeb, 0xb2, 0xcc, 0x66, 0x61, 0x93, 0x51, 0xbd, 0xd8,
    0x96, 0xd9, 0x7d, 0x60, 0x71, 0xa5, 0x82, 0x73, 0xd5, 0x8e, 0xf9, 0x45,
    0xfd, 0x44, 0x85, 0x2a, 0x78, 0xa5, 0x77, 0xa3, 0x82, 0x57, 0xbd, 0x18,
    0x88, 0x82, 0x28, 0x28, 0x78, 0x31, 0x70, 0xbb, 0x19, 0x7e, 0xe1, 0x36,
    0x84, 0x6d, 0xb5, 0x38, 0x32, 0x56, 0x32, 0xaa, 0x94, 0x36, 0xab, 0xb5,
    0xed, 0x9a, 0xaf, 0x26, 0x4d, 0x93, 0x36, 0x5f, 0x6f, 0x9a, 0xb7, 0xc7,
    0x8b, 0x68, 0xb6, 0x2c, 0x3d, 0x97, 0xcf, 0x73, 0xce, 0xef, 0x70, 0xfe,
    0xe7, 0xff, 0x7f, 0x24, 0x21, 0x04, 0x0f, 0xaf, 0x54, 0x60, 0x4c, 0xa4,
    0x02, 0x63, 0x14, 0x13, 0x91, 0x4a, 0x4d, 0xe9, 0xf4, 0x60, 0xdd, 0xd1,
    0x85, 0xe3, 0xc9, 0x67, 0xa4, 0x9a, 0x03, 0x80, 0xf4, 0x30, 0x28, 0x38,
    0x3a, 0x2c, 0x84, 0xb6, 0x8e, 0xa3, 0xfb, 0x20, 0x26, 0xb5, 0xb1, 0xaa,
    0xb7, 0xfe, 0xf7, 0x24, 0x99, 0x70, 0x8c, 0xa6, 0x63, 0x83, 0x35, 0xc0,
    0x2a, 0xd0, 0x9d, 0xf7, 0x4f, 0x08, 0x93, 0xdd, 0x4e, 0xd7, 0xeb, 0x1f,
    0x60, 0x54, 0xac, 0x35, 0xb7, 0x8a, 0x8d, 0x35, 0x4a, 0xb9, 0x14, 0xd1,
    0xdf, 0xc7, 0x48, 0xfe, 0x35, 0x45, 0xf7, 0x17, 0x57, 0xa5, 0x1a, 0xd0,
    0xd4, 0xc8, 0x6b, 0x42, 0x71, 0x6c, 0xc7, 0xe2, 0xeb, 0x45, 0x55, 0x55,
    0x2c, 0x16, 0xa5, 0x16, 0x54, 0xca, 0xb2, 0x6e, 0x56, 0x69, 0x28, 0x26,
    0x59, 0xb8, 0x74, 0x81, 0x7c, 0x2a, 0xcf, 0xde, 0x91, 0xef, 0x24, 0x00,
    0xc3, 0xff, 0xcf, 0xd1, 0x64, 0x09, 0xd7, 0xc0, 0xab, 0x5c, 0xbf, 0x71,
    0x8d, 0xcb, 0x57, 0x7e, 0xdd, 0x4a, 0x06, 0xb2, 0xd9, 0x34, 0x3f, 0xc5,
    0x8d, 0x48, 0x2d, 0xfb, 0xe9, 0xec, 0x3f, 0x81, 0xa2, 0x68, 0x04, 0x47,
    0x87, 0x05, 0x80, 0x21, 0x33, 0x13, 0x10, 0x5a, 0x6c, 0x81, 0xdf, 0x96,
    0xd3, 0x44, 0xa3, 0x11, 0x0e, 0x1d, 0xf4, 0x31, 0x3d, 0x3d, 0x4d, 0x34,
    0x5a, 0x16, 0x5a, 0x6c, 0x6e, 0x20, 0x8a, 0xab, 0x08, 0x2d, 0x41, 0x3c,
    0xb1, 0x82, 0x3f, 0x14, 0x21, 0x62, 0x6c, 0x44, 0xda, 0xb6, 0x13, 0xe7,
    0xd1, 0x03, 0x68, 0xa1, 0x19, 0x32, 0x33, 0x01, 0x21, 0xbf, 0xb5, 0x47,
    0x1d, 0x59, 0x92, 0x0c, 0x94, 0x1a, 0x54, 0x7a, 0x7a, 0x8e, 0xa2, 0xaa,
    0xdb, 0x29, 0xe9, 0x3a, 0x3f, 0x5f, 0xb9, 0xca, 0x6e, 0x8f, 0x07, 0x9b,
    0x71, 0x03, 0x28, 0x01, 0x82, 0x50, 0x6c, 0x85, 0x09, 0x1c, 0x38, 0x3a,
    0xdc, 0xb8, 0xed, 0xcd, 0x48, 0xeb, 0x0b, 0xc8, 0x92, 0x46, 0x72, 0x2a,
    0x88, 0xdc, 0xdf, 0x26, 0x8d, 0x4c, 0x6d, 0x5a, 0x38, 0xf5, 0xf6, 0x47,
    0xd8, 0xe4, 0x0d, 0x00, 0x5c, 0x87, 0x9e, 0xc5, 0x58, 0x6f, 0xe7, 0xc2,
    0xf7, 0xe7, 0x49, 0x25, 0x63, 0x58, 0x4c, 0x32, 0xaa, 0x6a, 0x67, 0x7e,
    0x29, 0xc6, 0x9f, 0x75, 0xad, 0xec, 0x71, 0xb9, 0x71, 0x9b, 0x0c, 0x50,
    0xca, 0x21, 0x6b, 0x11, 0xc2, 0xe3, 0xb7, 0x30, 0xe8, 0xb9, 0x0c, 0x7d,
    0xa7, 0x5f, 0xa1, 0xcd, 0xe5, 0x85, 0x3a, 0x85, 0x4f, 0xce, 0x7d, 0xcd,
    0xc0, 0xe0, 0x19, 0xda, 0x77, 0x7a, 0xf9, 0xf0, 0xec, 0x39, 0x2c, 0xd6,
    0x06, 0x6e, 0xfa, 0xfd, 0x00, 0xe4, 0xf2, 0x1a, 0x00, 0x26, 0xc3, 0x7f,
    0x3f, 0xd5, 0xd2, 0x8d, 0xa9, 0xa1, 0x1e, 0x3d, 0x9f, 0xc1, 0xd0, 0x56,
    0xaf, 0x10, 0x0d, 0x2d, 0xf2, 0xc6, 0xd0, 0xcb, 0x88, 0x4c, 0x84, 0xa1,
    0x53, 0xc7, 0xb1, 0x97, 0x42, 0x1c, 0x3f, 0xe2, 0x63, 0xe0, 0xf9, 0xd3,
    0x44, 0x23, 0x21, 0x5e, 0x7c, 0xe1, 0xb9, 0x8a, 0xe0, 0x76, 0xe3, 0x03,
    0xea, 0xcb, 0x66, 0x30, 0x6d, 0x03, 0xc0, 0x28, 0x2b, 0x36, 0x2e, 0x9e,
    0xbf, 0xc8, 0x50, 0xdf, 0x5e, 0x30, 0x18, 0xd9, 0xe5, 0xf6, 0xf0, 0xed,
    0xa7, 0xef, 0x32, 0x3f, 0x3f, 0xc7, 0x42, 0x64, 0x15, 0x97, 0xbb, 0x0b,
    0x49, 0x36, 0xdd, 0x07, 0x2d, 0xcf, 0x11, 0x2f, 0xf5, 0x82, 0x19, 0xd0,
    0x35, 0x8a, 0x2b, 0x11, 0x64, 0xc5, 0x86, 0x34, 0xfb, 0xf9, 0xc7, 0xc2,
    0xde, 0xd1, 0x4c, 0xe3, 0xbe, 0x7d, 0x48, 0x4a, 0x53, 0x79, 0xb7, 0xd5,
    0x01, 0x08, 0x10, 0x25, 0x44, 0x3e, 0x01, 0x5a, 0x0a, 0x80, 0xe0, 0x3f,
    0x21, 0xfc, 0x77, 0xc3, 0x8c, 0x3f, 0x3e, 0xc8, 0x3b, 0x4e, 0x99, 0x27,
    0xd2, 0x7e, 0x92, 0x81, 0xdb, 0xac, 0xa5, 0xeb, 0x91, 0x12, 0xe3, 0xbf,
    0x88, 0xf0, 0xa5, 0xaf, 0x78, 0xec, 0xec, 0x97, 0x90, 0x4d, 0x80, 0x5e,
    0x7c, 0xc0, 0x80, 0x39, 0xd0, 0x33, 0xb5, 0xc6, 0x2c, 0xa4, 0x20, 0x1b,
    0x06, 0x60, 0xf6, 0xc7, 0x31, 0x9a, 0xfa, 0xdf, 0x2b, 0x3b, 0x3b, 0x38,
    0x3a, 0x2c, 0xcc, 0xed, 0xed, 0x84, 0x15, 0x3b, 0x05, 0xad, 0x00, 0x80,
    0xd9, 0x64, 0xc0, 0xe5, 0x74, 0xd0, 0xd6, 0xda, 0x72, 0x1f, 0xb0, 0xa9,
    0x43, 0x2e, 0x0a, 0x5a, 0x1a, 0x80, 0xf8, 0xe4, 0x2c, 0xc9, 0xa5, 0xb2,
    0xbb, 0x2b, 0x11, 0xb9, 0xfc, 0xe6, 0x11, 0x31, 0xa1, 0x6d, 0xe2, 0x7b,
    0xaa, 0x07, 0xe4, 0x3a, 0x52, 0xe9, 0x35, 0xe6, 0x17, 0xef, 0x51, 0x28,
    0x68, 0x78, 0x3d, 0x8f, 0xd2, 0x77, 0xec, 0x00, 0x16, 0x7d, 0x15, 0x74,
    0xad, 0x02, 0x89, 0xde, 0x99, 0xab, 0xe4, 0xad, 0x2a, 0xb4, 0x9f, 0xbd,
    0x74, 0x58, 0x9c, 0xec, 0xee, 0xa4, 0xb3, 0xd7, 0x07, 0x86, 0x3a, 0x00,
    0x52, 0xe9, 0x35, 0xae, 0xdf, 0x9c, 0xc0, 0xbb, 0xcb, 0x89, 0x77, 0x77,
    0x07, 0x00, 0x8b, 0xd7, 0x6e, 0x93, 0xcf, 0x9b, 0x2b, 0x39, 0xab, 0x01,
    0x41, 0x39, 0xbc, 0xe4, 0x96, 0x71, 0x1e, 0xde, 0x8f, 0xed, 0x91, 0xe6,
    0xaa, 0x5e, 0x26, 0x1c, 0x27, 0xf4, 0xc7, 0x24, 0x58, 0x5b, 0xaa, 0x20,
    0x5b, 0x82, 0xa0, 0x3c, 0xd8, 0xc2, 0x3f, 0x7c, 0x43, 0xfe, 0xde, 0xdd,
    0xaa, 0xba, 0xb2, 0xa3, 0x8b, 0xd6, 0xa7, 0xcf, 0x6c, 0x39, 0xdc, 0xfe,
    0x05, 0x54, 0x9e, 0x6f, 0xf9, 0x65, 0x83, 0xc4, 0x16, 0x00, 0x00, 0x00,
    0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

static const unsigned char image46_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x12,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x56, 0xce, 0x8e, 0x57, 0x00, 0x00, 0x03,
    0xa2, 0x49, 0x44, 0x41, 0x54, 0x38, 0x8d, 0x75, 0x94, 0x5d, 0x4c, 0xdb,
    0x55, 0x18, 0xc6, 0x7f, 0xff, 0x7e, 0x61, 0xa1, 0x1d, 0x94, 0x42, 0x4b,
    0x15, 0x90, 0x05, 0xd0, 0x89, 0x63, 0x61, 0x63, 0x6e, 0x99, 0x2c, 0x83,
    0xce, 0x4c, 0x85, 0x98, 0x18, 0xd8, 0x85, 0xde, 0x38, 0x12, 0x97, 0x78,
    0x61, 0x76, 0xe3, 0xd5, 0x2e, 0x25, 0x71, 0x17, 0x7a, 0x25, 0x24, 0x33,
    0xba, 0xc4, 0xc4, 0xce, 0xc4, 0x8f, 0x5d, 0x6c, 0x4a, 0x50, 0x59, 0x18,
    0x38, 0x8a, 0xab, 0x38, 0x86, 0xb3, 0x94, 0x41, 0x57, 0xbe, 0x6c, 0x59,
    0x4b, 0xdb, 0x15, 0xfa, 0x01, 0x2d, 0xd0, 0xd2, 0xf6, 0x78, 0xb1, 0xb4,
    0x64, 0x3a, 0x9f, 0xe4, 0xdc, 0xbc, 0xcf, 0xfb, 0x3c, 0xe7, 0x79, 0xcf,
    0x39, 0x39, 0x92, 0x10, 0x02, 0x80, 0xbe, 0xbe, 0x3e, 0x11, 0x8d, 0x46,
    0x01, 0xa8, 0x34, 0xe8, 0x29, 0x09, 0x2f, 0xd3, 0xa8, 0x4c, 0x90, 0xc3,
    0x4a, 0x3c, 0xc9, 0x50, 0x44, 0x41, 0x41, 0x99, 0x29, 0x5f, 0x6b, 0x6b,
    0x6b, 0xa3, 0xb5, 0xb5, 0x55, 0x02, 0x90, 0x84, 0x10, 0x74, 0x76, 0x76,
    0x0a, 0xb7, 0xdb, 0x4d, 0xfb, 0xf1, 0xa3, 0xac, 0xd9, 0x7e, 0x66, 0x15,
    0x39, 0x6b, 0x92, 0x9c, 0xcf, 0x3e, 0x78, 0x9b, 0xca, 0x52, 0x0d, 0x00,
    0xdf, 0x8f, 0xcd, 0xf2, 0xdd, 0xf0, 0x04, 0xa9, 0xf5, 0x75, 0x52, 0x1b,
    0x9b, 0xa8, 0xca, 0x4c, 0x8c, 0xdf, 0x73, 0x61, 0xb1, 0x58, 0xe8, 0xee,
    0xee, 0x96, 0x24, 0x8b, 0xc5, 0x22, 0x7a, 0x7b, 0x7b, 0xb9, 0x3d, 0x3c,
    0xc8, 0xec, 0x87, 0x67, 0x28, 0x6f, 0xa8, 0xc2, 0x64, 0x6e, 0x47, 0xd2,
    0xd6, 0xf0, 0x24, 0x88, 0xad, 0x55, 0xfc, 0xa3, 0x83, 0x84, 0xa6, 0x9c,
    0x4c, 0xec, 0x3d, 0xc9, 0xf9, 0x0b, 0x9f, 0x60, 0xb3, 0xd9, 0x12, 0x72,
    0xa0, 0xe7, 0xdc, 0x7b, 0x67, 0x09, 0x5e, 0xfb, 0x02, 0x5f, 0x41, 0x21,
    0x11, 0x63, 0x2d, 0x4b, 0x61, 0x05, 0xf1, 0x78, 0x82, 0x8a, 0xf2, 0xd2,
    0xbc, 0x41, 0x2a, 0xb5, 0x83, 0x75, 0xc2, 0xc1, 0xbc, 0x6f, 0x9d, 0xa0,
    0xb2, 0x18, 0x8f, 0x7f, 0x05, 0xc3, 0x7a, 0x80, 0x09, 0x7f, 0x0c, 0xe4,
    0x0a, 0x95, 0x22, 0x1a, 0x8d, 0x22, 0x1c, 0x56, 0x4a, 0xbb, 0xde, 0x67,
    0x7f, 0xf5, 0x6e, 0x8a, 0x65, 0x8f, 0x9b, 0x5b, 0x93, 0x0e, 0x8e, 0x1f,
    0x3e, 0x00, 0xc0, 0x2d, 0xbb, 0x0b, 0x49, 0x5f, 0x4b, 0x5d, 0x75, 0x35,
    0x1a, 0x8d, 0x86, 0xf8, 0x91, 0xd7, 0xb9, 0xfb, 0xeb, 0x20, 0x47, 0x47,
    0xc7, 0x19, 0x1d, 0x1d, 0x05, 0xef, 0xd4, 0x84, 0xb8, 0xd4, 0x73, 0x5e,
    0x24, 0x93, 0x49, 0x91, 0xcd, 0x66, 0xf3, 0x2b, 0x99, 0x4c, 0x8a, 0x6f,
    0xbe, 0xba, 0x24, 0x56, 0xa7, 0x87, 0xc5, 0xdd, 0xa1, 0x2b, 0x62, 0xe6,
    0xde, 0xf4, 0x63, 0x7c, 0x36, 0x9b, 0x15, 0x7e, 0xbf, 0x5f, 0x5c, 0x38,
    0xf3, 0xa6, 0x98, 0xbe, 0x7e, 0x4d, 0xc8, 0x1c, 0x3f, 0x7c, 0x4d, 0x53,
    0x7b, 0x17, 0x4a, 0xa5, 0x12, 0xab, 0xd5, 0x8a, 0xd9, 0x6c, 0xc6, 0xe3,
    0xf1, 0xa0, 0x54, 0x2a, 0xa9, 0x6b, 0x68, 0x62, 0xd9, 0x17, 0xc4, 0xb9,
    0x1c, 0xe2, 0x85, 0x86, 0x17, 0x01, 0xe8, 0xef, 0xef, 0xc7, 0x6c, 0x36,
    0x13, 0x8b, 0xc5, 0x30, 0x1a, 0x8d, 0xd4, 0xb7, 0xbc, 0xc2, 0xa6, 0xe3,
    0x37, 0x64, 0xdb, 0xf3, 0x7f, 0xa1, 0x52, 0xa9, 0xf2, 0x23, 0xb9, 0xdd,
    0x6e, 0x72, 0xcf, 0x20, 0x57, 0x4f, 0xed, 0xec, 0xe4, 0xf9, 0x68, 0x34,
    0x8a, 0xd5, 0x6a, 0xcd, 0xf7, 0x14, 0xee, 0xd1, 0xb2, 0x3d, 0x67, 0x87,
    0xb1, 0x77, 0x8e, 0x88, 0x91, 0x81, 0x6f, 0xff, 0x13, 0x3b, 0x9b, 0xcd,
    0x8a, 0x11, 0xcb, 0xe7, 0x42, 0x34, 0x23, 0x3c, 0x5d, 0x8d, 0x62, 0x66,
    0x66, 0xe6, 0x89, 0x3d, 0x3f, 0x7e, 0xf9, 0x91, 0x98, 0x7c, 0xf7, 0x98,
    0x90, 0x15, 0x2a, 0xe5, 0x28, 0xd6, 0x1c, 0xdc, 0x19, 0x1f, 0x7b, 0xec,
    0x9a, 0xef, 0xdc, 0x1e, 0x47, 0xe5, 0x73, 0xe2, 0x4f, 0x81, 0x4e, 0x96,
    0xc6, 0x6e, 0xbb, 0xc1, 0xe2, 0xc2, 0x7c, 0x9e, 0x4f, 0x24, 0x12, 0xd8,
    0x46, 0x06, 0x38, 0x60, 0x4c, 0x03, 0xa0, 0x90, 0xab, 0x35, 0xbc, 0x54,
    0xf9, 0x14, 0x37, 0xed, 0x57, 0x19, 0xf0, 0xba, 0x51, 0x15, 0x16, 0x93,
    0x4a, 0x6e, 0x53, 0x94, 0xdd, 0xe0, 0x64, 0x73, 0x23, 0xe7, 0x3e, 0x85,
    0xb3, 0xcf, 0xab, 0x39, 0x7d, 0xea, 0x18, 0x57, 0xaf, 0x0f, 0xb0, 0xe0,
    0xaa, 0x05, 0x20, 0x1e, 0x09, 0xd1, 0x6a, 0x0a, 0xa2, 0x51, 0x4b, 0xc4,
    0xd4, 0x1a, 0x14, 0xda, 0x7d, 0x87, 0x88, 0xaf, 0xac, 0xf2, 0xda, 0xe1,
    0x67, 0x09, 0x44, 0xbc, 0xc8, 0xca, 0xca, 0x40, 0x52, 0x53, 0x61, 0xa8,
    0x83, 0xf9, 0x39, 0xe2, 0x19, 0xa0, 0x48, 0x8b, 0xaa, 0xa8, 0x98, 0xd3,
    0xaf, 0xbe, 0x4c, 0x38, 0xba, 0x0e, 0x80, 0xae, 0x4a, 0x83, 0x32, 0x19,
    0x23, 0xec, 0xf2, 0xa0, 0xdd, 0x77, 0x08, 0x59, 0xc9, 0xc1, 0x13, 0x84,
    0x5d, 0x1e, 0x00, 0x2a, 0x74, 0x05, 0x18, 0xa4, 0x07, 0x18, 0x4b, 0x8b,
    0xa0, 0x40, 0x0b, 0xcd, 0x6d, 0x8f, 0xe6, 0x30, 0x98, 0x60, 0xcf, 0xd3,
    0xa8, 0x54, 0x4a, 0x2a, 0x0c, 0x7a, 0x8c, 0xea, 0x0d, 0x94, 0x49, 0x1f,
    0x00, 0x61, 0x97, 0x87, 0x92, 0x83, 0x27, 0x90, 0xe9, 0x5b, 0x3a, 0xa4,
    0x8c, 0x42, 0x47, 0xc8, 0xb1, 0xf0, 0x48, 0x94, 0x8e, 0x23, 0x42, 0x93,
    0x88, 0xcd, 0xc0, 0xee, 0x81, 0xfd, 0x3d, 0x07, 0xd9, 0x34, 0x22, 0xbd,
    0x4d, 0x36, 0x72, 0x1f, 0xb1, 0xe1, 0x06, 0x20, 0xe4, 0x58, 0x20, 0xa3,
    0xd0, 0xa1, 0x6f, 0xe9, 0x90, 0x64, 0x00, 0x0d, 0x3d, 0x97, 0xa5, 0x80,
    0x7d, 0x69, 0xd7, 0x4c, 0xa4, 0x11, 0x91, 0x79, 0x88, 0x04, 0xf3, 0x46,
    0xe2, 0xe1, 0x14, 0xe2, 0xe1, 0x1f, 0xb0, 0x15, 0xc8, 0x9b, 0x04, 0xec,
    0x4b, 0x34, 0xf4, 0x5c, 0x96, 0x00, 0x64, 0xb9, 0x4d, 0x9b, 0x2e, 0x0e,
    0x49, 0x61, 0xef, 0x16, 0xbe, 0xdf, 0xa7, 0xc8, 0x24, 0x53, 0x6c, 0x05,
    0xbc, 0x70, 0xff, 0x4f, 0x54, 0x32, 0x60, 0xef, 0x73, 0x6c, 0x7a, 0x9c,
    0x00, 0x64, 0x92, 0x29, 0x02, 0x93, 0x4e, 0xc2, 0xde, 0x2d, 0x9a, 0x2e,
    0x0e, 0x49, 0x39, 0xbd, 0x94, 0xfb, 0x8f, 0x72, 0x98, 0xed, 0xe9, 0x16,
    0x99, 0x88, 0x0f, 0x75, 0x59, 0x31, 0x26, 0x63, 0x35, 0x3f, 0x7d, 0xdc,
    0x4b, 0x47, 0xe7, 0x1b, 0x3c, 0x50, 0x40, 0xf9, 0xfe, 0x1a, 0x02, 0x93,
    0x4e, 0xe4, 0xba, 0x67, 0xf2, 0x49, 0xfe, 0xd7, 0x08, 0x60, 0xcd, 0xf6,
    0x8b, 0x08, 0xde, 0xb8, 0x42, 0x66, 0x71, 0x9a, 0x9a, 0xe5, 0x45, 0x82,
    0x35, 0xf5, 0xc4, 0x14, 0x2a, 0xd4, 0x55, 0xf5, 0x18, 0x4f, 0xbd, 0x85,
    0xbe, 0xa5, 0x43, 0xfa, 0xb7, 0xe6, 0x1f, 0xd4, 0x8b, 0xe6, 0xff, 0x9d,
    0xe9, 0x5f, 0x67, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae,
    0x42, 0x60, 0x82
};

static const unsigned char image47_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x12,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x56, 0xce, 0x8e, 0x57, 0x00, 0x00, 0x03,
    0x61, 0x49, 0x44, 0x41, 0x54, 0x38, 0x8d, 0x6d, 0x94, 0x5f, 0x4c, 0xdb,
    0x55, 0x14, 0xc7, 0x3f, 0xf7, 0x67, 0xd7, 0xae, 0xdd, 0x0f, 0x0a, 0xb4,
    0x02, 0x5d, 0xda, 0xad, 0x42, 0x5a, 0x16, 0xb4, 0x0f, 0xb8, 0xb1, 0x68,
    0x0c, 0x2c, 0xce, 0x2c, 0x3a, 0x83, 0xbe, 0x2c, 0x13, 0x1f, 0xcc, 0x42,
    0x9c, 0x92, 0xa8, 0x89, 0x73, 0x89, 0x0f, 0xd3, 0xf0, 0x80, 0xd1, 0x64,
    0x6a, 0x88, 0xf3, 0xc1, 0x44, 0x63, 0x32, 0x75, 0x59, 0x34, 0x61, 0xf1,
    0xef, 0x90, 0xcc, 0xa8, 0x8d, 0x52, 0x82, 0x33, 0xa8, 0x6b, 0x07, 0xc4,
    0x6c, 0x63, 0x38, 0xda, 0x32, 0x2a, 0xdd, 0x0a, 0xfd, 0xd1, 0x3f, 0xbf,
    0x96, 0xd1, 0x5e, 0x1f, 0xb0, 0x05, 0xc6, 0x4e, 0x72, 0x93, 0x7b, 0xcf,
    0x3d, 0xdf, 0x4f, 0xce, 0x39, 0x37, 0xe7, 0x22, 0xa5, 0xe4, 0xf6, 0xd5,
    0xdb, 0xdb, 0x2b, 0xdd, 0x6e, 0xb7, 0x04, 0x24, 0x20, 0xbb, 0xba, 0xba,
    0xe4, 0xec, 0xd8, 0xa8, 0xcc, 0x46, 0xae, 0xc8, 0x52, 0x8c, 0xdf, 0xef,
    0x97, 0x03, 0x03, 0x03, 0x12, 0xb0, 0x49, 0x29, 0x11, 0x52, 0x4a, 0xd6,
    0x5a, 0xfc, 0xa7, 0x7e, 0x39, 0xfc, 0xc5, 0xc7, 0xe4, 0x4d, 0x46, 0x00,
    0x62, 0xe9, 0x3c, 0x9f, 0xfd, 0x76, 0x89, 0xc4, 0x8d, 0x79, 0xfa, 0x3b,
    0x5b, 0xb1, 0x39, 0x1b, 0x98, 0xf5, 0xb4, 0x33, 0xf8, 0xe7, 0x04, 0x2e,
    0x97, 0x0b, 0xaf, 0xd7, 0x4b, 0x47, 0x47, 0x87, 0x58, 0x07, 0x8a, 0x7e,
    0xde, 0x27, 0x8d, 0x68, 0xd4, 0xf8, 0x7c, 0x28, 0x42, 0x61, 0xa1, 0x60,
    0x24, 0x93, 0xc9, 0x50, 0xc8, 0xeb, 0x1c, 0x7d, 0xf3, 0x43, 0xb4, 0x6c,
    0x8e, 0xc1, 0xbe, 0x97, 0x79, 0xef, 0xc4, 0xa7, 0xec, 0xd8, 0xd5, 0xc6,
    0xc1, 0xd7, 0xdf, 0x11, 0x25, 0xad, 0xa1, 0xb4, 0x99, 0xfe, 0xe4, 0x2d,
    0xa9, 0x5a, 0x05, 0x36, 0x5f, 0x2b, 0x17, 0xa3, 0x3a, 0x8a, 0x22, 0x09,
    0xff, 0x3b, 0xc7, 0x74, 0x64, 0x06, 0xff, 0xf0, 0x28, 0x9a, 0xa6, 0x33,
    0xaf, 0x25, 0xb1, 0xd4, 0xd5, 0x31, 0xc5, 0x66, 0x2e, 0x8e, 0x9c, 0x47,
    0x3f, 0x71, 0x5c, 0x1e, 0x3a, 0xfa, 0x9a, 0x00, 0x50, 0x4a, 0xe5, 0x18,
    0x59, 0xc4, 0xe6, 0xf3, 0x01, 0x90, 0x5f, 0x9c, 0x67, 0xe2, 0xea, 0x1c,
    0xa8, 0xf5, 0xd8, 0x5c, 0x4d, 0xe4, 0x6c, 0xf5, 0x3c, 0xd8, 0x58, 0x47,
    0xe0, 0xf8, 0x0b, 0x00, 0x3c, 0xb5, 0xbf, 0x8d, 0xe5, 0xa5, 0x5b, 0x68,
    0x7f, 0x8f, 0x94, 0xab, 0x11, 0x52, 0x4a, 0xc6, 0x5f, 0x7d, 0x42, 0xde,
    0xd7, 0xfd, 0x7c, 0xd9, 0x99, 0xce, 0xe6, 0x51, 0x2d, 0x26, 0x68, 0xdc,
    0xcf, 0xa9, 0x85, 0x4d, 0x34, 0x5d, 0xf8, 0x8a, 0x07, 0x5a, 0x9a, 0x99,
    0xf9, 0x27, 0x4e, 0xe8, 0xdc, 0x2f, 0x00, 0xec, 0x3d, 0xf4, 0x18, 0xb9,
    0x6b, 0x5f, 0x32, 0x36, 0x30, 0xc5, 0xc3, 0xef, 0x7f, 0x23, 0x0c, 0xc9,
    0x60, 0x40, 0x5a, 0x1b, 0xef, 0x59, 0xd7, 0x70, 0xd5, 0x62, 0x82, 0xad,
    0xad, 0xa0, 0xac, 0x54, 0xbe, 0xdd, 0x92, 0xe2, 0x7c, 0xff, 0x77, 0x9c,
    0xe9, 0x79, 0x1b, 0x5d, 0xd3, 0x56, 0xfa, 0x19, 0x0a, 0xd1, 0xdd, 0xb3,
    0x13, 0x67, 0x4d, 0x01, 0x00, 0x25, 0x75, 0x39, 0x48, 0x95, 0xc7, 0x4b,
    0xf1, 0x66, 0x8c, 0x62, 0xf4, 0x2a, 0x45, 0x5d, 0x42, 0xfd, 0x6e, 0xd8,
    0x52, 0xbf, 0x4a, 0xb6, 0xba, 0xf8, 0xbe, 0xef, 0xa3, 0x32, 0x04, 0x60,
    0x26, 0x14, 0x42, 0x58, 0x1c, 0x98, 0xed, 0x2a, 0xb1, 0xb3, 0x27, 0xa5,
    0x41, 0x8f, 0x5c, 0xc1, 0x79, 0xff, 0xa3, 0x14, 0xe3, 0xd7, 0x51, 0x76,
    0x3f, 0x03, 0xea, 0xdd, 0xe5, 0xe0, 0xf0, 0x92, 0x20, 0x35, 0xfa, 0x2d,
    0xd3, 0xd7, 0x67, 0x49, 0x84, 0xc3, 0xeb, 0xb2, 0x2e, 0x9d, 0x55, 0x47,
    0x15, 0x89, 0xc8, 0xe4, 0xea, 0xab, 0x89, 0x6a, 0x67, 0x19, 0xa2, 0x15,
    0x04, 0xa7, 0x27, 0xa3, 0xec, 0x88, 0x0c, 0xd1, 0xdd, 0xdc, 0xc0, 0x1b,
    0x2f, 0xbe, 0xc2, 0x4d, 0xa0, 0x12, 0x30, 0xb2, 0xd1, 0x0a, 0xd9, 0xd4,
    0xca, 0xab, 0x65, 0xe7, 0xe6, 0x90, 0xe9, 0x38, 0xe4, 0x16, 0x01, 0x38,
    0x7d, 0x2d, 0x4e, 0xeb, 0x1f, 0x27, 0x79, 0xa4, 0x66, 0x99, 0xbf, 0xce,
    0xfa, 0x19, 0x0f, 0x87, 0x89, 0x01, 0x8b, 0x77, 0x80, 0x2c, 0xa5, 0x72,
    0x18, 0xed, 0x0e, 0x14, 0xf3, 0x36, 0x2f, 0xe9, 0x48, 0x04, 0x61, 0x34,
    0x95, 0x2f, 0x6d, 0x99, 0x1b, 0x38, 0x2d, 0x0a, 0x58, 0xed, 0xfc, 0xfc,
    0xb5, 0x9f, 0x44, 0x49, 0x74, 0x07, 0x50, 0x3a, 0x96, 0xc4, 0xe2, 0xf2,
    0xa0, 0xd8, 0x1f, 0x7a, 0x9c, 0xc4, 0xc4, 0x38, 0xa2, 0xa1, 0x1d, 0x36,
    0x57, 0x02, 0x30, 0x94, 0x02, 0x51, 0x51, 0x85, 0x7e, 0xcb, 0xc8, 0xf0,
    0xd0, 0x10, 0x6d, 0x56, 0x38, 0xec, 0x80, 0x83, 0x0e, 0x70, 0x9a, 0xd7,
    0x64, 0x93, 0xce, 0x91, 0x89, 0xe7, 0xa8, 0xdd, 0xd7, 0x29, 0x0c, 0x66,
    0x97, 0x47, 0x58, 0x3c, 0xbb, 0xa4, 0xae, 0xe5, 0x30, 0x57, 0x96, 0x1a,
    0x26, 0x40, 0xd7, 0x09, 0xfe, 0x1e, 0x64, 0x8f, 0x0d, 0x7a, 0xdc, 0xab,
    0xe2, 0x6c, 0x2d, 0x9c, 0x99, 0x81, 0xa8, 0xa3, 0x89, 0xf8, 0x48, 0x00,
    0xfb, 0x9e, 0x03, 0xc0, 0xff, 0x23, 0xe2, 0x7e, 0xb6, 0x47, 0x5c, 0x7e,
    0xf7, 0x25, 0x19, 0xdc, 0xfb, 0x1c, 0xf3, 0x8a, 0x01, 0xeb, 0xd8, 0xaf,
    0x54, 0x78, 0xb7, 0x70, 0x69, 0xe0, 0x47, 0x8e, 0x38, 0x57, 0x21, 0x17,
    0x52, 0x90, 0x2e, 0x40, 0xea, 0x2e, 0xb0, 0x57, 0x17, 0xc8, 0x68, 0x66,
    0xb6, 0x3f, 0x79, 0x58, 0x00, 0xeb, 0xa7, 0x3f, 0x74, 0xec, 0x80, 0xb4,
    0x34, 0x58, 0x30, 0x2c, 0x64, 0xb0, 0xba, 0xed, 0x64, 0x4d, 0x9b, 0xf8,
    0x61, 0x70, 0x1c, 0x00, 0x55, 0x35, 0xb1, 0xf3, 0xde, 0xad, 0x54, 0x20,
    0xd1, 0x13, 0x69, 0x72, 0x7a, 0x05, 0xcd, 0xbd, 0xa7, 0xca, 0x43, 0xbb,
    0xe1, 0x1b, 0x99, 0xfa, 0xe0, 0x98, 0x4c, 0x06, 0x03, 0x28, 0x46, 0x03,
    0x66, 0x9b, 0x5a, 0xf6, 0xeb, 0x89, 0x34, 0xc5, 0xa5, 0x65, 0x00, 0x6a,
    0xf7, 0x75, 0xe2, 0x7a, 0xfa, 0x88, 0x58, 0xab, 0xdb, 0x00, 0x02, 0xd0,
    0xa3, 0x93, 0x32, 0x19, 0x0c, 0x90, 0x8d, 0x4c, 0x52, 0xc8, 0xa6, 0xca,
    0x7e, 0xf3, 0x36, 0x2f, 0xd5, 0x2d, 0xed, 0xa8, 0x4d, 0x2d, 0xe2, 0x76,
    0xcd, 0x7f, 0x05, 0x50, 0x7e, 0xef, 0xd3, 0x0f, 0x6c, 0x67, 0x00, 0x00,
    0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

static const unsigned char image48_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x12,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x56, 0xce, 0x8e, 0x57, 0x00, 0x00, 0x03,
    0xa1, 0x49, 0x44, 0x41, 0x54, 0x38, 0x8d, 0x6d, 0x94, 0x5d, 0x48, 0xdb,
    0x57, 0x18, 0xc6, 0x7f, 0xa7, 0xf9, 0x1b, 0x8d, 0xc6, 0xe6, 0x5f, 0x13,
    0xa7, 0x31, 0x7e, 0xfc, 0xb5, 0x68, 0x75, 0x5b, 0x97, 0xaa, 0xcc, 0xae,
    0x5a, 0x6c, 0x2c, 0x58, 0x56, 0x6d, 0xc1, 0x6e, 0x0c, 0x36, 0xd8, 0x60,
    0xb0, 0x4f, 0xbc, 0xe9, 0x85, 0x75, 0x0e, 0xb6, 0x8b, 0x81, 0x22, 0x14,
    0xca, 0x36, 0xe9, 0xd5, 0xc0, 0x8d, 0x32, 0x76, 0xd1, 0xc1, 0x3e, 0x5c,
    0xb7, 0xd6, 0x3a, 0xd6, 0x35, 0xb5, 0x53, 0xf7, 0x41, 0x8d, 0xb6, 0x45,
    0xed, 0x5a, 0x6d, 0x63, 0xac, 0xdf, 0xd6, 0x68, 0xa2, 0x31, 0x46, 0x3d,
    0xbb, 0xc8, 0x4c, 0x0d, 0xf5, 0x85, 0x03, 0x87, 0xf7, 0x9c, 0xe7, 0xe1,
    0x3d, 0xef, 0x79, 0x9f, 0x47, 0x48, 0x29, 0xd9, 0x2e, 0xbc, 0xae, 0x4e,
    0x19, 0xf0, 0xdc, 0x8d, 0xca, 0xe9, 0x0c, 0x46, 0x06, 0x9a, 0x5f, 0x4d,
    0x74, 0x5c, 0x95, 0xfe, 0x27, 0x00, 0x52, 0x4a, 0xa4, 0x94, 0xb4, 0xb5,
    0xb5, 0x49, 0x87, 0xc3, 0x21, 0x1d, 0x0e, 0x87, 0x2c, 0xc9, 0x49, 0x93,
    0x87, 0x32, 0x77, 0xc9, 0x8b, 0x75, 0x27, 0xe4, 0x58, 0x6b, 0x9d, 0x1c,
    0x6b, 0xad, 0x93, 0x87, 0x73, 0x53, 0x24, 0x10, 0x59, 0xaa, 0xaa, 0xca,
    0xb6, 0xb6, 0x36, 0xb9, 0x89, 0x17, 0x52, 0x4a, 0x5a, 0x5a, 0x5a, 0xe4,
    0x99, 0xe6, 0x46, 0xaa, 0x6c, 0x06, 0x4c, 0x5a, 0x3a, 0x07, 0x2a, 0x2b,
    0x51, 0x2d, 0x36, 0xb4, 0x74, 0x2b, 0x5a, 0x46, 0x1a, 0x00, 0xce, 0x9e,
    0x1b, 0x00, 0xf4, 0xf5, 0xbb, 0x98, 0x1e, 0x1e, 0xc0, 0x7d, 0xf3, 0x2e,
    0xd7, 0x67, 0x43, 0xfc, 0xf2, 0xeb, 0x15, 0xec, 0x76, 0xbb, 0x10, 0x7d,
    0x7d, 0x7d, 0xb2, 0xa6, 0xa6, 0x86, 0x2b, 0xf5, 0xaf, 0x11, 0x70, 0xdf,
    0x26, 0xfd, 0xc8, 0x71, 0x94, 0x24, 0x8d, 0x1d, 0x31, 0x0a, 0x71, 0x6a,
    0x62, 0xa4, 0xf2, 0xf5, 0xd5, 0x10, 0xc1, 0x85, 0xf0, 0x8b, 0x02, 0xc3,
    0x5d, 0xf8, 0x3d, 0xa3, 0xfc, 0xf5, 0xe7, 0x4d, 0x6e, 0x6b, 0x0e, 0x1a,
    0x4f, 0x9f, 0x11, 0x8a, 0xa6, 0x69, 0x7c, 0xd7, 0x54, 0xcf, 0x72, 0x7f,
    0x07, 0x7a, 0x93, 0x99, 0xd5, 0x75, 0x15, 0x88, 0x67, 0x75, 0x7c, 0x1c,
    0x20, 0x42, 0xb6, 0xe0, 0x9e, 0x44, 0xc4, 0x19, 0xc3, 0x44, 0x4b, 0x71,
    0x04, 0x7d, 0x21, 0xca, 0x0e, 0x15, 0x53, 0xe8, 0x0f, 0x00, 0xa0, 0x18,
    0xf5, 0x3a, 0xf4, 0xae, 0x0e, 0x62, 0x76, 0xee, 0x44, 0x28, 0x31, 0xac,
    0x4c, 0x0c, 0x13, 0x5a, 0x9c, 0x0d, 0x37, 0xdc, 0xff, 0x88, 0x64, 0xfb,
    0xb3, 0x04, 0xbd, 0x5e, 0x82, 0x73, 0x93, 0x91, 0xea, 0xd6, 0x96, 0x17,
    0x01, 0x08, 0x05, 0x41, 0xfa, 0x1e, 0xe2, 0x75, 0x75, 0xca, 0x1d, 0xde,
    0xde, 0x4e, 0x14, 0x63, 0x22, 0xc6, 0x3d, 0x45, 0x4c, 0x65, 0xed, 0xa7,
    0xee, 0xdc, 0x8f, 0xd8, 0x5e, 0xa9, 0xa5, 0xf6, 0x9b, 0x0e, 0x4c, 0x45,
    0xe5, 0x4c, 0x7b, 0x46, 0x59, 0x5a, 0x83, 0x2e, 0xbf, 0x42, 0xe9, 0xa9,
    0xd3, 0x94, 0xbc, 0x53, 0x4f, 0xfb, 0xd4, 0x3a, 0x3a, 0x7b, 0x05, 0x22,
    0xde, 0x42, 0x82, 0x35, 0x85, 0xb9, 0xae, 0x4b, 0x88, 0x7b, 0x67, 0x1b,
    0xe4, 0xae, 0xa2, 0x72, 0x92, 0x4a, 0xab, 0xa2, 0x7e, 0x73, 0x69, 0x66,
    0x8c, 0xd9, 0x91, 0x01, 0xe2, 0x75, 0x21, 0xd6, 0x82, 0xab, 0x90, 0x60,
    0x46, 0xd5, 0x0a, 0x30, 0xa8, 0xc9, 0x8f, 0xfb, 0xb6, 0xb2, 0xc4, 0xd4,
    0xb7, 0x4d, 0x4c, 0xff, 0x73, 0x03, 0x65, 0x7d, 0xd9, 0xc7, 0xc8, 0x7c,
    0x80, 0xe9, 0xbf, 0xbb, 0x21, 0xe8, 0x63, 0x79, 0x7e, 0x06, 0xb3, 0x49,
    0x4f, 0xe6, 0xee, 0x1c, 0x32, 0x6d, 0x49, 0xd1, 0xb3, 0xe2, 0x77, 0x33,
    0x78, 0xed, 0x02, 0x71, 0x16, 0x1b, 0x22, 0xc6, 0x00, 0x4a, 0x2c, 0x32,
    0x29, 0x9b, 0xf5, 0xc0, 0x35, 0x14, 0x80, 0xd8, 0x91, 0xcb, 0xd8, 0x4c,
    0x7b, 0x31, 0x66, 0x97, 0x42, 0xb6, 0x79, 0xdb, 0x01, 0xdd, 0x8c, 0xfc,
    0x62, 0x7b, 0x64, 0x3f, 0xe1, 0xba, 0x4c, 0xac, 0x1e, 0x1e, 0x01, 0x8a,
    0x21, 0x33, 0x0f, 0xf3, 0x4a, 0x0f, 0xf1, 0x71, 0x82, 0xcf, 0x4f, 0x9d,
    0x64, 0xa1, 0xb3, 0x1b, 0x4d, 0x0f, 0x5a, 0xec, 0x63, 0xf0, 0xfd, 0xcc,
    0xe7, 0xf0, 0x5a, 0x35, 0x1c, 0xc7, 0x5f, 0xc4, 0xcb, 0x0e, 0xf6, 0x3d,
    0x9d, 0x87, 0xc9, 0xb0, 0x41, 0x8a, 0xd5, 0x14, 0xb9, 0xa3, 0x28, 0xf1,
    0x46, 0x7c, 0x77, 0x86, 0x31, 0xe5, 0xe6, 0x33, 0xe3, 0x72, 0x53, 0x30,
    0x01, 0xe7, 0x81, 0x4b, 0x80, 0xdd, 0x00, 0x9a, 0x1e, 0x4e, 0x6c, 0x0c,
    0x51, 0xec, 0x9f, 0xc2, 0xd7, 0xfc, 0x3b, 0xe6, 0x58, 0x85, 0x0b, 0x7b,
    0x1d, 0x64, 0x95, 0x16, 0x40, 0x68, 0x89, 0xc0, 0x9c, 0x97, 0x8d, 0xa7,
    0xf2, 0x11, 0x57, 0x9f, 0x27, 0xd5, 0x54, 0xf8, 0xc2, 0x44, 0xfe, 0x11,
    0x95, 0xee, 0xfb, 0xe9, 0x2c, 0xd5, 0xb7, 0x72, 0x50, 0x08, 0xfe, 0x90,
    0x92, 0x2f, 0xfe, 0x27, 0xcc, 0x32, 0xeb, 0x19, 0xfc, 0x48, 0x03, 0x40,
    0x5f, 0x76, 0x12, 0x5d, 0x49, 0x6d, 0xb8, 0x8c, 0xf1, 0x07, 0xf4, 0x7c,
    0xff, 0x25, 0xed, 0x43, 0x9e, 0xb0, 0x44, 0x1e, 0x7c, 0xd5, 0x24, 0x75,
    0x93, 0x3f, 0x91, 0xba, 0x4f, 0xa3, 0xdf, 0x63, 0x65, 0xf0, 0xfd, 0xb3,
    0x54, 0x0b, 0x01, 0xc0, 0xa8, 0x94, 0x9c, 0x17, 0x82, 0xc4, 0x74, 0x58,
    0x14, 0x82, 0x9c, 0xfd, 0xc7, 0x70, 0x9b, 0xd3, 0x58, 0x14, 0xa0, 0x5b,
    0xf6, 0xb1, 0x36, 0x7a, 0x8b, 0xc3, 0xef, 0x7d, 0x18, 0x26, 0x72, 0x56,
    0x08, 0xa3, 0xfa, 0x4c, 0xa5, 0xcf, 0xb6, 0x67, 0x0e, 0x75, 0x77, 0x0e,
    0xd7, 0x3d, 0x56, 0x26, 0x3f, 0xfd, 0x01, 0xe3, 0xbf, 0x0f, 0xa3, 0x1a,
    0xad, 0xa5, 0x99, 0xb1, 0x54, 0x97, 0x90, 0xf2, 0xee, 0x51, 0x02, 0xb3,
    0xf3, 0xb4, 0x9f, 0xfb, 0x99, 0xe4, 0x37, 0x3f, 0xa1, 0xe2, 0xe8, 0x31,
    0x55, 0x6c, 0xb5, 0x91, 0x5b, 0x1f, 0xbc, 0x24, 0xcd, 0x96, 0x51, 0x2c,
    0x05, 0x69, 0x04, 0x62, 0xf3, 0xf8, 0xfa, 0x37, 0x77, 0x14, 0xd1, 0x01,
    0x7b, 0x36, 0xb9, 0x29, 0x0a, 0x6b, 0x73, 0x01, 0x3c, 0xce, 0x5e, 0x32,
    0x5e, 0x6f, 0xc0, 0x5c, 0x56, 0x25, 0x00, 0xa2, 0x88, 0x9c, 0x15, 0xc2,
    0x98, 0xf1, 0x72, 0x83, 0x6f, 0xe5, 0x9e, 0x13, 0x4b, 0x66, 0x08, 0x7d,
    0x62, 0x02, 0xc4, 0x6c, 0x11, 0x6e, 0x70, 0x95, 0x85, 0xb1, 0x05, 0x7c,
    0xf3, 0x2a, 0xda, 0x5b, 0x1f, 0xa3, 0x16, 0x96, 0x8b, 0xcd, 0x33, 0xb1,
    0x9d, 0xb1, 0x39, 0x2b, 0x84, 0x51, 0x7b, 0xa3, 0xd1, 0xe7, 0x1b, 0xea,
    0x65, 0x75, 0x8b, 0xc6, 0xf4, 0xe6, 0x54, 0x2c, 0x07, 0xab, 0xb9, 0xf3,
    0xd9, 0xdb, 0x4f, 0x98, 0xdb, 0x7f, 0x08, 0xbc, 0x7c, 0x2d, 0x42, 0xd2,
    0xb9, 0x58, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42,
    0x60, 0x82
};

static const char* const image49_data[] = { 
"18 18 13 1",
"d c #000000",
"c c #231800",
"i c #565656",
"f c #5a5664",
"h c #790000",
"# c #a58363",
"e c #b59f8a",
"k c #d2d2d2",
"g c #e99900",
"j c #fefefe",
"b c #ffbf55",
"a c #ffdfaa",
". c #ffffff",
"......######......",
"....##aaaaab##....",
"...#caaaaaddde#...",
"..#cfcaaadfafdb#..",
".#aaaaaaaaaaaabb#.",
".#addaaaaddaaaab#.",
"#aaaadaadaaaaaabb#",
"#aggaaaaaagggaabb#",
"#aaaahhhhaaaaaabb#",
"#aaahaaaahaaaiibb#",
"#aaaaaaaaaaiijjib#",
"#baaaaaaaiijkjkki#",
".#baaaaaijkjjjjijd",
".#bbaaaaijjjjjjjjd",
"..#bbaaaijjjjjjjkd",
"...#bbbbbijjjjjkd.",
"....##bbbiijjjkkd.",
"......####dddddd.."};

static const char* const image50_data[] = { 
"18 18 35 1",
"g c #000000",
"d c #5a5664",
"E c #655b60",
"B c #790000",
"C c #7c3c00",
"G c #898792",
"z c #a58363",
"# c #b10c00",
"F c #c4c3c9",
"D c #d9a348",
"c c #d9be91",
"a c #da0f00",
"f c #fefefe",
"b c #ff3a50",
"A c #ff5366",
"y c #ff5d6f",
"x c #ff6172",
"u c #ff6b7c",
"t c #ff8f9c",
"r c #ff97a3",
"q c #ff9aa5",
"o c #ffa1ac",
"n c #ffa4ae",
"l c #ffaab4",
"k c #ffacb6",
"w c #ffadb7",
"s c #ffb5bd",
"p c #ffbcc4",
"v c #ffbf55",
"m c #ffc3ca",
"j c #ffc8cf",
"i c #ffcad0",
"h c #ffcbd1",
"e c #ffdfaa",
". c #ffffff",
"......######......",
"....##aaaaaba#....",
"...#cccccccaaa#...",
"..#deeeeddeccaa#..",
".#ffdeedffdeeca##.",
"#dfdgeegdfdecaah##",
"#dfggeeggfdecahhi#",
"#dfggeeggfdecajkl#",
"#dfdgeegdfdecamno#",
"#eddeeeeddeecapqr#",
"#eeeeeeeeeeecastu#",
"#veeeeeeeeeecawxy#",
"#zveeeeeeeeec##A##",
".zvvBBCeeeeeeD###.",
"..zvvBBeeeevvDDz..",
"...zvBCvvvvvvvzEFF",
"....zzvvvvvvzzEEGF",
"......zzzzzzEEGFFF"};

static const char* const image51_data[] = { 
"18 18 85 2",
".l c #000000",
".V c #009900",
".2 c #010101",
".z c #020202",
".8 c #030303",
".9 c #090909",
"#j c #0b0b0b",
".j c #101010",
".k c #141414",
"#h c #1b1b1b",
".Q c #1e1e1e",
".K c #202020",
".7 c #212121",
"#b c #222222",
".O c #262626",
".5 c #292929",
".t c #2b2b2b",
".D c #2d2d2d",
".F c #2f2f2f",
"#a c #303030",
".b c #353535",
"#k c #363636",
".T c #393939",
".U c #3f3f3f",
".0 c #404040",
"#d c #444444",
"#g c #484848",
".v c #494949",
".Y c #4c4c4c",
".w c #505050",
".S c #525252",
"#c c #5b5a5b",
".N c #5d5d5d",
"#e c #5f5f5f",
".c c #606060",
".s c #696969",
".a c #6e6e6e",
".G c #6f6f6f",
"## c #707070",
".o c #717171",
".P c #787878",
".3 c #7a7a7a",
".g c #7d7d7d",
"#i c #7e7e7e",
".u c #7f7f7f",
".4 c #808080",
".6 c #858585",
".# c #868686",
".C c #8f8f8f",
".A c #929292",
".d c #939393",
".f c #9a9a9a",
".H c #9f9f9f",
".1 c #a0a0a0",
"#m c #a5a5a5",
".J c #afafaf",
"#r c #b9b9b9",
"#o c #bdbdbd",
".y c #c2c2c2",
".i c #c4c4c4",
".R c #cbcbcb",
"#n c #cccccc",
".M c #cecece",
".B c #cfcfcf",
"#p c #d0d0d0",
"#. c #d1d1d1",
".X c #d2d2d2",
".h c #d3d3d3",
".m c #d4d4d4",
".E c #d5d5d5",
".e c #dcdcdc",
"#s c #dfdede",
".I c #dfdfdf",
".n c #e0e0e0",
"#q c #e2e2e2",
"#l c #e3e3e3",
"#f c #eeeeee",
".Z c #efefef",
".p c #f4f4f4",
".r c #fafafa",
".q c #fefefe",
".L c #ff3300",
".W c #ff6600",
".x c #ff9900",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQt.#.a.b.c.d.eQtQt",
"QtQtQtQtQtQtQtQtQt.f.g.h.i.j.k.l.mQt",
"QtQtQtQtQtQtQtQt.n.o.p.q.r.s.l.l.tQt",
"QtQtQtQtQtQt.u.c.v.w.u.x.q.y.l.l.z.A",
"QtQtQtQt.c.c.B.q.q.q.C.D.x.E.F.l.l.G",
"QtQt.H.w.I.q.q.x.q.q.J.K.L.M.N.l.l.O",
"Qt.H.c.q.q.L.x.x.x.q.w.j.w.E.P.l.l.Q",
".J.c.q.q.L.L.L.q.q.H.l.l.l.R.S.l.l.T",
".U.q.V.V.V.W.q.q.H.l.l.l.l.X.t.l.l.Y",
".C.q.q.V.q.q.Z.w.l.l.l.l.0.1.l.l.2.3",
".w.q.q.q.I.4.j.l.l.l.l.5.6.7.8.l.9#.",
"##.0.0#a.l.l.l.l.l.l#b#c#d.D.b.b#e#f",
"Qt.K#g#g.l.l.l.l.l.t#h#i#j#k#k#k#lQt",
"QtQt#g#g#g.l.l.l.3#m#n#n#o#p#qQtQtQt",
"QtQtQt.0.0.0.C#r#sQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQt#s#s#sQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image52_data[] = { 
"18 18 263 2",
"bv c #188900",
"be c #2a8800",
"bq c #2d7b00",
"bu c #3f7500",
"aM c #476100",
"a6 c #4c9f1c",
"aL c #4ecd27",
"bn c #51a720",
"bf c #52cd29",
"bp c #549411",
"as c #5dd137",
"bH c #5e6c00",
"aY c #5f6204",
"bo c #62af26",
"bd c #685400",
"a0 c #68d73b",
"aZ c #6f8615",
"aJ c #777d12",
"a7 c #7c8623",
"ca c #7f5102",
"cd c #805306",
"bV c #827d1c",
"aI c #828c22",
"bh c #835404",
"a1 c #835505",
"b1 c #855505",
"bG c #856a00",
"br c #864c00",
"bU c #86c260",
"bO c #895807",
"at c #8b9d1f",
"b0 c #9b6614",
"#p c #9e3201",
"#D c #9e3202",
"b4 c #9e6b1e",
"bx c #9e6d1f",
".r c #a13608",
"#V c #a22800",
".V c #a23603",
"aq c #a51900",
".G c #a53906",
"c# c #a7711d",
"bb c #ae6e49",
".F c #b4460a",
"bm c #b6ae2e",
"ar c #b6f1a5",
"aa c #b7eaa3",
"## c #b84c11",
".d c #b86301",
".c c #b86401",
".H c #b86402",
"aO c #b9533d",
".i c #ba6503",
"ba c #ba653f",
".e c #bb6801",
".t c #bd6906",
"a9 c #be5634",
"#E c #be5d00",
".q c #bf5b1e",
"ab c #c05000",
"b3 c #c07a03",
"b. c #c25a38",
"bM c #c2b858",
"bc c #c3350d",
"av c #c48352",
"bs c #c52600",
"a4 c #c57813",
"bK c #c61400",
"a8 c #c64e3a",
"bI c #c72a00",
"b# c #c75e3d",
".u c #c8720b",
".X c #c97713",
"aX c #cb5f4b",
"aH c #cc644b",
"aK c #cd9108",
"aW c #cd9a72",
"bJ c #ce3100",
"au c #cf694a",
".j c #cf7a11",
"a# c #d67f41",
"bl c #d6a13b",
"aP c #d7895e",
"aG c #d87f55",
"a2 c #d88802",
"bz c #d98a05",
"cc c #daceba",
"ce c #dcd0ba",
"bt c #dd2800",
"bi c #df8d0c",
"bQ c #df9316",
"#W c #e0a452",
"bX c #e1632f",
"aN c #e26a22",
"bE c #e2b43b",
".f c #e2c2ae",
"bF c #e6821f",
"#a c #e7cdc1",
"bL c #e8bd8d",
"bw c #e8cc81",
".b c #e8cdae",
".s c #e8cec2",
".W c #edd9c1",
".h c #eed9c2",
"a5 c #efa534",
"a3 c #f0c075",
"bY c #f7b06d",
"#f c #f89014",
"#x c #f89114",
"#h c #f89117",
".K c #f8941c",
"#i c #f8961f",
".M c #f98e0b",
"#e c #f99114",
"#v c #f99115",
"#u c #f9941b",
".1 c #f9951a",
"#d c #f99520",
".2 c #f9961a",
".y c #f9961f",
".0 c #f99721",
"#w c #f99722",
"#s c #f99724",
"#I c #f99e29",
".z c #f99e2f",
".x c #f99f32",
"#c c #f9a132",
"bk c #fa8437",
".C c #fa8d1e",
"bD c #fa8d34",
"#l c #fa932a",
"#P c #fa9822",
"#J c #fa991d",
".Z c #fa9924",
".5 c #fa9a20",
".B c #fa9b2f",
"#N c #fa9f2b",
"#O c #faa02e",
"#M c #faa12d",
".A c #faa135",
"#k c #faa136",
"#L c #faa32f",
"#K c #faa532",
"#t c #faa542",
"#j c #faaa43",
"bg c #fadf9f",
"#n c #fb8632",
"#m c #fb8a2f",
".9 c #fb8b31",
"#B c #fb8b35",
"#A c #fb8c32",
".S c #fb8e2d",
"#z c #fb912c",
"#S c #fb9138",
".8 c #fb942c",
"#T c #fb943e",
"#R c #fb9739",
".R c #fb9931",
"#Q c #fb9a2f",
".6 c #fb9b20",
".P c #fb9e25",
"#r c #fba940",
"#H c #fbaa3f",
".4 c #fbab40",
".3 c #fbad46",
".L c #fbb55c",
"bW c #fc8b6e",
"#8 c #fc9d42",
"#9 c #fc9e48",
"#7 c #fca342",
"#6 c #fca93e",
"#5 c #fcae3d",
".Q c #fcae4b",
"#4 c #fcb03f",
"#y c #fcb157",
"#3 c #fcb241",
"#2 c #fcb443",
"#1 c #fcb544",
".7 c #fcb65f",
"#G c #fcbb5c",
"#g c #fcbc68",
"al c #fcbd5e",
"cb c #fcfbf9",
".w c #fd9e2b",
"a. c #fdb261",
"#0 c #fdb545",
"#Z c #fdb94c",
"#Y c #fdc463",
".N c #fdc980",
".O c #fdce87",
".g c #fdfaf9",
".a c #fdfbf9",
"bP c #fdfcfb",
"bS c #fe7327",
"#. c #fe8d35",
"bC c #fe975c",
".m c #fea331",
".l c #fea431",
".Y c #fea734",
"an c #feb263",
"am c #feb661",
"ak c #fec25b",
"aj c #fec558",
"ai c #fec559",
"bB c #fec682",
"ah c #fec75a",
"ag c #fec85b",
"#X c #fed586",
"aD c #fed99b",
"b2 c #fefcf9",
"by c #fefdfb",
"bT c #ff7e4b",
".T c #ff9235",
".U c #ff993a",
"#C c #ff9d47",
".J c #ff9f2a",
"#o c #ffa045",
".o c #ffa13a",
".n c #ffa335",
".v c #ffa42c",
".p c #ffa63d",
".k c #ffae38",
".I c #ffb13b",
"b6 c #ffb257",
"b7 c #ffb458",
"b8 c #ffb75d",
".E c #ffb763",
"b9 c #ffb962",
"#U c #ffba65",
"#b c #ffc059",
"#q c #ffc065",
"b5 c #ffc166",
"c. c #ffc268",
"bZ c #ffc46c",
"bA c #ffc47a",
"bR c #ffc47d",
"bN c #ffc871",
"af c #ffca64",
"ao c #ffcd86",
"ae c #ffd073",
"bj c #ffd197",
"ay c #ffd682",
"az c #ffd881",
"aA c #ffd883",
"aB c #ffd989",
"#F c #ffd98c",
"aC c #ffdb94",
"aE c #ffe7b2",
"ad c #ffe99c",
"ax c #ffea9d",
".D c #fff2d4",
"ap c #fff4b9",
"aR c #fffcc9",
"aS c #fffecf",
".# c #fffefe",
"ac c #ffffc1",
"aw c #ffffc5",
"aF c #ffffcf",
"aT c #ffffd7",
"aQ c #ffffd8",
"aU c #ffffe1",
"aV c #fffffb",
"Qt c #ffffff",
"QtQtQt.#.a.b.c.c.d.d.d.e.f.g.#QtQtQt",
"QtQtQt.h.i.j.k.l.m.n.o.p.q.r.sQtQtQt",
".#Qt.t.u.v.w.x.y.z.A.B.C.D.E.F.GQt.#",
".#.H.I.J.K.L.D.M.N.O.P.Q.R.S.T.U.V.#",
".W.X.Y.Z.0.1.2.3.4.5.6.D.7.8.9#.###a",
".H#b#c#d.D#e#f#g.D#h#i#j#k#l#m#n#o#p",
".H#q#r#s#t#e#e#u#v#w#x.D#y#z#A#B#C#D",
"#E#F#G#H#I#J#K#L#M#N#O#P#Q#R#S#T#U#V",
"Qt#W#X#Y#Z#0#1#2#3#4#5#6#7#8#9a.a#Qt",
"aaabacadaeafagahaiajakalamanaoapaqar",
"asatauavawaxayazaAaBaCaDaEaFaGaHaIaJ",
"aKaLaMaNaOaPaQaRaSaTaUaVaWaXaYaZa0a1",
"a2a3a4a5a6a7a8a9b.b#babbbcbdbebfbgbh",
"QtbibjbkblbmbnbobpbqbrbsbtbubvbwbxQt",
"bybzbAbBbCbDbEbFbGbHbIbJbKbLbMbNbObP",
"QtQtbzbQbAbRbSbTbUbVbWbXbYbZb0b1QtQt",
"QtQtb2Qtb3b4b5b6b7b8b9c.c#caQtcbQtQt",
"QtQtQtQtQtcccdcdcdcdcdcdceQtQtQtQtQt"};

static const char* const image53_data[] = { 
"18 18 38 1",
"a c #6f6f6f",
"h c #707070",
"b c #7f7f7f",
"k c #808080",
"d c #8f8f8f",
"j c #9292aa",
"G c #999999",
"C c #9f9f9f",
"B c #a7a7a7",
"e c #afafaf",
"E c #b2b2b2",
"n c #bdbdbd",
"f c #bfbfbf",
"D c #c7c7c7",
"# c #cccccc",
"l c #ccccff",
"F c #cdcdcd",
"q c #cfcfcf",
"H c #d2d2d2",
"J c #d6d6d6",
"w c #d7d7d7",
"o c #d9d9d9",
"p c #dfdfdf",
"I c #e2e2e2",
"v c #e6e6e6",
"A c #ebebeb",
"u c #ececec",
"g c #efefef",
"z c #f5f5f5",
"t c #f6f6f6",
"s c #f9f9f9",
"y c #fbfbfb",
"r c #fcfcfc",
"x c #fdfdfd",
"c c #fefefe",
"m c #ffcc00",
"i c #ffffcc",
". c #ffffff",
"......#..#........",
"......#..#........",
"....abb.b.bb......",
"...acdcbeefgb.f...",
".bhcfiicciiifhif..",
".bgfifcffifififh..",
"jjjjjjjjjjjjjjjjk#",
"jccccccccccccccca#",
"jcllmmlmmllmmllnao",
"jllllllllllllllajp",
"qjcccccrstuvpwqafu",
".jccccxyszAlllBj#.",
".CnmmmmmmmmmmDaEp.",
"..jnllllllllFaGq..",
"...jjjjjjjjjaG#...",
"....jyylylllaH....",
"....jaaaaaaaa.....",
"......IJ###o......"};

static const char* const image54_data[] = { 
"18 18 25 1",
"c c #000000",
"a c #336633",
"d c #548954",
"q c #606060",
"# c #6f9b6f",
"i c #76ad83",
"h c #89b88e",
"o c #98b6bc",
"p c #a5a5a5",
"j c #a8cba1",
"g c #b5d3a9",
"m c #b8d3ba",
"e c #c1dab0",
"r c #c1f4ff",
"n c #cccaca",
"l c #d1e2c9",
"v c #d8e5d6",
"f c #dae9bf",
"w c #e1dede",
"u c #e5eddd",
"k c #eaf1d8",
"t c #f1f4e5",
"b c #f9f8f1",
"s c #fefefe",
". c #ffffff",
"...........#aa#...",
"...........#bbc...",
"...........#ddc...",
"...........#eec...",
"...........#ffc...",
"..........dfgghc..",
".........dfbiiiic.",
".........dfjiiiic.",
".........dfjiiiic.",
".........dklmmmic.",
".........dbabbbic.",
"..nnnnn..dbiabbic.",
".opppppq.diaibbic.",
".orssssc.dbiiabic.",
".orrsssc.dtuvvvic.",
".orwwwwc.dgiaaaic.",
"..ooqqc..dfgiiiic.",
"..........cccccc.."};

static const char* const image55_data[] = { 
"18 18 33 1",
"c c #6b5cb8",
"f c #8f8f8f",
"b c #92b600",
"d c #b6b6aa",
"A c #bfbfbf",
"m c #ca87a2",
"C c #cccccc",
"z c #d2d2d2",
"B c #d6d6d6",
"y c #d9d9d9",
"g c #db4900",
"# c #db6d00",
"j c #db9200",
"D c #dcdcdc",
"E c #e2e2e2",
"x c #ececec",
"r c #f89fc4",
"n c #f8a1c5",
"q c #f8a3c6",
"w c #f9aaca",
"l c #f9aecd",
"v c #fab4d1",
"u c #fabad5",
"s c #fbc0d9",
"t c #fbc7dd",
"h c #fcd0e2",
"p c #fcd9e8",
"o c #fde2ed",
"e c #feecf4",
"k c #fef2f8",
"i c #fefefe",
"a c #ffdb00",
". c #ffffff",
"...#..#...#..#....",
"...a#.a#..a#.a#...",
"...a#.a#..a#.a#...",
"...bc.bcddbc.bc...",
"..dbcdbceebcdbcf..",
".debcebcggbcebchf.",
"deebciijggjiibcehf",
"deibciikjjkiibcehf",
"dliiiiiiiiiiiiehmf",
"delmmleeeehhlmmmnf",
"deeoplmmmllmlqnrsf",
"dleehhtsuvlwwwwimf",
"dlimissiuwwwwiwmxf",
"dxlsmismmsiwmmmydf",
"dxxixmmixmmmxxydfz",
".dfdiiixixxxyddfAB",
"...dffyiyyddfffCy.",
".....DffffffCBE..."};

static const char* const image56_data[] = { 
"18 18 46 1",
"p c #005b00",
"e c #005f00",
"i c #006000",
"f c #006600",
"B c #056a05",
"A c #076100",
"v c #096c09",
"C c #0f710f",
"h c #137613",
"a c #1b7a1b",
"F c #206204",
"d c #238623",
"o c #2b8c2b",
"z c #2d7e2b",
"u c #488630",
"w c #4d9e4d",
"j c #539353",
"K c #671e04",
"x c #6fb96f",
"q c #7ab37a",
"g c #86c086",
"D c #87c287",
"r c #915027",
"J c #9b4e17",
"k c #9b5526",
"H c #9b6546",
"n c #9b7566",
"# c #9ccd9c",
"m c #a55316",
"E c #a57b66",
"b c #acccac",
"l c #af5205",
"R c #af7145",
"I c #af9084",
"O c #b95804",
"Q c #b99e93",
"y c #c35e04",
"N c #cdbab2",
"L c #d76a03",
"P c #e17002",
"M c #f57c01",
"c c #fcfdfc",
"G c #ff8200",
"t c #ff9b07",
"s c #ffc56f",
". c #ffffff",
"............#abc..",
"............def...",
"...........ghij...",
"......klmn.opq....",
".....rssstuviwxwwq",
".....ysstgzAfBCwDx",
"....EssttgzzF.....",
"....lsttGtgtGH....",
"...IsstGGGGGGl....",
"...JsttGGGGGGK....",
"..IsstGGGGGGLK....",
"..HsttGGGGMKKN....",
"..OstGGGGyKNN.....",
".EsttGGPKKN.......",
".mstGMKKNN........",
"QstGKKNN..........",
"RtLKN.............",
"RKKN.............."};

static const char* const image57_data[] = { 
"18 18 10 1",
"h c #5d1d00",
"e c #633000",
"# c #9c3000",
"a c #cccccc",
"d c #ce6100",
"f c #fefefe",
"c c #ff9e31",
"b c #ffcf63",
"g c #ffffce",
". c #ffffff",
"........####a.....",
"..######bccd#a....",
".#cccdd#ebccd#a...",
"dcbcccdddebccd#a..",
"ddcbcccdddeb##d#a.",
"#ddcbcc#####bbbb#a",
"#dddcb#bbbf#fgfgb#",
"##d#ddbfgfgfgfgfb#",
"#d##ddbgfgfgfgfgb#",
"##d###bfgfgfgfgfb#",
"#d##d#bgfgfgfgfgb#",
"d#d###bfgfgfgfgfb#",
".h##d#bgfgfgfgfgb#",
"..h###bfgfgfgfgfb#",
"...h##bgfgfgfgfgb#",
"....h#bfgfgfbbbbb#",
".....hbbbbbb#####a",
"......h#####aaaaa."};

static const char* const image58_data[] = { 
"18 18 87 2",
".Y c #282828",
".o c #371f04",
".N c #3c3c3c",
".m c #3e2305",
".x c #404040",
"#g c #4b4b4b",
".v c #4c2b06",
".w c #4c4c4c",
".F c #4d4d4d",
".y c #4e4e4e",
".Q c #505050",
".n c #532f06",
".l c #575450",
"#k c #575757",
"#q c #595959",
".k c #5b5b5b",
"#p c #5c5c5c",
".f c #5f5f5f",
".u c #603607",
".q c #606060",
"#d c #616161",
".X c #626262",
".B c #646464",
"#s c #666666",
".p c #676460",
"#h c #676767",
".7 c #6d6d6d",
".t c #6e3e08",
".d c #7f7f7f",
"#c c #828282",
".s c #868686",
".j c #8f8f8f",
".r c #969696",
"#t c #999999",
"#. c #9b9b9b",
".b c #9f9f9f",
".9 c #a0a0a0",
".6 c #a3a3a3",
".O c #a6a6a6",
"#i c #aeaeae",
".g c #afafaf",
".# c #b1b1b1",
"#r c #b2b2b2",
".M c #bbbbbb",
".a c #bfbfbf",
"#j c #c6c6c6",
"#f c #cacaca",
".E c #cccccc",
".W c #cdcdcd",
".0 c #cecece",
".c c #cfcfcf",
".A c #d0d0d0",
".C c #d2d2d2",
".5 c #d3d3d3",
"#e c #d4d4d4",
"#n c #d5d5d5",
".D c #d6d6d6",
".V c #d7d7d7",
".8 c #d8d8d8",
".P c #d9d9d9",
".L c #dbdbdb",
".4 c #dcdcdc",
"#m c #dddddd",
".h c #dfdfdf",
".U c #e1e1e1",
"#b c #e2e2e2",
".K c #e5e5e5",
".3 c #e6e6e6",
".z c #e9e9e9",
"#a c #eaeaea",
".J c #ececec",
".2 c #ededed",
".i c #efefef",
".T c #f0f0f0",
"## c #f1f1f1",
"#l c #f2f2f2",
".I c #f3f3f3",
".1 c #f4f4f4",
".Z c #f5f5f5",
".S c #f7f7f7",
".H c #f9f9f9",
"#o c #fafafa",
".R c #fbfbfb",
"#u c #fcfcfc",
".G c #fdfdfd",
".e c #fefefe",
"Qt c #ffffff",
"QtQtQtQtQtQtQt.#Qt.#QtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQt.#Qt.#QtQtQtQtQtQtQtQt",
"QtQtQtQt.a.b.b.b.b.b.b.cQtQtQtQtQtQt",
"QtQt.d.b.b.e.e.#.e.#.e.b.f.gQtQtQtQt",
"Qt.b.g.e.e.e.h.a.a.i.e.e.e.j.k.gQtQt",
"Qt.b.h.a.l.l.m.n.n.o.l.p.h.q.e.r.sQt",
"Qt.b.h.b.b.n.t.t.t.u.v.b.e.w.x.e.y.z",
"Qt.b.h.e.h.b.b.b.b.b.b.e.A.B.j.e.y.C",
"QtQt.b.e.e.e.e.e.e.e.e.D.E.F.y.e.y.E",
"QtQt.b.e.e.G.H.I.J.K.L.C.M.N.e.y.O.P",
"Qt.c.Q.b.e.R.S.T.z.U.V.W.X.Y.y.E.C.Z",
".g.b.i.b.0.H.1.2.3.4.5.6.7.8.y.9QtQt",
".b.e.e.i.b#.###a#b.8#c#d.4#e#f#g.iQt",
".b.e.e.e.e.b.b.b.b#h#i.U.P.A#j#k.DQt",
".c.b.i.e.e.e.R.S#l.J.K#m#n.a#k.O.PQt",
"Qt.D.b.b.g.2#o.Z.i.z#e.r#p#q#r.c.ZQt",
"QtQt.H.h.b.b#s#p#p#s#s#t.a.E.h.HQtQt",
"QtQtQtQtQt#l.K.K.h.h.K.K#l#uQtQtQtQt"};

static const char* const image59_data[] = { 
"18 18 142 2",
".e c #000000",
"#k c #00cc00",
".f c #040404",
".g c #0a0a0a",
".h c #101010",
".i c #171717",
".j c #1e1e1e",
".k c #232324",
".n c #271c10",
".o c #313131",
".r c #444444",
".q c #4b4b4b",
"#f c #510000",
"#s c #520202",
".s c #525353",
"#t c #5a0905",
"#g c #5e0505",
"#E c #5f2d0c",
".4 c #620504",
"#D c #650000",
"#u c #65110b",
"#r c #660000",
".t c #666c6c",
"#h c #6b080b",
".R c #6f090a",
".5 c #71100f",
"#v c #726625",
".S c #7a1313",
"#W c #7a1617",
"#Q c #7a1b1c",
".p c #7a7a7a",
"#e c #7b3434",
"#V c #7f1213",
"#i c #7f1819",
".3 c #7f2222",
".u c #838989",
".6 c #891e1e",
".Q c #8a4040",
".J c #8b1819",
"#q c #8c3434",
".I c #8d1c1c",
".H c #8e3636",
"#B c #8f2626",
".Z c #8f3535",
"#R c #910909",
"#j c #951c24",
"#O c #952625",
"#L c #952e2e",
"#l c #96552d",
".K c #97292a",
".T c #982727",
"#c c #983636",
".7 c #9a292a",
"#M c #9b1414",
"#N c #9e0a0a",
"#P c #9e0b0e",
".v c #a0a6a6",
".8 c #a1262a",
"#y c #a19a4b",
"#J c #a3a249",
".# c #a47f5a",
"ak c #a53636",
".L c #a67878",
".M c #a87878",
".d c #a97e53",
".9 c #aa292d",
".G c #aa7878",
".X c #ad3333",
".F c #ad7878",
"#C c #af2121",
".U c #b03434",
"#X c #b13b3b",
"ai c #b23434",
".B c #b38f8f",
".V c #b53134",
"#F c #b5bb5a",
".A c #b78f8f",
".Y c #ba4141",
"#w c #bc803a",
".w c #bcc2c2",
"#I c #be7a2c",
"#4 c #bf3b3b",
"a. c #c12626",
"#U c #c16b6c",
"#T c #c84848",
"#Y c #c95454",
".0 c #ca9a9a",
".D c #cab0b0",
".x c #d2d9db",
"a# c #d36d6d",
".m c #d3914c",
"ah c #d57171",
"#d c #d6bdbd",
".W c #da5052",
"#m c #db5452",
"aj c #dc8989",
"ac c #dd5757",
"ae c #dd5a5a",
"ad c #dd5b5b",
"af c #dd5c5c",
".N c #ddcbcb",
"ab c #de6e6e",
"#Z c #de7b7b",
"#. c #df5154",
"#n c #e05b5b",
"#b c #e06968",
".P c #e0b3b3",
"#2 c #e15e5e",
"#5 c #e25757",
"#p c #e37575",
"#3 c #e39898",
"#S c #e3a9a9",
"#9 c #e46565",
"aa c #e49797",
"#7 c #e76868",
".z c #e7d8d8",
"#6 c #e86666",
"#8 c #e86868",
"## c #e9595a",
"#1 c #eb6d6d",
"#0 c #ee7979",
"#a c #ef6868",
"al c #efd1d1",
"#x c #f02a2e",
"#o c #f07a7a",
".2 c #f0e8e8",
"ag c #f1d2d2",
"#z c #f46a77",
"#K c #f56674",
".E c #f5efef",
"#A c #f68888",
".1 c #f9f0f0",
".O c #f9f4f4",
".y c #fafafa",
".C c #fbec00",
"#G c #ff6254",
"#H c #ff6554",
".a c #ff7800",
".c c #ffbe21",
".l c #ffd674",
".b c #fff66f",
"Qt c #ffffff",
"QtQtQtQtQtQtQt.#.a.b.c.dQtQtQtQtQtQt",
".e.e.f.g.h.i.j.k.l.b.m.n.o.pQtQtQtQt",
".q.r.s.t.u.v.w.x.l.a.b.aQtQtQtQtQtQt",
".yQtQtQtQt.z.A.B.C.a.b.a.DQtQtQtQtQt",
".yQt.E.F.G.H.I.J.C.a.b.a.K.L.M.NQtQt",
".O.P.Q.R.S.T.U.V.C.a.b.a.W.X.Y.Z.0.1",
".2.3.4.5.6.7.8.9.C.a.b.a#.###a#b#c#d",
"#e#f#g#h#i#j#k#l.C.a.b.a#k#m#n#o#p#q",
"#r#s#t#u#v#k#w#x.C#x.b.C#k#k#y#z#A#B",
"#C#D#E.l#F#x.b#G.c.c#H.C.C#I#J#K#L#M",
"Qt#N#O.C.l.C#x#k#P.b.c#P.c.b.C#Q#R#S",
"Qt#T#U#V#V.b.b#k.b.b.c.C.b#W#Q#X#RQt",
"QtQt#Y#Z#0#Q#Q#Q#Q#Q#Q#Q#Q#1#2#R#3Qt",
"QtQt#Y#4#3#5#6#7#7#7#7#8#9a.#R#YQtQt",
"QtQtQt#4a#aaabacadaeafaea.a.#RagQtQt",
"QtQtQtQt#4a.ahaeaeaeaea.a.#R#3QtQtQt",
"QtQtQtQtQta.#R#Raiai#R#Ra.#3QtQtQtQt",
"QtQtQtQtQtQtajakakakak#3alQtQtQtQtQt"};

static const char* const image60_data[] = { 
"18 18 199 2",
"#c c #5b2003",
"#P c #5b2205",
"#Q c #612c0a",
"a8 c #643925",
".8 c #672c13",
"aY c #683e2c",
"aj c #6a330f",
"ai c #6a3924",
"b. c #6c4b3e",
"b# c #6e3e26",
"aL c #704734",
"ba c #704d3e",
"#m c #734c3a",
"#4 c #76513c",
"aZ c #816154",
"a9 c #826457",
"#x c #846c62",
"aM c #856559",
"ah c #87370d",
"#I c #8d695d",
"bb c #8d7369",
"bc c #8e7469",
"ay c #8f7063",
"a0 c #933f11",
"aK c #954008",
".U c #963b0d",
"aX c #974413",
"a# c #983c18",
"#z c #984f20",
".7 c #9a3406",
".V c #9a3b09",
"aw c #9a4413",
".T c #9b3909",
"#j c #9b3d0f",
"#e c #9b3f16",
"aN c #9b4916",
"a7 c #9b4b17",
"aa c #9c401b",
"#s c #9d4219",
".W c #9e3d08",
".c c #9e441d",
".b c #9e441e",
".d c #9e451a",
".a c #9e4721",
"#E c #9f4011",
".9 c #9f4312",
"#3 c #a14b18",
"#n c #a14e1b",
"#W c #a44e1c",
".S c #a54308",
".n c #a64511",
".1 c #a64c1a",
"a6 c #a65117",
"az c #a65a1f",
"a1 c #a75019",
"a5 c #a8541b",
".6 c #a94b16",
".g c #a95636",
".f c #ab5935",
".O c #ab5b39",
".o c #ad5016",
"a4 c #ad571b",
".N c #ae521c",
"a2 c #ae5b1e",
"ag c #af6027",
"a3 c #b45c1e",
".p c #b4674a",
"ab c #b56439",
"#O c #b66128",
"aW c #b66322",
".A c #b66a4c",
"ax c #b6a6a0",
"#. c #b7571a",
"#Z c #b7683d",
".e c #b8775b",
".z c #b95f1e",
"a. c #b9632b",
".3 c #bc7243",
"#V c #bd6c27",
".G c #be6621",
"aJ c #be6e29",
"bd c #bfafa9",
"#K c #c06d37",
"#D c #c1712f",
"#r c #c37931",
"#d c #c49282",
"aO c #c6691e",
".I c #c77127",
".F c #c87f45",
".H c #ca8758",
"#y c #cbb4ad",
".X c #cc8b63",
"#l c #cccccc",
".h c #cd8752",
"#2 c #cd8846",
"#X c #cda091",
".# c #cda291",
".5 c #cf823b",
"#k c #cfc4bf",
"aV c #d28539",
".J c #d37d24",
"aP c #d38331",
"#J c #d4ada4",
"#o c #d58840",
".0 c #d88b36",
".E c #da964e",
"#w c #db9d67",
"#i c #db9f67",
"av c #dbb492",
"aQ c #dd923a",
"#5 c #dd9e40",
".2 c #ddc0b7",
"be c #dddcdc",
"aT c #de984b",
"aU c #dea465",
"aA c #df8a34",
"#8 c #df9a47",
"aS c #df9e56",
"aR c #e0a45c",
"#b c #e19c42",
"#Y c #e1c8c1",
"#U c #e3a152",
"#N c #e3a85d",
"#A c #e4a661",
"#9 c #e4a969",
"au c #e5a757",
".m c #e5b67f",
"aI c #e6b06f",
".Y c #e9b77a",
"#H c #e9be96",
".Z c #eba641",
".D c #eba748",
"#v c #ebb05e",
"## c #ebcdab",
".M c #eda53e",
".u c #edae54",
"#G c #eea134",
".R c #eeb057",
".K c #eeb668",
"af c #eec184",
"aB c #eec285",
"#q c #efc689",
"#h c #f0b256",
"#7 c #f0b351",
".v c #f1ba66",
"#p c #f3c679",
"#1 c #f3c886",
"#C c #f3d4a5",
"#L c #f4cc87",
"ao c #f5c068",
"#a c #f5c470",
"al c #f6b442",
"#B c #f6d092",
"aC c #f8bc51",
".L c #f8c35e",
"ae c #f8d08c",
"aD c #f9bd50",
"#T c #f9bd56",
"#M c #f9d393",
"#0 c #f9d791",
".t c #f9d797",
"an c #facc70",
"aH c #fad591",
"at c #fae0a7",
"ak c #fdb348",
".w c #fdd482",
"aG c #fdd58c",
".C c #fdd782",
"ap c #fdd788",
".B c #fdeeb2",
".P c #fdf3b6",
"ad c #fee1a5",
".s c #fefefe",
"#6 c #ffbd46",
"#S c #ffc85c",
"#R c #ffd462",
"#t c #ffd86d",
"#u c #ffd883",
"am c #ffd98a",
".y c #ffda77",
".Q c #ffdb89",
"#g c #ffdd90",
".k c #ffdf8a",
"aF c #ffdfa0",
".4 c #ffe483",
"aq c #ffe4a1",
"aE c #ffe6b0",
"#F c #ffe89a",
"ar c #ffe9a6",
"#f c #ffed95",
".j c #ffeeab",
"ac c #ffeeae",
".x c #ffef9a",
"as c #ffefc4",
".r c #fff1a0",
".l c #fff5a5",
".q c #fff5c1",
".i c #fffbb6",
"Qt c #ffffff",
"QtQtQtQtQtQt.#.a.b.c.d.eQtQtQtQtQtQt",
"QtQtQtQt.f.g.h.i.j.k.l.m.n.oQtQtQtQt",
"QtQtQt.p.q.r.s.t.u.s.v.w.x.y.zQtQtQt",
"QtQt.A.B.C.D.E.F.G.H.I.J.K.L.M.NQtQt",
"Qt.O.P.Q.R.s.S.T.U.V.W.X.Y.Z.s.0.1Qt",
".2.3.4.s.5.6.7.8.8.8.8.9#.###a#b#c#d",
"#e#f#g#h#i#j.8#k#l#l#l#m#n#o#p#q#r#c",
"#s#t#u#v#w.8#x#l#lQtQt#y#z#A#B#C#D#c",
"#E#F.s#G#H.8#I#lQtQtQt#J#K#L#M#N#O#P",
"#Q#R#S#T#U#V#W#XQtQt#Y#Z#0.s#1#2#3#c",
"#4#5#6.s#7#8#9a.a#aaabacadaeafagahai",
"Qtajakalaman.saoapaqarasatauavaw#cax",
"QtayazaAaBaCaDaEaFaG.saHaIaJaK#caL#l",
"QtQtaMaNaOaPaQaRaSaTaUaVaWaX#caY#lQt",
"QtQt#laZa0a1a2a3a4a5a6a7#c#ca8#lQtQt",
"QtQtQt#la9b.b##c#c#c#c#cb.ba#lQtQtQt",
"QtQtQtQtQt#lb.bbbcbcbcbd#l#lQtQtQtQt",
"QtQtQtQtQtQtQtbebe#l#l#lQtQtQtQtQtQt"};

static const char* const image61_data[] = { 
"18 18 89 2",
".B c #003300",
".s c #339900",
"#. c #8a8888",
"#l c #8b8986",
"#e c #8c8c87",
".9 c #929089",
".w c #99cc00",
"#g c #9e9554",
"#f c #a7a59a",
"#u c #a99d49",
"#r c #a9a47f",
".2 c #ada044",
"#m c #adab9f",
"#s c #b0afa3",
"#p c #b3a53e",
".m c #b3a95a",
".c c #b5aa5c",
".Q c #b7ad63",
".o c #b8a839",
".F c #b8ad64",
".0 c #b8ae65",
".u c #b8ae66",
".g c #bab16a",
".a c #bbb26b",
".x c #bbb36d",
".b c #bdb26b",
".J c #beb574",
"## c #c0b776",
"#k c #c1bc9b",
".T c #c2b97c",
".l c #c3bb7c",
".d c #c3bc7e",
".Y c #c4bc7e",
".3 c #c4bc82",
".n c #c5b961",
"#d c #c6c19d",
".N c #c8c086",
".j c #cc6600",
".8 c #ccc7a1",
".p c #cdc798",
".q c #cec793",
".e c #d0cb9c",
"#h c #d1ca97",
".A c #d1cba0",
"#b c #d2c25e",
".M c #d3cea6",
"#v c #d5c13f",
".P c #d5c23e",
".Z c #d5c248",
".6 c #d6c243",
".H c #d7c546",
".X c #d7d3af",
".S c #d8c75e",
".W c #d9c74b",
"#t c #d9cf9e",
".y c #dccc5e",
".4 c #dcd7b2",
".U c #dedab8",
"#q c #e1d468",
".K c #e1d78c",
"#j c #e3ddb5",
"#n c #e3ddba",
"#w c #e4d77f",
".f c #e4e0c5",
".# c #e4e1ca",
".z c #e8d877",
".h c #e8e5ce",
".V c #e9e4be",
".t c #e9e7d3",
"#i c #ebe8d2",
".C c #ece7bd",
".D c #eddf86",
".E c #edebdc",
".I c #f0e697",
".5 c #f2efde",
"#o c #f3f1e5",
".1 c #f4f3e7",
".O c #f5f4e6",
".R c #f6f5eb",
"#c c #f7eeb3",
".7 c #f8efb4",
".v c #faf9f3",
".G c #fbfbf7",
".L c #fdf4b5",
"#a c #fefefd",
".k c #fefefe",
".i c #ff9933",
".r c #ffcc00",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQt.#.a.b.c.d.e.fQtQtQt",
"QtQtQtQtQtQtQtQt.g.h.i.j.k.k.l.m.n.o",
"QtQtQtQtQtQtQt.p.q.k.r.i.k.s.s.k.k.o",
"QtQtQtQtQtQt.t.u.v.i.i.k.k.s.w.k.o.o",
"QtQtQtQtQtQt.x.v.j.i.k.k.s.w.k.y.z.o",
"QtQtQtQtQt.A.v.i.j.k.k.w.B.k.C.o.D.o",
"QtQtQtQt.E.F.v.j.i.k.w.s.k.G.H.I.D.o",
"QtQtQtQt.J.v.i.j.k.k.w.s.k.K.o.D.L.o",
"QtQtQt.M.N.k.r.i.k.w.s.k.O.P.D.D.L.o",
"QtQtQt.Q.R.r.j.k.k.s.k.k.S.o.D.L.k.o",
"QtQt.T.U.v.j.k.k.w.s.k.V.W.D.D.L.k.o",
"Qt.X.Y.k.r.i.k.w.s.k.v.Z.D.D.L.L.k.o",
"Qt.0.1.r.j.k.k.s.s.k.2.D.D.L.k.k.k.o",
".3.4.v.i.i.k.w.s.k.5.6.D.L.L.7.8.9#.",
"###a.i.j.k.w.B.k#a#b.D.D#c#d#e#fQtQt",
"#g#g#h#i.k.s.s.k#j.o.D#k#l#mQtQtQtQt",
"QtQt#g#g#g#g#n#o#p#q#r#sQtQtQtQtQtQt",
"QtQtQtQtQt#t#g#u#v#wQtQtQtQtQtQtQtQt"};

static const char* const image62_data[] = { 
"18 18 34 1",
"r c #404040",
"b c #666666",
"# c #6699ff",
"a c #66cccc",
"s c #696969",
"p c #707070",
"z c #7e5621",
"n c #7e5825",
"g c #7f7f7f",
"w c #9e7a4a",
"t c #9e7b4d",
"q c #9f9f9f",
"F c #be8539",
"m c #cccccc",
"e c #cfcfcf",
"o c #d1d1d1",
"B c #d2d2d2",
"j c #d6d6d6",
"A c #d9d9d9",
"y c #dfdfdf",
"i c #e1e1e1",
"v c #e5e5e5",
"E c #fdb554",
"u c #fdb85c",
"D c #fdbb63",
"C c #fdc77e",
"x c #fdca86",
"h c #fefde7",
"c c #fefefe",
"f c #ff99cc",
"l c #ffcc00",
"k c #ffda44",
"d c #fffef3",
". c #ffffff",
"........#a........",
".....ba#ccb#......",
"....bcccccdeb.....",
"....acccfcfcg#....",
"...bccccchccibj...",
"...#cfckkiliibm...",
"...#ccckeiiibnm...",
"...#caceebbbkno...",
"...pqeerstktunv...",
"....ssswktxtuny...",
"......zwutxtunA...",
".......zwttttnB...",
"........zwCtDnm...",
".........zwtunm...",
"..........ztEnm...",
"...........zFzm...",
"............bbm...",
".............Bm..."};

static const char* const image63_data[] = { 
"18 18 152 2",
".u c #00a600",
".I c #343230",
".Q c #40403b",
".L c #4a9c28",
".j c #590000",
".a c #5d0000",
".J c #5d603c",
"#u c #68bf27",
".i c #690000",
".d c #6c0000",
"#. c #6d6f39",
".m c #700000",
"au c #700402",
"## c #708f2a",
".1 c #748e2e",
".h c #77150f",
".b c #781e17",
"av c #812222",
"#m c #818c3f",
"aq c #821502",
"ag c #8e2d17",
"#X c #8f743d",
".P c #918064",
"am c #922508",
"#9 c #944232",
"#a c #9e903f",
"#v c #9ebf4f",
".5 c #9f4c2d",
"#Y c #9f6d2e",
"#k c #9fdb7d",
".E c #a0502a",
".0 c #a58771",
".# c #aa3d00",
".l c #ad0f00",
".e c #ad6e53",
".k c #b01a00",
".T c #b05d2c",
"#N c #b18329",
"#j c #b2fd87",
"#6 c #b37214",
".g c #b77d5f",
".2 c #ba8c4f",
"#l c #bbc4a7",
"#n c #bf6a1d",
".f c #c2916e",
"#b c #c46f24",
"#5 c #c88b36",
".R c #c9974d",
"#1 c #ca5411",
"#W c #ce8d3c",
".3 c #cf7929",
"#F c #d09f4a",
"ak c #d18d58",
"#p c #d66008",
"#c c #d67211",
".F c #d67310",
".o c #d67512",
"#7 c #d77f2a",
".c c #d7b489",
"ac c #d88e40",
".s c #d8b965",
"at c #d8bebe",
"#0 c #d9b6a8",
"#O c #db6623",
"#V c #db8e3f",
"#P c #db9a3e",
"a. c #dc6716",
"#A c #dc833c",
"#y c #dc9446",
".B c #dd330e",
"al c #ddc4c4",
"#I c #de6412",
"#H c #dec8c8",
"#i c #df6a3a",
".z c #e08a3b",
"#Z c #e08c2f",
".q c #e09a41",
"ad c #e1953b",
"af c #e2cece",
".x c #e47234",
".9 c #e4783f",
"ap c #e4c9be",
".y c #e57d31",
".S c #e59c40",
"#z c #e7dada",
".C c #e87e38",
".r c #e8a94e",
"#Q c #e99550",
"ah c #eb7517",
"#h c #ec8c45",
"an c #ed9e52",
"#o c #ede3e3",
"ar c #efab61",
".p c #efbc58",
".w c #efdb90",
"aj c #f0bc55",
".A c #f16b1f",
".N c #f2a670",
".Z c #f2eeb8",
"#M c #f49900",
"ab c #f59d18",
"as c #f6f7ff",
"#4 c #f7940c",
"#U c #f79e1b",
"#B c #f89244",
"#8 c #f9f9f9",
"#E c #faad21",
".8 c #fb5916",
"#R c #fd933d",
"#g c #fec851",
"ae c #fefefe",
".X c #feffb7",
".M c #ff6615",
".W c #ff7c32",
"#w c #ff823a",
"#G c #ff843a",
"#q c #ff9c53",
"#2 c #ff9e42",
"ai c #ff9f30",
"#t c #ffa10f",
"#J c #ffa44b",
"a# c #ffa64b",
"#f c #ffaa18",
"#s c #ffad22",
".V c #ffb026",
".6 c #ffb127",
"#3 c #ffb230",
"aa c #ffb92f",
".7 c #ffbf41",
".4 c #ffc04b",
"#T c #ffc349",
".H c #ffc656",
"#S c #ffc659",
"#L c #ffcc57",
"#C c #ffcd61",
"#D c #ffd264",
"#e c #ffd268",
"#d c #ffd369",
"#K c #ffd560",
".v c #ffd898",
".G c #ffdb6f",
".U c #ffdb72",
"#r c #ffdd6a",
"#x c #ffef96",
".n c #fff5c4",
".Y c #fffac4",
".K c #ffffa2",
".O c #ffffa8",
".D c #ffffb7",
".t c #ffffbf",
"ao c #fffff4",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"Qt.#.a.b.c.d.e.f.g.h.i.j.k.l.m.f.m.n",
".o.p.q.r.s.t.u.v.w.x.y.z.A.B.C.n.D.E",
".F.G.H.n.I.J.K.t.L.M.B.N.O.P.Q.R.S.T",
".o.U.V.n.n.I.W.X.Y.Z.0.1.B.I.2.3.4.5",
".o.U.6.7.n.8.9.8.Y.B#..L###a#b.4.5Qt",
"#c#d#e#f#g#h#i#j.u.Y#k#l#m#n.4.5#oQt",
"#p#q#r#s#t#g#u#v.I.I#w#x#y.4.5#zQtQt",
"#A#B#C#D#E#g#g#g#F#G.B.B.4.5#HQtQtQt",
"Qt#I#J#K#L#M#N.u.n.n#O#P.4.5QtQtQtQt",
"Qt#Q#R#S#T#U#V#W#X#Y#Z.4.5QtQtQtQtQt",
"Qt#0#1#2.4#3#4#5#6#7.4.5QtQtQtQtQtQt",
"#8Qt#9a.a#aaabacad.4.5QtQtQtQtQtQtQt",
"Qtaeafagahaiajak.4.5QtQtQtQtQtQtQtQt",
"QtQtaealamanaoap.5QtQtQtQtQtQtQtQtQt",
"QtQtQtQtaqaras.5QtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtatauavQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image64_data[] = { 
"18 18 170 2",
".l c #00332c",
".c c #008346",
".B c #203736",
"#W c #322628",
"ae c #421214",
"as c #451b1b",
"ad c #4f4547",
"aw c #512525",
"#J c #513430",
".W c #55352e",
"#c c #56322d",
"an c #574646",
"#t c #5a362f",
"#5 c #5b1e1a",
"#l c #5f5347",
"aM c #614a45",
"aL c #634b45",
"aC c #654b46",
"#7 c #682726",
".g c #684f4d",
".h c #6b5757",
".f c #6c5654",
".7 c #6e3d33",
".U c #6e4b3a",
"aI c #6f3a30",
".e c #736968",
".i c #746466",
"ax c #752e2e",
".j c #767972",
"ay c #7a3737",
"#r c #7a473e",
"al c #7b2822",
"ar c #7b2c1e",
"#6 c #7b7778",
"am c #7c7877",
".5 c #7d3e35",
"at c #7e3939",
"#a c #807d7d",
"#H c #832716",
"aD c #872c1c",
"#V c #872d1c",
"aB c #877d7a",
".b c #87aa72",
"#8 c #883b38",
"av c #8a807e",
"aJ c #8d8988",
".N c #8e2517",
"aE c #8e3225",
"aH c #8f3123",
"au c #923529",
".k c #92b666",
"aK c #938a89",
"az c #943d35",
".Y c #979a9a",
".a c #98b86f",
"aq c #993d33",
"aN c #9a9594",
"aA c #9c392b",
".Z c #9f2915",
".4 c #9f4c38",
".6 c #a03b2f",
".m c #a09e9e",
"aG c #a13f34",
".u c #a19f9f",
".D c #a2a0a0",
"aF c #a34035",
".8 c #a35d55",
"#k c #a44138",
".L c #a4c883",
".V c #a53420",
"ac c #a63320",
"ak c #a73f32",
".M c #a9b4b3",
"#9 c #ab4031",
"ao c #ad4031",
"ap c #ae4131",
".n c #af6865",
".A c #afd489",
"ag c #b14131",
".# c #b1d583",
"ab c #b44231",
".t c #b4d687",
"af c #b84431",
"#X c #b84737",
"ah c #b9422e",
".E c #bc5a4f",
".S c #bd3f27",
"aj c #be4531",
".v c #be5e54",
".K c #bfb678",
"## c #c2371d",
".T c #c2412c",
"#m c #c56e5e",
"ai c #c7472e",
".d c #c7c7c7",
"#3 c #c9462b",
"aa c #c9462c",
"#Y c #c9472d",
"#L c #c9472e",
"#4 c #ca4b33",
"a# c #cb472c",
"a. c #cb472d",
"#K c #cd4b32",
".X c #cecdcd",
"#U c #d24b2f",
"#I c #d2d2d2",
"#u c #d34b31",
"#q c #d44a32",
"#d c #d95137",
"#G c #db5138",
".I c #db523b",
".R c #df5c48",
".J c #e45241",
"#T c #e45f4d",
"#. c #e46654",
"#v c #e56c5c",
"#M c #e66453",
"#0 c #e76e5e",
"#s c #e7e7e7",
"#e c #e8614f",
"#2 c #e86756",
"#S c #e86757",
"#F c #e96757",
"#B c #e98f87",
"#Z c #ea7063",
".s c #ebc0b0",
".H c #ec776a",
"#1 c #ed7265",
"#j c #ed887d",
"#N c #ee7a6e",
"#n c #ee9b95",
"#p c #ef7667",
"#w c #ef8e85",
"#A c #f39f98",
".0 c #f48376",
"#f c #f4a09b",
"#O c #f4a6a2",
".o c #f4b5b1",
".Q c #f6a7a4",
".y c #f6ada9",
"#E c #f6afaa",
"#y c #f6b5b2",
"#x c #f7b0ad",
".G c #f7bab7",
"#R c #f7bfbb",
"#h c #f7c0bd",
".C c #f7f7f7",
"#g c #f8bfbb",
".2 c #f8c1be",
".9 c #f99d94",
".3 c #f9a29a",
"#Q c #f9b8b5",
"#P c #f9bfbc",
"#i c #f9c2bf",
".1 c #f9c9c6",
".P c #f9cdcb",
"#o c #fac1c0",
"#D c #fac5c2",
"#z c #fac5c4",
".z c #fcaeae",
"#C c #fcb0ac",
".O c #fd8f84",
"#b c #fdfdfd",
".x c #fee8e6",
".F c #ffb8b3",
".q c #ffc6c3",
".r c #ffcccb",
".w c #ffd4d0",
".p c #ffd9d7",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQt.#.a.b.c",
"QtQtQtQtQt.d.e.f.g.h.i.j.k.#.a.b.lQt",
"QtQtQtQt.m.n.o.p.q.r.s.k.t.a.b.lQtQt",
"QtQtQt.u.v.w.x.x.y.z.k.A.a.c.c.B.CQt",
"QtQt.D.E.F.x.G.H.I.J.K.L.c.l.l.MQtQt",
"QtQt.N.O.P.x.Q.R.S.T.l.l.l.U.V.W.XQt",
"Qt.Y.Z.0.1.x.2.3.4.5.6.7.8.9#.###a#b",
"Qt#c#d#e#f#g#h#i#j#k#l#m#n#o#p#q#r#s",
"Qt#t#u#v#v#w#x#y#z#A#B#C#D#E#F#G#H#I",
"Qt#J#K#L#v#v#M#N#O#P#Q#R#E#S#T#U#V#I",
"Qt#W#X#L#Y#v#v#v#T#Z#0#1#2#T#3#4#5#I",
"Qt#6#7#8#9a.a##T#T#T#T#T#TaaabacadQt",
"QtQtae#8acafagahaia.#T#Tajakacalam#b",
"QtQtan#8#8acacacacaoapaqacacacarQtQt",
"QtQtQtasat#8#8#8acacacacacacauavQtQt",
"QtQtQtQtawax#8ayacacacacazaAaBQtQtQt",
"QtQtQtQtQtaCaDaEaFaGaFaHaIaJQtQtQtQt",
"QtQtQtQtQtQtQtaKaLaMaLaNQtQtQtQtQtQt"};

static const char* const image65_data[] = { 
"18 18 80 2",
".s c #7c0c00",
".U c #8a332a",
".L c #8d352c",
"#c c #8d635f",
".E c #8e3428",
"#b c #987571",
"#g c #9e3a28",
".M c #a49b97",
".# c #a59795",
"#k c #a87674",
"#a c #aa8682",
".9 c #aea4a6",
".h c #b29286",
".c c #b2978e",
".w c #b65935",
"#n c #b69e9c",
".8 c #bc9583",
".p c #bea295",
".T c #bee2e3",
".5 c #bfbbbb",
"#h c #c08d8d",
".3 c #c0aaac",
".v c #c2c4c5",
".6 c #c37555",
".4 c #c8989b",
".Z c #cbb2b3",
".n c #ccada1",
".7 c #cd8b70",
".q c #cdcac7",
".e c #cf9d89",
".o c #cfb8ae",
"#f c #d09f8d",
"## c #d2bdb4",
"#l c #d37955",
"#j c #d3bcb4",
"#m c #d3d1cf",
".i c #d5ac9c",
".0 c #d6a2a5",
".k c #d77c62",
".S c #d89da0",
".2 c #d8afb1",
".r c #d8d5d1",
".K c #d9eaeb",
"#i c #dba590",
".j c #dba894",
"#d c #deae9a",
".d c #e0af9a",
".u c #e3b09b",
".1 c #e4c5c7",
".D c #e5ecee",
".x c #e6baaa",
".g c #e7baac",
"#e c #e7c2b4",
"#. c #e7c3b5",
".f c #e9c0b1",
".J c #edc0c2",
".V c #f1ffff",
".W c #f48e93",
".P c #f49b9f",
".C c #f4ffff",
".H c #faa2a6",
".O c #fab9bd",
".B c #fadfe0",
".a c #fcffff",
".G c #fdcbce",
".I c #fe212c",
".A c #fed3d4",
".b c #fefefe",
".X c #ff000b",
".Q c #ff020e",
".y c #ff040f",
".F c #ff1218",
".Y c #ff121d",
".R c #ff141f",
".m c #ff1520",
".z c #ff1b26",
".l c #ff9ca1",
".t c #ffa1a6",
".N c #ffe4e7",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQtQtQt.#QtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQt.#.a.#QtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQt.#.b.b.c.dQtQt",
"QtQtQtQtQtQtQtQtQtQtQt.#.b.e.b.f.gQt",
"QtQtQtQtQtQtQt.#.#.#.#.h.e.i.b.j.kQt",
"QtQtQtQtQtQt.l.m.b.b.n.e.o.b.p.q.r.s",
"QtQtQtQtQt.t.m.m.b.b.u.v.w.s.s.s.s.x",
"QtQtQtQt.#.y.z.A.b.B.C.D.E.sQtQtQtQt",
"QtQtQt.#.z.F.G.b.H.I.J.K.LQtQtQtQtQt",
"QtQtQt.M.N.O.b.P.Q.R.S.T.UQtQtQtQtQt",
"QtQtQt.#.b.V.W.X.Y.Z.0.Y.sQtQtQtQtQt",
".#.#.#.b.#.b.1.2.3.4.Y.sQtQtQtQtQtQt",
".#.b.5.6.7.8.b.b.9.Y.sQtQtQtQtQtQtQt",
".#.b#..6##.s#a#b#c.sQtQtQtQtQtQtQtQt",
"#d#e.6#f#g#h.s.s.sQtQtQtQtQtQtQtQtQt",
"Qt#i.b#j#k.sQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQt#l#m#n.sQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQt.s.sQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image66_data[] = { 
"18 18 44 1",
"k c #303030",
"p c #333333",
"j c #404040",
"u c #504827",
"b c #505050",
"r c #605a41",
"c c #606060",
"v c #663300",
"l c #6b6b6b",
"o c #707070",
"# c #777777",
"m c #7f7f7f",
"t c #807445",
"d c #808080",
"h c #8c8c8c",
"E c #8f7819",
"g c #8f8f8f",
"A c #996600",
"z c #af9f5c",
"n c #afafaf",
"D c #b2b2b2",
"f c #bababa",
"a c #bfbfbf",
"s c #cc9900",
"w c #cccccc",
"e c #cfcfcf",
"O c #d2d2d2",
"F c #d6d6d6",
"N c #d9d9d9",
"M c #dfdfdf",
"q c #e5e5e5",
"P c #ececec",
"L c #efc622",
"x c #ffcc00",
"K c #ffd630",
"C c #ffd738",
"J c #ffd83c",
"B c #ffda46",
"I c #ffdb49",
"H c #ffdd55",
"y c #ffe062",
"G c #ffe26f",
"i c #ffe374",
". c #ffffff",
".......##a##......",
"....b#c.a...#.....",
"...d..e.....#f....",
"..g.....e..eeh....",
".gge..eeeieeacjk..",
"ge.eeee.ieeeec..l.",
"m...eccnoccckpa.oq",
"ge.arsstusssvw#ioq",
".cocsxsssxssv.#aoq",
"..s.sysxsxsxv.#ioq",
"..s.s.zxsiABv.#aoq",
"..s.A.zyAyAyv#aioq",
"..s.A.A.AyACveinoq",
"..s.A.A.A.ACvoooDq",
"..sEssssAAAAvwwwF.",
"..sy.GyHIJKLvM....",
"...AAAAAAAAAww....",
"....NwwwwwwwOP...."};

static const char* const image67_data[] = { 
"18 18 6 1",
"# c #6c3900",
"b c #8d5415",
"a c #e3b387",
"d c #fbcf79",
"c c #ffffb9",
". c #ffffff",
"........##.##.##..",
".......#ab#ab#ab#.",
".......#ab#ab#ab#.",
"......#ab#ab#ab#..",
"......#ab#ab#ab#..",
".....#ab#ab#ab#...",
".....#ab#ab#ab#...",
"....#ab#ab#ab#....",
"....#ab#ab#ab#....",
"...#ab#ab#ab#.....",
"...#ab#ab#ab#.....",
"..#cb#cb#cb#......",
"..#cd#cd#cd#......",
".#cd#cd#cd#.......",
".#cd#cd#cd#.......",
"#cd#cd#cd#........",
"#dd#dd#dd#........",
".##.##.##........."};

static const char* const image68_data[] = { 
"18 18 10 1",
"e c #6a6a69",
"a c #959595",
"h c #bcc0b9",
"# c #cccccc",
"g c #dbded9",
"f c #e9eee7",
"d c #eff6f2",
"c c #f3fcfd",
"b c #f9feff",
". c #ffffff",
"....#...#...#.....",
"...#...#...#......",
"...#...#...#......",
"....#...#...#.....",
".....#...#...#....",
".....#aaa#aa.#....",
"....a#bbb#bba#....",
"..aab#bbb#cbc#aa..",
".acc#ccc#ccc#ccca.",
".acccccccccccccca.",
"adccccccccccccccde",
"afdccccccccccccdfe",
"agfddddddddddddfge",
"ahgffffffffffffghe",
".ehgggggggggggghe.",
"..eehhhhhhhhhhee..",
"....eeeeeeeeee....",
".................."};

static const char* const image69_data[] = { 
"18 18 31 1",
"a c #793f04",
"c c #9c4c00",
"b c #adadad",
". c #ef8000",
"h c #ffbf64",
"A c #ffe6a8",
"z c #ffe7aa",
"v c #ffe8ae",
"u c #ffe9b2",
"y c #ffe9b3",
"C c #ffe9b4",
"x c #ffebb8",
"B c #ffebb9",
"w c #ffecbe",
"r c #ffeec3",
"t c #ffeec4",
"o c #ffeec5",
"p c #ffefc9",
"q c #fff0c9",
"s c #fff0ca",
"n c #fff0cd",
"m c #fff1cf",
"l c #fff3d5",
"j c #fff3d7",
"g c #fff4d8",
"e c #fff4d9",
"k c #fff5dc",
"i c #fff6de",
"f c #fff6e0",
"d c #fff6e1",
"# c #ffffff",
".##aa###bb#####bb#",
"c.adea##bb########",
"#afghaa#####bb####",
"aijhakla###bbbbb##",
"alhakhmha##bbbb###",
"anohhapha###bb####",
"#aaaaqrhaaa##b####",
"###asthauvha######",
"###atwxyvzAaa#####",
"###ahBChaAAaAa####",
"####ahhaAAhaha####",
"#####aaAAhaAha####",
"#######ahhhha#####",
"########aaaac.####",
"#############c.###",
"##############c.##",
"###############c.#",
"################c."};

static const char* const image70_data[] = { 
"18 18 15 1",
"j c #742200",
"# c #932c1b",
"g c #a83a0c",
"d c #d86c09",
"i c #df750d",
"e c #df810d",
"m c #e89209",
"b c #f69f0a",
"h c #f8971f",
"k c #f8b60a",
"l c #f8c70a",
"c c #f8c91e",
"f c #f8d516",
"a c #fce36c",
". c #ffffff",
"..................",
".......##.........",
"......#aa#........",
"....##abba##....#.",
"...#aacddbba#..#a#",
"..#aeecfbddb#.#ab#",
".#adggfbdbbd##hfd#",
"#afijjfbfddbkfbfb#",
"#affffffdfbdffkb#.",
"#klffffkddkdbfff#.",
".#lbffbdbbdkkkbfb#",
".#kbkfbbfkkkbdkbb#",
"..#kkkkkkdddfd#dd#",
"...##ddddbbld#.#d#",
".....#bfbcbm##..#.",
"......######......",
"..................",
".................."};

static const char* const image71_data[] = { 
"18 18 69 2",
".# c #888888",
"#a c #a75018",
"## c #a9521b",
".8 c #ac5822",
".5 c #ac5a24",
".4 c #ae5c26",
".1 c #b1622d",
".X c #b26430",
".W c #b36733",
".T c #b66d3a",
".S c #b8703d",
".J c #bc7948",
".I c #bd7b4b",
".B c #c28455",
".A c #c38657",
".x c #c68d5f",
".b c #c7c7c7",
".q c #cc986d",
".p c #cd9b6f",
".c c #ce6f00",
".l c #d1a379",
".Y c #d27537",
".k c #d2a57c",
".O c #d68348",
".F c #d98b53",
".w c #dd9862",
".t c #df9d6a",
".a c #e1e1e1",
".h c #e6b183",
".e c #e8b98d",
".d c #ebc096",
"#c c #f2a214",
"#b c #f2a316",
"#. c #f3a61c",
".9 c #f3a71f",
".6 c #f3a822",
".7 c #f3aa26",
".3 c #f4ab29",
".2 c #f4ac2b",
".V c #f4b135",
".U c #f4b237",
".L c #f5b642",
".K c #f5b845",
".P c #ff8f45",
".E c #ff9a55",
".m c #ffb276",
".0 c #ffe033",
".Z c #ffe135",
".R c #ffe340",
".Q c #ffe342",
".N c #ffe54b",
".H c #ffe54d",
".M c #ffe550",
".G c #ffe650",
".z c #ffe75b",
".y c #ffe85d",
".s c #ffe968",
".r c #ffea6a",
".g c #fff889",
".f c #fff98b",
".D c #fffdca",
".C c #fffdcb",
".v c #fffdcd",
".u c #fffecd",
".o c #fffecf",
".n c #fffed0",
".j c #fffed1",
".i c #fffed2",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQt.#.#.#.#.#.#Qt",
"QtQtQtQtQtQtQtQtQtQt.#Qt.aQt.aQt.#Qt",
"QtQtQtQtQtQtQtQtQt.#.aQt.#.#.#.#.#Qt",
"QtQtQtQtQtQtQtQt.#.b.#.#QtQtQtQtQtQt",
"QtQtQtQtQtQtQtQt.#.#QtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQt.c.c.cQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQt.c.d.cQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQt.c.e.f.g.cQtQtQtQtQtQtQt",
"QtQtQtQtQt.c.h.i.j.k.l.cQtQtQtQtQtQt",
"QtQtQtQt.c.m.n.o.p.q.r.s.cQtQtQtQtQt",
"QtQtQt.c.t.u.v.w.x.y.z.A.B.cQtQtQtQt",
"QtQt.c.y.C.D.E.F.G.H.I.J.K.L.cQtQtQt",
"Qt.c.M.H.N.O.P.Q.R.S.T.U.V.W.X.cQtQt",
"Qt.c.R.S.T.Y.Z.0.X.1.2.3.4.5.6.cQtQt",
"Qt.c.X.1.2.3.7.5.8.9#.###a#b#c.cQtQt",
"QtQt.c.c.c.c.c.c.c.c.c.c.c.c.cQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image72_data[] = { 
"18 18 134 2",
"#p c #422f06",
".E c #433100",
".W c #453200",
".M c #453300",
".F c #483500",
"#d c #4f3508",
".D c #573e00",
".L c #5a4000",
".n c #5c4200",
".m c #604300",
".f c #604600",
".O c #614700",
".P c #624800",
"#N c #63230a",
".U c #634700",
"#B c #66260d",
".V c #664c00",
".g c #674900",
".w c #694d00",
"#Z c #6c240c",
".0 c #6d2b0e",
"#q c #6d3d00",
"#h c #6e3d00",
".Q c #6e5300",
"#7 c #702c0e",
"#8 c #702d0f",
".R c #715500",
".u c #724e00",
".b c #725700",
".# c #735800",
"#g c #744100",
"#e c #744d00",
"ab c #763110",
".d c #765400",
".H c #766000",
".c c #775500",
"#f c #784400",
".N c #785500",
".v c #785800",
".T c #785900",
".J c #796400",
".s c #7b6600",
".C c #7f5700",
"#0 c #812a01",
".6 c #842f11",
".A c #866700",
".q c #887400",
"#u c #8a2600",
".G c #8a6300",
".X c #8a7000",
".S c #8b6800",
"a. c #8d3401",
".y c #8d6d00",
".k c #8f7202",
"#A c #902f0e",
"a# c #903501",
"aa c #933701",
"#4 c #943801",
"#T c #963901",
"#H c #9a3b01",
".K c #9c7300",
".Y c #9c7c00",
"#Y c #9d450f",
".l c #9d7502",
".Z c #9e7e00",
".B c #9f7500",
".o c #9f7600",
".I c #9f7b00",
"#6 c #a05936",
".i c #a08400",
"#I c #a15a37",
".8 c #a18100",
"#j c #a25b37",
"#U c #a25b38",
".x c #a27900",
"#5 c #a35b39",
".9 c #a35c39",
".7 c #a58500",
"#v c #a65e3b",
".t c #a77c00",
"ad c #a94100",
"#J c #ab633d",
"#k c #b0663f",
".5 c #b55111",
".z c #b58f00",
".p c #b68e00",
".4 c #be530e",
"#X c #be5500",
"#S c #bf5301",
"#G c #c15401",
"#M c #c34f00",
"#r c #c85f04",
".r c #c8a500",
"#3 c #c95d00",
".j c #caa803",
"#z c #cc5400",
".2 c #cc6a16",
"#t c #ce6000",
".1 c #ce681b",
"#o c #d05800",
".3 c #d06c15",
".h c #d0ae00",
"#s c #d16300",
"#W c #d27400",
"#R c #d87000",
"#c c #d96d00",
"#V c #da8700",
"#L c #db7600",
"#F c #df7800",
"#y c #df7c00",
"#9 c #e1e1e1",
"#2 c #e68900",
"#1 c #e69405",
"#K c #e69b00",
".e c #e7e7e7",
"ac c #e8e8e8",
".a c #e9e9e9",
"#i c #eaeaea",
"#x c #eba400",
"## c #ecb100",
"#n c #ed9e00",
"#C c #ee9c00",
"#Q c #ef9e00",
"#b c #efa200",
"#. c #f0ae0c",
"#w c #f2b311",
"#D c #f4aa00",
"#m c #f4b900",
"#l c #f4bc0f",
"#a c #f4bd00",
"#P c #fdad00",
"#E c #febb00",
"#O c #ffad00",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQt.#.aQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQt.b.#.c.d.d.eQtQtQtQtQtQtQt",
"QtQtQt.f.g.h.i.j.k.l.m.m.eQtQtQtQtQt",
"QtQt.n.o.p.q.r.s.t.u.u.v.m.aQtQtQtQt",
"Qt.f.w.x.y.z.A.B.u.C.D.E.F.m.aQtQtQt",
"Qt.f.G.H.I.J.K.u.C.L.M.N.N.N.NQtQtQt",
"Qt.O.P.Q.R.S.T.U.V.W.X.Y.X.Z.N.NQtQt",
"QtQt.0.1.2.3.4.5.6.X.Y.X.7.X.8.N.aQt",
"QtQt.9#.###a#b#c#d.Y.X#e#f#e#g#h#iQt",
"QtQt#j#k#l#m#n#o#d#p#q#g#r#s#t#u#iQt",
"QtQtQt#v#w#x#y#z#A#B#C#D#E#F#G#H#iQt",
"QtQtQt#I#J#K#L#M#A#N#O#P#Q#R#S#T.aQt",
"QtQtQtQt#U#V#W#X#Y#Z#0#1#2#3#4.aQtQt",
"QtQtQtQtQt#I#5#6#7#8#9a.a#aa.aQtQtQt",
"QtQtQtQtQtQtQtab.aacQtQtQtad.aQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image73_data[] = { 
"18 18 80 2",
".q c #6f550c",
".x c #6f5614",
".L c #735b2e",
".r c #745915",
".m c #755c21",
".t c #786035",
".g c #7a612b",
".F c #806732",
".T c #833600",
".3 c #863700",
".e c #8d763d",
".c c #907a46",
".h c #9a8353",
"#m c #a35200",
".# c #a48f5c",
".a c #a59160",
".1 c #ae5200",
"#d c #b15600",
".S c #b35b00",
"#j c #b46700",
"#l c #b86200",
"#c c #bf6900",
".2 c #c37100",
".l c #c4b46d",
"#e c #c77e00",
".9 c #c98100",
".k c #cabb7f",
".w c #cabc81",
"#n c #cb7800",
".4 c #cb8200",
".E c #cba436",
".u c #cba438",
".f c #cbbc81",
".p c #cbbd82",
".0 c #cd6a00",
".8 c #d17000",
"#b c #d17400",
".U c #d18800",
".R c #d27300",
".D c #d2a030",
".M c #d49100",
"#i c #d67e00",
".K c #d68a09",
".C c #d99c15",
".v c #d9b335",
".Q c #da7e00",
"#a c #db8400",
".y c #dca40c",
".J c #e08a00",
".s c #e0a30c",
".Z c #e49300",
"#k c #e79400",
"#h c #e99600",
".I c #ea9a00",
"## c #ea9b00",
"#g c #ed9d00",
".B c #f1a400",
".H c #f29c00",
".o c #f2e19d",
".j c #f2e29f",
".n c #f3e29b",
".i c #f3e29c",
".d c #f3e7b3",
".6 c #f5a407",
".Y c #f5a607",
"#f c #f5ae00",
".P c #f5af00",
".b c #f5ecc1",
"#. c #f8b702",
".7 c #fabb02",
".5 c #fbc002",
".A c #fdbc02",
".V c #fec407",
".X c #fec807",
".W c #ffc709",
".N c #ffcc0f",
".G c #ffcd0f",
".O c #ffce11",
".z c #ffd314",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQt.#.#QtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQt.a.b.b.cQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQt.#.d.e.f.gQt",
"QtQtQtQtQtQtQtQtQtQtQt.h.i.j.k.l.mQt",
"QtQtQtQtQtQtQtQtQtQt.h.n.o.p.q.rQtQt",
"QtQtQtQtQt.s.s.s.s.t.u.v.w.xQtQtQtQt",
"QtQtQt.y.y.z.A.A.B.C.D.E.FQtQtQtQtQt",
"QtQt.y.G.A.z.A.H.I.J.K.LQtQtQtQtQtQt",
"Qt.M.N.A.O.A.P.J.Q.R.S.TQtQtQtQtQtQt",
".U.V.W.X.Y.P.Z.Q.0.1.2.3QtQtQtQtQtQt",
".4.5.6.7.P.Z.Q.8.1.2.TQtQtQtQtQtQtQt",
".9.7#..P###a#b#c#d.2.3QtQtQtQtQtQtQt",
"#e#f#g#h#a#i#c.S.2.3QtQtQtQtQtQtQtQt",
"Qt#j#k#a.Q#c#l.2.3QtQtQtQtQtQtQtQtQt",
"QtQt#m#n#n.2.2.3QtQtQtQtQtQtQtQtQtQt",
"QtQtQt.3.3.3.3QtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image74_data[] = { 
"18 18 108 2",
"#P c #d55d15",
".S c #d58615",
"#J c #d58815",
"#I c #d67717",
"#t c #d68a15",
"#h c #d78915",
".6 c #d78a1a",
"#O c #d97417",
"#L c #d97e1b",
"#M c #da7e1b",
"#N c #da801b",
"#K c #da831b",
"#B c #db8a1d",
".T c #db9f1d",
"#z c #dc9720",
"#A c #dc9a1d",
"#v c #dc9c20",
"#u c #dca020",
".7 c #dca420",
"#i c #dca721",
".F c #e78c17",
".u c #e79317",
".l c #e79617",
".d c #e79717",
".c c #e7971a",
".b c #e89d1d",
".G c #e89e20",
".v c #e89f20",
".a c #e8a121",
".m c #e9a021",
".# c #e9a323",
".n c #eaa128",
".f c #eaa429",
".e c #eaa629",
"#H c #f6e992",
".R c #f7eb9d",
".5 c #f7eb9e",
"#G c #f8ec9e",
"#C c #f8eca4",
"#j c #f8eca6",
"#y c #f8eca7",
"#D c #f8eca8",
"#F c #f8efa9",
"#E c #f8efae",
".t c #f8f5c7",
"#s c #f8f5c8",
".k c #f9f0ba",
".j c #f9f0bb",
".i c #f9f0be",
".w c #f9f0c1",
".h c #f9f2c1",
".g c #f9f2c3",
"#x c #f9f7d0",
"#r c #f9f7d2",
".U c #faf3ce",
".8 c #faf5d4",
".s c #faf7d0",
".4 c #faf7d2",
".E c #faf7d3",
".Q c #faf7d6",
".r c #faf8d4",
".H c #faf8dc",
".V c #faf8de",
".D c #faf8e3",
"#g c #fbf6d8",
".W c #fbfaec",
"#e c #fdd867",
"#q c #fddc77",
".q c #fdde8d",
".3 c #fde28d",
".C c #fde28e",
".p c #fde295",
".J c #fde395",
".P c #fde9a4",
"#w c #fdfdf1",
"#f c #fefdf1",
".o c #fefdf2",
".9 c #fefdf4",
"#k c #fefef0",
"#l c #fefef2",
"#d c #ff4800",
".2 c #ff4e00",
"#o c #ff5000",
"#p c #ff5500",
"#n c #ff6b00",
"#c c #ff7400",
".1 c #ff8200",
".O c #ff8300",
"## c #ff8400",
"#. c #ff8a00",
"#a c #ff8e00",
"#b c #ff9000",
".y c #ff9500",
".N c #ffa600",
".X c #ffad00",
".K c #ffae00",
".B c #ffb100",
".z c #ffb300",
".0 c #ffb500",
".A c #ffb800",
".M c #ffc000",
".Y c #ffc100",
".Z c #ffc400",
".L c #ffc700",
".I c #ffe680",
".x c #ffe6a6",
"#m c #ffec67",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQt.#.a.b.c.d.d.dQtQtQtQt",
"QtQtQtQtQt.e.f.g.h.i.j.j.k.k.l.dQtQt",
"QtQtQt.m.n.g.g.o.o.p.q.o.o.r.s.t.uQt",
"QtQt.v.i.w.o.x.y.y.z.A.B.C.o.D.E.k.F",
"Qt.G.i.H.o.I.y.J.K.L.M.N.O.P.o.Q.R.S",
".T.U.V.W.o.y.y.X.Y.Z.0.1.2.3.o.4.5.6",
".7.8.9.o.o.I#.###a#b#c#d#e#f#g.5#hQt",
"#i#j#g.9#k#l#m#n#o#p.1#q#f#r#s#tQtQt",
"Qt#u#v#j.9#w.9.o#f#f#f#w#x#y#tQtQtQt",
"QtQtQt#z#A#B#C#D#E#F#G#H#I#JQtQtQtQt",
"QtQtQtQtQtQt#K#L#M#N#O#PQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image75_data[] = { 
"18 18 166 2",
".x c #17a30f",
".I c #17a40f",
".w c #58de09",
".m c #ac6900",
".v c #af6f00",
".n c #b47600",
".H c #b67c02",
"aj c #c43238",
"a. c #c43438",
"#0 c #c43638",
"#b c #c44517",
"az c #c94b38",
"#o c #c94c38",
"ak c #ca4b38",
"aq c #ca4c38",
".2 c #ca5038",
".1 c #ca5235",
"#c c #ca5238",
".a c #ca5338",
".c c #ca5438",
"#n c #ca5532",
"aI c #ca5538",
".k c #ca5638",
"#z c #cb523b",
"ap c #cb623b",
"ay c #cb643b",
"#9 c #cc673b",
"#Z c #cc6a3b",
"#L c #cc6f3b",
"aH c #d18445",
"aJ c #d1884b",
"ai c #d18a4b",
".b c #d2a650",
".# c #d4a855",
"#Q c #f23000",
"#R c #f54300",
"#P c #f54600",
"aA c #f54c00",
".F c #f54f00",
".d c #f55200",
".j c #f55700",
"#O c #f55e00",
"#1 c #f65200",
"#2 c #f65b00",
"#q c #f67e00",
"#M c #f75000",
".0 c #f75d00",
"#N c #f76b00",
".t c #f77800",
".3 c #f77e00",
"#B c #f78100",
".Q c #f78200",
".D c #f78400",
"#A c #f86900",
"aG c #f86a00",
"ah c #f86b00",
"#T c #f86c00",
"#S c #f87300",
".P c #f88900",
"#d c #f88d00",
"#p c #f89000",
".C c #f89700",
"#e c #f8a000",
".O c #f98600",
"#F c #fa6b00",
"#G c #fa7700",
".U c #fa7b00",
".u c #fa7e00",
".h c #fa8100",
".f c #fa8500",
".z c #fa8700",
".i c #fa8a00",
"#C c #fa8d00",
".E c #fa9a00",
".R c #fa9e00",
".B c #fa9f00",
"aB c #faa000",
"#r c #faa100",
".p c #faa300",
"#E c #faa400",
".s c #faa600",
"#y c #faa827",
".Z c #faad00",
"aF c #fab100",
"#a c #fab400",
"aC c #fab700",
".y c #fb9200",
".A c #fb9b00",
".l c #fb9d00",
".g c #fb9e00",
"#f c #fb9f00",
".e c #fba300",
".r c #fba400",
".q c #fba600",
".4 c #fba900",
"#t c #fbaa00",
".G c #fbaf00",
".5 c #fbb100",
".6 c #fbb400",
".o c #fbb500",
"#D c #fbb700",
"#I c #fbb723",
".S c #fbb800",
"#m c #fbbb3c",
"#s c #fbbc00",
".J c #fbbd00",
"aE c #fbc000",
"ax c #fbc200",
"#J c #fbc240",
"aD c #fbc300",
"#K c #fbc44b",
"#x c #fbd800",
"ar c #fdad00",
"#V c #fe8300",
"#U c #fe8400",
"#H c #fe9700",
"#i c #fea700",
".7 c #feb600",
"#g c #febc00",
".T c #fec000",
"al c #fec800",
".N c #feca00",
"#h c #fecd00",
"af c #fece00",
"#3 c #fed300",
".8 c #fed400",
"## c #fed435",
".L c #fed600",
"a# c #fed700",
"ab c #fed800",
"ad c #fed900",
"#4 c #fedb00",
"an c #fedc00",
".Y c #fedc11",
"ac c #fede00",
"#8 c #fee100",
"#W c #fee200",
"aw c #fee302",
"#6 c #fee500",
"ae c #fee600",
"#w c #fee60c",
"#7 c #fee700",
"au c #fee720",
"aa c #feea11",
"#Y c #feeb00",
"#k c #feeb02",
".9 c #feec00",
"#v c #feee00",
"#5 c #fef000",
"as c #fef01b",
"#X c #fef200",
"ag c #fef215",
"#. c #fef500",
"am c #fef715",
"av c #fef723",
"at c #fef820",
"#u c #fefa00",
".X c #fefd00",
"#j c #feff00",
".K c #ffb700",
".M c #ffdd00",
"ao c #fff228",
"#l c #fff400",
".W c #fffd00",
".V c #ffff00",
"Qt c #ffffff",
"QtQtQtQt.#.a.a.a.a.a.bQtQtQtQtQtQtQt",
"QtQtQt.c.d.e.f.g.h.i.j.cQtQtQtQtQtQt",
"QtQt.k.l.m.n.o.p.q.r.s.t.aQtQtQtQtQt",
"Qt.a.u.v.w.x.y.p.z.A.B.C.D.kQtQtQtQt",
".E.F.G.H.I.J.y.K.L.M.N.O.P.d.#QtQtQt",
".a.Q.R.S.p.r.T.U.V.W.X.Y.Z.0.1QtQtQt",
".2.3.p.4.5.6.S.7.8.9.X#.###a#bQtQtQt",
"#c#d#e#a#f#g#h.4#i.9#j#k#l#m#nQtQtQt",
"#o#p#q#r.G.S#g#s#t#u#v#w#x#y#cQtQtQt",
"#z#A#B#C.p#D#E.E#B#F#G#H#c#c#I#J#K#L",
".E#M#N#O#P#O#Q#R#S#T#U#V#W#X.9#Y.9#Z",
"Qt#0#1#2#3.8#4#5.9#6#7#5#6#8#8#8#W#9",
"QtQta.#Oa#aaabacab#Yadaeae#Yafagahai",
"QtQtQtajakalam#Yadanadadaeaoan#sapQt",
"QtQtQtQtQtaqaralasatauavawax.6ayQtQt",
"QtQtQtQtQtQtazaAaBaCaDaEaFaGapQtQtQt",
"QtQtQtQtQtQtQtaHaq.a.kaI#caJQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image76_data[] = { 
"18 18 51 1",
"S c #6f521a",
"F c #b40000",
"o c #b91b00",
"i c #be4f00",
"# c #be5000",
"T c #c29f42",
"H c #c33600",
"M c #c33c00",
"E c #c44000",
"k c #c44500",
"U c #c4a44b",
"P c #c94a00",
"N c #c94b00",
"V c #c9a953",
"I c #ca4b00",
"O c #cb4f00",
"l c #d00000",
"R c #d1b567",
"A c #d94e00",
"u c #d95200",
"Q c #da4600",
"D c #da4d00",
"v c #da5800",
"B c #da5b00",
"L c #db5f00",
"C c #db6000",
"p c #dc5900",
"J c #dc6000",
"W c #e0cc7c",
"c c #e47800",
"t c #e86800",
"w c #ea6c00",
"z c #ea7100",
"K c #ea7400",
"x c #ea7600",
"g c #ef0000",
"q c #ef8200",
"G c #ef8a00",
"f c #ef8d00",
"b c #f10000",
"e c #f19b00",
"y c #f9ad00",
"n c #f9ae00",
"d c #fa0000",
"r c #fab400",
"s c #fab700",
"m c #fabc00",
"j c #fac100",
"h c #facc00",
"a c #fda436",
". c #ffffff",
"..#aba............",
".cddefaa..........",
"cdghhbbba.........",
"idgjdggbba........",
"klbdgmmnbba.......",
"opllqrsddgta......",
".ouvwxbdgryza.....",
"..oABCblrrdbba....",
"...oDBlbbbgglb....",
"....oEvFllGGdb....",
".....oHIBJKKbl....",
"......LoMNLKlO....",
"........LHHPOQR...",
".............STR..",
"..............SUR.",
"...............SVR",
"................SW",
".................."};

static const char* const image77_data[] = { 
"18 18 121 2",
"## c #00ce00",
".i c #3f1400",
".v c #451a00",
".B c #492000",
".I c #4d2200",
".K c #4d2400",
"#g c #4e2400",
".z c #512807",
".1 c #552e09",
".t c #562e09",
"#k c #572f0c",
".g c #582f0f",
".7 c #59300f",
".8 c #593111",
"#2 c #5a7e66",
"#i c #5d3615",
"#l c #5e3615",
".c c #5f2d00",
"#f c #602f02",
"#v c #65350c",
"#t c #693621",
"#w c #69380f",
"#. c #6c3d14",
"#s c #6e3f15",
"#u c #6e3f1b",
"#j c #70401a",
"#x c #742f21",
".a c #74471d",
"#h c #754030",
"#c c #774a20",
"#X c #779b82",
".J c #7c3b09",
".A c #7e3e0f",
".u c #804015",
"#a c #804c27",
".0 c #824515",
".h c #864a1a",
".H c #884c1d",
"#q c #894d20",
"#d c #89817e",
".b c #8a5023",
"#1 c #8a827e",
".6 c #8d5428",
"#Q c #8d8581",
".y c #8e5528",
"#y c #8e8682",
".X c #903f2d",
"#p c #903f2e",
".Y c #904030",
".P c #90572b",
".5 c #90582b",
"#m c #908883",
".4 c #908984",
".9 c #914d38",
".2 c #914e3b",
"#r c #91592e",
"#W c #928c86",
".W c #954735",
".Z c #955c31",
".V c #964836",
".s c #965d31",
".# c #965e32",
"#e c #968d87",
"#n c #988f89",
"#0 c #99918b",
".T c #9a928c",
"#b c #9c543d",
"#z c #9c948e",
".E c #9e9691",
"#B c #9f9792",
"#D c #9f9793",
".D c #a19a94",
"#C c #a29b95",
"#Z c #a39c96",
".S c #a39d97",
".F c #a49e98",
".N c #a59f9a",
".C c #a8a19b",
".G c #a8a39c",
"#M c #a8c4b1",
".M c #aca4a0",
".L c #b4afa9",
".f c #c34317",
".e c #c34717",
"#A c #c4c0bb",
"#o c #c4c1bc",
"#E c #c9c4bf",
".3 c #cac4c1",
".d c #d15b21",
"#L c #d9cebf",
".j c #da6923",
"#P c #dbd3c5",
".k c #dc712e",
".R c #e0d6cd",
"#K c #e0d6ce",
"#Y c #e0d8ce",
"#V c #e1dbd0",
"#J c #e3d9d2",
"#I c #e4ddd4",
"#O c #e4ded4",
".Q c #e8e2da",
"#H c #eae6de",
".U c #f1ece7",
"#G c #f2ece7",
"#U c #f5f2ef",
".O c #f9f7f5",
"#N c #faf8f7",
"#F c #faf9f7",
".q c #ff974e",
".p c #ffa056",
".r c #ffaa62",
".w c #ffb369",
".o c #ffb674",
"#T c #ffbb00",
".x c #ffbe7f",
".n c #ffc786",
".m c #ffcc91",
".l c #ffce93",
"#R c #ffd900",
"#S c #fff900",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQt.#.#.a.b.cQtQtQtQtQt",
"Qt.d.d.d.d.d.d.e.f.#.g.h.i.j.kQtQtQt",
"Qt.l.l.m.n.o.p.q.r.s.t.u.v.w.xQtQtQt",
"QtQtQtQtQtQtQtQtQt.y.z.A.BQtQtQtQtQt",
"QtQtQtQt.C.D.E.F.G.H.I.J.K.L.MQtQtQt",
"QtQt.N.G.O.O.O.O.O.P.K.J.z.Q.R.S.TQt",
"Qt.T.O.O.U.V.W.X.Y.Z.z.0.1.2.3.R.R.T",
"Qt.4.O.5.6.7.8.9#.###a#b##.9#c.2.R#d",
"Qt#e.O.5#f#g.8##.g#h###i#j#k###l.R#m",
"Qt#n.O#o#p#q#r#i#s#t#k#u#v#w#x#o.R#y",
"Qt#z.O.O#A#B.D#C#D.E#D#C#D#D#o.R.R#y",
"Qt#E.O.O.O.O.O.O#F#F#G#G#H#I#J#K#L#B",
"Qt#M#M#M#M.O.O#N#F#G#G#H#I#I#O#P#QQt",
"#M#R#S#T#S#M#U#G#G#G#H#I#I#I#V#WQtQt",
"#X#S#T#S#R#X#G#G#G#H#Y#Y#Y#Y#eQtQtQt",
"#X#X#X#X#X#X#Z#0#m#z#0#n#1#DQtQtQtQt",
"Qt#2#2#2#2QtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image78_data[] = { 
"18 18 146 2",
".F c #07132b",
"ab c #0d2e78",
"a. c #122c78",
".T c #122e7c",
".R c #1b283b",
"ai c #1c3284",
"ac c #1e4c99",
"aj c #1f3980",
"#0 c #1f3b80",
".S c #1f4b95",
"#v c #213f83",
".i c #214084",
"af c #214f9c",
"#t c #21509c",
".3 c #222a34",
"ad c #22519c",
"ae c #22519d",
"#7 c #22539d",
"ag c #234a9e",
"#E c #234c9e",
".5 c #23539d",
"#g c #23549d",
".j c #243f81",
"#j c #244285",
".P c #262626",
"ak c #263e93",
".J c #264184",
".h c #264386",
".n c #274284",
"#Y c #284aa0",
"#X c #28579f",
".g c #294385",
".6 c #2a4199",
"an c #2d3e96",
"#G c #2d4787",
"#Q c #2e5495",
"#1 c #2e5ca0",
"#Z c #2f409a",
".7 c #304887",
"#N c #334aa5",
"ah c #344aa5",
"#6 c #3461a3",
"#D c #3562a4",
"#h c #384aa7",
"al c #394aa8",
"#u c #3b4aa8",
"#9 c #3c48a7",
"am c #3c4aa9",
"#8 c #3e4aaa",
"#F c #3f4aab",
"#2 c #3f6aa8",
"#O c #404aab",
"#5 c #416ba9",
".x c #435e96",
"#s c #436eaa",
".G c #464e61",
".4 c #466da4",
"ao c #475c93",
"#3 c #4770ac",
"#4 c #4871ac",
".D c #495566",
"#f c #4a73ad",
"#i c #4c5f98",
"ap c #5465a2",
"#R c #557ab1",
".v c #575757",
"#W c #597eb3",
"#C c #5b7fb3",
".s c #5f82b5",
"#M c #6285b6",
".U c #6576a5",
"#S c #6687b7",
".f c #6778a6",
".2 c #69788e",
".k c #697aa7",
"#V c #6989b9",
"#r c #6a8bba",
".V c #6c85b1",
"#T c #708ebc",
".w c #717171",
"#U c #718fbc",
"#e c #7391bd",
"#P c #7484ad",
".o c #748db6",
"#w c #7492be",
"#H c #7593be",
".r c #7794bf",
"#L c #7a97c0",
"#B c #7c98c1",
".m c #8593b8",
"#k c #859fc5",
".q c #88a1c6",
"#I c #89a1c6",
"#K c #8ca4c8",
"#q c #8ea5c9",
".8 c #8ea6c9",
"#x c #91a7ca",
".p c #91a8ca",
".H c #939393",
".C c #94aacb",
"#J c #95abcc",
".E c #969696",
"#A c #97adcc",
"#d c #97adcd",
"aa c #a3aeca",
".y c #a3b6d2",
".Q c #a4a4a4",
"#l c #a5b7d3",
".t c #a7b8d4",
".B c #a8b9d4",
".O c #aabbd5",
"#z c #abbcd6",
"#p c #acbdd6",
".W c #afbfd8",
".9 c #b0bfd8",
".z c #b1c0d9",
".A c #b2c1d9",
"#y c #b5c3da",
".1 c #b6c4db",
"#c c #b7c5db",
".u c #bbbbbb",
".K c #bdcade",
"#m c #bfcbdf",
".N c #c2cee1",
"#o c #c4cfe1",
".X c #cdd7e6",
"#. c #ced7e6",
".L c #ced8e6",
".M c #d0d9e7",
".e c #d1d6e4",
"#n c #d1dae8",
".0 c #d4dce9",
"#b c #d4ddea",
".I c #dce0e9",
"a# c #e0e4ed",
".l c #e6e9f0",
".Y c #e6eaf2",
"## c #e8ecf3",
".Z c #eaeef5",
".d c #ebedf2",
"#a c #edf0f5",
".a c #fafafa",
".c c #ff3333",
".b c #ff9900",
".# c #ffff99",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQt.#.a.#.b",
"QtQtQtQtQtQtQtQtQtQtQtQtQt.bQt.b.c.#",
"QtQtQtQtQtQtQtQtQtQtQtQt.bQt.c.#Qt.a",
"QtQtQtQtQt.d.d.d.d.dQtQt.b.#.b.b.c.b",
"QtQtQt.e.f.g.h.i.j.k.l.b.b.b.c.bQtQt",
"QtQt.m.n.o.p.q.r.s.tQt.u.b.v.wQtQtQt",
"Qt.m.x.y.z.A.B.C.DQt.E.F.G.HQtQtQtQt",
".I.J.y.K.L.M.N.O.P.Q.R.S.T.eQtQtQtQt",
".U.V.W.X.Y.Z.0.1.2.3.4.5.6.fQtQtQtQt",
".7.8.9#.###a#b#c#d#e#f#g#h#i.dQtQtQt",
"#j#k#l#m#n.0#o#p#q#r#s#t#u#i.dQtQtQt",
"#v#w#x.t#y.1#z#A#B#C#D#E#F#i.dQtQtQt",
"#G#C#H#I.C#J#K#L#M#s#g#N#O#i.dQtQtQt",
"#P#Q#R#S#T#U#V#W#s#X#Y#F#Z.fQtQtQtQt",
".I#0#1#2#3#4#5#6#7#Y#8#9a.a#QtQtQtQt",
"Qtaaabacadaeafagah#F#9aiaaQtQtQtQtQt",
"QtQtaaajakalam#O#Oana.aaQtQtQtQtQtQt",
"QtQtQt.I#Paoapapao#P.IQtQtQtQtQtQtQt"};

static const char* const image79_data[] = { 
"18 18 18 1",
"m c #000000",
"f c #00276e",
"l c #0063ff",
"k c #009cff",
"n c #3163ce",
"o c #31ceff",
"# c #424242",
"e c #6363ce",
"i c #63ffff",
"b c #898792",
"d c #9c9cce",
"j c #9cffff",
"p c #a88791",
"h c #c8c8c8",
"g c #d6d6d6",
"c c #f0f0f0",
". c #fafafa",
"a c #ffffff",
".........#.......#",
".aaaaaaaaa#aaaaa#.",
".aaaaaaaaaa#aaa#a.",
".bbbbbbbbbbbbbbbb.",
"bcccccccccccccccc#",
"bcdeeeeeeeeefgggh#",
"bceijjjjjjiiklgmh#",
"bcejajajjjjiknggb#",
"bcejjajjjiiokngmh#",
"bceijjjijioiknggb#",
"bcejjjijiiiokngmh#",
"bceiiijioioiknppb#",
"bceiiiioioiokncch#",
"bceoooooooooklppb#",
"bcekkkkkkkkkkfcch#",
"bcgnnnnnnnnnngppb#",
"bchhhhhhhhhhhhhhh#",
".################."};

static const char* const image80_data[] = { 
"18 18 23 1",
"l c #0099ff",
"t c #16a8fe",
"h c #1c1c1c",
"u c #20b0fd",
"s c #2bb7fc",
"q c #36bffc",
"c c #393939",
"r c #41c7fb",
"b c #42c7fa",
"p c #4dcffa",
"n c #58d7f9",
"o c #62def8",
"m c #6be3f8",
"k c #72e9f7",
"a c #78edf7",
"e c #7b7b7b",
"# c #8f8f8f",
"d c #979797",
"g c #b1b1b1",
"j c #c5c3c3",
"i c #e3e3e3",
"f c #f4f3f3",
". c #ffffff",
"...........#######",
"...........#.a.b.c",
"...........#a.b.ac",
"...........#cccccc",
"..ddc........dec..",
".################.",
"#fffffffffffffffgh",
"#fcccciiicccjiiigh",
"#fcaadidcaaacdiigh",
"#fcdddicaaaklhdjgh",
"#fiiiicaaamnblhdgh",
"cccccicakopq.lhdgh",
"#iiiiicanrst.lhdgh",
"ccccciiclu..lhdjgh",
"#iiiiiidhlllhdjigh",
"ccccciiijhhhdjjigh",
"#ggggggggggggggggh",
".hhhhhhhhhhhhhhhh."};

static const char* const image81_data[] = { 
"18 18 48 1",
"t c #000000",
"D c #0d0d0d",
"x c #101010",
"F c #1c161a",
"s c #1f141a",
"H c #282828",
"y c #2e1d26",
"E c #303030",
"u c #3d2733",
"C c #404040",
"K c #505050",
"I c #5a5a5a",
"d c #5c3b4d",
"N c #666666",
"Q c #686868",
"g c #6d5763",
"m c #707070",
"L c #727272",
"M c #787878",
"w c #7a4f67",
"e c #7d6773",
"O c #7f7f7f",
"l c #808080",
"J c #878787",
"B c #8f8f8f",
"n c #996280",
"f c #a86c8d",
"b c #ababab",
"z c #afafaf",
"a c #b7769a",
"o c #c680a7",
"k c #cccccc",
"A c #cfcfcf",
"v c #d689b3",
"j c #d9d9d9",
"# c #dfdfdf",
"P c #e2e2e2",
"r c #e593c0",
"S c #e5e5e5",
"R c #e9e9e9",
"T c #ececec",
"h c #efefef",
"q c #f49dcd",
"G c #f5f5f5",
"p c #fcfcfc",
"i c #fefefe",
"c c #ffd2eb",
". c #ffffff",
"..................",
"....#aaaaaaaab....",
"...#accccccccdb...",
"...acceeefeegcdh..",
"...aceiiifiieadj..",
"...aceiiifiieadk..",
"..#acellmnllmfndb.",
".#accccccncccccodp",
"haccqqqqqnqqqqqqdb",
"#acqqqqqqnqqqqqqrd",
"acqqsturqnqvwwvqqd",
"anntxmttnnyttttnnd",
"acatzimtqqwtAAxdod",
"dddtBiCDdddtiiEFdd",
".GjHtttIAjJtKKtLAj",
"...hMNOkP..QttIkR.",
"....pRST....PkkP..",
".................."};

static const char* const image82_data[] = { 
"18 18 53 1",
"y c #1b467b",
"G c #4d719f",
"T c #6c8eb7",
"t c #84abdc",
"u c #90a9c7",
"F c #c5e4f3",
"X c #c6e5f3",
"Y c #c7e5f4",
"x c #c8a462",
"U c #c8e6f4",
"C c #cae6f4",
"Q c #cbe7f5",
"z c #cccccc",
"R c #cce7f5",
"O c #cde8f5",
"P c #cee8f5",
"W c #d7ecf7",
"E c #d8edf7",
"B c #e4f2fa",
"L c #ebf6fb",
"M c #f2f9fc",
"v c #f39019",
"K c #f3fafd",
"N c #f6fbfd",
"V c #f7fcfe",
"S c #fafdff",
"w c #fb4629",
"J c #fcfefe",
"D c #fcfeff",
"H c #fdfeff",
"A c #fefefe",
"I c #feffff",
"a c #ff3333",
"n c #ff9600",
"k c #ff960b",
"r c #ff9a0c",
"m c #ffa813",
"p c #ffba31",
"q c #ffc24b",
"f c #ffca81",
"h c #ffcd4d",
"s c #ffcd7c",
"b c #ffd090",
"c c #ffd28e",
"l c #ffd75e",
"o c #ffdd68",
"i c #ffe8cb",
"j c #ffea7a",
"e c #fff4e5",
"d c #fff999",
"g c #ffffb2",
"# c #fffffe",
". c #ffffff",
".......#ab........",
".......cdae.......",
"......faghi.......",
"......ajkla.......",
"......kmnop.......",
"......qraks.......",
".....tuvwxyyz.....",
"....tAAtyyBCyz....",
"....tAAAADEFyz....",
"....tAGAAHyFyz....",
"....tAGAIJyFyz....",
"....tAGKLMyFyz....",
".....GNGOyPyz.....",
".....GNGQyRyz.....",
".....GSPTPUyz.....",
".....GVWPXYyz.....",
".....GVWPXYyz.....",
"......GGGyyz......"};

static const char* const image83_data[] = { 
"18 18 38 1",
"A c #080320",
"E c #0c0430",
"G c #130f26",
"z c #141120",
"H c #1a0968",
"J c #343434",
"D c #404040",
"o c #606060",
"j c #7f7f7f",
"b c #926d00",
"q c #9f9f9f",
"x c #a6a6a6",
"w c #afafaf",
"t c #b2b2b2",
"r c #bfbfbf",
"I c #c7c7c7",
"a c #cccccc",
"e c #cfb034",
"n c #cfcfcf",
"u c #d6d6d6",
"s c #d9d9d9",
"# c #dfdfdf",
"F c #e5e5e5",
"p c #e9e9e9",
"C c #ececec",
"l c #efefef",
"y c #f5f5f5",
"f c #f9f9f9",
"v c #fcfcfc",
"m c #fefefe",
"B c #ff6600",
"c c #ffd632",
"d c #ffd739",
"g c #ffd83d",
"h c #ffda44",
"i c #ffdb4a",
"k c #ffdd55",
". c #ffffff",
"..............#...",
"a............bbb#.",
"a..a........bcdebf",
"a.a........bghieeb",
"a.a.......jbbkeeeb",
"a.a......jlmnbeebn",
"a.a.....jlmmmbebal",
"a.a....jlmmmnobap.",
"a.a...jlmmmnqoa#..",
"a.a..jlmmmnnors...",
"a.a.qlmmmnnotuv...",
"aa.wllmmnnoxnf....",
".arormmnnoxny.....",
"..zhABnnoxaC......",
"..DBhEnoxaF.......",
"..nGHBzxa#........",
"...IJAxru.........",
"....ysauv........."};

static const char* const image84_data[] = { 
"18 18 26 1",
"o c #3c5b60",
"f c #727a7f",
"# c #808080",
"a c #828282",
"j c #8dc8d2",
"x c #a2dce6",
"r c #a6dde7",
"u c #aadfe8",
"w c #abdfe8",
"q c #aee0e9",
"t c #afe1e9",
"p c #b3e2ea",
"v c #b6e1e8",
"n c #b7e4eb",
"m c #bce5ed",
"l c #bfe7ee",
"s c #c0e7ee",
"b c #c5c5c5",
"k c #cccccc",
"e c #d5d5d5",
"d c #e3e3e3",
"g c #eaf7f9",
"c c #f8f8f8",
"i c #fafafa",
"h c #ffffcc",
". c #ffffff",
"..................",
"..................",
".#######aaaaaaa...",
"##bcccccccccde#f..",
"#gabhhhicccdeajfk.",
"#ggabhccccdeajjfk.",
"#gggabdccdeajljfk.",
"#ggmjabddeajnjjfk.",
"#gmmmfaeeaoppqjfk.",
"#gmmfjmaajporjjfk.",
"#mmfjsmmmturorjfk.",
"#mfjvjpjwjxjjojfk.",
"ffjjjjjjjjjjjjofk.",
".ffffffffffffffkk.",
"..kkkkkkkkkkkkkk..",
"..................",
"..................",
".................."};

static const char* const image85_data[] = { 
"18 18 80 2",
".2 c #004900",
".M c #393a17",
".U c #3d521b",
".F c #4c5a32",
".O c #58a11d",
".x c #5c9032",
".y c #675a3b",
"#l c #6cb92e",
"#k c #6eba31",
"#h c #70bb34",
".4 c #719a51",
"#j c #71bc36",
"#c c #72bc37",
".L c #74a44d",
"#g c #74bd39",
"#i c #75be3c",
"#b c #76be3d",
"#f c #78bf40",
".8 c #79bf41",
"#a c #7bc044",
".1 c #7bc145",
"#e c #7dc247",
".P c #7ea163",
".7 c #7ec248",
"## c #80c34c",
".0 c #81c34d",
"#d c #83c44f",
".6 c #84c550",
".T c #84c551",
".Z c #87c655",
".E c #8baf6e",
".S c #8bc85a",
"#. c #8dc95e",
".Y c #8ec95f",
".5 c #91cb63",
".c c #924900",
".R c #92cb64",
".X c #9dd174",
".z c #9e7743",
".K c #9ed175",
".Q c #a2d37b",
".I c #b0d98f",
".D c #b5dc96",
".a c #bd7a21",
".G c #bfbfbf",
".J c #cae2b7",
".V c #cccccc",
".d c #ceb18a",
".i c #cfcfcf",
".3 c #d2d2d2",
".w c #d9d9d9",
".b c #dd9330",
".r c #dfdfdf",
"#n c #e2e2e2",
".H c #e5e5e5",
".9 c #ececec",
".A c #edad58",
".n c #eec184",
".W c #efefef",
"#m c #f2f2f2",
".m c #f9f9f9",
".N c #fcfcfc",
".C c #fdb14b",
".v c #fdb350",
".B c #fdb554",
".u c #fdb759",
".q c #fdb95f",
".t c #fdbb63",
".l c #fdbc65",
".p c #fdbe69",
".# c #fdc170",
".h c #fdc376",
".s c #fdc57a",
".k c #fdc67b",
".o c #fdc881",
".g c #fdc982",
".j c #fed196",
".e c #fed59e",
".f c #ffe7c6",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQt.#.#QtQtQtQtQtQt",
"QtQtQtQtQtQtQtQt.a.b.b.b.c.dQtQtQtQt",
"QtQtQtQtQtQtQt.a.d.e.f.g.h.c.dQtQtQt",
"QtQtQtQtQtQt.i.a.j.f.k.#.l.b.c.mQtQt",
"QtQtQtQtQtQt.a.n.o.f.p.q.b.b.c.rQtQt",
"QtQtQtQtQt.d.a.s.f.t.u.v.b.b.c.wQtQt",
"QtQtQtQtQt.x.y.z.A.B.C.b.b.b.c.wQtQt",
"QtQtQtQt.D.x.D.E.F.c.b.b.b.c.G.HQtQt",
"QtQtQtQt.x.I.J.K.K.L.M.b.a.c.i.NQtQt",
"QtQtQt.O.P.Q.J.R.S.T.O.U.c.V.HQtQtQt",
"QtQt.W.x.X.J.Y.Z.0.1.O.2.x.3QtQtQtQt",
"QtQt.O.4.5.J.6.7.8.O.O.2.V.9QtQtQtQt",
"QtQt.x#..J###a#b#c.O.2.x.3QtQtQtQtQt",
"QtQt.x#d#e#f#g#h.O.O.2.V.WQtQtQtQtQt",
"QtQt.D.x#i#j#k.O.O.2.x.wQtQtQtQtQtQt",
"QtQtQt.2.2#l.O.O.2.x.V#mQtQtQtQtQtQt",
"QtQtQt.W.x.2.2.2.x.V#nQtQtQtQtQtQtQt",
"QtQtQtQt.N.H.i.V.3.HQtQtQtQtQtQtQtQt"};

static const char* const image86_data[] = { 
"18 18 58 1",
"h c #152a00",
"t c #334b34",
"J c #354d31",
"P c #3a5228",
"C c #425e5b",
"u c #445d48",
"o c #446059",
"M c #475e34",
"A c #47604c",
"Z c #485f35",
"F c #485f47",
"B c #4b6765",
"s c #4e6133",
"l c #4f6960",
"O c #50612f",
"I c #526331",
"G c #526431",
"q c #5e7462",
"i c #61796d",
"a c #627b6c",
"j c #627d6d",
"e c #62806b",
"n c #647339",
"r c #647a58",
"k c #6a794d",
"m c #6d8462",
"x c #75844e",
"g c #768c87",
"w c #788c61",
"D c #7d6200",
"z c #7d9060",
"v c #839b85",
"K c #86965f",
"L c #937d1b",
"N c #957f1e",
"T c #96801e",
"# c #acb9bb",
"U c #ad8915",
"X c #ad8a17",
"c c #b1bdc0",
"p c #b4c383",
"b c #ba8200",
"Q c #c2b467",
"3 c #c68700",
"d c #c6d599",
"y c #c98a00",
"R c #dfce9b",
"2 c #fbfcfc",
"0 c #ffae00",
"H c #ffb100",
"S c #ffb200",
"Y c #ffb300",
"1 c #ffb400",
"W c #ffb500",
"V c #ffe49a",
"E c #ffe49e",
"f c #ffea99",
". c #ffffff",
"....#a.b..........",
"...cddefbb........",
"...ghidjfkll......",
"...mnhidooppll....",
"..bqrshtd.ohoibb..",
".bfffutvpwhxjdjfbb",
"yffffzABCthhddvjfD",
"byEfzddtthFGhvvhDD",
"bHyzddddIfffJhhKyD",
"bHHLMddzfffffJKIyD",
"bHHNMOPQRffffDIIyD",
"bHSTMIPUyyVfDyIIyD",
"byWTMIPXYYyDyyIID.",
"..DPZIPXY0YDyyIP..",
"....PPPX10YDyyP...",
"..2...PXW0YD3D....",
"....2...DyYDD.....",
"..........DD......"};

static const char* const image87_data[] = { 
"18 18 47 1",
"# c #323231",
"O c #48484b",
"M c #4e5050",
"c c #555555",
"I c #575757",
"h c #585858",
"x c #655705",
"f c #685a00",
"A c #736400",
"m c #776f44",
"z c #796800",
"y c #85730d",
"e c #868686",
"N c #8e8f90",
"G c #98999b",
"b c #a4a5a6",
"R c #a7a7a7",
"E c #a9aaac",
"L c #aaacac",
"C c #b8b9b9",
"g c #bcbbb9",
"H c #c2c2c2",
"w c #c6a90d",
"j c #c6b78e",
"F c #cbcdcf",
"n c #cccccc",
"Q c #cecfd1",
"l c #d0af3f",
"a c #d6d6d6",
"r c #e3c13d",
"B c #e4e4e4",
"P c #e7e9ea",
"K c #e9eaec",
"s c #ead27f",
"i c #ebebeb",
"d c #ececee",
"S c #f6f6f6",
"J c #f8f9fa",
"D c #f9fafd",
"v c #ffdf5f",
"u c #ffe06f",
"t c #ffeb84",
"o c #ffedb8",
"q c #fff38e",
"p c #fff39c",
"k c #fffbb3",
". c #ffffff",
"............#.....",
"............#a....",
"....bbbbbbbbca....",
"...bddddddddde....",
"...bd.fffffgbhi...",
"...bdfjkkklmbhn...",
"...bdfokpqrfbhn...",
"...bdfstuvwfbhn...",
"...bdfxyzAffbhn...",
"...bd.......bhn...",
"...bdBCDEFGFbhn...",
"...bdHIbIbIbbhn...",
"...bd.bJbKbKbhn...",
"...bdLIbMNONbhn...",
"...bd.bPbQbQbhn...",
"...bbbbbbbbbbhn...",
"....hhhhhhhhhRn...",
".....nnnnnnnnnS..."};

static const char* const image88_data[] = { 
"18 18 15 1",
"a c #000000",
"f c #1c324e",
"c c #313131",
"# c #345277",
"m c #491d05",
"b c #5e7b9f",
"e c #616161",
"g c #6a3f27",
"d c #878887",
"j c #8e563d",
"k c #cca08e",
"l c #cccccc",
"h c #e0e0e0",
"i c #fefefe",
". c #ffffff",
"..................",
"..................",
"#..............aaa",
"abbbbcdddddddebbbf",
".ghhhciiiiiiiehhh#",
".ghhhhccccccchhhhf",
".giffiiiiiiiiiiiif",
".gjhbhhhhhhhhhhbhf",
".gkjkjfffffffffffl",
".gjkjja#..#llllll.",
".gkjkm.a#.#l......",
".gjkjm####l.......",
"gjkjkmllll........",
"gkjkjml...........",
"gjkjkml...........",
".mmmml............",
"..lll.............",
".................."};

static const char* const image89_data[] = { 
"18 18 14 1",
"a c #6d2400",
"j c #8c5e31",
"# c #a0062c",
"e c #aa7f00",
"k c #aa7f55",
"c c #cccccc",
"l c #d49f55",
"f c #d4bfaa",
"d c #f21a4f",
"b c #ff6d55",
"i c #ffbf55",
"h c #ffdf55",
"g c #ffdfaa",
". c #ffffff",
".......#########a.",
".......#bbbbbbbbac",
".......#bdddddddac",
".......#bdddddddac",
".....ee#bdddddddac",
"...feegabdddddddac",
"..feghhaaaadddddac",
"feeggggggggaddddac",
"ggggggggggggadddac",
"ggggggggigjigaddac",
"gggggggiiigjiaddac",
"igiggggigjggajddac",
"iiiiggiiigjgadddac",
"eeiiiiigjigaaaaaac",
".ckeiiiigjiacccccc",
"...ckkkiiijlc.....",
".....cckkklcc.....",
"........cccc......"};

static const char* const image90_data[] = { 
"18 18 107 2",
".8 c #003399",
"#e c #28164a",
".9 c #2b0018",
"#x c #323a62",
"#d c #410339",
"#l c #485174",
".4 c #4b000c",
".7 c #4d0b33",
".m c #5c5c5b",
".x c #626463",
"#t c #626960",
".t c #656564",
"#C c #6d6d6e",
"#o c #70706f",
"#y c #70738e",
".j c #717171",
".n c #737373",
".f c #767676",
"#O c #7b7b78",
"#G c #7d817d",
"#B c #828281",
".c c #828282",
"#L c #858686",
".Z c #8e0521",
".u c #909090",
"#k c #9196b0",
"#j c #949a94",
"#i c #959795",
"#w c #9999ac",
".w c #9c9c9c",
"#s c #9e9e9e",
".W c #a3121b",
".e c #a4a4a4",
".S c #a5a5a5",
".3 c #a9acbb",
"#f c #aa8494",
".K c #aaafaf",
"#J c #adadad",
"#K c #aeadae",
".i c #aeaeae",
".J c #b0acac",
"#N c #b0b0b0",
".G c #b0b1af",
".s c #b2b2b3",
".0 c #b3000c",
".l c #bebebe",
"#n c #c3c4c3",
"#. c #c4505c",
"#c c #c6ccd5",
".Y c #c9011c",
".6 c #ca0216",
"#u c #cbcbca",
".# c #cccccc",
".y c #cccdcd",
"#F c #cdcecd",
"#I c #cdced8",
".V c #cfc4cb",
".T c #d4d4d4",
".R c #d4d6d7",
"#M c #d5d6d5",
".H c #d8d8d8",
"#A c #d9d9d9",
".B c #da3135",
"#p c #dadad9",
"#z c #dadae1",
"#h c #deddde",
".N c #df0000",
"#H c #dfdee6",
".F c #e1e1e2",
".5 c #e20315",
"#g c #e2e2e1",
"#a c #e2e2e2",
".C c #e72b30",
".M c #e7767c",
".1 c #e79193",
".I c #e7e8e8",
".A c #e98a8e",
"#m c #e9f1f3",
".P c #f02233",
".D c #f16065",
"#D c #f2f2ef",
".g c #f2f2f2",
"#q c #f4f4f1",
".k c #f4f4f4",
"#v c #f5f5f6",
".O c #f6000f",
".v c #f6f6f6",
".d c #f7f7f7",
".h c #f9f9f9",
".U c #fafafa",
".X c #fb0001",
".p c #fbedee",
"#b c #fbfbfa",
".a c #fbfbfb",
"#r c #fcfcfc",
".E c #fdd5d8",
".q c #fdeded",
"## c #fdeff0",
".o c #fdf8f9",
".b c #fdfdfd",
".z c #fef0f1",
".r c #fef3f4",
"#E c #fefefe",
".Q c #ffe3e7",
".2 c #fffcfc",
".L c #fffdfe",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
".#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#",
".#.a.a.b.a.a.a.a.a.a.a.a.a.b.a.a.a.c",
".#.a.d.e.f.g.a.a.a.a.a.a.h.i.j.k.a.c",
".#.b.l.e.m.n.a.o.p.q.r.a.s.t.m.u.a.c",
".#.v.w.m.x.y.z.A.B.C.D.E.F.G.t.j.H.c",
".#.b.I.J.K.L.M.N.O.O.O.P.Q.R.S.T.U.c",
".#.a.a.a.a.V.W.X.O.Y.Z.0.1.2.a.a.a.c",
".#.a.a.a.a.3.4.5.6.7.8.9#.##.a.a.a.c",
".#.a.a#a#b#c.8#d#e.8.8.8#f.a#g.a.a.c",
".#.b#h#i#j.a#k.8.8.8.8#l#m#n#o#p#q.c",
".##r#s.m#t#u#v#w.8#x#y#z#A#B#C.m#D.c",
".##E#F.e.m#G.a.a#H#I.a.a.l.m#t#J.a.c",
".#.a.b#K#L#M.a.a.a.a.a.a.g#N#O.a.a.c",
".#.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.c",
".#.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c.c",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image91_data[] = { 
"18 18 42 1",
"K c #1d232a",
"B c #1e3f7a",
"a c #1e596c",
"o c #205b6e",
"I c #215d6c",
"C c #27447b",
"G c #2d6779",
"e c #2f687a",
"E c #339900",
"i c #356e7f",
"D c #36970c",
"H c #37970f",
"w c #389615",
"J c #39598d",
"m c #407888",
"F c #40962e",
"p c #49808f",
"y c #539d59",
"u c #558b99",
"z c #6da0ac",
"s c #7099a5",
"# c #81b3bd",
"r c #828282",
"b c #83a9c9",
"x c #a2bcc4",
"g c #a8d6dc",
"A c #b1dee3",
"h c #bce5ef",
"l c #c4edf4",
"k c #c5eff6",
"M c #cccccc",
"t c #cef8fc",
"d c #d3fdff",
"L c #eaeef4",
"f c #f3f8ff",
"j c #f6faff",
"n c #fafcff",
"q c #fcfdff",
"N c #fdfefe",
"c c #fefefe",
"v c #fefeff",
". c #ffffff",
"......######......",
".......#..#.......",
"..aaaaaaa#........",
".bbbbbbbbbbb......",
"bcccccccccdaef....",
"bcdddddgggahiij#..",
"bcddddggggakilmn..",
"bcdgggggggogidipq.",
"brrrrrrrrrrsi#ituv",
"bcccccccccwxyxizAe",
"bBBBBBBBBCwDEEFxxG",
"bccsssscccwxxxEEHI",
"bsssssssssiiiiiii.",
"bcccccccccJiKiKL..",
"bMMMMMMMMMJiKi....",
"bJJJJJJJJJJiN.....",
"..rMMM..rMM.......",
".rMM...rMM........"};

static const char* const image92_data[] = { 
"18 18 23 1",
"m c #0063ff",
"q c #009cff",
"p c #3163ce",
"l c #319cff",
"o c #31ceff",
"s c #393939",
"e c #424242",
"t c #636363",
"h c #6363ce",
"k c #63ceff",
"i c #63ffff",
"# c #898792",
"g c #9c9cce",
"j c #9cffff",
"r c #adad94",
"n c #b5b5b5",
"a c #cccccc",
"d c #ceceff",
". c #e2e2e2",
"u c #e7e7d6",
"c c #fefefe",
"f c #ffffce",
"b c #ffffff",
".##############abb",
"#ccddddddddddddeab",
"#fcdghhhhhhhhhdeab",
"#dfdhijjjjkklmdeab",
"#dndhjjjjijoopdeab",
"#dndhjjjjijoopdeab",
"#dndhijjjiioopdeab",
"#dndhkjjiikkqpdeab",
"#dndhoooooolqmdeab",
"#endkpppppppppdeab",
"bgerddddddddddgeab",
"bbgeeeeeeeeeeeeeab",
"bsngggggggggggta.b",
"bs#nc#c#c#c#c#ct.a",
"be##ecececececeuea",
"bbe#neu#ueu#ueu#ea",
"bbbeeeeeeeeeeeeeea",
"bbbbaaaaaaaaaaaaa."};

static const char* const image93_data[] = { 
"18 18 48 1",
"v c #000000",
"B c #0d0d0d",
"u c #101010",
"G c #1b1b1b",
"x c #202020",
"t c #303030",
"N c #333333",
"C c #404040",
"H c #4d4d4d",
"M c #4f4f4f",
"y c #565656",
"O c #666666",
"I c #747474",
"s c #808080",
"b c #8c5e31",
"J c #8c8c8c",
"A c #b0b0b0",
"P c #bfbfbf",
"e c #c9ebf3",
"# c #cc9900",
"D c #cccccc",
"w c #cfcfcf",
"E c #d6d6d6",
"F c #d9d9d9",
"K c #dcdcdc",
"L c #dfdfdf",
"z c #e2e2e2",
"T c #e5e5e5",
"R c #e9e9e9",
"S c #efefef",
"r c #f88d00",
"Q c #f9f9f9",
"c c #fdb24f",
"n c #fdc374",
"m c #fdc67c",
"l c #fdc983",
"q c #fdcb87",
"k c #fdcc8b",
"j c #fed092",
"i c #fed39a",
"f c #fed6a2",
"h c #fedaa9",
"p c #fedbad",
"g c #feddb1",
"a c #fee9ce",
"d c #fefefe",
"o c #ffa732",
". c #ffffff",
"..................",
"....#############.",
"...#aaaaaaaaaaaaab",
"..#ccccccccccccccb",
"..bbbbbbbbbbbbbbbb",
".#ddbddbddbddbddbb",
".#debdebdebdebddbb",
".#dbbbbbbbbbbbbbbb",
"#bbffffffffffffffb",
"#gghfijklmnccccoob",
"#gpqqqqccccccrrrrb",
"#gqoooooorrrrrrrrb",
"#qostusrrrrrsvvsrb",
"#orvdwvrrrrrvdwusb",
"bbbvwsvbbbbbvwsxyb",
".zABvvCDEFFFGvvHHF",
"...EIJDK....LMNOP.",
"....QRS......QLFT."};

static const char* const image94_data[] = { 
"18 18 54 1",
"x c #000000",
"H c #0d0d0d",
"B c #100e05",
"j c #101010",
"O c #1a1a1a",
"Q c #2b2b2b",
"w c #302b10",
"a c #303030",
"I c #333333",
"z c #403915",
"b c #404040",
"h c #444444",
"M c #4d4d4d",
"D c #505050",
"# c #606060",
"K c #666666",
"p c #6d6d00",
"y c #706325",
"A c #707070",
"m c #7c7c7c",
"E c #7f7f7f",
"v c #80722a",
"e c #808080",
"C c #8f802f",
"L c #8f8f8f",
"Y c #999999",
"u c #9f8e35",
"d c #9f9f9f",
"X c #a0a0a0",
"r c #af9c3a",
"F c #afafaf",
"R c #b2b2b2",
"o c #bfaa3f",
"g c #bfbfbf",
"k c #c0c0c0",
"J c #cccccc",
"N c #cdcdcd",
"q c #cfb844",
"t c #cfcfcf",
"U c #d2d2d2",
"P c #d9d9d9",
"l c #db9200",
"V c #dcdcdc",
"S c #dfdfdf",
"G c #e5e5e5",
"W c #ececec",
"c c #efefef",
"Z c #f2f2f2",
"T c #f5f5f5",
"s c #f9f9f9",
"i c #fcfcfc",
"f c #fefefe",
"n c #ffe354",
". c #ffffff",
"........#abc......",
".......defghi.....",
"......cbdggjk.....",
".....dlllllllm....",
"....glnnnnnnopq...",
"....lnnppnppnopq..",
"...lrnpgpnpcpnops.",
"..tlnpgfpnpffpnpq.",
".tlnnppppnppppnopq",
".lnnnnnnnnnnnnnnop",
"tlnnuvonnnnnnnnnop",
"lnnwxxxvnnnnyxxzop",
"looxAcbBoooCxDAxvr",
"EppxFfAxpppzxffapp",
".GgHj#xIJJJKxLFxMJ",
"...NOxbgP..cQxxHRS",
"....TUJVi...WXYgts",
".............iZZi."};

static const char* const image95_data[] = { 
"18 18 60 1",
"R c #303030",
"Z c #333333",
"E c #383838",
"0 c #3d3d3d",
"H c #3e3e3e",
"N c #404040",
"G c #414141",
"B c #484848",
"W c #4d4d4d",
"d c #535353",
"Q c #5a5a5a",
"U c #606060",
"P c #646464",
"O c #656565",
"V c #717171",
"n c #737373",
"K c #7b7b7b",
"a c #7f7f7f",
"S c #808080",
"F c #828282",
"z c #838383",
"Y c #8b8b8b",
"b c #8c8c8c",
"q c #8e8e8e",
"k c #8f8f8f",
"C c #919191",
"M c #989898",
"J c #9f9f9f",
"g c #a4a4a4",
"# c #a6a6a6",
"L c #a7a7a7",
"w c #b3b3b3",
"r c #bababa",
"s c #bebebe",
"A c #bfbfbf",
"u c #c2c2c2",
"l c #c5c5c5",
"x c #c7c7c7",
"D c #c8c8c8",
"m c #cacaca",
"T c #cccccc",
"c c #cfcfcf",
"1 c #d2d2d2",
"h c #d5d5d5",
"4 c #d9d9d9",
"X c #dcdcdc",
"5 c #dfdfdf",
"v c #e0e0e0",
"3 c #ececec",
"e c #eeeeee",
"I c #efefef",
"t c #f1f1f1",
"2 c #f5f5f5",
"p c #f7f7f7",
"j c #f9f9f9",
"y c #fbfbfb",
"i c #fcfcfc",
"o c #fdfdfd",
"f c #fefefe",
". c #ffffff",
"..................",
"......####........",
"....aaabcbd#e.....",
"...aaccfgghbdi....",
"..aacffjgklmnd....",
".aafogpqcrsggnd...",
"aactuvhwg#ggngdd..",
"adqxnggggggcngnaa.",
"anynnzAggAggBCgDaa",
"ann#EnAAAgBBnnnnFG",
"HFBBnEEEAggBgnn#EE",
"IHJBBBnEBKn#LnMEEG",
".HNnKKBBEKOPnnQEGP",
"..RSSKBBBEKKBPEBGT",
"..UVPaaWWWWnBBBB#X",
"...YNZNWW0TTTTTT12",
"....3X4XT5Tf......",
".................."};

static const char* const image96_data[] = { 
"18 18 14 1",
"k c #8c5e31",
"b c #926d00",
"e c #aa7f00",
"i c #aa7f55",
"c c #cccccc",
"l c #d49f55",
"f c #d4bfaa",
"# c #db9200",
"a c #fefefe",
"j c #ffbf55",
"h c #ffdf55",
"g c #ffdfaa",
"d c #fff600",
". c #ffffff",
".......##########.",
".......#aaaaaaaabc",
".......#aaaaaaadbc",
".......#aaddddddbc",
".....ee#aaddddddbc",
"...feegefaddddddbc",
"..feghheeeedddddbc",
"feeggggggggiddddbc",
"ggggggggggggidddbc",
"ggggggggjgkjgiddbc",
"gggggggjjjgkjiddbc",
"jgjggggjgkjgklddbc",
"jjjjggjjjgkjieddbc",
"eejjjjjgkjgkbbbbbc",
".ciejjjjgkjicccccc",
"...ciiijjjklc.....",
".....cciiilcc.....",
"........cccc......"};

static const char* const image97_data[] = { 
"18 18 76 2",
".r c #5f525a",
".l c #790000",
".0 c #9c4908",
".E c #9c8c85",
".7 c #9d4a08",
".6 c #9e4b09",
".5 c #a04d0a",
".L c #a3500b",
".4 c #a5520d",
".3 c #ac5911",
".v c #b36014",
".2 c #b56216",
"#g c #b66316",
".Z c #b75e0b",
".Y c #b85f0c",
".P c #b9600d",
"#f c #b96617",
".X c #bb620e",
"#e c #bb6819",
".1 c #bc6919",
".W c #bd6410",
"#d c #bd6a1a",
".d c #be6b1a",
".K c #bf6612",
".c c #bf6c1b",
".V c #c06713",
".b c #c06d1b",
".a c #c06d1c",
".# c #c16e1c",
".U c #c46b16",
".D c #c76e19",
".O c #c7733e",
".T c #c86f1a",
".N c #ca7641",
".S c #cc731d",
".J c #cc7843",
"#c c #cccbcf",
".M c #ce7a45",
".I c #cf7b46",
".u c #d07721",
"#b c #d1d0d4",
".R c #d47b24",
"#a c #d4d3d7",
".C c #d5814c",
".k c #d67d26",
".H c #d6824d",
".Q c #d77e27",
"## c #d7d6da",
".j c #d87f27",
"#i c #d87f28",
".B c #d8844f",
".i c #d98028",
"#h c #d98029",
".G c #d98550",
"#. c #d9d8dc",
".h c #da8129",
"#j c #da812a",
".9 c #dad9dd",
".g c #db822a",
".A c #db8752",
".8 c #dbdade",
".f c #dc832b",
".F c #dc8853",
"Qt c #dcdbdf",
".e c #dd842c",
".z c #dd8954",
".t c #df8b56",
".y c #e08c57",
".s c #e18d58",
".x c #e28e59",
".w c #e38f5a",
".q c #e4905b",
".p c #e5915c",
".o c #e6925d",
".n c #e7935e",
".m c #e8945f",
"Qt.#.#.#.#.#.#.#.#.#.#.#.a.b.c.c.d.d",
"Qt.#.e.e.e.e.e.e.e.e.f.f.g.h.i.j.k.l",
"Qt.#.e.m.m.m.m.n.n.o.p.q.r.s.t.r.u.v",
"Qt.#.e.m.m.n.n.o.p.w.x.y.z.A.B.C.D.l",
"Qt.#.e.n.n.o.p.w.E.t.F.G.H.r.I.J.K.L",
"Qt.#.f.n.o.q.x.t.F.G.C.r.M.N.O.r.P.l",
"Qt.#.f.g.h.Q.R.u.S.T.U.V.W.X.Y.Z.Z.0",
"Qt.l.b.l.1.l.2.l.3.l.4.l.5.l.6.l.7.l",
"Qt.8.9#.###a#b#cQtQtQtQtQtQtQtQtQtQt",
".#.a.b.c#d#e#f#gQt.r.#.#.#.#.#.#.#.#",
".e.e.f.f.g#h#i.lQt.#.e.e.e.e.e.e.e.e",
".m.m.m.n.n.o#j#dQt.#.e.Z.m.m.m.m.m.m",
".m.m.m.m.m.n.f.lQt.#.e.Z.m.m.Z.m.m.m",
".m.m.m.m.m.n.Z.#Qt.#.e.m.m.m.m.m.m.m",
".m.m.m.Z.m.Z.e.lQt.#.e.m.Z.m.m.m.m.m",
".e.e.e.e.Z.e.Z.#Qt.#.e.e.e.e.e.e.e.e",
".#.#.#.r.#.r.#.lQt.r.#.#.#.#.#.#.#.#",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image98_data[] = { 
"18 18 73 2",
".g c #003fa8",
".# c #0084ff",
".d c #00baff",
".f c #00cbfe",
".b c #122e69",
".X c #161c1e",
".S c #221c1a",
".u c #23343a",
"#a c #282b2b",
".v c #31444c",
"#b c #3b4b50",
".h c #4f4d4d",
"#f c #505050",
".5 c #52727f",
".t c #5d8b94",
".R c #626466",
".i c #636464",
".T c #659ba9",
"## c #666767",
".e c #66ffff",
".A c #676464",
".D c #679aa2",
".Y c #679ba8",
".6 c #696969",
".I c #6c6c6c",
".3 c #6d7072",
".p c #6d7073",
".O c #6e999f",
".z c #6f7072",
".J c #707070",
".V c #7099a5",
".w c #719ea8",
".q c #737170",
".k c #737171",
".m c #737373",
".H c #777777",
".4 c #7aabb5",
".K c #848484",
".Q c #8bc2d1",
".y c #8cbdc7",
".o c #8cc0cf",
".E c #8d8d8d",
".N c #8e8e8e",
".7 c #8ec2d1",
".1 c #8f8f8f",
"#. c #8fc8dd",
".U c #949494",
"#d c #a2e4fd",
".G c #a4a4a4",
".F c #a8a8a8",
".n c #a9bbbb",
".l c #acacac",
".M c #b2b2b2",
".Z c #b2c1c5",
"#c c #b6f3f7",
"#g c #b7b7b7",
".L c #bcbcbc",
".B c #bcc2c2",
".2 c #bebebe",
".r c #c1b6b6",
".j c #cbcbcb",
".c c #cccccc",
".9 c #d0f7ff",
"#e c #e1e1e1",
".8 c #e6ffff",
".W c #e8ffff",
".0 c #edffff",
".x c #efffff",
".P c #f0ffff",
".s c #f5fcfc",
".C c #f9ffff",
".a c #fefefe",
"Qt c #ffffff",
"QtQtQtQtQt.#.#.#.#.#.#.#.#QtQtQtQtQt",
"QtQtQtQt.#.a.a.a.a.a.a.a.a.b.cQtQtQt",
"QtQtQt.d.a.e.a.a.e.e.f.e.f.e.b.cQtQt",
"QtQt.d.a.e.f.e.a.e.f.a.f.e.f.e.g.cQt",
"QtQt.e.d.e.e.e.e.e.e.f.a.f.e.g.#.cQt",
"QtQtQt.e.d.e.e.e.f.e.e.#.e.g.g.cQtQt",
"QtQtQt.#.e.d.d.#.#.#.#.#.g.e.b.cQtQt",
"QtQtQt.h.#.e.a.e.e.a.f.e.f.b.i.jQtQt",
"QtQt.k.l.m.#.e.a.e.f.e.f.b.n.o.pQtQt",
"Qt.q.r.s.t.u.#.#.#.#.b.b.v.w.x.y.z.c",
".A.B.C.D.E.F.G.H.I.J.K.L.M.N.O.P.Q.R",
".S.a.T.UQtQtQtQtQtQtQtQtQtQt.U.V.W.X",
".S.a.Y.UQtQtQtQtQtQtQtQtQtQt.U.V.W.X",
".A.Z.0.O.1.2QtQtQtQtQtQt.2.1.O.P.Q.R",
"Qt.3.y.x.4.5.6.6.6.6.6.6.5.4.x.y.z.c",
"QtQt.p.7.8.9#.#.#.#.#.#..9.8.7.p.cQt",
"QtQtQt###a#b#c#d#d#d#d#c#b#a##.jQtQt",
"QtQtQtQtQt#e#f#f#f#f#f#f#g.cQtQtQtQt"};

static const char* const image99_data[] = { 
"18 18 69 2",
".Q c #0d2922",
".L c #153d10",
".q c #184713",
".C c #1c3836",
".i c #1c5116",
".K c #1f2524",
".E c #244c1f",
".I c #254d49",
".X c #263c3b",
"#c c #2d2d2d",
".M c #2d5956",
".p c #2d8423",
".Z c #303030",
".2 c #333a33",
".W c #336461",
".j c #349828",
".V c #373737",
".w c #37a22b",
".N c #386f6c",
".U c #404040",
"#a c #424242",
".J c #448681",
".7 c #4a4a4a",
".z c #4c0d2e",
".Y c #4d4d4d",
"#. c #535353",
".v c #5a6059",
".A c #5c4e00",
"#b c #5d5d5d",
".B c #61590b",
".u c #615a33",
".P c #636a62",
".o c #666666",
".1 c #696969",
".8 c #6b6b6b",
".e c #6f072e",
".6 c #727272",
".t c #7a6801",
".O c #808080",
".4 c #818181",
".f c #897501",
"## c #8f8f8f",
".9 c #909090",
".R c #9f9f9f",
".D c #a6a6a6",
".T c #afafaf",
".3 c #b0b0b0",
".l c #b46aff",
".m c #be7dff",
".x c #bfbfbf",
".H c #cae397",
".G c #cc99ff",
".F c #cccccc",
".k c #cfcfcf",
".b c #d11547",
".5 c #d2d2d2",
".S c #d5d5d5",
".n c #d6b601",
".r c #dcdcdc",
".0 c #dfdfdf",
".s c #e1c3ff",
".y c #ececec",
".a c #f44371",
".h c #f4d001",
".# c #f69eca",
".c c #ff6990",
".d c #ffc1e0",
".g c #ffffcc",
"Qt c #ffffff",
"QtQtQtQtQt.#.a.aQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQt.#.b.c.d.eQtQt.fQtQtQtQtQtQt",
"QtQtQt.a.b.c.d.b.b.e.f.g.fQtQtQtQtQt",
"QtQtQt.a.c.d.b.c.b.e.g.h.fQtQt.i.iQt",
"QtQtQt.e.e.b.#.c.b.g.h.h.fQt.i.j.i.k",
"QtQt.l.l.m.e.b.b.f.h.h.n.oQt.i.p.q.r",
"Qt.l.s.m.s.s.e.e.t.u.n.u.f.v.w.q.x.y",
"Qt.l.sQt.s.m.l.z.w.A.B.C.D.E.w.q.FQt",
"Qt.z.m.s.G.l.l.z.H.I.J.H.K.L.w.q.rQt",
"QtQt.z.z.m.l.l.M.I.w.I.N.O.P.q.x.yQt",
"QtQtQtQt.z.z.z.J.H.I.Q.R.S.T.U.FQtQt",
"QtQtQt.i.i.i.i.V.W.X.kQtQt.S.Y.rQtQt",
"QtQt.i.w.w.w.w.i.Z.0.SQt.SQt.1.0QtQt",
"QtQtQt.i.i.i.i.2.3.S.S.SQt.S.4.5QtQt",
"QtQtQtQtQtQtQt.6.7.R.3.S.SQt.8.FQtQt",
"QtQtQtQtQtQtQtQtQt.9#.##.3.S#a.FQtQt",
"QtQtQtQtQtQtQtQtQtQtQt.3#b#c.x.SQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image100_data[] = { 
"18 18 68 2",
".S c #48484b",
".Q c #4e5050",
".G c #575757",
".O c #585858",
".9 c #808080",
".R c #8e8f90",
".k c #929292",
".d c #996600",
".t c #9f8a33",
".I c #9f9f9f",
".H c #a4a5a6",
".Y c #a9a9a9",
".z c #af9735",
".j c #afa475",
".T c #b2b2b2",
".7 c #b3b3b3",
".Z c #b8b8b8",
".W c #bababa",
".X c #bcbcbc",
".6 c #bebebe",
".D c #bf9f1d",
".r c #bfa126",
".J c #bfbfbf",
".N c #c3c3c3",
".x c #c6c6c6",
".5 c #c8c8c8",
".a c #cc9900",
".8 c #cccccc",
".V c #cecfd1",
".l c #cfb449",
".f c #cfb757",
"#a c #cfcfcf",
".0 c #d2d2d2",
".4 c #d3d3d3",
"#b c #d6d6d6",
"#. c #d7d7d7",
"## c #d9d9d9",
".3 c #dedede",
".h c #dfc14b",
".# c #dfdfdf",
".P c #e2e2e2",
".s c #e4e4e4",
".E c #e5e5e5",
".U c #e7e9ea",
".2 c #e8e8e8",
".K c #e9e9e9",
".M c #e9eaec",
".e c #efdd94",
".F c #efefef",
".1 c #f3f3f3",
".y c #f4f4f4",
".L c #f8f9fa",
".C c #f9f9f9",
".o c #fcfcfc",
".b c #fefefe",
".q c #ffd52d",
".w c #ffd633",
".B c #ffd738",
".v c #ffd83e",
".A c #ffd943",
".n c #ffda44",
".u c #ffdb49",
".m c #ffdc4f",
".g c #ffdf60",
".c c #fff0b4",
".i c #fff2bf",
".p c #fff3c4",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQt.#.a.a.a.a.a.#QtQtQtQtQtQt",
"QtQtQt.a.a.a.b.c.c.c.c.d.d.#QtQtQtQt",
"Qt.#.a.b.c.c.e.d.d.d.f.g.h.d.d.#QtQt",
"Qt.a.b.i.c.j.d.k.k.k.d.l.m.n.h.d.oQt",
".#.a.p.q.r.d.k.s.s.s.d.t.u.v.w.d.xQt",
".a.q.q.q.r.d.#.b.b.y.d.z.A.B.q.r.d.C",
".a.r.r.r.r.d.s.s.s.s.s.d.r.r.D.r.d.E",
".F.d.d.d.d.k.G.H.G.H.G.I.d.d.d.d.J.K",
"Qt.o.E.j.k.b.H.L.H.M.H.N.O.O.P.E.K.o",
"QtQtQt.j.#.b.G.H.Q.R.S.T.k.O.FQtQtQt",
"QtQtQt.j.b.b.H.U.H.V.H.W.X.O.PQtQtQt",
"QtQtQt.j.b.b.G.H.G.H.G.Y.Z.O.0QtQtQt",
"QtQtQt.j.b.b.1.2.3.4.5.6.7.O.8QtQtQt",
"QtQtQt.9.O.O.O.O.O.O.O.O.O.9.8QtQtQt",
"QtQtQtQt#.###a###############bQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image101_data[] = { 
"18 18 65 2",
".H c #202020",
".V c #323210",
".F c #3d3d10",
".M c #404040",
".Z c #463f03",
".Y c #46460e",
".O c #4e4e00",
".x c #505050",
".U c #515130",
".2 c #535101",
".R c #535310",
".S c #5a5a00",
".l c #606060",
".A c #695b11",
".1 c #6c5e13",
".k c #7a7a7a",
".G c #7e6a16",
".I c #808080",
".s c #868600",
".D c #8f8f8f",
".j c #996600",
".T c #9d9d00",
".W c #a6a6a6",
".J c #a8a800",
".3 c #af950c",
".P c #afafaf",
".K c #b2b2b2",
".N c #b3b300",
".0 c #bfa30d",
".B c #bfbfbf",
".7 c #c2c2c2",
".# c #cc9900",
".m c #ccac24",
".y c #cccccc",
".i c #cfcfce",
".C c #cfcfcf",
".8 c #d6d6d6",
"#. c #d7d7d7",
".Q c #d9d9d9",
".L c #dcdcdc",
".6 c #dfbe0f",
".u c #dfdfdf",
".X c #e2e2e2",
".q c #ecc836",
".e c #edd688",
".5 c #efcb10",
".E c #efefef",
".v c #fbd42c",
".t c #fbd639",
".w c #fbd63b",
".p c #fcdc66",
".9 c #fcfcfc",
".r c #fddd6c",
".o c #fde491",
".f c #fde698",
".d c #feedb7",
".g c #feefc1",
".c c #fef6df",
".z c #fefefe",
".4 c #ffd911",
".n c #fff6df",
".h c #fff9eb",
".b c #fffefb",
".a c #fffffd",
"Qt c #ffffff",
"QtQt.#.#.#.#.#QtQtQt.#.#.#.#.#QtQtQt",
"Qt.#.a.a.a.a.a.#Qt.#.b.b.c.d.e.#QtQt",
".#.f.g.g.h.a.i.j.k.l.m.n.d.o.p.q.jQt",
".#.g.r.f.m.s.s.s.s.s.j.m.o.p.t.m.j.u",
".#.v.w.m.s.u.u.u.u.u.x.j.m.t.m.m.j.y",
".#.v.m.s.u.z.z.z.z.z.z.l.j.m.m.m.j.y",
".#.m.A.u.B.C.z.z.z.l.D.E.F.j.m.m.j.y",
"Qt.G.s.u.C.H.u.z.D.l.z.u.I.J.j.j.K.L",
"QtQt.s.u.z.C.M.D.M.z.z.u.I.N.O.C.CQt",
"QtQt.s.u.z.z.P.x.E.z.u.u.I.N.O.QQtQt",
"QtQt.s.u.z.z.z.z.z.z.u.u.I.N.O.QQtQt",
"QtQt.s.R.u.z.z.z.u.u.u.B.S.J.O.QQtQt",
"QtQt.s.T.U.u.u.u.u.u.C.V.s.O.W.XQtQt",
"QtQtQt.Y.J.R.I.I.I.I.O.Z.0.1.WQtQtQt",
"QtQtQt.j.2.J.N.N.N.N.s.3.4.5.jQtQtQt",
"QtQt.j.6.#.O.O.O.O.O.O.j.#.4.#.jQtQt",
"QtQt.j.#.j.K.y.y.y.y.y.7.j.j.#.jQtQt",
"QtQtQt.j.y.8QtQtQtQtQtQt.9#..j.yQtQt"};

static const char* const image102_data[] = { 
"18 18 100 2",
".u c #37a22b",
".j c #4e3e46",
".x c #6f4d8a",
".a c #7f7f7f",
"#u c #89653b",
".y c #8b5d2b",
"#v c #8d6433",
".G c #a19084",
"#s c #a48652",
"#t c #a96d38",
"#D c #a9946d",
".w c #ab7946",
"#G c #ab8b5e",
"#n c #af7745",
".k c #b6b6b8",
"#w c #c0a05b",
".F c #c2bdaf",
"#B c #c6b89f",
"#H c #c9a07f",
".H c #c9bb95",
".o c #cb9345",
".N c #cbb88b",
".K c #cea16e",
".f c #d0c4d8",
".n c #d1a779",
".b c #d1c6d9",
".V c #d6ce9b",
"#F c #d7a553",
".t c #d7d2c0",
".D c #d8a44c",
".c c #ddd4e3",
".# c #ded6e4",
".C c #dfa755",
".7 c #e0ab4b",
"#A c #e0b55d",
"#q c #e0bc6c",
"#h c #e1ad5e",
"#y c #e1bd6c",
"#i c #e4b55c",
"#m c #e4c06e",
".p c #e4c9ea",
".Y c #e5b867",
".O c #e5d554",
".g c #e5e1f0",
"#f c #e6b84f",
"#E c #e6ba5e",
"#g c #e6c370",
"#z c #e7b95d",
".Z c #e8b861",
"#l c #e8bf54",
"#r c #e8c26c",
".R c #e9b85d",
"#k c #e9bf4d",
"#j c #e9c252",
".d c #e9d8ea",
".l c #ead9ec",
".P c #ebbb54",
".0 c #ebc752",
".8 c #ecc954",
".I c #eddda8",
".X c #eec551",
".L c #eec771",
"#x c #eecc73",
".M c #efcc53",
"#e c #efd156",
".s c #efd782",
"#o c #f0d47c",
".W c #f0e474",
".9 c #f4d862",
".J c #f4db84",
"#p c #f4e094",
".i c #f4f4f9",
".S c #f5dd67",
"#C c #f5f2ef",
".h c #f69eca",
".e c #f6e9f6",
".E c #f8dd5d",
".v c #f8e076",
".U c #f8eebb",
".T c #f9f3c3",
".B c #f9f3ee",
".2 c #f9f4c1",
".3 c #faf8c6",
".z c #fafade",
".4 c #fbf6bd",
"#c c #fbf7ad",
"#b c #fbf7ae",
"#a c #fcf8b1",
".Q c #fcfbcb",
"#d c #fde97a",
".6 c #fdea70",
"## c #fef6a0",
".q c #fefefe",
".m c #ff6990",
"#. c #ffed76",
".5 c #ffef86",
".1 c #fff386",
".A c #fffcc0",
".r c #fffffe",
"Qt c #ffffff",
"QtQtQtQt.#.a.a.bQtQtQtQtQtQtQtQtQtQt",
"QtQtQt.c.a.d.e.a.fQtQtQtQtQtQtQtQtQt",
"QtQtQt.a.d.d.g.h.aQtQtQtQtQtQtQtQtQt",
"QtQtQt.a.d.i.h.h.jQtQtQtQtQtQtQtQtQt",
"QtQtQt.k.a.l.h.m.j.n.o.oQtQtQtQtQtQt",
"QtQtQt.o.a.p.h.m.j.q.q.q.n.n.o.rQtQt",
"QtQt.o.s.s.a.h.m.j.q.t.u.q.q.q.oQtQt",
"Qt.o.v.s.w.x.j.m.j.y.q.t.q.z.A.q.o.B",
".C.D.E.w.F.G.j.j.j.G.y.t.H.H.I.q.o.J",
".K.L.M.w.F.G.G.j.G.G.y.N.m.m.O.P.C.o",
".K.Q.R.S.w.F.F.F.F.y.T.U.V.W.X.Y.C.o",
".o.Q.Z.0.1.y.y.y.y.2.3.4.5.6.7.C.J.o",
".o.Q.J.R.8.9#.###a#b#c#d#e#f.C.J#g.o",
".o.Q.Q.J#h#i#j#i#k#i#k#l.C.C.J.Q#m#n",
"#n.Q.Q.Q#o.C.C.C.C.C.C.C.J.Q.Q#p#q.o",
"#n.J#r#s#t#u#v#u#u#u#u#u#u#t#w#x#y#n",
"#n#z#A#t#BQtQtQtQtQtQtQt#C#D#t#E#F#t",
"#G#u#tQtQtQtQtQtQtQtQtQtQtQtQt#t#u#H"};

static const char* const image103_data[] = { 
"18 18 14 1",
"b c #3887b0",
"c c #6e6e6e",
"g c #87c6e2",
"i c #8ac8e3",
"e c #91cee7",
"d c #97cdeb",
"k c #9dc9ed",
"f c #b4def1",
"j c #c7c7c7",
"# c #df7508",
"l c #e3ecf6",
"h c #ededed",
"a c #ffee8b",
". c #ffffff",
"..................",
".###..............",
".#a#..............",
"#aa#..........bbb.",
"#aaab..cc...bbdefb",
"#abggbchhcccbiefeb",
"bddedgc...jjcbfeeb",
"bkkbeech.jh..cbeb.",
".bbbbdechchh..cb..",
"....bdegcchhhhcb..",
".....bbgggccccggeb",
"..bbbddbbggggddeeb",
".bidkdeeebbedeeelb",
"biddeeeffllblllllb",
"bffffffllbbbblllb.",
".blllllbb....bbb..",
"..bbbbb...........",
".................."};

static const char* const image104_data[] = { 
"18 18 14 1",
"# c #a74a5c",
"d c #b45f70",
"c c #d98192",
"l c #f8c9d1",
"e c #fab6c0",
"g c #fbbebb",
"a c #fca2b0",
"b c #fdd7dd",
"j c #fea69d",
"f c #ff4238",
"i c #ff5b52",
"h c #ff655d",
"k c #ff887a",
". c #ffffff",
"........##........",
".......#..#.......",
"......#abaa#......",
"......#caac#......",
".......#cc#.......",
".....##dddd##.....",
"....#bdcdebde#....",
"...#bde.edbbde#...",
"..#fghiggfjhfkh#..",
".#fgfgggfgfjjkkf#.",
".#ghggggghjjkkkk#.",
"#bbabbbbbbbbbbaee#",
"#edddddddddddddde#",
"#d.alaallalaala.d#",
"#lalaaaaaaaaaalal#",
"##aa##########aa##",
".###..........###.",
".................."};

static const char* const image105_data[] = { 
"18 18 150 2",
"ah c #280f0c",
"ai c #2a0d09",
"#8 c #5f281c",
"ao c #672314",
"at c #682415",
"#M c #692a1d",
"#X c #692b1d",
"#A c #6a2c1e",
".a c #6e4a29",
"aa c #722515",
"aj c #722615",
"#0 c #732716",
"#P c #752818",
"ag c #772b19",
"## c #773a2a",
"a# c #7c2f19",
".V c #7d3f2f",
"#7 c #7e311e",
"#E c #7e311f",
"#G c #833723",
"#q c #833724",
".W c #834434",
"#r c #863a26",
"#W c #873a25",
".I c #8b4d3b",
"#e c #8b4e3b",
"#s c #8c3f2b",
"#L c #8e422b",
".y c #905741",
".o c #905d41",
".f c #906541",
".b c #946e44",
"#z c #964b31",
".# c #967144",
".2 c #995538",
".O c #995d38",
".D c #996438",
".9 c #9b6435",
".U c #9b6b35",
".H c #9b6e35",
".x c #9d6e38",
".u c #9d6f3b",
".n c #9f713a",
".m c #a0733b",
"#x c #a7705e",
"#i c #a7755e",
"#k c #a7775e",
".4 c #a77d5e",
".6 c #a77e5e",
".8 c #a7815e",
".Q c #a7825e",
".S c #a7835e",
".F c #a7845e",
"#Z c #ae2d24",
"#9 c #b05b1f",
"a. c #b05c1f",
"#d c #bd5a24",
".0 c #bd5c24",
".1 c #bd5f24",
".N c #bd6624",
".C c #bd7124",
".s c #bd7e24",
".t c #bd8324",
".k c #bd8724",
".l c #bd8824",
"#Y c #c1341f",
"as c #c14812",
"ar c #c15610",
"ap c #c1590f",
"aq c #c15a0f",
"ak c #d4260c",
"an c #d4270d",
"am c #d5240c",
"#O c #d53f2c",
"#C c #d5422c",
"#D c #d63d2f",
"#c c #d75533",
"#p c #d75933",
"#o c #d76231",
".Z c #d76435",
"#a c #d76c35",
".M c #d77535",
".B c #d78437",
".r c #d79537",
".j c #d7a137",
".e c #d7a337",
"al c #e43717",
"#N c #e9632e",
"#B c #e9722f",
"#m c #e97f2f",
"#n c #e97f30",
"#. c #ea8634",
"#b c #eb8340",
".Y c #ec9646",
".K c #eca24b",
".L c #eca44b",
".X c #ecab4e",
".A c #edb44f",
".J c #edb557",
".q c #edc54f",
".h c #edd14f",
".i c #edd24f",
".c c #edd44f",
".d c #edd54f",
".z c #eec35c",
".p c #eed15c",
".g c #eedd5c",
"af c #ff3923",
"#6 c #ff3d28",
"#5 c #ff4127",
"ae c #ff4820",
"#4 c #ff4a24",
"#3 c #ff5522",
"ad c #ff561e",
"#V c #ff592c",
"ac c #ff5a1b",
"ab c #ff5b19",
"#U c #ff5d2a",
"#2 c #ff621c",
"#T c #ff6228",
"#1 c #ff6d1a",
"#K c #ff7a2f",
"#Q c #ff7d1a",
"#J c #ff7d2c",
"#I c #ff802d",
"#F c #ff851f",
"#v c #ff852d",
"#S c #ff862e",
"#R c #ff9428",
"#u c #ff9633",
"#H c #ff9f33",
"#g c #ffa639",
"#w c #ffa739",
"#y c #ffaa38",
"#t c #ffaf3c",
"#h c #ffba3d",
"#f c #ffbc46",
"#l c #ffc73a",
".3 c #ffcd4b",
"#j c #ffdac8",
".T c #ffde3a",
".P c #ffe04b",
".5 c #ffe0c8",
".v c #ffe13d",
".7 c #ffe1c8",
".G c #ffe23c",
".E c #ffe23d",
".R c #ffe4c8",
".w c #ffec4b",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQt.#.#.#.aQtQtQtQtQtQtQtQt",
"QtQtQtQtQt.b.c.d.d.e.aQtQtQtQtQtQtQt",
"QtQtQtQt.f.g.h.i.j.k.l.m.m.m.nQtQtQt",
"QtQtQtQt.o.p.q.r.s.t.u.v.w.w.w.xQtQt",
"QtQtQtQt.y.z.A.B.C.D.w.w.E.F.G.w.HQt",
"QtQtQt.I.J.K.L.M.N.O.P.w.Q.R.S.T.UQt",
".V.VQt.W.X.Y.Z.0.1.2.3.4.5.6.7.8.9Qt",
".V#.#####a#b#c#d#e#f#g#h#i#j#k#l.9Qt",
".V#m#n#o#p#q#r#d#s#t#u#v#w#x#y#zQtQt",
"Qt#A#B#C#D#E#F#G#G#H#I#I#I#J#K#LQtQt",
"QtQt#M#N#O#P#Q#Q#R#S#T#T#T#U#V#WQtQt",
"QtQtQt#X#Y#Z#0#1#2#3#4#4#5#6#7QtQtQt",
"QtQtQt#8#9a.a#aaabacadadaeafagQtQtQt",
"QtQtQtQt#8#8ahaiajakalalaman#0QtQtQt",
"QtQtQtQtQtQtQtQtaoapaqaqarasatQtQtQt",
"QtQtQtQtQtQtQtQtQtaoaoaoaoaoQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image106_data[] = { 
"18 18 42 1",
"n c #37d0ff",
"C c #635b57",
". c #645c58",
"j c #6bffff",
"# c #736a66",
"q c #827b76",
"B c #837c77",
"p c #877e79",
"l c #918a85",
"F c #98908a",
"b c #99918b",
"o c #9a928c",
"u c #9c948e",
"a c #9e958f",
"g c #9f9792",
"k c #a5ffff",
"d c #c3bdb9",
"f c #c4c0bb",
"D c #c4c1bc",
"H c #c7c2bd",
"x c #c9c3be",
"s c #c9c4bf",
"I c #cbc7c3",
"J c #ccc8c5",
"t c #d1ceca",
"z c #d2cecb",
"w c #d4d0ce",
"m c #d7d4d2",
"r c #e0ddda",
"A c #e0deda",
"h c #e0dedc",
"i c #e4e2de",
"G c #eae9e7",
"E c #eaeae7",
"v c #efecec",
"e c #efefed",
"y c #f2f0ef",
"N c #fdf865",
"L c #ff2900",
"M c #ff6000",
"K c #ffb100",
"c c #ffffff",
"..#aabcccccccccccc",
".def#bbccccccccccc",
"ghi#jkbbcccccccccc",
"lhm#njkboppppppppp",
"qrst#njkbuvtwwwwwp",
"qrsxt#njjbuvmmmmpc",
"cqrsst##byzavAApcc",
"ccBrsxthheyzpvpccc",
"cccCrDfthEeyf##ccc",
"cccFCrDfthGf#v#ccc",
"cccFyCrfHtf#ry#ccc",
"cccFyACrHfCrr#.ccc",
"cccFyAwCrCIm#..ccc",
"cccFyAwwCvJC...Kcc",
"cccFyAwFppp...LMKc",
"cccFyAFccccccKMMKN",
"cccFyFccccccccKKKN",
"cccFFccccccccccNNN"};

static const char* const image107_data[] = { 
"18 18 84 2",
".w c #009600",
".D c #049e00",
"#. c #12a300",
".r c #130900",
".k c #137f7e",
".0 c #13a300",
".O c #16a300",
".n c #188d89",
".v c #18a400",
".t c #20a700",
"## c #238c00",
".f c #24a6a4",
"#b c #258102",
"#c c #2a8a02",
"#d c #2a8d02",
"#g c #2f8909",
"#a c #339507",
".5 c #3ca609",
".6 c #3da809",
".7 c #3faa09",
".8 c #41af0c",
".9 c #46b40f",
".V c #4ebc14",
".U c #50bd15",
".W c #51be15",
".X c #52c115",
".4 c #54b415",
".Z c #54bb15",
".Y c #55c215",
".T c #55c217",
".1 c #57b815",
".J c #5bc01b",
".L c #5bc81b",
".3 c #5db41d",
".K c #5dc81b",
".2 c #5eba1b",
".A c #61cd20",
".B c #64cd20",
".S c #66c421",
".M c #69cc23",
".C c #6bcf24",
".z c #6ed028",
".y c #75d32d",
".x c #78d428",
".P c #7dce31",
".N c #7dd038",
".I c #7fd636",
".E c #80d435",
".Q c #82d337",
".F c #82d636",
".R c #83d43b",
".b c #849d97",
".H c #86d83b",
".c c #a1b4b1",
".s c #a5ecff",
".p c #a7ecff",
".o c #a9ecff",
".l c #acecff",
".j c #baf0ff",
".e c #bff2ff",
".a c #c02500",
".i c #c9f2ff",
".h c #d7f7ff",
".u c #e0f9ff",
".g c #e1f9ff",
".# c #e32e00",
".q c #e8fbff",
".m c #eafbff",
".d c #f5fdff",
"#f c #ff6000",
"#o c #ffa300",
"#r c #ffa600",
"#p c #ffad00",
"#q c #ffb400",
"#n c #ffbc00",
"#m c #ffc100",
"#j c #ffc300",
"#i c #ffc800",
"#k c #ffdb00",
"#h c #ffdd00",
"#l c #ffde00",
".G c #ffe100",
"#e c #ffe500",
"Qt c #ffffff",
"QtQtQtQtQtQtQt.#.a.aQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQt.bQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQt.bQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQt.c.b.b.bQtQtQtQtQtQtQt",
"QtQtQtQtQt.c.c.d.d.d.e.b.bQtQtQtQtQt",
"QtQtQtQt.c.d.f.g.h.i.j.k.l.bQtQtQtQt",
"QtQtQtQt.c.d.m.f.f.n.k.o.p.bQtQtQtQt",
"QtQtQt.c.d.d.q.r.f.r.k.p.s.s.bQtQtQt",
"QtQtQt.c.d.f.f.f.f.f.k.k.k.s.bQtQtQt",
"QtQt.t.t.t.d.u.f.n.k.k.p.s.t.t.tQtQt",
".v.w.x.y.z.t.t.t.t.t.t.t.t.A.B.C.w.v",
".D.E.F.G.H.I.J.J.J.J.J.J.K.L.G.M.N.D",
"Qt.O.P.Q.R.G.S.T.U.V.W.X.G.Y.X.Z.OQt",
"QtQt.0.1.2.3.4.G.5.6.G.7.8.9.1.0QtQt",
"QtQtQt#.###a#a#b#c#d#c#a#a###.QtQtQt",
"QtQtQt#e#f#f#g#g#b#b#g#g#f#f#hQtQtQt",
"QtQtQtQt#i#j#f#kQtQt#l#f#m#nQtQtQtQt",
"QtQtQtQtQt#o#pQtQtQtQt#q#rQtQtQtQtQt"};

static const char* const image108_data[] = { 
"18 18 135 2",
"#e c #6b6a00",
"#I c #790700",
"#N c #797800",
".A c #79af00",
"#Z c #878900",
".Y c #900900",
".# c #908467",
"#q c #909700",
".l c #986900",
"#D c #988c6d",
"#P c #9f9479",
"#J c #a91700",
".Z c #b43b0c",
".m c #b68f00",
"#Y c #b7d800",
"#r c #bac200",
"#8 c #c0d000",
"#7 c #c0de00",
"#p c #c0e300",
"#O c #c2d000",
".J c #c2dd00",
"#C c #c7d600",
"#d c #c9e100",
"#M c #cad400",
"#f c #cad700",
".T c #cade00",
".6 c #cbd900",
"#B c #cbe300",
"#s c #cd0900",
"#6 c #cd6800",
"ac c #d00000",
"#X c #d02400",
".U c #d0de00",
".5 c #d0e200",
"ad c #d40f00",
"#H c #d41b00",
"#0 c #d4c600",
"ae c #d53629",
"#L c #d60000",
"#A c #d68e00",
"#9 c #d91100",
"#5 c #da0100",
".S c #da1600",
"#o c #da4b00",
".4 c #dc0000",
"#c c #dc0c00",
"a. c #dc1a00",
"#w c #dc3007",
"#z c #e00500",
"a# c #e01600",
"ab c #e01700",
"aa c #e01a00",
".t c #e01b00",
"#W c #e11c00",
"#4 c #e31100",
"#V c #e31a00",
".s c #e42000",
".R c #e51a00",
"#n c #e80700",
"#y c #e81700",
"#3 c #e81a00",
"#K c #e81b00",
".B c #e83407",
".a c #e88d00",
".I c #e8bc00",
"#U c #e91700",
".G c #e93f0f",
"#x c #ea1600",
"#2 c #ea2500",
"#m c #ea2900",
"#T c #ea2f02",
".u c #ea5800",
".b c #ea9f00",
".H c #eab800",
"#b c #ef1300",
"#G c #ef2e02",
".3 c #ef2f02",
"#l c #ef3400",
"#1 c #ef3709",
".2 c #ef3907",
"#a c #ef3c02",
"#R c #ef470c",
"#v c #ef4809",
"#S c #ef4a0c",
".q c #efad00",
".p c #efcc00",
".Q c #f13709",
"#k c #f14009",
"## c #f14509",
"#u c #f14c0c",
"#F c #f15414",
"#E c #f15915",
"#g c #f17a31",
".1 c #f24b11",
"#Q c #f25015",
".z c #f2cf00",
"#j c #f35214",
"#h c #f3762b",
".N c #f37731",
".P c #f55b15",
"#. c #f55f17",
"#i c #f55f1d",
".O c #f56a21",
".V c #f57529",
".F c #f5762d",
".9 c #f57e31",
".y c #f5ce00",
".o c #f5d000",
".0 c #f6691d",
"#t c #f67121",
".C c #f88a40",
".g c #f8cc00",
".w c #f8d500",
".8 c #f98e40",
".7 c #f99246",
".K c #f99a4f",
".W c #f99d53",
".E c #fa9346",
".D c #fa974c",
".M c #fa9a4f",
".L c #fa9d53",
".X c #fd9e4e",
".n c #fdce00",
".x c #fddb00",
".r c #febd7a",
".d c #ffc017",
".v c #ffc300",
".i c #ffc331",
".e c #ffc714",
".h c #ffce09",
".c c #ffce0f",
".k c #ffce14",
".f c #ffcf00",
".j c #ffcf17",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQt.#.#QtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"Qt.#QtQt.a.a.a.a.a.a.a.bQtQtQtQtQtQt",
"QtQtQt.a.c.c.d.e.f.g.g.b.a.aQtQtQtQt",
"QtQt.a.h.i.h.j.k.l.m.n.o.p.p.a.qQtQt",
"Qt.r.s.t.t.t.u.j.v.w.x.y.z.p.A.AQtQt",
"Qt.B.C.r.D.E.F.G.t.t.t.H.I.A.J.AQtQt",
"Qt.B.K.L.M.N.N.O.P.Q.R.S.A.T.U.AQtQt",
".V.B.W.X.X.Y.Z.0.1.2.3.4.5.5.6.AQtQt",
".B.V.7.8.9.Z.Z#.###a#b#c#d#e#f.AQtQt",
".B.V#g#h#h#i#j#k#l#m#n#o#p#q#r.AQt.#",
"#s#t#h.Y.Z#u#v#w#x#y#z#A#B#C.AQtQt#D",
"#s#E#F.Z.Z#G#H#I#J#K#L#M#N#O.AQt#PQt",
"#s#Q#R#S#T#U#V#J#J#W#X#Y#Z.A#0QtQtQt",
"Qt#s#s#1#2#3#4.R.t#5#6#7#8.AQtQtQt#D",
"QtQt.B#s#9a.a#aaabac#0.A.AQtQt#D#DQt",
"QtQtQtQt.B.B#s#sadae.A#0QtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image109_data[] = { 
"18 18 81 2",
".b c #6f970a",
"#h c #70500e",
".Y c #87ab2a",
".Z c #8bad2c",
".4 c #8cae2c",
".0 c #8eaf2d",
".3 c #8eb02d",
".1 c #8eb12e",
".2 c #90b12e",
"## c #a2cc32",
"#c c #a3cd33",
"#a c #a4ce33",
"#b c #a4ce34",
".9 c #ab0702",
".E c #ad0c07",
".T c #ae120c",
"#f c #b01611",
".I c #b0d43b",
"#n c #b28928",
".J c #b4d93d",
".F c #b51d18",
".O c #b5d940",
".K c #b6d941",
".L c #b6da42",
".N c #b7da42",
".W c #b82b25",
".M c #b8da42",
".X c #ba2b26",
".v c #bcdc46",
"#l c #bd922e",
".r c #bf2d28",
".w c #bfdd48",
".x c #c0e049",
".y c #c1e049",
".z c #c2df49",
".m c #c7e251",
".j c #c93a34",
".n c #c9e351",
".o c #c9e452",
".p c #cae453",
".g c #cee658",
".k c #d0332b",
".a c #d31a11",
".e c #d43127",
"#k c #d7ae4e",
"#o c #dfb75a",
"#g c #e0cc9b",
"#. c #ef4a3d",
"#j c #f0cc78",
"#i c #f0ddb0",
"#m c #f0deb3",
".U c #f14536",
".f c #f5967c",
".V c #fb4340",
".# c #fb6b61",
".l c #fb6f65",
".H c #fd4c4a",
".h c #fddb8d",
".s c #fe4545",
".G c #fe4646",
".t c #fe5353",
".8 c #feac57",
".u c #ff5858",
".c c #ff6716",
".S c #ff6b1b",
".6 c #ff772a",
".D c #ff7c21",
".5 c #ff7d2d",
".R c #ff7d2e",
".d c #ffa13d",
"#d c #ffa150",
"#e c #ffa850",
".7 c #ffa95e",
".i c #ffae4e",
".Q c #ffb56d",
".P c #ffba71",
".C c #ffbc76",
".B c #ffc684",
".A c #ffc888",
".q c #ffd18b",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQt.#.a.b.b.c.dQtQtQtQtQtQt",
"QtQtQtQt.#.e.#.f.g.g.h.i.c.dQtQtQtQt",
"QtQtQt.j.k.#.l.m.n.o.p.q.q.d.cQtQtQt",
"QtQt.r.s.t.u.v.w.x.y.y.z.A.B.C.DQtQt",
"Qt.E.F.G.H.I.J.K.L.M.M.N.O.P.Q.R.SQt",
".T.U.V.W.X.Y.Z.0.1.2.2.3.4.5.6.7.8.c",
".9#..V.WQt.b#####a#b#a#c.bQt.6#d#e.c",
"Qt#f#fQtQtQt.b.b.b.b.b.bQtQtQt.c.cQt",
"QtQtQtQtQtQtQtQt#g#hQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQt#g#hQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQt#g#hQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQt#g#hQtQtQtQtQtQtQtQt",
"QtQt#i#i#j#j#k#k#g#h#k#k#l#j#i#iQtQt",
"Qt#i#i#j#j#k#k#k#g#h#k#l#k#j#j#m#m#m",
"Qt#i#j#j#j#j#k#k#k#h#n#k#k#j#j#j#mQt",
"QtQtQt#i#i#j#j#j#o#o#j#j#j#j#mQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image110_data[] = { 
"18 18 141 2",
".u c #000000",
".c c #0072ff",
".d c #0099ff",
".a c #00ccff",
".b c #99ffff",
"#2 c #9b1c01",
"#V c #aa2c08",
"#d c #ac3812",
".S c #ad3f1b",
"#6 c #ad4132",
"ah c #af6356",
"#e c #b03b12",
"#0 c #bb5532",
".t c #bb6c4b",
"#X c #be3a05",
".E c #be7156",
"#L c #bf3901",
"#1 c #bf847d",
".v c #bfbfbf",
".I c #c56a2d",
"#w c #c64c12",
"ak c #c88c7e",
"ai c #ca3603",
".y c #cb8b5f",
".# c #ccffff",
".H c #d47a1b",
".5 c #d6702e",
".x c #d69554",
"#u c #d7653d",
"a. c #d7aea7",
".l c #d9560f",
"#J c #d97252",
"ad c #dc3702",
"#W c #dc5a20",
"#g c #dd5e27",
".C c #dd7710",
"#Q c #de5d0b",
"#h c #de7538",
"ae c #e03f0a",
"#Z c #e04e06",
".e c #e1c3bf",
"#c c #e2640a",
".0 c #e26b0c",
"#7 c #e2c2ba",
"#M c #e35507",
"#x c #e36512",
".T c #e3802b",
".k c #e4803c",
"ac c #e77637",
".4 c #e97c11",
"#9 c #eb5e11",
"#P c #eb6d0f",
".D c #eb9a27",
".R c #ec9a19",
"#i c #ef8227",
"ab c #f16510",
".F c #f1be68",
"#5 c #f2e4e2",
".s c #f4ba49",
"a# c #f54c03",
"#R c #f7660a",
".6 c #f79523",
"#H c #f95404",
".1 c #faf5f2",
"#G c #fb5505",
".7 c #fb961c",
"aj c #fbd5b7",
"af c #fdb67d",
"aa c #ff4904",
"#4 c #ff5906",
"#U c #ff6208",
"#F c #ff6308",
"#s c #ff6606",
"#Y c #ff6608",
"#3 c #ff6709",
"#r c #ff6906",
"#N c #ff6b0b",
"#T c #ff6c0b",
"#q c #ff7008",
"#K c #ff710c",
"#S c #ff740c",
"#E c #ff740e",
"#O c #ff750d",
"#D c #ff7a11",
"#C c #ff7d11",
"#p c #ff7e0f",
"#v c #ff7e14",
"#y c #ff8612",
"#B c #ff8814",
".3 c #ff8819",
"#o c #ff8916",
"#z c #ff8d16",
".f c #ff8f5c",
"#n c #ff9219",
".o c #ff9260",
"#b c #ff9315",
"#A c #ff9318",
"#m c #ff9619",
".2 c #ff9863",
".i c #ff9a44",
"#a c #ff9d1b",
"#l c #ff9f1c",
".h c #ff9f6f",
"#j c #ffa017",
".O c #ffa03a",
".p c #ffa047",
".Z c #ffa31a",
".j c #ffa447",
"#k c #ffa61d",
"## c #ffa91e",
".8 c #ffaa1f",
".Q c #ffac19",
".Y c #ffac1f",
"#. c #ffad1f",
".9 c #ffb021",
".P c #ffb12a",
".N c #ffb321",
".X c #ffb425",
".U c #ffb42f",
"#8 c #ffb587",
".q c #ffb749",
".W c #ffb833",
".V c #ffb83b",
".M c #ffba36",
".n c #ffc17e",
".g c #ffc1a8",
".G c #ffc42e",
".B c #ffc856",
".L c #ffca61",
".A c #ffcd7f",
".K c #ffd37c",
".r c #ffd457",
"ag c #ffd7bc",
".z c #ffd89c",
".J c #ffd978",
".w c #ffe67e",
".m c #fff4b7",
"#t c #fff8f5",
"#f c #fffbfa",
"#I c #fffefd",
"Qt c #ffffff",
"QtQt.#.a.#QtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQt.a.b.cQtQtQtQtQtQtQtQtQtQtQtQtQt",
".#.#.#.d.#QtQtQtQtQtQtQtQtQtQtQtQtQt",
".d.#QtQtQtQtQtQtQtQtQtQt.e.e.eQtQtQt",
"Qt.f.f.f.f.f.f.f.e.e.g.h.i.j.k.eQtQt",
".l.m.m.n.n.n.n.n.o.f.p.q.r.s.tQtQtQt",
".f.m.u.v.w.x.y.m.z.A.B.C.D.EQtQtQtQt",
".f.F.vQt.G.H.I.J.K.L.M.N.C.CQtQtQtQt",
".f.O.P.Q.R.S.T.U.V.W.X.Y.Z.0.CQtQtQt",
".1.2.3.4.S.5.6.7.8.9#.###a#b#c#d#e#e",
"Qt#f.2.l#g.5#h#i#j#k#l#m#n#o#p#q#r#s",
"QtQt#t.l#u#v#w#x#y#z#A#B#C#D#E#F#G#H",
"QtQtQt#I#J#K#L#M#N#O#P#Q#R#S#T#U#V#e",
"QtQtQtQt.2#W#L#X#Y#Z#0#1#0#2#3#4#e#5",
"QtQtQtQtQt#6#0#7#8#9#0Qt#5a.#2a#aa#e",
"QtQtQtQtQt#0#7QtQtQtab#0QtQtac#2adae",
"QtQtQtQtQtQt#1QtQtQtaf#0QtQtag#2ahai",
"QtQtQtQtQtQtQtQtQtQtQt#0QtQtaj#2#5ak"};

static const char* const image111_data[] = { 
"18 18 138 2",
"#b c #000000",
"#0 c #240200",
"#f c #341100",
"#R c #350f00",
"#V c #3a1107",
"#u c #421600",
"#Z c #431800",
"#D c #431c17",
".Z c #462200",
".m c #482114",
"#d c #491c00",
".t c #492300",
"#n c #4b1d01",
"#o c #4b2823",
".7 c #4c1e00",
".r c #4d1e08",
"aa c #4e2c26",
"#4 c #4f2718",
".N c #502600",
"#N c #522b1f",
".C c #542900",
"#. c #562900",
".h c #583915",
"#s c #585858",
".E c #5a2400",
".i c #5b3102",
".a c #5b3915",
".b c #5b3a15",
".5 c #5c2700",
".U c #5c2b00",
".w c #5c2c00",
".I c #5c2d00",
"#1 c #5c2e18",
"#y c #5d2e00",
".O c #5e2800",
"#m c #5e2900",
".0 c #5f2a00",
"#c c #5f2d00",
"#k c #603608",
".l c #613100",
".F c #623000",
".c c #624323",
"#t c #632c00",
".D c #632f00",
".H c #643200",
".k c #653500",
"#x c #653a27",
"#7 c #663504",
".T c #673401",
".j c #673500",
"#K c #683400",
"#Q c #683500",
"#P c #683600",
".W c #683602",
"#Y c #693704",
"ae c #69402e",
".u c #6a3600",
".R c #6a3a00",
"## c #6c3607",
".v c #6c3900",
"#A c #6d3c1c",
".n c #6d5149",
"#8 c #6e3d24",
".6 c #6f3b00",
".x c #71544d",
"#g c #73400f",
"ag c #74461e",
".q c #754013",
".J c #755a53",
".9 c #774323",
".V c #775a51",
"#v c #78462a",
"#p c #79450f",
"#E c #7b4d23",
".P c #7d4b07",
"#l c #7e4c17",
".G c #804a13",
"#L c #804c32",
"ah c #855a27",
"#S c #865231",
"#C c #935d39",
"#2 c #945e37",
"#i c #965d22",
"#F c #971e00",
".# c #97836d",
".B c #996637",
"#W c #996737",
".3 c #9a6934",
"a# c #9d8f8f",
"#3 c #9f8d8c",
"a. c #a1908f",
".4 c #a56c35",
"#9 c #a5938f",
"#J c #a76e33",
".S c #a97039",
"#B c #a98648",
".K c #ab7030",
"#I c #ae7847",
".s c #b1752f",
".g c #b3a699",
"#e c #bbafad",
".X c #be7826",
".e c #bf7f37",
"#j c #c1b6b5",
".8 c #c2ac93",
"ad c #c7bbb7",
"#a c #cbc5cd",
".L c #cd8b45",
"#h c #cf9760",
".o c #d09046",
".f c #d0995a",
"#w c #d1925b",
"ac c #d1c8c6",
".y c #d28f42",
".d c #d39c5d",
".Q c #d39f6f",
"af c #d5cdcc",
".p c #d99656",
".Y c #db9659",
".A c #dda967",
".z c #de9c5d",
"#X c #e7ac7d",
"#6 c #e7b380",
"#z c #e9bb8f",
"#H c #ebbc91",
"#5 c #ebbd90",
"#U c #eca455",
"ab c #ecbc8a",
"#O c #edc29a",
"#G c #efc49e",
"#M c #f0a758",
"#q c #f0bd8d",
".M c #f1c573",
"#r c #f5c392",
".1 c #f9ddbf",
".2 c #fefefe",
"#T c #ffba77",
"Qt c #ffffff",
"QtQtQtQtQtQtQt.#.a.b.cQtQtQtQtQtQtQt",
"Qt.d.e.fQt.g.h.i.j.k.l.m.nQtQtQtQtQt",
".o.p.q.r.s.t.u.v.v.v.v.v.w.xQtQtQtQt",
".y.z.A.r.B.C.D.E.F.G.H.v.v.I.JQtQtQt",
".K.L.M.r.N.O.P.Q.R.Q.S.T.v.v.U.VQtQt",
".W.X.Y.Z.0.1.2.2.3.Q.4.5.v.v.6.7QtQt",
".8.W.9#.##.2#a#b.3.Q.Q.Q#c.v.v#d#eQt",
"Qt.W#f#g#h.2#b#b.Q.Q.Q.Q#i.v.v#d#jQt",
".8#k.I#l#l.3.3.Q.Q.Q#b#b.2#m.v#n#oQt",
".W.l#p#q#q#r#r#r.Q.Q#b#s.2#t#u#v#w#x",
".W#y#q#q#z#r#A#B.Q.Q#s.2.1#m#u#u#u#C",
"#D#E#q#F.1#G#H#H#A#I#h#J#K#u#L#M#u#C",
"#N#q#q#F.1.1#O#H#H#H#H#P#Q#R#S#T#U#C",
"#V#W#q#X#F.1.1#G#H#H#H#Y#Z#0#1#2#CQt",
"#3#4#q#X#X#F.1.1.1#5#6#7#8#9a.a#QtQt",
"Qtaa#qab#X#X#F#F#F#X.3#8acQtQtQtQtQt",
"Qtadae#q#q#X#X#X#X#8#8afQtQtQtQtQtQt",
"QtQtadagahahahahahadQtQtQtQtQtQtQtQt"};

static const char* const image112_data[] = { 
"18 18 108 2",
".f c #000000",
"#u c #290000",
"#D c #320e0e",
"#. c #340815",
"#E c #382020",
"#v c #451000",
"#m c #490c1e",
".1 c #4c3632",
"#F c #503225",
".K c #554b4b",
".W c #5a293d",
".z c #5d2b35",
".4 c #663333",
".V c #67190a",
"#h c #6a070c",
".9 c #6b7b8b",
".O c #6d521a",
".k c #72644c",
".R c #762211",
"#n c #794624",
"#t c #7f1010",
".N c #81631d",
"#i c #850f0f",
".H c #85532b",
"#O c #862525",
"#N c #882a2a",
"#I c #8a2626",
".Q c #8b5516",
".8 c #8c721b",
"#g c #8e5328",
".T c #8e5f35",
".G c #8e696b",
".# c #926c68",
"#b c #976905",
".w c #997416",
"#G c #9b7665",
".t c #9b781c",
"#c c #9c2424",
".5 c #9c7059",
".E c #9c7515",
"#f c #9d6f25",
".Y c #9f7b0f",
".Z c #9f9c93",
".7 c #a1755f",
".X c #a17762",
"#l c #aa3a3a",
".u c #ab7900",
".r c #ad7c21",
".3 c #ad9399",
".A c #ae7c22",
"#x c #b29ba4",
".v c #b48200",
".q c #ba8b1d",
"#e c #bba6ab",
".6 c #bc9209",
".y c #bd8d1b",
"#M c #be8c8c",
".F c #be8e1b",
"#a c #c0adb2",
"#J c #c0bebe",
"#j c #c45454",
"#B c #c65757",
"#r c #c65959",
"#C c #c75c5c",
".C c #c89300",
"#o c #c99a1a",
"#s c #ce6060",
"#H c #ce6666",
".l c #ceb570",
"#A c #cf6d6d",
".j c #d0b47d",
"#q c #d26c6c",
"#k c #d46868",
".P c #d4a003",
".g c #d4ba70",
"#p c #d67a7a",
"#w c #d6920c",
".I c #d7a402",
"#P c #d9bfbf",
".o c #dca500",
"#z c #dd8b8b",
".b c #dea800",
".a c #dfb013",
".B c #e0af12",
".p c #e2af07",
"#K c #e2d8d8",
"#L c #e3d8d9",
"#y c #eab6b6",
"#d c #ecba0f",
".x c #ecbb12",
".U c #eebf13",
".2 c #f6f5f6",
".i c #f7e9b4",
".e c #f9f8f8",
".c c #faebbd",
".S c #fafafd",
".s c #fbd243",
".n c #fbf8f0",
".0 c #fbfbfb",
".M c #fcecb1",
".d c #fefefe",
".L c #feffff",
".m c #fffded",
".D c #fffef3",
"## c #fffffa",
".J c #fffffb",
".h c #fffffc",
"Qt c #ffffff",
"QtQtQt.#.#.#.#.#.#.#QtQtQtQtQtQtQtQt",
"QtQt.#.a.a.b.c.d.d.e.#.#.#.#QtQtQtQt",
"Qt.#.a.a.a.f.g.h.d.d.d.d.i.j.#QtQtQt",
".#.a.a.a.f.k.f.l.m.d.n.d.o.p.q.#QtQt",
".#.a.r.a.a.s.t.u.d.d.d.v.f.w.x.y.#Qt",
".#.a.z.A.B.C.d.d.d.d.D.d.a.f.E.x.F.#",
".G.a.z.H.I.d.J.K.K.K.L.d.M.N.O.P.x.#",
".G.zQt.Q.d.d.K.R.R.R.K.S.M.P.P.P.x.#",
".zQt.T.U.d.d.K.R.R.V.R.d.M.P.W.W.x.#",
"Qt.X.U.Y.Z.d.0.K.R.1.d.2.M.W.3.3.4.#",
"Qt.5.U.U.d.d.d.d.1.d.d.d.M.6.WQtQt.4",
"Qt.7.U.8.9.d.d#..d.d.d##.Z.Z.W#aQtQt",
"Qt.W.U#b#.#.#.#c#..d.d.d#d#d.W#eQtQt",
"Qt.W#f#g#h#i#j#k#l#.#.#m#n#o.WQtQtQt",
"QtQt.W.W#i#p#q#r#s#t#u#v#w.W#xQtQtQt",
"QtQtQtQt#y#z#A#B#C#D#E#F.W#GQtQtQtQt",
"QtQtQtQt#y#y#z#H#I#J#K#LQtQtQtQtQtQt",
"QtQtQtQtQt#M#N#O#PQtQtQtQtQtQtQtQtQt"};

static const char* const image113_data[] = { 
"18 18 50 1",
"c c #000000",
"e c #161516",
"a c #18271b",
"f c #1c120d",
"C c #291100",
"H c #341402",
"d c #345d41",
"# c #39513d",
"O c #466a51",
"r c #486c49",
"S c #665230",
"B c #6f9a7c",
"U c #765d30",
"K c #77633b",
"y c #78431c",
"E c #79441d",
"L c #7e4820",
"N c #806c43",
"i c #82af90",
"F c #834d25",
"l c #844d24",
"P c #854e25",
"s c #8e552c",
"D c #91572c",
"T c #958152",
"G c #967a4f",
"x c #a06337",
"g c #abcfb3",
"J c #ad7041",
"u c #b89a7d",
"I c #be7c4c",
"w c #be7d4c",
"n c #bf7d4c",
"M c #c1b4a6",
"R c #c3b8ab",
"V c #c5b6a5",
"q c #c6bcb7",
"A c #c78553",
"b c #cae1cf",
"Q c #cccccc",
"z c #cd8956",
"m c #d2915e",
"p c #d3915f",
"t c #d4905d",
"v c #d4915e",
"o c #da9866",
"k c #dd9d6d",
"j c #de9e6e",
"h c #fefefe",
". c #ffffff",
".....##aaa........",
"....#bbbbbc.......",
"...#bbdaeebcff....",
"..#bbgaheeicjkff..",
"..#bgiahhaicllmnf.",
"..#biiiaaiicoplnfq",
".r#giiciiicstloluf",
"rii#iiicccvwsowxyf",
"rii#iiiiiczAysxslf",
"rBCrBiiiicDwyyEFsf",
"raGaBBiiiicDHIJHEf",
"a.HKaBBBBiicJDLHyf",
"..MHNaaaOiicPDHyfQ",
"...RHSTUaOiicHyfBa",
"....VHHHaBiicffBBa",
"......QQaBiicQ.aaa",
".........aBBBaQ...",
"..........aaaaQ..."};

static const char* const image114_data[] = { 
"18 18 84 2",
"#f c #171b1b",
".Y c #2a0903",
"#h c #353b3b",
"#q c #38050c",
"#l c #3d0000",
"#n c #3d1010",
".# c #3f0000",
".F c #400502",
"#g c #410405",
".9 c #410500",
"## c #420200",
"#m c #420606",
".b c #430300",
".a c #440404",
".R c #460901",
"#o c #480300",
".h c #480301",
".y c #4a0a01",
".I c #4d0c02",
".q c #4d1b1b",
".z c #4f0401",
".d c #501600",
".x c #551811",
".l c #5c1c07",
".5 c #5f1000",
"#j c #601003",
".f c #603000",
"#. c #631c01",
"#a c #642923",
"#i c #6e6e6e",
".W c #724949",
"#d c #781d03",
".C c #7a3008",
".1 c #7c3505",
".8 c #7e4801",
".c c #825000",
".k c #825454",
".H c #833407",
".4 c #843108",
".7 c #8a2502",
"#p c #8c3008",
".n c #903907",
".e c #9a6907",
"#c c #9c2900",
".0 c #9e3c06",
".u c #a07426",
".K c #a77448",
".T c #b07b0d",
".s c #b5520a",
".G c #b66712",
".w c #b6761a",
".V c #c14705",
".E c #c37d17",
".2 c #c54503",
".J c #c6b5a9",
".i c #c88e16",
".m c #c9911d",
".6 c #ca5b04",
"#e c #cb5118",
".v c #ce8417",
".Q c #d16d10",
".S c #d84400",
".D c #d8921b",
".j c #e9bc26",
".p c #eca420",
".r c #f2b222",
".O c #f3a116",
"#k c #f46a09",
".L c #f48d11",
".X c #f4bf27",
".N c #f5f3f1",
"#r c #f7f7f7",
".B c #f9f7f2",
"#b c #f9f9f9",
".A c #faf9f7",
".M c #ff860f",
".t c #ff9715",
".Z c #ff9d15",
".U c #ffa512",
".P c #ffb11e",
".o c #ffb621",
".3 c #ffbb25",
".g c #ffcf29",
"Qt c #ffffff",
"QtQtQt.#.aQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQt.b.c.c.#QtQtQtQtQtQtQtQtQt.d.d.d",
"QtQt.b.c.c.c.#QtQtQtQtQtQtQt.e.e.e.d",
"Qt.b.c.b.f.g.g.hQtQtQtQtQt.e.i.j.j.k",
"Qt.l.c.m.l.n.g.o.#QtQtQtQt.e.p.j.j.q",
"Qt.l.c.m.r.r.s.o.t.#QtQt.u.v.q.j.w.q",
"Qt.x.y.z.r.r.r.s.s.#.A.B.u.C.D.E.qQt",
"QtQt.F.G.H.o.n.t.t.I.J.K.L.M.D.D.qQt",
"Qt.N.l.O.P.H.t.t.t.Q.R.K.S.M.M.qQtQt",
"Qt.H.T.l.P.P.H.n.s.U.R.V.S.S.M.WQtQt",
".H.X.X.X.Y.Z.Z.n.0.1.R.2.V.S.qQtQtQt",
".H.X.X.3.3.4.Z.n.S.5.6.7.V.V.qQtQtQt",
".H.X.X.Z.Z.8.9.S.S.S#.##.V#aQtQt#bQt",
"Qt.H.Z.Z.Z.S.S.9.9#c#c#d#e#aQtQt#fQt",
"Qt.H.Z.S.S#c.S.S.9.9#g#h#i#f#f#fQt#f",
"QtQt.H.S#c#c#j#k#l#m#h#i#f#iQtQtQt#f",
"QtQtQt.H.H#n#o#p#h#i#i#hQtQt#fQt#fQt",
"QtQtQtQtQtQtQt#q#f#f#f#rQt#fQtQtQtQt"};

static const char* const image115_data[] = { 
"18 18 80 2",
".K c #000000",
".V c #120000",
"#c c #270000",
"#m c #580404",
".Q c #5a5a5a",
"#l c #5c0000",
".R c #6f2121",
".1 c #862a2a",
".Z c #881e1e",
"#b c #8a2222",
"#h c #8d2a2a",
"#j c #8f0909",
".5 c #8f2b2b",
".O c #900c0c",
".i c #961414",
"#k c #981717",
".f c #981e1e",
"#i c #9b1616",
"#g c #9d1f1f",
"#d c #a32323",
".M c #a5aeae",
".B c #af4343",
".N c #bb4f4f",
".h c #be8d8d",
".I c #c05c5c",
".# c #c37575",
".o c #c87d7d",
".E c #ca7070",
".W c #ca7171",
".g c #d3b4b4",
".c c #d3b6b6",
".C c #d78888",
".J c #d7d2d2",
"#n c #dad8d8",
".p c #dbdada",
".d c #dcdcdc",
".e c #decaca",
".a c #e39898",
".0 c #e4a2a2",
".A c #e79e9e",
"#. c #eea3a3",
"#a c #fcd7d7",
".P c #fcf1f1",
".x c #fcf7f7",
".U c #fdc2c2",
".T c #fefdfd",
".s c #fefefe",
"## c #ffc7c7",
".Y c #ffcbcb",
".4 c #ffcccc",
".k c #ffcece",
".r c #ffd1d1",
".q c #ffd5d5",
".X c #ffd7d7",
".9 c #ffdada",
".S c #ffdcdc",
".L c #ffdddd",
"#f c #ffdede",
".3 c #ffe1e1",
".7 c #ffe2e2",
"#e c #ffe3e3",
".2 c #ffe4e4",
".v c #ffe6e6",
".G c #ffe7e7",
".u c #ffe9e9",
".b c #ffeaea",
".j c #ffebeb",
".t c #ffeded",
".D c #ffeeee",
".z c #ffefef",
".l c #fff1f1",
".H c #fff2f2",
".F c #fff3f3",
".8 c #fff5f5",
".6 c #fff7f7",
".m c #fff9f9",
".y c #fffcfc",
".w c #fffdfd",
".n c #fffefe",
"Qt c #ffffff",
"Qt.#.#QtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
".#.a.b.#.c.d.e.#.#.#.f.f.g.d.h.iQtQt",
".#.j.k.k.f.#.#.l.m.n.m.m.f.f.i.o.i.p",
".#.q.r.k.f.s.s.m.t.b.u.v.w.w.i.k.i.d",
".#.f.k.k.f.x.y.m.t.b.t.z.b.b.i.k.k.i",
".A.B.f.k.f.C.C.z.t.D.E.E.b.i.k.k.k.i",
"Qt.#.s.f.s.F.F.C.G.H.H.H.E.I.i.i.i.d",
"Qt.#.s.s.J.K.s.C.L.m.M.K.s.E.N.N.O.d",
"Qt.#.s.P.Q.K.s.R.S.T.K.K.s.E.q.U.O.d",
"Qt.#.w.P.Q.R.R.R.s.R.R.V.s.W.X.U.O.d",
".#.s.P.P.R.s.s.s.s.t.t.R.R.W.r.Y.U.Z",
".#.w.P.u.s.0.1.1.1.1.z.2.2.3.Y.4.U.5",
".#.6.7.7.1.1.8.8.8.9.1#..3.3.3.4##.5",
".##a#a.1.8.8.K.8.K.X.9.1.3.3.U#####b",
"Qt#c#a#d.8#e.K.8.K#f.9#g.U.U#c.U.U#h",
"QtQt#c#i.9#e#j.9#j.L.9#k.U#c.U.U#h.d",
"QtQtQt#c.9#e.9.9.9.9.9#k#c.U.U#h.dQt",
"QtQtQtQt#c#c#c#c#c#c#c#l#m#l#h#nQtQt"};

static const char* const image116_data[] = { 
"18 18 66 2",
".J c #000000",
".A c #040000",
".P c #070000",
".0 c #070707",
"#. c #090909",
".N c #141414",
".m c #141919",
".y c #152121",
".O c #1b1b1b",
".C c #2f3939",
".1 c #331616",
".5 c #373737",
".X c #380000",
".# c #393838",
".I c #443333",
".8 c #495353",
".s c #4b4b4b",
".e c #4d4d4d",
".Q c #4f0000",
".T c #500000",
".t c #540000",
".v c #550000",
".c c #565656",
".2 c #570000",
".u c #5a0000",
".3 c #610000",
".B c #616161",
".D c #650000",
".4 c #670000",
".l c #6f7c7c",
".E c #720000",
".b c #727272",
".S c #797979",
".W c #7d7d7d",
".K c #7e7e7e",
".Y c #830000",
".9 c #9c9c9c",
".M c #a2a2a2",
".F c #a40000",
".d c #adadad",
".6 c #afafaf",
".k c #b58484",
".n c #b94848",
".G c #cb0000",
".q c #cc0000",
".H c #cdcdcd",
".U c #cf0707",
".i c #cf6262",
".j c #da8383",
".w c #daacac",
".R c #dc1313",
".a c #dcdcdc",
".p c #e69d9d",
".r c #e85959",
".x c #e97474",
".V c #ef7979",
".g c #efe3e3",
".o c #f2c1c1",
".Z c #f41f1f",
".f c #f7dddd",
"## c #f9f9f9",
".L c #fafafa",
".z c #fbfbfb",
".7 c #fdfdfd",
".h c #fefdfd",
"Qt c #ffffff",
"QtQtQtQtQt.#.#.#.#QtQtQtQtQtQtQtQtQt",
"QtQtQtQt.#.aQtQtQt.#.#QtQtQtQtQtQtQt",
"QtQtQtQt.#.aQtQtQtQtQt.b.bQtQtQtQtQt",
"QtQtQtQtQt.#QtQtQtQt.cQtQt.d.dQtQtQt",
"Qt.#.#.#Qt.e.f.g.hQt.cQtQtQtQtQtQtQt",
".#.a.a.a.e.i.j.k.l.m.cQtQtQtQtQtQtQt",
".#QtQtQt.e.n.o.p.q.q.r.mQtQtQtQt.sQt",
".#QtQtQt.a.t.u.v.w.x.q.r.y.z.A.BQtQt",
".#QtQtQt.a.C.u.u.D.E.F.G.r.A.HQtQtQt",
"Qt.bQtQtQt.a.I.u.u.u.u.E.q.r.J.K.K.L",
"Qt.bQt.M.J.N.O.P.Q.u.u.u.E.q.R.J.a.K",
"Qt.S.#.J.HQtQt.a.J.u.u.u.u.T.U.V.J.a",
"QtQt.dQtQtQt.W.J.a.J.X.u.u.u.Y.Z.J.a",
"QtQtQt.dQtQt.0QtQt.a.J.J.1.2.3.4.J.a",
"QtQtQt.#.5.0.HQtQt.6.J.a.J.J.J.J.aQt",
"QtQtQtQt.#.7QtQtQt.a.JQtQt.a.a.aQtQt",
"QtQtQtQtQtQtQtQtQtQt.8.9QtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQt#.##QtQtQtQtQt"};

static const char* const image117_data[] = { 
"18 18 90 2",
".G c #011427",
".O c #1c2128",
"#w c #471600",
"#v c #4e1d00",
"#h c #4e2100",
"#x c #5c3f3e",
".F c #654a1c",
".Z c #903d00",
".j c #9b1f00",
".5 c #9c4200",
".0 c #a24701",
".g c #ad2e00",
".# c #ad4e02",
".f c #ae5318",
".a c #b2611b",
".Y c #b55e11",
".R c #b65f12",
"#u c #ba5a00",
"## c #c16700",
"#n c #c26300",
"#i c #ca7b2a",
".Q c #ccaba9",
".4 c #cd7000",
".J c #d06107",
".e c #d19457",
".q c #d4670b",
".1 c #d4841a",
".c c #d4b8a1",
".X c #d6cecb",
".b c #dcc0aa",
".w c #dcdcdc",
"#a c #df7e00",
".6 c #e18209",
"#q c #e77d00",
"#p c #e7d7cd",
".E c #ed9109",
".C c #edb365",
".M c #ef9200",
".i c #efa138",
".S c #f9c131",
".x c #faf6f3",
".I c #fec891",
".y c #fefefe",
"#r c #ff900a",
"#t c #ff9207",
"#s c #ff940a",
"#j c #ff9d04",
"#m c #ff9d10",
"#k c #ff9e11",
".K c #ffa201",
"#l c #ffa213",
"#o c #ffa50c",
"#c c #ffa515",
".U c #ffa704",
".7 c #ffa912",
".2 c #ffab02",
".V c #ffad01",
".P c #ffaf07",
"#b c #ffb015",
".L c #ffb51a",
"#d c #ffb62c",
"#g c #ffb62f",
".D c #ffb733",
"#e c #ffbc37",
"#f c #ffbd3e",
".B c #ffbe32",
".3 c #ffbf29",
".8 c #ffc555",
".v c #ffc75a",
".9 c #ffc761",
".z c #ffcb65",
".A c #ffcc52",
"#. c #ffd566",
".p c #ffd57c",
".u c #ffd788",
".W c #ffe28a",
".h c #ffe3a4",
".o c #ffe69e",
".t c #ffe6a2",
".n c #ffe7b2",
".m c #ffecc0",
".T c #ffee93",
".H c #ffeea7",
".l c #ffeeb7",
".s c #ffefc6",
".r c #fff0cf",
".N c #fffdd0",
".k c #fffee8",
".d c #ffffe6",
"Qt c #ffffff",
"QtQtQt.#.#.a.bQtQtQtQtQtQtQtQtQtQtQt",
"Qt.c.#.d.d.d.e.f.f.f.g.gQtQt.h.i.i.j",
"Qt.#.d.d.k.d.l.m.n.h.o.p.gQt.h.i.i.j",
"Qt.#.q.q.l.r.s.l.t.u.p.v.gQt.h.i.j.w",
".x.#.y.y.q.l.q.q.q.z.v.A.B.g.h.i.j.w",
".#.y.y.y.q.C.y.y.y.q.D.B.E.g.w.i.j.w",
".F.G.y.q.H.I.y.y.y.J.K.L.M.g.w.i.j.w",
".F.G.N.q.H.F.O.y.y.q.K.P.M.g.i.j.QQt",
".R.S.S.H.T.F.O.y.q.K.U.V.M.g.W.j.XQt",
"Qt.Y.Z.Z.0.1.S.q.K.K.2.M.g.W.W.g.wQt",
"Qt.Z.3.4.5.6.3.7.M.M.M.g.8.9#..g.wQt",
".Z.3##.Z.Z#a#b#c.g.g.g#d#e#f#g.g.wQt",
".S.Z.Z.4#h#i#j#k#l#m#n#o#o#o.g#pQtQt",
"QtQt.Z#hQt.g#q#q#r#s#t#u#o#o.g.wQtQt",
"QtQt#vQtQtQt#w#q#q#q#q#q#w.g.wQtQtQt",
"QtQtQtQtQt#w.w.g.g.g.gQt#w.wQtQtQtQt",
"QtQtQt#w#w#x#xQtQtQtQt#x#x#w#wQtQtQt",
"QtQtQtQt#wQt#xQtQtQtQt#xQt#wQtQtQtQt"};

static const char* const image118_data[] = { 
"18 18 44 1",
"d c #000000",
"p c #010101",
"h c #020202",
"a c #030303",
"J c #040404",
"H c #060606",
"k c #0d0d0d",
"l c #0e0e0e",
"c c #0f0f0f",
"j c #111111",
"b c #191919",
"g c #222222",
"q c #252525",
"m c #292929",
"M c #303030",
"e c #3f3f3f",
"o c #404040",
"n c #444444",
"u c #454545",
"K c #4a4a4a",
"i c #5b5b5b",
"I c #646464",
"F c #6a6a6a",
"N c #6f6f6f",
"O c #707070",
"E c #717171",
"P c #727272",
"G c #747474",
"z c #777777",
". c #7d7d7d",
"r c #7f7f7f",
"A c #818181",
"s c #838383",
"L c #8b8b8b",
"f c #8f8f8f",
"v c #9e9e9e",
"t c #ababab",
"x c #b2b2b2",
"y c #b9b9b9",
"C c #dfdfdf",
"D c #f6f6f6",
"B c #fdfdfd",
"w c #fefefe",
"# c #ffffff",
".################.",
"ab##############ba",
"cde############edc",
"cddf##########fddc",
"cddg##########gddc",
"cddhijkkkklmnohddc",
"kddddddddddddddddc",
"pdddpddddddddddddc",
"pdqrdsqdddqrrhstdj",
"uvwxdywzdABwxdywwu",
"dvwvdCwdddDwvdCwvd",
"ddEFdGdddHdEFHGIdd",
"JddddddddddddddddJ",
"KddddddddddddddddK",
"#lddddddddddddddl#",
"##mddddddddddddm##",
"###LMddddddddML###",
"#####tNNOOOPt#####"};

static const char* const image119_data[] = { 
"18 18 132 2",
".C c #030303",
".x c #080808",
".v c #0e0e0e",
"#v c #121212",
"#w c #131313",
"#u c #161616",
".D c #181818",
".B c #191919",
"#t c #1b1b1b",
"#j c #1c1c1c",
".p c #1e1e1e",
".U c #1f1f1f",
".u c #212121",
".e c #222222",
".k c #242424",
"#s c #262626",
".w c #272727",
".o c #282828",
".i c #292929",
"#i c #2a2a2a",
".b c #2c2c2c",
"#h c #2d2d2d",
".a c #2e2e2e",
"## c #2f2f2f",
".r c #323232",
"#. c #333333",
"#b c #353535",
".E c #363636",
".1 c #373737",
".9 c #383838",
".c c #393939",
".8 c #3a3a3a",
".0 c #3b3b3b",
".T c #3c3c3c",
"#g c #3d3d3d",
".Z c #3e3e3e",
".M c #3f3f3f",
"#C c #404040",
"#r c #414141",
".L c #434343",
".S c #444444",
".R c #454545",
".l c #474747",
".m c #4a4a4a",
".K c #505050",
".f c #535353",
"#k c #565656",
".4 c #676767",
".A c #6a624e",
"#E c #6c6561",
"#P c #6f625d",
"#O c #6f6a68",
"#N c #717171",
".Q c #7b6851",
"#F c #868686",
"#y c #8b8b8b",
"#G c #8d8d8d",
"#l c #919191",
".h c #949494",
"#x c #979797",
"#M c #999999",
"#m c #9b9b9b",
".2 c #a4a4a4",
".n c #ababab",
".# c #aeaeae",
".5 c #b2b2b2",
".q c #b5b5b5",
".J c #b76d0d",
".V c #b86a0a",
"#c c #b9b9b9",
"#d c #bbbbbb",
".W c #bcb6ae",
".z c #bd7615",
"#9 c #be4e0d",
"#3 c #bf4d07",
"#S c #bf4e08",
"#5 c #bf4f09",
"#4 c #bf510d",
"#8 c #bf5213",
"#7 c #bf5416",
"aa c #bf5517",
"#W c #c05310",
"#R c #c05716",
"#X c #c15b1c",
".g c #c1c1c1",
"ab c #c36a33",
"#z c #c3c3c3",
".d c #c4c4c4",
"#H c #c6c6c6",
".s c #c77107",
"#n c #c7c7c7",
".y c #c8821c",
"#I c #c8c8c8",
".X c #c9c9c9",
".t c #d0cfb8",
".Y c #d2d2d2",
"#e c #d3d3d3",
".6 c #dadada",
"#o c #dedede",
"#A c #e2e2e2",
"#K c #e86311",
"#V c #e87c53",
"#1 c #e98158",
"#B c #e9e9e9",
".7 c #ebebeb",
".G c #edd077",
"#p c #efefef",
"#D c #f09b66",
"#J c #f1a06d",
"#a c #f1f1f1",
".O c #f2a134",
"#0 c #f2b39b",
".j c #f3f3f3",
"#U c #f4bea9",
"#f c #f7f7f7",
"#q c #f8f8f8",
".H c #f9c95f",
"#T c #f9dac6",
".I c #fbbd4e",
".F c #fbdeb8",
".N c #fbdfbd",
"#L c #fbe5d7",
"#6 c #fceadf",
".P c #fda52d",
"#2 c #fdf5f2",
"a. c #fdf6f4",
"#Q c #fef8f5",
"#Y c #fef9f7",
"a# c #fefcfb",
".3 c #fff8f0",
"#Z c #fffefe",
"Qt c #ffffff",
"QtQtQtQt.#.a.b.a.cQtQtQtQtQtQtQtQtQt",
"QtQt.d.e.e.f.g.g.h.i.jQtQtQtQtQtQtQt",
"QtQt.k.l.m.n.o.p.q.h.rQtQtQtQtQtQtQt",
".s.t.u.l.m.g.v.w.x.g.uQtQtQtQtQtQtQt",
".s.s.y.z.A.g.B.C.D.g.u.EQtQtQtQtQtQt",
".F.G.H.I.J.K.g.g.g.L.M.wQtQtQtQtQtQt",
".N.O.P.s.Q.e.R.S.L.M.T.UQtQtQtQtQtQt",
".s.s.V.W.X.Y.b.M.Z.0.1.p.2QtQtQtQtQt",
".s.3.4.5.g.6.7.8.9.E#.##.e#aQtQt#b.l",
"QtQt#c.h#d#e.7#f.0#g#h#i#j.Z#k.U.D.D",
"QtQtQt#l#m#n#o#p#q#r.u#s.e.p#t#u#v#w",
"QtQtQtQt#x#y#z#e#A#B#C##.w.B.B.p.0Qt",
"QtQtQtQtQt#D#E#F#G#H#I#z.c.p.Z.SQtQt",
"QtQtQtQtQt#J#K#LQt#M#N#O#P.jQtQtQtQt",
"QtQtQtQt#Q#R#S#TQtQtQt#U#VQtQtQtQtQt",
"QtQtQtQt#W#XQt#SQt#Y#Z#0#1#2QtQtQtQt",
"QtQtQtQt#3QtQt#4#5#6Qt#7Qt#8QtQtQtQt",
"QtQtQtQtQtQtQtQtQtQt#9a.a#aaabQtQtQt"};

static const char* const image120_data[] = { 
"18 18 196 2",
"## c #2a2a2a",
"#G c #4d4229",
"#a c #524a30",
"#. c #666152",
".Z c #8d6d35",
"aL c #905f10",
"aK c #906311",
"b. c #926c1b",
"#O c #927112",
"ax c #927413",
"aS c #936714",
"a4 c #936815",
"aI c #936d19",
"#3 c #937211",
"ag c #937b1b",
"#A c #95871d",
"#l c #978016",
"bb c #988637",
"a6 c #988638",
"aW c #997624",
"ba c #99873a",
"a8 c #9a7b25",
"aH c #9a7c26",
"aV c #9a884a",
"au c #9b741b",
"af c #9b751c",
"aT c #9b7821",
"a5 c #9b7d32",
"a0 c #9c7116",
"aZ c #9c741d",
"av c #9c8240",
"#2 c #9d6f13",
"#z c #9e6809",
"#N c #9e6a0c",
"ay c #a57614",
"#H c #a98d39",
"#U c #af791b",
"#m c #b09221",
"aC c #b2751a",
"#T c #b27a19",
"#j c #b47d21",
"#E c #b5901e",
"an c #b67a1a",
"#n c #b69121",
"#D c #b69b21",
"#9 c #b97f1d",
"aJ c #ba8218",
"aM c #bc7c15",
"ah c #bc8a14",
"#V c #bc9231",
".b c #bc9730",
".j c #bc9933",
".k c #bc9b37",
".K c #bd7f28",
".y c #bd932c",
".c c #bd952c",
".i c #bd9838",
".a c #bd9b3c",
".w c #be761f",
"#d c #be7920",
".q c #be8d1f",
".e c #be8f23",
".d c #be9228",
".t c #bf8819",
".r c #bf891b",
".f c #bf9131",
"#e c #c06d17",
".v c #c06d18",
".X c #c08211",
".I c #c08718",
".s c #c08e23",
".u c #c1851c",
".g c #c18a2b",
".9 c #c18b1f",
"aU c #c29930",
"a9 c #c3972d",
"a3 c #c48e21",
"aG c #c49124",
"aQ c #c58716",
"at c #c58919",
"aR c #c58a1b",
"aF c #c58b1c",
"a1 c #c58c1d",
"aE c #c68614",
"#q c #c6a742",
"#p c #c9a63d",
"#P c #cc5707",
".x c #cc7d1f",
".h c #ce9758",
"#7 c #d36704",
"#Q c #d36804",
"#4 c #d36903",
"ak c #d36904",
"ae c #d39724",
"#M c #d4921d",
"#1 c #d5921d",
".p c #dcb13c",
".# c #dcbf67",
".Y c #ddc8ad",
".8 c #dea62d",
".W c #dea62e",
".H c #dea72e",
"#F c #deaf26",
".J c #dfb45a",
"#S c #e09a1e",
"am c #e3981a",
"#8 c #e3991b",
"#6 c #e5a418",
"al c #e78503",
"#5 c #e78803",
"aB c #e79c15",
"aA c #e7a117",
"aj c #e7b620",
"az c #e7bb26",
"#B c #e7c527",
".0 c #e8be43",
"#C c #ead728",
"ai c #ebbf1d",
"#R c #ebd827",
"#o c #efc631",
"aD c #f2a41c",
".B c #f3e469",
".P c #f3e46a",
".l c #f3e870",
".z c #f3e972",
".A c #f3e974",
".n c #f4db5d",
".C c #f4dd5f",
".O c #f4df63",
".Q c #f4df65",
".m c #f4e268",
".L c #f5cf5b",
".S c #f5d552",
".o c #f5d553",
".2 c #f5d653",
".D c #f5d654",
".4 c #f5d655",
".N c #f5d95a",
".3 c #f5da5a",
".R c #f5da5b",
"#s c #f7bc4c",
".M c #f7cb4d",
".T c #f7ce48",
".E c #f7cf4a",
"#r c #f7cf51",
".1 c #f7d14c",
"#c c #f7d351",
"aw c #f7ebbb",
"#f c #f8bc40",
".U c #f8c73e",
".F c #f8c940",
".5 c #f8cb44",
"#b c #f8cb45",
"#g c #f8cd46",
"aX c #f8e5c7",
"#I c #f9b036",
"#t c #f9b539",
".7 c #f9bf32",
".V c #f9c135",
"#W c #f9c235",
".G c #f9c236",
"#u c #f9c338",
".6 c #f9c53b",
"aY c #faebd5",
"#Y c #fbb929",
"#w c #fbb92a",
"#J c #fbba2a",
"a# c #fbba2b",
"a. c #fbba2c",
"#X c #fbbc2e",
"#h c #fbbd2e",
"a2 c #fbbd2f",
"#v c #fbbe31",
"#k c #fbfad7",
"ap c #fcb320",
"ab c #fcb421",
"#x c #fcb422",
"ao c #fcb423",
"#K c #fcb524",
"aa c #fcb625",
"#i c #fcb626",
"aN c #fdaa16",
"aP c #feab16",
"#0 c #feac17",
"aq c #feae19",
"#y c #feaf1a",
"ac c #feb01c",
"#L c #feb01d",
"#Z c #feb01e",
"a7 c #fefaea",
"b# c #fefdf5",
"ad c #ffaa14",
"ar c #ffaa15",
"aO c #ffab15",
"as c #ffab16",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQt.#.a.b.c.d.e.fQtQt.gQt",
"QtQtQt.hQt.i.j.k.l.m.n.o.p.q.r.s.t.u",
"QtQt.v.w.x.y.m.z.A.B.C.D.E.F.G.H.I.J",
"QtQt.K.L.M.N.O.P.P.Q.R.S.T.U.V.W.XQt",
"Qt.Y.Z.0.1.2.3.C.C.R.4.1.5.6.7.8.9Qt",
"Qt#.###a#b.1#c#d#e#f.1#g.U.G#h#i.9#j",
"#k#l#m#n#o#p#q#r#s#t.5.U#u#v#w#x#y#z",
"#A#B#C#D#E#F#G#H#I.U.6.G#v#J#K#L#M#N",
"#O#P#Q#R#S#T#U#V#W.V#v#X#Y#K#Z#0#1#2",
"#3#4#5#6#P#7#8#9a.a##Yaaabac#0adaeaf",
"agahaiajakalamanaoabap#Laqarasatauav",
"awaxayazaAaBaCaDaqaq#0adadaEaFaGaHQt",
"QtQtaIaJaKaLaMaNaOaPaqaQaRaSaTaUaVQt",
"QtQtQtaWaXaYaZa0a1a2a3a4a5QtQta6QtQt",
"QtQtQta7QtQtQtQta8a9b.QtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtb#babbQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image121_data[] = { 
"18 18 279 2",
".6 c #0a0a73",
".Y c #181738",
"#k c #2b2a1e",
"#l c #30302c",
".7 c #33283c",
".Z c #3433a4",
"#c c #37372f",
"#d c #454353",
"a7 c #692901",
"ct c #763c03",
"ce c #773f02",
"c# c #793b03",
"c. c #793c03",
"cd c #793f03",
"ca c #7a3c03",
"cc c #7a3e03",
"a6 c #7b3501",
"cb c #7b3e03",
"ck c #7b4108",
"cj c #7b4209",
".q c #831e00",
".p c #854209",
".E c #85430a",
".C c #8a3700",
".# c #8c521c",
".o c #8c531e",
"cg c #904f06",
"b4 c #935004",
".F c #935d25",
"#b c #93832d",
".b c #94470c",
".D c #952e04",
"bP c #954a04",
"aU c #962903",
".a c #964a10",
"b7 c #965008",
"bA c #965205",
"b8 c #96560a",
"bQ c #975104",
"ch c #97540c",
"#C c #98854b",
"#t c #999154",
".r c #9b2d00",
"bo c #9b5109",
"bI c #9c5e11",
"bD c #9d4f08",
"bL c #9f5d10",
".n c #a05d24",
"bH c #a0600f",
".m c #a06028",
"aV c #a33502",
"aT c #a33503",
"aD c #a33604",
"aH c #a33707",
"bC c #a35a1a",
"bK c #a76613",
"bl c #a95606",
"br c #a96914",
"bn c #a97e5c",
"#B c #aa974d",
"a0 c #ac5908",
"bM c #ac6210",
"bS c #ac672a",
"bJ c #ac6914",
"ba c #ad5808",
"aN c #b05f0b",
"a1 c #b0620c",
"bm c #b06512",
"bb c #b16516",
"bG c #b16810",
"bw c #b25e0b",
"aw c #b4620d",
"be c #b47619",
".U c #b47f45",
".T c #b54302",
"bx c #b6670f",
"ae c #b66915",
"aO c #b66b0f",
"bi c #b75b08",
"#X c #b86e11",
"ax c #b87111",
"af c #b87614",
"#Z c #b87a19",
"#q c #b88119",
"#I c #b8821c",
"## c #b88423",
"bs c #b9630a",
"#F c #b96f11",
"#o c #b97725",
".G c #bb4300",
"bv c #bc5b04",
"bN c #bc680e",
"bf c #c05e05",
"bt c #c15d02",
".s c #c35408",
"a. c #c37120",
"bu c #c45e00",
"a5 c #c45e01",
"aS c #c46004",
"a8 c #c46207",
"aW c #c4640a",
"aB c #c4660f",
"ak c #c46915",
"aJ c #c46a16",
"ar c #c46c19",
"#7 c #c46d1b",
"#8 c #c46d1c",
"#6 c #c46e1c",
"#9 c #c46f1e",
"#5 c #c47020",
"bq c #c47512",
"bX c #c56d0f",
"bY c #c66e11",
"bW c #c76e0e",
"bF c #c77311",
"bj c #c77414",
"cf c #c8810b",
"#m c #c89426",
"bZ c #c96f11",
"bO c #ca6b0b",
".S c #cb4d00",
"b0 c #cc6f10",
"b3 c #cc7508",
"b1 c #cd6e0e",
"b2 c #cd6f0a",
".X c #ceb72b",
"by c #cf6f0d",
"#u c #cfc351",
"bV c #d0720f",
"a9 c #d29434",
"b9 c #d47e10",
"bd c #d48215",
".5 c #d5bd5d",
".H c #d7710d",
".B c #d7720f",
"a3 c #d78e1b",
"bg c #d86d00",
"bh c #d86e03",
"bz c #d8750b",
"bE c #d87a10",
"bT c #d9740e",
"bU c #d9770f",
"bk c #db7a10",
"bp c #dc8112",
"#j c #dec864",
".t c #dfa321",
".A c #e09b1d",
".h c #e0aa24",
".g c #e0ad24",
".f c #e0ae25",
".e c #e0ae2a",
".j c #e1a62b",
".i c #e1a723",
"#s c #e1c944",
"b# c #e28114",
"b. c #e38f20",
"aQ c #e4a423",
".R c #e5770b",
"bc c #e58915",
"a4 c #e69a2e",
"aX c #e6b654",
".9 c #e8730b",
"cu c #e89f3b",
"aZ c #eb9521",
"a2 c #ec961a",
"#H c #ecbd4f",
".W c #ed820e",
".I c #edbc26",
"aY c #eeaf39",
"aK c #eecc62",
"ci c #f1b770",
"aM c #f2a42c",
"#D c #f2b82d",
"az c #f2bf35",
"ai c #f2d658",
".8 c #f49d19",
"as c #f4d574",
"av c #f5a82c",
"aA c #f5c768",
".Q c #f6af1f",
"#4 c #f6dc79",
"a# c #f6dd71",
"#3 c #f6e05c",
"aP c #f7aa22",
".y c #f7df37",
".J c #f7ee3c",
".u c #f7ee3d",
"aL c #f8c548",
".O c #f8e442",
".x c #f8e73c",
"#P c #f8ea80",
".w c #f8ed42",
".v c #f8f041",
".K c #f8f546",
"ad c #f9a827",
".z c #f9d631",
"at c #f9d655",
".P c #f9d934",
"#O c #f9ec77",
"#Q c #f9ed7c",
".0 c #f9f551",
".L c #f9f552",
"#a c #facf31",
"#r c #fad93d",
"aa c #fadb56",
".V c #fae6c6",
"#N c #faec5f",
".N c #faed4f",
".M c #faf357",
"#e c #faf359",
"#E c #fbb425",
"ay c #fbb92b",
"ag c #fbc535",
"#0 c #fbcd3b",
"aj c #fbcf77",
"ah c #fbd345",
"#2 c #fbe154",
".4 c #fbea54",
"#M c #fbea55",
"#R c #fbed72",
"#n c #fca31e",
"#W c #fcb72c",
"ac c #fcc23c",
"#V c #fcc73b",
"au c #fcca49",
"#U c #fcd648",
"#J c #fcdc48",
"#1 c #fcdc4d",
"#K c #fce34f",
"#L c #fce651",
"#A c #fce658",
"#S c #fce961",
"#i c #fcef63",
"#v c #fcf15e",
".d c #fcf4b4",
".1 c #fcf664",
"cs c #fdae2e",
"aR c #fdb348",
"cl c #fdc367",
"ab c #fdd44e",
"#T c #fde156",
".k c #fdebb1",
".3 c #fdf366",
".2 c #fdf66c",
"#f c #fdf66f",
"#Y c #fec981",
"b5 c #fecf37",
"#. c #fecf8f",
".c c #fed89e",
".l c #fef1d7",
"#z c #fef26c",
"#w c #fef571",
"#h c #fef572",
"#g c #fef675",
"#y c #fef676",
"#p c #fef7e4",
"aF c #ff8a00",
"aE c #ff8a01",
"aG c #ff8b02",
"aC c #ff9615",
"an c #ff9c20",
"ao c #ff9d22",
"am c #ff9f24",
"aI c #ff9f25",
"ap c #ffa22b",
"al c #ffa834",
"aq c #ffaf41",
"bR c #ffcd43",
"cn c #ffd08b",
"co c #ffd28b",
"cr c #ffd37d",
"cm c #ffd39a",
"cp c #ffd68b",
"cq c #ffdb8b",
"bB c #ffe3a8",
"#G c #fff3e3",
"#x c #fff677",
"b6 c #fffcf0",
"Qt c #ffffff",
"Qt.#.a.b.c.d.e.f.g.h.i.j.k.l.m.n.oQt",
"Qt.p.q.r.s.t.u.v.w.x.y.z.A.B.C.D.EQt",
"Qt.F.G.H.I.J.K.L.M.N.O.P.Q.R.S.T.UQt",
"Qt.V.W.X.Y.Z.0.1.2.3.4.5.6.7.8.9#.Qt",
"Qt###a#b#c#d#e#f#g#h#i#j#k#l#m#n#oQt",
"#p#q#r#s#t#u#v#w#x#y#z#A#B#C#D#E#F#G",
"#H#I#J#K#L#M#N#O#P#Q#R#S#T#U#V#W#X#Y",
"#Z#0#1#2#3#4#5#6#7#8#9a.a#aaabacadae",
"afagahaiajakalamanaoapaqarasatauavaw",
"axayazaAaBaCaDaEaFaFaGaHaIaJaKaLaMaN",
"aOaPaQaRaSaTaUaVaFaFaVaUaDaWaXaYaZa0",
"a1a2a3a4a5a6a7a6aFaFa6a7a6a8a9b.b#ba",
"bbbcbdbebfbga6aFaFaFaFa6bhbibjbkblbm",
"bnbobpbqbrbsbtbububua5bvbwbxbybzbAbB",
"QtbCbDbEbFbGbHbIbJbKbLbMbNbObPbQbRQt",
"QtQtbSbTbUbVbWbXbYbZb0b1b2b3b4b5b6Qt",
"QtQtb7b8b9c.c#c#cacbcccdcecfcgchQtQt",
"QtQtcicjckclcmcncocpcqcrcsctctcuQtQt"};

static const char* const image122_data[] = { 
"18 18 22 1",
"m c #000000",
"s c #1c1c1c",
"b c #3d4e65",
"i c #565656",
"# c #607696",
"o c #696969",
"r c #6b7b8b",
"q c #777777",
"t c #90a8ca",
"a c #9cb3d3",
"l c #a8a8a8",
"k c #afc8e5",
"g c #b9b9b9",
"c c #bad0e9",
"n c #bfd4ed",
"j c #cccccc",
"f c #d6e9fc",
"e c #dfb1ae",
"d c #ed9b95",
"h c #f4f8fc",
"p c #fefefe",
". c #ffffff",
"..###........###..",
".#aaa#......#aaab.",
"#cddaa#....#aaddab",
"#ceeda#....#adeeab",
"#ffeg######aadeefb",
".##f##hhhhhfaffffb",
"...#hhhfffffifbbbj",
"...#hfffffffgbjjj.",
"..#klmnnnlmnfgbj..",
"..#kmmkkkmmknfkbj.",
"..iookkkkkkfffkbj.",
".#opqbkffrrrffkbj.",
"#hoqsbkffffffktbj.",
"#hkbbkfffrrrkktbj.",
"#ffkkffffffkkttbj.",
"#kkfffffkkikttbj..",
".bkkkkkkkittbbj...",
"..bbbbbbbbbbjj...."};

static const char* const image123_data[] = { 
"18 18 96 2",
".X c #000000",
".K c #5c2000",
".G c #5d2100",
".T c #622400",
".O c #6c2a00",
"#B c #771300",
"#A c #791500",
"#w c #831800",
"#q c #841900",
".j c #851f06",
".m c #871f05",
".l c #882006",
".k c #892006",
"#k c #8a1b00",
"#f c #8d1d00",
".u c #8d2207",
"#a c #8e1d00",
"#D c #942100",
".s c #962809",
".A c #9c2f0c",
".C c #a0310d",
".8 c #a93100",
".3 c #ac3400",
"#. c #ad3400",
".2 c #ae3600",
".e c #af3500",
".y c #af3600",
".i c #b03500",
".d c #b03601",
"#z c #b04c00",
".# c #b13701",
".a c #b23802",
"#t c #b24e00",
".c c #b33903",
".f c #b43a05",
".b c #b53d07",
"#y c #b65200",
"#C c #b75400",
".9 c #b9470f",
"#x c #b95600",
"#v c #c75600",
"#u c #c85700",
".7 c #c86a00",
".W c #c96e00",
"#r c #cf6100",
"#s c #d16500",
"#h c #d26700",
"#p c #d56d00",
"#o c #d67000",
"#e c #d67100",
"#d c #d87600",
"#l c #d97600",
"#m c #da7700",
"#c c #da7800",
"#g c #da7900",
"#b c #db7a00",
"#n c #db7b00",
"#j c #db7c00",
".6 c #db7d00",
".F c #dc8100",
".R c #dd8300",
".V c #de8200",
".w c #de8300",
".E c #de8600",
".n c #df8600",
".h c #df8900",
".q c #e08900",
".v c #e08c00",
".S c #e39300",
".L c #e49700",
".M c #e49c00",
".N c #e59c00",
".x c #f1a700",
".p c #f1a800",
".1 c #f1a900",
".U c #f2b000",
".J c #f3b100",
".Q c #f3b500",
".r c #f4b700",
".z c #f4b800",
".P c #f4b900",
".t c #f5ba00",
".D c #f5be00",
".B c #f5bf00",
".H c #f5c000",
"#i c #faf8f8",
".5 c #fbefd2",
".Z c #ffa198",
".0 c #ffbbb5",
"## c #ffca49",
".4 c #ffcd50",
".o c #ffd054",
".g c #ffd056",
".I c #ffdb79",
".Y c #fffaef",
"Qt c #ffffff",
"Qt.#.a.bQtQtQtQt.c.d.eQtQtQtQtQtQtQt",
".f.g.h.i.j.k.l.m.n.o.p.eQtQtQtQtQtQt",
".f.q.i.r.s.t.u.v.v.w.x.yQtQtQtQtQtQt",
"Qt.i.z.A.B.C.D.r.v.E.F.iQtQtQtQtQtQt",
"Qt.G.H.H.H.I.D.r.J.E.#QtQtQtQtQtQtQt",
"Qt.K.L.M.N.O.P.Q.q.R.#QtQtQtQtQtQtQt",
"Qt.E.S.S.r.T.Q.U.V.W.yQtQt.f.f.fQtQt",
".a.X.Y.U.r.Z.0.1.W.2QtQt.3.4.4.4.fQt",
".y.Y.Y.5.r.P.1.6.7.8Qt.3.4.1.1.1.4.9",
"#..5.5.P.1.1.6.7.8Qt.3##.1#a.9#b.1#a",
"Qt#.#.#.#.#.#c#d#eQt.3.1#f#g#a#b#h#a",
"QtQtQt#..D#i#i.D#j.8##.1#k#l#m#h#h#a",
"QtQt#..D#j#i.D#j#j#n.1#o#p#q#r#s#aQt",
"QtQt#.#j#j#i#j#j#h#g#t#u#s#v#w#kQtQt",
"QtQtQt#.#.#j#x#x#x#y#z#A#B#BQtQtQtQt",
"QtQt#.#.#j#a#.#.#j#C#qQtQtQtQtQtQtQt",
"QtQt#.#j#j#a#j#j#j#DQtQtQtQtQtQtQtQt",
"QtQtQt#.#.#.#a#a#aQtQtQtQtQtQtQtQtQt"};

static const char* const image124_data[] = { 
"18 18 160 2",
"aw c #4d2fb0",
"az c #5037a7",
"as c #5130b2",
"ay c #5137a8",
"aC c #5437b5",
"ax c #5639b5",
"aB c #563bb5",
"aA c #573bb5",
"av c #583bb6",
".t c #5a1600",
".6 c #681c00",
"#v c #692200",
"#c c #6a2200",
"#G c #702402",
"#S c #733d1d",
"#7 c #753e20",
"#u c #772900",
"#3 c #773f20",
"#5 c #794020",
".s c #7b1600",
"ag c #7d4521",
"af c #7e4621",
"au c #8657bb",
"at c #885bbb",
"aD c #8c5ccd",
"#A c #a84800",
"#q c #a94b00",
"#e c #ac4e00",
".4 c #ae5500",
"ab c #b04e00",
"#g c #b14c07",
".d c #b15600",
".h c #b42500",
".3 c #b46000",
".a c #b66700",
".b c #b66800",
".q c #b76900",
".e c #b96f00",
".# c #ba7000",
"#Z c #c09709",
".F c #ca5600",
".Q c #cb5b00",
"aa c #cba628",
".g c #d03d00",
"#H c #d06c09",
"#F c #d06d09",
"#T c #d17209",
"#U c #d17409",
".o c #d19315",
".R c #d26d00",
".2 c #d26f00",
"#R c #d27309",
".E c #d56900",
".i c #d5a115",
".r c #d66c00",
"#8 c #d67e09",
".c c #d6a83b",
"#4 c #d98414",
"#6 c #d98811",
"#I c #db8309",
"ao c #db850f",
"ad c #dc830f",
"ai c #dc8411",
"#V c #dc8509",
"an c #dc850f",
"ah c #dc8811",
"al c #df8200",
"a# c #df8400",
"ae c #df8a11",
"#Q c #df8c09",
"#9 c #df8d09",
"ac c #e08500",
"am c #e08a0f",
"aq c #e08a14",
"ak c #e08c09",
"ap c #e08c14",
"#2 c #e08e09",
"#J c #e09614",
"#w c #e09e21",
"ar c #e18f09",
"#W c #e19b14",
"aj c #e3940c",
"#E c #e39c14",
"#P c #e39d14",
"#K c #e3a120",
"#1 c #e4a315",
"#0 c #e59d00",
"a. c #e5a720",
"#x c #e5a928",
"#t c #e5ad32",
"#D c #e8af36",
"#y c #e8b130",
".p c #e97e00",
".f c #ea8f09",
".G c #eab617",
".P c #eaba2e",
"#r c #eaba40",
".5 c #eabc2e",
"#z c #eabc3e",
"#n c #eac040",
"#s c #eac24b",
".u c #edc02b",
"#d c #edc03d",
"#f c #efbc31",
"#p c #efbc42",
".D c #efc23b",
"#o c #efc24a",
"#m c #efc446",
"#b c #efc456",
".S c #efc74b",
".1 c #efc855",
".v c #f1c631",
".C c #f1c83b",
"#l c #f1cc4c",
"#k c #f1cc4e",
".O c #f1cc55",
"#h c #f1cc5b",
".0 c #f2cc5b",
"#i c #f2cc5f",
"#j c #f2cd54",
".7 c #f2d06c",
".B c #f2d45f",
".N c #f2d465",
".n c #f3d356",
".H c #f3d361",
".Z c #f3d36a",
"#a c #f3d566",
".T c #f3d679",
".j c #f5d34d",
".w c #f5d567",
".8 c #f5d880",
"## c #f5dd71",
"#. c #f6dd79",
".A c #f6dd80",
".I c #f6e195",
".Y c #f6e281",
".k c #f7dd78",
".9 c #f7dd82",
".l c #f7e186",
".x c #f7e28a",
".m c #f8dd7f",
".M c #f8de88",
".z c #f8e18e",
".U c #f8e298",
".y c #f8e598",
".X c #f8e996",
".L c #f9e9a3",
".V c #f9eba8",
".W c #faeaa4",
".J c #faecaf",
".K c #faecb2",
"#X c #fb5f64",
"#Y c #fb6568",
"#N c #fb766d",
"#L c #fb7b79",
"#O c #fb8079",
"#M c #fb8282",
"#B c #fb9f91",
"#C c #fb9f93",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"Qt.#.a.bQt.c.d.d.d.d.d.d.cQt.b.a.#Qt",
".e.f.g.h.b.i.j.k.l.m.k.n.o.b.h.g.p.q",
".b.r.s.t.u.v.w.x.y.z.A.B.C.D.t.s.E.q",
".a.F.t.G.u.H.I.J.K.L.M.N.O.D.P.t.Q.q",
".q.R.q.G.S.T.U.V.W.X.Y.Z.0.1.P.b.2.q",
"Qt.3.4.5.6.7.8.9#.###a.0#b#c#d.4.3Qt",
"QtQt#e#f#g#h#i#j#k#l#m#n#o#g#p#eQtQt",
"QtQt#q.P#r#s#t#c#u#v#w#x#y#r#z#eQtQt",
"QtQt#A#B#C#D#E#F#G#H#I#J#K#L#M#eQtQt",
"QtQt#A#N#O#P#Q#R#S#T#U#V#W#X#Y#AQtQt",
"QtQt#Z#0#1#2#3#4#5#6#7#8#9a.a#aaQtQt",
"QtQtQtabacadaeafafagahaiajakabQtQtQt",
"QtQtQtQt.dalamananaoapaqarabQtQtQtQt",
"QtQtQtQtQt.dasatapapauavabQtQtQtQtQt",
"QtQtQtQtQtQtawaxayazaAaBQtQtQtQtQtQt",
"QtQtQtQtQtQtaCaDQtQtaDaBQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image125_data[] = { 
"18 18 103 2",
".2 c #007654",
".j c #241b09",
".u c #292009",
".i c #312511",
".s c #3a2f15",
".t c #3c2f17",
".h c #3f341a",
".a c #40361b",
".G c #413517",
".e c #41361b",
".B c #43371d",
".# c #44371d",
".V c #45371b",
".g c #46371d",
".f c #473820",
".3 c #594c2d",
"#t c #5d4f30",
".8 c #655631",
"#K c #71653b",
"#i c #736543",
".9 c #776846",
"#o c #776947",
"#n c #78694a",
".6 c #827547",
"#a c #877754",
".Z c #887b4e",
"#j c #8a7e5b",
"#E c #8d7e55",
"## c #908157",
"#q c #90845b",
"#F c #90845f",
"#v c #91855c",
".1 c #928460",
"#z c #978961",
".S c #9c9069",
"#h c #9f9274",
"#D c #a19375",
"#k c #a2956f",
"#C c #a29575",
"#y c #a29576",
".4 c #a39778",
".k c #a59778",
".c c #a89d73",
"#l c #aca37f",
".M c #b6ad8c",
"#f c #b6ad8f",
"#c c #b9b193",
".U c #bab395",
"#e c #bfb69c",
"#d c #c2b89e",
".X c #c4bda6",
".r c #c8bea7",
".l c #cbc2a9",
".v c #cbc2ab",
".d c #cbc4ad",
".b c #cdc5b0",
".0 c #cdc8b0",
".7 c #d0c8b1",
".q c #d1ccb5",
".W c #d2cdb8",
".C c #d2ceb9",
".T c #d6cebc",
"#G c #d6cfbb",
".m c #d9d4bf",
"#H c #d9d4c1",
"#I c #dad5c3",
".F c #dcd6c5",
"#J c #dcd7c6",
".Y c #dcd8c6",
"#w c #dcd8c7",
".A c #dcd8c8",
".5 c #dcd9c8",
"#A c #e0dbca",
"#. c #e0dccd",
".p c #e0ddce",
".o c #e3ded0",
"#B c #e4ded2",
".R c #e4ded3",
".n c #e4e2d3",
"#u c #e5e2d4",
".w c #e5e2d7",
"#s c #e8e3d8",
".z c #e8e5d8",
"#x c #e9e6d8",
".N c #e9e6da",
"#r c #eae7da",
".y c #eae9de",
".L c #eaeae0",
"#m c #edebe0",
"#g c #efebe2",
"#p c #efece3",
".x c #efece4",
".K c #f1efe7",
".J c #f2f0e7",
"#b c #f2f0e9",
".D c #f3f2ea",
".E c #f6f3ef",
".H c #f7f5f1",
".I c #f8f7f2",
".Q c #faf9f7",
".P c #fafaf7",
".O c #fbfbfa",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"Qt.#.a.aQt.b.c.c.c.c.c.dQt.e.f.fQtQt",
".g.h.i.j.k.l.m.n.o.p.q.r.k.s.g.f.fQt",
".g.t.u.v.w.x.y.y.y.y.y.z.A.v.B.f.fQt",
".f.a.C.x.D.E.E.E.E.E.E.E.x.y.F.f.fQt",
".g.G.F.D.H.I.I.I.I.I.I.J.K.L.F.g.GQt",
"Qt.M.N.y.f.f.O.P.Q.Q.I.f.f.R.y.MQtQt",
".S.T.U.V.W.W.f.O.Q.Q.f.W.W.f.X.Y.SQt",
".Z.0.1.g.W.2.f.P.Q.Q.3.2.W.f.4.5.6Qt",
".6.7.8.9.f.f.Q.Q.I.I.H.f.f.9.9#..6Qt",
"##.7#a.9.4#b#c#d#e#e#f#g#h#i#j#.##Qt",
"#k#l#m.K#b.D#n.f.f.f#o#p.L.y.N#l#kQt",
"Qt#q.p#r#p.K#s#t#t#t#s.y.y.L#u#vQtQt",
"Qt#v#w#x.L#y.L.L#y.y.y#y.L.L#u#vQtQt",
"QtQt#z#A#B.L#C#D#y#y#y.L#u#u#zQtQtQt",
"QtQtQt#E#F#G#H#I#J#J#w#w#E#EQtQtQtQt",
"QtQtQtQtQt#K#K#K#K#K#K#KQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image126_data[] = { 
"18 18 66 2",
".Q c #2a1c1b",
".P c #2a201d",
".E c #2b201d",
".X c #2c2120",
".U c #6b5d5b",
".1 c #6d5455",
".Z c #6f615f",
"## c #716562",
".9 c #756864",
".6 c #776966",
".a c #786a67",
"#. c #7a6c69",
".# c #7c706c",
".i c #8a4e57",
".n c #9e928d",
".m c #9f938e",
".J c #a79d98",
".8 c #aea6a1",
".7 c #b0a8a3",
".t c #bab4b0",
".p c #bdb5b1",
".u c #bfb7b3",
".o c #bfb8b4",
".v c #c3bcb6",
".l c #c43653",
".d c #c4bdb9",
".B c #c4beba",
".w c #c7c0bb",
".2 c #c7c1bc",
".k c #c9405c",
".C c #c9c0bb",
".3 c #c9c1bc",
".x c #c9c2bd",
".h c #ca4762",
".D c #cac3be",
".L c #cbc4c1",
".g c #cd566d",
".T c #cdc8c5",
".j c #d0576f",
".r c #d0cac6",
".s c #d0ccc7",
".f c #d16077",
".e c #d16479",
".4 c #d1ccc8",
".5 c #d1cdc8",
".0 c #d2ceca",
".M c #d2cecb",
".c c #d5d0ce",
".A c #d5d3ce",
".y c #d6d3ce",
".q c #d9d5d3",
".F c #dad6d4",
".K c #dbd8d5",
".b c #dcd9d7",
".N c #dcdbd8",
".O c #e0deda",
".S c #e1dede",
".V c #e3e1de",
".R c #e5e3e2",
".z c #e9e5e3",
".I c #eae6e4",
".G c #eae7e6",
".W c #eae9e7",
".Y c #eaebe9",
".H c #f2f2f0",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQt.#.#.aQtQtQtQtQtQtQt.#.#.#QtQtQt",
"Qt.#.b.c.d.#QtQtQtQtQt.#.d.c.b.#QtQt",
".#.b.b.e.f.d.#QtQtQt.#.d.f.e.b.b.#Qt",
".#.c.e.g.h.i.#QtQtQt.#.i.h.g.e.c.#Qt",
".#.d.j.k.l.#.m.#.#.#.n.#.l.h.j.d.#Qt",
"Qt.#.d.i.#.o.p.q.r.s.t.u.#.i.d.#QtQt",
"QtQt.#.#.v.w.x.y.z.A.B.C.v.#.#QtQtQt",
"QtQtQt.#.D.E.F.G.H.I.F.E.D.#QtQtQtQt",
"QtQtQt.#.s.J.K.H.H.H.K.J.s.#QtQtQtQt",
"QtQt.#.L.M.N.O.P.Q.P.R.S.c.T.#QtQtQt",
"Qt.U.U.v.c.V.W.H.X.H.H.Y.K.F.#.#QtQt",
"QtQt.Z.v.0.1.H.H.1.H.H.1.F.F.#QtQtQt",
"Qt.U.U.v.2.3.1.1.1.1.1.4.5.v.#.#QtQt",
"QtQtQt.#.v.3.6.H.H.H.6.4.v.#QtQtQtQt",
"QtQtQtQt.#.v.7.6.6.6.8.v.#QtQtQtQtQt",
"QtQtQtQtQt.#.9#..6##.#.#QtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image127_data[] = { 
"18 18 42 1",
"y c #000000",
"k c #502200",
"E c #513800",
"u c #582800",
"N c #634700",
"D c #7e630c",
"# c #858585",
"e c #8c4b00",
"d c #9c5600",
"w c #a45e00",
"B c #a55f00",
"x c #a8a8a8",
"n c #aa5c02",
"F c #ac9036",
"H c #b49841",
"K c #b8a66c",
"o c #b9710d",
"f c #bc7610",
"c c #c27e15",
"v c #c6c6c6",
"J c #e5b934",
"L c #e5ca75",
"b c #ebebd8",
"G c #ecc859",
"m c #edb543",
"I c #f2d888",
"g c #fedb98",
"t c #ff9200",
"A c #ff9800",
"C c #ff9900",
"s c #ffac36",
"j c #ffc147",
"z c #ffc34e",
"h c #ffc85b",
"l c #ffc95c",
"r c #ffca56",
"M c #ffdc6d",
"q c #ffe18a",
"p c #ffe79d",
"i c #fffee0",
"a c #ffffea",
". c #ffffff",
"......#....#......",
".....#a#..#a#.....",
".....#b#..#b#.....",
"ccc..cccccccd..eee",
"fghcciiiiiiijkelme",
".nociiippqrjstueev",
"...wixyzzzzxyAuvv.",
"...BiyyCCCCyyCuv..",
"...BpllCCCCCCCuv..",
"...DDDCCCCCCEEEv..",
"..FiiiDGGGGDiiiEv.",
".FiHDppIIIIiiDHJEv",
".FiHKDppIIpiDKHJEv",
".FpppLppppppLppJEv",
".FJpppppppppppJJEv",
"..DJJJDDDDDDJJJEv.",
"...DDDJMMMMJEEEv..",
"......NNNNNNvvv..."};

static const char* const image128_data[] = { 
"18 18 115 2",
".3 c #3f0e0e",
"#. c #654100",
".U c #6b4300",
".n c #732500",
".# c #774300",
".g c #774400",
".o c #784500",
".a c #794200",
"#p c #7a1f00",
".w c #7a2b00",
"#h c #7a5000",
".4 c #7c0000",
".v c #7c2b00",
".E c #7f2c00",
".x c #7f4c00",
".c c #804500",
".F c #805200",
".f c #834800",
".e c #834900",
"#d c #840000",
".d c #844800",
".j c #874c00",
".5 c #880000",
"#D c #8f3000",
".1 c #8f3400",
".0 c #973900",
".T c #993800",
".u c #9d3200",
".M c #9e3600",
".y c #9f4b00",
".L c #a23800",
".K c #a63d00",
"#v c #a67500",
"#q c #a73000",
"#i c #ac5100",
"#W c #b78100",
"#U c #b98400",
"#Q c #bb8300",
"## c #bd5900",
".2 c #bd5a00",
"#C c #bf6340",
"#j c #c25800",
".V c #c76a00",
"#E c #cd4600",
".N c #cd7100",
".r c #cf6500",
"#r c #d45d2d",
"#w c #d7500e",
"#K c #d76300",
"#a c #d86000",
"#S c #d86500",
".t c #de4e12",
"#b c #e07800",
".J c #e55c19",
"#F c #e76513",
"#c c #e78100",
"#x c #e99300",
"#k c #e99400",
".p c #eb6708",
".q c #eb6909",
".b c #ececec",
".m c #ed700b",
".Z c #ee8815",
"#y c #efad00",
"#T c #f08324",
"#g c #f0bab0",
".S c #f18313",
"#f c #f1bab1",
"#J c #f1eeeb",
".D c #f28110",
"#L c #f2881c",
".s c #f29b00",
".P c #f3ae00",
".Q c #f3b000",
"#z c #f3bd00",
"#V c #f3be00",
".W c #f48006",
".z c #f4a000",
".H c #f4a800",
".I c #f4ac00",
".i c #f57b04",
".O c #f58506",
".G c #f68105",
".9 c #f7a500",
".8 c #f7ac00",
"#e c #f7af00",
".7 c #f7b100",
".h c #f8b700",
"#G c #f8d100",
"#n c #f9a293",
"#M c #f9cb00",
"#l c #fab800",
"#N c #fad200",
"#H c #fad300",
"#o c #fbb3a5",
".C c #fbb500",
".B c #fbb700",
"#m c #fbbc00",
".R c #fbbf00",
".A c #fbce00",
"#O c #fbd900",
".6 c #fcb500",
".Y c #fcbd00",
"#R c #fccb0c",
".X c #fce117",
"#A c #fdd100",
"#B c #fdd300",
"#s c #fec80a",
"#I c #fee000",
"#P c #fee400",
".k c #ffb000",
".l c #ffb300",
"#u c #ffd70d",
"#t c #ffd717",
"Qt c #ffffff",
"Qt.#.a.bQt.c.d.e.f.e.d.c.bQt.a.#.bQt",
".g.h.i.f.j.k.l.m.n.m.l.k.j.f.i.h.g.b",
".o.p.q.r.s.t.u.v.w.v.u.t.s.r.q.p.o.b",
"Qt.x.y.z.A.B.C.D.E.D.C.B.A.z.y.x.bQt",
"Qt.F.G.H.I.J.K.L.M.L.K.J.I.H.G.F.bQt",
".F.N.O.P.Q.R.B.S.T.S.B.R.Q.P.O.N.F.b",
".U.V.W.I.X.Y.Z.0.1.0.Z.Y.X.I.W.V.U.b",
".U.2.3.4.5.6.7.8.9.8.7.6.5.4.3.2.U.b",
"#.###a#b#c#d#e#f#g#f#e#d#c#b#a###..b",
"#h#i#j#k#l#m#m#n#o#n#m#m#l#k#j#i#h.b",
"#h#p#q#r#s#t#u#n#o#n#u#t#s#r#q#p#h.b",
"#v#w#x#y#z#A#B#C#C#C#B#A#z#y#x#w#v.b",
"#v#D#E#F#G#H#I#J#K#J#I#H#G#F#E#D#v.b",
"Qt#v#L#M#N#O#P#J#K#J#P#O#N#M#L#v.bQt",
"QtQt#Q#z#R#R#S#S#T#S#S#R#R#z#Q.bQtQt",
"QtQtQt#U#V#z#R#I#I#I#R#z#V#U.bQtQtQt",
"QtQtQtQt#W#W#V#V#V#V#V#W#W.bQtQtQtQt",
"QtQtQtQtQtQt#W#W#W#W#W.b.bQtQtQtQtQt"};

static const char* const image129_data[] = { 
"18 18 86 2",
".o c #000000",
".w c #1d4c45",
".I c #376665",
".J c #396665",
".b c #3c5f57",
".c c #42665d",
".N c #6a99a6",
"#j c #6c98a6",
"#p c #6f9aa6",
"#k c #7098a3",
"#t c #7199a3",
".h c #719d9f",
".# c #72b6c5",
".g c #73b5c4",
".K c #7599a3",
".k c #75b7c4",
"#l c #799aa1",
"#c c #7c99a0",
".i c #7c9faa",
"#q c #7e999f",
".L c #81999f",
".Q c #82999f",
".V c #84999e",
".G c #84a9b2",
"#r c #859a9f",
".R c #879a9e",
".H c #879b9e",
".C c #87a9b1",
".M c #8a9b9e",
"#s c #8a9b9f",
".z c #9dacb0",
".D c #9dadb0",
".X c #9fadb0",
".B c #b00000",
".e c #bcd1da",
".Y c #bedfe8",
".S c #c0dfe6",
"#i c #c1d7df",
".O c #c3dfe6",
".2 c #ced6d8",
".P c #cedae1",
".u c #cfdfe1",
"#a c #cfe2e8",
".U c #d0dbe1",
".v c #d0dfe1",
"#o c #d0dfe6",
".F c #d1dddf",
".E c #d3dddf",
"#n c #d6dcdf",
"#e c #d7dcdf",
".W c #d8dddf",
".l c #d9e2ed",
"#g c #d9e6ef",
".f c #e4eef9",
".Z c #e4f0f2",
".7 c #e4f2f2",
".8 c #e5eff0",
"#b c #e6f2f2",
".0 c #e8f0f0",
".6 c #e8f2f5",
".T c #e9f2f2",
".1 c #eaf0f2",
".A c #ebf0f4",
".9 c #ebf2f2",
".x c #ecf2f5",
".5 c #ecf5f5",
".y c #edf0f5",
"#h c #eef5f7",
".4 c #eef7f7",
"#. c #eff2f2",
"#d c #eff2f3",
".p c #eff3f7",
".q c #eff5f7",
"#m c #f0f3f4",
".t c #f0f4f8",
".s c #f0f5f7",
".3 c #f0fbfb",
".m c #f2f7fb",
".n c #f3f6fb",
".j c #f4f8fb",
"## c #f4fbfe",
"#f c #f7fefe",
".r c #fde9da",
".d c #ffbd6f",
".a c #ffdfbe",
"Qt c #ffffff",
"Qt.#.#QtQtQtQtQtQtQtQt.#.#QtQtQtQtQt",
".#.a.a.#.b.c.c.c.c.#.#.a.a.#QtQtQtQt",
".#.a.d.e.f.f.c.f.f.f.e.d.a.gQtQtQtQt",
".#.d.e.f.h.h.h.i.h.j.f.e.d.kQtQtQtQt",
"Qt.#.l.f.m.n.h.n.n.n.f.l.#QtQtQtQtQt",
"Qt.#.l.o.p.q.r.s.t.q.o.l.gQtQt.u.vQt",
"Qt.#.l.w.x.r.r.r.y.y.w.l.kQtQt.v.zQt",
"Qt.i.l.A.A.B.B.B.A.A.A.l.CQtQt.D.E.F",
"Qt.i.i.l.A.A.B.A.A.l.l.G.CQtQtQt.E.H",
"Qt.G.e.l.G.I.I.I.G.l.l.e.J.K.LQt.M.F",
"QtQt.N.e.l.l.l.l.l.l.e.I.O.P.Q.R.E.H",
"QtQtQt.G.N.N.N.N.N.N.N.S.T.U.V.W.X.H",
"QtQtQtQt.N.Y.Y.Y.Y.Y.Y.Z.0.1.2.W.E.V",
"QtQtQt.N.3.4.5.6.N.7.Z.8.0.9#..W.HQt",
"QtQt.N###a.N.N.N#b#b.7.T#c.V#d#e.VQt",
"Qt.N#f#g.NQt.N#h#i#j#k#l#d#m#e#n.LQt",
"Qt.N.N.NQt.N.3#o#pQtQt#q#r.M#s.VQtQt",
"QtQtQtQtQt.N#j#tQtQtQtQtQtQtQtQtQtQt"};

static const char* const image130_data[] = { 
"18 18 66 2",
".N c #5d0200",
".Z c #901614",
".c c #bd524c",
".n c #c95f5b",
".O c #cb201d",
".b c #d05653",
".7 c #d05d56",
".8 c #d05d58",
".9 c #d05e59",
".a c #d15c58",
".# c #d15d59",
".z c #d1615c",
".g c #d1625e",
".A c #d1645f",
".6 c #d1655f",
".t c #d2645f",
".B c #d26560",
".e c #d26762",
"#. c #d26a65",
".J c #d46d69",
".E c #d4716c",
".y c #d56d69",
".Q c #d5706a",
".j c #d5716c",
".m c #d6716c",
".v c #d6736d",
".I c #d6746f",
".0 c #d6756d",
".q c #d67570",
".5 c #d67670",
".l c #d67671",
".2 c #d67773",
".r c #d77a75",
".1 c #d77b76",
".o c #d77e78",
".4 c #d97e79",
"## c #d9817c",
".3 c #d9837e",
".W c #e96b66",
".L c #ef918a",
".U c #f2c6c1",
".k c #f8817c",
".Y c #f9706a",
".f c #fe928c",
".S c #ff0200",
".u c #ff1b38",
".w c #ff5f8e",
".R c #ff9da7",
".x c #ff9e97",
".p c #ffa9a4",
".s c #ffbcb6",
".F c #ffd0ce",
".h c #ffd3ce",
".T c #ffd5d3",
".d c #ffd6d4",
".K c #ffdcd8",
".C c #ffddda",
".X c #ffdede",
".i c #ffe9e7",
".D c #ffebe9",
".V c #ffecea",
".P c #ffefed",
".G c #fff3f2",
".H c #fff5f4",
".M c #fff6f4",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQtQt.#.a.bQtQtQtQt",
"QtQt.c.c.cQtQtQtQtQt.#.d.d.d.eQtQtQt",
"Qt.c.f.f.f.cQtQtQtQt.g.h.i.h.jQtQtQt",
".c.f.f.k.k.c.lQtQtQt.m.d.n.h.oQtQtQt",
".c.f.k.k.c.p.qQtQtQt.r.s.t.s.oQtQtQt",
"Qt.c.c.c.u.p.vQtQtQt.v.s.w.s.oQtQtQt",
"QtQt.o.x.p.p.yQtQt.z.p.s.s.s.oQtQtQt",
"QtQt.o.o.s.s.p.A.t.B.p.s.s.o.oQtQtQt",
"Qt.o.s.s.C.C.C.C.C.C.C.C.s.s.s.oQtQt",
"Qt.r.s.C.C.i.i.D.D.D.i.i.C.C.s.oQtQt",
".E.s.F.G.G.i.i.D.H.D.i.i.G.G.F.s.IQt",
".J.F.K.L.L.i.i.M.G.M.i.i.L.L.K.F.JQt",
".J.F.K.N.O.P.P.P.P.P.P.P.N.O.K.F.QQt",
".Q.R.R.N.S.P.P.T.U.T.G.V.O.S.R.R.WQt",
"Qt.j.R.R.X.V.Y.T.Z.T.Y.V.X.R.R.0QtQt",
"Qt.1.R.R.X.V.Y.Y.T.Y.Y.X.X.R.R.2QtQt",
"QtQt.o.o.T.V.V.V.V.V.V.V.T.3.4QtQtQt",
"QtQtQtQt.1.5.6.7.8.9#..4##QtQtQtQtQt"};

static const char* const image131_data[] = { 
"18 18 90 2",
".Y c #000000",
"#t c #126000",
"#o c #136000",
".H c #236900",
".U c #236a00",
"#f c #246b00",
".t c #2c7000",
".X c #327300",
".8 c #397800",
"#w c #3a7b00",
"#u c #3e7c00",
".f c #3f7000",
"#x c #3f7e00",
".J c #407500",
".e c #417200",
".i c #436500",
".g c #457500",
".M c #457a00",
".h c #476800",
".d c #4d7b00",
".j c #4e6d00",
".I c #4e9100",
"#h c #4ed000",
".c c #517e00",
".r c #547200",
"#c c #547600",
".L c #549500",
".s c #557300",
".n c #588800",
"#g c #5aa700",
"#j c #5fa800",
".2 c #5fb100",
".v c #608c00",
"#i c #61a900",
".9 c #62b400",
".l c #62be00",
"#b c #63b400",
".7 c #65b400",
".F c #699000",
".z c #6ab500",
"#n c #6c9500",
".k c #6cb700",
".B c #6dbb00",
".K c #6dca00",
".R c #70c000",
"#q c #71bd00",
".o c #73a300",
"#k c #73b800",
".q c #74c300",
".Q c #75c300",
".x c #77c100",
".y c #77c600",
".p c #77c700",
".m c #78a600",
".S c #7bc800",
"#p c #7da700",
".D c #7dc600",
"#s c #7fa800",
".A c #7faa00",
".w c #7fcf00",
".C c #80cc00",
".N c #80d300",
".G c #82d700",
".Z c #86e200",
".u c #87dc00",
".5 c #8ade00",
".0 c #8ce600",
".E c #8dd700",
".V c #8ddb00",
"#v c #92c000",
".T c #92dc00",
"#d c #95e100",
".3 c #98de00",
".1 c #9ce500",
".6 c #9fe900",
".4 c #b8e502",
"#l c #bc1007",
"#a c #c3f800",
"#e c #c4f700",
"## c #cbf800",
".W c #ccd936",
"#. c #e4ff21",
".O c #e9f79b",
".P c #f3ffb8",
".b c #fe2000",
".a c #fe6100",
".# c #fe8e00",
"#r c #ff2915",
"#m c #fff36a",
"Qt c #ffffff",
"QtQt.#QtQtQtQtQtQtQtQtQtQtQt.#QtQtQt",
"QtQt.a.aQtQtQtQtQtQtQtQtQt.a.aQtQtQt",
"QtQtQt.a.bQt.c.d.e.f.gQt.b.aQtQtQtQt",
".h.i.j.a.b.k.l.m.n.o.p.q.b.a.r.r.sQt",
"Qt.t.u.v.w.x.y.z.A.B.C.D.E.F.G.tQtQt",
"Qt.H.I.J.K.x.y.z.A.B.C.D.E.F.L.HQtQt",
"QtQt.t.M.N.O.P.Q.R.S.P.O.T.F.tQtQtQt",
"QtQtQt.U.V.O.W.C.R.C.W.O.T.UQtQtQtQt",
"QtQtQt.X.T.O.Y.Z.R.0.Y.O.1.XQtQtQtQt",
"QtQt.H.2.3.4.4.5.0.5.4.4.6.7.HQtQtQt",
"QtQt.8.9.4#.##.4#a.4###..4.7.8QtQtQt",
"QtQt.8#b.4#c#d.4#e.4#d#c.4.7.8QtQtQt",
"QtQt#f#g#d#h.4.4.4.4.4#h#d#i.8Qt.8Qt",
"#f#c#c#j.B#k#k#d#d#d#k#k.B#i#fQtQt.8",
".8QtQt.8#k.D#l#m#m#m#l.D#k#n#c#f#cQt",
"Qt.8Qt#o#p#q#l#r#r#r#l#q#s#oQtQtQtQt",
"QtQtQtQt#t#u#v#l#l#l#s#u#tQtQtQtQtQt",
"QtQtQtQtQtQt.t#w#x#x#wQtQtQtQtQtQtQt"};

static const char* const image132_data[] = { 
"18 18 156 2",
"#d c #0a4c07",
".5 c #0a4f07",
".4 c #0a5207",
".3 c #0d5b09",
"#q c #0d5c09",
"#r c #0e5b09",
"#o c #0e8307",
"#c c #0eb80f",
"#k c #104c02",
"#E c #105e09",
"#e c #106109",
"#U c #106209",
".6 c #106509",
"ar c #115d07",
"#n c #115d09",
"ah c #116509",
"#V c #116609",
"#H c #116809",
"#u c #116909",
"#f c #117309",
"#t c #11760c",
"#a c #118302",
"#b c #119302",
"#l c #124807",
"ai c #126907",
"#8 c #126b09",
".2 c #126c0c",
".Y c #126d0c",
"#K c #12710c",
".W c #12730c",
"#g c #127a0f",
".Z c #12800c",
"## c #128a02",
"#m c #134007",
"#Q c #136b0c",
".T c #13760c",
"as c #13770f",
".F c #13780f",
"#. c #137f0c",
"#j c #13bc09",
"#p c #13c417",
"az c #16750f",
".Q c #16780f",
"at c #167a0f",
".w c #169011",
".M c #17780c",
".9 c #17c109",
"#F c #17cc1b",
"#R c #18b409",
"#s c #18cc1a",
"#S c #18cc1b",
"#0 c #1b7e14",
"au c #1b8611",
"#y c #1bad09",
"#v c #1bba0c",
"#C c #1bbc0c",
"#I c #1bc60f",
".8 c #1bca0f",
"#6 c #1bcd15",
"#G c #1bdb1b",
".n c #1d780c",
"#4 c #1d8115",
"ay c #1d8314",
"#5 c #1dbc0f",
"#J c #1dbd0f",
"#Y c #1dc20f",
"#Z c #1dc30f",
"#X c #1dcc11",
".V c #1dce0f",
".S c #1dcf11",
".O c #1dd011",
"#W c #1ddc17",
".E c #1fd011",
"af c #1fd41a",
"a# c #1fd717",
"a. c #1fd823",
".C c #23770c",
"#1 c #238e17",
"av c #239215",
"#z c #23b311",
"#B c #23b511",
".X c #23dd2e",
"ax c #249217",
"aa c #24cc14",
".v c #25cf0f",
"#A c #26b714",
".K c #28780c",
"ae c #28cc15",
"#3 c #29931b",
"aw c #29971b",
".N c #2add32",
".U c #2ade38",
"#2 c #2b9a20",
".L c #2cc20f",
".D c #2cdd2d",
"ab c #30d51b",
".1 c #32dd43",
"ad c #33d920",
".J c #367709",
".R c #36de4a",
"ac c #37dd20",
"#i c #37dd4b",
".0 c #39e14e",
".g c #3e7509",
"#h c #40e25b",
".u c #41dd28",
".7 c #41e270",
".I c #467709",
".m c #57c80c",
".B c #58d30f",
".r c #631421",
".t c #69ce0f",
".b c #6b6500",
".A c #77cd0c",
".x c #787402",
".a c #8e5b00",
".o c #956b00",
".h c #965b00",
".c c #9a5600",
".# c #9e5c00",
".z c #a1f246",
".f c #b1b400",
"#D c #b6b409",
"#x c #b6d609",
"#T c #b7b607",
"#7 c #b8b707",
"ag c #bcbb09",
".y c #bef231",
"#w c #bfbc09",
"#L c #c3de09",
".q c #c3f72b",
"#9 c #c4c409",
"aq c #c4c609",
"#P c #c9e20c",
"aj c #cac809",
".e c #cbd300",
"ak c #cbe209",
"#M c #cbe711",
"#O c #cceb14",
".l c #d0d60f",
"al c #d0e60f",
"ap c #d0ea11",
"#N c #d1ef15",
"am c #d6f015",
"ao c #d9f217",
"an c #dbf51a",
".p c #e0f009",
".k c #e8ef15",
".i c #e9f602",
".d c #f2f600",
".j c #f8d4d3",
".s c #f8d6d4",
".H c #ff374d",
".G c #ff432b",
".P c #ff4b17",
"Qt c #ffffff",
"QtQtQtQtQt.#.a.bQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQt.c.d.e.f.gQtQtQtQtQtQtQtQtQt",
"QtQtQt.h.i.j.k.l.m.nQtQtQtQtQtQtQtQt",
"QtQt.o.p.q.r.s.t.u.v.wQtQtQtQtQtQtQt",
"QtQt.x.y.z.A.B.C.D.E.FQtQtQtQtQtQtQt",
".GQt.H.I.J.K.L.M.N.O.FQtQtQtQtQtQtQt",
"Qt.PQtQtQtQt.Q.R.S.TQtQtQtQtQtQtQtQt",
"QtQtQtQtQt.Q.U.V.WQtQtQtQtQtQtQtQtQt",
"QtQtQtQt.F.X.V.YQtQtQtQtQtQtQtQt.ZQt",
"QtQtQt.T.0.1.2Qt.3.4.5.5QtQtQtQt.6Qt",
"QtQtQt.W.7.8.9#.###a#b#c#dQtQt#e#fQt",
"QtQtQt#g#h#i#j#k#l#m#n#o#p#q#r#s#tQt",
"QtQt#u#v#g#w#x#y#z#A#B#C#D#E#F#G#tQt",
"QtQt#H#I#J#K.Y#L#M#N#O#P#Q#R#S#T#UQt",
"QtQt#V#W#X#Y#Z#0#1#2#3#4#5#6#7#UQtQt",
"QtQtQt#8#9a.a#aaabacadaeafagahQtQtQt",
"QtQtQtQtaiajakalamanaoapaqarQtQtQtQt",
"QtQtQtQtQtasatauavawaxayazQtQtQtQtQt"};

static const char* const image133_data[] = { 
"18 18 113 2",
".Z c #1f3800",
"#D c #243c00",
".R c #320f00",
"#t c #355602",
"#u c #446c09",
".h c #451300",
".d c #471300",
"#m c #496f07",
".F c #4b1400",
"#b c #507b09",
".6 c #547e09",
".N c #558009",
".j c #581b00",
"#l c #5a8814",
".7 c #5b1c00",
".o c #5d1c00",
"#i c #5e8d15",
".n c #602000",
".u c #612000",
".# c #632000",
".P c #652100",
".D c #652200",
".Y c #692000",
".g c #6b2200",
"#a c #6b9a15",
"#. c #6b9b15",
".O c #6e2200",
".v c #6f2200",
".X c #71a31a",
".E c #74a31a",
"#M c #792800",
"#E c #7a2e00",
"#L c #802b00",
"#A c #802d00",
"#p c #862f00",
".8 c #8a2f00",
".e c #8c3800",
".k c #8d3900",
".c c #8e3900",
".t c #903900",
".m c #913900",
"#e c #913b00",
".p c #963600",
".C c #983900",
".w c #993700",
".S c #9b2000",
".B c #9e4500",
".I c #a32f00",
".a c #a44500",
".b c #ae4c00",
"#c c #ae4d00",
".G c #af4300",
".f c #af4f00",
".J c #b14d00",
".i c #b65200",
"#U c #b85300",
".l c #ba5600",
"#N c #ba5b00",
"#C c #bc5c00",
"#T c #be5900",
"#B c #bf6000",
"#o c #c25d00",
"#z c #c35d00",
"#K c #c45c00",
"#d c #c45e00",
"#S c #c45f00",
".q c #c46100",
".r c #c96400",
"#R c #ca6100",
".M c #ca6900",
"#J c #cb6200",
"#O c #cb6400",
"#y c #cb6500",
".s c #cb6700",
"#P c #cc6600",
"#Q c #cd6800",
"#I c #d16900",
".y c #d16f00",
"#x c #d26b00",
"#H c #d26c00",
".z c #d27000",
"#F c #d46d00",
"#G c #d46f00",
".A c #d47000",
"#w c #d67100",
"#n c #d67300",
"#v c #da7500",
".L c #dc7e00",
".K c #dc7f00",
".W c #df8000",
".5 c #e08400",
".V c #e08500",
"#k c #e08a00",
"#q c #e08e00",
"#j c #e19000",
"## c #e48900",
".U c #e48d00",
".T c #e58f00",
"#s c #e59700",
".4 c #e89400",
"#g c #e99600",
".3 c #ea9b00",
".x c #ea9d00",
".H c #ea9f00",
".2 c #eaa000",
".1 c #eaa300",
"#f c #edbc00",
".0 c #efaa00",
"#r c #f2b600",
".Q c #f3ba00",
"#h c #f3bd00",
".9 c #fad700",
"Qt c #ffffff",
"QtQtQtQt.#.#QtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQt.#.a.#QtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQt.b.a.#.#QtQtQtQtQtQtQtQtQt",
"QtQt.#.c.d.e.b.f.g.d.hQtQtQtQtQtQtQt",
"QtQtQt.i.d.j.k.l.m.n.g.dQtQtQtQtQtQt",
"QtQt.i.d.o.p.q.r.s.t.u.v.dQtQtQtQtQt",
"Qt.i.d.#.w.x.y.z.A.B.C.u.D.E.FQtQtQt",
"QtQt.#.G.H.I.J.K.L.M.t.C.E.N.O.d.dQt",
"QtQt.P.Q.Q.R.S.T.U.V.W.B.X.N.n.u.Y.d",
"QtQt.Z.X.0.1.2.3.4.U.5.X.6.t.C.B.o.7",
"Qt.8.9.X#..0.3.3.4###a#b#c#d.B.M.B#e",
".8#f#g#h#.#i#j#j#k#l#m#c#d#n.M.M#o#e",
"#p#q#r#s#s#t.Z#u#u#t#c#d#v#w#x#y#z#e",
"#A#q#q#B#t#C#t.Z#D#E#d#F#G#H#I#J#K.Z",
"Qt#L#M#M#N#N#EQt#uQt#E#O#P#Q#O#R.X#e",
"QtQtQt#E#E#EQtQt#uQtQt#E#d#S#d.X#T#e",
"QtQtQtQtQtQtQtQt#uQtQt#E.l#S.X#U#U#e",
"QtQtQtQtQtQtQtQtQt#u#u#E#E.Z#E#E#E#e"};

static const char* const image134_data[] = { 
"18 18 72 2",
".X c #1f2800",
".K c #339bea",
".B c #389dea",
".D c #3d9dea",
".l c #3fb8f9",
".J c #4ba8ed",
".x c #4caaf0",
".f c #50c3f5",
".2 c #54400c",
".I c #54aeee",
".q c #54b8f4",
".k c #57b4f4",
".e c #5dc6f5",
".s c #5fbcf5",
".o c #64bcf5",
".h c #69c3f0",
".a c #69d3f4",
".W c #6d7e07",
".v c #6dc3f7",
".u c #8bd0f7",
".A c #8ecef5",
"#c c #922b00",
"#e c #984f20",
"#f c #9f5223",
"## c #a85f28",
".3 c #b47131",
"#. c #b67532",
".C c #bfe7f9",
".w c #c3ecff",
".F c #d15214",
".G c #d15715",
".M c #d25214",
".y c #da6415",
".E c #dc6917",
".Q c #dc7b1d",
".r c #dff2fc",
".T c #e0751b",
".U c #e49028",
".5 c #e9d3a7",
".8 c #eadeb2",
".m c #eaf8ff",
"#b c #edaf40",
".6 c #efb446",
".L c #efdcc1",
".z c #efdebb",
".7 c #f2c45b",
".n c #f2fbff",
".1 c #f3ecd4",
".g c #f3f9ff",
"#d c #f6b53c",
"#a c #f6c24e",
".H c #f6ecde",
".9 c #f7c04f",
".0 c #f7f2ea",
".4 c #f8d06d",
".P c #f9e195",
".N c #f9e3a3",
".S c #f9f2e2",
".R c #fbe3a3",
".V c #fbe6a9",
".Y c #fbe9b0",
".# c #ff8807",
".d c #ffa107",
".p c #ffad00",
".t c #ffaf00",
".Z c #ffbb8d",
".j c #ffe228",
".c c #ffe52b",
".b c #fff728",
".i c #fff82e",
".O c #fff9f4",
"Qt c #ffffff",
"Qt.#.#.#.#QtQtQtQt.aQtQt.#.#.#.#QtQt",
".#.b.#.c.c.d.eQt.f.g.h.#.i.#.j.j.#Qt",
".#.b.#.#.c.d.k.l.m.n.o.#.i.#.#.j.#Qt",
".#.p.c.c.p.d.q.r.r.r.s.#.t.j.j.p.#Qt",
"Qt.#.#.#.#.u.v.w.w.w.w.x.#.#.#.#QtQt",
"Qt.y.z.z.z.A.w.w.B.C.D.z.z.z.z.EQtQt",
".F.z.z.G.H.z.I.J.z.K.z.H.H.G.L.L.MQt",
"Qt.G.G.N.H.H.H.O.O.O.H.H.H.P.G.GQtQt",
"QtQt.Q.R.H.S.O.O.O.O.O.S.H.N.TQtQtQt",
"QtQt.U.V.H.W.O.O.O.O.O.W.H.V.UQtQtQt",
"QtQt.U.V.H.X.O.O.O.O.O.X.H.Y.UQtQtQt",
"QtQt.U.Z.Z.0.0.0.0.0.0.0.Z.Z.UQtQtQt",
"QtQt.U.Z.Z.Z.1.O.O.O.1.Z.Z.Z.UQtQtQt",
"QtQt.U.Z.Z.Z.1.2.1.2.1.Z.Z.Z.UQtQtQt",
"QtQtQt.3.4.5.5.6.2.7.8.8.9#.QtQtQtQt",
"QtQtQtQt###a#a#b#c.7#d#d#eQtQtQtQtQt",
"QtQtQtQtQt#f############QtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image135_data[] = { 
"18 18 32 1",
"q c #552211",
"i c #622b1d",
"# c #6d3521",
"g c #793b28",
"r c #7e3f29",
"w c #89472e",
"C c #8c6a5e",
"D c #90675b",
"x c #914d35",
"z c #975037",
"a c #9f5b3e",
"b c #9f5b40",
"y c #a15b40",
"h c #a15c40",
"p c #a35e42",
"A c #a35f45",
"c c #a56146",
"d c #a8684b",
"o c #ae6a4e",
"e c #cc8c6c",
"s c #cc8d6d",
"B c #cd8f71",
"f c #f1bca4",
"n c #f5b49b",
"t c #fdc7af",
"k c #fef2ea",
"l c #fef2ed",
"m c #ffd3bc",
"u c #ffd3bd",
"v c #ffdece",
"j c #ffe7da",
". c #ffffff",
"..................",
".....#######......",
"....#abcdcba#.....",
".###abefffeba###..",
"ghhiaejjjjjeaihhg.",
"ghiieklmjmlkeiihg.",
"ghiinkomjmokniihg.",
"ghpinkqmjmqkniphg.",
".#rsntuvjvutnsr#..",
"..#sntuwwwutns#...",
"..#nntujwjutnn#...",
"..#nntujwjutnn#...",
"..xnnouuouuonnx...",
"..xynnooooonnyx...",
"...#ynnnnnnny#....",
"....#zAsBsAz#.....",
".....C#####D......",
".................."};

static const char* const image136_data[] = { 
"18 18 86 2",
".4 c #1d0000",
".Y c #4e0000",
".h c #552211",
".R c #7d1400",
"#d c #841400",
"#e c #891b00",
".X c #893614",
"#. c #8a3715",
".K c #8a3815",
"#g c #903109",
"#b c #912e00",
".5 c #92360c",
"#a c #983702",
".I c #9a3607",
"#k c #9a451d",
"#j c #9e3f15",
".S c #9f4015",
".C c #9f461d",
"#i c #9f4b17",
".V c #a14820",
".W c #a14a20",
".T c #a54d21",
"#l c #a84f21",
".p c #a87829",
"#n c #a95023",
".7 c #aa5223",
".Z c #ac4d11",
"#h c #ac5224",
"#o c #ac5324",
".q c #ac7e2d",
".o c #ac7e2e",
".z c #af8a37",
"#p c #b15b2b",
".y c #b1903b",
"#t c #b25c2b",
"#r c #b25d2d",
"#q c #b25e2d",
"#s c #b45f2e",
"## c #b65b23",
"#f c #b85c27",
"#m c #b8642e",
".u c #b88a4c",
".9 c #b96531",
".8 c #ba6832",
".6 c #bd6936",
".J c #bf6f38",
".c c #bf9a4c",
"#c c #c07447",
".U c #c2723b",
".n c #c39759",
".f c #c3b36d",
".L c #c47e54",
".D c #c4a453",
".Q c #c9825b",
".M c #ca8255",
".3 c #d0b15b",
".H c #d19b75",
".0 c #d5c173",
".N c #dcb38e",
".b c #e01414",
".1 c #e3d39b",
".a c #e41414",
".2 c #e4d49b",
".k c #e4d5a0",
".O c #e8deb5",
".B c #e9ddae",
".# c #ea1414",
".j c #ea9600",
".r c #eadeb1",
".P c #eae2b9",
".E c #eddeb4",
".F c #ede5c1",
".G c #efe5c3",
".s c #f2e7c8",
".l c #f2ebcb",
".A c #f3ecd0",
".m c #f5c000",
".t c #f5ecd3",
".d c #f5f2e2",
".v c #f8ecce",
".x c #f8f2d8",
".w c #f9f6e7",
".e c #fdfbf4",
".g c #fdfdf2",
".i c #fdfdf7",
"Qt c #ffffff",
"QtQtQtQt.#Qt.aQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQt.#.#.a.bQtQtQtQtQtQtQtQtQtQtQt",
"QtQt.c.d.e.e.fQtQtQtQtQtQtQtQtQtQtQt",
"QtQt.c.g.h.i.fQtQtQtQtQtQtQtQtQtQtQt",
"Qt.j.j.g.k.i.l.fQtQtQtQtQtQtQtQtQtQt",
"QtQt.m.g.i.i.l.l.fQtQtQt.n.nQt.o.pQt",
"QtQt.c.g.i.l.l.l.n.n.n.n.i.n.n.i.qQt",
"QtQt.c.g.d.l.l.n.r.i.i.i.s.n.i.t.qQt",
"QtQt.c.d.d.l.u.r.v.w.i.s.i.n.i.t.qQt",
"QtQt.c.d.d.l.u.r.v.x.w.i.s.n.t.r.qQt",
"QtQt.y.d.d.l.u.r.r.x.x.s.n.i.t.qQtQt",
"QtQt.z.d.A.l.l.u.k.k.k.u.i.t.B.qQtQt",
"QtQt.C.D.E.F.G.G.u.u.u.t.t.t.H.IQtQt",
"Qt.J.K.L.M.N.O.P.P.P.P.P.t.Q.R.S.TQt",
".U.V.W.X.Y.Z.0.1.2.2.2.2.3.4.5.6.T.7",
"Qt.8.9.V#.###a#b#c#d#e###f#g.T.9.7Qt",
"QtQt#h.6#i.K.K.V#j#.#k#l#l.6#m#nQtQt",
"QtQtQtQt#o.6#p.6#q#r#r.6#s#tQtQtQtQt"};

static const char* const image137_data[] = { 
"18 18 139 2",
".8 c #2a0c07",
".N c #2b0500",
".1 c #2b0b02",
".2 c #310c07",
"#C c #511400",
"#D c #521600",
"#I c #561a00",
"#H c #571b00",
".Z c #581b00",
".U c #5e2200",
".f c #612817",
".e c #693123",
".d c #6b3627",
".V c #70381a",
"#t c #713520",
"#h c #743928",
".g c #794d28",
"#u c #7a3f2b",
"#v c #7a3f2d",
".h c #7d522b",
".i c #7d522d",
".T c #7e4b20",
"af c #802f00",
".K c #804e24",
"#q c #833d1b",
"ag c #863600",
"#y c #863c17",
"ae c #883900",
".c c #885830",
"ad c #8d4007",
"ah c #8e4609",
"#5 c #914809",
".S c #956742",
".L c #966943",
"ac c #985215",
"ab c #995317",
"#4 c #9b5820",
".y c #9c724e",
".J c #9e7450",
".x c #9e7453",
"#V c #9f5f28",
".# c #9f7654",
"ai c #a3642d",
".z c #a77e5b",
"#b c #aa703c",
".w c #ac8462",
"#n c #b07a4a",
"#E c #b16538",
".I c #b18c67",
".l c #b18d69",
".k c #b28e6a",
"#G c #b3693c",
".A c #b4906d",
"#U c #b68458",
"#M c #b68559",
".m c #b79471",
".4 c #b8895b",
"#z c #ba8d61",
".v c #ba9a76",
".j c #bc9c78",
"#a c #bd8d64",
".a c #be9d79",
"#f c #beac91",
"#7 c #bf9769",
"#6 c #bf976a",
".n c #bf9d79",
".b c #bf9f7c",
"#s c #bfad91",
"#x c #c2ad95",
"a# c #c3a374",
"aa c #c7a77a",
"#k c #c9b49b",
"#9 c #ccaf87",
"#8 c #ccb186",
".X c #ccbba0",
"#X c #cdb188",
".W c #cdbba1",
"a. c #d0b38a",
".r c #d0b48d",
"#w c #d0b8a4",
".Y c #d0bba1",
"#g c #d0c1ab",
"#3 c #d1b58e",
"#j c #d1c0a9",
"#r c #d1c2b0",
"#O c #d2b896",
"#2 c #d4bb9a",
".s c #d4bc9b",
"#e c #d4c3b0",
"#W c #d5ba98",
"#Y c #d6ba98",
".t c #d6bea1",
".q c #d6c1a0",
".F c #d7c4a3",
"#F c #d95c45",
".G c #d9c0a2",
"#Z c #d9c2a3",
"#0 c #dac3a4",
"#1 c #dac4a6",
"#l c #dac8b9",
"#P c #dbc7a9",
".Q c #dbc8a8",
".p c #dbc8ab",
".E c #dcc8ac",
"#N c #dcc8ae",
"#m c #dccdbe",
"#i c #dcd3c1",
".6 c #dcd4bf",
".R c #dfceb2",
"#c c #e0cdb3",
"#J c #e0ceb5",
"## c #e0d3c5",
".7 c #e0d4c5",
".H c #e0d4c6",
".D c #e0d4c7",
"#d c #e0d5c8",
"#Q c #e1cfb6",
"#T c #e1d0b8",
".P c #e1d3ba",
".5 c #e3cfc1",
"#R c #e4d4bd",
"#S c #e4d5bd",
".u c #e4d5bf",
"#B c #e4d6bf",
".o c #e4d6c1",
"#A c #e8dbc6",
"#K c #e8dcc7",
"#L c #e8dcc8",
".9 c #e8ded4",
"#. c #eae2ce",
"#o c #efe2d3",
"#p c #efe5d5",
".C c #efe5d8",
".O c #f1e7d8",
".B c #f2ebde",
".3 c #f6f0e7",
".0 c #f9f7f4",
".M c #fdfbfa",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQt.#.#.#QtQtQtQtQtQtQt.#.#.#QtQtQt",
"Qt.#.a.b.c.d.d.e.f.g.h.i.c.j.k.#QtQt",
".#.l.m.n.c.o.p.q.r.s.t.u.c.v.w.x.#Qt",
".y.z.A.c.B.C.D.E.F.G.H.C.B.c.I.J.yQt",
".K.L.c.M.M.N.O.P.Q.R.O.N.M.M.c.S.TQt",
".U.c.c.M.M.V.O.W.X.Y.O.V.M.M.c.c.ZQt",
"QtQt.c.M.0.M.O.1.2.2.O.O.M.3.cQtQtQt",
"QtQt.4.M.O.5.6.7.8.9#.##.O.3#aQtQtQt",
"Qt#b#c.O#d#e#f#g#h#i#j#k#l#m#c#bQtQt",
"Qt#n#o#p#q#r#s#t#u#v#w#x#y#o#o#nQtQt",
"Qt#z#A#B.P#C#D#E#F#G#H#I#J#K#L#zQtQt",
"Qt#M#N#O#P#Q#R.u.u.u.u#S#T#P.p#UQtQt",
"QtQt#V#W#X#Y#Z#0#1#1#1#1#2#3#4QtQtQt",
"QtQtQt#5#6#7#8#X#8#9a.a#aa#5QtQtQtQt",
"QtQtQtQtabacadaeafagahabaiQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image138_data[] = { 
"18 18 20 1",
"k c #5d0200",
"o c #d01711",
"c c #d05d58",
"l c #d1645f",
"j c #d4716c",
"r c #d67670",
"# c #d77e78",
"q c #d97e79",
"p c #da766a",
"n c #e35c50",
"b c #ea8d81",
"h c #ea9187",
"d c #fbb3a7",
"e c #ffd0ce",
"a c #ffd7d2",
"f c #ffddda",
"m c #ffdede",
"g c #ffe9e7",
"i c #fff3f2",
". c #ffffff",
"..................",
"..##.........##...",
".#aa#bcccccb#aa#..",
".#aa#deeeeed#aa#..",
"#aaacfgggggfcaaa#.",
"###cefgggggfec###.",
".hdffgggigggfedh..",
".jefkkgiiigkkfej..",
".jekgglllllggkej..",
".jeggliiiiilggej..",
".jeglmkgggkmlgej..",
".jeglmmmmmmmlgej..",
".hefgllnnnllgfeh..",
"..hefgooooogfeh...",
"...heffpopffeh....",
"....hqrcccrqh.....",
"..................",
".................."};

static const char* const image139_data[] = { 
"18 18 194 2",
"aP c #70380b",
"b. c #723c0f",
".e c #733d0f",
".U c #7b3e0b",
"#W c #83532c",
"#L c #83552f",
"#T c #835f42",
"#J c #836247",
"#1 c #925b2c",
"a3 c #944b0e",
"#D c #945b2c",
"aK c #954a0d",
"ar c #954e13",
"#k c #955f32",
".J c #956238",
"#f c #95765c",
"aJ c #96490b",
"aV c #995218",
"aM c #995924",
"aC c #995e2d",
"ap c #996133",
"ae c #99653a",
"#6 c #996840",
".p c #996941",
"#V c #996b46",
".B c #996d49",
"#K c #996d4a",
".O c #996f4e",
".4 c #997150",
"#i c #997151",
"#7 c #9b5e2d",
"#y c #9b663a",
"#5 c #9b6c47",
"#x c #9b785b",
".I c #a5500b",
"#Q c #ab4e01",
"aE c #ad4d00",
".d c #af5001",
"aA c #b0692e",
".9 c #b06a32",
".0 c #b08766",
"aO c #b15000",
"aS c #b1560b",
"b# c #b2560a",
"a. c #b3560a",
"#C c #b8580a",
"aX c #b8590b",
"a5 c #ba5400",
"a6 c #ba631c",
"#0 c #ba6d2e",
"#Z c #ba753c",
"#Y c #ba7b47",
"#X c #ba7e4c",
"#E c #ba8458",
"#F c #ba8a63",
"#G c #ba8c67",
"#H c #ba8e6b",
"#I c #ba906d",
"au c #bc5500",
"ag c #bc6f30",
"#s c #bc7d49",
"ad c #bc7d4a",
"#r c #bc9574",
"aG c #bd641c",
"ah c #bd6b28",
"#t c #bd7840",
"ac c #bd7d49",
"#q c #bd9574",
"a0 c #c2671c",
"aF c #c35800",
"#2 c #c35e0a",
"aj c #c36e2a",
"aR c #c3936c",
"a1 c #c45800",
"a9 c #c5702a",
".w c #c65e0b",
".f c #c65f0a",
"aQ c #c8a588",
"aD c #c95f09",
".T c #c96d21",
"aL c #c9722b",
"aB c #c97939",
".8 c #c98044",
".K c #c9976f",
".1 c #c99e7b",
".c c #ca600a",
".F c #ca610b",
"## c #ca6a1c",
"#v c #cb732a",
"aY c #cb976c",
"ax c #ce6c1c",
"#m c #cf5d00",
"ai c #d25f00",
".t c #d26d1c",
".V c #d2a988",
".v c #d59b6c",
"av c #d89f70",
"al c #d96100",
"a# c #d9792a",
"a2 c #dc6300",
"a8 c #dca170",
".X c #dd721c",
".k c #de721c",
"#8 c #de8338",
"#z c #de8c49",
"#4 c #de9a63",
".G c #de9f6c",
"#w c #deab81",
"aI c #deaf88",
".g c #df7b2a",
"a7 c #dfaf88",
".s c #e16600",
"#o c #e27d2a",
"#n c #e2a470",
"a4 c #e36700",
"aq c #e48230",
"ao c #e4914d",
"#j c #e4985a",
"#g c #e4b794",
"aZ c #e5b288",
".b c #e67f2a",
"#. c #e96e09",
"as c #e96f0b",
"az c #e9893a",
"#l c #e98d42",
"an c #e9934d",
".Z c #e9af7e",
"#e c #e9b58a",
"#c c #eb6a00",
"ak c #eca870",
"#9 c #ed6a00",
".H c #edb688",
".l c #ef6b00",
".h c #f1aa70",
"aT c #f26c00",
".u c #f2b888",
"#M c #f6974a",
"#S c #f6b17a",
"#b c #f7ac70",
"at c #f97000",
"aH c #faf2eb",
".a c #fbae70",
"#a c #fbf2eb",
".j c #fdbc88",
"aw c #fdf3eb",
"aW c #fe7200",
".i c #fef3eb",
"#B c #ff7301",
"aa c #ff7708",
"ay c #ff780a",
"#P c #ff790c",
".r c #ff7f16",
"aU c #ff8019",
"#p c #ff841e",
"aN c #ff8623",
".m c #ff8928",
"#O c #ff8c2f",
"#3 c #ff8e34",
"#A c #ff9136",
".Y c #ff9137",
".x c #ff9239",
"#N c #ff9640",
".q c #ff9843",
"#u c #ff9a48",
"af c #ff9c4c",
"am c #ff9d4d",
".S c #ffa154",
".n c #ffa256",
"ab c #ffa359",
".E c #ffa55c",
".R c #ffa760",
".7 c #ffa963",
".D c #ffab68",
"#R c #ffae6a",
".Q c #ffaf6d",
".o c #ffaf6f",
".6 c #ffb172",
".C c #ffb274",
".P c #ffb679",
"#U c #ffb67c",
".5 c #ffb77e",
"#d c #ffb980",
".A c #ffbb85",
".y c #ffbf8a",
".z c #ffbf8b",
".N c #ffc08d",
".L c #ffc494",
".M c #ffc697",
".3 c #ffc99c",
".2 c #ffca9e",
"#h c #ffcba0",
".W c #fff4eb",
".# c #fff4ec",
"Qt c #ffffff",
"QtQtQtQt.#.a.b.c.d.e.f.g.h.iQtQtQtQt",
"QtQtQt.j.k.l.m.n.o.p.q.r.s.t.uQtQtQt",
"QtQt.v.w.x.y.z.y.A.B.C.D.E.r.F.GQtQt",
"Qt.H.I.J.K.L.M.L.N.O.P.Q.R.S.T.U.VQt",
".W.X.Y.Z.0.1.2.3.L.4.5.6.7.8.9#.###a",
"#b#c#d.N#e#f#g#h.M#i#d.C#j#k#l.x#m#n",
"#o#p.5.y.L#q#r.3.L.4.5.6#s#t#u.x#c#v",
".f#u.P.A.N#w#x.L.N.O.P.o#y#z.q#A#B#C",
"#D#E#F#G#H#I#J.y.A#K.C.D#L#M#N#O#P#Q",
".d.n#R.C.P#S#T.5#U#V#R.R#W#X#Y#Z#0#1",
"#2#3.R#R.Q#4#5.6.o#6.R.n#7#8#O.r#9a.",
"a#aa.nab.Racad.7.Rae.nafagah#paaaiaj",
"akal#uaman#kao.n.Sap#u#Naqarasatauav",
"awaxayazaAaB#u#u.qaC.x#O#paDaEaFaGaH",
"QtaIaJaKaL.x.x.x#AaMaN.raaataOaPaQQt",
"QtQtaRaSaT#p#p#paUaVayaWaTaiaXaYQtQt",
"QtQtQtaZa0a1a2.lata3a4#ma5a6a7QtQtQt",
"QtQtQtQt#aa8a9a.#Qb.b#ajavaHQtQtQtQt"};

static const char* const image140_data[] = { 
"18 18 152 2",
"#1 c #3f413f",
"af c #484848",
"#a c #494949",
"#u c #4a4a4a",
".3 c #4b4b4b",
".2 c #4c4c4c",
"#t c #4d4d4d",
"#F c #4e4e4e",
".S c #4f4f4f",
".R c #505050",
"#M c #525252",
"#s c #535353",
"#E c #545454",
".G c #555555",
"#h c #565656",
"#A c #575757",
"#r c #585858",
"#D c #5a5a5a",
"#g c #5b5b5b",
".y c #5c5c5c",
".9 c #5e5e5e",
"#f c #5f5f5f",
"#l c #616161",
".C c #656565",
".B c #666666",
".s c #676767",
"au c #676967",
".r c #686868",
".i c #696969",
".h c #6a6a6a",
".b c #6b6b6b",
"at c #6b6d6b",
".a c #6c6c6c",
"#R c #757775",
"#z c #787a78",
"#n c #7b7d7b",
".c c #7c7d7c",
"#i c #7e7e7e",
"#q c #7f827f",
"#o c #807f80",
"#Q c #818281",
"#5 c #828482",
"#m c #838483",
"ap c #848584",
"## c #858685",
"#j c #868786",
"ai c #8a8b8a",
"#S c #8b8c8b",
"ab c #8c8d8b",
"ac c #8c8d8c",
".d c #8c8e8d",
"#c c #8d8e8d",
"#L c #8f8f8f",
"#X c #919291",
"aa c #929292",
".8 c #949594",
"#Y c #949695",
".W c #959695",
"#7 c #969896",
".L c #979897",
".t c #989998",
".n c #999999",
"#b c #999a99",
".o c #9a9a9a",
"as c #9a9b9b",
"aq c #9b9b9b",
".U c #9fa09f",
".I c #9fa19f",
"#P c #a0a0a0",
".# c #a3a3a3",
"ar c #a4a4a4",
".e c #a6a6a6",
"#4 c #a7a7a7",
".5 c #a7a9a7",
"a# c #a8a8a8",
"#G c #a9a8a9",
"am c #abaaaa",
".K c #ababab",
"aj c #adadad",
"#K c #aeaeae",
"#W c #afafaf",
"al c #afb0b0",
"#y c #b0b0b1",
"#3 c #b1b2b2",
"ak c #b4b4b4",
".m c #b5b6b5",
"#O c #b6b6b6",
"an c #b6b7b6",
".x c #b7b7b6",
"av c #b8b9b8",
"#6 c #b9b9b9",
"#V c #bababa",
"a. c #babbba",
".6 c #babbbb",
"#2 c #bbbcbb",
"#J c #bdbdbd",
"ah c #bdbebd",
".4 c #bfbfbf",
".z c #c2c2c2",
"#x c #c3c3c3",
"ag c #c5c5c5",
"#Z c #c5c6c5",
"#k c #c7c7c7",
"#. c #c8c8c8",
".f c #c8c9c8",
"ao c #c9c9c8",
"ad c #cac9c9",
"ae c #cacac9",
"#I c #cacaca",
".T c #cbcbcb",
".q c #cbcccb",
"#N c #cccccc",
"#8 c #cccccd",
".H c #cccdcc",
"#w c #cdcdcc",
"#B c #cecfce",
".l c #cfcfcf",
"#H c #d0d0cf",
"#d c #d0d0d0",
".p c #d0d1d0",
"#9 c #d0d1d1",
"#0 c #d3d3d3",
"#v c #d3d4d3",
".A c #d6d6d6",
".F c #d6d6d7",
".g c #d6d7d6",
".Q c #d7d7d8",
".1 c #d8d8d8",
"#T c #dadad9",
".w c #dadada",
"#U c #dedddd",
".E c #dededd",
".P c #dfdfdf",
".v c #e1e0e1",
".k c #e1e1e1",
".j c #e4e4e4",
".O c #e5e5e5",
".0 c #e6e6e6",
"#C c #eae9e9",
".N c #ebebeb",
".Z c #ecedec",
".V c #edecec",
"#p c #efefef",
".J c #f1f1f1",
".Y c #f2f3f3",
".D c #f6f6f6",
"#e c #f7f6f7",
".X c #f7f7f7",
".M c #fafafa",
".7 c #fcfcfb",
".u c #fefefe",
"Qt c #ffffff",
"QtQtQtQtQt.#.a.b.c.c.d.e.fQtQtQtQtQt",
"QtQtQt.g.a.h.h.i.j.k.l.m.n.o.pQtQtQt",
"QtQt.q.b.r.s.s.t.u.u.u.v.w.x.y.zQtQt",
"Qt.A.h.i.B.s.C.D.u.u.u.j.E.F.G.G.HQt",
"Qt.I.f.J.K.L.L.M.D.u.N.O.P.Q.R.S.SQt",
".T.U.V.u.u.u.u.W.X.Y.Z.0.P.1.2.3.3.4",
".5.6.u.u.u.u.7.8.9#.#..O.P#####a#a#b",
"#c#d.u.u.u.D#e#f#g#h#i#j#j.A.l#k#l#m",
"#n#o.0.N#p.J#q#g#r#s.R#t#u#v#w#x#y#z",
".9#A#B.0#C.N#D#A#E.R#F.2#G#H#I#J#K#z",
"#D#r#r#L#L#r#A#E#M#F.3#u#G#N#x#O#P#Q",
"#R#E#S#T#U.P#s.R#F.3#u#u#G#k#V#W#X#Y",
"#Z.R#S#0.A.1.1#q.2#u#q#q#1#2#3#4#5#6",
"Qt#7#S#8.l#d#9#q#q.H#I#xa.#la#aaabQt",
"Qt#Nac.x#kadae###k#x#J#O#W#LafafagQt",
"QtQtahai.##V#lajajakalam#LafafanQtQt",
"QtQtQtaoafafapaq#4aras#LafafagQtQtQt",
"QtQtQtQtQt#2afat#z#zauauavQtQtQtQtQt"};

static const char* const image141_data[] = { 
"18 18 40 1",
"b c #700a0a",
"I c #8a2a04",
"F c #8d939e",
"a c #909397",
"# c #bdbebf",
"K c #d3a5a5",
"G c #e7748b",
"y c #ec6100",
"J c #efc3c3",
"x c #f15a00",
"w c #f15c00",
"z c #f26700",
"H c #f3c7c7",
"v c #f76200",
"m c #f89500",
"r c #fa8000",
"t c #fa9300",
"E c #faf7f7",
"g c #fbfbfb",
"L c #fcfbfa",
"f c #fcfcfc",
"q c #fe7e00",
"p c #fe9800",
"C c #ff0033",
"A c #ff7600",
"D c #ff7900",
"B c #ff8100",
"o c #ff9400",
"s c #ff9a00",
"n c #ffa000",
"u c #ffaf00",
"k c #ffb300",
"l c #ffc700",
"i c #ffc900",
"h c #ffd100",
"j c #ffdb00",
"d c #ffdd00",
"c c #ffe000",
"e c #ffec00",
". c #ffffff",
".........########.",
"........abbbbbbbb.",
"........abcdeeeb..",
".......abccdeebf..",
"....g..abhijjb..g.",
"......abkkllb.....",
"......abmnnb#bbbbb",
".....aboppbbbkkkb.",
"bb...abqrssstsub..",
"bb...bvwxyzABsb...",
".C....bbbbzDDbE...",
".C.....FbzDDb.....",
"..C...FbzDDb......",
"b.G...bzDDb.......",
"bb.H.IzDbb........",
"JC.H.bDbK.........",
"..GLbDbK..........",
"...GbbK..........."};

static const char* const image142_data[] = { 
"18 18 20 1",
"h c #29602d",
"n c #454222",
"o c #586739",
"q c #627134",
"k c #688136",
"r c #698d4e",
"p c #77ba12",
"e c #993333",
"l c #abce42",
"# c #d6163d",
"c c #f52c35",
"a c #fb7171",
"i c #fcadc4",
"g c #fd3233",
"f c #fe3233",
"b c #fed4d4",
"d c #ff3333",
"j c #ff3399",
"m c #ffcccc",
". c #ffffff",
"....#.#..#..#.#...",
"....#a##aba##a#...",
"#...#b#b#a#b#a#cc.",
".##abb#ab#ba#baadc",
".edaabeaabad#bade.",
"..eddaeddadebade..",
"a#beddaeddfaaade#.",
"dbageddaededddebad",
"eddabeddcedeeebadc",
".eeddgeeeheiedade.",
"...eeejklhjmieee..",
"..iiim.klnojiii...",
".iiimj.klnojmiii..",
"iiiij..pqnp.jmiii.",
"mjimj...nq...jiiji",
"j.mj....pr...jmi.j",
"..mj....pr....jm..",
"..j.....pr.....j.."};

static const char* const image143_data[] = { 
"18 18 84 2",
".s c #004600",
"#r c #0b5600",
"#q c #0d5801",
".g c #0f510f",
".K c #145514",
"#p c #1d6316",
"#i c #24651c",
".w c #24651f",
".j c #256125",
"#a c #25651c",
".4 c #26661e",
".9 c #27661e",
".7 c #296a20",
"#n c #30761f",
"#m c #347d1f",
".m c #377033",
"#o c #39851f",
".6 c #3e8e20",
"#g c #449720",
"#e c #449820",
"#l c #449920",
"#f c #459920",
".z c #4b8148",
".0 c #4da621",
".5 c #4da721",
".i c #4faa21",
".Y c #5f0606",
".2 c #600808",
".3 c #60905c",
".b c #679167",
".O c #6c1b1b",
".l c #6d956d",
"#d c #76bd52",
".S c #790301",
".8 c #79140d",
".r c #7f3b3b",
".h c #7fc15e",
".k c #80a380",
"#b c #82aa7a",
"#c c #86c466",
".T c #905252",
".1 c #91ca74",
"#h c #93cb77",
".P c #94b68f",
"#k c #9ccf82",
".# c #9ed085",
".E c #9fb99f",
".a c #a3bda3",
".F c #a4c49b",
".q c #a83425",
".f c #ab2814",
".V c #ab7c7c",
"#j c #afcca8",
".t c #b0c6b0",
".v c #b3d4a4",
".n c #b48888",
".X c #b81f05",
".y c #b8d5ac",
".c c #c09c9c",
".e c #c82100",
"#. c #cce6bf",
"## c #dff0d7",
".D c #e12d00",
".d c #e45d46",
".B c #e82802",
".I c #eb0b06",
".M c #ec1000",
".H c #f41d00",
".x c #f43300",
".p c #f62f00",
".u c #f7f9f7",
".U c #f84008",
".J c #fa3200",
".N c #fd3b04",
".A c #fe928d",
".G c #fef7f7",
".W c #fef8f8",
".R c #ff3c00",
".Q c #ff3d1d",
".L c #ff6536",
".C c #ff6b43",
".o c #ffaaae",
".Z c #fffdfd",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQtQtQt.#.a.bQtQtQt",
"QtQtQtQtQt.c.d.e.f.g.h.i.j.k.l.mQtQt",
"QtQtQtQt.n.d.o.p.p.q.r.s.t.u.v.wQtQt",
"QtQtQt.d.d.o.p.p.p.p.x.sQtQt.y.zQtQt",
"QtQt.d.o.A.B.C.C.p.p.x.D.EQt.F.zQtQt",
".G.d.o.H.I.I.I.C.p.p.J.D.KQt.F.zQtQt",
".d.o.L.M.o.N.N.I.C.p.p.p.OQt.z.PQtQt",
".d.o.Q.R.S.o.S.N.I.C.p.p.TQt.z.PQtQt",
".d.o.U.U.S.o.o.N.S.C.D.D.VQt.zQtQtQt",
".W.X.X.U.U.S.S.S.C.C.C.Y.Z.F.zQt.0.1",
"QtQtQt.X.C.C.C.C.S.C.C.2Qt.3.4.5.6.4",
"QtQtQtQt.X.X.C.C.S.C.SQtQt.7.4.4.4Qt",
"QtQtQtQtQtQt.X.SQt.8QtQtQt.9.1.1QtQt",
"QtQtQtQtQtQtQtQtQt#.##QtQt#a#bQtQtQt",
"QtQtQtQtQtQtQt#c#d#e#f#g#h#i#jQtQtQt",
"QtQtQtQtQtQt#k#l#m.4.4#n#o#p#jQtQtQt",
"QtQtQtQtQtQtQtQt.4.4.4.4#h#q#jQtQtQt",
"QtQtQtQtQtQtQtQtQt#o.4QtQt#r#jQtQtQt"};

static const char* const image144_data[] = { 
"18 18 160 2",
"aw c #140000",
"ax c #140701",
"ao c #1c0701",
"aD c #1e0000",
".f c #393737",
"#F c #3c1507",
".h c #3f2a30",
".E c #413838",
".v c #413e3e",
"an c #420d04",
"#y c #453430",
"#H c #474444",
"#b c #48311d",
"ap c #4c260b",
"#G c #503125",
"aC c #573030",
".o c #575353",
"#l c #5a4943",
".y c #615749",
"#r c #63453c",
"#I c #645036",
".2 c #646262",
".P c #672727",
"aq c #673a10",
"#B c #6a1000",
".9 c #6e5452",
".b c #746867",
"au c #754b4b",
".0 c #761011",
".# c #761500",
"#E c #77300c",
".Z c #787070",
"#i c #797171",
"#7 c #7b1700",
"#T c #7b1b01",
"#M c #7c1a01",
"#k c #7c3f13",
"#A c #7c4a2c",
"#x c #7d4815",
".O c #7d7575",
"#. c #7e1801",
"#v c #7e1c01",
"#p c #7e7777",
"#j c #7e7c77",
".p c #7f6435",
"#q c #7f6868",
"#z c #806969",
".D c #827a7a",
".e c #834141",
".G c #838282",
"#h c #867f7f",
"#8 c #8b2d09",
"ae c #8b5e0f",
"#X c #8e2f07",
"#N c #8e2f09",
"#o c #8f8888",
"aa c #91310a",
"#w c #94330a",
".Y c #958f8f",
"av c #994812",
".R c #999696",
".1 c #9a6d6e",
"#m c #9a9393",
"#g c #9f9999",
"#J c #a07e48",
".8 c #a19c9c",
"af c #a2400e",
"#9 c #a24210",
"#S c #a24410",
"ak c #a2581b",
".N c #a29d9d",
"#O c #a44711",
"#Y c #a44812",
"#s c #a58987",
"#n c #a88080",
".u c #a8a1a1",
"aB c #a98585",
".C c #a9a2a2",
"#C c #aa4e14",
"#P c #ac4e14",
"aA c #ac8e8e",
"#Z c #ad5215",
"#f c #b2acac",
".q c #b2b2b2",
"a. c #b3591a",
"#c c #b3adad",
".i c #b4b3b3",
"#0 c #b55c18",
".X c #b6b2b2",
"ag c #b75b1a",
"#D c #b85d1b",
"ay c #b8812d",
"#Q c #ba621b",
".7 c #bcb7b7",
"#e c #bdb8b8",
"#a c #be6a1e",
"#2 c #c0681f",
".n c #c0bcbc",
".M c #c4c0c0",
"#1 c #c56d1f",
"a# c #c57022",
".t c #c9c6c6",
".c c #ca6766",
".B c #cac7c7",
".d c #ce3938",
"ah c #ce7b26",
".6 c #cfcccc",
".3 c #cfcdcd",
"#d c #d18889",
".W c #d1cece",
".m c #d53131",
"#R c #d6842a",
"aj c #d8852c",
".a c #d8d8d8",
".5 c #dad8d8",
"ar c #db8d2f",
"am c #db9135",
"ai c #dd8e30",
"#K c #dfcea4",
".L c #dfdddd",
"ad c #e09238",
".4 c #e0cccc",
"az c #e2a13a",
"#L c #e49633",
".V c #e5e2e2",
".S c #e5e3e3",
"#6 c #e6d6c4",
".A c #ee7374",
".l c #efeded",
".U c #f0efef",
"#W c #f1eded",
".T c #f2cdcd",
".H c #f2f1f1",
".K c #f4bcbd",
".x c #f5ca87",
"#u c #f6aa3e",
".s c #f7f6f6",
"as c #f8ac3e",
".z c #f8f8f8",
".k c #f9f8f8",
".g c #fcf2e9",
".J c #fd8081",
"at c #fdb340",
".j c #fdfcfc",
".r c #fefefe",
".I c #ffa5a5",
"#t c #ffb94f",
"ab c #ffc05e",
"#3 c #ffc162",
"#4 c #ffc265",
"#V c #ffc971",
"#5 c #ffca77",
"#U c #ffcb76",
"al c #ffcd77",
"ac c #ffce79",
"## c #ffdea3",
".w c #ffdea4",
".F c #fff3c3",
".Q c #ffffe5",
"Qt c #ffffff",
"QtQtQtQtQt.#.#Qt.a.b.c.d.e.fQtQtQtQt",
"QtQtQt.#.#.g.g.h.i.j.k.l.m.n.oQtQtQt",
"QtQt.#.g.#.g.p.q.r.r.r.s.m.t.u.vQtQt",
"QtQt.#.w.#.x.y.z.r.r.r.m.A.B.C.D.EQt",
"Qt.#.F.w.#.x.G.H.j.I.J.K.L.M.N.O.PQt",
".#.Q.#.w.#.x.R.S.T.m.U.V.W.X.Y.Z.0.1",
".#.Q.#.w.#.x.2.3.m.4.5.6.7.8.D.0.9#.",
".###.#.w#a.##b#c.m#d#e#f#g#h#i.0#j#.",
".###.#.w#a.##k#l#m.m#n#o#p#q.m#r#s#.",
".##t#u#v#a.##w#x#y#z.0.0.m.m#A.g#.Qt",
".##u#u#v#a#B#C#D#E#F#G#H#I#J#K.g#.Qt",
".##L#u#v#M#N#O#P#Q#R#S#T#U#V.g#.#WQt",
".##L#v#X#X#Y#Z#0#1#2#T#3#4#5#.#6QtQt",
".##L#7#8#9a.a##a#aaaab#5acad#.aeQtQt",
"#.#Lafafagahaiajakab#5alam#.QtQtaeQt",
"Qtanaoapaqarasatab#5#5#.#.aeaeQtQtQt",
"QtQtauavawaxayabaz#.#.QtaeQtQtQtQtQt",
"QtQtQtaAaBaCaD#.#.QtQtQtQtaeQtQtQtQt"};

static const char* const image145_data[] = { 
"18 18 54 1",
"O c #152a00",
"t c #1b2bcc",
"e c #393939",
"Y c #3f502e",
"T c #445d48",
"P c #475e34",
"y c #5026a0",
"U c #526331",
"Z c #674700",
"I c #6f6f6f",
"j c #747474",
"c c #777777",
"J c #7b7b7b",
"V c #7d6200",
"o c #808787",
"Q c #839b85",
"D c #868583",
"h c #878686",
"F c #89a8f3",
"p c #8a8a8a",
"i c #8d8d8d",
"C c #8e8e8e",
"z c #8fa4e0",
"d c #909090",
"x c #9191db",
"v c #929292",
"M c #949494",
"N c #959595",
"R c #979797",
"g c #9da2a2",
"a c #ac4e2f",
"W c #ad8a17",
"B c #b0b0af",
"H c #b0b0b0",
"K c #b1b1af",
"b c #b3b9bd",
"S c #c6d599",
"# c #ce5c25",
"k c #ced1d0",
"u c #d0b3cf",
"q c #d0d3d3",
"E c #d4d8e1",
"n c #e0b3b0",
"f c #e2d3d0",
"L c #e4e1d7",
"A c #ecf1f6",
"m c #ee444e",
"r c #eeb1b7",
"G c #f0eee5",
"l c #f5e5e4",
"s c #ff332d",
"X c #ffae00",
"w c #fffffd",
". c #ffffff",
"..................",
"...#a...bbbc......",
"...debbbfghc......",
"...iejklmnoc......",
"...peqrstu.c......",
"...vewxyzABc......",
"...CeDEFGHIc......",
"...deJKLcccc......",
"...Meccc..........",
"...Ne....OO.......",
"...Ne.POOQQO......",
"...ReOSQSSTQO..O..",
"...OOS.SQUQOQOVWO.",
"..OSQ.SQQQUUOOOWO.",
"..PQUQQUUUQUUOOWO.",
".OSQSXWXWUWUUUOVOW",
"PPXUWVWVWUUUUVVVVY",
"ZZZZZZZZZZZZZZOOOO"};

static const char* const image146_data[] = { 
"18 18 172 2",
"#Y c #006bcf",
"ad c #0072cc",
"ao c #007dc7",
"aO c #007fcc",
"aJ c #048acb",
"#I c #0570cf",
"aw c #0952cf",
"aD c #0a9eb6",
"#s c #1496c7",
"av c #1fb08f",
"#t c #2285d3",
"#X c #22b484",
"#H c #24b18b",
"ac c #2cba76",
"#r c #2eb48a",
"aE c #3524b6",
"#J c #3b3ebe",
"an c #3fc559",
"#u c #4b86df",
"ap c #4e16b0",
"aK c #520dad",
"aN c #52d739",
"ae c #5a1cb1",
"aI c #5bdb35",
"#d c #62cd90",
"aP c #6605a9",
"#e c #6bcbb8",
"#Z c #6d0aaa",
"aC c #6fe630",
"#c c #71dd58",
"#G c #73e331",
"#W c #7dea29",
"#f c #86d2d3",
"#q c #86eb2d",
"ax c #870091",
"#K c #8923b2",
"#v c #8ba0e3",
"#0 c #9e069a",
"au c #a5ff19",
"ab c #a9fe16",
"#L c #aa40b6",
"#b c #aeff2f",
"aF c #af0eaa",
"#g c #b5e3e6",
"#w c #b8c3ed",
"aq c #bf30b6",
"af c #c13bb9",
"#1 c #c456c4",
"#M c #cf7cd1",
"#x c #d1def6",
"am c #d5ff18",
"ay c #d691d8",
"#h c #dbf2ee",
".0 c #dfff91",
"#N c #e0a9e1",
"#2 c #e1b1e3",
".1 c #e4ffb5",
"ag c #e5bbe7",
".Z c #e5ff68",
"#O c #e9ccec",
"#F c #e9ff12",
"#y c #eaf3fb",
"#p c #ebff15",
"#i c #f1fbf5",
"#3 c #f2dff3",
"#a c #f2ff1c",
".2 c #f2ffd5",
"#V c #f3ff0e",
"#P c #f5ebf8",
"#z c #f7fbfd",
"#4 c #f8ecf9",
"#Q c #f9f8fd",
"#5 c #faf2fa",
"aM c #faf500",
".Y c #fafe4c",
"#j c #fbfefa",
"aa c #fbff07",
".3 c #fbffef",
"aH c #fdf300",
"#6 c #fdf8fd",
"#7 c #fdf9fd",
".4 c #fefffa",
"aj c #ff0000",
"#B c #ff0003",
"#S c #ff0200",
"#9 c #ff0407",
".7 c #ff121a",
"#l c #ff1907",
".S c #ff1d21",
".F c #ff1e1e",
".8 c #ff3010",
".T c #ff3117",
".t c #ff3131",
"az c #ff3238",
".G c #ff3927",
"a. c #ff3c0f",
".s c #ff3f42",
"#R c #ff4e50",
".E c #ff4e53",
"ar c #ff5154",
".i c #ff5156",
"#C c #ff5608",
".u c #ff5842",
".h c #ff5d61",
"#k c #ff5f63",
".j c #ff6768",
".U c #ff6e1e",
".v c #ff7147",
"#T c #ff750b",
"ak c #ff7513",
".H c #ff7938",
"ai c #ff7a7b",
"as c #ff7f02",
"#m c #ff8314",
".9 c #ff8616",
".k c #ff8686",
"aA c #ff8a05",
".V c #ff8c1e",
"#D c #ff8d00",
"aL c #ff8d05",
"aG c #ff9009",
".w c #ff915e",
"#n c #ff9606",
"#. c #ff980b",
".R c #ff9f9f",
".r c #ffa2a3",
".I c #ffa441",
".l c #ffa4a4",
".g c #ffa5a5",
"a# c #ffa707",
".x c #ffb081",
".J c #ffb34b",
"#A c #ffc1c2",
".K c #ffc360",
".m c #ffc4c4",
".W c #ffc729",
".y c #ffcbaa",
"#U c #ffd004",
"#8 c #ffd0d0",
".c c #ffd1d2",
"al c #ffd700",
".b c #ffd7d8",
".L c #ffd887",
".d c #ffd9da",
".z c #ffdbca",
".D c #ffdbdb",
".n c #ffddde",
"## c #ffe009",
"at c #ffe102",
".M c #ffe6b3",
".a c #ffe7e7",
".X c #ffe83e",
".A c #ffe8e0",
"#E c #ffea01",
"aB c #ffea02",
".6 c #ffebeb",
"#o c #ffee06",
".e c #ffeeee",
".o c #ffeeef",
".f c #ffefef",
".N c #fff3db",
".B c #fff3f1",
".C c #fff7f7",
".p c #fff8f8",
".O c #fff9f0",
".# c #fffafa",
".q c #fffcfc",
".P c #fffdfa",
".Q c #fffdfb",
"ah c #fffeff",
".5 c #fffffc",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQt.#.a.b.c.d.e.#QtQt",
"QtQtQtQtQtQtQt.f.g.h.i.j.k.l.m.n.o.p",
"QtQtQtQtQt.q.r.s.t.u.v.w.x.y.z.A.B.C",
"QtQtQtQt.D.E.F.G.H.I.J.K.L.M.N.O.P.Q",
"QtQtQt.R.S.T.U.V.W.X.Y.Z.0.1.2.3.4.5",
"QtQt.6.7.8.9#.###a#b#c#d#e#f#g#h#i#j",
"QtQt#k#l#m#n#o#p#q#r#s#t#u#v#w#x#y#z",
"Qt#A#B#C#D#E#F#G#H#I#J#K#L#M#N#O#P#Q",
"Qt#R#S#T#U#V#W#X#Y#Z#0#1#2#3#4#5#6#7",
"#8#9a.a#aaabacadaeafagQtQtQtQtQtQtah",
"aiajakalamanaoapaq#3QtQtQtQtQtQtQtQt",
"arajasatauavawaxayQtQtQtQtQtQtQtQtQt",
"azajaAaBaCaDaEaFagQtQtQtQtQtQtQtQtQt",
"ajajaGaHaIaJaKaF#3QtQtQtQtQtQtQtQtQt",
"ajajaLaMaNaOaPaF#4QtQtQtQtQtQtQtQtQt",
"ajajaLaMaNaOaPaF#5QtQtQtQtQtQtQtQtQt"};

static const char* const image147_data[] = { 
"18 18 108 2",
"#F c #004600",
"#I c #065000",
"#O c #073b01",
"#x c #074c00",
"#M c #074f00",
"#L c #075200",
"#N c #085300",
"#r c #10600c",
"#u c #124600",
"#C c #146206",
"#s c #195912",
"#w c #1a6e14",
"#K c #248000",
"#v c #299b00",
"#A c #2d892a",
"#y c #32492f",
"#G c #339900",
"#l c #359d00",
"#E c #3d533a",
"#B c #51a92a",
"#P c #80a47d",
"#J c #88c46a",
"#c c #8b4040",
".7 c #8b4749",
"#g c #954342",
".I c #971000",
".E c #980500",
".D c #9a0900",
".1 c #9d0c00",
".Q c #9f0800",
"#z c #a3b97f",
".M c #a40500",
".N c #aa0500",
".S c #b11900",
".X c #b61000",
".T c #b78d8d",
".J c #bf9c9c",
".R c #c62100",
".F c #c62a0e",
"#D c #c6d7c5",
".A c #c9a6a6",
".8 c #cb2200",
"#H c #d0e7c4",
".u c #d20e00",
".Z c #d29296",
".5 c #d42700",
"#a c #d60100",
"#t c #e0a2a2",
".C c #e22100",
"#e c #e61600",
"#f c #e62c00",
".b c #e71616",
".a c #e71717",
".c c #e71818",
"#. c #e91919",
".h c #e92321",
".K c #e93840",
".p c #eb0f00",
".k c #eb454a",
".B c #ec3e40",
".2 c #ec4d4d",
".P c #ec5644",
".o c #ed0e00",
".U c #ed4a4a",
"#i c #ee0400",
"#n c #ee1903",
".s c #ee3a34",
".j c #ef7979",
".# c #ef7c7c",
".t c #f00600",
"#m c #f00606",
".w c #f11000",
".4 c #f20e00",
".z c #f21500",
".f c #f26061",
".r c #f27d7e",
".G c #f42800",
".e c #f49e9e",
".d c #f4b2b2",
".3 c #f67c7b",
".i c #f6afaf",
".n c #f81a00",
".q c #f8b2b2",
".V c #fa3f15",
"#p c #fb3200",
"#k c #fb3300",
"#o c #fb3600",
"#q c #fc3800",
".6 c #fc6b58",
".Y c #fc7c78",
".O c #fd99a0",
".m c #ff2000",
".x c #ff3100",
".0 c #ff3400",
".9 c #ff3500",
"#j c #ff3700",
".v c #ff3a00",
".y c #ff3d00",
".H c #ff3e00",
".W c #ff5b34",
".l c #ff6243",
"#h c #ff8e8f",
"#b c #ff9a98",
"#d c #ffa696",
".L c #ffb29e",
".g c #ffb6ae",
"## c #ffc9c0",
"Qt c #ffffff",
"QtQtQtQtQtQt.#.a.b.c.dQtQtQtQtQtQtQt",
"QtQtQtQtQt.e.f.g.g.g.h.iQtQtQtQtQtQt",
"QtQtQtQtQt.j.k.l.m.n.o.p.qQtQtQtQtQt",
"QtQtQtQt.r.s.t.u.v.w.x.y.z.AQtQtQtQt",
"QtQtQtQt.B.g.C.D.E.v.F.G.H.I.JQtQtQt",
"QtQtQtQt.K.L.M.N.g.O.I.P.Q.R.S.TQtQt",
"QtQtQt.U.V.W.v.I.I.I.X.Y.Z.I.0.1QtQt",
"QtQt.2.3.4.v.5.I.6.Y.Y.Y.7.8.9.1QtQt",
"QtQt#.###a.I.I.I#b.v.v.v.I.v.1QtQtQt",
"QtQtQt#c#d#e.L.L.1.I.I.I#f.1QtQtQtQt",
"QtQtQtQt#g#h#i#j.L.L.L#k#j.1Qt#lQtQt",
"QtQtQtQtQt#m#n#o#p#q.1.1.1#rQt#sQtQt",
"QtQtQtQtQtQt#t.1.1.1#u#v#wQtQt#x#yQt",
"QtQtQtQtQtQtQtQt#z#A#B#CQtQt#D#x#EQt",
"QtQtQtQtQtQtQtQtQtQtQt#F#G#H#I#x#EQt",
"QtQtQtQtQtQtQtQtQtQtQt#J#F#K#L#M#yQt",
"QtQtQtQtQtQtQtQtQt#lQtQt#l#F#N#OQtQt",
"QtQtQtQtQtQtQtQtQtQt#l#lQt#F#PQtQtQt"};

static const char* const image148_data[] = { 
"18 18 102 2",
".g c #000000",
"#w c #020202",
"#l c #040404",
"#B c #060606",
"#F c #090909",
"#r c #0b0b0b",
"#G c #0e0e0e",
".K c #101010",
"#v c #111111",
"#c c #111416",
"#d c #151c20",
"#s c #161616",
"#A c #181818",
".9 c #1f2b33",
".q c #202020",
"#e c #202930",
".2 c #222f38",
"#b c #232323",
".6 c #283741",
".5 c #2a3034",
"#m c #2d2d2d",
".7 c #2d3e4a",
".8 c #2e3f4b",
"#f c #2f383f",
".U c #2f404d",
".o c #303030",
"#j c #323232",
"#C c #373737",
".N c #3a4f5f",
".R c #3e5566",
".z c #404040",
".I c #41505b",
".x c #41596b",
".E c #435d6f",
".0 c #445e70",
"#z c #484848",
".S c #4c687d",
".L c #4d606f",
"#E c #4e4e4e",
"#a c #4f4f4f",
".H c #54697a",
"#p c #555555",
".s c #55758c",
".T c #587991",
".M c #5b7d96",
".j c #5b7e97",
"#g c #63686c",
".d c #658297",
"#x c #676767",
".V c #676f75",
".c c #68869b",
".w c #6a8ca5",
".t c #6b8da6",
".P c #707070",
".Q c #707c84",
"#I c #717171",
".l c #7192a9",
".4 c #757575",
".X c #7c8184",
".h c #7f7f7f",
".p c #808080",
".A c #81929e",
".u c #819eb3",
"#i c #828282",
".e c #8598a6",
"#t c #868686",
"#u c #888888",
"#. c #8a8e91",
"#J c #8b8b8b",
".b c #8ba1b0",
".v c #8ba6b9",
".# c #8c8c8c",
".J c #9c9c9c",
".n c #9ca7af",
".D c #9eb4c4",
".W c #9f9f9f",
"#h c #a9abac",
".y c #b0b6bb",
"## c #b4b4b4",
"#n c #b6b6b6",
".f c #b6bec5",
"#D c #bababa",
".r c #bac3ca",
"#H c #bbbbbb",
".a c #bbc5cd",
"#q c #bccbd6",
".Y c #c3c8cb",
".1 c #c3c8cc",
"#o c #c6c6c6",
".O c #c7cacd",
".Z c #c8cfd4",
".m c #cbd3d9",
".G c #cfcfcf",
".B c #cfd8df",
".k c #d4dee5",
".F c #d6d9dc",
"#y c #dbdbdb",
".C c #dde5eb",
".i c #e5e9ec",
".3 c #ededed",
"#k c #fefefe",
"Qt c #ffffff",
"QtQtQt.#QtQtQtQtQtQt.a.b.c.d.e.fQtQt",
"QtQtQt.g.hQtQtQtQt.i.j.k.l.k.j.m.nQt",
"QtQtQt.o.p.qQtQt.r.s.t.u.v.u.w.s.x.y",
"QtQtQt.zQt.pQtQt.A.B.l.C.D.C.l.B.E.F",
"QtQt.h.zQt.GQtQt.H.s.w.u.v.u.t.s.x.I",
".J.g.g.KQtQtQtQt.L.m.M.k.l.k.j.m.N.O",
".g.g.g.PQtQtQtQt.Q.R.S.s.T.s.S.R.U.V",
".#.h.WQtQtQtQtQt.X.Y.N.Z.0.Z.N.1.2Qt",
"QtQtQtQtQtQtQt.3.4.5.6.7.U.8.6.9#.Qt",
"QtQtQtQtQtQtQt###a#b#c#d#e#f#g#hQtQt",
"Qt.g.gQtQtQt.3#i#j#k#l#m#nQtQtQtQtQt",
".gQtQt.gQtQt#o#p#q#r#s#tQtQtQtQtQtQt",
".gQtQt.gQtQt#u#m#v#w#xQtQtQtQtQtQtQt",
"QtQt.gQtQt#y#z#A#B#CQtQtQtQtQtQtQtQt",
"QtQt.gQtQt#D#E#F#GQtQtQtQtQtQtQtQtQt",
"QtQt.gQtQt.g#H#IQtQtQtQtQtQtQtQtQtQt",
"QtQtQt.g.g#J#JQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image149_data[] = { 
"18 18 42 1",
"b c #000000",
"K c #101010",
"L c #404040",
"x c #4d4d4d",
"j c #586f3b",
"e c #627c42",
"y c #727272",
"C c #767676",
"# c #8c8c8c",
"g c #8eb460",
"N c #959595",
"F c #999999",
"u c #99c167",
"A c #9d9d9d",
"d c #9f9f9f",
"w c #a5a5a5",
"G c #aeaeae",
"M c #afafaf",
"l c #afdd76",
"q c #be9968",
"E c #cbcbcb",
"z c #cccccc",
"f c #cfcfcf",
"D c #d2d2d2",
"J c #d9d9d9",
"m c #dcdcdc",
"a c #dfdfdf",
"I c #e5e5e5",
"r c #e9e9e9",
"i c #eecda1",
"k c #efefef",
"B c #f2f2f2",
"H c #f5f5f5",
"c c #f9f9f9",
"v c #fcfcfc",
"t c #fdc67c",
"n c #fed093",
"p c #fed59f",
"s c #fedaaa",
"o c #fedfb6",
"h c #fee5c3",
". c #ffffff",
"..................",
"#..#.......#..#...",
"#..#...a...#..#...",
"#..#...bc.....#...",
"#....debeee.......",
"...fegehijgegk....",
".kfeglehiellgem...",
".keglgnopqlllger..",
".egllessnteullgev.",
"kelllesqqqejeeeew.",
"deeeeeexb#eeyzfAeB",
"eCzDEeFfbzkGzr..GH",
".aI..vJBKz........",
"........Lz........",
"........Lz........",
"........LzzL......",
"........MLLM......",
".........NM......."};

static const char* const image150_data[] = { 
"18 18 88 2",
".D c #430023",
"#u c #4c0d2e",
"#j c #570f30",
"#n c #570f31",
"#i c #571032",
"#g c #5d2643",
".F c #601b3b",
"#d c #612b48",
".t c #64052b",
".h c #652042",
".0 c #662846",
".v c #662a48",
".a c #66304c",
"#t c #6c1136",
".e c #6f072e",
".c c #702043",
".R c #702245",
".b c #702446",
".f c #72405a",
".m c #7b1d43",
".H c #7c2f51",
".n c #83596f",
"#c c #876677",
".p c #900b36",
"#b c #9b0d39",
".8 c #9c2f55",
".7 c #a17f91",
".E c #b0103f",
".C c #b22c55",
"#o c #b2a6ac",
".d c #b89fac",
".u c #bba6b1",
"#k c #bbb2b7",
"#f c #c61444",
".Z c #cccccc",
"#p c #cfcfcf",
".g c #d0bfc8",
".P c #d11547",
".Q c #d2d2d2",
"#r c #d3c7cd",
"#l c #d6d6d6",
"#m c #d7cad1",
".i c #d88aa9",
".# c #dccfd6",
".l c #e0648a",
".w c #e39ab7",
"#h c #e5e5e5",
".q c #e7184c",
".o c #e7dfe3",
".1 c #ec6f94",
"#v c #ececec",
".G c #efefef",
".r c #f21a4f",
".6 c #f21d51",
"#a c #f22155",
".5 c #f32f60",
"## c #f33263",
".Y c #f43a6a",
"#e c #f43f6e",
".O c #f4416f",
".s c #f44371",
".4 c #f44472",
"#. c #f5517d",
".X c #f5527e",
".3 c #f55883",
"#s c #f5f5f5",
".9 c #f65a85",
".N c #f65b85",
".B c #f65d87",
".W c #f66a92",
".M c #f7769c",
".A c #f7799e",
".2 c #f77ba0",
".V c #f880a4",
".k c #f88aac",
".S c #f990b2",
".L c #f991b2",
".U c #f992b3",
".z c #f995b6",
".T c #f998b8",
".j c #f99fbe",
"#q c #f9f9f9",
".I c #faa7c5",
".K c #faaac7",
".y c #fab1cd",
".J c #fbb7d2",
".x c #fbc3dc",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"Qt.#.a.b.c.a.dQtQtQt.d.a.e.e.f.gQtQt",
".g.h.i.j.k.l.m.n.o.f.p.q.r.r.s.t.uQt",
".v.w.x.y.z.A.B.C.D.E.r.r.r.r.r.s.F.G",
".H.I.J.K.L.M.N.O.s.s.r.r.r.r.P.s.e.Q",
".R.S.T.U.V.W.X.Y.s.r.r.r.r.r.P.s.e.Z",
".0.1.2.M.W.3.4.5.6.r.r.r.r.r.P.s.F.Z",
".7.8.B.9#..s###a.r.r.r.r.r.P.s#b#c.Q",
"Qt#d.s#e.s.s#a.r.r.r.r.r.P.s#f#g.Z#h",
"Qt.o#i.s.s.s.s.r.r.r.r.P.s.P#j#k#lQt",
"QtQt#m#n.s.s.s.r.r.r.P.s.P#j#o#p#qQt",
"QtQtQt#r#n.s.s.s.r.P.s.P#j#o#p#sQtQt",
"QtQtQtQt#r#n.s.s.s.s.P#j#o#p#sQtQtQt",
"QtQtQtQtQt#r#n.s.s.q#t#o#p#sQtQtQtQt",
"QtQtQtQtQtQt#r#n.s.t#o#p#sQtQtQtQtQt",
"QtQtQtQtQtQtQt#r#u#o.Z#sQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQt#s#p#vQtQtQtQtQtQtQt"};

static const char* const image151_data[] = { 
"18 18 39 1",
"l c #1f1f1f",
"q c #212121",
"p c #303030",
"J c #3a3a3a",
"j c #474747",
"w c #4a4a4a",
"s c #4e4e4e",
"r c #505050",
"h c #525252",
"d c #565656",
"C c #575757",
"E c #585858",
"B c #5a5a5a",
"v c #5d5d5d",
"u c #5e5e5e",
"t c #5f5f5f",
"m c #606060",
"a c #646464",
"g c #656565",
"c c #666666",
"F c #6b6b6b",
"I c #707070",
"K c #747474",
"x c #767676",
"z c #7e7e7e",
"b c #7f7f7f",
"H c #858585",
"D c #939393",
"e c #989898",
"G c #9d9d9d",
"y c #9f9f9f",
"i c #afafaf",
"n c #bdbdbd",
"# c #bfbfbf",
"o c #cfcfcf",
"A c #d4d4d4",
"f c #efefef",
"k c #fefefe",
". c #ffffff",
"...#aaaaba#.......",
".cdef####ffghi....",
"jkkkllmmen#kkgo...",
"jjekkkkkkkkkdpj...",
"jkqrsttuvwhxyzj...",
"jkkAAAAAAAhrBCj...",
"jkDkkkkkkkDkAeEF#.",
"jkkkkkkkkkkkkkkkgj",
"jkDkkkkkkkDkkkkkkj",
"jkkkkkkkkkkkkkkkkj",
"jkDkkkkkkkDkkkkkkj",
"jkkkkkkkkkkkkkkkkj",
"jkDkkkkkkkGkkkkkkj",
"mHkkkkkkkkkkkkkkkj",
".IJkkkkkkkDkkkkkkj",
"..#ddIIIIIjIIkkkkj",
".............bhKkj",
"................Fj"};

static const char* const image152_data[] = { 
"18 18 65 2",
".n c #000000",
".K c #34697a",
".j c #404040",
".L c #4d8197",
".p c #598da1",
".w c #618895",
".J c #6296aa",
".C c #6596a8",
".a c #666666",
".B c #669fbc",
".v c #66a4c1",
".# c #66ccff",
".8 c #749aa4",
".h c #749ca8",
".9 c #76a0ab",
".t c #7ba3b0",
".M c #7daebe",
".f c #86bfd4",
".l c #88b3bc",
".s c #8ed3ef",
".I c #90bbce",
".c c #926d00",
".E c #93a9b2",
".3 c #93acb4",
".i c #93b3c1",
".m c #95b6be",
".A c #97d3ef",
".d c #999999",
".0 c #9adeff",
".W c #9ae9ff",
"#. c #a0bbc1",
".y c #a0d5f2",
".V c #a5e9ff",
".U c #a5f5ff",
".o c #a6efff",
".7 c #a9c6d4",
".u c #aaf3ff",
".4 c #aef4ff",
".Y c #b0cdd4",
".1 c #b0e9ff",
".R c #b0f5ff",
".z c #b6edfd",
".6 c #b7e6fd",
".F c #b8d3de",
".Z c #baf5ff",
".S c #baffff",
".g c #bee2e6",
".r c #cffbff",
".N c #d1ecf0",
".X c #d2f5ff",
".Q c #d2ffff",
".k c #d3fdff",
".H c #d9eaf2",
".D c #dcf5fe",
".x c #deebef",
".T c #def7f7",
".q c #e3fdff",
".5 c #e6ffff",
".O c #e9ffff",
".P c #f0f9fd",
".G c #f7fcff",
".e c #fefefe",
".2 c #feffff",
".b c #ffcc00",
"Qt c #ffffff",
"QtQtQtQtQt.#.a.b.c.b.c.b.aQtQt.#QtQt",
"QtQtQtQt.#Qt.d.e.b.b.b.b.cQt.#Qt.#Qt",
"QtQt.#QtQt.#.a.c.c.c.c.c.aQtQt.#QtQt",
"Qt.#Qt.#QtQt.f.g.e.e.e.g.hQtQtQtQtQt",
"QtQt.#QtQtQt.i.e.j.e.j.k.l.mQtQt.#Qt",
"QtQtQtQtQt.f.g.e.n.e.n.k.o.pQt.#Qt.#",
"Qt.#QtQtQt.f.e.e.e.q.k.k.o.pQtQt.#Qt",
".#Qt.#QtQt.f.e.j.e.r.k.j.s.pQtQtQtQt",
"Qt.#QtQt.f.t.f.u.j.j.j.u.v.p.wQtQtQt",
"QtQtQtQt.f.x.f.f.y.z.A.B.C.D.p.EQtQt",
"QtQtQt.f.F.G.H.I.J.K.L.M.N.O.D.pQtQt",
"QtQtQt.f.P.e.e.e.e.e.e.Q.R.S.D.pQtQt",
"QtQtQt.f.P.e.e.T.T.a.Q.U.U.V.D.pQtQt",
"QtQtQt.f.P.e.T.T.T.U.U.U.W.X.Y.pQtQt",
"QtQtQtQt.f.T.T.Z.Z.a.R.0.1.2.p.3QtQt",
"QtQtQtQt.f.T.4.R.U.U.0.1.5.p.pQtQtQt",
"QtQtQtQtQt.f.0.0.0.0.6.7.p.8QtQtQtQt",
"QtQtQtQtQtQt.f.p.p.p.p.9#.QtQtQtQtQt"};

static const char* const image153_data[] = { 
"18 18 55 1",
"m c #000000",
"I c #000008",
"Y c #173339",
"C c #2d454b",
"Q c #2d4e55",
"y c #454545",
"s c #474747",
"D c #4a6a71",
"z c #5d6b6e",
"X c #5d9daa",
"0 c #5e9daa",
"M c #65a1ae",
"T c #66a2ae",
"U c #6da6b2",
"P c #73aab5",
"u c #787878",
"a c #7b7b7b",
"c c #7c7c7c",
"b c #7d7d7d",
"i c #7f7f7f",
"N c #808080",
"L c #83b4be",
"Z c #858583",
"e c #858585",
"S c #8b8b8b",
"o c #8d8d8d",
"h c #919191",
"H c #94bec7",
"l c #969696",
"q c #979797",
"n c #9a9a9a",
"v c #9c9c9c",
"r c #9f9f9f",
"K c #9fadb0",
"f c #a0a0a0",
"B c #a0afb2",
"G c #a6c9d0",
"k c #a8a8a8",
"O c #a8cad1",
"F c #b9d4da",
"j c #bdbdbd",
"J c #c0c0c0",
"# c #c1c1c1",
"p c #c3c3c3",
"d c #c4c4c4",
"w c #c5c5c5",
"R c #c7c7c7",
"E c #cadfe3",
"W c #cbdfe3",
"A c #ccdadd",
"x c #d0d0d0",
"V c #dbe9ec",
"t c #efefef",
"g c #fefefe",
". c #ffffff",
"..........#abcd...",
".........efggghi..",
"........jkglmngop.",
"........agqgrgqgs.",
"..#abcdtcgmrmfmgs.",
".efggghiugngfgvgs.",
"jkglmngolhgqmvgsw.",
"agqgrgxgyzogggss..",
"cgmrmfmgsABsssC..D",
"cgngfgxgsEFGHHI.DD",
"JhgqmvgsKFGHLLIMDD",
".NogggssFOHLPPIMQQ",
"..RsssSFGHLPTTIMQQ",
"...UVWFGHLPTXXIIYQ",
"...UWFGHLPTXXXI.IY",
"...IIIIIIIIIIII..I",
"....ZI0....0IZ....",
"...IIIII..IIIII..."};

static const char* const image154_data[] = { 
"18 18 173 2",
"#w c #000000",
".c c #582e0f",
".O c #5c2d09",
".N c #5d2e08",
".M c #5f330d",
"#G c #60320c",
".# c #643c1c",
"#S c #666666",
".E c #673e1f",
".l c #693009",
".m c #6d360c",
".e c #6f4218",
".Q c #6f4422",
".X c #734623",
"aw c #735845",
".n c #743c11",
".7 c #774926",
"#u c #78451e",
"#g c #7c4924",
".k c #7d3d0d",
"aQ c #7f4d26",
"#W c #834d1c",
".L c #86501f",
".a c #885927",
"ak c #8c5423",
".F c #8e6d53",
".b c #8f511e",
"aJ c #8f7560",
".o c #92745a",
"aK c #934f18",
"aO c #935019",
"aL c #945119",
"aN c #95521a",
"aM c #95531a",
"ax c #965018",
"aP c #985019",
"aI c #988578",
".x c #9c571f",
".I c #9c7237",
".R c #a37a40",
"#9 c #a49183",
"a. c #a9692c",
".y c #ae9f95",
"ay c #b46321",
".H c #b6a69c",
".p c #b88d46",
"az c #bd6d26",
".P c #c4752a",
".d c #cccccc",
".s c #d26a22",
".T c #d36925",
".6 c #d76e1e",
".f c #d9ad5c",
".i c #da7226",
".2 c #da8236",
"#f c #db6f1c",
"#t c #db6f1e",
"av c #db7a2a",
".W c #db7f2a",
"## c #db833b",
"aH c #db8532",
"al c #db8c3b",
".3 c #de893b",
"#F c #df7723",
".U c #df8033",
".1 c #df8f43",
"#b c #df9041",
"#U c #e2862d",
".j c #e37826",
"#Q c #e37e27",
"#E c #e3822a",
".D c #e38625",
"#7 c #e38930",
"#8 c #e6822c",
"am c #e6923c",
"#o c #e69a49",
"#p c #e69c4c",
"#s c #e8862a",
".r c #e89840",
"#V c #ea822c",
"#P c #ea993a",
"ai c #ea9b3f",
".t c #eb852b",
"aj c #ec8c33",
"#e c #ec8e31",
"#m c #ecab58",
"#l c #eeb369",
".u c #ef872a",
"au c #ef9539",
".5 c #ef9838",
"at c #efa145",
"#D c #efa343",
"#T c #efa443",
"#6 c #efa545",
"as c #efa949",
".h c #efa94f",
".4 c #f0af52",
"ah c #f2ad4c",
"#r c #f2ae4e",
"#c c #f2b35b",
"aa c #f2b65d",
"#. c #f2bc71",
"an c #f3a347",
"#B c #f3bc66",
"#Y c #f3be67",
".V c #f4a847",
"ag c #f4b350",
".B c #f4b353",
"#5 c #f4b754",
"#d c #f4b857",
"aA c #f69a3b",
"ao c #f6af50",
"#O c #f6b754",
"af c #f6bb59",
"aB c #f7a140",
"ar c #f7bd5c",
"ap c #f7be5f",
".C c #f8a33a",
"aF c #f8a544",
"#4 c #f8c160",
".K c #f8c260",
"aq c #f8c261",
"#a c #f8c86e",
".J c #f8e383",
"aG c #faa142",
"aE c #faa844",
"aD c #faab46",
"aC c #fbaa46",
".q c #fbce6c",
"#A c #fbce74",
"#R c #fbcf79",
"#y c #fbd588",
"#q c #fccd6f",
"ae c #fcd175",
"ab c #fcd279",
"#Z c #fcd37e",
"#x c #fce2a4",
"a# c #feb75a",
"#3 c #fed378",
"#C c #fed379",
"ad c #fed67a",
"ac c #fed77b",
".G c #fefdfd",
"#h c #fefefe",
".v c #ff9a35",
".w c #ffb247",
"#X c #ffc066",
".S c #ffc86e",
".A c #ffd171",
"#H c #ffd275",
"#2 c #ffd980",
"#z c #ffd981",
"#N c #ffda7f",
"#M c #ffdc89",
"#0 c #ffdf8f",
"#1 c #ffdf90",
"#L c #ffe39e",
"#J c #ffe49e",
"#k c #ffe4a5",
"#n c #ffe689",
"#v c #ffe7a4",
"#K c #ffe7ab",
"#I c #ffe892",
".0 c #ffeb99",
".9 c #ffeba9",
"#j c #ffecb0",
".g c #ffee88",
".z c #fff28e",
"#i c #fff29b",
".8 c #fff4ad",
".Y c #fff7b4",
".Z c #fffbae",
"Qt c #ffffff",
"QtQtQtQtQt.#.a.a.b.c.dQtQtQtQtQtQtQt",
"QtQtQtQt.e.f.g.h.i.j.k.l.m.n.o.dQtQt",
"QtQtQtQtQt.e.p.q.r.s.t.u.v.w.x.y.dQt",
"QtQtQtQtQtQt.e.z.A.B.C.D.E.E.F.dQtQt",
"QtQtQtQtQt.G.H.I.J.K.E.E.dQtQtQtQtQt",
"QtQtQtQtQtQt.L.M.N.O.P.Q.dQtQtQtQtQt",
"QtQtQtQt.L.L.R.S.T.U.V.W.X.dQtQtQtQt",
"QtQtQt.L.Y.Z.0.1.2.3.4.5.6.7.dQtQtQt",
"QtQt.L.8.Y.9#.###a#b#c#d#e#f#g.dQtQt",
"#h.L#i.8#j#k#l#m#n#o#p#q#r#s#t#u.dQt",
"Qt.L#i#v#w#x#y#z#w#A#B#C#w#D#E#F#G.d",
".L#H#I#J#w#K#L#M#w#N#N#N#w#O#P#Q#G.d",
".L#H#R#S#S#w#S#w#S#w#S#w#S#S#T#U#V#G",
"#W#X#Y#Z#0#w#1#w#2#w#3#w#4#5#6#7#8#G",
"#9a.a#aa#aab#wacadae#wafagahaiaj#G.d",
"Qtakalamanao#wapaqar#wahasatauav#G.d",
"QtQtawaxayazaAaBaCaDaEaFaGaH#G#G.dQt",
"QtQtQtQtaIaJaxaKaLaMaNaOaPaQ.d.dQtQt"};

static const char* const image155_data[] = { 
"18 18 159 2",
"ax c #6f2e07",
"#y c #795236",
"aB c #7a2b06",
".# c #7f5b45",
".r c #80511f",
".P c #805745",
"av c #824328",
"as c #845945",
".d c #845d39",
"#j c #87431c",
".z c #886348",
".6 c #8a3b08",
".j c #8b5e2a",
"aA c #8c5a45",
"#m c #8c6235",
".A c #8e6840",
"#I c #8e6f64",
"#S c #8f5d22",
".t c #8f6a52",
".N c #944708",
"ay c #947266",
".Q c #957866",
".B c #96682a",
".C c #966b38",
".m c #967867",
".f c #967868",
".K c #976214",
"ab c #977155",
"#x c #985c3d",
".D c #986f47",
".y c #987d74",
".L c #995f09",
"an c #9a4b05",
".7 c #9c8982",
".M c #9d5608",
"aa c #9e501b",
".O c #9f6845",
".c c #a06d13",
".8 c #a1742d",
"ai c #a2550b",
".E c #a38161",
".n c #a38b83",
"ah c #a6735b",
"#1 c #a67c68",
"ap c #a9591f",
".i c #ab9f9b",
".h c #ac7c1f",
"#H c #af816b",
"aw c #af9a92",
"at c #b54a06",
"am c #b69d94",
"#k c #b6aba8",
".R c #b88927",
".J c #b98b2b",
"#R c #b9ada8",
".a c #baa8a2",
"#2 c #bca9a2",
"af c #be6326",
"#3 c #bf7e0d",
"aq c #bf9789",
"#Q c #c46e12",
"ag c #c59a8b",
"#l c #c6b7b1",
".e c #cccccc",
"aC c #d1c5c1",
"#G c #d2771a",
"az c #d2c5c1",
"ar c #d3c6c1",
"al c #db5c08",
".b c #ddd4d0",
"#w c #df8513",
".x c #dfba48",
".o c #e0c46f",
"ao c #e37b08",
".F c #e3d5bb",
".s c #e8e2e0",
"ae c #ea8416",
"#7 c #eb8d1c",
".g c #ebc135",
"#J c #ebc342",
".l c #ebc53f",
"#z c #ecce61",
"aj c #ee8007",
"#n c #eed16b",
"#0 c #f08b0e",
"#i c #f08d0d",
"#8 c #f09a12",
".3 c #f6b00e",
"#Z c #f7a010",
"#h c #f7a412",
"#Y c #f7aa17",
"a. c #f8950b",
"ad c #f89912",
".4 c #f89c09",
"ac c #f89f07",
"#9 c #f8a20b",
"#4 c #f8aa1a",
"#O c #f8ad26",
"#X c #f8ae20",
".2 c #f8bc23",
"#N c #f8bd31",
"#T c #f8be2b",
"#L c #f8c946",
".1 c #f8ca3c",
"#D c #f8cb47",
"#e c #f8cc50",
"#K c #f8ce48",
".S c #f8d951",
".k c #f8d953",
"a# c #f9860b",
"#v c #f9a120",
"#P c #f9a21b",
"#g c #f9ac22",
"#W c #f9ad29",
"#V c #f9ae2d",
"#U c #f9b42e",
"#E c #f9b435",
"#f c #f9ba37",
"#M c #f9c63e",
"#6 c #fa9920",
"#5 c #fa9d20",
"#F c #faa227",
"#u c #faa92f",
"#t c #fabe43",
"#s c #fad65e",
"#C c #fad75b",
".0 c #fad95b",
".q c #fada5a",
"#B c #fadc67",
".9 c #fadf69",
"#A c #fadf6e",
"#d c #fadf72",
".w c #fae06e",
".p c #fae070",
".T c #fae273",
".5 c #fb8507",
".I c #fbe37d",
".Z c #fbe47f",
"#r c #fbe687",
"#. c #fbe78b",
"#o c #fbe78c",
".v c #fbe78d",
"ak c #fc7707",
".U c #fcea9a",
".H c #fceca3",
".u c #fceea7",
"## c #fceead",
"#p c #fcefb6",
"#q c #fdf1be",
"#c c #fdf3c3",
".Y c #fdf4c4",
"#a c #fdf8db",
"au c #fe5a04",
".V c #fef3c5",
".G c #fef4ca",
".X c #fefae6",
".W c #fefbe9",
"#b c #fefbeb",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQt.#.aQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQt.b.c.d.eQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQt.f.g.h.iQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQt.j.k.l.m.eQtQtQtQtQtQt",
"QtQtQtQtQtQt.n.o.p.q.r.eQtQtQtQtQtQt",
"QtQtQtQtQt.s.t.u.v.w.x.y.eQtQtQtQtQt",
".z.A.B.C.D.E.F.G.H.I.q.J.K.L.M.N.O.P",
".Q.R.S.T.U.V.W.X.Y.Z.0.1.2.3.4.5.6.7",
"Qt.n.8.9#.###a#b#c#d#e#f#g#h#i#j#kQt",
"QtQt#l#m#n#o#p#q#r#s#t#u#v#w#x.eQtQt",
"QtQtQt.b#y#z#A#B#C#D#E#F#G#H.eQtQtQt",
"QtQtQtQt#I#J#K#L#M#N#O#P#Q#RQtQtQtQt",
"QtQtQtQt#S#T#U#V#W#X#Y#Z#0#1QtQtQtQt",
"QtQtQt#2#3#4#5#6#7#8#9a.a#aa.eQtQtQt",
"QtQtQtabacadaeafagahaiajakalamQtQtQt",
"QtQt.sanaoapaq.e.e.earasatauav.eQtQt",
"QtQtawaxay.eQtQtQtQtQt.eazaAaBaCQtQt",
"QtQtQt.e.eQtQtQtQtQtQtQtQtQt.e.eQtQt"};

static const char* const image156_data[] = { 
"18 18 30 1",
"k c #000000",
"# c #431935",
"v c #591100",
"d c #712224",
"a c #73333b",
"e c #752a2a",
"m c #773438",
"n c #783b40",
"j c #7c3a39",
"h c #814949",
"i c #844545",
"l c #8f4d3d",
"p c #911528",
"r c #914035",
"q c #ab565d",
"y c #dda9b1",
"x c #e3cdc8",
"t c #e51d55",
"z c #e92a61",
"B c #ec2b62",
"w c #ecb857",
"A c #ee2862",
"c c #efbbc5",
"f c #fbf8f8",
"b c #ff0033",
"s c #ff6a95",
"o c #ffcc66",
"g c #ffde9b",
"u c #ffe468",
". c #ffffff",
"..........#a#a#...",
".bbcbb...aad#e##..",
".bbbbb..fagga#hi#.",
"..bbb....#ggga#j#.",
"...b.....#gkg#lm#.",
"........ngggggon#.",
"........ngggggn#n.",
".........nggbgnn#.",
"..........bbgo#nn.",
"........ppqgo#pnn.",
".rr....psstgopsntp",
"ruurrrrpstto#ststp",
"vwwuuuupttttpssttp",
"xvvvvvrrppttpsttpy",
"..xxxruurrrrupzzp.",
".....vwwuuuuuuppy.",
".....xvvvvvvvvApy.",
".......xpBBBBBBpy."};

static const char* const image157_data[] = { 
"18 18 29 1",
"c c #2f404d",
"A c #577890",
"x c #5e7281",
"v c #678aa3",
"w c #688ba4",
"h c #737474",
"# c #7b99af",
"t c #7c90a0",
"q c #7e9cb1",
"s c #7f9db2",
"z c #92a7b7",
"m c #94acbe",
"n c #95adbf",
"u c #9cb3c3",
"y c #9db3c4",
"j c #a9bdcb",
"p c #abbfcc",
"r c #acbfcd",
"o c #b9c9d5",
"l c #bacad5",
"k c #bbbaba",
"g c #bccbd6",
"i c #c7d4dd",
"d c #cbd7df",
"e c #ccd8e0",
"f c #d3dde4",
"b c #d8e1e7",
"a c #fefefe",
". c #ffffff",
"..................",
"..................",
"..................",
".####........####.",
"#abbbc......#abbbc",
"#aaaac......#aaaac",
"#addec......#adedc",
"#fgggchhhhhh#fgggc",
"#ijjjckkkkkk#ijjjc",
"#lmnmchhhhhh#onmmc",
"#pqqqccccccc#rsqqc",
"tuvwvc......tuvvwc",
"xywwwc......xywwwc",
"xzAAAc......xzAAAc",
".cccc........cccc.",
"..................",
"..................",
".................."};

static const char* const image158_data[] = { 
"18 18 153 2",
".Y c #005b83",
"#o c #005f8c",
"#l c #006396",
".B c #006a9c",
".K c #006d9d",
"#a c #0081bf",
"#m c #0084c7",
"#n c #0086c8",
".h c #008fd2",
".k c #0094d5",
".r c #009ce2",
".l c #015278",
".e c #044969",
".8 c #06a1e9",
".i c #07a1e8",
"#A c #083f5c",
".j c #09a1e8",
".s c #0a3d54",
"## c #0ea5e9",
".w c #0f3441",
".X c #10a5ea",
".7 c #122834",
".d c #122934",
"#z c #152229",
"#w c #1a1617",
"#p c #1f2c31",
"#b c #1f2c32",
"#I c #241f1c",
"#s c #242020",
"#E c #242021",
"#N c #251f1a",
"aw c #282526",
".A c #2daeec",
".t c #301f18",
".H c #302018",
".9 c #32b0ec",
"an c #332a26",
".v c #373334",
"#. c #38b1ec",
".J c #39b1ec",
".n c #41b3ec",
".g c #454243",
".u c #462918",
"#d c #464039",
".L c #473c27",
".q c #4fb7ee",
"#L c #522c18",
".C c #52371e",
".c c #535051",
"#M c #5e3a1d",
".R c #5f3519",
".o c #5f9cbf",
".T c #5fb1de",
".p c #639cbf",
"av c #6a3518",
"#5 c #6c391a",
".f c #706e6e",
".W c #72c2f0",
"#7 c #793918",
"af c #793a18",
".x c #7ab0d2",
".Z c #7b6e4c",
"#U c #7c683b",
"#6 c #7f7c7d",
"au c #863e19",
"#e c #877d67",
"#T c #897a58",
".S c #8c8a8b",
"#t c #958f82",
"#j c #974d1d",
".G c #97501f",
"#q c #978c6f",
".z c #97d0f3",
"#H c #988b6a",
".m c #9a9999",
".U c #a2d5f4",
".I c #a4d5f6",
"ao c #a64918",
".V c #a6d7f5",
"#k c #a9a7a8",
"as c #b6511a",
"am c #b6551b",
"#W c #b65c1f",
"at c #b7b6b6",
"#v c #b8a77a",
".y c #bbccd8",
"#D c #c5bda5",
"ae c #c65e1d",
".a c #c6c5c5",
"#O c #cbb169",
"#h c #cdaa50",
".6 c #d4d3d3",
"#y c #d86e23",
"#c c #d8c99d",
"#B c #dcc178",
".# c #e2e2e2",
"#r c #e6debd",
".5 c #eb7e26",
".Q c #eb8128",
".b c #f1f0f0",
"#R c #f7edcd",
"ap c #f8681a",
"ar c #f86c1b",
"aq c #f86e1d",
"#u c #f8ecc2",
"#G c #f8edc7",
"#F c #f8edc9",
"#X c #f9701e",
"ag c #f9721f",
"#S c #f9e8b5",
"#Q c #f9eabf",
"#K c #fa7d23",
"#C c #fae9b1",
"#f c #fbe6a9",
"#8 c #fc7d24",
".F c #fc8728",
"al c #fc8928",
"#P c #fce5a2",
"#2 c #fce5a3",
"#1 c #fce6a6",
"ah c #fd9630",
"#0 c #fde59b",
".E c #fe9830",
".D c #fe9c31",
".1 c #fee292",
"#3 c #fee293",
".0 c #fee294",
"ad c #ffa235",
"ak c #ffaa3a",
"#i c #ffaf3d",
"#Y c #ffb23f",
"#9 c #ffb440",
".P c #ffb641",
"aj c #ffba45",
"#V c #ffbb43",
"ai c #ffbc47",
".4 c #ffc14a",
"#x c #ffc44b",
"#J c #ffc64e",
"ac c #ffcb53",
".O c #ffcf57",
"a. c #ffd25e",
".N c #ffd564",
".M c #ffd665",
"ab c #ffd769",
".3 c #ffd76a",
"a# c #ffd86f",
"#4 c #ffdb78",
"aa c #ffdc76",
".2 c #ffe082",
"#Z c #ffe083",
"#g c #ffe189",
"Qt c #ffffff",
"QtQtQt.#.a.a.#QtQtQtQtQtQtQtQtQtQtQt",
"Qt.b.c.d.e.e.d.f.bQtQtQtQtQtQtQtQtQt",
".b.g.h.h.i.j.k.l.gQtQtQtQtQtQtQtQtQt",
".m.h.n.n.o.p.q.r.s.t.u.u.v.f.#QtQtQt",
".c.n.w.x.y.w.z.A.B.C.D.E.F.G.H.mQtQt",
".c.n.w.x.y.w.I.J.K.L.M.N.O.P.Q.R.SQt",
".c.n.T.T.U.V.W.X.Y.Z.0.1.2.3.4.5.H.#",
".6.7.8.8.9#.###a#b#c#d#e#f#g#h#i#j.f",
"Qt#k.7#l#m#n#o#p#q#r#s#t#u#v#w#x#y.c",
"QtQt.#.c#z#A#w#B#C#D#E#F#G#H#I#J#K.c",
"QtQtQt#k#L#M#N#O#P#Q#R#F#S#T#U#V#W.c",
"QtQtQt.#.t#X#Y.M#Z#0#1#2#3#4.O.E#5.m",
"QtQtQtQt#6#7#8#9a.a##4aaabacadae.v.b",
"QtQtQtQt.b.gafagah#Yaiajakalaman.6Qt",
"QtQtQtQtQtQt.S.taoapaqaras#L#L.#QtQt",
"QtQtQtQtQtQtQtat#wauav.taw.aQtQtQtQt",
"QtQtQtQtQtQtQt.f#wawaw.#QtQtQtQtQtQt",
"QtQtQtQtQtQtQt.f.f.bQtQtQtQtQtQtQtQt"};

static const char* const image159_data[] = { 
"18 18 45 1",
"b c #c71823",
"i c #cccccc",
"f c #d72224",
"l c #d7222d",
"J c #d72236",
"N c #db3938",
"y c #dc3930",
"n c #dd2829",
"k c #dd2f28",
"B c #de2125",
"e c #de2621",
"t c #de2e21",
"a c #df524d",
"E c #e04946",
"P c #e1413e",
"q c #e1483e",
"z c #e23738",
"v c #e24037",
"Q c #e4615b",
"s c #e58788",
"F c #e65357",
"p c #e65953",
"r c #e74e4c",
"c c #e77a77",
"w c #e84e45",
"C c #e87170",
"M c #ea6861",
"K c #ea9596",
"u c #eb8d8e",
"D c #ec5f5a",
"d c #ec8b86",
"H c #efaeaa",
"o c #f0a4a2",
"L c #f0ada2",
"j c #f1c7c6",
"G c #f29b94",
"h c #f2bfc1",
"x c #f3bcb8",
"m c #f5b4b0",
"I c #f6aba9",
"g c #f8cdce",
"# c #fbe9ed",
"A c #fce5e2",
"O c #fddcda",
". c #ffffff",
"......#abbc.......",
"......dbeefg......",
"......cbeefhi.....",
"......jkllaii.....",
"....mmmmmmmmmm....",
"...mnbbbbbbbbno...",
"...pbebfeeefefqi..",
"...resbeefttukvi..",
"...wfxbfteekxyzi..",
"...rAkeeeefeBgri..",
"....CbeftetefDii..",
"...opretqqeeEFG...",
"....iibeGHbtgiii..",
".....AblGIbeii....",
".....AbJKLbfg.....",
".....AbJKLbfgi....",
"......MNjOPQii....",
".......iiiiii....."};

static const char* const image160_data[] = { 
"18 18 25 1",
". c #000000",
"e c #131313",
"k c #171717",
"n c #181818",
"b c #191919",
"u c #202020",
"v c #212121",
"w c #282828",
"m c #292929",
"p c #2c2c2c",
"i c #2e2e2e",
"s c #2f2f2f",
"d c #303030",
"h c #393939",
"o c #3d3d3d",
"t c #3e3e3e",
"g c #444444",
"q c #474747",
"r c #4d4d4d",
"l c #595959",
"# c #777777",
"j c #787878",
"c c #8d8d8d",
"f c #fefefe",
"a c #ffffff",
".#abaaaabacaacaaca",
"a.#bdde..acacacaca",
"aa.......acacacaca",
"aa.f.f..bacacacaca",
"a#.c.f..bacaacaaca",
"aghh....gaaaaaaaaa",
"a.hhh...aaaacaacaa",
"a#.....e.gaacacaca",
"aaaa#.hi.eejcacaca",
"agk.dllhmn..jacaca",
"g..kdllop.#.gaacaa",
"b#abqrqhm.ag.aaaaa",
"aaashthiu.aa#.aa.a",
"aaavmpwvk.aaa#.a.a",
"aaag......gaaa#..a",
"aag.daaaad.ga....a",
"a#d.aaaaaad.#aaaaa",
"g..baaaaaab...aaaa"};

static const char* const image161_data[] = { 
"18 18 32 1",
"v c #000000",
"z c #111111",
"y c #222222",
"D c #555555",
"u c #666666",
"C c #888888",
"A c #999999",
"r c #bbbbbb",
"s c #cccccc",
"f c #cf000e",
"h c #cf0210",
"c c #d00311",
"m c #d31724",
"B c #d41e2b",
"b c #d51f2b",
"e c #d8313c",
"w c #dc4d57",
"x c #dddddd",
"a c #de4f59",
"i c #de525b",
"g c #e78289",
"t c #e78a90",
"n c #e98b91",
"# c #ea8d93",
"d c #eb979d",
"j c #ec9ca1",
"q c #eeeeee",
"k c #f7d7d9",
"l c #fefafa",
"o c #fefcfc",
"p c #fefefe",
". c #ffffff",
"..................",
".....#abcba#......",
"...defffffffed....",
"..ghfijklkjifhg...",
".dhmnoppppponmhd..",
".efnpqrppssppnfe..",
"tfiopuvpuvvupoif#.",
"wfjxyzvsvAsvrpjfa.",
"BfksACvsvCsvCpkfb.",
"cflppCvpDvvvCplfc.",
"BfkppCvppsxvCpkfb.",
"wfjppCvpyDCvxpjfa.",
"tfiopCvpAzzApoif#.",
".efnpppppppppnfe..",
".dhmnoppppponmhd..",
"..ghfijklkjifhg...",
"...defffffffed....",
".....twBcBwt......"};

static const char* const image162_data[] = { 
"18 18 94 2",
".O c #5d0400",
".B c #690200",
".P c #693025",
".4 c #750f0c",
".f c #751110",
".F c #753f34",
".K c #754035",
".D c #7d0003",
".E c #801e19",
"## c #803f37",
"#e c #804039",
".H c #80413a",
".I c #80413b",
".d c #854e4a",
".N c #865c57",
".b c #880005",
".L c #8c3130",
"#a c #8c6057",
"#d c #8c6159",
"#A c #8c6460",
".# c #8f5b57",
"#. c #983d3e",
"#z c #984b4a",
".C c #9c0009",
"#v c #9c6462",
".G c #a27a6e",
".J c #a27c71",
"#y c #a2827e",
"#b c #a37f77",
"#c c #a37f78",
".8 c #a6000c",
".3 c #b0000e",
".M c #b39996",
".6 c #b99380",
"#f c #ba1925",
".2 c #bba4a1",
".a c #bc000f",
".A c #c2acaa",
".5 c #c59f8b",
".w c #c7b3b1",
".j c #cd333e",
"#u c #cebdbb",
".m c #d00014",
".n c #d0c0be",
"#B c #d2c2c0",
"#w c #d4c5c3",
".9 c #d7cac8",
"#x c #dacdcc",
".x c #dc0016",
".c c #dcd0cf",
"#j c #e0192c",
".y c #e30018",
".e c #e3d9d8",
".g c #e4525e",
".v c #e50019",
".z c #e70019",
".Q c #e7c7ab",
".1 c #e7c8ad",
"#k c #ece6e5",
".u c #f1001b",
"#q c #f1011c",
"#g c #f10620",
".7 c #f10c25",
"#t c #f31b32",
".t c #f32439",
"#r c #f41f36",
"#s c #f64154",
"#p c #f64355",
".p c #f64758",
"#i c #f6505f",
"#o c #f65464",
"#l c #f75160",
".q c #f85867",
".s c #f85d6b",
".l c #f85f6c",
".r c #f86572",
"#h c #f86c78",
".o c #f89097",
".k c #f9727e",
".i c #fa7984",
"#m c #fa7c86",
"#n c #fa858e",
".h c #fb838c",
".R c #fee5ca",
".0 c #fee7cd",
".S c #feead3",
".Z c #feedd9",
".T c #fef1e1",
".Y c #fef4e8",
".U c #fff7ed",
".X c #fff8f2",
".V c #fffaf4",
".W c #fffaf5",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQt.#.a.b.c.c.b.a.dQtQtQtQtQt",
"QtQtQt.e.f.g.h.i.j.j.k.l.m.f.eQtQtQt",
"QtQt.n.f.o.o.o.p.q.r.s.t.u.v.f.nQtQt",
"Qt.w.b.v.x.x.y.z.u.u.u.u.u.u.u.b.wQt",
".A.B.C.D.E.F.G.H.C.C.I.J.K.L.D.C.B.M",
".N.O.P.Q.R.S.T.U.V.W.X.Y.Z.0.1.P.O.N",
".2.3.x.4.5.S.T.U.V.W.X.Y.Z.6.f.7.8.9",
"Qt#..a.x.8.D###a#b#c#d#e.D#f.7.a#.Qt",
"QtQt#..x.u.u#g.7.7#h.oQt.o#i#j#.QtQt",
"QtQt#k#..u.u.7#l#h#m#n.o#o#p#.QtQtQt",
"QtQtQt.9#..u#q#g#r.q#s#t.u#.#uQtQtQt",
"QtQtQtQt.9#v.3.v.u.u.v.3#.#wQtQtQtQt",
"QtQtQtQtQtQt#x#y#z#z#A#BQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image163_data[] = { 
"18 18 150 2",
".r c #000000",
"#Q c #5c2403",
".D c #5c2e12",
"aq c #623f2a",
"ag c #633f2a",
"#d c #672f0b",
".p c #6e5347",
".t c #6f3911",
"#P c #6f4626",
".5 c #702900",
".c c #73533b",
".u c #784020",
"ar c #785a4b",
".C c #7b3100",
"#w c #7b3200",
"#G c #7b441d",
"#y c #7d3100",
".8 c #7f3000",
"#I c #813600",
".w c #824411",
"#h c #863b04",
".k c #896d59",
".9 c #897e7e",
"a. c #8a4605",
"#7 c #8c410d",
".V c #955911",
"#b c #9a5b1b",
".X c #9a847a",
"#k c #9b621b",
".W c #9d6e1d",
".S c #9d7241",
".3 c #9e5c22",
"#m c #9e6722",
"ak c #9e9291",
"#8 c #a0928f",
"ah c #a1928e",
".K c #a26010",
"#a c #a47b56",
"#R c #a84e04",
"#c c #a86517",
"#j c #a8958c",
"#i c #a94400",
"#6 c #aa611e",
"ap c #aa794a",
"#A c #aa8f72",
".f c #aa9c7d",
".E c #ab978d",
".4 c #ac4500",
"#H c #b04700",
".Y c #b27930",
".6 c #b35707",
"#U c #b6b1b1",
".G c #bc9450",
"#O c #be915f",
".m c #beaf98",
".g c #c2bbb9",
"#l c #c38c41",
".B c #c45400",
"#g c #c5680e",
"ai c #c5bebd",
"#K c #c65100",
"#e c #c75700",
"aj c #c7c1c0",
".I c #ca670c",
"at c #cec8c7",
"as c #d1cccb",
".U c #d55700",
".L c #d7bb6a",
"#T c #d85700",
".7 c #d89320",
".F c #d9b64f",
"#v c #da5800",
"#9 c #dbd7d6",
".T c #de7417",
".n c #dec066",
"#. c #dfa447",
"af c #e46200",
".H c #e5decc",
".j c #e6d08c",
"#x c #e75e00",
"#J c #e76600",
"#S c #e76902",
".v c #e8d393",
".o c #e9d498",
"al c #ea7b07",
".0 c #ebb06a",
".a c #ebd79f",
".h c #ebd9a3",
"#f c #ec6300",
".P c #ecc38d",
".d c #eddcab",
"#u c #f06f09",
".i c #f1e4be",
".e c #f3e7c5",
".s c #f49a34",
".# c #f4e9c9",
"#3 c #f5943f",
".Q c #f6c989",
"ad c #f8a448",
".b c #f8f2e0",
"#2 c #f9ae6c",
".M c #faf5e8",
".A c #fb8918",
".R c #fbc175",
"#4 c #fd8e28",
"#1 c #fdc58c",
".Z c #fdd18a",
".J c #ff7408",
"#F c #ff861b",
"#5 c #ff942d",
"#t c #ff942e",
"ae c #ff9a36",
"#E c #ff9c3a",
"am c #ff9f32",
"#s c #ffa439",
"an c #ffa43c",
"#D c #ffa640",
"ao c #ffa744",
"a# c #ffb752",
"#C c #ffbe51",
"aa c #ffbe65",
"#n c #ffc05f",
"#B c #ffc15e",
".2 c #ffc26f",
".1 c #ffc272",
"#V c #ffc458",
".z c #ffc867",
"#W c #ffcb7f",
"#r c #ffcc65",
"#0 c #ffce90",
"ac c #ffd191",
"#q c #ffd683",
"ab c #ffd79b",
"#L c #ffd87a",
"#Z c #ffd9a0",
"#Y c #ffda9f",
"#X c #ffdb9b",
"#N c #ffdea7",
"#o c #ffe38f",
"## c #ffe593",
".N c #ffe77f",
"#p c #ffe7a2",
".y c #ffeba3",
"#M c #ffedbd",
".q c #fff0c6",
".O c #fff1c9",
"#z c #fff8ad",
".l c #fff9c8",
".x c #fffbd5",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQt.#QtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQt.aQtQtQt.#QtQtQt",
"Qt.bQtQtQtQtQt.cQtQt.aQtQtQt.dQtQtQt",
"Qt.eQtQtQtQtQt.f.c.g.h.iQtQt.eQtQtQt",
"Qt.jQtQtQtQt.f.k.l.c.m.nQtQt.iQtQtQt",
"Qt.oQtQtQt.p.f.q.r.s.t.uQtQt.vQtQtQt",
"Qt.iQtQt.w.p.x.y.z.A.B.C.D.E.FQtQtQt",
"Qt.#Qt.w.G.H.p.C.C.C.C.I.J.K.LQtQtQt",
"Qt.MQt.w.N.O.P.P.Q.R.S.T.U.V.W.XQtQt",
"QtQt.w.Y.w.Z.Z.0.1.2.3.4.5.6.7.8.9Qt",
"Qt.w#.###a.w.w.w#b#c.w#d#e#f#g#h#i#j",
"#k#l#m#n#o#p#q#r#s#s#s#t#u#v.8#w#x#y",
"#k#z#A#m#m#B#C.r#D#E#F#G#H.8#I#J#K#y",
"#k#L#M#N#O#P#P#Q#Q#Q#Q#Q#Q#R#S#T#y#U",
"Qt#k#V#W#X#Y#Z#0#1#2#3#4#5#6#7#y#8#9",
"QtQt#ka.a.a#aa#Wabac.radaeafagahaiQt",
"QtQtQtajaka.alamanaoaoaoagagaiaiQtQt",
"QtQtQtQtQtQtapa.aqagagarasatQtQtQtQt"};

static const char* const image164_data[] = { 
"18 18 103 2",
".e c #00aaff",
"Qt c #01aaff",
".v c #131e21",
"#B c #15cfff",
"#q c #18d0ff",
"#p c #1ad1ff",
"#c c #1bd0ff",
".t c #1e2020",
".E c #1f2121",
".3 c #1fd1ff",
"#C c #22d1ff",
".U c #22d2ff",
"#b c #22d3ff",
".y c #262626",
".M c #26d2ff",
"#d c #29d2ff",
".F c #2ad2ff",
".z c #2dd3ff",
".f c #303030",
".V c #30d3ff",
"#D c #30d4ff",
".D c #313333",
".w c #31d3ff",
"#r c #34d4ff",
".N c #35d3ff",
".G c #38d4ff",
"#e c #38d5ff",
".A c #3cd5ff",
".l c #3d3d3d",
".x c #40d5ff",
"#E c #40d6ff",
".O c #44d6ff",
".H c #48d7ff",
".h c #4a4a4a",
".B c #4cd7ff",
".4 c #4cd8ff",
".W c #50d8ff",
"#F c #51d8ff",
"#s c #55d8ff",
".P c #55d9ff",
".g c #575757",
"#f c #59d9ff",
".I c #59daff",
".C c #5ddaff",
".X c #61dbff",
".p c #646464",
".Q c #66dbff",
"#t c #66dcff",
".J c #6adcff",
".5 c #6fddff",
".i c #717171",
".Y c #72ddff",
"#G c #73ddff",
".R c #77deff",
".K c #7bdfff",
"#g c #7cdfff",
".a c #7e7e7e",
".6 c #7fe0ff",
"#o c #81e3fc",
".Z c #84e0ff",
"#a c #85e6ff",
"#u c #88e0ff",
".S c #88e1ff",
".m c #8b8b8b",
"#h c #8de1ff",
".7 c #91e2ff",
"#H c #95e2ff",
".0 c #95e3ff",
".j c #979797",
".T c #99e3ff",
"#i c #9de4ff",
".8 c #a2e4ff",
".1 c #a5e5ff",
".u c #a8a8a8",
"#v c #a9e6ff",
"#j c #ace6ff",
".9 c #b0e7ff",
".k c #b1b1b1",
".2 c #b4e7ff",
"#w c #b8e7ff",
"#k c #bce8ff",
".q c #bebebe",
"#. c #bee9ff",
"#I c #c2e9ff",
"#x c #c5eaff",
"#l c #c8eaff",
".o c #cbcbcb",
"## c #cbebff",
"#J c #cfebff",
"#y c #d1ebff",
"#m c #d4ecff",
".n c #d8d8d8",
"#K c #d9edff",
"#z c #dbedff",
"#n c #deeeff",
"#A c #e1eeff",
".L c #f1fcff",
".r c #f2f2f2",
".s c #f2fcff",
".b c #ff7f2b",
".c c #ff8230",
".d c #ffac30",
".# c #ffffff",
"Qt.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#.#",
".#.#.#.#.#.#.#Qt.#.#.#.#.#.#.a.#.#.#",
".#.#.#.b.c.d.#.#.#.#.e.#.#.a.#.#.#.e",
".#.#.#.c.d.f.#.#.#.#.#.#.a.#.#.#.#.#",
".#.#.#.g.f.f.f.h.i.j.g.a.#.#.#.#.#.#",
".#.#.#.#.#.k.l.f.f.f.f.f.m.#.#.e.#.#",
".#Qt.#.#.n.l.f.o.f.f.f.f.p.#.#.#.#.#",
".#.#.#.#.i.i.o.l.f.f.f.f.#.#.#.#.#.#",
".#.#.#.#.#.o.f.f.f.i.q.r.#.#.#.s.t.t",
".e.#.#.#.#.#.a.l.f.f.i.k.u.s.v.t.w.x",
".#.#.#.#.#.#.#.#.q.h.y.t.t.t.z.A.B.C",
".#.#.#.#.e.#.#.#.#.D.E.t.F.G.H.I.J.K",
".#.#.#.#.#.#.#.L.t.t.M.N.O.P.Q.R.S.T",
".#.e.#.#.#.L.t.t.U.V.x.W.X.Y.Z.0.1.2",
".#.#.#.L.t.t.3.z.A.4.C.5.6.7.8.9#.##",
".#.L#a#b#c#d#e.H#f.J#g#h#i#j#k#l#m#n",
"#o#p#q.M#r.O#s#t.R#u.T#v#w#x#y#z#A#A",
"#B#C#D#E#F.X#G.Z#H.1.2#I#J#K#A#A#A#A"};

static const char* const image165_data[] = { 
"18 18 131 2",
"Qt c #0049aa",
".f c #054eae",
".k c #054fae",
".l c #064eae",
".m c #0c55b3",
".q c #0c55b4",
".r c #145db9",
".w c #145dba",
".F c #1d66c0",
".D c #1d66c1",
".x c #1d67c0",
".E c #1e66c1",
".J c #276fc8",
".G c #2770c8",
".K c #2770c9",
".Q c #317ad0",
".L c #317ad1",
".O c #317bd1",
".P c #327ad0",
".1 c #3b84d8",
".2 c #3c84d8",
".Y c #3c84d9",
".0 c #3c85d8",
".Z c #3c85d9",
".# c #406a7f",
"## c #468fe0",
"#. c #468fe1",
"#a c #4690e0",
"#m c #5099e8",
"#n c #5099e9",
"#D c #59a2ef",
"#C c #59a2f0",
".H c #5d8796",
"#S c #61aaf6",
"#T c #61abf6",
".M c #658f9c",
".N c #658f9d",
"#3 c #68b1fb",
"#4 c #68b1fc",
"aa c #6db6ff",
"#R c #707070",
"#b c #71a1cf",
"a# c #78acdf",
".U c #84a2ba",
"a. c #94a3b2",
"#B c #95a1ac",
".T c #99afb6",
".R c #9cb1b7",
"#2 c #9f9f9f",
"#Q c #a0a19f",
"#9 c #a1a3a3",
"#1 c #a2a29f",
"#P c #a7a6a0",
"#o c #a7bcc0",
"#0 c #a9a7a0",
"#E c #aac0c3",
"#A c #abaaa1",
"#8 c #acaaa1",
"#O c #aeaca2",
"#Z c #aeaca3",
"#l c #afada2",
"#z c #b4b1a2",
"#7 c #b4b1a3",
"#N c #b8b3a2",
"#k c #b9b5a4",
"#Y c #bbb6a4",
"#y c #bdb9a4",
"#U c #bdc3b4",
"#6 c #beb8a4",
".V c #bec1ad",
".9 c #c1bba4",
"#M c #c1bba5",
"#c c #c1c7b5",
"#5 c #c2bea6",
"#j c #c3bda5",
"#X c #c5bfa5",
"#x c #c8c1a6",
"#i c #c9c2a7",
".X c #cbc5a7",
".8 c #ccc4a5",
"#L c #ccc4a6",
"#W c #cfc7a6",
".6 c #cfc9a9",
"#w c #d2c9a7",
"#h c #d4cca8",
".W c #d5cda8",
".5 c #d5ceaa",
"#K c #d6cca7",
".7 c #d6cda8",
"#V c #d9cfa8",
".a c #db9200",
"#G c #dcd7af",
"#v c #ddd3a9",
"#p c #dfd9b0",
"#J c #e0d5a9",
"#F c #e0dab0",
"#r c #e1daaf",
".3 c #e2d9ad",
"#g c #e3d8aa",
"#f c #e5d9aa",
"#u c #e7dbaa",
"#e c #e7dcab",
"#I c #eadeab",
"#d c #ece1ac",
".S c #ede1ad",
"#H c #eee2ab",
"#t c #f0e3ac",
".4 c #f3e4ac",
"#s c #f8e8ad",
"#q c #fbecad",
".C c #ffcf0d",
".v c #ffd11c",
".B c #ffd324",
".p c #ffd428",
".I c #ffd52b",
".j c #ffd52c",
".A c #ffd73a",
".u c #ffd83a",
".e c #ffdb4a",
".y c #ffdb4b",
".i c #ffdc50",
".z c #ffdc51",
".t c #ffdd57",
".s c #ffe26d",
".d c #ffe26e",
".h c #ffe476",
".c c #ffe78b",
".n c #ffe88b",
".b c #ffea97",
".o c #ffeb98",
".g c #ffefae",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQt.#.a.a.a.a.#QtQtQtQtQtQtQtQtQtQt",
"Qt.#.a.b.c.d.e.a.#QtQtQtQtQtQtQtQtQt",
".f.a.b.g.b.h.i.j.a.f.f.f.k.f.l.f.k.f",
".m.a.n.o.n.d.e.p.a.m.q.m.q.m.q.m.m.m",
".r.a.s.h.s.t.u.v.a.r.w.w.w.r.w.w.w.w",
".x.a.y.z.e.A.B.C.a.D.E.F.D.F.D.D.D.D",
".G.H.a.I.p.v.C.a.H.J.K.G.K.G.G.G.G.G",
".L.L.M.a.a.a.a.N.O.P.Q.R.S.T.U.V.W.X",
".Y.Z.Y.Y.0.0.1.1.Z.2.Y.3.4.5.6.7.8.9",
"#.#.#####.#a#.#b#c#d#e#f#g#h#i#j#k#l",
"#m#n#n#o#p#q#p#r#s#t#u#v#w#x#y#z#A#B",
"#C#D#D#E#F#q#G#H#I#J#K#L#M#N#O#P#Q#R",
"#S#S#S#T#R#R#R#U#V#W#X#Y#Z#0#1#2#R#2",
"#3#4#3#3#3#3#3#R#5#6#7#8#9#R#R#Ra.a#",
"aaaaaaaaaaaaaaaa#R#R#R#R#Raaaaaaaaaa"};

static const char* const image166_data[] = { 
"18 18 158 2",
"ay c #2e2d35",
"aA c #58556e",
"#z c #644107",
"#j c #664408",
".6 c #67410d",
"#M c #6e4a11",
"ar c #6e4a17",
"ax c #787878",
"#6 c #795718",
"ad c #79571b",
"ap c #7c6310",
"at c #817f92",
"al c #86652a",
".v c #876a29",
"aq c #876e1b",
".I c #8b6c27",
".T c #916e20",
".f c #917a28",
"#X c #94783f",
"ag c #958441",
"#o c #967f2f",
"#9 c #968442",
"ao c #968541",
".u c #97772a",
".g c #9a8230",
"#. c #9a8332",
"#W c #9b791a",
"#Z c #9b8845",
".e c #9e8734",
"#B c #a08b42",
".o c #a18b3d",
".z c #a28b3b",
".V c #a38d3d",
"ac c #a5862a",
".d c #a99342",
"a. c #a99546",
"aw c #a9a9aa",
"aB c #aaaaaa",
".U c #ab9455",
"#O c #ad9c54",
".K c #b2983c",
".p c #b29b45",
"ak c #b49e5a",
".H c #bb9c37",
".h c #bca967",
"as c #bcb073",
"#N c #bdb07a",
".J c #beac69",
".c c #bead6d",
"#5 c #c7a42e",
".5 c #cba72e",
".A c #ceb755",
"#0 c #cfc584",
"az c #d1d1d1",
".W c #d2ba5d",
".q c #d2bc63",
"#C c #d2c581",
".t c #d3b64d",
"#L c #d4ae2c",
"ah c #d4cf91",
"an c #d4d092",
"av c #d4d4d4",
"ae c #d6c9a1",
".w c #d9cea9",
".n c #dcd1ab",
"#8 c #ddd7bb",
"#7 c #e7e0ca",
".y c #ece6d1",
".b c #ece6d2",
".i c #ede8d4",
"#Y c #edead9",
".r c #f0da7b",
"## c #f0df92",
"#p c #f0e4a4",
".s c #f1d972",
"au c #f1f1f1",
"#i c #f2c837",
"#y c #f2c936",
".k c #ff9513",
"Qt c #ff9719",
".8 c #ffa12d",
".m c #ffa230",
".j c #ffa73c",
".l c #ffac46",
".7 c #ffb04e",
".# c #ffb65c",
".x c #ffc47d",
"ab c #ffd338",
"#V c #ffd43b",
"#K c #ffd53e",
"#4 c #ffd53f",
"aa c #ffd540",
"#m c #ffd5a2",
"#x c #ffd643",
"#h c #ffd745",
".4 c #ffd747",
"#3 c #ffd849",
".S c #ffd84b",
"aj c #ffd952",
"#U c #ffdb52",
"#J c #ffdb53",
"#w c #ffde5e",
".G c #ffdf60",
"ai c #ffdf67",
"#T c #ffe164",
"#g c #ffe16b",
"#I c #ffe36f",
".R c #ffe371",
".3 c #ffe473",
"#l c #ffe4c4",
"a# c #ffe678",
"#S c #ffe87f",
".F c #ffe88a",
".L c #ffe990",
"#2 c #ffea85",
".9 c #ffebd3",
"#k c #ffebd4",
"#H c #ffec8c",
"#v c #ffec8e",
".B c #ffef99",
".X c #fff0b5",
".Q c #fff1ab",
".E c #fff1ac",
"#f c #fff2aa",
"#R c #fff3a6",
"#G c #fff4aa",
".C c #fff4c9",
".M c #fff4ce",
"#1 c #fff5ab",
".D c #fff5cd",
"#u c #fff6b2",
".2 c #fff6b7",
"#a c #fff8ca",
"#n c #fff8f0",
"#A c #fff9f1",
"#Q c #fffabf",
"#F c #fffac5",
".P c #fffad0",
".Y c #fffae4",
"#t c #fffbc6",
"#e c #fffbcb",
"#q c #fffbd3",
"am c #fffbec",
".N c #fffbed",
"#P c #fffcc6",
"#D c #fffccd",
".O c #fffce7",
"#E c #fffdd3",
".1 c #fffdd9",
"#s c #fffed7",
"#d c #fffed8",
"#r c #fffede",
"#b c #fffef2",
".0 c #ffffdf",
"#c c #ffffe6",
".Z c #ffffec",
"af c #fffff8",
".a c #ffffff",
"Qt.#.a.a.a.b.c.d.e.f.g.h.i.a.a.a.j.k",
".a.l.m.a.n.o.p.q.r.s.t.u.v.w.a.k.x.a",
".a.a.a.y.z.A.B.C.D.E.F.G.H.I.i.a.a.a",
".a.a.a.J.K.L.M.N.O.P.Q.R.S.T.U.a.a.a",
".a.a.a.V.W.X.Y.Z.0.1.2.3.4.5.6.a.a.a",
".7.8.9#.###a#b#c#d#e#f#g#h#i#j#k.8.7",
"#l#m#n#o#p#q#r#s#t#u#v#w#x#y#z#A#m#l",
".a.a.a#B#C#D#E#F#G#H#I#J#K#L#M.a.a.a",
".a.a.a#N#O#P#Q#R#S#T#U#x#V#W#X.a.a.a",
".a.a.a#Y#Z#0#1#2.G#3#4#V#5#6#7.a.a.a",
".a.l.m.a#8#9a.a##Jaaabacadae.a.k.x.a",
"Qt.#.a.a.aafagahaiajakalam.a.a.a.j.k",
".a.a.a.a.a.aanaoapaqaras.a.a.a.a.a.a",
".a.a.a.a.a.aatauavawaxay.a.a.a.a.a.a",
".a.a.a.a.a.aazaAaAayayaz.a.a.a.a.a.a",
".a.a.a.a.a.aatauavaBaxay.a.a.a.a.a.a",
".a.a.a.a.a.aazaAaAayayaz.a.a.a.a.a.a",
".a.a.a.a.a.a.aazaAayaz.a.a.a.a.a.a.a"};

static const char* const image167_data[] = { 
"18 18 41 1",
"w c #002141",
"q c #003366",
"u c #1880bc",
"H c #1b78b0",
"G c #1f78b0",
"E c #2188c2",
"D c #2287c1",
"C c #2487c0",
"J c #248dc7",
"B c #2589c2",
"I c #278cc6",
"v c #37729c",
"a c #431935",
"L c #46aae1",
"r c #47648c",
"F c #4aa6d9",
"A c #581e16",
"t c #61baec",
"c c #712224",
"i c #73333b",
"b c #752a2a",
"m c #773438",
"o c #783b40",
"l c #7c3a39",
"h c #814949",
"g c #844545",
"n c #8f4d3d",
"x c #914035",
"M c #9ac1d6",
"s c #a6bbd0",
"# c #a89388",
"p c #b27d57",
"d c #e1d3cb",
"K c #e3cdc8",
"z c #ecb857",
"f c #efbbc5",
"k c #fbf8f8",
"e c #ff0033",
"j c #ffcc66",
"y c #ffe468",
". c #ffffff",
"..#a#a#a..........",
".#aabacad...eefee.",
".aghaijjak..eeeee.",
".alaijjjad...eee..",
".amnajaaja....e...",
".aopjjjjja........",
".#ajjajjad........",
"..ajjjaid.........",
"...ajjjad.........",
".qqqajarqqs.......",
"qtttuavuttqqqqwxx.",
"qtuuuuuuuuttttwyyx",
"qtuutwwwuuuuuuwzzx",
"swuuutttwwxxwwwAA.",
"swBBBCDEtFyyxss...",
".qwwGGGGHHzzx.....",
".qIJwwwwwwAAK.....",
".qLIIIIIIwM......."};

static const char* const image168_data[] = { 
"18 18 81 2",
".P c #009900",
".s c #00a500",
".4 c #01007c",
".W c #0547a9",
".X c #1552ab",
"#o c #1d1794",
".U c #1d58c4",
".D c #1f4da8",
".3 c #20238c",
"#m c #2332a6",
".E c #264eb9",
".N c #267fdd",
"Qt c #3300ff",
"#b c #3533a2",
".K c #398ae0",
".T c #3b8ae0",
".Q c #3ba411",
".2 c #3e8be0",
".V c #40409b",
".O c #408372",
".r c #473b9d",
".p c #4745a0",
".R c #4d7dd0",
".S c #4f96e2",
".1 c #5196e2",
".5 c #524dab",
".g c #53a500",
".x c #544fa3",
"#h c #5450af",
"## c #5499e2",
"#g c #5699e2",
".t c #5767af",
".0 c #65a2e4",
".H c #668abe",
"#. c #66a5e5",
".G c #6782ab",
"#f c #68a5e6",
".z c #698cbf",
"#j c #6a60ae",
"#l c #6ba6e5",
".Y c #6f8ed2",
".I c #7695c2",
".Z c #77ade7",
"#a c #7870a4",
".A c #7895c2",
".9 c #79aee6",
"#e c #7cb1e7",
"#k c #7eb1e8",
".n c #867fad",
".B c #88a1c5",
".u c #89a2c6",
".8 c #8cb9e9",
"#d c #8fbbea",
".y c #9fd99f",
".7 c #a0c4ec",
"#c c #a2c6eb",
"#n c #a49fc2",
".6 c #a7c0e6",
".J c #ab2d64",
".F c #afdfaf",
"#i c #b3afcc",
".o c #bfe5bf",
".q c #d0a3af",
".v c #df4e62",
".m c #e19fab",
".w c #f74652",
".e c #ff0b0d",
".c c #ff1010",
".C c #ff1a20",
".a c #ff3333",
".b c #ff7070",
".L c #ff9901",
".M c #ff9b06",
".j c #ff9e10",
".l c #ff9f9f",
".h c #ffab30",
".f c #ffbfbf",
".k c #ffcb7f",
".d c #ffd28f",
".i c #ffdfaf",
".# c #ffffff",
"Qt.#.a.#.#.#.#.#.b.c.#.#.#.#.#.#.#.#",
".d.#.#.#.#.#.#.#.#.e.f.#.g.#.#.#.#.#",
".h.i.#.#.#.#.#.#.#.#.e.#.#.#.#.#.#.#",
".i.j.j.dQt.#.#.a.#.#.e.#.#.#.#.#.#.#",
".#.#.d.j.j.j.k.#.#.#.e.#.#.#.#.#.#.#",
".g.#.#.#.#.#.j.j.#.#.e.l.#.#.#.#.#.#",
".#.#.#.#.g.#.#.a.j.#.m.e.n.#.#.#.#.#",
".o.o.#.#.#.#.#.#.j.n.p.e.q.r.#.#.#.#",
".s.s.s.s.#.#.#.#.j.t.u.v.w.x.#.#.#.#",
".#.#.#.y.s.#.#.n.j.z.A.B.C.D.E.#.#.#",
".#.#.#.#.F.s.#.a.j.G.H.I.J.K.E.#.#.#",
".#Qt.#.#.a.y.s.s.G.L.M.j.D.K.N.E.#.#",
".#.#.#.#.#.#.O.O.P.P.Q.D.R.S.T.U.#.#",
".#.#.#.#.#.#.V.W.X.D.D.Y.Z.0.1.2.E.#",
".#.#.#.#.#.#.#.3.4.5.6.7.8.9#.##.E.#",
".#.#.#.#.#.#.#.#.##a#b#b#c#d#e#f#g#h",
".#.#.#.#.#.#.#.#.#.#.##i#j#b#b#k#l#m",
".#.#.#.#.#.#.#.#.#.#.#.#.#.##n#b#b#o"};

static const char* const image169_data[] = { 
"18 18 32 1",
"r c #1c1c1c",
"b c #6e6e6e",
"l c #828282",
"o c #866a52",
"z c #8dcccb",
"y c #924900",
"c c #949494",
"p c #9f9f9f",
"A c #a0877a",
"a c #c2c2c2",
"j c #c6c6c6",
"d c #cacaca",
"i c #cccccc",
"v c #d3ba94",
"g c #d3d3d3",
"C c #d4d4d4",
"u c #d8d8d8",
"q c #dbc39c",
"m c #dfdfdf",
"h c #e5e5e5",
"f c #ededed",
"x c #efefef",
"k c #f1d9b2",
"# c #f66a92",
"D c #f7f7f7",
"B c #fcfcfc",
"w c #fdb098",
"t c #febd98",
"s c #fecab2",
"n c #fecba5",
"e c #fefefe",
". c #ffffff",
"...........##.....",
"........abcccbd...",
"........ceeeefcg..",
".......ceeeeefhci.",
"......jceccckcccc.",
"lcm...cccnnnnnnoci",
"ceppppcqnnrsnnrtli",
"lueeeevnnnbsnnbtli",
"lueeeelntwnnnnwtli",
".luxceebttnyyytlii",
"..lceexebnnnynlii.",
"..xlulebezcllAli..",
"...BllleeezzzCli..",
".....leeee##DCli..",
".....leeeeDDDCli..",
"......llCCCCCbii..",
".......illlllii...",
".........iiiii...."};

static const char* const image170_data[] = { 
"18 18 53 1",
"# c #b64900",
"Y c #bebebe",
"e c #bfbfbf",
"W c #cccccc",
"h c #d9d9d9",
"b c #db9200",
"a c #dbb600",
"X c #dfbd32",
"O c #dfcf8e",
"d c #dfdfdf",
"M c #e5e5e5",
"T c #e9e9e9",
"U c #efd97f",
"i c #efe3b5",
"c c #efefef",
"N c #f5f5f5",
"n c #f9f9f9",
"f c #fcfcfc",
"g c #ffcc00",
"L c #ffdd55",
"z c #ffdd57",
"S c #ffdf5d",
"F c #ffdf5f",
"t c #ffdf60",
"K c #ffe167",
"y c #ffe168",
"R c #ffe26f",
"E c #ffe270",
"s c #ffe372",
"V c #ffe476",
"J c #ffe478",
"x c #ffe47a",
"m c #ffe57b",
"Q c #ffe680",
"D c #ffe682",
"r c #ffe683",
"I c #ffe88a",
"w c #ffe88b",
"l c #ffe88d",
"P c #ffe992",
"C c #ffe993",
"q c #ffea95",
"H c #ffeb9b",
"v c #ffeb9d",
"k c #ffec9e",
"B c #ffeda5",
"p c #ffeda6",
"G c #ffefad",
"u c #ffefae",
"j c #ffefb0",
"A c #fff0b6",
"o c #fff1b8",
". c #ffffff",
"........#.........",
"........#a........",
"..#b....b.....#...",
"..c#.dabbae..#b...",
"...febgggg#bhf....",
"....bijklmgg#nn...",
"...agopqrstgbb....",
"...bguvwxyzgg#n...",
"##hbABCDEFggg#h##b",
"hh.bGHIJKLggg#MNhh",
"...aOPQRSggg#bT...",
"....bUVgggggbWN...",
"....eb#ggX#bh.....",
"...#f.b###b.Y#....",
"..#b.f..h....b#N..",
"........#Y....N...",
"........#Y........",
"........b........."};

static const char* const image171_data[] = { 
"18 18 39 1",
"a c #00357b",
"C c #0039ad",
"e c #0042ad",
"v c #004aad",
"h c #004ab5",
"d c #0052b5",
"m c #105ab5",
"H c #1852b5",
"l c #185ab5",
"K c #296bbd",
"J c #3173c6",
"b c #427bc6",
"# c #4a84c6",
"B c #5284ce",
"x c #528cce",
"G c #5a8cce",
"u c #6394ce",
"t c #6b9cd6",
"y c #739cd6",
"i c #84add6",
"F c #84adde",
"g c #94b5de",
"f c #9cb5de",
"z c #9cbdde",
"D c #9cbde7",
"c c #a5bdde",
"E c #b5cee7",
"p c #bdceef",
"q c #bdd6ef",
"r c #c6d6ef",
"j c #cccccc",
"s c #cedeef",
"A c #cedef7",
"n c #d6e7ef",
"k c #dee7ef",
"w c #deeff7",
"o c #e7eff7",
"I c #eff7f7",
". c #ffffff",
".......#aab.......",
"......caddef......",
"......gahdeij.....",
"......kleemnj.....",
"....oppqrrrpps....",
"...rlaaaaaaaaht...",
"...uadaaaaaadvdw..",
"...xataadhdvyahsj.",
"...xazaadhdvgavAj.",
"...BCcaaddhhzavAj.",
"...BCcahddavDaenj.",
"...qyoaebgahzEFjj.",
"....jjaeGravDjjj..",
"......aeGqahzj....",
"......aeBEaeDj....",
"......aeBEaeDj....",
"......yHgIJKnj....",
".......jjjjjjj...."};

static const char* const image172_data[] = { 
"18 18 148 2",
"#5 c #570f30",
"#9 c #570f31",
"#Y c #571032",
"al c #5d0d30",
"#V c #5d2643",
".Q c #601b3b",
"#O c #612b48",
"ar c #64052b",
".l c #652042",
"#l c #662846",
".B c #662a48",
".a c #66304c",
".z c #680a2f",
"ao c #6c1136",
".g c #6d2e4c",
".6 c #6f072e",
".c c #702043",
".8 c #702245",
".b c #702446",
"aq c #730000",
".t c #732e4c",
".j c #76455e",
".h c #77163a",
".i c #781539",
".q c #7b1d43",
".S c #7c2f51",
".r c #804f66",
"a# c #860a33",
"#N c #876677",
"#r c #8b143d",
".I c #8d183f",
"#s c #900d36",
"#G c #90113b",
".J c #90173f",
"#b c #901a41",
".u c #902348",
"#c c #92173f",
"aj c #921740",
"#H c #940c37",
"am c #971942",
"#P c #990f3b",
"#M c #9b0d39",
"#B c #9d2f55",
".f c #9d667d",
"#0 c #9f0e3a",
"#A c #a17f91",
"#1 c #a4103d",
".Y c #a42850",
"ai c #a8214a",
"af c #ab224c",
"ag c #af103e",
"aa c #b0113f",
"#Q c #b21844",
"ab c #b2a6ac",
".Z c #b4345c",
".d c #b89fac",
".A c #bba6b1",
"#6 c #bbb2b7",
"#U c #c61444",
"#Z c #cb315c",
"#k c #cccccc",
"ac c #cfcfcf",
".k c #d0bfc8",
"#4 c #d11547",
"#I c #d12755",
"a. c #d1335f",
"ap c #d1c3ca",
".7 c #d2d2d2",
"#L c #d31547",
"#3 c #d3194a",
"ae c #d3c7cd",
"#y c #d41548",
"#T c #d4194a",
"#7 c #d6d6d6",
"#i c #d71648",
"#8 c #d7cad1",
".m c #d88aa9",
"#d c #da3662",
".H c #da4b75",
".# c #dccfd6",
".4 c #dd2152",
".p c #e0648a",
".C c #e39ab7",
".s c #e3dcdf",
"an c #e4184b",
"#W c #e5e5e5",
"#X c #e7dfe3",
"#t c #e83d68",
"ak c #ec406c",
".v c #ec4e76",
"#m c #ec6f94",
".R c #efefef",
"#x c #f21a4f",
"#h c #f21c50",
"#2 c #f22054",
"#q c #f2547f",
"#F c #f32557",
"#S c #f32a5c",
"#R c #f33160",
"#g c #f33e6a",
".K c #f35b80",
"#a c #f3648d",
".3 c #f43262",
"#w c #f43363",
".O c #f43764",
"#j c #f44170",
".5 c #f44270",
"#z c #f44371",
"#K c #f44671",
".P c #f44673",
".N c #f54a73",
"#E c #f54e7b",
".y c #f5557e",
"ah c #f5f5f5",
".x c #f64e78",
"#J c #f6537b",
"#D c #f65681",
"#C c #f65b85",
".w c #f65c81",
"#p c #f6618b",
".2 c #f75e84",
"#o c #f76e95",
".X c #f7759b",
"#n c #f7789d",
".G c #f7799e",
".M c #f77a99",
"#e c #f785a1",
".0 c #f87291",
"#v c #f87695",
"#u c #f8829f",
".o c #f88aac",
".e c #f8f3f5",
"#f c #f989a4",
"## c #f98cae",
".W c #f98eaf",
".L c #f990a9",
".9 c #f990b2",
".F c #f995b6",
"#. c #f997b7",
".1 c #f99bb2",
".n c #f99fbe",
"ad c #f9f9f9",
".T c #faa7c5",
".V c #faa9c6",
".E c #fab1cd",
".U c #fbb7d2",
".D c #fbc3dc",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"Qt.#.a.b.c.a.dQtQt.e.f.g.h.i.j.kQtQt",
".k.l.m.n.o.p.q.r.s.t.u.v.w.x.y.z.AQt",
".B.C.D.E.F.G.H.I.s.J.K.L.M.N.O.P.Q.R",
".S.T.U.V.W.X.Y.K.s.Z.0.1.2.3.4.5.6.7",
".8.9#.##.X#a#b.s#c#d#e#f#g#h#i#j.6#k",
"#l#m#n#o#p#q#r.s#s#t#u#v#w#x#y#z.Q#k",
"#A#B#C#D#E#F#G.s#H#I#J#K#F#L.5#M#N.7",
"Qt#O#F#F#F#F#P.G.d#Q#R#S#T#z#U#V#k#W",
"Qt#X#Y#F#F#F#Z#0.s#1#2#3#z#4#5#6#7Qt",
"QtQt#8#9#F#Fa.a#.saa#4#z#4#5abacadQt",
"QtQtQtae#9#zaf#z.sag#z#4#5abacahQtQt",
"QtQtQtQtae#9ai.sajak#4#5abacahQtQtQt",
"QtQtQtQtQtaeal.samanaoabacahQtQtQtQt",
"QtQtQtQtQtQtapQtaqarabacahQtQtQtQtQt",
"QtQtQtQtQtQtQtQtaqab#kahQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image173_data[] = { 
"18 18 33 1",
"h c #000000",
"d c #6d0000",
"g c #828282",
"# c #924955",
"c c #a92c23",
"p c #ae3026",
"s c #b13328",
"b c #b66d55",
"B c #bd3c2e",
"C c #bd3c2f",
"o c #be3c2e",
"a c #c2c2c2",
"E c #c74334",
"D c #c74335",
"i c #c74435",
"x c #c84334",
"u c #cb4637",
"n c #ce4939",
"y c #cf4939",
"k c #db5241",
"e c #db6d55",
"r c #dc5240",
"m c #dc5241",
"z c #dc5340",
"t c #e05643",
"A c #e15643",
"v c #ec5f4a",
"w c #f2644e",
"l c #f3634d",
"q c #ff6d55",
"f c #ff9255",
"j c #ffb6aa",
". c #ffffff",
"...#....#.......#.",
"..a#bbcdd......#dd",
"..effffcd.....#dgd",
"..hfihff#....#.dad",
".ahjihjk#......d.d",
".ejjjjfce......d..",
".#flllic.......d..",
".a#ddecc###b...d..",
"....abmnocccb..d..",
".epdbqqrisdddp.d..",
"edppbqqtudaaebddb.",
"#a.#vwvkxd..aebbd.",
"p..yzArnBd...adpa.",
"...CDuECpd....da..",
"..aedddddde...d...",
"..edba..abde..d...",
".abdaa...abda.d...",
"edd#aaa.aa#ddddpa."};

static const char* const image174_data[] = { 
"18 18 176 2",
"#A c #040003",
"#l c #190e00",
"#k c #1e0c04",
"av c #4c2309",
"aD c #532809",
"au c #542b0a",
"#6 c #542f14",
"aE c #5c3009",
"ar c #5c3c21",
"at c #613407",
"aq c #61360e",
"ai c #6f3d0f",
"ae c #7b491b",
"ac c #854d12",
"ak c #854e11",
"ad c #86511e",
"#v c #896338",
"#Y c #8b5217",
"as c #8d6029",
"#t c #985e25",
"aC c #9b6228",
"#a c #a97744",
"a# c #ae8a64",
"#1 c #b19068",
".C c #b57e1c",
"#w c #b6a88c",
"ah c #b78851",
"#U c #bb6124",
".N c #bb751d",
".z c #bb772d",
"aF c #bc7c3a",
"a. c #c07f42",
"ap c #c0864b",
"#M c #c46820",
"aH c #c48139",
"aG c #c6843f",
".m c #c99b59",
"#8 c #cc9d4e",
"aA c #cd8d48",
"#G c #ce9256",
"#h c #d2a25c",
"#J c #d3b786",
"aB c #d48f46",
"#s c #d58a1d",
"#5 c #d68819",
".y c #d6a863",
".9 c #d7a95f",
".Y c #d7b77b",
"aP c #d9ae81",
".M c #daa267",
"aO c #dbb183",
"#S c #dcc7a2",
".q c #dd9944",
"aM c #deb383",
"#L c #dfb07b",
"#2 c #e0ab6b",
"aN c #e0b485",
"#9 c #e19e58",
"#Z c #e2a14b",
"aI c #e2ac74",
"#z c #e3c58f",
"aQ c #e5b98b",
".Z c #e6cda5",
"#T c #e6d3ab",
".O c #e7c091",
".a c #e8b964",
".# c #e8bb67",
".K c #e9a54e",
".x c #e9ba77",
".w c #e9bb75",
".l c #e9be79",
".b c #e9bf70",
".D c #eaa55a",
"al c #eab781",
"#. c #eac59c",
"#p c #eb9c12",
"## c #ebb476",
".g c #ebc374",
".r c #eca456",
".7 c #eca75c",
".0 c #eccc9c",
".V c #eda659",
"#Q c #eda866",
".h c #edc784",
".P c #edd399",
"#W c #eea24b",
"#c c #eea659",
".W c #eea759",
".T c #eea75b",
".4 c #eea75f",
".6 c #eea85d",
"#C c #eea960",
".2 c #eebe84",
".u c #eec679",
".A c #eecc9e",
".p c #efa151",
"aK c #efa85b",
".5 c #efa85e",
".U c #efa860",
"ax c #efa960",
"#r c #efaa5f",
"#I c #efaa60",
".3 c #efc59a",
"#j c #f0aa5f",
"#o c #f0ad67",
"aj c #f0ae66",
"#i c #f0bc88",
"ay c #f1a221",
"#d c #f1a743",
"az c #f1bd88",
".v c #f1ce86",
".n c #f1e6d4",
"#H c #f2ab5f",
"am c #f2b370",
".L c #f2b574",
"#u c #f2b981",
"af c #f2bc89",
"#3 c #f39d0f",
"#R c #f3a322",
"#P c #f3a85b",
"#K c #f3ab62",
"aw c #f3b370",
"aJ c #f3b472",
"#N c #f3d7a8",
"an c #f4a01a",
"aL c #f4a83d",
"#X c #f4ac59",
"#D c #f4ae67",
".X c #f4ba7d",
"#n c #f4bd80",
".1 c #f4c181",
"aS c #f4c696",
".8 c #f5aa40",
".B c #f5ac64",
"#q c #f5af61",
".J c #f5bc83",
".o c #f5be7f",
".i c #f5e3c4",
"#b c #f6a82c",
"#0 c #f6ad63",
"ao c #f6cea5",
".j c #f6e4c5",
".k c #f6e5c6",
"#e c #f7b25c",
"aR c #f7c997",
".I c #f7deba",
"#7 c #f8e4bb",
"aT c #f9c992",
".f c #f9dca8",
".E c #fadcba",
".d c #fae1b3",
".H c #fae5c1",
".t c #fae7ba",
"#f c #fbb163",
".s c #fbdfb3",
"#y c #fbe3b6",
"#F c #fbebbc",
"#V c #fce1ad",
".Q c #fce8bd",
"#4 c #fdaa16",
"#m c #fdae4e",
".e c #fee0b2",
".c c #fefefe",
"ab c #ffa600",
"#g c #ffa800",
"#B c #ffbb67",
"aa c #ffc242",
"#x c #ffd9ae",
"#O c #ffe3a6",
"ag c #ffeac3",
"#E c #ffeeb7",
".S c #fff5d2",
".R c #fff6d5",
".G c #fffdde",
".F c #ffffd9",
"Qt c #ffffff",
"QtQt.#.#.a.bQtQtQtQtQtQtQtQtQtQtQtQt",
"Qt.#.c.d.e.f.g.h.i.j.k.k.l.m.m.nQtQt",
".m.c.o.p.q.r.s.t.u.v.w.x.l.y.y.m.zQt",
".m.A.p.B.C.D.E.F.G.H.I.I.J.K.L.J.M.z",
".N.O.p.C.P.Q.R.S.I.I.J.J.T.U.V.W.X.N",
".N.p.C.Y.Z.0.1.2.3.J.4.5.6.N.7.8.8.N",
".h.N.9#.###a#a#b.J#c#d#e#f.7.N#g#g.N",
"Qt.N#h#i#j#k#l#m#n#o#p#a#a#q#r#s#t#s",
"QtQt.N#u.T#v#w#x.c#y#z#A#A#B#C#t#sQt",
"QtQt.N#D.T#E.c.c.F.F#F#v#G#H#I.NQtQt",
"QtQt#J.N#K.c.c#L#M#N.F#O#P#Q#R.NQtQt",
"QtQt#S.N#K.c#T#U#A#U.F#V#W#X#R#tQtQt",
"Qt#Y#Y#Z#0#1.F#2#U.F.F#1#3#4#5#6QtQt",
"#Y#7#8#Y#9a.a##U.F#U#1aaab#5acadaeQt",
"#Yafagahaiaj.F.F.F.Faa#5#5akaealamae",
"#Yanafaoapaqaras#5#5atauavalalawaxae",
"Qt#YayafazaAaBaCaDaEaFaGaHaIaJaKaLae",
"QtQt#YafafafafafaMaNaOaPaQaRaSaTaeQt"};

static const char* const image175_data[] = { 
"18 18 26 1",
"m c #202020",
"f c #282419",
"v c #2ea7c4",
"r c #31b2d1",
"s c #3bacc7",
"w c #463f2b",
"p c #4bbcd7",
"x c #514831",
"h c #585448",
"n c #645a3d",
"a c #786b49",
"o c #7ecfe2",
"e c #7f7f7f",
"i c #8c7d55",
"b c #9f9f9f",
"t c #a08f61",
"u c #beb394",
"g c #cfc7b0",
"# c #cfcfcf",
"d c #d8d1bf",
"l c #dbd5c4",
"q c #e5f5f9",
"k c #e7e3d8",
"j c #f3f1ec",
"c c #fefefe",
". c #ffffff",
".......#aaaa......",
"......baccccaaa...",
"......adcccccccaa.",
"......eaadccccccca",
"......eccaaadccccf",
".....aaaacccaadcff",
"...aaccccaaaccafgf",
"..hcccgiijckaacggf",
".hccjffggiacclfggf",
"bcclmcccccagccfgn.",
"nclfccopoqagcgfn..",
"nffccrrrrsnccftu..",
".njnvrrrrwcccft...",
".njjnnnnxcccfgt...",
"..ntcccacccfgn....",
"...tnnttfffggn....",
"....tggggggtn.....",
".....tttttt......."};

static const char* const image176_data[] = { 
"18 18 9 1",
"# c #aa7f00",
"f c #aa7f55",
"e c #cccccc",
"d c #cd9436",
"a c #d49f55",
"g c #e9ab44",
"c c #ffbf55",
"b c #ffdfaa",
". c #ffffff",
"..................",
".......###a.......",
"......#bbb###.....",
"....###bbccbb#....",
"...#bbb##cdbc#e...",
"...#bbbbb#dcdbfe..",
"...#bbccbb#cdcfe..",
"...#bbc#cc##ccbfe.",
"...fbbcd###dcdbfe.",
"...fbbbccbgd#ccfe.",
"..#babbcbbbbdcfe..",
".#bbbbcccbccffe...",
"#bbbbbbfccffee....",
".bbbbbccffee......",
"..bbbccfee........",
"...bccfe..........",
"....cfe...........",
".....e............"};

static const char* const image177_data[] = { 
"18 18 59 1",
"o c #bf1800",
"j c #c01d00",
"e c #c3280b",
"v c #c42802",
"f c #c62807",
"a c #c7381f",
"h c #c93f26",
"C c #cc2701",
"# c #de3c02",
"p c #f1bf65",
"g c #f1c52e",
"k c #f6da90",
"1 c #f6f1c5",
"r c #f6f4c6",
"R c #f7daa6",
"l c #f7ebc0",
"q c #f8e1aa",
"H c #f8fcda",
"z c #f8fcdd",
"L c #f9ce76",
"w c #f9d045",
"D c #f9d17c",
"W c #f9eacf",
"0 c #fad166",
"x c #fae3ba",
"Q c #faebd0",
"i c #faee8e",
"S c #faeedb",
"T c #faf1de",
"G c #fafde8",
"A c #fafeea",
"m c #faffed",
"c c #fb8101",
"Y c #fbc053",
"Z c #fbcc59",
"2 c #fbe088",
"K c #fbe188",
"O c #fbfef1",
"U c #fbfff1",
"t c #fcf3ea",
"b c #fcf4f2",
"M c #fcf7f0",
"V c #fcf8f0",
"X c #fdd9b4",
"n c #fdf8d1",
"E c #fdfcfe",
"J c #fdfdff",
"y c #fdfffb",
"N c #fdffff",
"4 c #fe9e16",
"3 c #fee9a8",
"P c #fef8f4",
"u c #fefcfb",
"I c #fefefb",
"s c #fefffd",
"F c #feffff",
"d c #fffefe",
"B c #fffffe",
". c #ffffff",
".......##..##.....",
"......##..###.....",
".....a##.###......",
"....ba####c#......",
"...da##c#c##..##..",
"....e##ccc#..##...",
"...af#cccc#####...",
"...aaccgccc##c#...",
"..ahacggiccccc#...",
"..ajccklmniicc##..",
"..aocpqrstuiic##..",
"..avcwxyzABBic##..",
"..aCcDEFGHIBJKca..",
"..aCcLM.NOPQFcca..",
"...CccRSTUVWXca...",
"...CacYZ0123cca...",
"....Cac4ccc#aad...",
"......aaaaaa......"};

static const char* const image178_data[] = { 
"18 18 6 1",
"# c #2d2d2d",
"d c #5f5f5f",
"c c #7d7d7d",
"b c #a2a2a2",
"a c #b1b1b1",
". c #ffffff",
"..................",
"..................",
"..................",
"..................",
"####..........####",
"#aaa##......##aaa#",
"#bbbb########bbbb#",
"#cccccc#cc#cccccc#",
"#cccccc#c.#cccccc#",
"#cccddd####dddccc#",
"#dddd########dddd#",
"#ddd##......##ddd#",
"####..........####",
"..................",
"..................",
"..................",
"..................",
".................."};

static const char* const image179_data[] = { 
"18 18 83 2",
".D c #084a3a",
".E c #184845",
".F c #1e4e4b",
".G c #284c52",
".H c #2c5c5a",
".I c #31555b",
".M c #323a58",
".C c #334d67",
".K c #343c5a",
".N c #37435f",
".x c #396b68",
".R c #3a4263",
".t c #3a4860",
".L c #3a4865",
".J c #3c5472",
".r c #3e5470",
".O c #3f506d",
".p c #425d7a",
".a c #426180",
".h c #465878",
".q c #465879",
".P c #465b79",
".u c #465c77",
".l c #4a7394",
".U c #4b6382",
".s c #4e6985",
".f c #4e7697",
".n c #55688b",
".o c #577697",
".b c #608bae",
".T c #6381a1",
".k c #638aaa",
".v c #6b84a4",
".# c #739fc3",
".7 c #7c6539",
".A c #7cb1ae",
"#d c #816f4b",
".S c #83a3c0",
".d c #8ea6c3",
"#f c #8f7b53",
".Q c #8faeca",
".z c #9bd0cd",
".6 c #9e8759",
".5 c #a0895a",
".4 c #a18b5d",
"#l c #a38957",
".9 c #a38e62",
".3 c #a48d5f",
".2 c #a78f61",
".1 c #a99264",
".0 c #ac9566",
"#m c #acacac",
".Z c #ae9868",
".Y c #b1996a",
".X c #b29b6c",
"#a c #b6a685",
".y c #bae5e3",
".B c #bed4e7",
".e c #d1e2f1",
".c c #d3e4f3",
".W c #d4c3a1",
".w c #d8e6f1",
"#k c #dacfb2",
"#n c #dbceb2",
"#c c #dbcfb3",
"#q c #dbcfb4",
".m c #dceaf5",
".j c #e0ecf6",
"#. c #e3dac4",
"#g c #e3dac5",
"#p c #e3dbc6",
"#o c #e3e1e1",
"#e c #e4d7bd",
"#i c #e5d7be",
".V c #ece2cf",
"## c #ece5d7",
"#j c #ece6d7",
"#b c #ece6d8",
"#h c #eee8d9",
".i c #f1f7fb",
".8 c #f3ede2",
".g c #f6fafc",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQt.#QtQtQtQt.aQtQtQtQtQtQt",
"QtQtQtQtQt.bQt.a.a.a.a.c.aQtQtQtQtQt",
"Qt.dQt.e.f.g.hQt.i.j.c.h.c.a.eQt.dQt",
"Qt.a.k.l.m.n.h.n.h.n.h.n.o.c.a.k.aQt",
"QtQt.p.c.q.h.o.h.o.h.o.h.o.h.c.rQtQt",
"QtQtQt.p.s.t.t.t.t.t.t.t.t.u.rQtQtQt",
".v.wQtQt.x.y.z.x.z.A.x.A.A.xQtQt.w.v",
"Qt.a.B.C.l.D.D.D.E.F.G.H.I.J.C.B.JQt",
"Qt.k.a.K.L.K.L.M.N.M.O.K.P.K.J.a.kQt",
"QtQt.C.Q.R.S.R.T.R.o.R.o.R.U.R.CQtQt",
"QtQt.V.q.o.h.o.h.o.h.o.h.o.h.R.VQtQt",
"QtQt.W.X.Y.Z.0.1.2.3.4.5.6.6.7.WQtQt",
"Qt.8.9#.###aQtQtQtQtQtQt#a#b#c#d.8Qt",
"#e#f#g#h#aQtQt#f#f#f#fQtQt#a#g#h#d#i",
"#f#j#k#.#aQt#f#l#m#m#l#fQt#a#c#.#b#d",
"#f#n###g#aQt#f#o#o#o#o#fQt#a#b#p#q#d",
"#f#f#f#f#f#f#fQtQtQtQt#f#d#d#d#d#d#d"};

static const char* const image180_data[] = { 
"18 18 175 2",
"ag c #770000",
"#6 c #8a0000",
"#K c #8c0000",
"#5 c #940000",
"#V c #960000",
"#f c #970000",
"#U c #990000",
".C c #a00000",
"ah c #a10000",
"#T c #a10202",
"#z c #a20000",
".N c #a30000",
"ap c #a30404",
"ai c #a30605",
"#p c #a40000",
"aE c #a4120d",
"av c #a4130f",
".1 c #a70401",
"as c #a70502",
".2 c #a80e0d",
"aL c #aa0603",
"aD c #aa0c05",
".3 c #aa0e0d",
".B c #ab1010",
"#9 c #ac0100",
"au c #ac1b11",
"#8 c #ad0000",
"aC c #ad0804",
"af c #ad1213",
"ar c #ae3539",
"ae c #af0000",
"aQ c #b01d1c",
"aK c #b10805",
"at c #b21b10",
"#d c #b30504",
".r c #b33030",
"ad c #b50603",
"ak c #b51913",
"#7 c #b60000",
"#X c #b60100",
"ao c #b71c14",
".O c #b72120",
"#o c #ba0000",
"#I c #ba0805",
"az c #ba1a0b",
"an c #ba1c13",
"aj c #bc2117",
"#4 c #bf0000",
"#e c #bf0f05",
"aH c #bf1105",
"aG c #bf1808",
"ay c #bf200d",
"ax c #bf2413",
"aw c #bf2611",
"aF c #c02312",
"#c c #c10000",
"#J c #c11307",
"a. c #c11913",
".Z c #c20000",
".Y c #c30000",
".M c #c50c0e",
"#3 c #c60704",
"aq c #c60707",
"#W c #c70000",
".5 c #c7100f",
"aN c #c71107",
"aM c #c81505",
"aa c #c81f13",
".6 c #c9100e",
"ab c #c92116",
"#b c #ca0f0e",
"#S c #cb0601",
"#g c #cb0806",
".4 c #cb0f0e",
"#n c #cc0604",
".L c #cc0b06",
"#L c #cd0e07",
"aR c #cd2613",
"am c #cd2a15",
"al c #cd2f16",
"#a c #ce1716",
".R c #d02222",
".Q c #d12423",
"ac c #d1271b",
".P c #d22221",
"aA c #d33936",
"#Y c #d51c17",
"#s c #d6160f",
".A c #d63f3d",
"#r c #d72311",
".s c #d8130d",
".X c #d82d27",
"#C c #db1912",
"#1 c #dc2419",
"#0 c #dd231a",
".D c #dd4240",
"#v c #de2319",
"#N c #df251c",
"#E c #e02219",
".7 c #e02b21",
"#2 c #e1291d",
"#i c #e2261a",
".E c #e24e48",
".k c #e32316",
"#u c #e3271c",
"#B c #e32913",
"#R c #e4281f",
"#m c #e42c1d",
".e c #e43225",
"#. c #e53126",
"a# c #e53518",
".S c #e53c32",
"#D c #e6291a",
"#h c #e62b19",
"## c #e63728",
"#M c #e72b1b",
".U c #e74338",
"#l c #e82c1b",
".9 c #e83426",
".a c #e84d44",
"#t c #ea3320",
".z c #ea3424",
".V c #ea4337",
"#Q c #ec2f1b",
".W c #ec453a",
".0 c #ef3319",
".J c #ef584a",
".K c #ef5a4d",
".G c #ef5c4f",
".T c #f04e3e",
".F c #f0584d",
".j c #f17f75",
".v c #f37266",
".d c #f4b1ae",
".t c #f58175",
"#Z c #f63a1d",
".u c #f68177",
".f c #f6887d",
".m c #f68c81",
".l c #f7897f",
"#y c #f83820",
".I c #f8624d",
"aJ c #f8dfdc",
".b c #f96a57",
"#H c #fa3b1f",
"aB c #fa9e93",
".# c #fadcda",
"#k c #fc3e1e",
".8 c #fc4c30",
".H c #fc6a54",
".w c #fc7c65",
".y c #fc816b",
".q c #fc8475",
".n c #fc8b79",
".g c #fc8e7b",
"aP c #fdf7f6",
"#q c #fe3b1d",
"#A c #fe3d1d",
"#P c #fe3d1e",
"#F c #fe401d",
"#O c #fe411d",
".h c #fe492a",
"aI c #fe9680",
".i c #febbac",
"aO c #fed4cd",
".c c #fededb",
"aS c #fef6f5",
"#x c #ff3b1d",
"#G c #ff3c1d",
".p c #ff3d1d",
"#w c #ff3e1e",
"#j c #ff4522",
".x c #ff7d66",
".o c #ff8c75",
"Qt c #ffffff",
"QtQtQtQtQtQtQt.#.a.b.cQtQtQtQtQtQtQt",
"QtQtQtQtQtQt.d.e.f.g.h.iQtQtQtQtQtQt",
"QtQtQtQtQt.j.k.l.m.n.o.p.qQtQtQtQtQt",
"QtQtQtQt.r.s.t.u.v.w.x.y.z.AQtQtQtQt",
"QtQtQt.B.C.D.E.F.G.H.I.J.K.L.MQtQtQt",
"QtQt.C.N.O.P.Q.R.S.T.U.V.W.X.Y.ZQtQt",
"Qt.0.1.2.3.4.5.6.7.8.9#.###a#b#c#dQt",
"Qt.0.0#e#f.Y#g#h#i#j#k#l#m#n#o#p#dQt",
"Qt.0#q.0#r#s#t#u#v#w#q#x#y#d#z#p#dQt",
"Qt.0#A.0#B#C#t#D#E#F#q#G#H#I.C#p#dQt",
"Qt.0.0#J#K#c#L#M#N#O#P#Q#R#S#o#z#dQt",
"Qt.0#T#U#V#W#o#X#Y#Z#0#1#2#3#4#4#dQt",
"QtQt#V#5#6#7#8#9a.a#aaabacadae#cQtQt",
"QtQtQtafagahaiajakalamanaoapaqQtQtQt",
"QtQtQtQtarasatauavawaxayazaAQtQtQtQt",
"QtQtQtQtQtaBaCaDaEaFaGaHaIQtQtQtQtQt",
"QtQtQtQtQtQtaJaKaLaMaNaOQtQtQtQtQtQt",
"QtQtQtQtQtQtQtaPaQaRaSQtQtQtQtQtQtQt"};

static const char* const image181_data[] = { 
"18 18 126 2",
"#I c #4b4340",
"#C c #4c3b5c",
"#P c #4c4540",
"#R c #4e4742",
"#1 c #4f4843",
"#7 c #504a45",
"#5 c #524b46",
".f c #544e70",
"#t c #55476c",
"#6 c #554e4b",
"#Z c #57504c",
"#Q c #58524d",
"#Y c #5b544f",
"#A c #5d5550",
"#o c #5e4030",
".G c #5e588a",
"#i c #5e5987",
"#y c #614731",
".x c #645e8e",
".l c #645f8a",
".B c #6b678f",
"#H c #6c5240",
".X c #6c6794",
"#n c #6f5542",
"#x c #6f5543",
"#X c #6f5643",
".p c #6f6996",
".k c #6f6997",
".3 c #716894",
"#B c #745b4a",
"#b c #746795",
".P c #746d9a",
".b c #746f9a",
"#O c #755b4a",
"#c c #755b4b",
".# c #77729c",
"#4 c #807a75",
"#m c #807ba1",
".g c #8278a0",
".U c #837ea2",
".s c #897ea4",
".Y c #8983a6",
"#j c #8a84a7",
".j c #8a85ac",
"#a c #8b82a7",
".8 c #8c8cb0",
"#J c #8e8682",
"#S c #8e89a9",
"#z c #908883",
".a c #918aac",
"#0 c #968d87",
"#3 c #98908a",
"#h c #9894b6",
"#2 c #9e958f",
".2 c #9e95b6",
"#K c #9e9691",
".L c #9e96b4",
"#s c #9e9bb9",
".F c #9f9bba",
".w c #a19dbb",
".t c #a29bb9",
".A c #a29cb8",
".W c #a3a1bd",
"#w c #a4a0bb",
".Q c #a7a0bd",
"#W c #a8a4bd",
".T c #aea8c1",
"#l c #b2adc5",
".M c #b4afc7",
".u c #b6b1c7",
".Z c #b6b1c8",
"#N c #b6b1cb",
".o c #b6b4c8",
"#G c #b7b4ca",
".K c #b7b4cd",
".7 c #bab6ce",
"#r c #bab8ce",
"#D c #bcb8ce",
".O c #bdbcd2",
".v c #c0c0d2",
"#g c #c2bed3",
"#V c #c3bece",
"## c #c3c0d3",
".i c #c4c3d4",
".e c #c4c7d4",
".N c #cacad7",
".y c #cbcad7",
".q c #cbccda",
"#v c #ccc8d8",
".1 c #d0ceda",
".r c #d0cede",
"#M c #d1ceda",
".E c #d2d3de",
"#F c #d4d3de",
".0 c #d4d4de",
".S c #d6d4de",
".J c #d6d5e0",
"#k c #dad8e2",
"#f c #dcd9e4",
"#U c #dcdbe3",
".z c #dcdbe4",
"#q c #dcdce6",
".6 c #e0dce6",
".h c #e0deea",
"#e c #e1deea",
".n c #e1e1ea",
"#u c #e3e1ea",
"#. c #e4e1ea",
".I c #e4e3ea",
"#E c #e5e3ec",
".5 c #e9e9f0",
".D c #eaeaf0",
".V c #eaebf0",
"#p c #efecf1",
"#T c #efeff1",
"#L c #f1eff1",
"#d c #f1eff4",
".4 c #f2ecf4",
".c c #f2f0f4",
".d c #f3f2f4",
".H c #f5f2f4",
".C c #f5f3f4",
".m c #f5f5f4",
".R c #f6f5f5",
".9 c #f7f6f5",
"Qt c #ffffff",
"QtQtQtQt.#.a.a.bQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQt.a.c.d.e.f.f.gQtQtQtQtQtQtQt",
"QtQtQtQt.a.d.h.i.j.k.l.lQtQtQtQtQtQt",
"QtQtQtQt.a.m.n.o.p.q.r.r.f.f.sQtQtQt",
"QtQtQt.a.t.u.v.w.x.y.z.z.A.A.BQtQtQt",
"QtQtQt.a.C.D.E.F.G.H.I.J.K.L.BQtQtQt",
"QtQt.a.t.M.N.O.P.Q.R.C.S.T.U.BQtQtQt",
"QtQt.a.d.V.J.W.X.Y.Z.0.1.2.3.BQtQtQt",
"Qt.a.4.5.6.7.8.T.9.9#.###a#b#cQtQtQt",
".a#d#e#f#g#h#i#j.Z.S#k#l#m#n#oQtQtQt",
".a#p#q#r#s#t.T.C.C#u#v#w#x#y#zQt#AQt",
"Qt#B#c#c#C#D.d.V#E#F#G#H#c#I#J#K#AQt",
"QtQtQtQt#j#L.h.6#M#N#H#OQt#P#z#AQtQt",
"QtQt#Q#R#S#T#U#V#W#X#cQtQt#Y#ZQtQtQt",
"QtQtQtQt.a#c#c#c#c#cQtQt#0#AQtQtQtQt",
"QtQtQtQtQtQtQtQt#1#2#3#4#5QtQtQtQtQt",
"QtQtQtQtQtQt#A#A#6#5#7#0QtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image182_data[] = { 
"18 18 72 2",
".0 c #2f2521",
".6 c #392f2b",
".y c #3d6b87",
".2 c #3f3631",
".a c #473c38",
".3 c #483d38",
".b c #4b3e3b",
".# c #4d403d",
".7 c #4d403e",
".5 c #4d4340",
".c c #514742",
".j c #544843",
".8 c #564c47",
".Z c #574d4a",
"#b c #584e4b",
".T c #594f4b",
".d c #5a4f4b",
".K c #5b504c",
".z c #5d524d",
"#a c #5d524e",
"#c c #5e504c",
".o c #60544f",
".Y c #6093b3",
"## c #615550",
".U c #625653",
".e c #655955",
"#d c #665b57",
".9 c #685b57",
".4 c #685c58",
".f c #6b5f5b",
".X c #6c605b",
".I c #6d615c",
".S c #6da1bf",
".x c #6f645f",
".g c #716661",
"#. c #746864",
".n c #756964",
".h c #776a66",
".i c #7a6d69",
"#e c #7b6c68",
"#f c #887b76",
".J c #89b4ce",
".p c #ac1cbc",
".A c #b021bc",
".L c #b328ba",
".O c #b74f91",
".q c #b828b9",
".C c #b84a98",
".D c #b8548c",
".M c #ba2db6",
".N c #ba3f9e",
".B c #be36b6",
".r c #be3ea7",
".s c #be5988",
".1 c #c25e86",
".P c #c76786",
".V c #cb6d83",
".E c #cb6d84",
".t c #d07381",
".Q c #d07582",
".F c #d2777f",
".k c #d5807e",
".W c #da8d80",
".R c #dc9b86",
".G c #dfa889",
".u c #e0b186",
".H c #e3b582",
".v c #e5be7c",
".l c #e8afac",
".w c #e8c479",
".m c #f6d7d5",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQt.#.a.b.c.d.e.f.g.h.iQtQtQtQt",
"QtQtQt.j.k.k.k.k.k.k.k.l.l.m.nQtQtQt",
"QtQt.o.k.k.p.q.r.s.t.k.u.v.w.m.xQtQt",
"Qt.y.z.k.A.q.B.C.D.E.F.G.H.w.m.I.yQt",
".y.J.K.k.p.L.M.N.O.P.Q.R.u.v.m.I.J.y",
".y.S.T.k.p.A.q.r.U.I.V.W.G.H.m.X.S.y",
".y.Y.Z.0.k.1.k.U.2.3.I.m.m.m.b.4.Y.y",
"Qt.y.y.5.6.2.7.8.9#..U###a#b##.y.yQt",
"QtQtQtQt#c#d#e#fQtQt#c#d#e#fQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image183_data[] = { 
"18 18 103 2",
"#I c #3f9cca",
".i c #4ba4cd",
"#J c #4da4ce",
"#H c #54a9d0",
"#g c #57afd4",
".h c #58add3",
"#F c #5aacd3",
".T c #5aaed2",
"#o c #5aafd3",
"#K c #63b1d6",
"#A c #65b3d6",
".U c #663600",
".q c #66b4d6",
".K c #66b4d7",
"#B c #68b4d7",
"#C c #6ab4d7",
"#t c #6ab5d7",
"#G c #6ab5d8",
"#u c #6ab6d8",
".j c #6bb4d6",
"#n c #6bb5d7",
"#D c #70b8da",
".A c #71b8d8",
".9 c #71bad9",
"#z c #74bada",
".u c #77bbda",
"#y c #78bbda",
".H c #7abcda",
".G c #7dbdda",
"#j c #905c21",
".6 c #905d21",
"#k c #926228",
"#b c #956428",
"#v c #b9e6ff",
"#w c #b9e7fc",
".s c #c2ecff",
".r c #c3ebff",
"#h c #c4ecff",
".B c #caecff",
"#E c #cbecff",
".1 c #ccecff",
".t c #cdecff",
".R c #d0efff",
".2 c #d1ecfe",
".3 c #d1f0fc",
".F c #d2effe",
".P c #d4effe",
"#f c #d6eff4",
"#. c #d9f2fc",
"#p c #dbf2fc",
"#x c #dcf2fe",
"#q c #dcf6fc",
"#i c #e0f5fa",
".0 c #e0f5fe",
".8 c #e1f7fc",
".O c #e5f6f2",
".Z c #e5f6fc",
".Q c #e7f7f5",
".Y c #e7f7fc",
"#e c #e8f7fa",
".C c #eaf5f4",
"#c c #eaf7fa",
".L c #edf7f4",
".7 c #edf7fa",
".X c #edf9fa",
".D c #eff6f7",
".5 c #eff7fa",
".M c #f2f7f9",
".E c #f2f7fa",
".4 c #f2f9f9",
".V c #f2f9fa",
".W c #f3f9fa",
"#d c #f5f9f7",
".N c #f5f9fa",
"#s c #f7f9f9",
"#r c #f8f9f9",
".c c #fa7a00",
".a c #fe9100",
".b c #fe9200",
".z c #ff7c00",
".I c #ff7e00",
"#a c #ff8146",
"#m c #ff884f",
".p c #ff8e00",
"## c #ff8e4c",
".g c #ff9600",
".# c #ff9700",
".J c #ff9b00",
".S c #ff9c00",
"#l c #ffa471",
".y c #ffb600",
".o c #ffc100",
".x c #ffcc00",
".w c #ffd300",
".n c #ffd400",
".v c #ffd500",
".k c #ffe215",
".l c #ffe31d",
".d c #ffe524",
".m c #ffe52b",
".e c #ffe531",
".f c #ffe535",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQt.#QtQtQtQtQtQtQt",
"QtQtQtQtQt.#QtQtQtQt.#QtQtQtQtQtQtQt",
"QtQtQtQtQtQt.#QtQtQtQtQtQtQtQt.#QtQt",
"QtQtQtQtQtQtQtQtQt.a.b.bQtQt.#QtQtQt",
"QtQtQtQtQtQtQtQt.c.d.e.f.gQtQtQtQtQt",
"QtQtQtQtQt.h.i.j.k.l.m.n.o.pQt.#.#Qt",
"QtQtQtQt.q.r.s.t.u.v.w.x.y.zQtQtQtQt",
"QtQtQt.A.B.C.D.E.F.G.w.H.H.IQt.JQtQt",
"QtQtQt.K.B.L.M.N.O.P.H.Q.R.HQtQt.SQt",
"QtQt.A.T.L.U.V.W.V.X.Y.Z.0.1.HQtQtQt",
"Qt.H.2.3.M.E.M.E.4.V.5.6.7.8.HQtQtQt",
".9.B#.###a.E#b#c#c#b#d.M.7#e#f.HQtQt",
"#g#h#.#i.5.M#c#j#k#c#d#l#m.5#..B#nQt",
"#o#h.B#p#q#c#c#c#c#c#r#s#d.5#..B#tQt",
"Qt#u.H#v#w#w#w#w#w.B#x#x#x#..B.B#yQt",
"QtQtQt#z#A#B#C#C#D#w#E#E#E#E.B.HQtQt",
"QtQtQtQtQtQtQtQtQt#F#G#H#I#J#KQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image184_data[] = { 
"18 18 124 2",
".Z c #312e36",
".B c #3a3742",
".N c #3c3842",
".1 c #403d46",
".O c #443f4a",
".E c #4f4c54",
".k c #927f80",
".j c #988d86",
".I c #998a85",
".6 c #9c8a82",
".n c #9e8f8b",
".a c #a49697",
".T c #a59792",
".x c #a59796",
".H c #a89f9a",
"#F c #a99a91",
".e c #aa9f9a",
"#U c #ac9e9a",
".b c #aca39c",
".5 c #aea49e",
"#V c #aeaca8",
".d c #afa49e",
".z c #b0a3a0",
".y c #b0a49e",
".o c #b1a39d",
".f c #b3a6a1",
".# c #b6ada7",
".c c #b9ada6",
".S c #b9afa9",
"#0 c #beb4ab",
"#Q c #beb4b2",
"#G c #bfb3ae",
"#H c #c3b7b3",
"#E c #c4bcb9",
".W c #c4d4e9",
"#1 c #c7beba",
"#T c #c7bebb",
"#R c #cac4c3",
"#Z c #cbc3c1",
"#S c #cbc6c3",
".X c #cbdce9",
"#f c #ccc4c3",
"#4 c #cdc6c3",
"#L c #d0c4c1",
"#r c #d0c7c5",
"#q c #d0c8c5",
"#2 c #d0ccc8",
"#s c #d1c8c7",
".3 c #d1e2e9",
"#K c #d2c7c5",
"#3 c #d2cdca",
"#M c #d4cdca",
"#W c #d6cece",
"#5 c #d6cfce",
".G c #d9d4d3",
".U c #dad0d3",
".7 c #dad4d4",
"#D c #dbd4d4",
"#P c #dbd6d4",
"#Y c #dcd4d4",
"#X c #dcd5d5",
"#J c #dcd6d3",
".4 c #dcd6d6",
"#t c #dcd7d4",
"#y c #dcd7d5",
".m c #dcd7d6",
".w c #dcd8d6",
"#O c #dcd8d8",
"#I c #dcdbd8",
"#u c #dfdbd8",
"#x c #e0d8d5",
"#w c #e0d8d6",
"#z c #e0d8d7",
"#p c #e0d9da",
".J c #e0dbda",
"#C c #e0dcdc",
"#g c #e0deda",
"#N c #e1dcde",
".R c #e1ddde",
".l c #e1dede",
"#B c #e3dede",
"#v c #e4deda",
"#e c #e4dede",
".g c #e4e2e0",
"#h c #e4e2e2",
"#A c #e5e1e2",
"#i c #e7e2de",
"#o c #e7e2e2",
".p c #e7e5e3",
"#m c #e8e2e2",
"#l c #e8e3e2",
".h c #e8e3e4",
".Y c #e8e5e3",
"#n c #e8e5e4",
"#k c #eae5e3",
"#d c #eae5e7",
"#j c #eae6e3",
"#a c #eae6e7",
".2 c #eae9e7",
".M c #eae9e9",
".i c #eaeae7",
".A c #eaeae9",
"## c #eaebe9",
"#c c #eaebea",
"#. c #eaece9",
".t c #eaecea",
".Q c #efebe9",
".V c #efecea",
".u c #efecec",
".8 c #efeced",
".s c #efefed",
"#b c #eff0ef",
".P c #f2efed",
".F c #f2f0ed",
".q c #f2f0ef",
".9 c #f2f0f0",
".K c #f2f2f0",
".v c #f2f2f1",
".r c #f3f3f2",
".C c #f3f3f4",
".D c #f5f3f4",
".0 c #f8f5f4",
".L c #f8f7f5",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQt.#.a.bQtQt.c.d.eQtQtQtQtQt",
"QtQtQtQt.f.g.h.i.j.k.l.g.m.nQtQtQtQt",
"QtQtQt.o.p.q.r.r.s.t.u.v.u.w.xQtQtQt",
"QtQt.y.z.A.B.r.C.D.r.r.E.F.i.G.HQtQt",
"Qt.I.J.t.K.L.M.N.O.M.P.D.s.Q.R.SQtQt",
".T.U.V.W.X.Y.Z.L.0.1.2.3.3.2.Y.4.5Qt",
".6.7.2.8.9#..2##.Q#a#b.u#c#d#e.7.jQt",
".6#f#g#h#i.Y#j#k#l#m#n#n#m#o#p#q.jQt",
".6#r#s#t#u#v#w#x#y#z#A#B#C.m#D#E.jQt",
"#F#G#H#q#I#v#J#K#L#M#A#N#O#P#D#E.5Qt",
"Qt.6.6#Q#R#S#T#U.6#V#W#X#D#Y#Z.5QtQt",
"QtQt#0.6.6.6.5QtQt.6#1#2#3#4.5QtQtQt",
"QtQtQtQtQtQtQtQtQtQt.5.6.6.5#5QtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image185_data[] = { 
"18 18 119 2",
"#Z c #00a9b9",
"#R c #00b6c3",
"#W c #00c7d2",
"#0 c #00d3da",
"#V c #00eaee",
"#X c #3dd6de",
"#S c #52dee2",
"#Y c #59e1e6",
"#N c #5ddbe2",
"#U c #7ae1e7",
"#G c #84ecf0",
"#T c #87e5e9",
".R c #8c7b74",
".H c #918377",
".4 c #96837e",
"#Q c #97857a",
"#t c #98857f",
"#P c #99ecee",
"#H c #9b8a7f",
".t c #9f9188",
"#s c #9f9287",
".# c #9f9386",
"#M c #a19486",
"#z c #a3958b",
".G c #a4958d",
"#O c #a4eff1",
".e c #a59691",
"#E c #a79a8b",
".3 c #a89a91",
".h c #a89a94",
".y c #a89b93",
"#L c #a89c8d",
".g c #a99b95",
".Q c #aca097",
"#I c #aca194",
".a c #b0a4a4",
".o c #b6aaa9",
"#g c #b6acac",
"#K c #b6ada9",
"#F c #b6adab",
".u c #b7adab",
"#u c #b8ada9",
"#J c #b8afac",
"#r c #bab1b0",
"#y c #bcb1ae",
".f c #bdb4b2",
".5 c #beb4b1",
".I c #c0b7b6",
"#A c #c2bbb6",
"#x c #c2bcb8",
"#h c #c3b6b2",
"#D c #c3b7b3",
"#v c #c3bab9",
"#C c #c9bdb9",
"#w c #c9beba",
"#B c #c9c1bc",
"#i c #cbc2c1",
"#f c #ccc6c1",
".6 c #cdc6c3",
"#q c #cdc7c5",
"#n c #d0ccc8",
"#p c #d2cac6",
"#m c #d4cfcd",
".2 c #d5cfcd",
"#o c #d5d0ce",
"#j c #d6cfcd",
"#e c #d7d0ce",
".J c #d7d4d2",
"#k c #dad3d4",
".7 c #dad4d0",
"#l c #dad4d2",
"## c #dad6d4",
".S c #dbcdce",
".1 c #dcd7d4",
"#d c #dcd9d7",
".8 c #dcdbd8",
"#. c #e0d4d8",
"#a c #e0d7d4",
"#b c #e0d8d7",
".P c #e0d9da",
".T c #e0dbd8",
"#c c #e0dbda",
".Y c #e0ddda",
".K c #e3deda",
".F c #e3dedc",
".9 c #e3e1de",
".Z c #e4e1de",
".0 c #e4e2de",
".U c #e4e2e0",
".z c #e5e1de",
".X c #e7dee2",
".W c #e7e1de",
".N c #e7e1e2",
".O c #e7e2e0",
".C c #e7e2e2",
".w c #e7e5e2",
".L c #e8e1de",
".A c #e8e5e3",
".x c #e9e2e6",
".s c #e9e5e6",
".n c #e9e7e6",
".D c #eae2e7",
".V c #eae5e2",
".M c #eae5e3",
".m c #eae7e7",
".r c #eae9e7",
".b c #eaeae7",
".q c #eaebe9",
".E c #ede5e3",
".l c #edecea",
".p c #efe6e4",
".B c #efe9e7",
".c c #efeaec",
".v c #efeaed",
".i c #efecea",
".d c #efefed",
".k c #f1f0ee",
".j c #f2ecec",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQt.#.#.aQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQt.#.b.c.d.eQt.f.g.hQtQtQtQtQt",
"QtQtQt.#.i.j.k.k.g.g.l.m.n.oQtQtQtQt",
"QtQtQt.#.p.k.k.i.q.n.q.r.n.s.tQtQtQt",
"QtQt.u.#.n.v.l.r.n.r.b.b.w.x.yQtQtQt",
"Qt.#.#.z.A.n.B.C.D.A.E.r.n.C.F.GQtQt",
".H.I.J.K.n.b.l.A.w.L.A.M.N.O.P.QQtQt",
".R.I.S.T.U.n.V.W.X.Y.Y.Z.w.0.1.2.3Qt",
".4.5.6.7.8.9.Z.T#.###a#b#c#d#e#f.3Qt",
".##g#h#i#j#k#l#m#n#n#n#o#e#p#q#r#sQt",
"Qt.##t#u#v#w#x#y#z#y#y#A#B#C#D#E#FQt",
"QtQt#G.##H#t#t.##A.##t#I#J#K#L#MQtQt",
"Qt#NQtQt#OQtQt#PQtQt.##t#Q.#QtQtQtQt",
"#RQtQt#SQtQt#TQtQt#UQtQt#VQtQtQtQtQt",
"QtQt#WQtQt#WQtQt#XQtQt#YQtQtQtQtQtQt",
"QtQtQtQtQtQtQt#ZQtQt#0QtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image186_data[] = { 
"18 18 68 2",
".y c #883f07",
".v c #8b4709",
".w c #9cd3f7",
".u c #9ed3f7",
".n c #b2ccf7",
".g c #bac8f7",
".c c #baefb8",
".x c #c37428",
".e c #c3dbf4",
".o c #c9c7f7",
".k c #c9efc5",
".d c #c9f3cd",
".2 c #ca3f00",
".s c #cbe1b8",
".f c #cbe6be",
".t c #cbefc3",
".p c #ccc8f5",
".b c #d0f7d3",
".h c #d1cdf5",
".r c #d1e2ec",
".l c #d1f7d2",
".q c #d2d3f2",
".j c #d2e5ed",
"#a c #d65e00",
".i c #d7dbf2",
".# c #daf8da",
".m c #daf9dc",
"#b c #db5800",
".W c #e06100",
".a c #e3f9e4",
".O c #e44c00",
".z c #e44d00",
".C c #e46b00",
".B c #e47609",
".N c #e56900",
".M c #e57102",
"## c #ea8a00",
".U c #ea9700",
".6 c #ef9300",
".1 c #ef9d00",
".3 c #f19e00",
".V c #f2a600",
".0 c #f6a300",
".G c #f6c400",
".K c #f7c000",
".7 c #f7cc00",
".A c #f7ce00",
"#. c #f8a700",
".5 c #f8a900",
".T c #f8ae00",
".L c #f8bd00",
".E c #f8c700",
".F c #f8c800",
".9 c #f9bc00",
".J c #fac700",
".8 c #fade15",
".I c #fae100",
".4 c #fbdc00",
".H c #fbf77e",
".Y c #fdc800",
".Z c #fdcc00",
".S c #fdcd00",
".R c #fdec09",
".X c #fdf367",
".P c #fdf768",
".Q c #fef762",
".D c #fff9b4",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQt.#.#.a.aQtQtQtQtQtQt",
"QtQtQtQtQtQtQt.a.#.b.a.a.aQtQtQtQtQt",
"QtQtQtQtQt.c.c.d.b.b.b.a.aQtQtQtQtQt",
"QtQtQt.e.f.f.c.d.#.a.a.aQtQtQtQtQtQt",
"Qt.g.h.i.j.f.k.l.m.aQtQtQtQtQtQtQtQt",
".n.o.p.q.r.s.t.lQtQtQtQtQtQtQtQtQtQt",
".u.o.pQtQtQtQtQtQt.vQtQtQtQtQtQtQtQt",
".u.wQtQtQtQtQtQt.v.x.yQtQtQt.z.z.AQt",
"Qt.B.BQtQtQtQt.C.D.E.F.zQt.z.GQt.zQt",
".B.D.H.B.BQt.C.D.I.J.K.K.z.LQtQt.zQt",
"Qt.B.B.H.H.B.M.N.N.N.O.O.z.zQtQt.zQt",
"QtQtQt.B.H.H.H.P.Q.Q.R.S.T.UQt.z.VQt",
"QtQtQtQt.W.H.H.X.P.P.Y.Z.0.1.2.3QtQt",
"QtQtQtQtQt.W.D.X.4.4.Y.5.6.2.7QtQtQt",
"QtQtQtQtQtQt.W.8.8.9#.##.2QtQtQtQtQt",
"QtQtQtQtQtQtQt.W#a.W.W.2QtQtQtQtQtQt",
"QtQtQtQtQt#b#b#b#b.2.2.2.2.2QtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image187_data[] = { 
"18 18 152 2",
"#i c #5f8a02",
"#. c #5f8c02",
"#g c #608c02",
".V c #618c02",
".8 c #618d02",
"## c #628d02",
"#h c #638d07",
".7 c #648d07",
".E c #648e02",
".F c #658f07",
"#e c #669007",
"#c c #699107",
".p c #6a9307",
"#d c #6a9309",
".q c #6c9609",
".1 c #6f9709",
".f c #709a09",
"#n c #709c07",
".W c #739d07",
".M c #759c09",
".g c #759d09",
"#x c #759f07",
".e c #789e09",
".3 c #789f09",
".w c #7aa109",
".S c #7aa309",
".# c #7ca309",
".2 c #7da30c",
".d c #7da409",
".a c #80a70c",
".k c #82a70c",
".c c #82a80c",
".b c #83a80c",
".B c #84aa09",
".I c #84aa0c",
".N c #86aa11",
".l c #88ad0f",
".x c #89ae11",
"#w c #89bc00",
"#N c #8e2f00",
"#C c #902f00",
"av c #903002",
"#q c #903100",
"#6 c #903102",
"#p c #903400",
".X c #90c700",
".T c #90c800",
"#o c #913402",
"#5 c #923402",
"#4 c #973702",
"#m c #983902",
".H c #98cc00",
".C c #98cd00",
"#3 c #9a3d02",
"#l c #9b3e02",
"aq c #9e3f02",
"#k c #9f4002",
"#2 c #9f4007",
"#f c #9fca02",
".9 c #a1cc02",
"#j c #a24707",
"#K c #a34002",
"as c #a34807",
".U c #a3cc02",
".A c #a3d300",
"#1 c #a54c07",
".t c #a5d400",
".u c #a7d400",
"#J c #a84702",
"#r c #a85009",
".z c #a8d400",
"#0 c #aa5209",
"#I c #ac4e07",
"an c #ac5309",
"#a c #acd01b",
".6 c #acd320",
"#D c #ae5809",
"#H c #af5407",
"#b c #afd320",
"#Z c #b15b09",
".5 c #b1d424",
"ae c #b25d09",
"#O c #b35d09",
"#Y c #b35e0c",
".Z c #b3d428",
".R c #b3d528",
".0 c #b3d628",
"#7 c #b45f09",
".D c #b4e200",
".4 c #b6d528",
".Q c #b7d72b",
".Y c #b7e300",
".L c #b8d82e",
".o c #bae500",
".P c #bcd931",
".n c #bee600",
".O c #bfdc38",
".J c #bfe500",
".K c #bfe700",
".v c #c3e700",
".i c #c4e900",
".j c #c4ea00",
".s c #caf500",
".h c #cbf500",
"at c #cc6a09",
"ad c #d25c00",
"#y c #d45e00",
"ac c #d55f00",
"am c #d66100",
"ab c #d66200",
"al c #d66400",
"aa c #d76900",
"#v c #d96b00",
"a# c #da7000",
".r c #daf792",
"#G c #dc7700",
"a. c #dc7800",
"ao c #e07f00",
"#9 c #e08000",
"#8 c #e08600",
".m c #e0f8a2",
"af c #e18d00",
"#X c #e47615",
"au c #e77e1b",
"#P c #efa03d",
"#M c #f2780f",
"#A c #f27b0f",
"#z c #f27c0f",
"ar c #f37e14",
"ak c #f38014",
"aj c #f58515",
"ai c #f58c1a",
"#u c #f58d1b",
"ap c #f58f20",
"ah c #f69220",
"#Q c #f69e2d",
"#E c #f79c29",
"#B c #fb9a3c",
"#L c #fb9a3d",
"#W c #fb9d40",
"#V c #fba046",
"#U c #fba34c",
"#T c #fda853",
"#S c #fdad59",
"#s c #fdaf5c",
"#R c #fdb160",
"#F c #fdb361",
"ag c #fdb462",
"#t c #ffbd14",
".G c #fffd43",
".y c #fffdbb",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQtQtQt.#.a.bQtQtQt",
"QtQt.c.d.e.fQtQtQtQtQt.g.h.i.j.kQtQt",
"Qt.l.m.h.n.o.pQtQtQt.q.r.s.t.u.v.wQt",
".x.y.z.A.B.C.D.EQt.F.G.H.I.J.K.L.MQt",
".N.O.P.Q.R.S.T.U.V.W.X.w.Y.Z.0.1QtQt",
"Qt.2.3.4.5.6.7.8.9#.###a.6#b#cQtQtQt",
"QtQtQt.1#d#e.7Qt#f#gQt.V###hQtQtQtQt",
"QtQtQtQtQtQtQtQt.9#iQtQtQtQtQtQtQtQt",
"QtQtQtQt#j#k#l#m.U#n#o#o#p#qQtQtQtQt",
"QtQtQt#r#s#t#u#v#w#x#y#z#A#B#CQtQtQt",
"QtQtQt#D#E#F#G#H#I#J#K#y#L#M#NQtQtQt",
"QtQtQt#O#P#Q#R#S#T#U#V#W#A#X#NQtQtQt",
"QtQtQtQt#Y#Z#0#1#2#3#4#5#6#NQtQtQtQt",
"QtQtQtQt#7#8#9a.a#aaabacad#NQtQtQtQt",
"QtQtQtQtaeafagahaiajakalam#NQtQtQtQt",
"QtQtQtQtQtanaoapaq#marab#CQtQtQtQtQt",
"QtQtQtQtQtQtas#2atau#5avQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image188_data[] = { 
"18 18 92 2",
"## c #b40502",
"#p c #b70500",
".u c #b71100",
".P c #b71300",
".Q c #b71700",
".c c #b72d00",
".E c #b72f00",
".# c #b74000",
".d c #b74500",
".h c #b74600",
".k c #b74b00",
".j c #b74f00",
".i c #b75200",
"#k c #b80600",
"#t c #b80700",
"#l c #b80800",
"#m c #b80900",
"#c c #b80b00",
".S c #b81100",
".R c #b81c00",
"#o c #b90500",
"#y c #b90800",
"#u c #ba0802",
"#. c #bc0800",
"#n c #bd0700",
"#z c #be0600",
"#d c #bf0800",
".9 c #bf0f00",
".H c #c30607",
".N c #c70500",
".6 c #c70600",
".7 c #c70800",
".o c #c71300",
".w c #c73b00",
".D c #c90b00",
".8 c #c90c00",
".3 c #c91400",
".p c #c93e00",
".M c #cb1100",
".W c #cb1400",
".4 c #cb1402",
".s c #d21602",
".2 c #d42000",
".V c #d62a07",
".F c #d63c00",
".C c #d92d0f",
".L c #db2f09",
".U c #dc3402",
".I c #e02f14",
".m c #e0360f",
".K c #e03914",
".J c #e03b11",
".v c #e03e02",
".g c #e13f00",
".r c #e33b17",
".y c #e34e17",
".a c #e56d00",
".B c #e74b1b",
".z c #e8521d",
".A c #e85523",
".1 c #ea0007",
".0 c #ea0009",
"#x c #ed0009",
".x c #ed4e24",
".l c #ef4e24",
".f c #ef5324",
"#a c #f10717",
"#f c #f20815",
"#e c #f20c14",
".n c #f25211",
".q c #f65b30",
".e c #f65e2e",
".b c #f65e30",
".t c #f65f2e",
"#s c #f8000f",
"#w c #ff0115",
"#b c #ff051d",
"#j c #ff0620",
".Y c #ff071a",
".Z c #ff0815",
".T c #ff1436",
"#r c #ff1b2e",
".X c #ff1c3d",
".O c #ff203c",
"#i c #ff2138",
"#g c #ff2442",
".5 c #ff2443",
"#h c #ff2542",
".G c #ff2724",
"#q c #ff283e",
"#v c #ff2d38",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQt.#.#QtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQt.#.a.#QtQtQtQtQtQt",
"QtQtQtQtQtQtQtQt.#.a.b.b.cQtQtQtQtQt",
"QtQtQtQtQtQtQt.d.b.e.f.g.cQtQtQtQtQt",
".h.i.i.j.kQtQt.h.b.l.m.g.n.oQtQtQtQt",
"Qt.c.b.b.b.p.p.p.q.r.s.g.t.uQtQtQtQt",
"Qt.c.v.w.x.y.z.A.B.C.D.g.uQtQtQtQtQt",
"Qt.E.F.G.H.I.J.K.L.M.N.O.P.Q.R.SQtQt",
"QtQt.E.G.T.N.U.V.W.N.X.O.Y.Z.0.1.2.3",
"QtQtQt.4.T.5.N.X.N.X.X.N.6.7.8.1.9Qt",
"Qt#.###a.T.5.N.N.N.N.N#b.Y.Z.0#cQtQt",
"#d#e#f#a#a.5.5.N#g#h#i#j#k#l#mQtQtQt",
"#.#n#o#p#p#p#p#p#h#q#r#s#tQtQtQtQtQt",
"#uQtQtQtQtQt#p#p#p#v#w#x#x#yQtQtQtQt",
"QtQtQtQtQt#z#pQtQt#t#y#y#y#y#yQtQtQt",
"QtQtQtQtQt#pQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQt#p#pQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQt#p#pQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image189_data[] = { 
"18 18 236 2",
"#N c #056699",
"#D c #066d9d",
"#1 c #076c9f",
"#k c #0770b3",
"#y c #096fb1",
"#X c #09739f",
".8 c #0974b4",
"#M c #097eb5",
"#W c #0b719f",
".T c #0e7cb7",
"#V c #0f6f9c",
"#U c #0f7190",
"#0 c #0f8dbb",
"bN c #102bbf",
"bI c #112cbf",
"#C c #117caf",
"by c #132ebf",
"#. c #137eb7",
"#2 c #146b98",
".Y c #1480b7",
"#Y c #1492bb",
"#x c #14a9e1",
"bO c #1630bf",
".G c #1680b8",
"#j c #16a3dd",
"#m c #177eb8",
"ae c #186ca3",
".L c #1a78aa",
"bJ c #1c35c0",
".b c #1c81a5",
".c c #1d81a5",
"bH c #1e41e2",
"bx c #1e43e3",
"#w c #1eb8e4",
".j c #1f81a6",
"#L c #1fb8e4",
"bP c #2139c1",
"bG c #2147e3",
"bF c #2249e3",
"#Z c #22bbe4",
"bw c #244de4",
".g c #247fa1",
"#i c #24bce2",
"bh c #2654e5",
"#K c #26bfe5",
"#h c #27a9c4",
"#v c #27c0e5",
".6 c #289eb2",
".7 c #29bfe2",
".d c #2b83a7",
".a c #2b84a7",
"#E c #2bc2e5",
"#b c #2d9cab",
"#J c #2dc4e6",
"bg c #2e5fe8",
"#n c #2fc6e6",
"bi c #305bde",
"a3 c #3065e6",
".3 c #309ca8",
"#u c #30c7e6",
"#q c #31b0c5",
"#F c #31c8e6",
"#I c #32c8e6",
"bv c #335fe8",
".# c #3480a5",
"a2 c #356eea",
"#G c #36cbe6",
"#p c #37c3da",
"#H c #37cce6",
".5 c #38b7c9",
"#o c #38cce6",
"bt c #3968e9",
".S c #39cae2",
"#g c #39cce5",
"#t c #39cde6",
"a8 c #3acb15",
".1 c #3bacb6",
".0 c #3bb7c4",
".P c #3e625a",
".N c #3f635a",
"#a c #40c7d9",
"#s c #40d1e7",
".Q c #416962",
"af c #4186c6",
"#c c #42c1cf",
".R c #43716c",
"## c #43d3e8",
"aM c #447fec",
"#f c #44d4e8",
".E c #451b07",
"bm c #45a01b",
"#r c #45d4e7",
".4 c #46c5d4",
".D c #474032",
"bu c #4874ed",
".u c #495446",
".F c #496157",
"a7 c #49a51d",
"#e c #49d5e5",
"aU c #4ac51d",
".C c #4b3624",
".v c #4e3723",
"a9 c #4eaa3b",
".r c #51624e",
"aR c #51a625",
"#d c #53dce9",
"bf c #5485f0",
".O c #558075",
"aw c #558fef",
".Z c #55dbe6",
"ah c #5790eb",
".t c #588378",
"bl c #58a730",
"#R c #59a636",
".M c #59d7dc",
"aA c #5aa92c",
".q c #5b371c",
"aS c #5ce629",
".A c #5e3919",
"aT c #5ee42a",
"a1 c #6092f3",
"#B c #60a740",
"aN c #618ede",
".2 c #61e0e8",
"#7 c #62ab36",
"bd c #6594f4",
"ag c #689df5",
".i c #68e4ea",
"aD c #6ac83a",
".n c #6b4327",
".s c #6cdede",
".h c #6de5e8",
"bn c #710969",
"bM c #720565",
"bz c #740766",
"#T c #74d49f",
"aL c #75a4f7",
"bL c #760361",
".I c #764e2f",
"bA c #770361",
".e c #775236",
".m c #775337",
".J c #78543a",
"a0 c #79a6f8",
".B c #7a5235",
"bK c #7b0f66",
"aC c #80ed48",
".p c #81593c",
".o c #825a3c",
".l c #846248",
".z c #847d69",
".f c #855f42",
".V c #86654b",
".K c #86674c",
".H c #88684f",
"be c #8ab1fc",
"aJ c #8caffa",
"av c #90b7fd",
"aB c #92f261",
"ad c #9360c1",
"aK c #94bafe",
"bE c #9721a6",
"au c #9abdff",
".w c #9c8f83",
"at c #9fb1fb",
"a. c #a1ef69",
"bs c #a22cb1",
".k c #a29083",
"bB c #a8128e",
"bC c #aa1490",
"an c #aae578",
"bD c #ab1592",
"bc c #ab3ebe",
".W c #ab9583",
"bo c #ad1694",
"aZ c #af4ec9",
"am c #aff981",
"bp c #b01898",
"bq c #b31a9c",
"a4 c #b4b398",
"br c #b51b9f",
"b. c #b61d9e",
"b# c #b91fa4",
"ba c #bb1fa6",
"#S c #bbfd91",
"bb c #bc21a8",
"aV c #be3ba7",
"#9 c #bffe98",
"aI c #c165d7",
"#8 c #c2ff9c",
"aY c #c327b1",
"aX c #c72eb4",
"#Q c #ca9a21",
"#z c #ce9919",
"aQ c #cf9914",
"a# c #d086dc",
"#O c #d0d892",
"aW c #d13fbe",
"#6 c #d19b1a",
"bj c #d4990f",
"az c #d49a16",
"al c #d49b17",
"a6 c #d49c1f",
"ax c #d6d2ae",
"aH c #dc50cd",
"as c #de7ae5",
"aE c #e066d4",
".x c #e1d8d1",
"aG c #e761d8",
"ac c #e762d9",
"ao c #e779e4",
".X c #ebe5e1",
"ab c #ec69dd",
"aa c #ee6cdf",
"#3 c #efe283",
"#l c #eff5fb",
".y c #f0ebe7",
".9 c #f2f7fc",
"aF c #f77de8",
"ar c #f87ee9",
"aq c #fa82ec",
".U c #fcfdfe",
"ap c #fd86ef",
"aO c #fee77a",
"ai c #fee989",
"a5 c #ffda43",
"aP c #ffe576",
"#P c #ffeb91",
"#4 c #ffeea1",
"ak c #ffeea2",
"#5 c #ffeea3",
"ay c #ffefa6",
"aj c #ffefaa",
"bk c #fffcf2",
"#A c #fffdf5",
"Qt c #ffffff",
"QtQtQtQtQtQt.#.a.b.c.d.#QtQtQtQtQtQt",
"Qt.e.fQtQtQtQt.g.h.i.j.kQtQtQtQtQtQt",
"Qt.l.m.n.o.p.q.r.s.t.u.v.wQtQtQtQtQt",
"QtQt.xQt.y.z.A.B.C.D.E.F.GQtQtQtQtQt",
"Qt.H.I.J.K.L.M.N.O.P.Q.R.S.T.UQtQtQt",
"Qt.V.W.X.Y.Z.0.1.2.3.4.5.6.7.8.9QtQt",
"QtQtQt#.###a#b#c#d#e#f#g#h#i#j#k#lQt",
"QtQt#m#n#o#p#q#r#f#s#t#u#v#w#x#y#z#A",
"Qt#B#C#D#E#F#G#H#G#I#J#K#L#M#N#O#P#Q",
"Qt#R#S#T#U#V#W#X#X#Y#Z#0#1#2#3#4#5#6",
"Qt#7#8#9a.a#aaabacadaeafagahaiajakal",
"Qt#7#9amanaoapaqarasatauavawaxayakaz",
"QtaAaBaCaDaEaFaGaHaIaJaKaLaMaNaOaPaQ",
"QtaRaSaTaUaVaWaXaYaZa0ava1a2a3a4a5a6",
"QtQta7a8a9b.b#babbbcbdbebfbgbhbibjbk",
"QtQtblbmbnbobpbqbrbsbtbubvbwbxbyQtQt",
"QtQtQtQtbzbAbBbCbDbEbFbGbHbIbJQtQtQt",
"QtQtQtQtQtQtbKbLbLbMbNbObPQtQtQtQtQt"};

static const char* const image190_data[] = { 
"18 18 115 2",
".6 c #000b2b",
".q c #000e3d",
"#O c #001779",
".D c #00185f",
".h c #001870",
"#S c #001a94",
"#W c #001b97",
".V c #002477",
".k c #003926",
"#R c #0044ad",
".y c #00683e",
".c c #111076",
".L c #137f4f",
".f c #153b5f",
".b c #17117a",
"#c c #1c1411",
"#V c #1d61ba",
".1 c #1f1714",
".9 c #221a17",
".W c #232b1f",
".x c #25426e",
".Q c #281f1d",
"#a c #2a2220",
".p c #2e4273",
"#b c #332b29",
".3 c #3b3432",
".A c #3e3735",
"#p c #413a38",
"#i c #47403e",
".w c #496186",
".s c #499044",
"## c #4b0409",
".l c #4d8c49",
"#l c #4f050d",
"#L c #5176b5",
".S c #524c49",
".O c #554f4c",
".5 c #582e48",
".U c #5f7495",
".a c #6529a6",
".t c #67a263",
".z c #6c6664",
".2 c #6e6967",
"#G c #6e8dc1",
".0 c #716c6a",
"#E c #728dbd",
"#H c #744c71",
"#C c #751028",
".M c #7aae76",
"#g c #7f7b79",
"#M c #7f9bc9",
".C c #827e7c",
".m c #854a9c",
".g c #8847a0",
"#r c #891637",
"#K c #891a26",
".X c #8e8531",
".B c #8e8988",
".T c #9c9897",
"#B c #9f5060",
".R c #9f9b9a",
"#h c #a19e9d",
"#u c #a4a1a0",
"#. c #a51010",
".n c #a878b9",
"#A c #aaa7a6",
"#z c #b0adac",
"#q c #bd5050",
".r c #c1cad6",
"#N c #c2cfe5",
"#j c #c3c1c0",
".4 c #c4b5be",
".K c #c5cdd8",
".J c #ccd3dd",
".j c #cce0ca",
".E c #cee1cd",
".H c #cfcdcc",
"#U c #d1daeb",
".Z c #d2d0cf",
"#t c #d3b9a5",
".F c #d4e5d3",
".o c #d5bedd",
"#F c #d6dfee",
".Y c #d7d4b6",
"#o c #d7d6d5",
".i c #dbe0e7",
".u c #dddbe0",
".N c #dddcdb",
"#k c #dfabab",
".# c #dfcee5",
".d c #dfcee6",
".v c #e1d4e7",
".e c #e1ede0",
"#T c #e2e8f3",
".P c #e3e2e1",
"#P c #e6bcbc",
"#w c #e7bfbf",
"#Q c #e8e8ed",
"#v c #e9c8c8",
".I c #ebeaea",
".7 c #ed1a0b",
"#d c #ed1b0e",
"#I c #f0d8d8",
"#x c #f1422a",
"#m c #f35f39",
".8 c #f67514",
"#y c #f78c3b",
"#n c #f89a53",
".G c #f9f9f9",
"#e c #fcceac",
"#J c #fcd8bd",
"#f c #fcfcfc",
"#s c #fddac0",
"#D c #fee8d8",
"Qt c #ffffff",
"QtQtQtQtQt.#.a.b.c.c.b.a.dQtQtQtQtQt",
"QtQtQt.e.f.c.g.g.g.g.g.g.c.h.iQtQtQt",
"QtQt.j.k.l.m.n.oQtQt.o.n.g.p.q.rQtQt",
"Qt.e.k.s.t.uQtQtQtQtQtQt.v.w.x.q.iQt",
"Qt.y.s.t.z.A.A.B.C.A.A.A.A.A.w.x.DQt",
".E.k.s.FQtQtQtQt.G.H.H.H.H.I.J.x.q.K",
".L.s.M.N.A.A.A.O.P.Q.R.R.S.TQt.U.x.V",
".W.X.YQt.Z.0.TQt.P.1.2.2.3.TQt.4.5.6",
".7.8QtQt.9.0.0.O.G.H.H.H.H.IQtQt#.##",
".7.8QtQt.Q.0.0.O.0#a#b#c.3#aQtQt#.##",
"#d.8#e#f.Q.0.0.O.0#g#h#i#j#aQt#k#.#l",
"#m.8#n#o#p.0.0.O.0#a#b#c.3#aQt#q#.#r",
"#s.7.8#t#u.0.TQt.0#g#h#i#j#a#v#.###w",
"Qt#x.8#yQt.B#zQt#A.2.2.2.2#g#B#.#CQt",
"Qt#D.7.8#E#FQtQtQtQtQtQt#F#G#H###IQt",
"QtQt#J#K#L#L#M#NQtQt#N#M#L#L#O#PQtQt",
"QtQtQt#Q#R#S#L#L#L#L#L#L#S#R#TQtQtQt",
"QtQtQtQtQt#U#V#W#S#S#W#V#UQtQtQtQtQt"};

static const char* const image191_data[] = { 
"18 18 95 2",
".U c #1c1c1c",
".2 c #6e6e6e",
"#l c #740100",
".# c #7f0000",
".E c #828282",
".6 c #949494",
"#A c #990500",
"#g c #994b4b",
"#w c #9b0000",
".K c #9c0000",
"#h c #9d9898",
"#z c #9e2a19",
".7 c #9f0000",
"#x c #a40500",
".z c #a60100",
".O c #aa0000",
".N c #af0100",
"#r c #b60000",
".c c #bb0000",
"#q c #bb0800",
"#v c #bc0800",
"#t c #c0c0c0",
".y c #c3c3c3",
"#m c #c4c4c4",
"#B c #c60000",
".C c #c70200",
".B c #c90400",
".b c #c96664",
"#p c #cb4e46",
"#c c #ccb9af",
"#u c #cdcdcd",
"#s c #ce0200",
".8 c #cf7b3e",
".h c #d14947",
".0 c #d2a19a",
".L c #d55b5a",
".o c #d6413c",
"#C c #d80400",
".J c #dadada",
".v c #db0500",
".T c #db8747",
".Z c #dbbb96",
".w c #dc0500",
".1 c #dc8646",
".n c #dfadab",
".M c #dfdfdf",
".g c #e0b1af",
".m c #e20500",
".x c #e3adab",
"#o c #e6e6e6",
".a c #e7b1af",
"#f c #e7e7e7",
".A c #e90500",
".D c #ead7d7",
".f c #eb1716",
"#k c #ececec",
"#e c #ededed",
".s c #ef100d",
".r c #ef1a18",
".q c #f02725",
"#y c #f11000",
".p c #f13333",
".u c #f30602",
".i c #f32d2c",
".5 c #f3b587",
"#j c #f3f3f3",
".H c #f3ffff",
".t c #f40a07",
".k c #f41310",
".j c #f4201d",
"#i c #f4f4f4",
".l c #f60906",
".e c #f64758",
".F c #f6ffff",
".9 c #f7c9a1",
".d c #f85867",
"#d c #fafafa",
"#n c #fdfdfd",
".I c #fdffff",
".G c #fefefe",
"## c #ff0f25",
"#a c #ff8e7f",
"#. c #ffb0a5",
".Q c #ffd0ae",
".R c #ffd2af",
".P c #ffddc3",
".S c #ffdec0",
".X c #ffe5ce",
".W c #ffe6cf",
"#b c #ffe7c3",
".Y c #ffe9cd",
".4 c #fff0d7",
".V c #fff2da",
".3 c #ffffe7",
"Qt c #ffffff",
"QtQtQtQtQtQt.#.#.#.#.#.aQtQtQtQtQtQt",
"QtQtQtQt.b.c.c.d.d.e.f.#.gQtQtQtQtQt",
"QtQtQt.h.c.d.d.i.j.k.l.m.#.nQtQtQtQt",
"QtQt.o.c.d.p.q.r.s.t.u.v.w.#.xQtQtQt",
"Qt.y.z.#.#.#.#.#.#.#.A.B.v.C.#.DQtQt",
".y.E.F.F.G.G.G.H.I.J.#.#.C.K.K.LQtQt",
".E.G.E.E.E.E.E.E.J.M.J.J.#.N.O.#QtQt",
".E.E.P.P.Q.R.R.S.E.E.E.y.J.#.K.#QtQt",
"Qt.T.P.U.V.W.X.U.Y.Z.0.E.y.J.K.#QtQt",
"Qt.1.P.2.3.4.4.2.Y.5.6.G.E.y.7.#QtQt",
"Qt.8.9#.###a#b#b.9.6.M.G#c.#.7.#QtQt",
".y.E.6######.6.6.6.G#d#e#f.#.##g#hQt",
".E#i#j#a###a.G.G.G.G.G#k#c.L#l#e.M#h",
".E#i.6.M.M.M.6.6.M.G#e.M.EQt.6.M#m#h",
".E.M.M#n.G.G#d.M.M#e#o.E#p.#Qt#h#hQt",
".E.M#e.G.G.G.G#e#e#f.E#q#r#s.#QtQtQt",
"#p.E#t#e#e#e#e#e#u.E#v#w#s#s#s.#QtQt",
".##x#y.E.E.E.E.E#z#A#B#x#C#s#s.#QtQt"};

static const char* const image192_data[] = { 
"18 18 134 2",
".w c #2b221a",
".u c #2b231a",
"#y c #522901",
"#Z c #684624",
"#3 c #747474",
"aa c #757575",
"#t c #767676",
"ac c #777777",
".a c #783c02",
"#0 c #785a3c",
".j c #7a4008",
".t c #808080",
".v c #828282",
".9 c #870000",
"#Y c #876e55",
".8 c #880000",
".M c #8c8c8c",
".P c #8d1111",
"#W c #8d8d8d",
"#z c #8e745a",
".7 c #900000",
"#5 c #909090",
".W c #921e1e",
".i c #926233",
".Z c #929292",
".1 c #939393",
"#. c #940707",
".X c #950000",
".h c #966333",
"#x c #967d65",
".g c #976434",
".f c #996636",
".r c #999999",
".6 c #9b0000",
".Q c #9c4b4b",
".e c #9d6a3a",
"ab c #9d9d9d",
".V c #9f5454",
".l c #9f9f9f",
".x c #a0a0a0",
"## c #a41212",
".O c #a42626",
".y c #a4a4a4",
"#a c #a60000",
".5 c #a70000",
".d c #a77342",
".q c #a9a9a9",
".c c #ac7845",
".n c #acacac",
".I c #b06262",
".E c #b19494",
".0 c #b3b3b3",
".H c #b5a2a2",
"#4 c #b7b7b7",
".R c #b88989",
".L c #b8b8b8",
".m c #b9b9b9",
"#j c #ba0c0c",
"ad c #bababa",
"#i c #bb0b0b",
".U c #bb9292",
".p c #c0c0c0",
"#H c #c12323",
"#m c #c22a2a",
"a# c #c2c2c2",
".D c #c38f8f",
"#l c #c42b2b",
"#V c #c4c4c4",
"#k c #c52d2d",
"#h c #c52f2f",
"#q c #c53333",
"#b c #c53838",
"#I c #c63b3b",
"#2 c #c6c6c6",
"#M c #c7c7c7",
"#r c #c94242",
".2 c #cccccc",
".4 c #cd5454",
".b c #ceb094",
"#d c #cecece",
".k c #cfcfcf",
"#S c #d16a6a",
".S c #d1bcbc",
".T c #d3c1c1",
".B c #d3d3d3",
"#g c #d46464",
".J c #d4abab",
".# c #d6c4b3",
"#T c #d79d9d",
".s c #d8d8d8",
".N c #d9bfbf",
"#G c #d9cbc1",
"#X c #dadada",
"#L c #dbdbdb",
"#N c #dcdcdc",
".Y c #dda0a0",
"#1 c #dddad9",
"#U c #dddddd",
"#9 c #dedede",
"#R c #dfd6d0",
".F c #dfdfdf",
"#F c #e0e0e0",
"#K c #e1e1e1",
"#8 c #e2e2e2",
"#6 c #e4e4e4",
"#f c #e6a7a7",
"#7 c #e6e6e6",
"#A c #e8d5ce",
"#O c #e8e8e8",
"a. c #e9e9e9",
"#J c #eadbdb",
"#E c #eaeaea",
".C c #ebe3e3",
"#D c #ebebeb",
"#p c #edcbc9",
".K c #edebeb",
"#Q c #efedea",
".z c #f2f2f2",
"#P c #f3f3f3",
"#n c #f4d7d7",
"#C c #f4f4f4",
"#c c #f5dbdb",
"#v c #f6f6f6",
".3 c #f7e2e2",
"#u c #f7f7f7",
"#B c #f8e9e9",
".G c #f8f8f8",
"#s c #f9ebeb",
"#e c #fbf0f0",
".o c #fbfbfb",
"#w c #fcfcfc",
"#o c #fdfdfd",
".A c #fefefe",
"Qt c #ffffff",
"QtQtQtQtQt.#.a.a.a.a.a.a.#QtQtQtQtQt",
"QtQtQtQt.b.c.c.c.c.c.c.d.a.#QtQtQtQt",
"QtQtQtQt.#.e.f.g.h.h.g.f.a.#QtQtQtQt",
"QtQtQt.i.j.a.a.a.a.a.a.a.a.a.iQtQtQt",
"QtQtQtQt.k.l.m.n.o.o.p.q.l.kQtQtQtQt",
"QtQtQtQt.r.s.t.uQtQt.v.w.s.rQtQtQtQt",
"QtQtQtQt.x.y.z.AQtQt.A.z.B.xQtQtQtQt",
"QtQtQt.C.D.E.F.z.G.G.z.F.H.I.J.KQtQt",
"Qt.L.M.N.O.P.Q.R.S.T.U.V.W.X.Y.Z.0Qt",
"Qt.1.2.3.4.5.6.7.8.9#.###a#b#c#d.1Qt",
"Qt.ZQtQt#e#f#g#h#i#j#k#l#m#nQtQt.ZQt",
"Qt.Z.A#o.AQtQtQtQtQt#p#q#r#s.A#o#tQt",
"Qt.Z#u#v#w.AQt#x#y#z#A#k#r#B#C#D#tQt",
"Qt.Z#E#F.z#o.AQtQtQt#G#H#I#J#K#L#tQt",
"Qt.1#M.F#N#O#P#u#Q.G#R#S#T#U#N#V#tQt",
"Qt.L#W.l#F#X#X#Y#Z#0#1#N#X#U#2#3#4Qt",
"QtQt.G#5.r#6#7#8.F#9.F#8a.a#aa#4QtQt",
"QtQtQtQtab#t#t#t#t#t#t#t#tacadQtQtQt"};

static const char* const image193_data[] = { 
"18 18 118 2",
".c c #9e8139",
"#I c #ac8a2e",
".S c #ac8b31",
"#A c #ac8b32",
".l c #ac8c38",
".I c #ac8e3e",
".e c #ac8e41",
".b c #b1995f",
"#Q c #c19d32",
"#R c #c19e36",
"#J c #c19e38",
".H c #c1a03e",
".w c #c1a142",
".x c #c1a657",
".n c #c1a659",
".m c #c8b68d",
"#z c #cba635",
"#W c #cba735",
".2 c #cba83c",
"#u c #cbaa45",
".k c #cbae54",
".T c #cbb05b",
".f c #cbb265",
".a c #cbbb94",
".d c #d3c5a5",
"#Z c #e5be3a",
"#X c #e5be3b",
"#t c #e5bf3c",
".9 c #e5c144",
"#m c #e5c65c",
".3 c #e5cb72",
".j c #e5cb74",
".g c #e5d086",
".# c #eae3d4",
"#H c #eec63c",
"#S c #eec846",
"#B c #eecb54",
".R c #eecc56",
".v c #eed16c",
".J c #eeda8d",
".o c #eedc97",
"#Y c #f8ce3e",
"#l c #f8d045",
"#e c #f8d049",
"#f c #f8db73",
"#. c #f8de7d",
".i c #f8e391",
".h c #f8e599",
"#P c #f9d03e",
"#K c #f9d653",
".G c #f9db6b",
".y c #f9e9a5",
"#V c #ffd542",
"#y c #ffd746",
"#G c #ffd747",
"#U c #ffd84b",
"#O c #ffd84e",
"#s c #ffd94d",
"#T c #ffd94e",
"#x c #ffd952",
"#F c #ffda52",
"#k c #ffda55",
"#N c #ffdb55",
"#d c #ffdc5b",
"#r c #ffdc5c",
".8 c #ffdc5f",
"#L c #ffdd5f",
"#M c #ffdd60",
".1 c #ffdd61",
"#j c #ffde66",
"#C c #ffdf66",
"#q c #ffe06d",
"#E c #ffe06e",
"#c c #ffe16e",
".Q c #ffe273",
".7 c #ffe274",
"#D c #ffe275",
".0 c #ffe276",
"#i c #ffe379",
"#w c #ffe37a",
"#p c #ffe47d",
"#n c #ffe47e",
".F c #ffe583",
".P c #ffe78a",
"#h c #ffe78d",
"#v c #ffe88a",
".Z c #ffe88c",
".u c #ffe88d",
"## c #ffea99",
"#o c #ffeb98",
".E c #ffeb99",
".t c #ffec9e",
".6 c #ffeca0",
".O c #ffeca1",
".4 c #ffeda1",
".U c #ffeda3",
".Y c #ffeda4",
".D c #ffefac",
"#g c #ffefad",
".s c #fff0ad",
".p c #fff2b6",
".r c #fff2b7",
".q c #fff3ba",
".V c #fff3bb",
".z c #fff3be",
"#a c #fff4be",
".C c #fff4bf",
"#b c #fff6ca",
".A c #fff7ca",
".K c #fff7cb",
".B c #fff8cf",
".5 c #fffad9",
".N c #fffbd9",
".L c #fffbda",
".X c #fffcdf",
".M c #fffce0",
".W c #ffffec",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQt.#.a.b.c.c.b.a.#QtQtQtQtQt",
"QtQtQtQt.d.e.f.g.h.i.j.k.l.dQtQtQtQt",
"QtQtQt.m.n.o.p.q.r.s.t.u.v.w.mQtQtQt",
"QtQt.d.x.y.z.A.B.A.C.D.E.F.G.H.dQtQt",
"Qt.#.I.J.p.K.L.M.N.K.r.O.P.Q.R.S.#Qt",
"Qt.a.T.U.V.B.M.W.X.B.V.Y.Z.0.1.2.aQt",
"Qt.b.3.4.r.A.N.M.5.K.r.6.P.7.8.9.bQt",
"Qt.c#.##.s#a#b.B#b#a.s.E.F#c#d#e.cQt",
"Qt.c#f.u.t.s.r.q.p#g.t#h#i#j#k#l.cQt",
"Qt.b#m#n.Z#o.4.Y.O#o.Z#p#q#r#s#t.bQt",
"Qt.a#u#q#i.F.P.u#v.F#w#q.8#x#y#z.aQt",
"Qt.##A#B#C#c.Q#D.7#E#C#r#F#G#H#I.#Qt",
"QtQt.d#J#K#d#L#M#L#d#N#O#y#P#Q.dQtQt",
"QtQtQt.m#R#S#T#T#T#U#G#V#H#Q.mQtQtQt",
"QtQtQtQt.d#I#W#X#Y#Y#Z#z#I.dQtQtQtQt",
"QtQtQtQtQt.#.a.b.c.c.b.a.#QtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image194_data[] = { 
"18 18 201 2",
"aV c #2c7b02",
"aJ c #316100",
"a5 c #318803",
"a1 c #327d03",
"#W c #359c01",
"ba c #378b04",
"aU c #397e03",
"#J c #39a907",
"#2 c #3a8a00",
"#x c #3e9c0e",
"#4 c #3ea207",
"#V c #3eaf03",
"#U c #3f9f07",
"#K c #3fb103",
"ad c #41980f",
".c c #43762b",
"#3 c #43b105",
"a4 c #458524",
"a6 c #477804",
"bb c #488525",
"bg c #498022",
".n c #4a8030",
"#5 c #4c910f",
".b c #578540",
".C c #588841",
"#g c #5a5c20",
"aq c #5a7822",
"bc c #5b6d22",
"ac c #5c9e05",
"aP c #5d4700",
"aT c #5e5d02",
"#L c #607d01",
"aO c #624500",
"a0 c #644a01",
"#X c #645b00",
"#i c #656e22",
"aA c #664401",
"b# c #665d03",
"aj c #66a149",
".m c #675c21",
"ae c #676922",
"#I c #68700e",
".i c #6b8015",
"#6 c #6b8903",
"aS c #6c6d27",
".o c #6c9557",
"aF c #6e5923",
"aK c #6f3c00",
"aR c #6f5923",
"a2 c #714902",
"#0 c #738738",
"aI c #743e01",
"a3 c #755f27",
".Q c #765923",
".p c #77913d",
"#w c #784717",
".h c #78a449",
"aW c #793501",
"#Y c #797932",
".d c #799f67",
".a c #7ba069",
"#N c #7e7632",
".g c #7e9c53",
"aw c #7f4f15",
"#T c #7f6102",
".P c #81902a",
"av c #843301",
".f c #869e57",
"ay c #887233",
"ax c #897032",
"#1 c #8a4900",
"#Q c #8b5313",
"bf c #8c2c0d",
"#C c #8cb876",
"#S c #8e4900",
"bd c #8f260d",
"#D c #8f682b",
"al c #90ba7b",
".l c #92230d",
"ab c #934f00",
"#7 c #945a01",
"#o c #946825",
".A c #959a37",
"a. c #97bf84",
"#n c #995609",
"a7 c #9b1e01",
"#M c #9b3f00",
"#r c #9c6a20",
"be c #9d0b04",
"#B c #9d3708",
"#R c #9f3d00",
"az c #a03f16",
"#p c #a0622e",
"#E c #a54307",
"#y c #a54f01",
"a8 c #a60000",
"#A c #a62800",
"#k c #a62a00",
"#H c #a74200",
"a9 c #a80000",
"aG c #a80100",
"aH c #a80c00",
"#q c #a87748",
"aB c #a91e00",
"aQ c #aa0400",
"as c #ab0000",
"#s c #ab6a0d",
"ar c #ac0000",
"b. c #ad0800",
".5 c #ae4400",
".k c #af0b04",
"#l c #b04d00",
"a# c #b33c1b",
"#m c #b45a00",
"#8 c #b62100",
"#a c #b6620a",
".D c #b69532",
"aE c #b70000",
"#9 c #b73115",
"at c #b80000",
"ap c #b91f01",
"#. c #b95a00",
".W c #b96305",
".Y c #b96814",
"aX c #ba0100",
".3 c #ba9511",
"aZ c #bb0a00",
".j c #bb1d04",
"af c #bd1600",
"aD c #be0000",
"au c #be0c00",
"aC c #bf0000",
"aY c #c10000",
"aN c #c10f00",
"ag c #c30500",
"#z c #c40f00",
"ao c #c50400",
".4 c #c60000",
"#j c #c70400",
"aa c #c91e00",
"#h c #cbdfc1",
".x c #ccb46c",
"ah c #ce0100",
"#O c #d0e2c8",
"ak c #d3e4cb",
"aL c #d40200",
"am c #d40801",
".w c #d42f13",
"an c #d50000",
"#P c #d6e6ce",
".q c #d8ca6d",
".z c #d8cb6d",
".e c #d8dfd4",
"ai c #d90101",
"aM c #da0000",
"#Z c #ddead7",
".v c #e00d01",
".R c #e56511",
".8 c #e68702",
"#c c #e68d16",
".y c #e7e8a1",
".7 c #ea9105",
"#b c #ea981d",
".u c #eb6816",
".O c #ecc841",
"#f c #ef9001",
".T c #efa833",
"#d c #f1a821",
".9 c #f3a403",
"#F c #f57b01",
"#G c #f59601",
".U c #f5ba40",
"#u c #f7ad03",
".t c #f8dc70",
".# c #f9fbf8",
"#t c #fbba0e",
".6 c #fdbf0d",
"#e c #fdc010",
".V c #fdcb35",
".S c #fdcd3d",
"## c #ff7f01",
".X c #ffab0d",
"#v c #ffc001",
".I c #ffc71e",
".2 c #ffce31",
".K c #ffd153",
".J c #ffdb19",
".1 c #ffdb5d",
".H c #ffdc61",
".E c #ffdf6b",
".0 c #ffe379",
".Z c #ffe37a",
".N c #ffe47c",
".G c #ffe88a",
".F c #ffe98f",
".M c #fff0a8",
".L c #fff0a9",
".s c #fff3b0",
".r c #fff6ba",
".B c #fffcf2",
"Qt c #ffffff",
"QtQtQtQt.#Qt.a.b.c.c.b.d.eQtQtQtQtQt",
"QtQtQtQt.f.g.h.i.j.k.l.m.n.oQtQtQtQt",
"QtQtQt.p.q.r.s.t.u.v.w.x.y.z.A.BQtQt",
"QtQt.C.D.E.F.G.H.I.J.K.L.M.N.O.PQtQt",
".#.o.Q.R.S.T.U.V.W.X.Y.Z.0.1.2.3.oQt",
"Qt.n.4.5.6.7.8.9#.###a#b#c#d#e#f#g#h",
".d#i#j#k#l#m#n#o#p#q#r#s#t#u#v#m#w.d",
".b#x#y#z#A#B#CQtQtQtQt#D#E#F#G#H#I.b",
".c#J#K#L#M#N#OQtQtQtQt#P#Q#R#S#T#U.c",
".c#J#V#W#X#Y#OQtQtQtQt#Z#0#1#2#3#4.c",
".b#5#6#7#8#9#CQtQtQtQta.a#aaabacad.b",
".daeafagahaiaj#C#Oakalajamanaoapaq.d",
"Qt.narasatauavawaxayazaAaBaCaDaE.nQt",
".#.oaFaGaHaIaJaKaLaMaNaOaPaQaraR.o.#",
"QtQt.CaSaTaUaVaWaXaYaZa0a1a2a3.CQtQt",
"QtQtQt.Ca4a5a6a7a8a9b.b#babb.CQtQtQt",
"QtQtQtQt.o.nbcbdbebebfbg.n.oQtQtQtQt",
"QtQtQtQt.#Qt.d.b.c.c.b.dQt.#QtQtQtQt"};

static const char* const image195_data[] = { 
"18 18 44 1",
"F c #125411",
"k c #1c1c1c",
"J c #6ab138",
"# c #774517",
"b c #7b491b",
"B c #7d4b1d",
"x c #7e4c1d",
"j c #7f4c1e",
"P c #824f21",
"v c #835022",
"z c #835223",
"e c #855223",
"s c #855324",
"g c #865325",
"c c #8b5217",
"C c #926237",
"O c #9a6a39",
"f c #a26e3d",
"p c #a93820",
"A c #b19068",
"o c #bb0028",
"y c #bb6124",
"E c #bb6326",
"a c #bb751d",
"N c #be9872",
"d c #cccccc",
"i c #d29c67",
"r c #d68819",
"K c #dac6b2",
"G c #dcc9b7",
"L c #ebab5c",
"q c #eea659",
"D c #f0ad5c",
"H c #f2af5c",
"l c #f39d0f",
"M c #f3ae5a",
"I c #f5bb83",
"m c #f5bc83",
"n c #f7b25c",
"w c #f88264",
"t c #f97fa6",
"u c #ff0f25",
"h c #ffffd9",
". c #ffffff",
"...##..........#..",
"..#a#.#.....#.#a#.",
"..#aa#a#...#a##a#b",
"..#caaa#d..###acc#",
"...#cac#d...#acc##",
"...##c#effg#acc##d",
"....##ahhhijcc##d.",
".....akhlkmnj#dd..",
"...oopkqlkmnrsd...",
"..otuoqqqqmnrvd...",
".aouuommqqmlrvd...",
"ahwoowmmmmnlrxd...",
"vnmynmmmmmllrxd...",
"zAmymmAmmmlrBd....",
"CDEmyymmnlrrBFd...",
"GCHmImmlllrBJFxd..",
".KCLMlllrBBJFllxd.",
"..KNOPBBBFFFrrrxd."};

static const char* const image196_data[] = { 
"18 18 236 2",
".a c #620000",
".b c #8f2628",
"bt c #8f3601",
"a2 c #8f3701",
"aF c #903801",
"aO c #903802",
"bf c #903901",
"bv c #913b00",
"bM c #913c00",
"aK c #923b02",
"bL c #923c00",
"be c #923c02",
"a0 c #943d02",
"bN c #964204",
".i c #970100",
"bO c #974306",
"bu c #984203",
".U c #991017",
".p c #991518",
".q c #9a1219",
".7 c #9b1218",
".F c #9b121a",
"bd c #9b3f03",
"aI c #9b4306",
".E c #9c111b",
"aJ c #9c4103",
"aG c #9c4204",
"aH c #9c4407",
".h c #9d0303",
".s c #9d121c",
".R c #9d131d",
"aZ c #9d4203",
"aN c #9e470a",
"bI c #9f5015",
".# c #a11c21",
"a1 c #a14a0f",
"bJ c #a3561b",
"bP c #a6581d",
".T c #ac3338",
"aD c #ac4f03",
"ah c #ac5003",
"#8 c #ac5104",
"#V c #ac5204",
"bK c #ad5e15",
"#6 c #b15809",
".r c #bb2e3a",
".8 c #bc4246",
".o c #bc484b",
".9 c #bd4d51",
".g c #be0a0b",
".S c #be4e51",
"#q c #c13846",
"#F c #c13a47",
"#T c #c13c45",
"#G c #c13d44",
"#. c #c4434d",
".A c #c50404",
"#p c #c9525b",
".e c #ce4c57",
".B c #d00f11",
"#f c #d0612e",
".l c #d0843f",
"#i c #d14126",
"#h c #d4b14d",
".x c #d61418",
"bc c #d65610",
"bb c #d75810",
"aQ c #d75811",
"bH c #d86f06",
".j c #d95046",
".3 c #da1118",
"aY c #db5d14",
"#A c #de843a",
".4 c #df1214",
"a5 c #df670c",
"#g c #e0c352",
"bs c #e1680c",
"a4 c #e1690c",
"aP c #e16912",
"#e c #e2201e",
"br c #e26a0b",
"a3 c #e26b0b",
".1 c #e31724",
".z c #e62834",
"aR c #e6924f",
"#v c #e6af3f",
".c c #e6b6bb",
".0 c #e73830",
"bq c #e77d16",
"aX c #e7994c",
".Z c #e81b22",
".f c #e8232e",
"#z c #e8c850",
".5 c #e91a1d",
"#u c #e94e29",
"#j c #ea1924",
".V c #ea1a1e",
"bk c #ea7908",
"a6 c #ea8e33",
".2 c #eb1426",
"bj c #eb7c08",
"ba c #eba246",
".N c #ec0f1b",
"#B c #ec3128",
"bi c #ec7e07",
".w c #ed1c25",
".K c #ee2e36",
"bh c #ee7f07",
"bG c #ee8007",
"bg c #ee8107",
"#Q c #eebd3c",
"bF c #ef8207",
"bE c #f08b0b",
".J c #f21230",
".6 c #f22125",
".C c #f24f5c",
".Y c #f31f2e",
"#t c #f32c33",
".M c #f34a60",
"aL c #f3b670",
".W c #f42e39",
"bA c #f48d04",
"#R c #f56e33",
"bz c #f68e04",
"by c #f69104",
"#o c #f7213a",
"#d c #f73141",
"#C c #f73b46",
".v c #f7526c",
"bx c #f79303",
".n c #f7c7af",
"## c #f81e38",
"bw c #f89502",
"bB c #f8b32e",
"bD c #f8b734",
".X c #fa2b3a",
"#I c #fa9f36",
"bC c #fabf3e",
"#w c #fad750",
"#S c #fb3435",
"#n c #fb3e53",
"#s c #fb4055",
"bl c #fbdd81",
"#a c #fc3950",
"#P c #fcd047",
"#J c #fcd13e",
"#y c #fcdb58",
"#r c #fd254a",
"#E c #fd2e52",
"#k c #fd374e",
"#H c #fd502f",
"#D c #fd536a",
"#m c #fd5565",
".I c #fd5588",
".D c #fd729a",
".Q c #fd8ba6",
".u c #fdb6ca",
".m c #fdd2af",
".L c #fe96bb",
"bp c #feeb87",
".O c #ff2845",
"#l c #ff4c5e",
"#c c #ff586d",
".y c #ff6485",
"#b c #ff687a",
".k c #ff7a62",
".t c #ff85a4",
".P c #ffa3bd",
"aC c #ffa921",
"aB c #ffae24",
"at c #ffb021",
"az c #ffb222",
"aA c #ffb226",
"ay c #ffb321",
"ax c #ffb422",
"au c #ffb426",
"ar c #ffb52d",
"aw c #ffb726",
"av c #ffb828",
"ai c #ffba2a",
".H c #ffbad4",
"aq c #ffbb32",
".G c #ffbdd3",
"af c #ffbe35",
"ap c #ffbf33",
"an c #ffc02c",
"ao c #ffc031",
"aj c #ffc133",
"#5 c #ffc137",
"am c #ffc22e",
"ae c #ffc237",
"#9 c #ffc433",
"al c #ffc434",
"ak c #ffc436",
"ad c #ffc639",
"#4 c #ffc73a",
"ac c #ffc83a",
"#W c #ffc936",
"a. c #ffc939",
"ab c #ffcb3a",
"a# c #ffcb3b",
"#3 c #ffcb3e",
"aa c #ffcc3a",
"#X c #ffce3c",
"#2 c #ffcf41",
"#Y c #ffd13e",
"#Z c #ffd340",
"#1 c #ffd343",
"#0 c #ffd441",
"aE c #ffd59a",
"#K c #ffd744",
"#O c #ffd74e",
"#L c #ffd949",
"#M c #ffda4e",
"#N c #ffda4f",
"#x c #ffdc57",
"aV c #fff2cd",
"aS c #fff2d9",
"aU c #fff2e5",
"aT c #fff2eb",
"bo c #fff3a2",
"b# c #fff3a5",
"bn c #fff3ac",
"bm c #fff3ad",
"aW c #fff3b3",
"b. c #fff3bb",
"a7 c #fff3c3",
"a9 c #fff3c9",
"a8 c #fff3cd",
"aM c #fff8f0",
"#7 c #fffdf7",
"ag c #fffef8",
"as c #fffefc",
"#U c #fffffd",
".d c #fffffe",
"Qt c #ffffff",
"QtQtQt.#.a.b.cQtQt.dQtQtQtQtQtQtQtQt",
"QtQt.e.f.g.h.i.j.k.l.m.n.o.p.q.rQtQt",
"QtQt.s.t.u.v.w.x.y.y.z.A.B.C.D.EQtQt",
"QtQt.F.G.H.I.J.K.L.L.M.N.O.P.Q.RQtQt",
".S.T.U.V.W.X.Y.Z.0.1.2.3.4.5.6.7.8.9",
"#.###a#b#c#d#e#f#g#h#i#j#k#l#m#n#o#p",
"Qt#q#r#s#t#u#v#w#x#y#z#A#B#C#D#E#FQt",
"QtQt#G#H#I#J#K#L#M#N#O#P#Q#R#S#T.dQt",
"QtQt#U#V#W#X#Y#Z#0#1#2#3#4#5#6#7.dQt",
"QtQt#U#8#9a.a#aaaaabacadaeaf#8ag.dQt",
"QtQt.dahaiajakalamanaoapaqarahas.dQt",
"QtQtQtahatauavawaxayazaAaBaCaD.dQtQt",
"QtQtaEaFaGaGaGaHaHaHaIaGaGaJaKaLQtQt",
"QtaMaNaOaPaQaRaSaTaUaVaWaXaYaZa0QtQt",
"Qta1a2a3a4a5a6a7a8a9b.b#babbbcbdbeQt",
"Qtbfbgbhbibjbkblbmbnbobpbqa3brbsbtQt",
"QtbubvbwbxbybzbAbBbCbDbEbFbGbHaFaFQt",
"QtQtbIbJbKbLbLbLbLbLbMbvbvbNbObPQtQt"};

static const char* const image197_data[] = { 
"18 18 112 2",
".1 c #004200",
"#T c #004900",
"#n c #005cff",
".Z c #014a01",
".T c #024b01",
".R c #024b02",
"#l c #034c00",
".y c #054800",
"#i c #054e00",
".P c #085007",
".L c #094707",
".q c #095202",
"#t c #0a4c03",
".2 c #0e5407",
".G c #104a10",
"#p c #105809",
".9 c #125411",
".l c #144914",
".z c #14590c",
"#r c #145d0d",
"#B c #164c16",
"#I c #164e16",
".F c #1d5a1e",
"#h c #285c28",
"#m c #285f28",
".o c #28642b",
"#N c #297200",
".X c #2a602a",
"#. c #2b5c2b",
"#A c #2b6420",
"#O c #2c3f00",
".4 c #2f632d",
"#M c #304600",
"#u c #317128",
"#j c #339f8a",
".N c #346534",
"#z c #357b11",
".f c #357c11",
"#L c #367b18",
"#f c #386338",
".W c #396939",
".c c #3e8a15",
".a c #3e8a19",
".8 c #40851c",
"#Q c #427842",
".E c #438c14",
".m c #447244",
".A c #456e45",
".K c #458d17",
".x c #458e14",
".M c #467b46",
"#P c #478614",
".b c #478e26",
".s c #488f1b",
"#e c #489216",
"#F c #48992a",
"#J c #497d49",
".V c #4b9418",
".k c #529c1b",
".0 c #59a21d",
"#D c #59ac2c",
".t c #5a7e5a",
".Y c #5aa120",
"#H c #5aa31b",
".S c #5ba41e",
"#K c #5c875c",
"## c #5dab2a",
"#s c #5ea71e",
".J c #5ea71f",
"#g c #5f8d5f",
".U c #61aa20",
"#k c #62a934",
"#C c #63aa2e",
".r c #65af21",
"#y c #67b122",
".n c #68ac38",
"#o c #68b029",
"#c c #6ab138",
"#q c #6ab229",
"#b c #6ab238",
".D c #6bb139",
".5 c #6cb338",
".O c #71b93c",
"#G c #72bb36",
"#x c #73ba3b",
".w c #742d02",
"#v c #75c9d3",
".v c #76bd3d",
".Q c #78bf40",
".I c #79c041",
".7 c #7ac142",
"#a c #7cc146",
".e c #7fc745",
"#R c #804900",
"#w c #81c83f",
".p c #83cb44",
".u c #843612",
".6 c #86c94e",
"#S c #89653b",
".i c #93cb67",
".3 c #9db787",
".g c #9db99d",
".# c #a3bc92",
"#E c #aed48f",
".H c #b87026",
".d c #bee0a0",
".h c #c2e3a5",
"#d c #fbcc49",
".B c #ff0000",
".j c #ff6699",
".C c #fff8ae",
"Qt c #ffffff",
"QtQtQtQtQtQtQtQt.#.#QtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQt.#.a.b.#QtQtQtQtQtQtQt",
"QtQtQtQtQtQt.#.c.d.e.f.#QtQtQtQtQtQt",
"QtQtQtQtQt.g.c.h.i.j.k.l.gQtQtQtQtQt",
"QtQtQtQtQt.m.n.o.p.q.r.s.tQtQtQtQtQt",
"QtQtQtQtQtQt.u.v.w.x.y.zQtQtQtQtQtQt",
"QtQtQtQt.g.A.h.B.C.v.D.E.F.#QtQtQtQt",
"QtQtQt.g.G.h.v.v.H.I.J.C.K.L.#QtQtQt",
"QtQtQt.M.N.O.P.Q.R.S.T.U.V.W.MQtQtQt",
"QtQtQtQtQt.X.Y.T.S.Z.0.1.2QtQtQtQtQt",
"QtQtQt.3.4.5.d.6.7.j.0.8.0.9.3QtQtQt",
"QtQt.3#.##.d#a#b.I#c.8.8#d#e#f.3QtQt",
"QtQt#g#h###i#j#i#k#l.0.8.0.8#m#gQtQt",
"QtQtQtQt#i#n.C#o#p#q#r#s#t#iQtQtQtQt",
"QtQt.g#u.d#v#v.j#w#x.C.B#y#z#A.gQtQt",
"Qt.g#B#C#D#E#F#G#H#H#H#z#z.j#z#I.gQt",
"Qt#J#K#L#M#N#O#G#H#G#z#z#z#P#z#K#IQt",
"QtQt#K#Q#R#z#S#z#S#T#S#z#S#S#S#IQtQt"};

static const char* const image198_data[] = { 
"18 18 110 2",
".O c #7f001b",
".a c #828282",
"#O c #83051f",
".d c #838382",
".r c #848485",
".N c #86021d",
".H c #870521",
".F c #877d7d",
".B c #887d7d",
"#P c #8a0d28",
"#M c #8b0b23",
"#H c #8b0b25",
".z c #8b8788",
"#i c #8d0c28",
".l c #8d8584",
".C c #8e8181",
".E c #92807f",
".t c #928889",
".G c #943836",
".A c #953738",
".D c #957f7e",
"#Q c #991f38",
"#z c #9c1934",
".# c #a0a0a0",
"#R c #a93c53",
"#q c #ba0d34",
".U c #bb0028",
"#L c #be042b",
"#K c #bf022a",
"#y c #bf042a",
"#h c #c0022a",
".L c #c01136",
"#G c #c1032c",
".K c #c11538",
".M c #c2042c",
".s c #c3bfbf",
".c c #c3c3c3",
"#J c #c5022b",
"## c #c60028",
".Y c #c66679",
"#N c #c66a7a",
".S c #c70028",
".J c #c7082e",
".Z c #c96478",
"#g c #ca032b",
"#F c #cb012a",
"#. c #cc012a",
".k c #cccccc",
"#x c #cd032c",
"#p c #ce042c",
".v c #d6d5d6",
".u c #dcdbd9",
".w c #dddddd",
"#f c #de0532",
"#E c #df0330",
".x c #e1e2e2",
".y c #e2e3e2",
".m c #e2e5e5",
"#w c #e30533",
".q c #e3e4e4",
".n c #e4e5e5",
"#a c #e68f9b",
".p c #e6e7e7",
".j c #e7e7e7",
".o c #e8e9e9",
"#o c #eb0834",
"#I c #ec0635",
".T c #eca7b1",
".9 c #ed0634",
"#D c #ef0532",
"#e c #f11440",
"#n c #f20d3a",
"#v c #f30836",
"#C c #f40836",
".8 c #f42a54",
".4 c #f50637",
"#u c #f50b38",
"#d c #f51f4b",
"#k c #f53058",
".R c #f60637",
"#B c #f60c39",
"#A c #f6123f",
"#t c #f6133f",
"#m c #f61441",
"#s c #f61a47",
"#l c #f61c49",
"#c c #f62855",
".3 c #f62d59",
"#b c #f6315b",
".7 c #f63a63",
".g c #f6f7f6",
".2 c #f73b65",
".6 c #f73c65",
".X c #f7426c",
".1 c #f7466e",
".W c #f7587d",
".P c #f76488",
".I c #f7678b",
"#r c #f84f7b",
".Q c #f8537b",
"#j c #f8638e",
".5 c #f86e97",
".0 c #f9779f",
".V c #f97fa6",
".h c #fafafa",
".f c #fafafb",
".i c #fbfbfb",
".b c #fcfcfc",
".e c #fefefe",
"Qt c #ffffff",
"QtQtQtQtQtQtQt.#.#.#.#.#.#.aQtQtQtQt",
"QtQtQtQtQtQt.#.b.c.d.a.a.c.e.aQtQtQt",
"QtQtQtQtQtQt.#.b.f.g.h.i.e.j.a.kQtQt",
"QtQtQtQtQtQt.l.m.n.o.p.n.n.q.r.kQtQt",
"QtQtQtQtQtQt.s.t.u.v.w.x.y.z.k.kQtQt",
"QtQtQtQtQtQtQt.A.B.C.D.E.F.G.kQtQtQt",
"QtQtQtQtQtQtQt.H.I.J.K.L.M.N.kQtQtQt",
"QtQtQtQtQtQtQt.O.I.P.Q.R.S.O.kQtQtQt",
"QtQtQtQtQtQt.T.U.V.W.X.R.S.O.Y.kQtQt",
"QtQtQtQt.T.Z.U.0.1.2.3.4.S.S.O.kQtQt",
"QtQtQt.T.U.U.5.6.7.8.9#..S##.O.kQtQt",
"QtQt#a.U.5.6#b#c#d#e#f#g#h#i.O.kQtQt",
"QtQt.U#j#b#k#l#m#n#o#p#q.O.O.kQtQtQt",
"QtQt.U#r#s#t#u#v#w#x#y#z.Y.kQtQtQtQt",
"QtQt.U#A#B#C#D#E#F#G#H.Y.kQtQtQtQtQt",
"QtQt.Z.U.R#I#J#K#L#M#N.kQtQtQtQtQtQt",
"QtQtQt.Z.U#O#P#Q#R.k.kQtQtQtQtQtQtQt",
"QtQtQtQt.k.k.k.k.k.kQtQtQtQtQtQtQtQt"};

static const char* const image199_data[] = { 
"18 18 3 1",
"# c #a70909",
"a c #ff0016",
". c #ffffff",
".....####.........",
"...###aa###.......",
"..##aaaa..##......",
".##..aaa...##.....",
".#...####aaa#.....",
".#a.##..##aa#.....",
".#aa#....#aa#.....",
"..##.....#.a#.....",
".........#..#.....",
".........#..#.....",
".........#a.#.....",
".........#aa#.....",
".........#aa#.....",
".........#.a#.....",
".........#..#.....",
".........#a.#.....",
".........#aa#.....",
"..........##......"};

static const char* const image200_data[] = { 
"18 18 9 1",
"e c #000000",
"# c #8d0303",
"c c #cbcbcb",
"d c #d4d4d4",
"b c #f12626",
"f c #fd9696",
"a c #fe4242",
"g c #fec8c8",
". c #ffffff",
"...###.....###....",
"..#aaa#####aaa#...",
".#baaa#bbb#aaaa#..",
"#bbaaaa###aaaaab#.",
"#bbaaaaaaaaaaaab#c",
"#b#baaaaaaaaaa#b#c",
"#b#badedededab#b#c",
"#b#baedededeab#b#c",
"###baaaaaaaaab###c",
"..#baaaaaaafbb#cc.",
"..#baaaaaafbbb#c..",
"..#baaaaaafbgb#c..",
"..#baaaaaagbgb#c..",
"..#baaaaaaagb.#c..",
"..#bbaaaaab.bb#c..",
"..#bbbbbbbbb.b#c..",
"...###########c...",
"....cccccccccc...."};

static const char* const image201_data[] = { 
"18 18 128 2",
"#X c #006eb4",
"#5 c #006fbb",
"#0 c #0075c8",
"#1 c #0081de",
"#Z c #0083e3",
"#U c #008bef",
"#K c #008ff3",
"#Y c #0093fa",
"#C c #009afd",
"#D c #00a2fe",
"#J c #00acfe",
"#T c #00b5fe",
"#w c #00bdfe",
"#i c #03d7fe",
"#l c #04c6fe",
"#O c #0868a5",
"#u c #0ba6fe",
".9 c #0c5787",
"#I c #0ebefe",
"#. c #1078ab",
"#V c #116aa6",
".5 c #121519",
"#k c #124c74",
"#P c #1792ec",
"## c #17dcfe",
"#9 c #1a354b",
"#4 c #1d2834",
"#E c #1d689b",
"#8 c #231d1e",
"#L c #244159",
"#v c #25120b",
"#j c #262c33",
"#m c #288dcf",
"#c c #2b282b",
".c c #362927",
"#a c #3982b1",
".d c #3b383a",
".8 c #3fd7fe",
".b c #403e40",
"#y c #406082",
".Z c #444447",
"#G c #4688c8",
".v c #482723",
"#b c #4a3c36",
"#x c #4d4948",
".S c #512b2b",
"#3 c #595453",
"#S c #5e8cec",
"#g c #5f1d1a",
".g c #623927",
"#Q c #657abe",
".Y c #684446",
".a c #686668",
"#M c #746c6a",
".k c #753d29",
"#7 c #777271",
"#t c #78a7fe",
".w c #818384",
".O c #8b8d8f",
".F c #929091",
"#F c #958f8e",
"#R c #966fb3",
".m c #9d9b9c",
".x c #9f9ea0",
".l c #a5a3a4",
"#r c #a7272b",
".4 c #ac4e50",
".e c #adacad",
".# c #b9b8b8",
".0 c #c0593c",
".N c #c3c1c1",
"#6 c #c7c5c5",
".X c #cba1bd",
"#W c #cdcbcb",
".h c #d46f3b",
"#2 c #dbdada",
".G c #dfdede",
".u c #e3683a",
".W c #e695ac",
".R c #e86262",
"#N c #e9e8e9",
"#H c #ee505c",
".7 c #f893be",
".f c #f8f8f8",
"#s c #fe2a2e",
"#A c #fe383c",
"#q c #fe4349",
".M c #fe4d27",
"#z c #fe4f45",
".6 c #fe5254",
"#B c #fe5684",
"#f c #fe595c",
"#p c #fe6559",
"#e c #fe6668",
"#n c #fe6847",
".E c #fe7040",
"#o c #fe7057",
"#h c #fe749e",
".U c #fe756a",
".T c #fe7a72",
"#d c #fe816b",
".3 c #fe817e",
".L c #fe8553",
".V c #fe8787",
".i c #fe8c46",
".K c #fe8f66",
".J c #fe967d",
".j c #fe9d55",
".2 c #fea17a",
".Q c #fea193",
".I c #fea48b",
".t c #fea555",
".1 c #fead6e",
".D c #feb06c",
".P c #feb48a",
".H c #feb694",
".n c #feb959",
".C c #febb7b",
".B c #fec184",
".s c #fec568",
".A c #fec791",
".z c #fed28f",
".o c #fed46a",
".r c #fed478",
".q c #fedd7b",
".y c #fedd89",
".p c #fee07a",
"Qt c #ffffff",
"QtQtQtQtQt.#.a.b.c.c.d.a.e.fQtQtQtQt",
"QtQtQt.#.b.g.h.i.j.j.i.h.k.d.lQtQtQt",
"QtQt.m.c.h.n.o.p.p.q.r.s.t.u.v.w.fQt",
"Qt.x.c.i.s.p.y.z.z.A.B.C.D.j.E.v.FQt",
".G.d.u.s.r.z.A.H.H.I.I.J.K.L.E.M.c.N",
".O.k.j.s.B.P.I.Q.R.S.T.U.V.W.X.W.Y.a",
".Z.0.j.1.2.J.3.3.4.5.6.7.8.9#.###a#b",
"#c.0.L.K#d.U#e#f.v#g#h###i#j#k#l#m.c",
"#j.4#n#o#p#f.6#q#r#s#t#i#u#v#.#w#m.c",
"#x#y.R#z#z#q#q#A#s#B#l#i#C#k#C#D#E#b",
"#F#k#G#H#A#s#s#s#B#I#l#w#w#J#D#K#L#M",
"#N.b#O#P#Q#R#R#S#T#w#T#J#D#C#U#V.c#W",
"Qt.##j#X#Y#C#D#D#D#D#C#Y#U#Z#O#c.lQt",
"QtQt.e#j.9#0#Z#Z#Z#Z#Z#1#0.9#c#FQtQt",
"QtQtQt#2#3#4.9#0#0#0#5.9#c#x#6QtQtQt",
"QtQtQtQtQt#7#8.9#k#9#4.a.N.fQtQtQtQt",
"QtQtQtQtQt#7#8#8.c#M#WQtQtQtQtQtQtQt",
"QtQtQtQt.G.d#3.m#NQtQtQtQtQtQtQtQtQt"};

static const char* const image202_data[] = { 
"18 18 110 2",
".M c #521700",
".L c #602900",
".S c #632e07",
".t c #652f09",
".g c #92540f",
".x c #92580f",
".H c #954b0f",
".D c #95500f",
".G c #955b0f",
".p c #98460f",
".w c #986c0f",
".q c #9f660f",
".J c #a20100",
".e c #a70800",
".a c #a70b00",
".f c #a80500",
".# c #a80700",
".b c #a80800",
".c c #a90200",
".K c #a90500",
".d c #aa0800",
".y c #d48e00",
".i c #e08607",
".s c #e72200",
".u c #e82000",
".E c #e82200",
".A c #e92000",
".B c #e92200",
".o c #ea2000",
".h c #ea2100",
".2 c #fa920c",
"#v c #fdcc00",
"#H c #fe4000",
"#I c #fe781f",
".P c #fe8900",
".N c #fe8c00",
".Q c #fe8d00",
"#p c #fec800",
".8 c #fecc00",
"#n c #fedc00",
".Z c #fede00",
".5 c #fef500",
"#t c #ff4101",
"#m c #ff5200",
"#N c #ff5400",
"#g c #ff600f",
"#O c #ff6f00",
"#Q c #ff7200",
"#P c #ff7800",
"#R c #ff7c3c",
"#z c #ff8000",
".R c #ff8300",
".T c #ff8500",
".O c #ff8600",
"#E c #ff8a00",
"#y c #ff8d00",
"#B c #ff940d",
"#D c #ff9600",
"#e c #ffa700",
"#q c #ffa800",
"#k c #ffad00",
".I c #ffad20",
".j c #ffad28",
".n c #ffad2b",
".l c #ffaf24",
"#x c #ffb100",
".m c #ffb321",
".9 c #ffb400",
".k c #ffb420",
"#w c #ffb600",
"#C c #ffb700",
"#d c #ffc400",
"#u c #ffd300",
".0 c #ffd400",
"#c c #ffd500",
"#b c #ffd600",
"#s c #ffd61b",
"#J c #ffd630",
"#f c #ffd720",
".7 c #ffd800",
".6 c #ffd900",
"#G c #ffd91b",
"#A c #ffd920",
"#L c #ffd924",
"#M c #ffd928",
"#. c #ffd935",
"#o c #ffdb00",
"#K c #ffdb2b",
"#j c #ffdc00",
"#i c #ffdd00",
".1 c #ffdd32",
"## c #ffe600",
".X c #ffe700",
".Y c #ffe800",
".4 c #ffea00",
"#a c #ffec00",
".v c #fff0da",
".z c #fff2d8",
".C c #fff2da",
"#l c #fff39b",
".r c #fff3d5",
".F c #fff3da",
"#r c #fff59e",
"#F c #fff5a4",
"#h c #fff5da",
".3 c #fff6d8",
".V c #fff7d6",
".U c #fff7d8",
".W c #fff7da",
"Qt c #ffffff",
"QtQt.#.a.b.c.d.e.b.b.b.f.b.a.eQtQtQt",
"Qt.g.h.i.i.j.k.l.m.m.m.n.i.i.o.pQtQt",
"Qt.q.r.s.t.t.t.t.t.t.t.t.t.u.v.wQtQt",
"Qt.x.y.z.AQtQtQtQtQtQtQt.B.C.y.DQtQt",
"QtQt.D.y.z.EQtQtQtQtQt.E.F.y.GQtQtQt",
"QtQtQt.H.y.I.JQtQtQt.K.j.y.HQtQtQtQt",
"QtQtQtQt.L.M.N.O.P.Q.R.S.tQtQtQtQtQt",
"QtQtQtQtQt.T.U.V.U.U.W.RQtQtQtQtQtQt",
"QtQtQtQt.T.W.X.Y.Z.Z.0.1.RQtQtQtQtQt",
"QtQtQt.2.3.4.5.4.6.7.8.9#..RQtQtQtQt",
"QtQtQt.2.3###a#a#b#c#d#e#f#gQtQtQtQt",
"QtQtQt.2#h#i.Z#j.8.8#k#l#f#mQtQtQtQt",
"QtQtQt.2#h#i#n#o.8#p#q#r#s#tQtQtQtQt",
"QtQtQt.2.W#j#u#v#w#x#y#z#A.RQtQtQtQt",
"QtQtQtQt#B.W#C.9#D#E#F#G#HQtQtQtQtQt",
"QtQtQtQtQt#I#s#J#K#L#M#NQtQtQtQtQtQt",
"QtQtQtQtQtQt#I#O#P#Q#RQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image203_data[] = { 
"18 18 104 2",
".M c #581d00",
".O c #5b1d00",
".P c #642b00",
".L c #642f07",
".t c #652f09",
".s c #69002e",
"#t c #74675f",
".6 c #898179",
"#L c #8a8078",
".g c #92540f",
".x c #92580f",
".H c #954b0f",
".D c #95500f",
".G c #955b0f",
".o c #98460f",
".w c #986c0f",
".0 c #999087",
".Q c #9e968d",
".p c #9f660f",
".N c #a29891",
".I c #a40000",
".e c #a70800",
".a c #a70b00",
".f c #a80500",
".# c #a80700",
".b c #a80800",
".c c #a90200",
".d c #aa0800",
"#z c #aca6a0",
".J c #ad0000",
"#F c #b1aaa4",
"#E c #b2aaa4",
"#A c #b6b1a6",
"#b c #bab5ac",
"#x c #bdb7b1",
"#y c #beb8b2",
"#j c #c0bcb3",
"#q c #c0bcb4",
".4 c #c1bdb5",
"#D c #c7c2bc",
"#a c #cbc8bc",
"#w c #cbc8c1",
"#C c #ccc7c2",
"#l c #cecbc6",
"#c c #cfcac4",
".3 c #d1cdc1",
"#v c #d1cdc8",
"#s c #d3cfcb",
".y c #d48e00",
".5 c #d4d0cc",
"#B c #d5d1cd",
"#K c #d7d3d0",
"#J c #d7d5cf",
".Z c #d8d5cd",
"#G c #d9d5d0",
"#p c #dad6d3",
"#o c #dad7d3",
".Y c #dbd7d6",
"#i c #dbd8d4",
"#n c #dcd8d4",
"#I c #dcd9d6",
"## c #dcdbd7",
"#H c #ddd9d6",
"#h c #dfdcd9",
".i c #e08607",
".X c #e1dedb",
"#f c #e2e0dd",
".W c #e3e0dd",
"#u c #e4e2e0",
"#e c #e5e3e1",
"#m c #e5e3e2",
"#g c #e5e4e0",
"#. c #e6e4e2",
".r c #e72200",
".7 c #e7e5e3",
".V c #e7e6e2",
".u c #e82000",
".E c #e82200",
".A c #e92000",
".B c #e92200",
".2 c #e9e8e6",
".h c #ea2100",
".9 c #efeeec",
".8 c #f0eeed",
".U c #f0f0ed",
".1 c #f1f0ef",
"#r c #f2f2f0",
"#k c #f3f2f1",
".R c #fafafa",
".S c #fbfafa",
"#d c #fbfbfa",
".T c #fbfbfb",
".j c #ffad28",
".n c #ffad2b",
".l c #ffaf24",
".K c #ffaf27",
".m c #ffb321",
".k c #ffb420",
".v c #fff0da",
".z c #fff2d8",
".C c #fff2da",
".q c #fff3d5",
".F c #fff3da",
"Qt c #ffffff",
"QtQt.#.a.b.c.d.e.b.b.b.f.b.a.eQtQtQt",
"Qt.g.h.i.i.j.k.l.l.l.m.n.i.i.i.oQtQt",
"Qt.p.q.r.s.t.t.t.t.t.t.t.t.u.v.wQtQt",
"Qt.x.y.z.AQtQtQtQtQtQtQt.B.C.y.DQtQt",
"QtQt.D.y.z.EQtQtQtQtQt.E.F.y.GQtQtQt",
"QtQtQt.H.y.l.IQtQtQt.J.K.y.HQtQtQtQt",
"QtQtQtQt.L.M.N.N.N.N.N.O.PQtQtQtQtQt",
"QtQtQtQtQt.Q.R.S.R.R.T.NQtQtQtQtQtQt",
"QtQtQtQt.Q.R.U.V.W.X.Y.Z.0QtQtQtQtQt",
"QtQtQt.Q.R.U.U.1.2.X.3.4.5.6QtQtQtQt",
"QtQtQt.Q.R.7.8.9#.###a#b#c.6QtQtQtQt",
"QtQtQt.Q#d#e#f#g#h#i#j#k#l.6QtQtQtQt",
"QtQtQt.Q#d#m#n#o#i#p#q#r#s#tQtQtQtQt",
"QtQtQt.Q#d#u#v#w#x#y#z#A#B#tQtQtQtQt",
"QtQtQtQt.Q#d#C#D#E#F#r#G#tQtQtQtQtQt",
"QtQtQtQtQt.Q#H#I#J#J#K#tQtQtQtQtQtQt",
"QtQtQtQtQtQt#L#L#L#t#tQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image204_data[] = { 
"18 18 123 2",
".L c #4f1400",
".R c #622b02",
".t c #652f09",
".K c #680009",
".g c #92540f",
".x c #92580f",
".H c #954b0f",
".D c #95500f",
".G c #955b0f",
".p c #98460f",
".w c #986c0f",
".q c #9f660f",
".J c #a10000",
"#c c #a54327",
".e c #a70800",
".a c #a70b00",
"#4 c #a7492e",
".f c #a80500",
".# c #a80700",
".b c #a80800",
".c c #a90200",
"#P c #a94b32",
".d c #aa0800",
"#m c #ae593e",
"#F c #b05f41",
"#w c #b16447",
"#M c #b1815b",
"#3 c #b46348",
".4 c #b4664b",
"#Z c #b5664b",
".S c #b5694d",
"#n c #b56950",
".M c #b56b51",
".W c #b56c52",
"#x c #b56d51",
"#d c #b66c51",
"#U c #b78562",
"#G c #b86f56",
".N c #b87259",
"#0 c #b8725b",
".5 c #b8745a",
"#W c #b8775c",
"#2 c #ba755b",
"#T c #ba8d6b",
"#Q c #bc735a",
"#b c #bc8e6d",
"#1 c #bd7f66",
".V c #be826a",
"#N c #bf8e68",
"#L c #bf9271",
".O c #c0846d",
".Q c #c1866e",
".P c #c28a73",
"#a c #c39576",
"#j c #c49573",
"#D c #c49575",
"#k c #c49b79",
"#K c #c49c7c",
"#l c #c49c7e",
"#O c #c49d7f",
"#Y c #c49e80",
"#t c #c79c79",
"#V c #c79e81",
"#v c #c7a083",
"#S c #c9a183",
"#C c #caa182",
"#X c #caa487",
"#J c #cba489",
"#i c #cba787",
"#R c #cba889",
"#B c #cba88b",
"#s c #cca788",
"## c #cda987",
".3 c #d0aa8c",
"#. c #d0ac8b",
"#A c #d0af93",
"#r c #d1af94",
"#I c #d2b498",
"#q c #d2b69d",
".y c #d48e00",
"#z c #d4b69e",
"#h c #d5b69c",
".2 c #d6b49b",
".9 c #d8bca2",
"#p c #d8bea7",
"#g c #dac0a9",
"#H c #dbbda6",
".1 c #dbc1a6",
"#y c #dfc4ae",
".0 c #dfc6af",
".8 c #dfc6b0",
".i c #e08607",
"#o c #e0c5b0",
"#f c #e0c7b3",
".Z c #e5d2c4",
".s c #e72200",
"#e c #e7d5c4",
".u c #e82000",
".E c #e82200",
".7 c #e8d8ca",
".A c #e92000",
".B c #e92200",
".o c #ea2000",
".h c #ea2100",
".Y c #eedfd4",
".6 c #eee0d5",
".U c #f2e4d9",
"#E c #f6decb",
"#u c #f6decd",
".T c #f6ede7",
".X c #f6ede8",
".I c #ffad20",
".j c #ffad28",
".n c #ffad2b",
".l c #ffaf24",
".m c #ffb321",
".k c #ffb420",
".v c #fff0da",
".z c #fff2d8",
".C c #fff2da",
".r c #fff3d5",
".F c #fff3da",
"Qt c #ffffff",
"QtQt.#.a.b.c.d.e.b.b.b.f.b.a.eQtQtQt",
"Qt.g.h.i.i.j.k.l.l.l.m.n.i.i.o.pQtQt",
"Qt.q.r.s.t.t.t.t.t.t.t.t.t.u.v.wQtQt",
"Qt.x.y.z.AQtQtQtQtQtQtQt.B.C.y.DQtQt",
"QtQt.D.y.z.EQtQtQtQtQt.E.F.y.GQtQtQt",
"QtQtQt.H.y.I.JQtQtQt.d.j.y.HQtQtQtQt",
"QtQtQtQt.K.L.M.N.O.P.Q.t.RQtQtQtQtQt",
"QtQtQtQtQt.S.T.T.T.T.U.VQtQtQtQtQtQt",
"QtQtQtQt.W.X.Y.Z.0.1.2.3.4QtQtQtQtQt",
"QtQtQt.5.X.6.7.8.9#.###a#b#cQtQtQtQt",
"QtQtQt#d.T#e#f#g#h#i#j#k#l#mQtQtQtQt",
"QtQtQt#n.T#o#p#q#r#s#t#u#v#wQtQtQtQt",
"QtQtQt#x.T#y#z#A#B#C#D#E#v#FQtQtQtQt",
"QtQtQt#G.T#H#I#J#K#L#M#N#O#PQtQtQtQt",
"QtQtQtQt#Q.T#R#S#T#U#u#V.SQtQtQtQtQt",
"QtQtQtQtQt#W#v#X#v#Y#O#ZQtQtQtQtQtQt",
"QtQtQtQtQtQt#0#1#2#3#4QtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

static const char* const image205_data[] = { 
"18 18 56 1",
"Y c #511b09",
"1 c #551b09",
"X c #6f2409",
"0 c #892b0f",
"Z c #a83600",
"W c #c23d00",
"S c #d03d00",
"R c #d14000",
"C c #d14500",
"P c #d14700",
"O c #d24b00",
"Q c #d44d00",
"d c #d95600",
"H c #da5f00",
"K c #da6600",
"I c #dc7100",
"# c #dc7200",
"N c #dc7700",
"x c #dc7800",
"b c #df7100",
"T c #e08000",
"n c #e08200",
"M c #e08300",
"a c #e37f00",
"w c #ffb400",
"l c #ffb500",
"B c #ffb600",
"k c #ffb700",
"v c #ffb800",
"A c #ffba00",
"u c #ffbb00",
"j c #ffbc00",
"G c #ffc000",
"i c #ffc100",
"t c #ffc400",
"z c #ffc700",
"L c #ffc800",
"F c #ffca00",
"h c #ffce00",
"V c #ffcf00",
"s c #ffd000",
"y c #ffd300",
"E c #ffd500",
"J c #ffd600",
"r c #ffd700",
"U c #ffd900",
"q c #ffdc00",
"c c #ffe531",
"m c #ffe742",
"o c #ffe946",
"g c #ffe94c",
"e c #ffea50",
"D c #ffea53",
"p c #ffea54",
"f c #fff6e2",
". c #ffffff",
"..................",
".#.aaaaaaaaaaaa.#.",
"bcddefghijklkgddmn",
"bo.dpqrstukvvwd.ox",
"bo.dpfpyzuAuBpd.ox",
".C.dDfpEFGjjupd.H.",
"..CdIefpJhtipKdH..",
".....npfpsLpx.....",
"......MpfpLN......",
".......KpsO.......",
"......PQpyRS......",
".....TppUEVVN.....",
".....WWWWWWWW.....",
".....WXYYYYYZ.....",
".....WXXXXXXZ.....",
"....0ZZZZZZZZ0....",
"....1111111111....",
".................."};

static const char* const image206_data[] = { 
"41 19 6 1",
"c c #9196ab",
"a c #f2f5fa",
"# c #f2f6fa",
". c #f3f4f9",
"b c #f3f6f9",
"d c #ffffff",
"..##a#a##.##..b..aa.......bb.....ab##....",
"..##a#a##.##..b..aa.......bb.....ab##....",
"..ccccccccccccccccccccccccccccccccccccc..",
".ccccccccccccccccccccccccccccccccccccccc.",
".ccccccccccccccccccccccccccccccccccccccc.",
".ccccccdddddddccccdddddcccdddddccdcccccc.",
".ccccccdcccccccccdcccccdccdcccdccdcccccc.",
".ccccccdcccccccccdcccccdccdcccdccddccccc.",
".ccccccdccccccccccdddddcccdddddccdcccccc.",
".ccccccdddddddcccccccccccccccccccccccccc.",
".cccccccccdcccccdddddddddccdddddddcccccc.",
".cccccccccdcccccccccdccccccccccccdcccccc.",
".cccccccccdccccccdddddddcccdddddddcccccc.",
".cccccdddddddddccdcccccdcccdcccccccccccc.",
".ccccccccccccccccdddddddcccdddddddcccccc.",
".ccccccccccccccccccccccccccccccccccccccc.",
".ccccccccccccccccccccccccccccccccccccccc.",
"..ccccccccccccccccccccccccccccccccccccc..",
"..##a#a##.##..b..aa.......bb.....ab##...."};


/*
 *  Constructs a MyDialog1 as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
MyDialog1::MyDialog1( QWidget* parent, const char* name, bool modal, Qt::WFlags fl )
    : QDialog( parent, name, modal, fl ),
      image1( (const char **) image1_data ),
      image2( (const char **) image2_data ),
      image3( (const char **) image3_data ),
      image4( (const char **) image4_data ),
      image5( (const char **) image5_data ),
      image6( (const char **) image6_data ),
      image7( (const char **) image7_data ),
      image8( (const char **) image8_data ),
      image9( (const char **) image9_data ),
      image10( (const char **) image10_data ),
      image11( (const char **) image11_data ),
      image12( (const char **) image12_data ),
      image13( (const char **) image13_data ),
      image14( (const char **) image14_data ),
      image15( (const char **) image15_data ),
      image16( (const char **) image16_data ),
      image17( (const char **) image17_data ),
      image18( (const char **) image18_data ),
      image19( (const char **) image19_data ),
      image20( (const char **) image20_data ),
      image21( (const char **) image21_data ),
      image22( (const char **) image22_data ),
      image23( (const char **) image23_data ),
      image24( (const char **) image24_data ),
      image25( (const char **) image25_data ),
      image26( (const char **) image26_data ),
      image27( (const char **) image27_data ),
      image28( (const char **) image28_data ),
      image29( (const char **) image29_data ),
      image30( (const char **) image30_data ),
      image31( (const char **) image31_data ),
      image32( (const char **) image32_data ),
      image33( (const char **) image33_data ),
      image34( (const char **) image34_data ),
      image35( (const char **) image35_data ),
      image36( (const char **) image36_data ),
      image37( (const char **) image37_data ),
      image38( (const char **) image38_data ),
      image39( (const char **) image39_data ),
      image40( (const char **) image40_data ),
      image41( (const char **) image41_data ),
      image42( (const char **) image42_data ),
      image49( (const char **) image49_data ),
      image50( (const char **) image50_data ),
      image51( (const char **) image51_data ),
      image52( (const char **) image52_data ),
      image53( (const char **) image53_data ),
      image54( (const char **) image54_data ),
      image55( (const char **) image55_data ),
      image56( (const char **) image56_data ),
      image57( (const char **) image57_data ),
      image58( (const char **) image58_data ),
      image59( (const char **) image59_data ),
      image60( (const char **) image60_data ),
      image61( (const char **) image61_data ),
      image62( (const char **) image62_data ),
      image63( (const char **) image63_data ),
      image64( (const char **) image64_data ),
      image65( (const char **) image65_data ),
      image66( (const char **) image66_data ),
      image67( (const char **) image67_data ),
      image68( (const char **) image68_data ),
      image69( (const char **) image69_data ),
      image70( (const char **) image70_data ),
      image71( (const char **) image71_data ),
      image72( (const char **) image72_data ),
      image73( (const char **) image73_data ),
      image74( (const char **) image74_data ),
      image75( (const char **) image75_data ),
      image76( (const char **) image76_data ),
      image77( (const char **) image77_data ),
      image78( (const char **) image78_data ),
      image79( (const char **) image79_data ),
      image80( (const char **) image80_data ),
      image81( (const char **) image81_data ),
      image82( (const char **) image82_data ),
      image83( (const char **) image83_data ),
      image84( (const char **) image84_data ),
      image85( (const char **) image85_data ),
      image86( (const char **) image86_data ),
      image87( (const char **) image87_data ),
      image88( (const char **) image88_data ),
      image89( (const char **) image89_data ),
      image90( (const char **) image90_data ),
      image91( (const char **) image91_data ),
      image92( (const char **) image92_data ),
      image93( (const char **) image93_data ),
      image94( (const char **) image94_data ),
      image95( (const char **) image95_data ),
      image96( (const char **) image96_data ),
      image97( (const char **) image97_data ),
      image98( (const char **) image98_data ),
      image99( (const char **) image99_data ),
      image100( (const char **) image100_data ),
      image101( (const char **) image101_data ),
      image102( (const char **) image102_data ),
      image103( (const char **) image103_data ),
      image104( (const char **) image104_data ),
      image105( (const char **) image105_data ),
      image106( (const char **) image106_data ),
      image107( (const char **) image107_data ),
      image108( (const char **) image108_data ),
      image109( (const char **) image109_data ),
      image110( (const char **) image110_data ),
      image111( (const char **) image111_data ),
      image112( (const char **) image112_data ),
      image113( (const char **) image113_data ),
      image114( (const char **) image114_data ),
      image115( (const char **) image115_data ),
      image116( (const char **) image116_data ),
      image117( (const char **) image117_data ),
      image118( (const char **) image118_data ),
      image119( (const char **) image119_data ),
      image120( (const char **) image120_data ),
      image121( (const char **) image121_data ),
      image122( (const char **) image122_data ),
      image123( (const char **) image123_data ),
      image124( (const char **) image124_data ),
      image125( (const char **) image125_data ),
      image126( (const char **) image126_data ),
      image127( (const char **) image127_data ),
      image128( (const char **) image128_data ),
      image129( (const char **) image129_data ),
      image130( (const char **) image130_data ),
      image131( (const char **) image131_data ),
      image132( (const char **) image132_data ),
      image133( (const char **) image133_data ),
      image134( (const char **) image134_data ),
      image135( (const char **) image135_data ),
      image136( (const char **) image136_data ),
      image137( (const char **) image137_data ),
      image138( (const char **) image138_data ),
      image139( (const char **) image139_data ),
      image140( (const char **) image140_data ),
      image141( (const char **) image141_data ),
      image142( (const char **) image142_data ),
      image143( (const char **) image143_data ),
      image144( (const char **) image144_data ),
      image145( (const char **) image145_data ),
      image146( (const char **) image146_data ),
      image147( (const char **) image147_data ),
      image148( (const char **) image148_data ),
      image149( (const char **) image149_data ),
      image150( (const char **) image150_data ),
      image151( (const char **) image151_data ),
      image152( (const char **) image152_data ),
      image153( (const char **) image153_data ),
      image154( (const char **) image154_data ),
      image155( (const char **) image155_data ),
      image156( (const char **) image156_data ),
      image157( (const char **) image157_data ),
      image158( (const char **) image158_data ),
      image159( (const char **) image159_data ),
      image160( (const char **) image160_data ),
      image161( (const char **) image161_data ),
      image162( (const char **) image162_data ),
      image163( (const char **) image163_data ),
      image164( (const char **) image164_data ),
      image165( (const char **) image165_data ),
      image166( (const char **) image166_data ),
      image167( (const char **) image167_data ),
      image168( (const char **) image168_data ),
      image169( (const char **) image169_data ),
      image170( (const char **) image170_data ),
      image171( (const char **) image171_data ),
      image172( (const char **) image172_data ),
      image173( (const char **) image173_data ),
      image174( (const char **) image174_data ),
      image175( (const char **) image175_data ),
      image176( (const char **) image176_data ),
      image177( (const char **) image177_data ),
      image178( (const char **) image178_data ),
      image179( (const char **) image179_data ),
      image180( (const char **) image180_data ),
      image181( (const char **) image181_data ),
      image182( (const char **) image182_data ),
      image183( (const char **) image183_data ),
      image184( (const char **) image184_data ),
      image185( (const char **) image185_data ),
      image186( (const char **) image186_data ),
      image187( (const char **) image187_data ),
      image188( (const char **) image188_data ),
      image189( (const char **) image189_data ),
      image190( (const char **) image190_data ),
      image191( (const char **) image191_data ),
      image192( (const char **) image192_data ),
      image193( (const char **) image193_data ),
      image194( (const char **) image194_data ),
      image195( (const char **) image195_data ),
      image196( (const char **) image196_data ),
      image197( (const char **) image197_data ),
      image198( (const char **) image198_data ),
      image199( (const char **) image199_data ),
      image200( (const char **) image200_data ),
      image201( (const char **) image201_data ),
      image202( (const char **) image202_data ),
      image203( (const char **) image203_data ),
      image204( (const char **) image204_data ),
      image205( (const char **) image205_data ),
      image206( (const char **) image206_data )
{
    QImage img;
    img.loadFromData( image0_data, sizeof( image0_data ), "PNG" );
    image0 = img;
    img.loadFromData( image43_data, sizeof( image43_data ), "PNG" );
    image43 = img;
    img.loadFromData( image44_data, sizeof( image44_data ), "PNG" );
    image44 = img;
    img.loadFromData( image45_data, sizeof( image45_data ), "PNG" );
    image45 = img;
    img.loadFromData( image46_data, sizeof( image46_data ), "PNG" );
    image46 = img;
    img.loadFromData( image47_data, sizeof( image47_data ), "PNG" );
    image47 = img;
    img.loadFromData( image48_data, sizeof( image48_data ), "PNG" );
    image48 = img;
    if ( !name )
	setName( "MyDialog1" );
    setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, 0, 0, sizePolicy().hasHeightForWidth() ) );
    setMinimumSize( QSize( 303, 268 ) );
    setMaximumSize( QSize( 303, 268 ) );
    setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    setIcon( image0 );
    setSizeGripEnabled( TRUE );

    tabWidget = new QTabWidget( this, "tabWidget" );
    tabWidget->setGeometry( QRect( 10, 10, 283, 250 ) );
    tabWidget->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    tabWidget->setBackgroundOrigin( QTabWidget::ParentOrigin );
    QFont tabWidget_font(  tabWidget->font() );
    tabWidget_font.setPointSize( 9 );
    tabWidget->setFont( tabWidget_font );
    tabWidget->setTabPosition( QTabWidget::Bottom );
    tabWidget->setTabShape( QTabWidget::Triangular );

    Widget8 = new QWidget( tabWidget, "Widget8" );
    Widget8Layout = new Q3VBoxLayout( Widget8, 11, 6, "Widget8Layout"); 

    layout3 = new Q3VBoxLayout( 0, 0, 6, "layout3"); 

    layout2 = new Q3HBoxLayout( 0, 0, 6, "layout2"); 
    spacer13 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout2->addItem( spacer13 );

    layout1 = new Q3GridLayout( 0, 1, 1, 0, 6, "layout1"); 

    toolButton4 = new MyToolButton( Widget8, "toolButton4" );
    toolButton4->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton4->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton4->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton4->setIconSet( QIcon( image1 ) );

    layout1->addWidget( toolButton4, 1, 1 );

    toolButton21 = new MyToolButton( Widget8, "toolButton21" );
    toolButton21->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton21->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton21->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton21->setIconSet( QIcon( image2 ) );

    layout1->addWidget( toolButton21, 3, 3 );

    toolButton7 = new MyToolButton( Widget8, "toolButton7" );
    toolButton7->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton7->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton7->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton7->setIconSet( QIcon( image3 ) );

    layout1->addWidget( toolButton7, 1, 4 );

    toolButton37 = new MyToolButton( Widget8, "toolButton37" );
    toolButton37->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton37->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton37->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton37->setIconSet( QIcon( image4 ) );

    layout1->addWidget( toolButton37, 5, 3 );

    toolButton39 = new MyToolButton( Widget8, "toolButton39" );
    toolButton39->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton39->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton39->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton39->setIconSet( QIcon( image5 ) );

    layout1->addWidget( toolButton39, 5, 5 );

    toolButton31 = new MyToolButton( Widget8, "toolButton31" );
    toolButton31->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton31->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton31->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton31->setIconSet( QIcon( image6 ) );

    layout1->addWidget( toolButton31, 4, 5 );

    toolButton13 = new MyToolButton( Widget8, "toolButton13" );
    toolButton13->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton13->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton13->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton13->setIconSet( QIcon( image7 ) );

    layout1->addWidget( toolButton13, 2, 3 );

    toolButton6 = new MyToolButton( Widget8, "toolButton6" );
    toolButton6->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton6->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton6->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton6->setIconSet( QIcon( image8 ) );

    layout1->addWidget( toolButton6, 1, 3 );

    toolButton19 = new MyToolButton( Widget8, "toolButton19" );
    toolButton19->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton19->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton19->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton19->setIconSet( QIcon( image9 ) );

    layout1->addWidget( toolButton19, 3, 1 );

    toolButton16 = new MyToolButton( Widget8, "toolButton16" );
    toolButton16->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton16->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton16->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton16->setIconSet( QIcon( image10 ) );

    layout1->addWidget( toolButton16, 2, 6 );

    toolButton38 = new MyToolButton( Widget8, "toolButton38" );
    toolButton38->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton38->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton38->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton38->setIconSet( QIcon( image11 ) );

    layout1->addWidget( toolButton38, 5, 4 );

    toolButton34 = new MyToolButton( Widget8, "toolButton34" );
    toolButton34->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton34->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton34->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton34->setIconSet( QIcon( image12 ) );

    layout1->addWidget( toolButton34, 5, 0 );

    toolButton9 = new MyToolButton( Widget8, "toolButton9" );
    toolButton9->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton9->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton9->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton9->setIconSet( QIcon( image13 ) );

    layout1->addWidget( toolButton9, 1, 6 );

    toolButton27 = new MyToolButton( Widget8, "toolButton27" );
    toolButton27->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton27->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton27->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton27->setIconSet( QIcon( image14 ) );

    layout1->addWidget( toolButton27, 4, 1 );

    toolButton12 = new MyToolButton( Widget8, "toolButton12" );
    toolButton12->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton12->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton12->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton12->setIconSet( QIcon( image15 ) );

    layout1->addWidget( toolButton12, 2, 2 );

    toolButton36 = new MyToolButton( Widget8, "toolButton36" );
    toolButton36->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton36->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton36->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton36->setIconSet( QIcon( image16 ) );

    layout1->addWidget( toolButton36, 5, 2 );

    toolButton3 = new MyToolButton( Widget8, "toolButton3" );
    toolButton3->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton3->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton3->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton3->setIconSet( QIcon( image17 ) );

    layout1->addWidget( toolButton3, 1, 0 );

    toolButton23 = new MyToolButton( Widget8, "toolButton23" );
    toolButton23->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton23->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton23->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton23->setIconSet( QIcon( image18 ) );

    layout1->addWidget( toolButton23, 3, 5 );

    toolButton35 = new MyToolButton( Widget8, "toolButton35" );
    toolButton35->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton35->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton35->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton35->setIconSet( QIcon( image19 ) );

    layout1->addWidget( toolButton35, 5, 1 );

    toolButton32 = new MyToolButton( Widget8, "toolButton32" );
    toolButton32->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton32->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton32->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton32->setIconSet( QIcon( image20 ) );

    layout1->addWidget( toolButton32, 4, 6 );

    toolButton29 = new MyToolButton( Widget8, "toolButton29" );
    toolButton29->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton29->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton29->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton29->setIconSet( QIcon( image21 ) );

    layout1->addWidget( toolButton29, 4, 3 );

    toolButton22 = new MyToolButton( Widget8, "toolButton22" );
    toolButton22->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton22->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton22->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton22->setIconSet( QIcon( image22 ) );

    layout1->addWidget( toolButton22, 3, 4 );

    toolButton1 = new MyToolButton( Widget8, "toolButton1" );
    toolButton1->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton1->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton1->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton1->setIconSet( QIcon( image23 ) );

    layout1->addWidget( toolButton1, 0, 6 );

    toolButton26 = new MyToolButton( Widget8, "toolButton26" );
    toolButton26->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton26->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton26->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton26->setIconSet( QIcon( image24 ) );

    layout1->addWidget( toolButton26, 4, 0 );

    toolButton18 = new MyToolButton( Widget8, "toolButton18" );
    toolButton18->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton18->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton18->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton18->setIconSet( QIcon( image25 ) );

    layout1->addWidget( toolButton18, 3, 0 );

    toolButton33 = new MyToolButton( Widget8, "toolButton33" );
    toolButton33->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton33->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton33->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton33->setIconSet( QIcon( image26 ) );

    layout1->addWidget( toolButton33, 4, 7 );

    toolButton10 = new MyToolButton( Widget8, "toolButton10" );
    toolButton10->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton10->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton10->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton10->setIconSet( QIcon( image27 ) );

    layout1->addWidget( toolButton10, 1, 7 );

    toolButton42 = new MyToolButton( Widget8, "toolButton42" );
    toolButton42->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton42->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton42->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton42->setIconSet( QIcon( image28 ) );

    layout1->addWidget( toolButton42, 2, 1 );

    toolButton40 = new MyToolButton( Widget8, "toolButton40" );
    toolButton40->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton40->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton40->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton40->setIconSet( QIcon( image29 ) );

    layout1->addWidget( toolButton40, 5, 6 );

    toolButton17 = new MyToolButton( Widget8, "toolButton17" );
    toolButton17->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton17->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton17->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton17->setIconSet( QIcon( image30 ) );

    layout1->addWidget( toolButton17, 2, 7 );

    toolButton41 = new MyToolButton( Widget8, "toolButton41" );
    toolButton41->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton41->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton41->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton41->setIconSet( QIcon( image31 ) );

    layout1->addWidget( toolButton41, 5, 7 );

    toolButton8 = new MyToolButton( Widget8, "toolButton8" );
    toolButton8->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton8->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton8->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton8->setIconSet( QIcon( image32 ) );

    layout1->addWidget( toolButton8, 1, 5 );

    toolButton24 = new MyToolButton( Widget8, "toolButton24" );
    toolButton24->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton24->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton24->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton24->setIconSet( QIcon( image33 ) );

    layout1->addWidget( toolButton24, 3, 6 );

    toolButton2 = new MyToolButton( Widget8, "toolButton2" );
    toolButton2->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton2->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton2->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton2->setIconSet( QIcon( image34 ) );

    layout1->addWidget( toolButton2, 0, 7 );

    toolButton15 = new MyToolButton( Widget8, "toolButton15" );
    toolButton15->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton15->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton15->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton15->setIconSet( QIcon( image35 ) );

    layout1->addWidget( toolButton15, 2, 5 );

    toolButton14 = new MyToolButton( Widget8, "toolButton14" );
    toolButton14->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton14->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton14->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton14->setIconSet( QIcon( image36 ) );

    layout1->addWidget( toolButton14, 2, 4 );

    toolButton5 = new MyToolButton( Widget8, "toolButton5" );
    toolButton5->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton5->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton5->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton5->setIconSet( QIcon( image37 ) );

    layout1->addWidget( toolButton5, 1, 2 );

    toolButton28 = new MyToolButton( Widget8, "toolButton28" );
    toolButton28->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton28->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton28->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton28->setIconSet( QIcon( image38 ) );

    layout1->addWidget( toolButton28, 4, 2 );

    toolButton25 = new MyToolButton( Widget8, "toolButton25" );
    toolButton25->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton25->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton25->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton25->setIconSet( QIcon( image39 ) );

    layout1->addWidget( toolButton25, 3, 7 );

    toolButton20 = new MyToolButton( Widget8, "toolButton20" );
    toolButton20->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton20->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton20->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton20->setIconSet( QIcon( image40 ) );

    layout1->addWidget( toolButton20, 3, 2 );

    toolButton11 = new MyToolButton( Widget8, "toolButton11" );
    toolButton11->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton11->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton11->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton11->setIconSet( QIcon( image41 ) );

    layout1->addWidget( toolButton11, 2, 0 );

    toolButton30 = new MyToolButton( Widget8, "toolButton30" );
    toolButton30->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton30->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton30->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton30->setIconSet( QIcon( image42 ) );

    layout1->addWidget( toolButton30, 4, 4 );

    toolButton145 = new MyToolButton( Widget8, "toolButton145" );
    toolButton145->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton145->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton145->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton145->setIconSet( QIcon( image43 ) );

    layout1->addWidget( toolButton145, 0, 0 );

    toolButton146 = new MyToolButton( Widget8, "toolButton146" );
    toolButton146->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton146->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton146->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton146->setIconSet( QIcon( image44 ) );

    layout1->addWidget( toolButton146, 0, 1 );

    toolButton147 = new MyToolButton( Widget8, "toolButton147" );
    toolButton147->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton147->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton147->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton147->setIconSet( QIcon( image45 ) );

    layout1->addWidget( toolButton147, 0, 2 );

    toolButton148 = new MyToolButton( Widget8, "toolButton148" );
    toolButton148->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton148->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton148->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton148->setIconSet( QIcon( image46 ) );

    layout1->addWidget( toolButton148, 0, 3 );

    toolButton149 = new MyToolButton( Widget8, "toolButton149" );
    toolButton149->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton149->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton149->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton149->setIconSet( QIcon( image47 ) );

    layout1->addWidget( toolButton149, 0, 4 );

    toolButton150 = new MyToolButton( Widget8, "toolButton150" );
    toolButton150->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton150->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton150->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton150->setIconSet( QIcon( image48 ) );

    layout1->addWidget( toolButton150, 0, 5 );

    toolButton151 = new MyToolButton( Widget8, "toolButton151" );
    toolButton151->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton151->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton151->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton151->setIconSet( QIcon( image49 ) );

    layout1->addWidget( toolButton151, 6, 0 );

    toolButton152 = new MyToolButton( Widget8, "toolButton152" );
    toolButton152->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton152->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton152->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton152->setIconSet( QIcon( image50 ) );

    layout1->addWidget( toolButton152, 6, 1 );
    layout2->addLayout( layout1 );
    spacer5 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout2->addItem( spacer5 );
    layout3->addLayout( layout2 );
    spacer4_2 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    layout3->addItem( spacer4_2 );
    Widget8Layout->addLayout( layout3 );
    tabWidget->insertTab( Widget8, QString::fromLatin1("") );

    Widget9 = new QWidget( tabWidget, "Widget9" );
    Widget9Layout = new Q3VBoxLayout( Widget9, 11, 6, "Widget9Layout"); 

    layout6 = new Q3VBoxLayout( 0, 0, 6, "layout6"); 

    layout5 = new Q3HBoxLayout( 0, 0, 6, "layout5"); 
    spacer14 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout5->addItem( spacer14 );

    layout4 = new Q3GridLayout( 0, 1, 1, 0, 6, "layout4"); 

    toolButton57 = new MyToolButton( Widget9, "toolButton57" );
    toolButton57->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton57->setIconSet( QIcon( image51 ) );

    layout4->addWidget( toolButton57, 1, 6 );

    toolButton54 = new MyToolButton( Widget9, "toolButton54" );
    toolButton54->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton54->setIconSet( QIcon( image52 ) );

    layout4->addWidget( toolButton54, 1, 3 );

    toolButton47 = new MyToolButton( Widget9, "toolButton47" );
    toolButton47->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton47->setIconSet( QIcon( image53 ) );

    layout4->addWidget( toolButton47, 0, 4 );

    toolButton51 = new MyToolButton( Widget9, "toolButton51" );
    toolButton51->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton51->setIconSet( QIcon( image54 ) );

    layout4->addWidget( toolButton51, 1, 0 );

    toolButton52 = new MyToolButton( Widget9, "toolButton52" );
    toolButton52->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton52->setIconSet( QIcon( image55 ) );

    layout4->addWidget( toolButton52, 1, 1 );

    toolButton56 = new MyToolButton( Widget9, "toolButton56" );
    toolButton56->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton56->setIconSet( QIcon( image56 ) );

    layout4->addWidget( toolButton56, 1, 5 );

    toolButton55 = new MyToolButton( Widget9, "toolButton55" );
    toolButton55->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton55->setIconSet( QIcon( image57 ) );

    layout4->addWidget( toolButton55, 1, 4 );

    toolButton43 = new MyToolButton( Widget9, "toolButton43" );
    toolButton43->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton43->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton43->setIconSet( QIcon( image58 ) );

    layout4->addWidget( toolButton43, 0, 0 );

    toolButton58 = new MyToolButton( Widget9, "toolButton58" );
    toolButton58->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton58->setIconSet( QIcon( image59 ) );

    layout4->addWidget( toolButton58, 1, 7 );

    toolButton44 = new MyToolButton( Widget9, "toolButton44" );
    toolButton44->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton44->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton44->setIconSet( QIcon( image60 ) );

    layout4->addWidget( toolButton44, 0, 1 );

    toolButton48 = new MyToolButton( Widget9, "toolButton48" );
    toolButton48->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton48->setIconSet( QIcon( image61 ) );

    layout4->addWidget( toolButton48, 0, 5 );

    toolButton45 = new MyToolButton( Widget9, "toolButton45" );
    toolButton45->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton45->setIconSet( QIcon( image62 ) );

    layout4->addWidget( toolButton45, 0, 2 );

    toolButton53 = new MyToolButton( Widget9, "toolButton53" );
    toolButton53->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton53->setIconSet( QIcon( image63 ) );

    layout4->addWidget( toolButton53, 1, 2 );

    toolButton49 = new MyToolButton( Widget9, "toolButton49" );
    toolButton49->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton49->setIconSet( QIcon( image64 ) );

    layout4->addWidget( toolButton49, 0, 6 );

    toolButton50 = new MyToolButton( Widget9, "toolButton50" );
    toolButton50->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton50->setIconSet( QIcon( image65 ) );

    layout4->addWidget( toolButton50, 0, 7 );

    toolButton46 = new MyToolButton( Widget9, "toolButton46" );
    toolButton46->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton46->setIconSet( QIcon( image66 ) );

    layout4->addWidget( toolButton46, 0, 3 );

    toolButton153 = new MyToolButton( Widget9, "toolButton153" );
    toolButton153->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton153->setIconSet( QIcon( image67 ) );

    layout4->addWidget( toolButton153, 2, 0 );

    toolButton154 = new MyToolButton( Widget9, "toolButton154" );
    toolButton154->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton154->setIconSet( QIcon( image68 ) );

    layout4->addWidget( toolButton154, 2, 1 );

    toolButton155 = new MyToolButton( Widget9, "toolButton155" );
    toolButton155->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton155->setIconSet( QIcon( image69 ) );

    layout4->addWidget( toolButton155, 2, 2 );

    toolButton156 = new MyToolButton( Widget9, "toolButton156" );
    toolButton156->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton156->setIconSet( QIcon( image70 ) );

    layout4->addWidget( toolButton156, 2, 3 );

    toolButton157 = new MyToolButton( Widget9, "toolButton157" );
    toolButton157->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton157->setIconSet( QIcon( image71 ) );

    layout4->addWidget( toolButton157, 2, 4 );

    toolButton158 = new MyToolButton( Widget9, "toolButton158" );
    toolButton158->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton158->setIconSet( QIcon( image72 ) );

    layout4->addWidget( toolButton158, 2, 5 );

    toolButton159 = new MyToolButton( Widget9, "toolButton159" );
    toolButton159->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton159->setIconSet( QIcon( image73 ) );

    layout4->addWidget( toolButton159, 2, 6 );

    toolButton160 = new MyToolButton( Widget9, "toolButton160" );
    toolButton160->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton160->setIconSet( QIcon( image74 ) );

    layout4->addWidget( toolButton160, 2, 7 );

    toolButton161 = new MyToolButton( Widget9, "toolButton161" );
    toolButton161->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton161->setIconSet( QIcon( image75 ) );

    layout4->addWidget( toolButton161, 3, 0 );

    toolButton162 = new MyToolButton( Widget9, "toolButton162" );
    toolButton162->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton162->setIconSet( QIcon( image76 ) );

    layout4->addWidget( toolButton162, 3, 1 );

    toolButton163 = new MyToolButton( Widget9, "toolButton163" );
    toolButton163->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton163->setIconSet( QIcon( image77 ) );

    layout4->addWidget( toolButton163, 3, 2 );
    layout5->addLayout( layout4 );
    spacer6 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout5->addItem( spacer6 );
    layout6->addLayout( layout5 );
    spacer1 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    layout6->addItem( spacer1 );
    Widget9Layout->addLayout( layout6 );
    tabWidget->insertTab( Widget9, QString::fromLatin1("") );

    TabPage = new QWidget( tabWidget, "TabPage" );
    TabPageLayout = new Q3VBoxLayout( TabPage, 11, 6, "TabPageLayout"); 

    layout9 = new Q3VBoxLayout( 0, 0, 6, "layout9"); 

    layout8 = new Q3HBoxLayout( 0, 0, 6, "layout8"); 
    spacer16 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout8->addItem( spacer16 );

    layout7 = new Q3GridLayout( 0, 1, 1, 0, 6, "layout7"); 

    toolButton82 = new MyToolButton( TabPage, "toolButton82" );
    toolButton82->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton82->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton82->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton82->setIconSet( QIcon( image78 ) );

    layout7->addWidget( toolButton82, 2, 7 );

    toolButton81 = new MyToolButton( TabPage, "toolButton81" );
    toolButton81->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton81->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton81->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton81->setIconSet( QIcon( image79 ) );

    layout7->addWidget( toolButton81, 2, 6 );

    toolButton80 = new MyToolButton( TabPage, "toolButton80" );
    toolButton80->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton80->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton80->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton80->setIconSet( QIcon( image80 ) );

    layout7->addWidget( toolButton80, 2, 5 );

    toolButton79 = new MyToolButton( TabPage, "toolButton79" );
    toolButton79->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton79->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton79->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton79->setIconSet( QIcon( image81 ) );

    layout7->addWidget( toolButton79, 2, 4 );

    toolButton78 = new MyToolButton( TabPage, "toolButton78" );
    toolButton78->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton78->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton78->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton78->setIconSet( QIcon( image82 ) );

    layout7->addWidget( toolButton78, 2, 3 );

    toolButton77 = new MyToolButton( TabPage, "toolButton77" );
    toolButton77->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton77->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton77->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton77->setIconSet( QIcon( image83 ) );

    layout7->addWidget( toolButton77, 2, 2 );

    toolButton76 = new MyToolButton( TabPage, "toolButton76" );
    toolButton76->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton76->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton76->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton76->setIconSet( QIcon( image84 ) );

    layout7->addWidget( toolButton76, 2, 1 );

    toolButton75 = new MyToolButton( TabPage, "toolButton75" );
    toolButton75->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton75->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton75->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton75->setIconSet( QIcon( image85 ) );

    layout7->addWidget( toolButton75, 2, 0 );

    toolButton74 = new MyToolButton( TabPage, "toolButton74" );
    toolButton74->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton74->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton74->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton74->setIconSet( QIcon( image86 ) );

    layout7->addWidget( toolButton74, 1, 7 );

    toolButton73 = new MyToolButton( TabPage, "toolButton73" );
    toolButton73->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton73->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton73->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton73->setIconSet( QIcon( image87 ) );

    layout7->addWidget( toolButton73, 1, 6 );

    toolButton72 = new MyToolButton( TabPage, "toolButton72" );
    toolButton72->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton72->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton72->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton72->setIconSet( QIcon( image88 ) );

    layout7->addWidget( toolButton72, 1, 5 );

    toolButton71 = new MyToolButton( TabPage, "toolButton71" );
    toolButton71->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton71->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton71->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton71->setIconSet( QIcon( image89 ) );

    layout7->addWidget( toolButton71, 1, 4 );

    toolButton70 = new MyToolButton( TabPage, "toolButton70" );
    toolButton70->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton70->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton70->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton70->setIconSet( QIcon( image90 ) );

    layout7->addWidget( toolButton70, 1, 3 );

    toolButton69 = new MyToolButton( TabPage, "toolButton69" );
    toolButton69->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton69->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton69->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton69->setIconSet( QIcon( image91 ) );

    layout7->addWidget( toolButton69, 1, 2 );

    toolButton68 = new MyToolButton( TabPage, "toolButton68" );
    toolButton68->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton68->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton68->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton68->setIconSet( QIcon( image92 ) );

    layout7->addWidget( toolButton68, 1, 1 );

    toolButton67 = new MyToolButton( TabPage, "toolButton67" );
    toolButton67->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton67->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton67->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton67->setIconSet( QIcon( image93 ) );

    layout7->addWidget( toolButton67, 1, 0 );

    toolButton66 = new MyToolButton( TabPage, "toolButton66" );
    toolButton66->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton66->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton66->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton66->setIconSet( QIcon( image94 ) );

    layout7->addWidget( toolButton66, 0, 7 );

    toolButton65 = new MyToolButton( TabPage, "toolButton65" );
    toolButton65->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton65->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton65->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton65->setIconSet( QIcon( image95 ) );

    layout7->addWidget( toolButton65, 0, 6 );

    toolButton64 = new MyToolButton( TabPage, "toolButton64" );
    toolButton64->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton64->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton64->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton64->setIconSet( QIcon( image96 ) );

    layout7->addWidget( toolButton64, 0, 5 );

    toolButton63 = new MyToolButton( TabPage, "toolButton63" );
    toolButton63->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton63->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton63->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton63->setIconSet( QIcon( image97 ) );

    layout7->addWidget( toolButton63, 0, 4 );

    toolButton62 = new MyToolButton( TabPage, "toolButton62" );
    toolButton62->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton62->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton62->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton62->setIconSet( QIcon( image98 ) );

    layout7->addWidget( toolButton62, 0, 3 );

    toolButton61 = new MyToolButton( TabPage, "toolButton61" );
    toolButton61->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton61->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton61->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton61->setIconSet( QIcon( image99 ) );

    layout7->addWidget( toolButton61, 0, 2 );

    toolButton60 = new MyToolButton( TabPage, "toolButton60" );
    toolButton60->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton60->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton60->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton60->setIconSet( QIcon( image100 ) );

    layout7->addWidget( toolButton60, 0, 1 );

    toolButton59 = new MyToolButton( TabPage, "toolButton59" );
    toolButton59->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton59->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton59->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton59->setIconSet( QIcon( image101 ) );

    layout7->addWidget( toolButton59, 0, 0 );

    toolButton83 = new MyToolButton( TabPage, "toolButton83" );
    toolButton83->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton83->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton83->setBackgroundOrigin( MyToolButton::ParentOrigin );
    toolButton83->setIconSet( QIcon( image102 ) );

    layout7->addWidget( toolButton83, 3, 0 );

    toolButton164 = new MyToolButton( TabPage, "toolButton164" );
    toolButton164->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton164->setIconSet( QIcon( image103 ) );

    layout7->addWidget( toolButton164, 3, 1 );

    toolButton165 = new MyToolButton( TabPage, "toolButton165" );
    toolButton165->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton165->setIconSet( QIcon( image104 ) );

    layout7->addWidget( toolButton165, 3, 2 );

    toolButton166 = new MyToolButton( TabPage, "toolButton166" );
    toolButton166->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton166->setIconSet( QIcon( image105 ) );

    layout7->addWidget( toolButton166, 3, 3 );

    toolButton167 = new MyToolButton( TabPage, "toolButton167" );
    toolButton167->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton167->setIconSet( QIcon( image106 ) );

    layout7->addWidget( toolButton167, 3, 4 );

    toolButton168 = new MyToolButton( TabPage, "toolButton168" );
    toolButton168->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton168->setIconSet( QIcon( image107 ) );

    layout7->addWidget( toolButton168, 3, 5 );

    toolButton169 = new MyToolButton( TabPage, "toolButton169" );
    toolButton169->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton169->setIconSet( QIcon( image108 ) );

    layout7->addWidget( toolButton169, 3, 6 );

    toolButton170 = new MyToolButton( TabPage, "toolButton170" );
    toolButton170->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton170->setIconSet( QIcon( image109 ) );

    layout7->addWidget( toolButton170, 3, 7 );
    layout8->addLayout( layout7 );
    spacer7 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout8->addItem( spacer7 );
    layout9->addLayout( layout8 );
    spacer8 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    layout9->addItem( spacer8 );
    TabPageLayout->addLayout( layout9 );
    tabWidget->insertTab( TabPage, QString::fromLatin1("") );

    TabPage_2 = new QWidget( tabWidget, "TabPage_2" );
    TabPageLayout_2 = new Q3VBoxLayout( TabPage_2, 11, 6, "TabPageLayout_2"); 

    layout15 = new Q3VBoxLayout( 0, 0, 6, "layout15"); 

    layout14 = new Q3HBoxLayout( 0, 0, 6, "layout14"); 
    spacer17 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout14->addItem( spacer17 );

    layout13 = new Q3GridLayout( 0, 1, 1, 0, 6, "layout13"); 

    toolButton112 = new MyToolButton( TabPage_2, "toolButton112" );
    toolButton112->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton112->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton112->setIconSet( QIcon( image110 ) );

    layout13->addWidget( toolButton112, 0, 0 );

    toolButton113 = new MyToolButton( TabPage_2, "toolButton113" );
    toolButton113->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton113->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton113->setIconSet( QIcon( image111 ) );

    layout13->addWidget( toolButton113, 0, 1 );

    toolButton114 = new MyToolButton( TabPage_2, "toolButton114" );
    toolButton114->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton114->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton114->setIconSet( QIcon( image112 ) );

    layout13->addWidget( toolButton114, 0, 2 );

    toolButton115 = new MyToolButton( TabPage_2, "toolButton115" );
    toolButton115->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton115->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton115->setIconSet( QIcon( image113 ) );

    layout13->addWidget( toolButton115, 0, 3 );

    toolButton116 = new MyToolButton( TabPage_2, "toolButton116" );
    toolButton116->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton116->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton116->setIconSet( QIcon( image114 ) );

    layout13->addWidget( toolButton116, 0, 4 );

    toolButton117 = new MyToolButton( TabPage_2, "toolButton117" );
    toolButton117->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton117->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton117->setIconSet( QIcon( image115 ) );

    layout13->addWidget( toolButton117, 0, 5 );

    toolButton118 = new MyToolButton( TabPage_2, "toolButton118" );
    toolButton118->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton118->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton118->setIconSet( QIcon( image116 ) );

    layout13->addWidget( toolButton118, 0, 6 );

    toolButton119 = new MyToolButton( TabPage_2, "toolButton119" );
    toolButton119->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton119->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton119->setIconSet( QIcon( image117 ) );

    layout13->addWidget( toolButton119, 0, 7 );

    toolButton120 = new MyToolButton( TabPage_2, "toolButton120" );
    toolButton120->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton120->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton120->setIconSet( QIcon( image118 ) );

    layout13->addWidget( toolButton120, 1, 0 );

    toolButton140 = new MyToolButton( TabPage_2, "toolButton140" );
    toolButton140->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton140->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton140->setIconSet( QIcon( image119 ) );

    layout13->addWidget( toolButton140, 1, 1 );

    toolButton143 = new MyToolButton( TabPage_2, "toolButton143" );
    toolButton143->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton143->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton143->setIconSet( QIcon( image120 ) );

    layout13->addWidget( toolButton143, 1, 2 );

    toolButton144 = new MyToolButton( TabPage_2, "toolButton144" );
    toolButton144->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton144->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton144->setIconSet( QIcon( image121 ) );

    layout13->addWidget( toolButton144, 1, 3 );

    toolButton171 = new MyToolButton( TabPage_2, "toolButton171" );
    toolButton171->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton171->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton171->setIconSet( QIcon( image122 ) );

    layout13->addWidget( toolButton171, 1, 4 );

    toolButton172 = new MyToolButton( TabPage_2, "toolButton172" );
    toolButton172->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton172->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton172->setIconSet( QIcon( image123 ) );

    layout13->addWidget( toolButton172, 1, 5 );

    toolButton173 = new MyToolButton( TabPage_2, "toolButton173" );
    toolButton173->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton173->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton173->setIconSet( QIcon( image124 ) );

    layout13->addWidget( toolButton173, 1, 6 );

    toolButton174 = new MyToolButton( TabPage_2, "toolButton174" );
    toolButton174->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton174->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton174->setIconSet( QIcon( image125 ) );

    layout13->addWidget( toolButton174, 1, 7 );

    toolButton175 = new MyToolButton( TabPage_2, "toolButton175" );
    toolButton175->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton175->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton175->setIconSet( QIcon( image126 ) );

    layout13->addWidget( toolButton175, 2, 0 );

    toolButton176 = new MyToolButton( TabPage_2, "toolButton176" );
    toolButton176->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton176->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton176->setIconSet( QIcon( image127 ) );

    layout13->addWidget( toolButton176, 2, 1 );

    toolButton177 = new MyToolButton( TabPage_2, "toolButton177" );
    toolButton177->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton177->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton177->setIconSet( QIcon( image128 ) );

    layout13->addWidget( toolButton177, 2, 2 );

    toolButton178 = new MyToolButton( TabPage_2, "toolButton178" );
    toolButton178->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton178->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton178->setIconSet( QIcon( image129 ) );

    layout13->addWidget( toolButton178, 2, 3 );

    toolButton179 = new MyToolButton( TabPage_2, "toolButton179" );
    toolButton179->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton179->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton179->setIconSet( QIcon( image130 ) );

    layout13->addWidget( toolButton179, 2, 4 );

    toolButton180 = new MyToolButton( TabPage_2, "toolButton180" );
    toolButton180->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton180->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton180->setIconSet( QIcon( image131 ) );

    layout13->addWidget( toolButton180, 2, 5 );

    toolButton181 = new MyToolButton( TabPage_2, "toolButton181" );
    toolButton181->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton181->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton181->setIconSet( QIcon( image132 ) );

    layout13->addWidget( toolButton181, 2, 6 );

    toolButton182 = new MyToolButton( TabPage_2, "toolButton182" );
    toolButton182->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton182->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton182->setIconSet( QIcon( image133 ) );

    layout13->addWidget( toolButton182, 2, 7 );

    toolButton183 = new MyToolButton( TabPage_2, "toolButton183" );
    toolButton183->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton183->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton183->setIconSet( QIcon( image134 ) );

    layout13->addWidget( toolButton183, 3, 0 );

    toolButton184 = new MyToolButton( TabPage_2, "toolButton184" );
    toolButton184->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton184->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton184->setIconSet( QIcon( image135 ) );

    layout13->addWidget( toolButton184, 3, 1 );

    toolButton185 = new MyToolButton( TabPage_2, "toolButton185" );
    toolButton185->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton185->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton185->setIconSet( QIcon( image136 ) );

    layout13->addWidget( toolButton185, 3, 2 );

    toolButton186 = new MyToolButton( TabPage_2, "toolButton186" );
    toolButton186->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton186->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton186->setIconSet( QIcon( image137 ) );

    layout13->addWidget( toolButton186, 3, 3 );

    toolButton187 = new MyToolButton( TabPage_2, "toolButton187" );
    toolButton187->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton187->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton187->setIconSet( QIcon( image138 ) );

    layout13->addWidget( toolButton187, 3, 4 );
    layout14->addLayout( layout13 );
    spacer11 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout14->addItem( spacer11 );
    layout15->addLayout( layout14 );
    spacer12 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    layout15->addItem( spacer12 );
    TabPageLayout_2->addLayout( layout15 );
    tabWidget->insertTab( TabPage_2, QString::fromLatin1("") );

    TabPage_3 = new QWidget( tabWidget, "TabPage_3" );
    TabPageLayout_3 = new Q3VBoxLayout( TabPage_3, 11, 6, "TabPageLayout_3"); 

    layout12 = new Q3VBoxLayout( 0, 0, 6, "layout12"); 

    layout11 = new Q3HBoxLayout( 0, 0, 6, "layout11"); 
    spacer18 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout11->addItem( spacer18 );

    layout10 = new Q3GridLayout( 0, 1, 1, 0, 6, "layout10"); 

    toolButton84 = new MyToolButton( TabPage_3, "toolButton84" );
    toolButton84->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton84->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton84->setIconSet( QIcon( image139 ) );

    layout10->addWidget( toolButton84, 0, 0 );

    toolButton88 = new MyToolButton( TabPage_3, "toolButton88" );
    toolButton88->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton88->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton88->setIconSet( QIcon( image140 ) );

    layout10->addWidget( toolButton88, 0, 4 );

    toolButton127 = new MyToolButton( TabPage_3, "toolButton127" );
    toolButton127->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton127->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton127->setIconSet( QIcon( image141 ) );

    layout10->addWidget( toolButton127, 4, 2 );

    toolButton128 = new MyToolButton( TabPage_3, "toolButton128" );
    toolButton128->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton128->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton128->setIconSet( QIcon( image142 ) );

    layout10->addWidget( toolButton128, 4, 3 );

    toolButton106 = new MyToolButton( TabPage_3, "toolButton106" );
    toolButton106->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton106->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton106->setIconSet( QIcon( image143 ) );

    layout10->addWidget( toolButton106, 2, 6 );

    toolButton108 = new MyToolButton( TabPage_3, "toolButton108" );
    toolButton108->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton108->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton108->setIconSet( QIcon( image144 ) );

    layout10->addWidget( toolButton108, 3, 0 );

    toolButton129 = new MyToolButton( TabPage_3, "toolButton129" );
    toolButton129->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton129->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton129->setIconSet( QIcon( image145 ) );

    layout10->addWidget( toolButton129, 4, 4 );

    toolButton126 = new MyToolButton( TabPage_3, "toolButton126" );
    toolButton126->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton126->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton126->setIconSet( QIcon( image146 ) );

    layout10->addWidget( toolButton126, 4, 1 );

    toolButton95 = new MyToolButton( TabPage_3, "toolButton95" );
    toolButton95->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton95->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton95->setIconSet( QIcon( image147 ) );

    layout10->addWidget( toolButton95, 1, 3 );

    toolButton94 = new MyToolButton( TabPage_3, "toolButton94" );
    toolButton94->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton94->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton94->setIconSet( QIcon( image148 ) );

    layout10->addWidget( toolButton94, 1, 2 );

    toolButton124 = new MyToolButton( TabPage_3, "toolButton124" );
    toolButton124->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton124->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton124->setIconSet( QIcon( image149 ) );

    layout10->addWidget( toolButton124, 3, 7 );

    toolButton85 = new MyToolButton( TabPage_3, "toolButton85" );
    toolButton85->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton85->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton85->setIconSet( QIcon( image150 ) );

    layout10->addWidget( toolButton85, 0, 1 );

    toolButton99 = new MyToolButton( TabPage_3, "toolButton99" );
    toolButton99->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton99->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton99->setIconSet( QIcon( image151 ) );

    layout10->addWidget( toolButton99, 1, 7 );

    toolButton125 = new MyToolButton( TabPage_3, "toolButton125" );
    toolButton125->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton125->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton125->setIconSet( QIcon( image152 ) );

    layout10->addWidget( toolButton125, 4, 0 );

    toolButton109 = new MyToolButton( TabPage_3, "toolButton109" );
    toolButton109->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton109->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton109->setIconSet( QIcon( image153 ) );

    layout10->addWidget( toolButton109, 3, 1 );

    toolButton97 = new MyToolButton( TabPage_3, "toolButton97" );
    toolButton97->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton97->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton97->setIconSet( QIcon( image154 ) );

    layout10->addWidget( toolButton97, 1, 5 );

    toolButton121 = new MyToolButton( TabPage_3, "toolButton121" );
    toolButton121->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton121->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton121->setIconSet( QIcon( image155 ) );

    layout10->addWidget( toolButton121, 3, 4 );

    toolButton101 = new MyToolButton( TabPage_3, "toolButton101" );
    toolButton101->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton101->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton101->setIconSet( QIcon( image156 ) );

    layout10->addWidget( toolButton101, 2, 1 );

    toolButton87 = new MyToolButton( TabPage_3, "toolButton87" );
    toolButton87->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton87->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton87->setIconSet( QIcon( image157 ) );

    layout10->addWidget( toolButton87, 0, 3 );

    toolButton110 = new MyToolButton( TabPage_3, "toolButton110" );
    toolButton110->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton110->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton110->setIconSet( QIcon( image158 ) );

    layout10->addWidget( toolButton110, 3, 2 );

    toolButton93 = new MyToolButton( TabPage_3, "toolButton93" );
    toolButton93->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton93->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton93->setIconSet( QIcon( image159 ) );

    layout10->addWidget( toolButton93, 1, 1 );

    toolButton103 = new MyToolButton( TabPage_3, "toolButton103" );
    toolButton103->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton103->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton103->setIconSet( QIcon( image160 ) );

    layout10->addWidget( toolButton103, 2, 3 );

    toolButton96 = new MyToolButton( TabPage_3, "toolButton96" );
    toolButton96->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton96->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton96->setIconSet( QIcon( image161 ) );

    layout10->addWidget( toolButton96, 1, 4 );

    toolButton105 = new MyToolButton( TabPage_3, "toolButton105" );
    toolButton105->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton105->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton105->setIconSet( QIcon( image162 ) );

    layout10->addWidget( toolButton105, 2, 5 );

    toolButton98 = new MyToolButton( TabPage_3, "toolButton98" );
    toolButton98->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton98->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton98->setIconSet( QIcon( image163 ) );

    layout10->addWidget( toolButton98, 1, 6 );

    toolButton86 = new MyToolButton( TabPage_3, "toolButton86" );
    toolButton86->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton86->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton86->setIconSet( QIcon( image164 ) );

    layout10->addWidget( toolButton86, 0, 2 );

    toolButton123 = new MyToolButton( TabPage_3, "toolButton123" );
    toolButton123->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton123->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton123->setIconSet( QIcon( image165 ) );

    layout10->addWidget( toolButton123, 3, 6 );

    toolButton102 = new MyToolButton( TabPage_3, "toolButton102" );
    toolButton102->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton102->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton102->setIconSet( QIcon( image166 ) );

    layout10->addWidget( toolButton102, 2, 2 );

    toolButton100 = new MyToolButton( TabPage_3, "toolButton100" );
    toolButton100->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton100->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton100->setIconSet( QIcon( image167 ) );

    layout10->addWidget( toolButton100, 2, 0 );

    toolButton111 = new MyToolButton( TabPage_3, "toolButton111" );
    toolButton111->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton111->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton111->setIconSet( QIcon( image168 ) );

    layout10->addWidget( toolButton111, 3, 3 );

    toolButton90 = new MyToolButton( TabPage_3, "toolButton90" );
    toolButton90->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton90->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton90->setIconSet( QIcon( image169 ) );

    layout10->addWidget( toolButton90, 0, 6 );

    toolButton122 = new MyToolButton( TabPage_3, "toolButton122" );
    toolButton122->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton122->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton122->setIconSet( QIcon( image170 ) );

    layout10->addWidget( toolButton122, 3, 5 );

    toolButton92 = new MyToolButton( TabPage_3, "toolButton92" );
    toolButton92->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton92->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton92->setIconSet( QIcon( image171 ) );

    layout10->addWidget( toolButton92, 1, 0 );

    toolButton107 = new MyToolButton( TabPage_3, "toolButton107" );
    toolButton107->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton107->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton107->setIconSet( QIcon( image172 ) );

    layout10->addWidget( toolButton107, 2, 7 );

    toolButton91 = new MyToolButton( TabPage_3, "toolButton91" );
    toolButton91->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton91->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton91->setIconSet( QIcon( image173 ) );

    layout10->addWidget( toolButton91, 0, 7 );

    toolButton89 = new MyToolButton( TabPage_3, "toolButton89" );
    toolButton89->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton89->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton89->setIconSet( QIcon( image174 ) );

    layout10->addWidget( toolButton89, 0, 5 );

    toolButton104 = new MyToolButton( TabPage_3, "toolButton104" );
    toolButton104->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton104->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton104->setIconSet( QIcon( image175 ) );

    layout10->addWidget( toolButton104, 2, 4 );

    toolButton188 = new MyToolButton( TabPage_3, "toolButton188" );
    toolButton188->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton188->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton188->setIconSet( QIcon( image176 ) );

    layout10->addWidget( toolButton188, 4, 5 );

    toolButton189 = new MyToolButton( TabPage_3, "toolButton189" );
    toolButton189->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton189->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton189->setIconSet( QIcon( image177 ) );

    layout10->addWidget( toolButton189, 4, 6 );

    toolButton190 = new MyToolButton( TabPage_3, "toolButton190" );
    toolButton190->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton190->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton190->setIconSet( QIcon( image178 ) );

    layout10->addWidget( toolButton190, 4, 7 );

    toolButton191 = new MyToolButton( TabPage_3, "toolButton191" );
    toolButton191->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton191->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton191->setIconSet( QIcon( image179 ) );

    layout10->addWidget( toolButton191, 5, 0 );

    toolButton192 = new MyToolButton( TabPage_3, "toolButton192" );
    toolButton192->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton192->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton192->setIconSet( QIcon( image180 ) );

    layout10->addWidget( toolButton192, 5, 1 );

    toolButton193 = new MyToolButton( TabPage_3, "toolButton193" );
    toolButton193->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton193->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton193->setIconSet( QIcon( image181 ) );

    layout10->addWidget( toolButton193, 5, 2 );

    toolButton194 = new MyToolButton( TabPage_3, "toolButton194" );
    toolButton194->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton194->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton194->setIconSet( QIcon( image182 ) );

    layout10->addWidget( toolButton194, 5, 3 );

    toolButton195 = new MyToolButton( TabPage_3, "toolButton195" );
    toolButton195->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton195->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton195->setIconSet( QIcon( image183 ) );

    layout10->addWidget( toolButton195, 5, 4 );

    toolButton196 = new MyToolButton( TabPage_3, "toolButton196" );
    toolButton196->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton196->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton196->setIconSet( QIcon( image184 ) );

    layout10->addWidget( toolButton196, 5, 5 );

    toolButton197 = new MyToolButton( TabPage_3, "toolButton197" );
    toolButton197->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton197->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton197->setIconSet( QIcon( image185 ) );

    layout10->addWidget( toolButton197, 5, 6 );

    toolButton198 = new MyToolButton( TabPage_3, "toolButton198" );
    toolButton198->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton198->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton198->setIconSet( QIcon( image186 ) );

    layout10->addWidget( toolButton198, 5, 7 );

    toolButton199 = new MyToolButton( TabPage_3, "toolButton199" );
    toolButton199->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton199->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton199->setIconSet( QIcon( image187 ) );

    layout10->addWidget( toolButton199, 6, 0 );

    toolButton200 = new MyToolButton( TabPage_3, "toolButton200" );
    toolButton200->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton200->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton200->setIconSet( QIcon( image188 ) );

    layout10->addWidget( toolButton200, 6, 1 );
    layout11->addLayout( layout10 );
    spacer9 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout11->addItem( spacer9 );
    layout12->addLayout( layout11 );
    spacer3 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    layout12->addItem( spacer3 );
    TabPageLayout_3->addLayout( layout12 );
    tabWidget->insertTab( TabPage_3, QString::fromLatin1("") );

    TabPage_4 = new QWidget( tabWidget, "TabPage_4" );
    TabPageLayout_4 = new Q3VBoxLayout( TabPage_4, 11, 6, "TabPageLayout_4"); 

    layout18 = new Q3VBoxLayout( 0, 0, 6, "layout18"); 

    layout17 = new Q3HBoxLayout( 0, 0, 6, "layout17"); 
    spacer19 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout17->addItem( spacer19 );

    layout16 = new Q3GridLayout( 0, 1, 1, 0, 6, "layout16"); 

    toolButton142 = new MyToolButton( TabPage_4, "toolButton142" );
    toolButton142->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton142->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton142->setIconSet( QIcon( image189 ) );

    layout16->addWidget( toolButton142, 1, 1 );

    toolButton141 = new MyToolButton( TabPage_4, "toolButton141" );
    toolButton141->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton141->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton141->setIconSet( QIcon( image190 ) );

    layout16->addWidget( toolButton141, 1, 0 );

    toolButton133 = new MyToolButton( TabPage_4, "toolButton133" );
    toolButton133->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton133->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton133->setIconSet( QIcon( image191 ) );

    layout16->addWidget( toolButton133, 0, 1 );

    toolButton137 = new MyToolButton( TabPage_4, "toolButton137" );
    toolButton137->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton137->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton137->setIconSet( QIcon( image192 ) );

    layout16->addWidget( toolButton137, 0, 5 );

    toolButton132 = new MyToolButton( TabPage_4, "toolButton132" );
    toolButton132->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton132->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton132->setIconSet( QIcon( image193 ) );

    layout16->addWidget( toolButton132, 0, 0 );

    toolButton138 = new MyToolButton( TabPage_4, "toolButton138" );
    toolButton138->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton138->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton138->setIconSet( QIcon( image194 ) );

    layout16->addWidget( toolButton138, 0, 6 );

    toolButton135 = new MyToolButton( TabPage_4, "toolButton135" );
    toolButton135->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton135->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton135->setIconSet( QIcon( image195 ) );

    layout16->addWidget( toolButton135, 0, 3 );

    toolButton139 = new MyToolButton( TabPage_4, "toolButton139" );
    toolButton139->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton139->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton139->setIconSet( QIcon( image196 ) );

    layout16->addWidget( toolButton139, 0, 7 );

    toolButton134 = new MyToolButton( TabPage_4, "toolButton134" );
    toolButton134->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton134->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton134->setIconSet( QIcon( image197 ) );

    layout16->addWidget( toolButton134, 0, 2 );

    toolButton136 = new MyToolButton( TabPage_4, "toolButton136" );
    toolButton136->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton136->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton136->setIconSet( QIcon( image198 ) );

    layout16->addWidget( toolButton136, 0, 4 );

    toolButton201 = new MyToolButton( TabPage_4, "toolButton201" );
    toolButton201->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton201->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton201->setIconSet( QIcon( image199 ) );

    layout16->addWidget( toolButton201, 1, 2 );

    toolButton130 = new MyToolButton( TabPage_4, "toolButton130" );
    toolButton130->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton130->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton130->setIconSet( QIcon( image200 ) );

    layout16->addWidget( toolButton130, 1, 3 );

    toolButton131 = new MyToolButton( TabPage_4, "toolButton131" );
    toolButton131->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton131->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton131->setIconSet( QIcon( image201 ) );

    layout16->addWidget( toolButton131, 1, 4 );

    toolButton202 = new MyToolButton( TabPage_4, "toolButton202" );
    toolButton202->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton202->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton202->setIconSet( QIcon( image202 ) );

    layout16->addWidget( toolButton202, 1, 5 );

    toolButton203 = new MyToolButton( TabPage_4, "toolButton203" );
    toolButton203->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton203->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton203->setIconSet( QIcon( image203 ) );

    layout16->addWidget( toolButton203, 1, 6 );

    toolButton204 = new MyToolButton( TabPage_4, "toolButton204" );
    toolButton204->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton204->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton204->setIconSet( QIcon( image204 ) );

    layout16->addWidget( toolButton204, 1, 7 );

    toolButton205 = new MyToolButton( TabPage_4, "toolButton205" );
    toolButton205->setPaletteForegroundColor( QColor( 255, 255, 255 ) );
    toolButton205->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    toolButton205->setIconSet( QIcon( image205 ) );

    layout16->addWidget( toolButton205, 2, 0 );
    layout17->addLayout( layout16 );
    spacer10 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout17->addItem( spacer10 );
    layout18->addLayout( layout17 );
    spacer4 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    layout18->addItem( spacer4 );
    TabPageLayout_4->addLayout( layout18 );
    tabWidget->insertTab( TabPage_4, QString::fromLatin1("") );

    languageChange();
    resize( QSize(304, 270).expandedTo(minimumSizeHint()) );
    //clearWState( WState_Polished );
}

/*
 *  Destroys the object and frees any allocated resources
 */
MyDialog1::~MyDialog1()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void MyDialog1::languageChange()
{
    setCaption( trUtf8( "\xec\x9d\xb4\xeb\xaa\xa8\xed\x8b\xb0\xec\xbd\x98" ) );
    toolButton4->setText( QString::null );
    QToolTip::add( toolButton4, trUtf8( "\x2f\xec\x9c\x99\xed\x81\xac\x2f" ) );
    toolButton21->setText( QString::null );
    QToolTip::add( toolButton21, trUtf8( "\x2f\xec\xb7\xa8\xed\x95\xa8\x2f" ) );
    toolButton7->setText( QString::null );
    QToolTip::add( toolButton7, trUtf8( "\x2f\xec\x95\x88\xeb\x85\x95\x2f" ) );
    toolButton37->setText( QString::null );
    QToolTip::add( toolButton37, trUtf8( "\x2f\xec\x9c\xbc\xec\x9c\xbc\x2f" ) );
    toolButton39->setText( QString::null );
    QToolTip::add( toolButton39, trUtf8( "\x2f\xed\x97\x88\xea\xb1\xb1\x2f" ) );
    toolButton31->setText( QString::null );
    QToolTip::add( toolButton31, trUtf8( "\x2f\xea\xb8\xb0\xeb\x8f\x84\x2f" ) );
    toolButton13->setText( QString::null );
    QToolTip::add( toolButton13, trUtf8( "\x2f\xec\x97\x90\xed\x97\xb4\x2f" ) );
    toolButton6->setText( QString::null );
    QToolTip::add( toolButton6, trUtf8( "\x2f\xeb\xa7\x8c\xec\xa1\xb1\x2f" ) );
    toolButton19->setText( QString::null );
    QToolTip::add( toolButton19, trUtf8( "\x2f\xec\x9e\xa0\x2f" ) );
    toolButton16->setText( QString::null );
    QToolTip::add( toolButton16, trUtf8( "\x2f\xec\x8a\xac\xed\x94\x94\x2f" ) );
    toolButton38->setText( QString::null );
    QToolTip::add( toolButton38, trUtf8( "\x2f\xed\x95\x9c\xec\x88\xa8\x2f" ) );
    toolButton34->setText( QString::null );
    QToolTip::add( toolButton34, trUtf8( "\x2f\xec\x89\xbf\x2f" ) );
    toolButton9->setText( QString::null );
    QToolTip::add( toolButton9, trUtf8( "\x2f\xeb\x98\xa5\xec\xb9\xa8\x2f" ) );
    toolButton27->setText( QString::null );
    QToolTip::add( toolButton27, trUtf8( "\x2f\xec\xb6\x94\xec\x9b\x8c\x2f" ) );
    toolButton12->setText( QString::null );
    QToolTip::add( toolButton12, trUtf8( "\x2f\xeb\x83\x89\xeb\x9e\xad\x2f" ) );
    toolButton36->setText( QString::null );
    QToolTip::add( toolButton36, trUtf8( "\x2f\xec\x9a\xb0\xec\x9a\xb0\x2f" ) );
    toolButton3->setText( QString::null );
    QToolTip::add( toolButton3, trUtf8( "\x2f\xec\xa7\xb1\x2f" ) );
    toolButton23->setText( QString::null );
    QToolTip::add( toolButton23, trUtf8( "\x2f\xeb\xb2\x84\xeb\x9f\xad\x2f" ) );
    toolButton35->setText( QString::null );
    QToolTip::add( toolButton35, trUtf8( "\x2f\xec\x9a\xb0\xec\x94\xa8\x2f" ) );
    toolButton32->setText( QString::null );
    QToolTip::add( toolButton32, trUtf8( "\x2f\xeb\x95\x80\xec\xb0\x8d\x2f" ) );
    toolButton29->setText( QString::null );
    QToolTip::add( toolButton29, trUtf8( "\x2f\xeb\x98\x98\xeb\x98\x98\x2f" ) );
    toolButton22->setText( QString::null );
    QToolTip::add( toolButton22, trUtf8( "\x2f\xec\x9b\xa9\x2f" ) );
    toolButton1->setText( QString::null );
    QToolTip::add( toolButton1, trUtf8( "\x2f\xed\x8c\x8c\xec\x95\x88\x2f" ) );
    toolButton26->setText( QString::null );
    QToolTip::add( toolButton26, trUtf8( "\x2f\xec\x97\xb4\x2f" ) );
    toolButton18->setText( QString::null );
    QToolTip::add( toolButton18, trUtf8( "\x2f\xed\x8f\x90\xec\x9d\xb8\x2f" ) );
    toolButton33->setText( QString::null );
    QToolTip::add( toolButton33, trUtf8( "\x2f\xeb\xb0\x95\xec\x88\x98\x2f" ) );
    toolButton10->setText( QString::null );
    QToolTip::add( toolButton10, trUtf8( "\x2f\xeb\xa9\x94\xeb\xa1\xb1\x2f" ) );
    toolButton42->setText( QString::null );
    QToolTip::add( toolButton42, trUtf8( "\x2f\xeb\x94\xb4\xec\xb2\xad\x2f" ) );
    toolButton40->setText( QString::null );
    QToolTip::add( toolButton40, trUtf8( "\x2f\xed\x97\x98\xec\x95\x85\x2f" ) );
    toolButton17->setText( QString::null );
    QToolTip::add( toolButton17, trUtf8( "\x2f\xed\x86\xb5\xea\xb3\xa1\x2f" ) );
    toolButton41->setText( QString::null );
    QToolTip::add( toolButton41, trUtf8( "\x2f\xed\x9d\x90\xed\x9d\x90\x2f" ) );
    toolButton8->setText( QString::null );
    QToolTip::add( toolButton8, trUtf8( "\x2f\xeb\xb6\x80\xeb\x81\x84\x2f" ) );
    toolButton24->setText( QString::null );
    QToolTip::add( toolButton24, trUtf8( "\x2f\xec\xb3\x87\x2f" ) );
    toolButton2->setText( QString::null );
    QToolTip::add( toolButton2, trUtf8( "\x2f\xeb\xb0\xa9\xea\xb8\x8b\x2f" ) );
    toolButton15->setText( QString::null );
    QToolTip::add( toolButton15, trUtf8( "\x2f\xeb\x8b\xb9\xed\x99\xa9\x2f" ) );
    toolButton14->setText( QString::null );
    QToolTip::add( toolButton14, trUtf8( "\x2f\xec\x8b\xa4\xeb\xa7\x9d\x2f" ) );
    toolButton5->setText( QString::null );
    QToolTip::add( toolButton5, trUtf8( "\x2f\xec\x9d\x8c\xed\x9d\x89\x2f" ) );
    toolButton28->setText( QString::null );
    QToolTip::add( toolButton28, trUtf8( "\x2f\xeb\x86\x80\xeb\x9e\x8c\x2f" ) );
    toolButton25->setText( QString::null );
    QToolTip::add( toolButton25, trUtf8( "\x2f\xec\xb0\x8c\xeb\xa6\xbf\x2f" ) );
    toolButton20->setText( QString::null );
    QToolTip::add( toolButton20, trUtf8( "\x2f\xed\x89\xa4\x2f" ) );
    toolButton11->setText( QString::null );
    QToolTip::add( toolButton11, trUtf8( "\x2f\xeb\x8d\x94\xec\x9c\x84\x2f" ) );
    toolButton30->setText( QString::null );
    QToolTip::add( toolButton30, trUtf8( "\x2f\xea\xb1\xb0\xeb\xb6\x80\x2f" ) );
    toolButton145->setText( QString::null );
    QToolTip::add( toolButton145, trUtf8( "\x2f\xec\xaa\xbc\xec\x98\xa5\x2f" ) );
    toolButton146->setText( QString::null );
    QToolTip::add( toolButton146, trUtf8( "\x2f\xea\xb9\x94\xea\xb9\x94\x2f" ) );
    toolButton147->setText( QString::null );
    QToolTip::add( toolButton147, trUtf8( "\x2f\xec\x95\x84\xed\x9c\xb4\x2f" ) );
    toolButton148->setText( QString::null );
    QToolTip::add( toolButton148, trUtf8( "\x2f\xec\x98\xa4\xec\x9a\xb0\x2f" ) );
    toolButton149->setText( QString::null );
    QToolTip::add( toolButton149, trUtf8( "\x2f\xec\x97\x89\xec\x97\x89\x2f" ) );
    toolButton150->setText( QString::null );
    QToolTip::add( toolButton150, trUtf8( "\x2f\xeb\xbb\x90\xeb\x81\x94\x2f" ) );
    toolButton151->setText( QString::null );
    QToolTip::add( toolButton151, trUtf8( "\x2f\xed\x8c\x8c\xec\x9d\xb4\xed\x8c\x85\x2f" ) );
    toolButton152->setText( QString::null );
    QToolTip::add( toolButton152, trUtf8( "\x2f\xea\xb7\x80\xeb\xa7\x88\xea\xb0\x9c\x2f" ) );
    tabWidget->changeTab( Widget8, trUtf8( "\xea\xb0\x90\xec\xa0\x95" ) );
    toolButton57->setText( QString::null );
    QToolTip::add( toolButton57, trUtf8( "\x2f\xea\xb9\x80\xeb\xb0\xa5\x2f" ) );
    toolButton54->setText( QString::null );
    QToolTip::add( toolButton54, trUtf8( "\x2f\xeb\xb2\x84\xea\xb1\xb0\x2f" ) );
    toolButton47->setText( QString::null );
    QToolTip::add( toolButton47, trUtf8( "\x2f\xeb\xb0\xa5\x2f" ) );
    toolButton51->setText( QString::null );
    QToolTip::add( toolButton51, trUtf8( "\x2f\xec\x86\x8c\xec\xa3\xbc\x2f" ) );
    toolButton52->setText( QString::null );
    QToolTip::add( toolButton52, trUtf8( "\x2f\xec\xbc\x80\xec\x9d\xb5\x2f" ) );
    toolButton56->setText( QString::null );
    QToolTip::add( toolButton56, trUtf8( "\x2f\xeb\x8b\xb9\xea\xb7\xbc\x2f" ) );
    toolButton55->setText( QString::null );
    QToolTip::add( toolButton55, trUtf8( "\x2f\xec\x8b\x9d\xeb\xb9\xb5\x2f" ) );
    toolButton43->setText( QString::null );
    QToolTip::add( toolButton43, trUtf8( "\x2f\xec\xbb\xa4\xed\x94\xbc\x2f" ) );
    toolButton58->setText( QString::null );
    QToolTip::add( toolButton58, trUtf8( "\x2f\xeb\x9d\xbc\xeb\xa9\xb4\x2f" ) );
    toolButton44->setText( QString::null );
    QToolTip::add( toolButton44, trUtf8( "\x2f\xeb\x8f\x84\xeb\x84\x9b\x2f" ) );
    toolButton48->setText( QString::null );
    QToolTip::add( toolButton48, trUtf8( "\x2f\xeb\xb9\xb5\x2f" ) );
    toolButton45->setText( QString::null );
    QToolTip::add( toolButton45, trUtf8( "\x2f\xed\x81\xac\xeb\xa6\xbc\x2f" ) );
    toolButton53->setText( QString::null );
    QToolTip::add( toolButton53, trUtf8( "\x2f\xed\x94\xbc\xec\x9e\x90\x2f" ) );
    toolButton49->setText( QString::null );
    QToolTip::add( toolButton49, trUtf8( "\x2f\xec\x82\xac\xea\xb3\xbc\x2f" ) );
    toolButton50->setText( QString::null );
    QToolTip::add( toolButton50, trUtf8( "\x2f\xec\x82\xac\xed\x83\x95\x2f" ) );
    toolButton46->setText( QString::null );
    QToolTip::add( toolButton46, trUtf8( "\x2f\xeb\xa7\xa5\xec\xa3\xbc\x2f" ) );
    toolButton153->setText( QString::null );
    QToolTip::add( toolButton153, trUtf8( "\x2f\xeb\xb9\xbc\xeb\xb9\xbc\xeb\xa1\x9c\x2f" ) );
    toolButton154->setText( QString::null );
    QToolTip::add( toolButton154, trUtf8( "\x2f\xed\x98\xb8\xeb\xb9\xb5\x2f" ) );
    toolButton155->setText( QString::null );
    QToolTip::add( toolButton155, trUtf8( "\x2f\xec\x96\xb4\xeb\xac\xb5\x2f" ) );
    toolButton156->setText( QString::null );
    QToolTip::add( toolButton156, trUtf8( "\x2f\xeb\xb6\x95\xec\x96\xb4\xeb\xb9\xb5\x2f" ) );
    toolButton157->setText( QString::null );
    QToolTip::add( toolButton157, trUtf8( "\x2f\xec\xb4\x88\xec\xbd\x94\x2f" ) );
    toolButton158->setText( QString::null );
    QToolTip::add( toolButton158, trUtf8( "\x2f\xeb\x8f\x84\xed\x86\xa0\xeb\xa6\xac\x2f" ) );
    toolButton159->setText( QString::null );
    QToolTip::add( toolButton159, trUtf8( "\x2f\xec\xb9\x98\xed\x82\xa8\x2f" ) );
    toolButton160->setText( QString::null );
    QToolTip::add( toolButton160, trUtf8( "\x2f\xeb\x8b\xac\xea\xb1\x80\x2f" ) );
    toolButton161->setText( QString::null );
    QToolTip::add( toolButton161, trUtf8( "\x2f\xec\x98\xa4\xeb\xa0\x8c\xec\xa7\x80\x2f" ) );
    toolButton162->setText( QString::null );
    QToolTip::add( toolButton162, trUtf8( "\x2f\xed\x95\xab\xeb\x8f\x84\xea\xb7\xb8\x2f" ) );
    toolButton163->setText( QString::null );
    QToolTip::add( toolButton163, trUtf8( "\x2f\xec\x9e\x90\xec\x9e\xa5\xeb\xa9\xb4\x2f" ) );
    tabWidget->changeTab( Widget9, trUtf8( "\xec\x9d\x8c\xec\x8b\x9d" ) );
    toolButton82->setText( QString::null );
    QToolTip::add( toolButton82, trUtf8( "\x2f\xed\x8f\xad\xed\x83\x84\x2f" ) );
    toolButton81->setText( QString::null );
    QToolTip::add( toolButton81, trUtf8( "\x2f\xed\x8b\xb0\xeb\xb9\x84\x2f" ) );
    toolButton80->setText( QString::null );
    QToolTip::add( toolButton80, trUtf8( "\x2f\xec\x82\xac\xec\xa7\x84\x2f" ) );
    toolButton79->setText( QString::null );
    QToolTip::add( toolButton79, trUtf8( "\x2f\xec\xb0\xa8\x2f" ) );
    toolButton78->setText( QString::null );
    QToolTip::add( toolButton78, trUtf8( "\x2f\xec\xb4\x9b\xeb\xb6\x88\x2f" ) );
    toolButton77->setText( QString::null );
    QToolTip::add( toolButton77, trUtf8( "\x2f\xeb\x8b\xb4\xeb\xb0\xb0\x2f" ) );
    toolButton76->setText( QString::null );
    QToolTip::add( toolButton76, trUtf8( "\x2f\xeb\xa9\x94\xec\x9d\xbc\x2f" ) );
    toolButton75->setText( QString::null );
    QToolTip::add( toolButton75, trUtf8( "\x2f\xec\x95\xbd\x2f" ) );
    toolButton74->setText( QString::null );
    QToolTip::add( toolButton74, trUtf8( "\x2f\xec\x84\xa0\xeb\xac\xbc\x2f" ) );
    toolButton73->setText( QString::null );
    QToolTip::add( toolButton73, trUtf8( "\x2f\xed\x8f\xb0\x2f" ) );
    toolButton72->setText( QString::null );
    QToolTip::add( toolButton72, trUtf8( "\x2f\xec\xb4\x9d\x2f" ) );
    toolButton71->setText( QString::null );
    QToolTip::add( toolButton71, trUtf8( "\x2f\xeb\xa0\x88\xec\xb9\xb4\x2f" ) );
    toolButton70->setText( QString::null );
    QToolTip::add( toolButton70, trUtf8( "\x2f\xed\x83\x9c\xea\xb7\xb9\x2f" ) );
    toolButton69->setText( QString::null );
    QToolTip::add( toolButton69, trUtf8( "\x2f\xec\xa0\x84\xec\xb2\xa0\x2f" ) );
    toolButton68->setText( QString::null );
    QToolTip::add( toolButton68, trUtf8( "\x2f\xec\xbb\xb4\x2f" ) );
    toolButton67->setText( QString::null );
    QToolTip::add( toolButton67, trUtf8( "\x2f\xeb\xb2\x84\xec\x8a\xa4\x2f" ) );
    toolButton66->setText( QString::null );
    QToolTip::add( toolButton66, trUtf8( "\x2f\xed\x83\x9d\xec\x8b\x9c\x2f" ) );
    toolButton65->setText( QString::null );
    QToolTip::add( toolButton65, trUtf8( "\x2f\xeb\x8f\x8c\x2f" ) );
    toolButton64->setText( QString::null );
    QToolTip::add( toolButton64, trUtf8( "\x2f\xec\x98\x90\xec\xb9\xb4\x2f" ) );
    toolButton63->setText( QString::null );
    QToolTip::add( toolButton63, trUtf8( "\x2f\xeb\xb2\xbd\xeb\x8f\x8c\x2f" ) );
    toolButton62->setText( QString::null );
    QToolTip::add( toolButton62, trUtf8( "\x2f\xeb\xb0\x98\xec\xa7\x80\x2f" ) );
    toolButton61->setText( QString::null );
    QToolTip::add( toolButton61, trUtf8( "\x2f\xea\xbd\x83\x2f" ) );
    toolButton60->setText( QString::null );
    QToolTip::add( toolButton60, trUtf8( "\x2f\xec\xa0\x84\xed\x99\x94\x2f" ) );
    toolButton59->setText( QString::null );
    QToolTip::add( toolButton59, trUtf8( "\x2f\xec\x8b\x9c\xea\xb3\x84\x2f" ) );
    toolButton83->setText( QString::null );
    QToolTip::add( toolButton83, trUtf8( "\x2f\xec\x98\xa4\xeb\x9d\xbd\x2f" ) );
    toolButton164->setText( QString::null );
    QToolTip::add( toolButton164, trUtf8( "\x2f\xeb\xb9\x84\xed\x96\x89\xea\xb8\xb0\x2f" ) );
    toolButton165->setText( QString::null );
    QToolTip::add( toolButton165, trUtf8( "\x2f\xeb\xaa\xa8\xec\x9e\x90\x2f" ) );
    toolButton166->setText( QString::null );
    QToolTip::add( toolButton166, trUtf8( "\x2f\xec\x9e\xa5\xea\xb0\x91\x2f" ) );
    toolButton167->setText( QString::null );
    QToolTip::add( toolButton167, trUtf8( "\x2f\xeb\xa1\x9c\xec\xbc\x93\x2f" ) );
    toolButton168->setText( QString::null );
    QToolTip::add( toolButton168, trUtf8( "\x2f\xec\x9a\xb0\xec\xa3\xbc\xec\x84\xa0\x2f" ) );
    toolButton169->setText( QString::null );
    QToolTip::add( toolButton169, trUtf8( "\x2f\xec\xa3\xbc\xec\x82\xac\xec\x9c\x84\x2f" ) );
    toolButton170->setText( QString::null );
    QToolTip::add( toolButton170, trUtf8( "\x2f\xed\x8c\x8c\xeb\x9d\xbc\xec\x86\x94\x2f" ) );
    tabWidget->changeTab( TabPage, trUtf8( "\xec\x82\xac\xeb\xac\xbc" ) );
    toolButton112->setText( QString::null );
    QToolTip::add( toolButton112, trUtf8( "\x2f\xeb\xb6\x95\xec\x96\xb4\x2f" ) );
    toolButton113->setText( QString::null );
    QToolTip::add( toolButton113, trUtf8( "\x2f\xec\x9b\x90\xec\x88\xad\x2f" ) );
    toolButton114->setText( QString::null );
    QToolTip::add( toolButton114, trUtf8( "\x2f\xea\xb0\x9c\x2f" ) );
    toolButton115->setText( QString::null );
    QToolTip::add( toolButton115, trUtf8( "\x2f\xea\xb1\xb0\xeb\xb6\x81\x2f" ) );
    toolButton116->setText( QString::null );
    QToolTip::add( toolButton116, trUtf8( "\x2f\xeb\x82\x98\xeb\xb9\x84\x2f" ) );
    toolButton117->setText( QString::null );
    QToolTip::add( toolButton117, trUtf8( "\x2f\xeb\x8f\xbc\xec\xa7\x80\x2f" ) );
    toolButton118->setText( QString::null );
    QToolTip::add( toolButton118, trUtf8( "\x2f\xeb\xb0\x94\xed\x80\xb4\x2f" ) );
    toolButton119->setText( QString::null );
    QToolTip::add( toolButton119, trUtf8( "\x2f\xec\x83\x88\x2f" ) );
    toolButton120->setText( QString::null );
    QToolTip::add( toolButton120, trUtf8( "\x2f\xec\x95\xbc\xec\x98\xb9\x2f" ) );
    toolButton140->setText( QString::null );
    QToolTip::add( toolButton140, trUtf8( "\x2f\xea\xb9\x8c\xec\xb9\x98\x2f" ) );
    toolButton143->setText( QString::null );
    QToolTip::add( toolButton143, trUtf8( "\x2f\xec\x95\x84\xea\xb8\xb0\xeb\x8f\xbc\xec\xa7\x80\x2f" ) );
    toolButton144->setText( QString::null );
    QToolTip::add( toolButton144, trUtf8( "\x2f\xed\x99\xa9\xea\xb8\x88\xeb\x8f\xbc\xec\xa7\x80\x2f" ) );
    toolButton171->setText( QString::null );
    QToolTip::add( toolButton171, trUtf8( "\x2f\xec\xa5\x90\x2f" ) );
    toolButton172->setText( QString::null );
    QToolTip::add( toolButton172, trUtf8( "\x2f\xeb\x8b\xa4\xeb\x9e\x8c\xec\xa5\x90\x2f" ) );
    toolButton173->setText( QString::null );
    QToolTip::add( toolButton173, trUtf8( "\x2f\xea\xb3\xb0\xeb\x8f\x8c\xec\x9d\xb4\x2f" ) );
    toolButton174->setText( QString::null );
    QToolTip::add( toolButton174, trUtf8( "\x2f\xed\x8c\xac\xeb\x8d\x94\x2f" ) );
    toolButton175->setText( QString::null );
    QToolTip::add( toolButton175, trUtf8( "\x2f\xec\xb0\x8d\xec\xb0\x8d\x2f" ) );
    toolButton176->setText( QString::null );
    QToolTip::add( toolButton176, trUtf8( "\x2f\xec\x86\x8c\x2f" ) );
    toolButton177->setText( QString::null );
    QToolTip::add( toolButton177, trUtf8( "\x2f\xed\x98\xb8\xeb\x9e\x91\xec\x9d\xb4\x2f" ) );
    toolButton178->setText( QString::null );
    QToolTip::add( toolButton178, trUtf8( "\x2f\xeb\xb0\xb1\xed\x98\xb8\x2f" ) );
    toolButton179->setText( QString::null );
    QToolTip::add( toolButton179, trUtf8( "\x2f\xed\x86\xa0\xeb\x81\xbc\x2f" ) );
    toolButton180->setText( QString::null );
    QToolTip::add( toolButton180, trUtf8( "\x2f\xec\x9a\xa9\x2f" ) );
    toolButton181->setText( QString::null );
    QToolTip::add( toolButton181, trUtf8( "\x2f\xeb\xb1\x80\x2f" ) );
    toolButton182->setText( QString::null );
    QToolTip::add( toolButton182, trUtf8( "\x2f\xeb\xa7\x90\x2f" ) );
    toolButton183->setText( QString::null );
    QToolTip::add( toolButton183, trUtf8( "\x2f\xec\x96\x91\x2f" ) );
    toolButton184->setText( QString::null );
    QToolTip::add( toolButton184, trUtf8( "\x2f\xec\x9b\x90\xec\x88\xad\xec\x9d\xb4\x2f" ) );
    toolButton185->setText( QString::null );
    QToolTip::add( toolButton185, trUtf8( "\x2f\xeb\x8b\xad\x2f" ) );
    toolButton186->setText( QString::null );
    QToolTip::add( toolButton186, trUtf8( "\x2f\xeb\xa9\x8d\xeb\xa9\x8d\x2f" ) );
    toolButton187->setText( QString::null );
    QToolTip::add( toolButton187, trUtf8( "\x2f\xea\xbf\x80\xea\xbf\x80\x2f" ) );
    tabWidget->changeTab( TabPage_2, trUtf8( "\xeb\x8f\x99\xeb\xac\xbc" ) );
    toolButton84->setText( QString::null );
    QToolTip::add( toolButton84, trUtf8( "\x2f\xeb\x86\x8d\xea\xb5\xac\x2f" ) );
    toolButton88->setText( QString::null );
    QToolTip::add( toolButton88, trUtf8( "\x2f\xec\xb6\x95\xea\xb5\xac\x2f" ) );
    toolButton127->setText( QString::null );
    QToolTip::add( toolButton127, trUtf8( "\x2f\xeb\xb2\x88\xea\xb0\x9c\x2f" ) );
    toolButton128->setText( QString::null );
    QToolTip::add( toolButton128, trUtf8( "\x2f\xec\xb9\xb4\xeb\x84\xa4\xec\x9d\xb4\xec\x85\x98\x2f" ) );
    toolButton106->setText( QString::null );
    QToolTip::add( toolButton106, trUtf8( "\x2f\xec\x8b\x9c\xeb\x93\xa4\x2f" ) );
    toolButton108->setText( QString::null );
    QToolTip::add( toolButton108, trUtf8( "\x2f\xec\x95\xbc\xea\xb5\xac\x2f" ) );
    toolButton129->setText( QString::null );
    QToolTip::add( toolButton129, trUtf8( "\x2f\xeb\x8f\x85\xeb\x8f\x84\x2f" ) );
    toolButton126->setText( QString::null );
    QToolTip::add( toolButton126, trUtf8( "\x2f\xeb\xac\xb4\xec\xa7\x80\xea\xb0\x9c\x2f" ) );
    toolButton95->setText( QString::null );
    QToolTip::add( toolButton95, trUtf8( "\x2f\xec\x9e\xa5\xeb\xaf\xb8\x2f" ) );
    toolButton94->setText( QString::null );
    QToolTip::add( toolButton94, trUtf8( "\x2f\xeb\x85\xb8\xeb\x9e\x98\x2f" ) );
    toolButton124->setText( QString::null );
    QToolTip::add( toolButton124, trUtf8( "\x2f\xec\x9a\xb0\xec\x82\xb0\x2f" ) );
    toolButton85->setText( QString::null );
    QToolTip::add( toolButton85, trUtf8( "\x2f\xec\x82\xac\xeb\x9e\x91\x2f" ) );
    toolButton99->setText( QString::null );
    QToolTip::add( toolButton99, trUtf8( "\x2f\xed\x9c\xb4\xec\xa7\x80\x2f" ) );
    toolButton125->setText( QString::null );
    QToolTip::add( toolButton125, trUtf8( "\x2f\xeb\x88\x88\x2f" ) );
    toolButton109->setText( QString::null );
    QToolTip::add( toolButton109, trUtf8( "\x2f\xec\x98\x81\xed\x99\x94\x2f" ) );
    toolButton97->setText( QString::null );
    QToolTip::add( toolButton97, trUtf8( "\x2f\xeb\x8f\x88\x2f" ) );
    toolButton121->setText( QString::null );
    QToolTip::add( toolButton121, trUtf8( "\x2f\xeb\xb3\x84\x2f" ) );
    toolButton101->setText( QString::null );
    QToolTip::add( toolButton101, trUtf8( "\x2f\xec\x97\xac\xed\x8f\xac\x2f" ) );
    toolButton87->setText( QString::null );
    QToolTip::add( toolButton87, trUtf8( "\x2f\xec\x95\x84\xeb\xa0\xb9\x2f" ) );
    toolButton110->setText( QString::null );
    QToolTip::add( toolButton110, trUtf8( "\x2f\xec\x98\xa8\x2f" ) );
    toolButton93->setText( QString::null );
    QToolTip::add( toolButton93, trUtf8( "\x2f\xec\x97\xac\x2f" ) );
    toolButton103->setText( QString::null );
    QToolTip::add( toolButton103, trUtf8( "\x2f\xeb\xb2\x84\xea\xb7\xb8\x2f" ) );
    toolButton96->setText( QString::null );
    QToolTip::add( toolButton96, tr( "/19/" ) );
    toolButton105->setText( QString::null );
    QToolTip::add( toolButton105, trUtf8( "\x2f\xeb\xbd\x80\x2f" ) );
    toolButton98->setText( QString::null );
    QToolTip::add( toolButton98, trUtf8( "\x2f\xec\x9d\x91\xea\xb0\x80\x2f" ) );
    toolButton86->setText( QString::null );
    QToolTip::add( toolButton86, trUtf8( "\x2f\xec\x8a\xa4\xed\x82\xa4\x2f" ) );
    toolButton123->setText( QString::null );
    QToolTip::add( toolButton123, trUtf8( "\x2f\xeb\x8b\xac\x2f" ) );
    toolButton102->setText( QString::null );
    QToolTip::add( toolButton102, trUtf8( "\x2f\xeb\xb0\x98\xec\xa7\x9d\x2f" ) );
    toolButton100->setText( QString::null );
    QToolTip::add( toolButton100, trUtf8( "\x2f\xeb\x82\xa8\xed\x8f\xac\x2f" ) );
    toolButton111->setText( QString::null );
    QToolTip::add( toolButton111, trUtf8( "\x2f\xed\x8f\xad\xec\xa3\xbd\x2f" ) );
    toolButton90->setText( QString::null );
    QToolTip::add( toolButton90, trUtf8( "\x2f\xec\xb2\x9c\xec\x82\xac\x2f" ) );
    toolButton122->setText( QString::null );
    QToolTip::add( toolButton122, trUtf8( "\x2f\xed\x95\xb4\x2f" ) );
    toolButton92->setText( QString::null );
    QToolTip::add( toolButton92, trUtf8( "\x2f\xeb\x82\xa8\x2f" ) );
    toolButton107->setText( QString::null );
    QToolTip::add( toolButton107, trUtf8( "\x2f\xec\x8b\xa4\xec\x97\xb0\x2f" ) );
    toolButton91->setText( QString::null );
    QToolTip::add( toolButton91, trUtf8( "\x2f\xec\x95\x85\xeb\xa7\x88\x2f" ) );
    toolButton89->setText( QString::null );
    QToolTip::add( toolButton89, trUtf8( "\x2f\xed\x85\x8c\xeb\x94\x94\x2f" ) );
    toolButton104->setText( QString::null );
    QToolTip::add( toolButton104, trUtf8( "\x2f\xeb\xb3\x80\xea\xb8\xb0\x2f" ) );
    toolButton188->setText( QString::null );
    QToolTip::add( toolButton188, trUtf8( "\x2f\xec\xa3\xbc\xeb\xa8\xb9\x2f" ) );
    toolButton189->setText( QString::null );
    QToolTip::add( toolButton189, trUtf8( "\x2f\xeb\xb6\x88\xea\xbd\x83\x2f" ) );
    toolButton190->setText( QString::null );
    QToolTip::add( toolButton190, trUtf8( "\x2f\xec\xa1\xb0\xeb\xac\xb8\x2f" ) );
    toolButton191->setText( QString::null );
    QToolTip::add( toolButton191, trUtf8( "\x2f\xec\x88\xad\xeb\xa1\x80\xeb\xac\xb8\x2f" ) );
    toolButton192->setText( QString::null );
    QToolTip::add( toolButton192, trUtf8( "\x2f\xeb\xa0\x88\xeb\x93\x9c\xec\xa0\xac\x2f" ) );
    toolButton193->setText( QString::null );
    QToolTip::add( toolButton193, trUtf8( "\x2f\xec\x8a\xa4\xec\xbc\x80\xec\x9d\xb4\xed\x8a\xb8\x2f" ) );
    toolButton194->setText( QString::null );
    QToolTip::add( toolButton194, trUtf8( "\x2f\xea\xb3\xa0\xea\xb8\x80\x2f" ) );
    toolButton195->setText( QString::null );
    QToolTip::add( toolButton195, trUtf8( "\x2f\xeb\xa7\x91\xec\x9d\x8c\x2f" ) );
    toolButton196->setText( QString::null );
    QToolTip::add( toolButton196, trUtf8( "\x2f\xed\x9d\x90\xeb\xa6\xbc\x2f" ) );
    toolButton197->setText( QString::null );
    QToolTip::add( toolButton197, trUtf8( "\x2f\xeb\xb9\x84\x2f" ) );
    toolButton198->setText( QString::null );
    QToolTip::add( toolButton198, trUtf8( "\x2f\xeb\x9e\xa8\xed\x94\x84\x2f" ) );
    toolButton199->setText( QString::null );
    QToolTip::add( toolButton199, trUtf8( "\x2f\xec\x83\x88\xec\x8b\xb9\x2f" ) );
    toolButton200->setText( QString::null );
    QToolTip::add( toolButton200, trUtf8( "\x2f\xeb\x8b\xa8\xed\x92\x8d\xec\x9e\x8e\x2f" ) );
    tabWidget->changeTab( TabPage_3, trUtf8( "\xea\xb8\xb0\xed\x83\x80" ) );
    toolButton142->setText( QString::null );
    QToolTip::add( toolButton142, trUtf8( "\x2f\xeb\xb3\xb5\xec\xa3\xbc\xeb\xa8\xb8\xeb\x8b\x88\x2f" ) );
    toolButton141->setText( QString::null );
    QToolTip::add( toolButton141, trUtf8( "\x2f\xeb\xb3\xb5\x2f" ) );
    toolButton133->setText( QString::null );
    QToolTip::add( toolButton133, trUtf8( "\x2f\xec\x82\xb0\xed\x83\x80\x2f" ) );
    toolButton137->setText( QString::null );
    QToolTip::add( toolButton137, trUtf8( "\x2f\xeb\x88\x88\xec\x82\xac\xeb\x9e\x8c\x2f" ) );
    toolButton132->setText( QString::null );
    QToolTip::add( toolButton132, trUtf8( "\x2f\xeb\xb3\xb4\xeb\xa6\x84\xeb\x8b\xac\x2f" ) );
    toolButton138->setText( QString::null );
    QToolTip::add( toolButton138, trUtf8( "\x2f\xec\x84\xb1\xed\x83\x84\xeb\xa6\xac\xec\x8a\xa4\x2f" ) );
    toolButton135->setText( QString::null );
    QToolTip::add( toolButton135, trUtf8( "\x2f\xeb\xa3\xa8\xeb\x8f\x8c\xed\x94\x84\x2f" ) );
    toolButton139->setText( QString::null );
    QToolTip::add( toolButton139, trUtf8( "\x2f\xec\x84\xb1\xed\x83\x84\xec\xa2\x85\x2f" ) );
    toolButton134->setText( QString::null );
    QToolTip::add( toolButton134, trUtf8( "\x2f\xed\x8a\xb8\xeb\xa6\xac\x2f" ) );
    toolButton136->setText( QString::null );
    QToolTip::add( toolButton136, trUtf8( "\x2f\xeb\xb9\xa8\xea\xb0\x84\xec\x96\x91\xeb\xa7\x90\x2f" ) );
    toolButton201->setText( QString::null );
    QToolTip::add( toolButton201, trUtf8( "\x2f\xec\xa7\x80\xed\x8c\xa1\xec\x9d\xb4\x2f" ) );
    toolButton130->setText( QString::null );
    QToolTip::add( toolButton130, trUtf8( "\x2f\xeb\xb6\x89\xec\x9d\x80\xed\x8b\xb0\x2f" ) );
    toolButton131->setText( QString::null );
    QToolTip::add( toolButton131, trUtf8( "\x2f\xed\x83\x9c\xea\xb7\xb9\xec\x9d\xbc\xec\xb4\x8c\x2f" ) );
    toolButton202->setText( QString::null );
    QToolTip::add( toolButton202, trUtf8( "\x2f\xea\xb8\x88\xeb\xa9\x94\xeb\x8b\xac\x2f" ) );
    toolButton203->setText( QString::null );
    QToolTip::add( toolButton203, trUtf8( "\x2f\xec\x9d\x80\xeb\xa9\x94\xeb\x8b\xac\x2f" ) );
    toolButton204->setText( QString::null );
    QToolTip::add( toolButton204, trUtf8( "\x2f\xeb\x8f\x99\xeb\xa9\x94\xeb\x8b\xac\x2f" ) );
    toolButton205->setText( QString::null );
    QToolTip::add( toolButton205, trUtf8( "\x2f\xec\x9a\xb0\xec\x8a\xb9\xec\xbb\xb5\x2f" ) );
    tabWidget->changeTab( TabPage_4, trUtf8( "\xec\x8b\x9c\xec\xa6\x8c" ) );
}

void MyToolButton::mousePressEvent(QMouseEvent * e) {
    emit clicked( toolTip () );
    QToolButton::mousePressEvent(e);
}

#include "emoticonwindow.moc"

