/***************************************************************************
 *   Copyright (C) 2008 by SK Communications.                              *
 *   http://kldp.net/projects/nateon/                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "knateoncommon.h"
#include "filetransfer.h"
#include "../network/sendfileinfo.h"
#include "../util/common.h"
#include "../util/sound.h"

extern nmconfig stConfig;

FileTransfer::FileTransfer(QWidget *parent, const char *name)
        : FileTransferForm(parent, name) {
    /// fileListGroupBox->hide(); <<=== 잠시 없앰.
    // layout()->setResizeMode(QLayout::Fixed);
    progressBar1->reset();
    //progressBar1->setPercentageVisible( true );
	fileListView->setAllColumnsShowFocus( true );
    fileListView->clear();


    connect( fileListView, SIGNAL( selectionChanged () ), this, SLOT( slotUpdateInfo() ) );
    connect( this, SIGNAL( progressUpdate( int ) ), progressBar1, SLOT( setValue( int ) ) );
    connect( cancelButton, SIGNAL( clicked() ), SLOT( slotCancelButton() ) );
}


FileTransfer::~FileTransfer() {
}

void FileTransfer::showlist() {
    fileListGroupBox->show();
    layout()->setResizeMode(QLayout::SetFixedSize);
}

void FileTransfer::hidelist() {
    fileListGroupBox->hide();
    layout()->setResizeMode(QLayout::SetFixedSize);
}

void FileTransfer::addListView(const QString & sCookie, const QString & sID, const QString & sFile, const qlonglong nSize, bool bSend) {
	QString sFilename( sFile );
	sFilename.replace( "%20", " " );

    Q3ListViewItem* newItem = new Q3ListViewItem(fileListView, sCookie, sID, sFilename, QString::number(nSize) );
    fileListView->setCurrentItem ( newItem );
    fileListView->setSelected ( newItem, true );
    fileListView->setSorting ( -1 );
	if ( nSize > MAX_INT ) {
		progressBar1->setMaximum( MAX_INT );
	}
	else {
		progressBar1->setMaximum( nSize );
	}
    progressBar1->reset();
    kbStatusLabel->setText( "0 / " + QString::number(nSize) + " Bytes" );
    if ( bSend )
        newItem->setText( 4, UTF8("보냄") );
    else
        newItem->setText( 4, UTF8("받음") );
    newItem->setText( 6, UTF8("기다리는 중") );
    newItem->setText( 7, "0");
    cancelButton->setEnabled( false );
    cancelButton->setText( UTF8("중지") );
}


Q3ListViewItem *FileTransfer::getListViewItem( const QString & sFileCookie ) {
    Q3ListViewItemIterator it( fileListView );
    Q3ListViewItem *item = 0;
    while ( it.current() ) {
        item = it.current();
        if (item->text(0) == sFileCookie )
            return item;
        ++it;
    }
    return 0;
}


void FileTransfer::endProgressByByte( const QString& sFileCookie ) {
    Q3ListViewItem *item = getListViewItem( sFileCookie );
    if ( item ) {
        item->setText( 6, UTF8("전송완료") );
        /*!
         * 쪽지 받음 소리
         */
        if ( stConfig.usesound && stConfig.usefilesenddonesound ) {
            Sound::play( stConfig.filesenddonesoundpath );
        }
        cancelButton->setEnabled( FALSE );
        cancelButton->setText( UTF8("완료") );
    }
}


void FileTransfer::updateProgressByByte(const QString & sFileCookie, const qlonglong nByte) {
    Q3ListViewItem *item = getListViewItem( sFileCookie );
    if ( item ) {
        qlonglong nTSize = QString(item->text(3)).toLongLong();
        unsigned int nPercent = (nByte * 100 ) / nTSize;
        item->setText(5, QString::number( nPercent ) + "%");
		
		int process = nByte;
		if ( nTSize > MAX_INT ) {
			process = (int)( (double)nByte / ( (double)nTSize / (double)MAX_INT ) );
		}

        if (  fileListView->isSelected( item )  ) {
			emit progressUpdate( process );
			progressBar1->update();

            kbStatusLabel->clear();
            kbStatusLabel->setText( QString::number( nByte ) + " / " + item->text(3) + " Bytes" );
		}

        if ( item->text(6) != UTF8("전송취소됨") ) {
            item->setText( 6, UTF8("전송중") );
            cancelButton->setEnabled( true );
            cancelButton->setText( UTF8("중지") );
        }

        item->setText(7, QString::number( nByte ) );
    }
}

#include "filetransfer.moc"

void FileTransfer::slotUpdateInfo() {
    Q3ListViewItem* pCurItem = fileListView->selectedItem();
    if ( pCurItem ) {
        fileNameLabel->setText( pCurItem->text(2) );
        kbStatusLabel->setText( pCurItem->text(7) + " / " + pCurItem->text(3) + " Bytes");
        QString sPercent;
        sPercent = (pCurItem->text(5)).replace("%", "");
		progressBar1->reset();
		if ( pCurItem->text(3).toLongLong() > MAX_INT ) {
			progressBar1->setMaximum( MAX_INT );
		}
		else {
			progressBar1->setMaximum( pCurItem->text(3).toInt() );
		}
        emit progressUpdate( pCurItem->text(7).toInt() );

        if ( ( pCurItem->text(6) == UTF8("전송중") ) || ( pCurItem->text(6) == UTF8("기다리는 중") ) ) {
            cancelButton->setEnabled( TRUE );
            cancelButton->setText( UTF8("중지") );
        } else {
            cancelButton->setEnabled( FALSE );
            cancelButton->setText( UTF8("완료") );
        }
    }
}

void FileTransfer::cancelTransfer(const QString & sCookie) {
    KMessageBox::information( this, UTF8("상대방이 파일전송을 취소하였습니다."), UTF8("전송 취소") );

    Q3ListViewItem *item = getListViewItem( sCookie );

// 	QListViewItemIterator it( fileListView );
// 	while ( it.current() )
// 	{
// 		item = it.current();
// 		if (item->text(0) == sCookie )
// 			break;
// 		++it;
// 	}
    if ( item ) {
        item->setText( 6, UTF8("전송취소됨") );
    }
    cancelButton->setEnabled( FALSE );
}

void FileTransfer::slotCancelButton() {
    Q3ListViewItem* pCurItem = fileListView->selectedItem();
    if ( pCurItem ) {
        /*!
         * File Cookie
         */
        emit cancelFileTransfer( pCurItem->text(0) );
        cancelButton->setEnabled( FALSE );
        pCurItem->setText( 6, UTF8("전송취소됨") );
    }
}
