/***************************************************************************
 *   Copyright (C) 2008 by SK Communications.                              *
 *   http://kldp.net/projects/nateon/                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SOUNDSELECTDIALOG_H
#define SOUNDSELECTDIALOG_H

#include <qvariant.h>
#include <qdialog.h>
//Added by qt3to4:
#include <Q3VBoxLayout>
#include <Q3GridLayout>
#include <Q3HBoxLayout>
#include <k3listview.h>

class Q3VBoxLayout;
class Q3HBoxLayout;
class Q3GridLayout;
class QSpacerItem;
class Q3GroupBox;
class K3ListView;
class Q3ListViewItem;
class KUrlLabel;
class QLineEdit;
class QPushButton;

class SoundSelectDialog : public QDialog {
    Q_OBJECT

public:
    SoundSelectDialog( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, Qt::WFlags fl = 0 );
    ~SoundSelectDialog();

    Q3GroupBox* soundGroupBox;
    K3ListView* soundListView;
    KUrlLabel* soundDownKUrlLabel;
    QLineEdit* filePathLineEdit;
    QPushButton* playButton;
    QPushButton* selectFileButton;
    //    QPushButton* buttonHelp;
    QPushButton* buttonOk;
    QPushButton* buttonCancel;

protected:
    Q3VBoxLayout* SoundSelectDialogLayout;
    Q3VBoxLayout* soundGroupBoxLayout;
    Q3HBoxLayout* layout4;
    QSpacerItem* spacer2;
    Q3HBoxLayout* layout3;
    Q3HBoxLayout* Layout1;
    QSpacerItem* Horizontal_Spacing2;

protected slots:
    virtual void languageChange();
};

#endif // SOUNDSELECTDIALOG_H
