/***************************************************************************
                          systemtraywidget.cpp  -  description
                             -------------------
    begin                : Sun Dec 29 2002
    copyright            : (C) 2002 by Mike K. Bennett
    email                : mkb137b@hotmail.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "systemtraywidget.h"

#include <kdebug.h>
#include <klocale.h>
#include <kmenu.h>
#include <kicon.h>
#include <kiconloader.h>
#include <kaboutdata.h>
#include <kcomponentdata.h>
#include <kstandarddirs.h>

#include "currentaccount.h"

// The constructor
SystemTrayWidget::SystemTrayWidget( QWidget *parent )
        : KSystemTrayIcon( parent ) {

    KStandardDirs *dirs = KGlobal::dirs();
    dirs->addResourceDir( "data", "/usr/share/apps" );
    sPicsPath = dirs->findResource( "data", QString( KGlobal::mainComponent().aboutData()->appName() ) + "/pics/" );
	setIcon( QIcon(sPicsPath +  "main_list_state_offline.png" ) );
}


// The destructor
SystemTrayWidget::~SystemTrayWidget() {
#ifdef NETDEBUG
    kDebug() << "DESTROYED SystemTrayWidget";
#endif
}

// Initialize the class
bool SystemTrayWidget::initialize() {
    connect( CurrentAccount::instance(), SIGNAL( changedStatus() ), SLOT( slotStatusChanged() ) );
    return true;
}


// Return the context menu
QMenu* SystemTrayWidget::menu() const {
    return contextMenu();
}


// Change the icon when the user's status changes
void SystemTrayWidget::slotStatusChanged() {
    QString     iconName;

    switch ( CurrentAccount::instance()->getStatus() ) {
    case 'O' :
        iconName = "main_list_state_online.png";
        break;
    case 'A' :
        iconName = "main_list_state_vacant.png";
        break;
    case 'B' :
        iconName = "main_list_state_otherbusiness.png";
        break;
    case 'P' :
        iconName = "main_list_state_onphone.png";
        break;
    case 'M' :
        iconName = "main_list_state_meeting.png";
        break;
    case 'F' :
        iconName = "main_list_state_offline.png";
        break;
    }

	setIcon( QIcon(sPicsPath +  iconName ) );
}

#include "systemtraywidget.moc"
