unit fMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Grids, RXGrids, uNemo;

type
  TForm1 = class(TForm)
    Panel2: TPanel;
    Panel3: TPanel;
    Panel1: TPanel;
    btnLoad: TButton;
    grdNemo: TRxDrawGrid;
    Label3: TLabel;
    edtDigits: TEdit;
    Label4: TLabel;
    edtLineCount: TEdit;
    Button3: TButton;
    Memo1: TMemo;
    edtInit: TEdit;
    Label5: TLabel;
    Label6: TLabel;
    edtResult: TEdit;
    Label7: TLabel;
    Edit1: TEdit;
    Button1: TButton;
    Button2: TButton;
    Label8: TLabel;
    Edit2: TEdit;
    Button4: TButton;
    Button5: TButton;
    btnSolve: TButton;
    procedure btnLoadClick(Sender: TObject);
    procedure grdNemoDrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure Button3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure btnSolveClick(Sender: TObject);
  private
    { Private declarations }
    Nemo: TNemo;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses IniFiles;

{$R *.dfm}

procedure TForm1.btnLoadClick(Sender: TObject);
var
  NumOfX, NumOfY: Integer;
  Ini: TIniFile;
begin
  if Assigned(Nemo) then
  begin
    Nemo.Free;
  end;

  grdNemo.Visible := True;
  Ini := TIniFile.Create(ExtractFileDir(ParamStr(0)) + '\nemo.ini');
  Nemo := TNemo.Create(Ini);
  with grdNemo do
  begin
    ColCount := Nemo.Col + Nemo.DCol + 1;
    RowCount := Nemo.Row + Nemo.DRow + 1;
    DefaultColWidth := Width div ColCount - 1;
    DefaultRowHeight := Height div RowCount - 1;
  end;
  Ini.Free;

  
end;

procedure TForm1.grdNemoDrawCell(Sender: TObject; ACol, ARow: Integer;
  Rect: TRect; State: TGridDrawState);
var
  col1, row1: Integer;
begin
{}
//OutputDebugString(PChar(Format('%d, %d, (%d,%d,%d,%d)', [ACol, ARow, Rect.Left, Rect.Top, rect.Right, rect.Bottom])));
  if not Assigned(Nemo) then Exit;

  with grdNemo do
  begin
    if ((ACol > 0) and (ACol <= Nemo.DCol) and (ARow >= Nemo.DRow+1))
      or ((ARow > 0) and (ARow <= Nemo.DRow) and (ACol >= Nemo.DCol+1)) then
    begin
      Canvas.Brush.Color := clYellow;
      Canvas.FillRect(Rect);
      if (ACol <= Nemo.DCol) then
      begin
        row1 := ARow-Nemo.DRow-1;
        col1 := ACol - Nemo.DCol + Nemo.RowDigits[ row1 ].Count - 1;
        if col1 >= 0 then
          Canvas.TextRect(Rect, Rect.Left+1, Rect.Top+1, IntToStr(Nemo.RowDigits[ row1 ].Item[col1]));
      end;

      if (ARow <= Nemo.DRow) then
      begin
        col1 := ACol-Nemo.DCol-1;
        row1 := ARow - Nemo.DRow + Nemo.ColDigits[ col1 ].Count - 1;
        if row1 >= 0 then
          Canvas.TextRect(Rect, Rect.Left+1, Rect.Top+1, IntToStr(Nemo.ColDigits[ col1 ].Item[row1]));
      end;
    end
    else if (ARow >= Nemo.DRow + 1) and (ACol >= Nemo.DCol + 1) then
    begin
      row1 := ARow-Nemo.DRow-1;
      col1 := ACol-Nemo.DCol-1;
      case Nemo.Board[row1][col1] of
      'O'://nbsGray:
        begin
        end;
      '#'://nbsBlack:
        begin
          Canvas.Brush.Color := clBlack;
          Canvas.FillRect(Rect);
        end;
      '.'://nbsWhite:
        begin
          Canvas.MoveTo(Rect.Left, Rect.Top);
          Canvas.LineTo(Rect.Right, Rect.Bottom);
          Canvas.MoveTo(Rect.Right, Rect.Top);
          Canvas.LineTo(Rect.Left, Rect.Bottom);
        end;
      end;
    end;
  end;
//  grdNemo.Canvas.Rectangle(Rect.Left+2, Rect.Top+2, rect.Right-2, rect.Bottom-2);
{}
end;

procedure TForm1.Button3Click(Sender: TObject);
var
  List: TStringList;
  Digits: TNemoDigits;
  LineCount: Integer;
begin
  List := TStringList.Create;
  Digits := TNemoDigits.Create(edtDigits.Text);
  LineCount := StrToInt(edtLineCount.Text);
  NemoMakeLine(List, '', Digits, LineCount);
  Memo1.Lines.Assign(List);
  edtResult.Text := ProcessLine(List, edtInit.Text);
  List.Free;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  i: Integer;
begin
  for i := 0 to Nemo.Row-1 do
    Nemo.ProcessRow(i);
  grdNemo.Refresh;
end;

procedure TForm1.Button5Click(Sender: TObject);
var
  i: Integer;
begin
  for i := 0 to Nemo.Col-1 do
    Nemo.ProcessCol(i);
  grdNemo.Refresh;
end;

procedure TForm1.btnSolveClick(Sender: TObject);
var
  nTotal: Integer;
  nWhite, nBlack: Integer;
  nPrevWhite, nPrevBlack: Integer;
  bDone: Boolean;
  nCount: Integer;
begin
  nPrevWhite := 0;
  nPrevBlack := 0;
  nTotal := Nemo.Col * Nemo.Row;
  bDone := False;
  nCount := 0;

  while not bDone do
  begin
    if (nCount mod 2) = 0 then
      Nemo.ProcessAllCol
    else
      Nemo.ProcessAllRow;
    grdNemo.Refresh;
    Nemo.GetScore(nWhite, nBlack);
    if nWhite+nBlack = nTotal then
    begin
      // ذ
      bDone := True;
    end
    else if (nWhite < nPrevWhite) or (nBlack < nPrevBlack) then
    begin
      // , ߸ 
      bDone := True;
    end
    else if (nWhite = nPrevWhite) and (nBlack = nPrevBlack) then
    begin
      // ,  
      bDone := True;
    end;
    nPrevWhite := nWhite;
    nPrevBlack := nBlack;
    Inc(nCount);
  end;
end;

end.
