/*
 * Decompiled with CFR 0.152.
 */
package com.endofhope.neurasthenia;

import com.endofhope.neurasthenia.SelectorManager;
import com.endofhope.neurasthenia.Server;
import com.endofhope.neurasthenia.ServerImplMBean;
import com.endofhope.neurasthenia.ServiceFactory;
import com.endofhope.neurasthenia.config.ConfigManager;
import com.endofhope.neurasthenia.connection.LogicalConnectionManager;
import com.endofhope.neurasthenia.connection.PhysicalConnectionManager;
import com.endofhope.neurasthenia.gather.Gather;
import com.endofhope.neurasthenia.handler.Handler;
import com.endofhope.neurasthenia.message.Message;
import com.endofhope.neurasthenia.scatter.Scatter;
import com.endofhope.neurasthenia.webcontainer.WebContainer;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerImpl
implements Server,
ServerImplMBean {
    private static final Logger logger = Logger.getLogger("server");
    private String serverId;
    private PhysicalConnectionManager physicalConnectionManager;
    private LogicalConnectionManager logicalConnectionManager;
    private ThreadPoolExecutor threadPoolExecutor;
    private Map<String, BlockingQueue<Message>> messageQueueMap;
    private SelectorManager selectorManager;
    private WebContainer webContainer;
    private volatile boolean running;
    private Map<String, Gather> gatherMap;
    private Handler handler;
    private Map<String, Scatter> scatterMap;
    private AtomicInteger atomicInt;

    public ServerImpl(String serverId) {
        this.serverId = serverId;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void boot() {
        this.running = true;
        this.atomicInt = new AtomicInteger(0);
        this.physicalConnectionManager = new PhysicalConnectionManager();
        this.logicalConnectionManager = new LogicalConnectionManager(this.physicalConnectionManager);
        ConfigManager configManager = ConfigManager.getInstance();
        this.selectorManager = new SelectorManager(configManager.getSelectorManagerInfo().getInitQueueSize());
        ConfigManager.ThreadPoolExecutorInfo tpei = configManager.getThreadPoolExecutorInfo();
        BlockingQueue workQueue = null;
        try {
            Class<?> clazz = Class.forName(tpei.getQueueClass());
            workQueue = (BlockingQueue)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, "workqueue error", e);
        }
        catch (InstantiationException e) {
            logger.log(Level.SEVERE, "workqueue error", e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.SEVERE, "workqueue error", e);
        }
        this.threadPoolExecutor = new ThreadPoolExecutor(tpei.getCorePoolSize(), tpei.getMaximumPoolSize(), tpei.getKeepAliveTime(), TimeUnit.SECONDS, workQueue);
        this.messageQueueMap = new ConcurrentHashMap<String, BlockingQueue<Message>>();
        for (ConfigManager.MessageQueueInfo messageQueueInfo : configManager.getMessageQueueInfoList()) {
            try {
                Class<?> clazz = Class.forName(messageQueueInfo.getQueueClass());
                BlockingQueue messageQueue = (BlockingQueue)clazz.newInstance();
                this.messageQueueMap.put(messageQueueInfo.getId(), messageQueue);
            }
            catch (ClassNotFoundException e) {
                logger.log(Level.SEVERE, "messagequeue error", e);
            }
            catch (InstantiationException e) {
                logger.log(Level.SEVERE, "messagequeue error", e);
            }
            catch (IllegalAccessException e) {
                logger.log(Level.SEVERE, "messagequeue error", e);
            }
        }
        this.scatterMap = new ConcurrentHashMap<String, Scatter>();
        for (ConfigManager.ScatterInfo scatterInfo : configManager.getScatterInfoList()) {
            Scatter scatter = ServiceFactory.createScatter(this, scatterInfo);
            scatter.boot();
            this.scatterMap.put(scatterInfo.getId(), scatter);
        }
        this.handler = ServiceFactory.createHandler(this, configManager.getHandlerInfo());
        this.handler.boot();
        this.gatherMap = new ConcurrentHashMap<String, Gather>();
        for (ConfigManager.GatherInfo gatherInfo : configManager.getGatherInfoList()) {
            Gather gather = ServiceFactory.createGather(this, gatherInfo);
            gather.boot();
            this.gatherMap.put(gatherInfo.getId(), gather);
        }
        if (configManager.getWebContainerInfo() != null) {
            this.webContainer = new WebContainer(this);
            this.webContainer.boot();
        }
    }

    @Override
    public void down() {
        this.running = false;
        Set<String> gatherKeySet = this.gatherMap.keySet();
        Iterator<String> gatherKeyIter = gatherKeySet.iterator();
        while (gatherKeyIter.hasNext()) {
            this.gatherMap.get(gatherKeyIter.next()).down();
        }
        this.gatherMap.clear();
        this.handler.down();
        Set<String> scatterKeySet = this.scatterMap.keySet();
        Iterator<String> scatterKeyIter = scatterKeySet.iterator();
        while (scatterKeyIter.hasNext()) {
            this.scatterMap.get(scatterKeyIter.next()).down();
        }
        this.scatterMap.clear();
        if (this.webContainer != null) {
            this.webContainer.down();
        }
    }

    @Override
    public String getServerId() {
        return this.serverId;
    }

    @Override
    public PhysicalConnectionManager getPhysicalConnectionManager() {
        return this.physicalConnectionManager;
    }

    @Override
    public LogicalConnectionManager getLogicalConnectionManager() {
        return this.logicalConnectionManager;
    }

    @Override
    public ThreadPoolExecutor getThreadPoolExecutor() {
        return this.threadPoolExecutor;
    }

    @Override
    public Map<String, BlockingQueue<Message>> getMessageQueueMap() {
        return this.messageQueueMap;
    }

    @Override
    public BlockingQueue<Message> getMessageQueue(String queueId) {
        return this.messageQueueMap.get(queueId);
    }

    @Override
    public SelectorManager getSelectorManager() {
        return this.selectorManager;
    }

    @Override
    public WebContainer getWebContainer() {
        return this.webContainer;
    }

    @Override
    public String getUnique() {
        return this.serverId + this.atomicInt.addAndGet(1);
    }

    @Override
    public int getActiveThreadCount() {
        return this.threadPoolExecutor.getActiveCount();
    }

    @Override
    public String[] getMessageQueueInfo() {
        String[] messageQueueInfoArray = null;
        if (this.messageQueueMap != null) {
            int size = this.messageQueueMap.size();
            messageQueueInfoArray = new String[size];
            Set<String> queueNameSet = this.messageQueueMap.keySet();
            Iterator<String> queueNameIter = queueNameSet.iterator();
            int i = 0;
            while (queueNameIter.hasNext()) {
                String queueName = queueNameIter.next();
                int queueSize = this.messageQueueMap.get(queueName).size();
                messageQueueInfoArray[i] = queueName + " : " + queueSize;
                ++i;
            }
        }
        return messageQueueInfoArray;
    }
}

