/*
 * Decompiled with CFR 0.152.
 */
package com.endofhope.neurasthenia.connection;

import com.endofhope.neurasthenia.connection.ConnectionEventHandler;
import com.endofhope.neurasthenia.connection.PhysicalConnectionKey;

public class LogicalConnection {
    public static final int CONNECTION_TYPE_STOMP_CONNECTED = 1;
    public static final int CONNECTION_TYPE_STOMP_SUBSCRIBED = 2;
    public static final int CONNECTION_TYPE_COMET_SUBSCRIBED = 3;
    private static final int CATEGORY_STOMP = 1;
    private static final int CATEGORY_COMET = 2;
    private String userId;
    private int connectionType;
    private PhysicalConnectionKey physicalConnectionKey;
    private ConnectionEventHandler connectionEventHandler;

    public static int getCategory(int contentType) {
        int category = 0;
        switch (contentType) {
            case 1: {
                category = 1;
                break;
            }
            case 2: {
                category = 1;
                break;
            }
            case 3: {
                category = 2;
            }
        }
        return category;
    }

    public static boolean isSameCategory(int connectionType1, int connectionType2) {
        return LogicalConnection.getCategory(connectionType1) == LogicalConnection.getCategory(connectionType2);
    }

    protected LogicalConnection(String userId, int connectionType, PhysicalConnectionKey physicalConnectionKey, ConnectionEventHandler connectionEventHandler) {
        this.userId = userId;
        this.connectionType = connectionType;
        this.physicalConnectionKey = physicalConnectionKey;
        this.connectionEventHandler = connectionEventHandler;
    }

    public String getUserId() {
        return this.userId;
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    public PhysicalConnectionKey getPhysicalConnectionKey() {
        return this.physicalConnectionKey;
    }

    public ConnectionEventHandler getConnectionEventHandler() {
        return this.connectionEventHandler;
    }

    public void setConnectionType(int connectionType) {
        this.connectionType = connectionType;
    }

    public boolean equals(Object otherObj) {
        boolean resultFlag = false;
        if (otherObj instanceof LogicalConnection) {
            LogicalConnection other = (LogicalConnection)otherObj;
            if (other.userId.equals(this.userId) && other.connectionType == this.connectionType && other.physicalConnectionKey.equals(this.physicalConnectionKey)) {
                resultFlag = true;
            }
        }
        return resultFlag;
    }

    public int hashCode() {
        return (this.physicalConnectionKey.toString() + this.userId + this.connectionType).hashCode();
    }
}

