/*
 * Decompiled with CFR 0.152.
 */
package com.endofhope.neurasthenia.gather;

import com.endofhope.neurasthenia.Constants;
import com.endofhope.neurasthenia.Server;
import com.endofhope.neurasthenia.connection.PhysicalConnectionManager;
import com.endofhope.neurasthenia.gather.AbstractGather;
import com.endofhope.neurasthenia.gather.HttpBufferPack;
import com.endofhope.neurasthenia.message.Message;
import com.endofhope.neurasthenia.message.MessageImpl;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpGather
extends AbstractGather {
    private static final Logger logger = Logger.getLogger("http.gather");

    public HttpGather(Server server, String id, String serviceType, int port, int readSelectTimeout, int readBufferSize, BlockingQueue<Message> messageQueue) {
        super(server, id, serviceType, port, readSelectTimeout, readBufferSize, messageQueue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int onReceive(SelectionKey selectionKey) throws IOException {
        this.readBuffer.clear();
        SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
        int readSize = socketChannel.read(this.readBuffer);
        if (readSize < 0) {
            selectionKey.cancel();
            return readSize;
        }
        this.readBuffer.flip();
        HttpBufferPack httpBufferPack = (HttpBufferPack)selectionKey.attachment();
        if (httpBufferPack == null) {
            httpBufferPack = new HttpBufferPack();
            selectionKey.attach(httpBufferPack);
        }
        HttpBufferPack.Status status = HttpBufferPack.Status.INIT;
        while (this.readBuffer.remaining() > 0) {
            HttpBufferPack neoHttpBufferPack;
            byte oneByte = this.readBuffer.get();
            status = httpBufferPack.getStatus();
            if (HttpBufferPack.Status.INIT == status) {
                if (!Constants.isCr(oneByte) && !Constants.isLf(oneByte)) {
                    httpBufferPack.addByte(oneByte);
                    httpBufferPack.setStatus(HttpBufferPack.Status.METHOD);
                }
            } else if (HttpBufferPack.Status.METHOD == status) {
                if (Constants.isCr(oneByte)) {
                    httpBufferPack.setMethodBytes(httpBufferPack.getPacked());
                    httpBufferPack.setStatus(HttpBufferPack.Status.METHOD_CR);
                } else {
                    if (Constants.isLf(oneByte)) {
                        throw new IllegalStateException("Method \uac00 \ub05d\ub0a0 \ub54c CR \uc774 \uc640\uc57c\ud558\uc9c0\ub9cc LF \uac00 \uba3c\uc800 \uc654\ub2e4.");
                    }
                    httpBufferPack.addByte(oneByte);
                }
            } else if (HttpBufferPack.Status.METHOD_CR == status) {
                if (!Constants.isLf(oneByte)) throw new IllegalStateException("Method \uac00 \ub05d\ub0a0 \ub54c CR \uc774\ud6c4\uc5d4 LF \uac00 \uc640\uc57c\ub9cc \ud55c\ub2e4.");
                httpBufferPack.setStatus(HttpBufferPack.Status.METHOD_CRLF);
            } else if (HttpBufferPack.Status.METHOD_CRLF == status) {
                if (Constants.isCr(oneByte)) {
                    logger.log(Level.WARNING, "header \uac00 \uc5c6\ub294 \uacbd\uc6b0\uac00 \ubc1c\uc0dd\ud558\uc600\ub2e4. \uc0c1\ud0dc\ub97c header_crlfcr \ub85c \ubcc0\uacbd\ud55c\ub2e4.");
                    httpBufferPack.setStatus(HttpBufferPack.Status.HEADER_CRLFCR);
                } else {
                    if (Constants.isLf(oneByte)) {
                        throw new IllegalStateException("Method \uac00 \ub05d\ub09c \ud6c4 LF \ub294 \uc62c \uc218 \uc5c6\ub2e4.");
                    }
                    httpBufferPack.addByte(oneByte);
                    httpBufferPack.setStatus(HttpBufferPack.Status.HEADER);
                }
            } else if (HttpBufferPack.Status.HEADER == status) {
                if (Constants.isCr(oneByte)) {
                    httpBufferPack.addHeaderBytes(httpBufferPack.getPacked());
                    httpBufferPack.setStatus(HttpBufferPack.Status.HEADER_CR);
                } else {
                    if (Constants.isLf(oneByte)) {
                        throw new IllegalStateException("Header \uac00 \ub05d\ub0a0 \ub54c CR \uc774 \uc640\uc57c \ud558\uc9c0\ub9cc LF \uac00 \uba3c\uc800 \uc654\ub2e4.");
                    }
                    httpBufferPack.addByte(oneByte);
                }
            } else if (HttpBufferPack.Status.HEADER_CR == status) {
                if (!Constants.isLf(oneByte)) throw new IllegalStateException("header \uac00 \ub05d\ub0a0 \ub54c CR \uc774\ud6c4\uc5d4 LF \uac00 \uc640\uc57c \ud55c\ub2e4.");
                httpBufferPack.setStatus(HttpBufferPack.Status.HEADER_CRLF);
            } else if (HttpBufferPack.Status.HEADER_CRLF == status) {
                if (Constants.isCr(oneByte)) {
                    httpBufferPack.setStatus(HttpBufferPack.Status.HEADER_CRLFCR);
                } else {
                    if (Constants.isLf(oneByte)) {
                        throw new IllegalStateException("header_crlf \ub2e4\uc74c\uc5d0 lf \ub294 \uc62c \uc218 \uc5c6\ub2e4.");
                    }
                    httpBufferPack.addByte(oneByte);
                    httpBufferPack.setStatus(HttpBufferPack.Status.HEADER);
                }
            } else if (HttpBufferPack.Status.HEADER_CRLFCR == status) {
                if (!Constants.isLf(oneByte)) throw new IllegalStateException("header_crlfcr \ub2e4\uc74c\uc5d0\ub294 LF \ub9cc \uc62c \uc218 \uc788\ub2e4.");
                if (httpBufferPack.isContentLengthFlag()) {
                    httpBufferPack.setStatus(HttpBufferPack.Status.BODY);
                } else {
                    httpBufferPack.setStatus(HttpBufferPack.Status.TERMINUS);
                    status = HttpBufferPack.Status.TERMINUS;
                }
            } else if (HttpBufferPack.Status.BODY == status) {
                if (httpBufferPack.isContentLengthFlag()) {
                    httpBufferPack.addByte(oneByte);
                    httpBufferPack.increateReadBodySize();
                    if (httpBufferPack.getContentLength() <= httpBufferPack.getReadBodySize()) {
                        httpBufferPack.setBodyBytes(httpBufferPack.getPacked());
                        httpBufferPack.setStatus(HttpBufferPack.Status.TERMINUS);
                        status = HttpBufferPack.Status.TERMINUS;
                    }
                } else {
                    httpBufferPack.setStatus(HttpBufferPack.Status.TERMINUS);
                    status = HttpBufferPack.Status.TERMINUS;
                }
            }
            if (HttpBufferPack.Status.TERMINUS != status) continue;
            selectionKey.attach(null);
            MessageImpl message = new MessageImpl(this.server.getUnique(), 2, PhysicalConnectionManager.createPhysicalConnectionKey((SocketChannel)selectionKey.channel()), httpBufferPack, null);
            logger.log(Level.FINER, "http gather put msg id:{0}", message.getMessageId());
            try {
                this.messageQueue.put(message);
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "gather fail to put message", e);
            }
            if (this.readBuffer.remaining() <= 0) continue;
            httpBufferPack = neoHttpBufferPack = new HttpBufferPack();
            selectionKey.attach(httpBufferPack);
        }
        return readSize;
    }
}

