/*
 * Decompiled with CFR 0.152.
 */
package com.endofhope.neurasthenia.handler;

import com.endofhope.neurasthenia.Server;
import com.endofhope.neurasthenia.handler.AbstractHandler;
import com.endofhope.neurasthenia.handler.BypassWorker;
import com.endofhope.neurasthenia.handler.EchoWorker;
import com.endofhope.neurasthenia.handler.HttpWorker;
import com.endofhope.neurasthenia.handler.StompWorker;
import com.endofhope.neurasthenia.message.Message;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HandlerImpl
extends AbstractHandler {
    private static final Logger logger = Logger.getLogger("handler");

    public HandlerImpl(Server server, String id, String serviceType, BlockingQueue<Message> messageQueue) {
        super(server, id, serviceType, messageQueue);
    }

    @Override
    public Runnable createWorker(Message message) {
        Runnable worker = null;
        int messageType = message.getMessageType();
        switch (messageType) {
            case 1: {
                worker = new StompWorker(message, this.server);
                break;
            }
            case 2: {
                worker = new HttpWorker(message, this.server);
                break;
            }
            case 6: {
                worker = new BypassWorker(message, this.server);
                break;
            }
            case 7: {
                worker = new EchoWorker(message, this.server);
                break;
            }
            default: {
                logger.log(Level.SEVERE, "Invalid message type {0}", messageType);
            }
        }
        return worker;
    }
}

