/*
 * Decompiled with CFR 0.152.
 */
package com.endofhope.neurasthenia.webcontainer.servlet;

import com.endofhope.neurasthenia.Constants;
import com.endofhope.neurasthenia.message.Message;
import com.endofhope.neurasthenia.message.MessageImpl;
import com.endofhope.neurasthenia.webcontainer.servlet.HttpServletResponseImpl;
import com.endofhope.neurasthenia.webcontainer.servlet.MessageOutputStream;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;

public class HttpServletOutputStreamImpl
extends ServletOutputStream {
    private static final Logger logger = Logger.getLogger("servlet");
    private MessageOutputStream messageOutputStream = new MessageOutputStream();
    private HttpServletResponseImpl httpServletResponseImpl;
    private BlockingQueue<Message> messageQueue;
    private Message inMessage;
    private byte[] buffer;
    private int dataIndex = 0;
    private boolean chunkedFlag = false;
    private boolean endCloseFlag = false;
    private boolean intermediateFlush = false;
    public static final int BODY_BUFFER_SIZE = 8192;
    private int bufferSize = 8192;

    public HttpServletOutputStreamImpl(HttpServletResponseImpl httpServletResponseImpl, BlockingQueue<Message> messageQueue, Message inMessage) {
        this.httpServletResponseImpl = httpServletResponseImpl;
        this.messageQueue = messageQueue;
        this.inMessage = inMessage;
    }

    protected void postService() throws IOException {
        this.flush();
        boolean isCometSupport = this.httpServletResponseImpl.isCometSupport();
        if (this.chunkedFlag) {
            if (!isCometSupport) {
                this.sendCloseChunk();
                this.sendBlankFooter();
                this.internalFlush();
                this.intermediateFlush = true;
                this.dataIndex = 0;
            }
        } else {
            this.internalFlush();
            if (this.endCloseFlag) {
                this.internalClose();
            }
        }
        if (!isCometSupport) {
            // empty if block
        }
        int messageType = 2;
        if (!this.httpServletResponseImpl.isAllowKeepAlive()) {
            messageType = 3;
        }
        MessageImpl outMessage = new MessageImpl(this.inMessage.getMessageId(), messageType, this.inMessage.getPhysicalConnectionKey(), null, this.messageOutputStream.getWritten());
        try {
            this.messageQueue.put(outMessage);
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "messageQueue interrupted", e);
        }
    }

    public void flush() throws IOException {
        if (!this.intermediateFlush) {
            if (this.httpServletResponseImpl.isAllowKeepAlive()) {
                this.chunkedFlag = this.httpServletResponseImpl.getContentLength() <= 0;
            }
            if (this.httpServletResponseImpl.getHttpVersion() != 11) {
                this.chunkedFlag = false;
                this.endCloseFlag = true;
            }
            this.httpServletResponseImpl.setupHeader();
            this.internalSend(this.httpServletResponseImpl.getHeaderBytes());
        }
        this.sendBody(this.chunkedFlag);
        this.internalFlush();
        this.dataIndex = 0;
        if (!this.intermediateFlush) {
            this.intermediateFlush = true;
        }
    }

    private void sendCloseChunk() throws IOException {
        this.internalSend("0".getBytes());
        this.internalSend(Constants.CRLF);
    }

    private void sendBlankFooter() throws IOException {
        this.internalSend(Constants.CRLF);
    }

    protected void sendBody(boolean chunked) throws IOException {
        if (this.dataIndex > 0) {
            if (chunked) {
                String hexSize = String.format("%x", this.dataIndex);
                String hexSizeStr = hexSize + "\r\n";
                this.internalSend(hexSizeStr.getBytes());
                this.internalSend(this.buffer, 0, this.dataIndex);
                this.internalSend(Constants.CRLF);
            } else {
                this.internalSend(this.buffer, 0, this.dataIndex);
            }
        }
    }

    protected void internalFlush() throws IOException {
        this.messageOutputStream.flush();
    }

    protected void internalSend(byte[] bytes) throws IOException {
        this.messageOutputStream.write(bytes);
    }

    protected void internalSend(byte[] bytes, int offset, int length) throws IOException {
        this.messageOutputStream.write(bytes, offset, length);
    }

    public void internalClose() throws IOException {
        this.messageOutputStream.close();
    }

    public void close() throws IOException {
        this.internalFlush();
    }

    public void write(int b) throws IOException {
        this.initBuffer();
        int expectedEnd = this.dataIndex + 1;
        if (expectedEnd < this.bufferSize - 1) {
            ++this.dataIndex;
            this.buffer[this.dataIndex] = (byte)b;
        } else if (expectedEnd == this.bufferSize - 1) {
            ++this.dataIndex;
            this.buffer[this.dataIndex] = (byte)b;
            this.flush();
        } else {
            this.flush();
            ++this.dataIndex;
            this.buffer[this.dataIndex] = (byte)b;
        }
    }

    public void write(byte[] bytes) throws IOException {
        this.initBuffer();
        this.write(bytes, 0, bytes.length);
    }

    public void write(byte[] bytes, int offset, int length) throws IOException {
        this.initBuffer();
        int expectedIndex = this.dataIndex + length;
        if (expectedIndex < this.bufferSize - 1) {
            System.arraycopy(bytes, offset, this.buffer, this.dataIndex, length);
            this.dataIndex += length;
        } else {
            this.flush();
            int quotient = length / this.bufferSize;
            for (int i = 0; i < quotient; ++i) {
                System.arraycopy(bytes, offset + this.bufferSize * i, this.buffer, 0, this.bufferSize);
                this.dataIndex = this.bufferSize;
                this.flush();
            }
            int remains = length % this.bufferSize;
            System.arraycopy(bytes, offset + this.bufferSize * quotient, this.buffer, 0, remains);
            this.dataIndex = remains;
        }
    }

    public void setBodyBufferSize(int bodyBufferSize) {
        this.bufferSize = bodyBufferSize;
        this.initBuffer();
    }

    public int getBodyBufferSize() {
        return this.bufferSize;
    }

    private void initBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[this.bufferSize];
        }
    }
}

