/*
 * Decompiled with CFR 0.152.
 */
package com.endofhope.neurasthenia.webcontainer.servlet;

import com.endofhope.neurasthenia.LifeCycle;
import com.endofhope.neurasthenia.webcontainer.WebContextManager;
import com.endofhope.neurasthenia.webcontainer.servlet.ServletConfigImpl;
import com.endofhope.neurasthenia.webcontainer.servlet.ServletContextImpl;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ServletManager
implements LifeCycle {
    private static Logger logger = Logger.getLogger("servlet");
    private ServletContextImpl servletContextImpl;
    private URLClassLoader urlCL;
    private Map<String, ServletInfo> servletInfoMap;
    private Map<String, String> urlNameMap;
    private static final String RESOURCE_SERVLET = "__RESOURCE_SERVLET";
    private static final String JSP_SERVLET = "__JSP_SERVLET";
    private Map<String, Servlet> servletCache;
    private volatile boolean running;

    protected ServletManager(ServletContextImpl servletContextImpl) {
        this.servletContextImpl = servletContextImpl;
        this.servletCache = new HashMap<String, Servlet>();
        this.init();
    }

    protected String getServletName(String servletPath) {
        return this.urlNameMap.get(servletPath);
    }

    public String getServletClass(String servletName) {
        return this.servletInfoMap.get(servletName).getServletClass();
    }

    public Servlet getServlet(String servletPath) {
        String servletName = null;
        servletName = servletPath != null && (servletPath.endsWith(".jsp") || servletPath.endsWith(".JSP") || servletPath.endsWith(".jspx") || servletPath.endsWith(".JSPX")) ? JSP_SERVLET : this.getServletName(servletPath);
        if (servletName == null) {
            servletName = RESOURCE_SERVLET;
        }
        return this.servletCache.get(servletName);
    }

    protected Map<String, Servlet> getServletMap() {
        return this.servletCache;
    }

    private void init() {
        ArrayList<URL> urlList = new ArrayList<URL>();
        String webinfPath = this.servletContextImpl.getRealContextPath() + File.separator + "WEB-INF" + File.separator;
        File classes = new File(webinfPath + "classes");
        File lib = new File(webinfPath + "lib");
        WebContextManager webContextManager = this.servletContextImpl.getWebContextManager();
        String commonClasspath = webContextManager.getCommonClassPath();
        if (commonClasspath != null && commonClasspath.length() > 1) {
            StringTokenizer st = new StringTokenizer(commonClasspath.trim());
            while (st.hasMoreTokens()) {
                String oneCommonClasspath = st.nextToken();
                File commonClasspathFile = new File(oneCommonClasspath);
                if (!commonClasspathFile.exists()) continue;
                try {
                    urlList.add(commonClasspathFile.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    logger.log(Level.WARNING, "common classpath invalid", e);
                }
            }
        }
        if (classes.exists()) {
            try {
                urlList.add(classes.toURI().toURL());
            }
            catch (MalformedURLException e) {
                logger.log(Level.WARNING, "WEB-INF/classes invalid", e);
            }
        }
        if (lib.exists()) {
            try {
                File[] jarList;
                FileFilter ff = new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        boolean result = false;
                        if (pathname.getName().endsWith(".jar")) {
                            result = true;
                        }
                        return result;
                    }
                };
                for (File file : jarList = lib.listFiles(ff)) {
                    urlList.add(file.toURI().toURL());
                }
            }
            catch (MalformedURLException e) {
                logger.log(Level.WARNING, "WEB-INF/lib invalid", e);
            }
        }
        URL[] urls = new URL[urlList.size()];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = (URL)urlList.get(i);
        }
        this.urlCL = new URLClassLoader(urls);
        this.servletInfoMap = new HashMap<String, ServletInfo>();
        this.servletInfoMap.put(RESOURCE_SERVLET, new ServletInfo(RESOURCE_SERVLET, "com.endofhope.neurasthenia.webcontainer.servlet.ResourceServlet"));
        ServletInfo jspServletInfo = new ServletInfo(JSP_SERVLET, "org.apache.jasper.servlet.JspServlet");
        this.servletInfoMap.put(JSP_SERVLET, jspServletInfo);
        Thread.currentThread().setContextClassLoader(this.urlCL);
        SAXBuilder saxb = new SAXBuilder();
        try {
            Document doc = saxb.build(new File(webinfPath + "web.xml"));
            Element webAppElement = doc.getRootElement();
            List contextParamElementList = webAppElement.getChildren("context-param");
            for (Element contextParamElement : contextParamElementList) {
                this.servletContextImpl.getInitParamMap().put(contextParamElement.getChildTextTrim("param-name"), contextParamElement.getChildTextTrim("param-value"));
            }
            List servletElementList = webAppElement.getChildren("servlet");
            for (Element servletElement : servletElementList) {
                Element servletNameElement = servletElement.getChild("servlet-name");
                Element servletClassElement = servletElement.getChild("servlet-class");
                String servletName = servletNameElement.getTextTrim();
                String servletClass = servletClassElement.getTextTrim();
                ServletInfo servletInfo = new ServletInfo(servletName, servletClass);
                List initParamElementList = servletElement.getChildren("init-param");
                for (Element initParamElement : initParamElementList) {
                    servletInfo.getInitParamMap().put(initParamElement.getChildTextTrim("param-name"), initParamElement.getChildTextTrim("param-value"));
                }
                this.servletInfoMap.put(servletName, servletInfo);
            }
            this.urlNameMap = new HashMap<String, String>();
            List servletMappingList = webAppElement.getChildren("servlet-mapping");
            for (Element servletMappingElement : servletMappingList) {
                Element servletNameElement = servletMappingElement.getChild("servlet-name");
                Element urlPatternElement = servletMappingElement.getChild("url-pattern");
                String servletName = servletNameElement.getTextTrim();
                String urlPattern = urlPatternElement.getTextTrim();
                this.urlNameMap.put(urlPattern, servletName);
            }
        }
        catch (JDOMException e) {
            logger.log(Level.WARNING, "WEB-INF/web.xml is invalid", e);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "WEB-INF/web.xml is invalid", e);
        }
    }

    @Override
    public void boot() {
        this.running = true;
        Set<String> nameSet = this.servletInfoMap.keySet();
        Iterator<String> nameIter = nameSet.iterator();
        Class<?> servletClass = null;
        while (nameIter.hasNext()) {
            String servletName = nameIter.next();
            ServletConfigImpl servletConfigImpl = new ServletConfigImpl(servletName, this.servletContextImpl);
            ServletInfo servletInfo = this.servletInfoMap.get(servletName);
            String servletClassName = servletInfo.getServletClass();
            Map initParamMap = servletInfo.getInitParamMap();
            Set keySet = initParamMap.keySet();
            for (String key : keySet) {
                servletConfigImpl.addServletConfigInitParam(key, (String)initParamMap.get(key));
            }
            try {
                servletClass = this.urlCL.loadClass(servletClassName);
                Servlet cachedServlet = (Servlet)servletClass.newInstance();
                cachedServlet.init((ServletConfig)servletConfigImpl);
                this.servletCache.put(servletName, cachedServlet);
                logger.log(Level.FINE, "servelt {0}, {1} initialized", new Object[]{servletName, cachedServlet});
            }
            catch (ClassNotFoundException e) {
                logger.log(Level.WARNING, "servlet class [" + servletName + "] not found", e);
            }
            catch (InstantiationException e) {
                logger.log(Level.WARNING, "servlet class [" + servletName + "] is not valid servlet", e);
            }
            catch (IllegalAccessException e) {
                logger.log(Level.WARNING, "servlet class [" + servletName + "] can not accessible", e);
            }
            catch (ServletException e) {
                logger.log(Level.WARNING, "servlet [" + servletName + "] exception", e);
            }
        }
    }

    @Override
    public void down() {
        this.running = false;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    class ServletInfo {
        private String servletName;
        private String servletClass;
        private Map<String, String> initParamMap;

        private ServletInfo(String servletName, String servletClass) {
            this.servletName = servletName;
            this.servletClass = servletClass;
            this.initParamMap = new HashMap<String, String>();
        }

        protected String getServletName() {
            return this.servletName;
        }

        private String getServletClass() {
            return this.servletClass;
        }

        private Map<String, String> getInitParamMap() {
            return this.initParamMap;
        }
    }
}

