package test;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import test.*;

public class TestServlet extends HttpServlet{


	private static final long serialVersionUID = 1L;
	
	@SuppressWarnings("unchecked")
	private void doProcess(HttpServletRequest req, HttpServletResponse resp) throws IOException{
		PrintWriter out = resp.getWriter();
		out.write(getHead("TestServlet"));
		Enumeration nameEnum = req.getParameterNames();
		out.write("<h2>테스트 서블릿</h2>\n");
		out.write("<hr />");
		while(nameEnum.hasMoreElements()){
			String key = (String)nameEnum.nextElement();
			String value = req.getParameter(key);
			out.write(key);
			out.write(" : ");
			out.write(value.length());
			System.out.println(value.length());
			out.write("\n<br />");
			out.write(value);
			out.write("<hr />\n");
		}
		out.write("3 + 5 = "+Test.add(3, 5));
		out.write(getTail());
	}

	@Override
	protected void doGet(HttpServletRequest req, HttpServletResponse resp)
			throws ServletException, IOException {
		doProcess(req, resp);
	}
	
	@Override
	protected void doPost(HttpServletRequest req, HttpServletResponse resp)
			throws ServletException, IOException {
		doProcess(req, resp);
	}
	public static String getHead(String title){
		StringBuilder sb = new StringBuilder();
		sb.append("<html>\n  <head>\n    <title>")
		.append(title)
		.append("</title>\n")
		.append("    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n")
		.append("</head>\n  <body>\n");
		return sb.toString();
	}
	public static String getTail(){
		return "  </body>\r\n</html>";
	}
}

