/*
 * Decompiled with CFR 0.152.
 */
package com.endofhope.neurasthenia.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ConfigManager {
    private static final Logger logger = Logger.getLogger("config");
    private static ConfigManager configManager;
    private String homeDir;
    private SelectorManagerInfo selectorManagerInfo;
    private CheckConnectionInfo checkConnectionInfo;
    private ThreadPoolExecutorInfo threadPoolExecutorInfo;
    private List<MessageQueueInfo> messageQueueInfoList;
    private List<GatherInfo> gatherInfoList;
    private HandlerInfo handlerInfo;
    private List<ScatterInfo> scatterInfoList;
    private WebContainerInfo webContainerInfo;

    private ConfigManager() {
        this.readFromFile();
    }

    public static synchronized ConfigManager getInstance() {
        if (configManager == null) {
            configManager = new ConfigManager();
        }
        return configManager;
    }

    public String getHomeDir() {
        return this.homeDir;
    }

    public SelectorManagerInfo getSelectorManagerInfo() {
        return this.selectorManagerInfo;
    }

    public CheckConnectionInfo getCheckConnectionInfo() {
        return this.checkConnectionInfo;
    }

    public ThreadPoolExecutorInfo getThreadPoolExecutorInfo() {
        return this.threadPoolExecutorInfo;
    }

    public List<MessageQueueInfo> getMessageQueueInfoList() {
        return this.messageQueueInfoList;
    }

    public List<GatherInfo> getGatherInfoList() {
        return this.gatherInfoList;
    }

    public HandlerInfo getHandlerInfo() {
        return this.handlerInfo;
    }

    public List<ScatterInfo> getScatterInfoList() {
        return this.scatterInfoList;
    }

    public WebContainerInfo getWebContainerInfo() {
        return this.webContainerInfo;
    }

    private void readFromFile() {
        this.homeDir = System.getProperty("home.dir", ".");
        StringBuilder configSB = new StringBuilder(this.homeDir).append(File.separator).append("config").append(File.separator).append("config.xml");
        SAXBuilder saxb = new SAXBuilder();
        Document doc = null;
        try {
            doc = saxb.build(configSB.toString());
            Element rootElement = doc.getRootElement();
            Element selectorManagerElement = rootElement.getChild("selector-manager");
            this.selectorManagerInfo = new SelectorManagerInfo(Integer.parseInt(selectorManagerElement.getChildTextTrim("init-queue-size")));
            Element checkConnectionElement = rootElement.getChild("check-connection");
            if (checkConnectionElement != null) {
                this.checkConnectionInfo = new CheckConnectionInfo(Long.parseLong(checkConnectionElement.getChildTextTrim("init-delay")), Long.parseLong(checkConnectionElement.getChildTextTrim("delay")), Integer.parseInt(checkConnectionElement.getChildTextTrim("during")));
            }
            Element threadPoolExecutorElement = rootElement.getChild("thread-pool-executor");
            this.threadPoolExecutorInfo = new ThreadPoolExecutorInfo(Integer.parseInt(threadPoolExecutorElement.getChildTextTrim("core-pool-size")), Integer.parseInt(threadPoolExecutorElement.getChildTextTrim("maximum-pool-size")), Integer.parseInt(threadPoolExecutorElement.getChildTextTrim("keep-alive-time")), threadPoolExecutorElement.getChildTextTrim("queue-class"));
            this.messageQueueInfoList = new ArrayList<MessageQueueInfo>();
            Element messageQueueListElement = rootElement.getChild("message-queue-list");
            List messageQueueElementList = messageQueueListElement.getChildren("message-queue");
            for (Element messageQueueElement : messageQueueElementList) {
                this.messageQueueInfoList.add(new MessageQueueInfo(messageQueueElement.getChildTextTrim("id"), messageQueueElement.getChildTextTrim("queue-class")));
            }
            this.gatherInfoList = new ArrayList<GatherInfo>();
            Element gatherListElement = rootElement.getChild("gather-list");
            List gatherElementList = gatherListElement.getChildren("gather");
            for (Element gatherElement : gatherElementList) {
                this.gatherInfoList.add(new GatherInfo(gatherElement.getChildTextTrim("id"), gatherElement.getChildTextTrim("service-type"), Integer.parseInt(gatherElement.getChildTextTrim("port")), Integer.parseInt(gatherElement.getChildTextTrim("read-select-timeout")), Integer.parseInt(gatherElement.getChildTextTrim("read-buffer-size")), gatherElement.getChildTextTrim("ref-message-queue-id")));
            }
            Element handlerElement = rootElement.getChild("handler");
            this.handlerInfo = new HandlerInfo(handlerElement.getChildTextTrim("id"), handlerElement.getChildTextTrim("service-type"), handlerElement.getChildTextTrim("ref-message-queue-id"));
            this.scatterInfoList = new ArrayList<ScatterInfo>();
            Element scatterListElement = rootElement.getChild("scatter-list");
            List scatterElementList = scatterListElement.getChildren("scatter");
            for (Element scatterElement : scatterElementList) {
                this.scatterInfoList.add(new ScatterInfo(scatterElement.getChildTextTrim("id"), scatterElement.getChildTextTrim("service-type"), scatterElement.getChildTextTrim("ref-message-queue-id")));
            }
            Element webContainerElement = rootElement.getChild("web-container");
            if (webContainerElement != null) {
                this.webContainerInfo = new WebContainerInfo(webContainerElement.getChildTextTrim("id"), webContainerElement.getChildTextTrim("service-type"), webContainerElement.getChildTextTrim("represent-files"), webContainerElement.getChildTextTrim("context-root-directory"), webContainerElement.getChildTextTrim("common-class-path"), webContainerElement.getChildTextTrim("encoding"));
                Element contextListElement = webContainerElement.getChild("context-list");
                List contextElementList = contextListElement.getChildren("context");
                for (Element contextElement : contextElementList) {
                    ContextInfo contextInfo = new ContextInfo(contextElement.getChildTextTrim("context-name"), contextElement.getChildTextTrim("context-path"), contextElement.getChildTextTrim("context-directory"), Integer.parseInt(contextElement.getChildTextTrim("context-version")));
                    this.webContainerInfo.addContextInfo(contextInfo);
                }
            }
        }
        catch (JDOMException e) {
            logger.log(Level.SEVERE, "parse error", e);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "config.xml file error", e);
        }
    }

    public class ContextInfo {
        private String contextName;
        private String contextPath;
        private String contextDirectory;
        private int contextVersion;

        private ContextInfo(String contextName, String contextPath, String contextDirectory, int contextVersion) {
            this.contextName = contextName;
            this.contextPath = contextPath;
            this.contextDirectory = contextDirectory;
            this.contextVersion = contextVersion;
        }

        public String getContextName() {
            return this.contextName;
        }

        public String getContextPath() {
            return this.contextPath;
        }

        public String getContextDirectory() {
            return this.contextDirectory;
        }

        public int getContextVersion() {
            return this.contextVersion;
        }
    }

    public class WebContainerInfo {
        private List<String> representFileList;
        private String id;
        private String serviceType;
        private String representFiles;
        private String contextRootDirectory;
        private String commonClassPath;
        private String encoding;
        private List<ContextInfo> contextInfoList;

        private WebContainerInfo(String id, String serviceType, String representFiles, String contextRootDirectory, String commonClassPath, String encoding) {
            this.id = id;
            this.serviceType = serviceType;
            this.representFiles = representFiles;
            this.contextRootDirectory = contextRootDirectory;
            this.commonClassPath = commonClassPath;
            this.encoding = encoding;
            this.contextInfoList = new ArrayList<ContextInfo>();
            this.representFileList = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(representFiles);
            while (st.hasMoreTokens()) {
                this.representFileList.add(st.nextToken());
            }
        }

        private void addContextInfo(ContextInfo contextInfo) {
            this.contextInfoList.add(contextInfo);
        }

        public String getId() {
            return this.id;
        }

        public String getServiceType() {
            return this.serviceType;
        }

        public String getRepresentFiles() {
            return this.representFiles;
        }

        public String getContextRootDirectory() {
            return this.contextRootDirectory;
        }

        public String getCommonClassPath() {
            return this.commonClassPath;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public List<ContextInfo> getContextInfoList() {
            return this.contextInfoList;
        }

        public List<String> getRepresentFileList() {
            return this.representFileList;
        }
    }

    public class ScatterInfo {
        private String id;
        private String serviceType;
        private String messageQueueId;

        private ScatterInfo(String id, String serviceType, String messageQueueId) {
            this.id = id;
            this.serviceType = serviceType;
            this.messageQueueId = messageQueueId;
        }

        public String getId() {
            return this.id;
        }

        public String getServiceType() {
            return this.serviceType;
        }

        public String getMessageQueueId() {
            return this.messageQueueId;
        }
    }

    public class HandlerInfo {
        private String id;
        private String serviceType;
        private String messageQueueId;

        private HandlerInfo(String id, String serviceType, String messageQueueId) {
            this.id = id;
            this.serviceType = serviceType;
            this.messageQueueId = messageQueueId;
        }

        public String getId() {
            return this.id;
        }

        public String getServiceType() {
            return this.serviceType;
        }

        public String getMessageQueueId() {
            return this.messageQueueId;
        }
    }

    public class GatherInfo {
        private String id;
        private String serviceType;
        private int port;
        private int readSelectTimeout;
        private int readBufferSize;
        private String messageQueueId;

        private GatherInfo(String id, String serviceType, int port, int readSelectTimeout, int readBufferSize, String messageQueueId) {
            this.id = id;
            this.serviceType = serviceType;
            this.port = port;
            this.readSelectTimeout = readSelectTimeout;
            this.readBufferSize = readBufferSize;
            this.messageQueueId = messageQueueId;
        }

        public String getId() {
            return this.id;
        }

        public String getServiceType() {
            return this.serviceType;
        }

        public int getPort() {
            return this.port;
        }

        public int getReadSelectTimeout() {
            return this.readSelectTimeout;
        }

        public int getReadBufferSize() {
            return this.readBufferSize;
        }

        public String getMessageQueueId() {
            return this.messageQueueId;
        }
    }

    public class MessageQueueInfo {
        private String id;
        private String queueClass;

        private MessageQueueInfo(String id, String queueClass) {
            this.id = id;
            this.queueClass = queueClass;
        }

        public String getId() {
            return this.id;
        }

        public String getQueueClass() {
            return this.queueClass;
        }
    }

    public class ThreadPoolExecutorInfo {
        private int corePoolSize;
        private int maximumPoolSize;
        private int keepAliveTime;
        private String queueClass;

        private ThreadPoolExecutorInfo(int corePoolSize, int maximumPoolSize, int keepAliveTime, String queueClass) {
            this.corePoolSize = corePoolSize;
            this.maximumPoolSize = maximumPoolSize;
            this.keepAliveTime = keepAliveTime;
            this.queueClass = queueClass;
        }

        public int getCorePoolSize() {
            return this.corePoolSize;
        }

        public int getMaximumPoolSize() {
            return this.maximumPoolSize;
        }

        public int getKeepAliveTime() {
            return this.keepAliveTime;
        }

        public String getQueueClass() {
            return this.queueClass;
        }
    }

    public class CheckConnectionInfo {
        private long initDelay;
        private long delay;
        private int during;

        private CheckConnectionInfo(long initDelay, long delay, int during) {
            this.initDelay = initDelay;
            this.delay = delay;
            this.during = during;
        }

        public long getInitDelay() {
            return this.initDelay;
        }

        public long getDelay() {
            return this.delay;
        }

        public int getDuring() {
            return this.during;
        }
    }

    public class SelectorManagerInfo {
        private int initQueueSize;

        private SelectorManagerInfo(int initQueueSize) {
            this.initQueueSize = initQueueSize;
        }

        public int getInitQueueSize() {
            return this.initQueueSize;
        }
    }
}

