/*
 * Decompiled with CFR 0.152.
 */
package com.endofhope.neurasthenia.handler;

import com.endofhope.neurasthenia.Server;
import com.endofhope.neurasthenia.handler.Handler;
import com.endofhope.neurasthenia.message.Message;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractHandler
implements Handler {
    private static final Logger logger = Logger.getLogger("handler");
    protected Server server;
    protected String id;
    protected String serviceType;
    protected BlockingQueue<Message> messageQueue;
    private volatile boolean running;
    private HandlerThread handlerThread;

    public AbstractHandler(Server server, String id, String serviceType, BlockingQueue<Message> messageQueue) {
        this.server = server;
        this.id = id;
        this.serviceType = serviceType;
        this.messageQueue = messageQueue;
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getServiceType() {
        return this.serviceType;
    }

    @Override
    public BlockingQueue<Message> getMessageQueue() {
        return this.messageQueue;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void boot() {
        this.running = true;
        this.handlerThread = new HandlerThread();
        this.handlerThread.start();
        logger.log(Level.INFO, "handler {0} booted", this.id);
    }

    @Override
    public void down() {
        this.running = false;
        this.handlerThread.interrupt();
        this.messageQueue.clear();
        logger.log(Level.INFO, "handler {0} downed", this.id);
    }

    @Override
    public abstract Runnable createWorker(Message var1);

    class HandlerThread
    extends Thread {
        HandlerThread() {
        }

        @Override
        public void run() {
            ThreadPoolExecutor threadPoolExecutor = AbstractHandler.this.server.getThreadPoolExecutor();
            while (AbstractHandler.this.running) {
                try {
                    Message message = AbstractHandler.this.messageQueue.take();
                    threadPoolExecutor.execute(AbstractHandler.this.createWorker(message));
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "handler interrupted", e);
                }
            }
        }
    }
}

