/*
 * Decompiled with CFR 0.152.
 */
package com.endofhope.neurasthenia.webcontainer.servlet;

import com.endofhope.neurasthenia.message.Message;
import com.endofhope.neurasthenia.webcontainer.servlet.HttpServletOutputStreamImpl;
import com.endofhope.neurasthenia.webcontainer.servlet.PanzerResponse;
import com.endofhope.neurasthenia.webcontainer.servlet.SystemSender;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class HttpServletResponseImpl
implements HttpServletResponse {
    private HttpServletOutputStreamImpl httpServletOutputStreamImpl;
    private PanzerResponse panzerResponse;
    private PrintWriter printWriter;
    private boolean postServiceFlag;
    private boolean cometSupport;
    private boolean allowKeepAlive;

    public HttpServletResponseImpl(PanzerResponse panzerResponse, BlockingQueue<Message> messageQueue, Message inMessage) {
        this.panzerResponse = panzerResponse;
        this.httpServletOutputStreamImpl = new HttpServletOutputStreamImpl(this, messageQueue, inMessage);
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)((Object)this.httpServletOutputStreamImpl), panzerResponse.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            osw = new OutputStreamWriter((OutputStream)((Object)this.httpServletOutputStreamImpl));
        }
        this.printWriter = new PrintWriter(osw);
        this.setStatus(200, "OK");
        this.allowKeepAlive = panzerResponse.isAllowKeepAlive();
    }

    public void postService() throws IOException {
        if (!this.postServiceFlag) {
            this.postServiceFlag = true;
            this.printWriter.flush();
            this.httpServletOutputStreamImpl.postService();
        }
    }

    public void setCometSupport(boolean cometSupport) {
        this.cometSupport = cometSupport;
    }

    public boolean isCometSupport() {
        return this.cometSupport;
    }

    protected void setupHeader() {
        String characterEncoding = this.panzerResponse.getCharacterEncoding();
        Map<String, List<String>> headerMap = this.panzerResponse.getHeaderMap();
        List<String> contentTypeList = headerMap.get("Content-Type");
        if (contentTypeList == null || contentTypeList.size() < 1) {
            String contentType = this.getContentType();
            if (contentType == null) {
                contentType = "text/html;charset=" + characterEncoding;
            } else {
                int charsetIndex = contentType.indexOf(";charset=");
                if (charsetIndex < 0 && contentType.contains("htm")) {
                    contentType = contentType.concat(";charset=").concat(characterEncoding);
                }
            }
            contentTypeList = new ArrayList<String>(1);
            contentTypeList.add(contentType);
            this.setContentType(contentType);
        }
        headerMap.put("Content-Type", contentTypeList);
        int contentLength = this.panzerResponse.getContentLength();
        if (contentLength > 0) {
            ArrayList<String> contentLengthList = new ArrayList<String>(1);
            contentLengthList.add("" + contentLength);
            headerMap.put("Content-Length", contentLengthList);
            this.setContentLength(contentLength);
        }
        if (this.allowKeepAlive && contentLength <= 0) {
            ArrayList<String> transferCodingList = new ArrayList<String>(1);
            transferCodingList.add("chunked");
            headerMap.put("Transfer-Encoding", transferCodingList);
            headerMap.remove("Content-Length");
        }
        if (this.panzerResponse.getHttpVersion() == 11) {
            ArrayList<String> connectionList = new ArrayList<String>(1);
            connectionList.add("Keep-Alive");
            headerMap.put("Connection", connectionList);
        }
    }

    protected byte[] getHeaderBytes() {
        StringBuilder sb = new StringBuilder();
        int httpVersion = this.panzerResponse.getHttpVersion();
        String httpVersionString = null;
        httpVersionString = httpVersion == 11 ? "HTTP/1.1" : (httpVersion == 10 ? "HTTP/1.0" : "HTTP/0.9");
        sb.append(httpVersionString).append(" ").append(this.panzerResponse.getStatusCode()).append(" ").append(this.panzerResponse.getStatusMessage()).append("\r\n");
        Map<String, List<String>> headerMap = this.panzerResponse.getHeaderMap();
        Set<String> headerKeySet = headerMap.keySet();
        for (String headerName : headerKeySet) {
            StringBuilder headerSB = new StringBuilder();
            headerSB.append(headerName).append(": ");
            List<String> valueList = headerMap.get(headerName);
            for (String oneValue : valueList) {
                headerSB.append(oneValue).append(",");
            }
            sb.append(headerSB.substring(0, headerSB.length() - 1)).append("\r\n");
        }
        sb.append("\r\n");
        return sb.toString().getBytes();
    }

    public boolean isAllowKeepAlive() {
        return this.allowKeepAlive;
    }

    public void setContentLength(int len) {
        this.panzerResponse.setContentLength(len);
    }

    public int getContentLength() {
        return this.panzerResponse.getContentLength();
    }

    public void setCharacterEncoding(String charset) {
        this.panzerResponse.setCharacterEncoding(charset);
    }

    public String getCharacterEncoding() {
        return this.panzerResponse.getCharacterEncoding();
    }

    public void setContentType(String type) {
        this.panzerResponse.setContentType(type);
    }

    public String getContentType() {
        return this.panzerResponse.getContentType();
    }

    public int getHttpVersion() {
        return this.panzerResponse.getHttpVersion();
    }

    public void setBufferSize(int size) {
        this.httpServletOutputStreamImpl.setBodyBufferSize(size);
    }

    public int getBufferSize() {
        return this.httpServletOutputStreamImpl.getBodyBufferSize();
    }

    public void flushBuffer() throws IOException {
        this.httpServletOutputStreamImpl.flush();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.httpServletOutputStreamImpl;
    }

    public PrintWriter getWriter() throws IOException {
        return this.printWriter;
    }

    public void addDateHeader(String name, long date) {
        Date oneDate = new Date(date);
        SimpleDateFormat sdf = new SimpleDateFormat();
        this.panzerResponse.addHeader(name, sdf.format(oneDate));
    }

    public void addHeader(String name, String value) {
        this.panzerResponse.addHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        this.panzerResponse.addHeader(name, "" + value);
    }

    public boolean containsHeader(String name) {
        Set<String> keySet = this.panzerResponse.getHeaderMap().keySet();
        return keySet.contains(name);
    }

    public void setDateHeader(String name, long date) {
        Date oneDate = new Date(date);
        SimpleDateFormat sdf = new SimpleDateFormat();
        this.panzerResponse.setHeader(name, sdf.format(oneDate));
    }

    public void setHeader(String name, String value) {
        this.panzerResponse.setHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.panzerResponse.setHeader(name, "" + value);
    }

    public void setStatus(int sc) {
        this.panzerResponse.setStatusCode(sc);
    }

    public void setStatus(int sc, String sm) {
        this.panzerResponse.setStatusCode(sc);
        this.panzerResponse.setStatusMessage(sm);
    }

    public void sendError(int sc, String msg) throws IOException {
        SystemSender.sendError(this, sc, msg);
    }

    public void sendError(int sc) throws IOException {
        SystemSender.sendError(this, sc, "ERROR\n");
    }

    public void addCookie(Cookie cookie) {
    }

    public String encodeRedirectURL(String url) {
        return null;
    }

    public String encodeRedirectUrl(String url) {
        return null;
    }

    public String encodeURL(String url) {
        return null;
    }

    public String encodeUrl(String url) {
        return null;
    }

    public void sendRedirect(String location) throws IOException {
    }

    public Locale getLocale() {
        return null;
    }

    public boolean isCommitted() {
        return false;
    }

    public void reset() {
    }

    public void resetBuffer() {
    }

    public void setLocale(Locale loc) {
    }
}

