/*
 * Decompiled with CFR 0.152.
 */
package info.jinwoomin.nevernaver;

import info.jinwoomin.downloader.DownloaderUtils;
import info.jinwoomin.downloader.IDownloadable;
import info.jinwoomin.downloader.IDownloader;
import info.jinwoomin.downloader.html.IHtmlDownloadable;
import info.jinwoomin.downloader.html.IHtmlDownloader;
import info.jinwoomin.downloader.html.IHtmlLineHandler;
import info.jinwoomin.log.AbstractLogabble;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NaverBlogPage
extends AbstractLogabble
implements IDownloadable,
IHtmlDownloadable,
IHtmlLineHandler {
    private String outputFolder;
    private String userId;
    private int category;
    private int pageIndex;
    private IDownloader downloader;
    private IHtmlDownloader htmlDownloader;
    static final int STATE_BEFORE = 0;
    static final int STATE_CONTENT = 1;
    static final int STATE_AFTER = 2;
    private int state;
    private StringBuffer lineBuffer;

    public void setOutputFolder(String outputFolder) {
        this.outputFolder = outputFolder;
    }

    public void setCategory(int category) {
        this.category = category;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public void backup() {
        File file = new File(this.outputFolder);
        file.mkdir();
        this.lineBuffer = new StringBuffer();
        try {
            URL url = new URL("http://blog.naver.com/post/postList.jsp?blogId=" + this.userId + "&categoryNo=" + this.category + "&cpage=" + this.pageIndex);
            this.htmlDownloader.setLogger(this.logger);
            this.htmlDownloader.setUrl(url);
            this.downloader.setLogger(this.logger);
            this.downloader.removeAllFiles();
            this.logger.info("page.url=[" + url + "]");
            this.state = 0;
            this.htmlDownloader.download();
            this.downloader.download();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.logger.debug("linebuffer=[" + this.lineBuffer.toString() + "]");
        try {
            String htmlFile = this.outputFolder + "/" + this.pageIndex + ".html";
            this.logger.info("html.file=[" + htmlFile + "]");
            FileOutputStream fos = new FileOutputStream(htmlFile);
            PrintWriter pw = new PrintWriter(fos);
            pw.println(this.lineBuffer.toString());
            pw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void setDownloader(IDownloader downloader) {
        this.downloader = downloader;
    }

    public void setHtmlDownloader(IHtmlDownloader htmlDownloader) {
        this.htmlDownloader = htmlDownloader;
    }

    public boolean handle(String line) {
        if (this.state == 0) {
            if (line.equals("\t<td style='padding: 15 10 35 10' colspan='2' width='572' class='view'>")) {
                this.state = 1;
            }
        } else if (this.state == 1) {
            if (line.equals("\t</td>")) {
                this.state = 2;
            } else {
                Pattern p = Pattern.compile("<IMG id=[\\x00-\\xff]* style=\"[\\x00-\\xff]*\" onclick=[']?popview\\([\"]?[\\x00-\\xff]*[\"]?\\)[']?[ height=[0-9]* | ]+src=\"([\\x00-\\xff]*)\"[ width=[0-9]* | ]+onload='setTimeout\\(\"resizeImage\\([0-9]*\\)\",[0-9]*\\)'[ align=[a-z]*]*>");
                Matcher m = p.matcher(line);
                while (m.find()) {
                    this.logger.debug("found=[" + m.group(1) + "]");
                    try {
                        URL url = new URL(m.group(1));
                        this.downloader.addFile(url, this.outputFolder + "/" + DownloaderUtils.pickFilename((String)m.group(1)));
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                    line = line.replace(m.group(1), DownloaderUtils.pickFilename((String)m.group(1)));
                }
                this.lineBuffer.append(line + "\n");
            }
        }
        return false;
    }
}

